local function IsDST()
	return TheSim:GetGameID() == "DST"
end

local function IsClient()
	return IsDST() and not TheWorld.ismastersim
end

local function DYCGetPlayer()
	if IsDST() then
		return ThePlayer
	else
		return GetPlayer()
	end
end

local function IsDistOK (other)
	if IsDST() then
		return true
	end
	local player=DYCGetPlayer()
	if player==other then
		return true
	end
	if not player then
		return false
	end
	local dis = player:GetPosition():Dist(other:GetPosition())
	return dis<=TUNING.DYC_HEALTHBAR_MAXDIST
end

local DYC_ENT_SIZE_LIST = {
	{prefab="krampus",width=1,height=3.75,},
	{prefab="nightmarebeak",width=1,height=4.5,},
	{prefab="spiderqueen",width=2,height=4.5,},
	{prefab="warg",width=1.7,height=5,},
	{prefab="pumpkin_lantern",width=0.7,height=1.5,},
	{prefab="jellyfish_planted",width=0.7,height=1.5,},
	
	{tag="snake",width=0.9,height=1.7,},
	{tag="eyeturret",width=1,height=4.5,},
	{tag="primeape",width=0.85,height=1.5,},
	{tag="monkey",width=0.85,height=1.5,},
	{tag="ox",width=1.5,height=3.75,},
	{tag="beefalo",width=1.5,height=3.75,},
	{tag="kraken",width=2,height=5.5,},
	{tag="nightmarecreature",width=1.25,height=3.5,},
	{tag="bishop",width=1,height=4,},
	{tag="rook",width=1.25,height=4,},
	{tag="knight",width=1,height=3,},
	{tag="bat",width=0.85,height=3,},
	{tag="minotaur",width=1.75,height=4.5,},
	{tag="packim",width=0.9,height=3.75,},
	{tag="stungray",width=0.9,height=3.75,},
	{tag="ghost",width=0.9,height=3.75,},
	{tag="tallbird",width=1.25,height=5,},
	{tag="chester",width=0.85,height=1.5,},
	{tag="hutch",width=0.85,height=1.5,},
	{tag="wall",width=0.5,height=1.5,},
	{tag="largecreature",width=2,height=7,},
	{tag="insect",width=0.5,height=1.6,},
	{tag="smallcreature",width=0.85,height=1.5,},
}


local assets=
{
	
}

local prefabs =
{
	
}

local function Clamp01 (num)
	if num<0 then
		num=0
	elseif num>1 then
		num=1
	end
	return num
end

local function GetHpText(hpCurrent,hpMax)
	local c1=TUNING.DYC_HEALTHBAR_C1
	local c2=TUNING.DYC_HEALTHBAR_C2
	local cnum=TUNING.DYC_HEALTHBAR_CNUM
	local str=""
	if TUNING.DYC_HEALTHBAR_POSITION==0 then
		str="  \n  \n  \n  \n"
	end
	local hpp=hpCurrent/hpMax
	for i=1,cnum do
		if hpp==0 or (i~=1 and i*1.0/cnum>hpp) then
			str=str..c1
		else
			str=str..c2
		end
	end
	return str
end

local function GetEntHBSize(ent)
	if not ent then 
		return 1
	end
	for k,v in pairs(DYC_ENT_SIZE_LIST) do
		if v.width and (ent.prefab==v.prefab or (v.tag and ent:HasTag(v.tag))) then
			return v.width
		end
	end
	return 1
end

local function GetEntHBHeight(ent)
	if not ent then 
		return 2.2
	end
	for k,v in pairs(DYC_ENT_SIZE_LIST) do
		if v.height and (ent.prefab==v.prefab or (v.tag and ent:HasTag(v.tag))) then
			return v.height
		end
	end
	return 2.2
end





local function InitHB (inst)
	if not inst.dychbowner then
		inst.dychbowner=inst.entity:GetParent()
		inst.dychbowner.dychealthbar=inst
	end
	
	if IsDST() or TUNING.DYC_HEALTHBAR_POSITION==0 then
		inst.dychbtext=inst.dychbowner:SpawnChild("dyc_healthbarchild") 
	else
		inst.dychbtext=inst:SpawnChild("dyc_healthbarchild") 
	end
	inst.Label:Enable(false)
	inst.dychbtext.Label:Enable(false)
	
	inst.SetHBHeight=function (inst,height)
		if TUNING.DYC_HEALTHBAR_POSITION==0 then
			return
		end
		if IsDST() then
			inst.Label:SetWorldOffset(0, height, 0)
			inst.dychbtext.Label:SetWorldOffset(0, height, 0)
		else
			inst.dychbheight=height*1.5
		end
	end
	inst:SetHBHeight(GetEntHBHeight(inst.dychbowner))
	
	inst.SetHBSize=function (inst,size)
		local hbsize=math.max(1,(13-TUNING.DYC_HEALTHBAR_CNUM)/5)*15*size
		inst.Label:SetFontSize(hbsize)
		inst.dychbtext.Label:SetFontSize(28*size)
	end
	inst:SetHBSize(GetEntHBSize(inst.dychbowner))
	inst.dycHbStarted=true
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	-- inst.entity:AddAnimState()
	-- inst.AnimState:SetLightOverride(1)
	
	inst:AddTag("FX")
	
	local label = inst.entity:AddLabel()
	label:SetFont(NUMBERFONT)
	-- label:SetFont(TALKINGFONT)
	label:SetFontSize(28)
	-- if IsDST() then
		-- label:SetWorldOffset(0, 2.2, 0)
	-- end
	label:SetColour(1, 1, 1)
	-- label:SetText("dyc_healthbar")
	label:SetText(" ")
	label:Enable(true)

	inst.persists = false
	
	inst.InitHB=InitHB

	return inst
end

local function dychbfn()
	local inst = fn()
	
	inst.OnRemoveEntity=function(inst)
		if inst.dychbowner then
			inst.dychbowner.dychealthbar=nil
		end
	end
	
	if IsDST() then
		inst.entity:AddNetwork()
	end

	inst.Label:SetFontSize(15)
	
	if IsDST() then
		inst.dychpold=0
	
		inst.dychp=-1
		inst.dychp_net = net_float(inst.GUID, "dyc_healthbar.hp", "dychpdirty")
		inst:ListenForEvent("dychpdirty", function(inst)
			if TUNING.DYC_HEALTHBAR_DDON and IsDistOK(inst) and inst.dychp>=0 then
				-- print("DamageDisplay!")
				if inst.dychbowner then
					local dd=SpawnPrefab("dyc_damagedisplay")
					dd:DamageDisplay(inst.dychbowner)
				end
			end
			inst.dychpold=inst.dychp
			inst.dychp=inst.dychp_net:value()
			
			if inst.dychpold<0 then
				inst.dychpold=inst.dychp
			end
			-- print("dychpdirty, dychp:"..inst.dychp.." dychpold:"..inst.dychpold)
		end)
		
		inst.dychpmax=0
		inst.dychpmax_net = net_float(inst.GUID, "dyc_healthbar.hpmax", "dychpmaxdirty")
		inst:ListenForEvent("dychpmaxdirty", function(inst)
			inst.dychpmax=inst.dychpmax_net:value()
		end)
		
		-- inst.dychbowner=nil
		-- inst.dychbowner_net=net_entity(inst.GUID, "dyc_healthbar.owner", "dychbownerdirty")
		-- inst:ListenForEvent("dychbownerdirty", function(inst)
			-- inst.dychbowner=inst.dychbowner_net:value()
		-- end)
		
		-- inst.dychbattacker=nil
		-- inst.dychbattacker_net=net_entity(inst.GUID, "dyc_healthbar.owner", "dychbattackerdirty")
		-- inst:ListenForEvent("dychbattackerdirty", function(inst)
			-- inst.dychbattacker=inst.dychbattacker_net:value()
		-- end)
	end
	
	local hpCurrent=-1
	local hpMax=-1
	local timer=0
	inst.dycHbStarted=false
	
	inst.OnRemoveEntity=function(inst)
		if inst.dychbowner then
			inst.dychbowner.dychealthbar=nil
		end
		if inst.dychbtext then
			inst.dychbtext:Remove()
		end
		if inst.dychbtask then
			inst.dychbtask:Cancel()
		end
	end
	
	function inst:DYCHBSetTimer(t)
		timer=t
	end
	
	inst.dychbtask=inst:DoPeriodicTask(FRAMES, function()
	
		if not inst.dycHbStarted then return end
		local owner=inst.dychbowner
		if not owner then return end
		
		local attacker=inst.dychbattacker
		local health=nil
		
		if not IsClient() then
			health=owner.components.health
		else
			health=owner.replica.health
		end
		
		
		if not owner:IsValid() or not IsDistOK(owner) or (IsClient() and not owner:HasTag("player")) or health==nil or health:IsDead() or timer>=TUNING.DYC_HEALTHBAR_DURATION then
			if not IsClient() then
				inst:Remove()
				return
			end
		end
		
		
		
		local hpCurrentNew=0
		local hpMaxNew=0
		if not IsDST() then
			hpCurrentNew=health.currenthealth
			hpMaxNew=health.maxhealth
		else
			hpCurrentNew=inst.dychp
			hpMaxNew=inst.dychpmax
		end
		
		
		if health~=nil and (hpCurrent ~= hpCurrentNew or hpMax ~= hpMaxNew) then
			hpCurrent = hpCurrentNew
			hpMax = hpMaxNew
			inst.Label:Enable(true)
			inst.Label:SetText(GetHpText(hpCurrent,hpMax))
			inst.dychbtext.Label:Enable(true)
			if TUNING.DYC_HEALTHBAR_POSITION~=0 then
				inst.dychbtext.Label:SetText(string.format("%d/%d\n   ",hpCurrent,hpMax))
			else
				inst.dychbtext.Label:SetText(string.format("  \n  \n%d/%d\n   ",hpCurrent,hpMax))
			end
			local hpp=hpCurrent/hpMax
			inst.Label:SetColour(Clamp01((1-hpp)*2),Clamp01(hpp*2),0)
		end
		
		local shouldFade=true
		local combat=nil
		if not IsClient() then
			combat=owner.components.combat
		else
			combat=owner.replica.combat
		end
		
		if combat and combat.target then
			shouldFade=false
		else
			if attacker and attacker:IsValid() then
				
				local attackerHealth=nil
				local attackerCombat=nil
				if not IsClient() then
					attackerHealth=attacker.components.health
					attackerCombat=attacker.components.combat
				else
					attackerHealth=attacker.replica.health
					attackerCombat=attacker.replica.combat
				end
				if attackerHealth and not attackerHealth:IsDead() and attackerCombat and attackerCombat.target==owner then
					shouldFade=false
				end
			end
		end
		
		
		
		if shouldFade then
			timer = timer + FRAMES
		else
			timer = 0
		end
		-- if owner.prefab=="bearger" then print(timer) end
		
		if IsDST() or TUNING.DYC_HEALTHBAR_POSITION==0 then
		else
			local pos=owner:GetPosition()
			pos.y = inst.dychbheight or 0
			inst.Transform:SetPosition(pos:Get())
		end
	end)
	
	if IsClient() then
		inst:DoTaskInTime(0,function() 
			inst:InitHB()
		end)
	end
	
	return inst
end


local function DamageDisplay (inst,target)
	if target.dycddcd==true then
		inst:Remove()
		return
	end
	target.dycddcd=true
	
	inst.Transform:SetPosition( ( target:GetPosition() + Vector3(0,GetEntHBHeight(target)*0.65,0) ):Get() )
	local oldhealth=(not IsDST() and target.components.health.currenthealth) or (target.dychealthbar and target.dychealthbar.dychp) or 0
	-- print("oldhealth:"..oldhealth)
	local ison=false
	local angle=math.random()*360
	local t=TUNING.DYC_HEALTHBAR_DDDURATION/2
	local d=1
	local h=2
	local g=2*h/t/t
	local timer=0
	local vh=d/t
	local vv=math.sqrt(2*g*h)
	local duration=t*2
	local changecolor=false
	-- if IsDST() then
		-- inst.Label:SetWorldOffset(0, GetEntHBHeight(target)*0.65, 0)
	-- end
	
	inst.dycddtask=inst:DoPeriodicTask(FRAMES,function()
		timer=timer+FRAMES
		if ison==false then
			target.dycddcd=false
			local newhealth=(not IsDST() and target.components.health.currenthealth) or (target.dychealthbar and target.dychealthbar.dychp) or 0
			-- print("newhealth:"..newhealth)
			local amount=newhealth-oldhealth
			local absamount=math.abs(amount)
			if absamount<TUNING.DYC_HEALTHBAR_DDTHRESHOLD then
				inst.dycddtask:Cancel()
				inst:Remove()
				return
			else
				-- print("health change:"..amount)
				ison=true
				inst.Label:Enable(true)
				local sign=""
				if amount>0 then
					inst.Label:SetColour(0, 1, 0)
					sign="+"
				else
					inst.Label:SetColour(1, 0, 0)
					changecolor=true
				end
				
				if absamount<1 then
					inst.Label:SetText(sign..string.format("%.2f",amount))
				elseif absamount<100 then
					inst.Label:SetText(sign..string.format("%.1f",amount))
				else
					inst.Label:SetText(sign..string.format("%d",amount))
				end
			end
		end
		
		local pos=inst:GetPosition()
		local move=Vector3(vh*FRAMES*math.cos(angle),vv*FRAMES,vh*FRAMES*math.sin(angle))
		inst.Transform:SetPosition(pos.x+move.x, pos.y+move.y, pos.z+move.z)
		vv=vv-g*FRAMES
		local fontsize=(1-math.abs(timer/t-1))*(TUNING.DYC_HEALTHBAR_DDSIZE2-TUNING.DYC_HEALTHBAR_DDSIZE1)+TUNING.DYC_HEALTHBAR_DDSIZE1
		inst.Label:SetFontSize(fontsize)
		if changecolor then
			local greenandblue=1-Clamp01(timer/t-0.5)
			inst.Label:SetColour(1, greenandblue, greenandblue)
		end
		if timer>=duration then
			inst.dycddtask:Cancel()
			inst:Remove()
		end
	end)
end

local function dycddfn ()
	local inst =  fn()
	inst.Label:SetFontSize(TUNING.DYC_HEALTHBAR_DDSIZE1)
	inst.Label:Enable(false)
	inst.InitHB=nil
	inst.DamageDisplay=DamageDisplay
	return inst
end


return 
Prefab( "common/dyc_damagedisplay", dycddfn, assets, prefabs),
Prefab( "common/dyc_healthbarchild", fn, assets, prefabs),
Prefab( "common/dyc_healthbar", dychbfn, assets, prefabs)


