ProximityInventoryRadius = nil
HaulingCapacity = nil
AttackDurability = nil
BlockDurability = nil
ThrowDurability = nil
MaxActiveMutations = nil
PlayerDamageMultiplier = nil
EnemyDamageMultiplier = nil
PerfectBlockWindow = nil
DewCollectorAmountPerHour = nil
PlankStorageCapacity = nil
LogStorageCapacity = nil
DropAmountMultiplier = nil
DropChanceMin = nil
DeconstructPercentage = nil
SmallStorageCapacity = nil
BigStorageCapacity = nil
FridgeStorageCapacity = nil
ProductionSpeedMultiplier = nil
ProductionItems = nil
PlayerSprintSpeedMultiplier = nil
PlayerSwimSpeedMultiplier = nil
DisableFOG = false
DisableDOF = false
DayLengthMultiplier = nil
NightLengthMultiplier = nil
EnableBuildHotKey = nil
EnableBuildHotKeyModifier = nil
RestoreMaterialsHotKey = nil
RestoreMaterialsModifier = nil
AOEPickupRadius = nil
AOEPickupKey = nil
AOEPickupModifierKey = nil
AOEPickupModeKey = nil
AOEPickupModeModifierKey = nil
AOEPickupMode = 1

dofile([[Mods\QoLMod\options.txt]])

local LocalPlayerCharacter = nil
local playerEffects = {}
local materials = {}
local updatingMaterials = false
local nodeUpdated = {}
local initEvent = false
local calendarComponent = nil
local gameToRealTimeRatio = 30

local cache = {}
cache.objects = {}
cache.names = {
  ["engine"] = {"Engine", false},
  ["uiStatics"] = {"/Script/Maine.Default__UserInterfaceStatics", true},
  ["gameStatics"] = {"/Script/Maine.Default__SurvivalGameplayStatics", true},
  ["kismet"] = {"/Script/Engine.Default__KismetSystemLibrary", true},
  ["icon"] = {"/Game/UI/Images/T_UI_Build.T_UI_Build", true}
}

cache.mt = {}
cache.mt.__index = function (obj, key)
  local newObj = obj.objects[key]
  if newObj == nil or not newObj:IsValid() then
    local className, isStatic = table.unpack(obj.names[key])
    if isStatic then
      newObj = StaticFindObject(className)
    else
      newObj = FindFirstOf(className)
    end
    if not newObj:IsValid() then
      newObj = nil
    end
    obj.objects[key] = newObj
  end
  return newObj
end

setmetatable(cache, cache.mt)

local function starts_with(str, start)
   return string.sub(str, #start) == start
end

local function printf(...)
  print(string.format(...))
end

local function ShowMessage(message)
  local engine = cache.engine
  local uiStatics = cache.uiStatics
  local icon = cache.icon
  if uiStatics and icon then
    local ui = uiStatics:GetGameUI(engine.GameViewport)
    ui:PostGenericMessage(message, icon)
  end
end

local function UpdatePlayer(player)
  if not player:IsValid() then
    print("Player instance not found\n")
    return
  end

  if ProximityInventoryRadius ~= nil then
    player.ProximityInventoryComponent.Radius = ProximityInventoryRadius
  end

  if HaulingCapacity ~= nil then
    player.HaulingComponent.Capacity = HaulingCapacity
  end

  if PerfectBlockWindow~= nil then
    player.BlockComponent.PerfectBlockWindow = PerfectBlockWindow
  end

  if PlayerSprintSpeedMultiplier ~= nil then
	  player.CharMovementComponent.MaxSprintSpeed = player.CharMovementComponent.MaxSprintSpeed*PlayerSprintSpeedMultiplier
  end
  
  if PlayerSwimSpeedMultiplier ~= nil then
	  player.CharMovementComponent.MaxSwimSprintSpeed = player.CharMovementComponent.MaxSwimSprintSpeed*PlayerSwimSpeedMultiplier
  end
end

local function UpdateGlobalItemData(globalItemData)
  if not globalItemData:IsValid() then
    print("GlobalItemData instance not found\n")
    return
  end
  
  if AttackDurability ~= nil then
    globalItemData.AttackDurability = AttackDurability
  end

  if BlockDurability ~= nil then
    globalItemData.BlockDurability = BlockDurability
  end

  if ThrowDurability ~= nil then
    globalItemData.ThrowDurability = ThrowDurability
  end

  if ProductionSpeedMultiplier ~= nil then
    globalItemData.ProcessingData:ForEach(function(idx)
      local itemData = globalItemData.ProcessingData[idx]
      local itemDataTag = itemData.ProcessingTag.TagName:ToString()
      if itemDataTag == "ItemProcessing.Cooking" or itemDataTag == "ItemProcessing.Drying" then
        itemData.ProcessingTime = itemData.ProcessingTime / math.max(0.01, ProductionSpeedMultiplier)
      end
    end)
  end
end

local function SetDayTimeMultiplier(isDayTime)
  if calendarComponent == nil or not calendarComponent:IsValid() then
    return
  end
  local multiplier = 1
  if DayLengthMultiplier ~= nil and isDayTime then
    multiplier = math.abs(DayLengthMultiplier)^((DayLengthMultiplier>0 and 1 or 0) - (DayLengthMultiplier<0 and 1 or 0))
  elseif NightLengthMultiplier ~= nil and not isDayTime then
    multiplier = math.abs(NightLengthMultiplier)^((NightLengthMultiplier>0 and 1 or 0) - (NightLengthMultiplier<0 and 1 or 0))
  end
  calendarComponent.GameToRealTimeRatio = gameToRealTimeRatio / multiplier
end

local function UpdateGameState(gameState)
  if not gameState:IsValid() then
    print("GameState instance not found\n")
    return
  end

  calendarComponent = gameState.CalendarComponent
  if DayLengthMultiplier ~= nil or NightLengthMultiplier ~= nil then
    SetDayTimeMultiplier(calendarComponent:IsDayTime())
  end
end

local function UpdateModeSettings(gameModeManager)
  if not gameModeManager:IsValid() then
    print("GameModeManager instance not found\n")
    return
  end

  local modeSettings = gameModeManager:GetGameModeSettings()
  local CDO = modeSettings:GetClass():GetCDO()
  if CDO:IsValid() then
    if PlayerDamageMultiplier ~= nil then
      CDO.PlayerDamageMultiplier = PlayerDamageMultiplier
    end

    if EnemyDamageMultiplier ~= nil then
      CDO.EnemyDamageMultiplier = EnemyDamageMultiplier
    end
  end
end

local function EnableBuild()
  if udpatingMaterials then return end
  local gameStatics = cache.gameStatics
  local engine = cache.engine

  if not engine or not gameStatics then
    print("Engine or SurvivalGameplayStatics instance not found\n")
    return
  end

  local controller = gameStatics:GetLocalSurvivalPlayerController(engine.GameViewport)
  if not controller:IsValid() then
    print("PlayerController instance not found\n")
    return
  end

  local results = {}                         
  if controller:GetHitResultUnderCursor(3, true, results) then
    local actor = results.Actor:Get()
    local component = results.Component:Get()
    if component:IsValid() then
      updatingMaterials = true
      for idx = 1, component:GetNumMaterials() do
        local material = component:GetMaterial(idx-1)
        local pm = material:GetPhysicalMaterial()
        if not materials[pm:GetAddress()] then
          materials[pm:GetAddress()] = {pm, pm.SurfaceType}
        end
        pm.SurfaceType = 0
      end
      updatingMaterials = false
      component:SetCollisionResponseToChannel(16 , 1)
      component:SetCollisionResponseToChannel(17 , 1)
      component:SetCollisionResponseToChannel(20 , 0)
      component:SetCollisionResponseToChannel(21 , 2)
      ShowMessage("Build enabled")
    end
  end
end

local function RestoreMaterials()
  if updatingMaterials then return end
  updatingMaterials = true
  local updated = false
  for _, material in pairs(materials) do
    material[1].SurfaceType = material[2]
    updated = true
  end
  materials = {}
  updatingMaterials = false
  if updated then
    ShowMessage("Surfaces restored")
  end
end

if AOEPickupRadius ~= nil and AOEPickupKey ~= nil then
  local pickupClass = StaticFindObject("/Script/Maine.SpawnedItem")
  local dropletClass = StaticFindObject("/Script/Maine.SpawnedItemDroplet")
  local plankClass = nil
  local logClass = nil
  local picking = false
  local items = {}
  local pickupModes = { "All", "Items only", "Logs&PLanks only"}
  
  local function PickupMode()
    AOEPickupMode = (AOEPickupMode % 3) + 1
    ShowMessage("Pickup mode: "..pickupModes[AOEPickupMode])
  end
  
  local function ValidForPickup(item)
    if item:IsA(dropletClass) then return false end
    if AOEPickupMode == 1 then return true end
    if AOEPickupMode == 2 and (item:IsA(plankClass) or item:IsA(logClass)) then return false end
    if AOEPickupMode == 3 and not (item:IsA(plankClass) or item:IsA(logClass)) then return false end
    return true
  end

  local function LookForPickupNearby()
    if not LocalPlayerCharacter or not LocalPlayerCharacter:IsValid() then return end

    if not plankClass or not plankClass:IsValid() then
      plankClass = StaticFindObject("/Game/Blueprints/Items/World/Harvested/BP_World_GrassPlank.BP_World_GrassPlank_C")
    end

    if not logClass or not logClass:IsValid() then
      logClass = StaticFindObject("/Game/Blueprints/Items/World/Harvested/BP_World_Log.BP_World_Log_C")
    end

    picking = true
    local engine = cache.engine
    local kismet = cache.kismet
    local types = {1}
    local pos = LocalPlayerCharacter:K2_GetActorLocation()
    local results = {}
    items = {}
    if kismet:SphereOverlapActors(engine.GameViewport, pos, AOEPickupRadius, types, pickupClass, nil, results) then
      for _, value in ipairs(results) do
        local item = value:get()
        if item and item:IsValid() and ValidForPickup(item) then
          table.insert(items, item)
        end
      end
    end
    picking = false
  end

  local function PickupLoop()
    if not LocalPlayerCharacter or not LocalPlayerCharacter:IsValid() then return end

    if #items > 0 and not picking then
      local item = table.remove(items)
      if item and item:IsValid() then
        if item.Interact:IsValid() then
          item:Interact(0, LocalPlayerCharacter)
        else
          if LocalPlayerCharacter:TryPickupItem(item.Item, false) then
            item:DelayedDestroy()
          end
        end
      end
    end
  end

  local function PickupEvent()
    if #items == 0 and not picking then
      LookForPickupNearby()
    end
  end  

  if AOEPickupModifierKey ~= nil then
    RegisterKeyBind(AOEPickupKey, {AOEPickupModifierKey}, PickupEvent)
  else
    RegisterKeyBind(AOEPickupKey, PickupEvent)
  end

  if AOEPickupModeKey ~= nil then
    if AOEPickupModeModifierKey ~= nil then
      RegisterKeyBind(AOEPickupModeKey, {AOEPickupModeModifierKey}, PickupMode)
    else
      RegisterKeyBind(AOEPickupModeKey, PickupMode)
    end
  end

  RegisterHook("/Script/Maine.SurvivalGameState:GetActiveBossForPlayer", PickupLoop)
end

local function Init()
  local gameStatics = cache.gameStatics
  local engine = cache.engine
  if not engine or not gameStatics then
    print("Engine or SurvivalGameplayStatics instance not found\n")
    return
  end

  local player = gameStatics:GetLocalSurvivalPlayerCharacter(engine.GameViewport)
  if LocalPlayerCharacter ~= nil and (not player:IsValid() or LocalPlayerCharacter:GetAddress() == player:GetAddress()) then
    return
  end

  LocalPlayerCharacter = player
  local gameModeManager = gameStatics:GetSurvivalGameModeManager(engine.GameViewport)
  local gameState = gameStatics:GetSurvivalGameState(engine.GameViewport)
  local globalItemData = gameStatics:GetGlobalItemData()

  UpdateGlobalItemData(globalItemData)
  UpdateGameState(gameState)
  UpdateModeSettings(gameModeManager)
  print("QoL init done\n")
end

if LogStorageCapacity ~= nil or PlankStorageCapacity ~= nil then
  NotifyOnNewObject("/Script/Maine.TypeRestrictedStorageBuilding", function(createdObject)
    if LogStorageCapacity ~= nil and createdObject:IsA("/Game/Blueprints/Items/Buildings/Storage/BP_LogStorage.BP_LogStorage_C") then
      createdObject.Capacity = LogStorageCapacity
    elseif PlankStorageCapacity ~= nil and createdObject:IsA("/Game/Blueprints/Items/Buildings/Storage/BP_PlankStorage.BP_PlankStorage_C") then
      createdObject.Capacity = PlankStorageCapacity
    end
  end)
end

if SmallStorageCapacity ~= nil or BigStorageCapacity ~= nil or FridgeStorageCapacity ~=nil then
  NotifyOnNewObject("/Script/Maine.Storage", function(createdObject)
    if SmallStorageCapacity ~= nil and createdObject:IsA("/Game/Blueprints/Items/Buildings/Storage/BP_Storage.BP_Storage_C") then
      createdObject.InventoryComponent.MaxSize = SmallStorageCapacity
    elseif BigStorageCapacity ~= nil and createdObject:IsA("/Game/Blueprints/Items/Buildings/Storage/BP_Storage_Big.BP_Storage_Big_C") then
      createdObject.InventoryComponent.MaxSize = BigStorageCapacity
    elseif FridgeStorageCapacity ~= nil and createdObject:IsA("/Game/Blueprints/Items/Buildings/Storage/BP_StorageFridge.BP_StorageFridge_C") then
      createdObject.InventoryComponent.MaxSize = FridgeStorageCapacity
    end
  end)
end

if DewCollectorAmountPerHour ~= nil then
  NotifyOnNewObject("/Script/Maine.FaucetBuilding", function(createdObject)
    if createdObject:IsA("/Game/Blueprints/Items/Buildings/BP_DewCollector.BP_DewCollector_C") then
      createdObject.FillAmountPerHour = DewCollectorAmountPerHour
    end
  end)
end

NotifyOnNewObject("/Script/Maine.ZiplineAnchorBuilding", function(createdObject)
  if createdObject:IsA("/Game/Blueprints/Items/Buildings/BP_GroundZiplineAnchor_Fixed.BP_GroundZiplineAnchor_Fixed_C") then
    createdObject.bPlayerCanInteract = true
  end
end)

if MaxActiveMutations ~= nil then
  NotifyOnNewObject("/Script/Maine.SurvivalPlayerState", function(createdObject)
    if createdObject:IsA("/Game/Blueprints/Player/BP_SurvivalPlayerState.BP_SurvivalPlayerState_C") then
      createdObject.PerkComponent.MaxEquippedPerks = MaxActiveMutations
    end
  end)
end

if DropAmountMultiplier ~= nil or DropChanceMin ~= nil then
  RegisterHook("/Script/Maine.LootComponent:SpawnLoot", function(self, looter, spawnType)
    local lootComponent = self:get()
    if nodeUpdated[lootComponent:GetOuter():GetAddress()] then
      nodeUpdated[lootComponent:GetOuter():GetAddress()] = nil
      return
    end
    lootComponent.Items:ForEach(function(lootIdx)
      local item = lootComponent.Items[lootIdx]
      if DropAmountMultiplier ~= nil then
        item.Count = math.floor(item.Count*DropAmountMultiplier)
      end
      if DropChanceMin ~= nil and item.DropChance < DropChanceMin then
        item.DropChance = math.min(1, DropChanceMin)
      end
    end)
  end)
  RegisterHook("/Script/Maine.HarvestNode:OnDamaged", function(self)
    local node = self:get()
    if nodeUpdated[node:GetAddress()] then
      return
    end
    nodeUpdated[node:GetAddress()] = true
    local lootComponent = node.LootComponent
    lootComponent.Items:ForEach(function(lootIdx)
      local item = lootComponent.Items[lootIdx]
      if DropAmountMultiplier ~= nil then
        item.Count = math.floor(item.Count*DropAmountMultiplier)
      end
      if DropChanceMin ~= nil and item.DropChance < DropChanceMin then
        item.DropChance = math.min(1, DropChanceMin)
      end
    end)
  end)
  local creatureClass = StaticFindObject("/Script/Maine.SurvivalCreature")
  RegisterHook("/Script/Maine.SurvivalCharacter:OnDeath", function(self)
    local character = self:get()
    if character:IsA(creatureClass) then
      local lootComponent = character.LootComponent
      lootComponent.Items:ForEach(function(lootIdx)
        local item = lootComponent.Items[lootIdx]
        if DropAmountMultiplier ~= nil then
          item.Count = math.floor(item.Count*DropAmountMultiplier)
        end
        if DropChanceMin ~= nil and item.DropChance < DropChanceMin then
          item.DropChance = math.min(1, DropChanceMin)
        end
      end)
    end
  end)
end

if DeconstructPercentage ~= nil then
  NotifyOnNewObject("/Script/Maine.Building", function(building)
    building.DropIngredientsPercentage = math.min(1, DeconstructPercentage)
  end)
end

if ProductionSpeedMultiplier ~= nil or ProductionItems ~= nil then
  NotifyOnNewObject("/Script/Maine.ProductionBuilding", function(createdObject)
    if ProductionSpeedMultiplier ~= nil then
      createdObject.ProductionTime = createdObject.ProductionTime / math.max(0.01, ProductionSpeedMultiplier)
    end
    if ProductionItems ~= nil then
      createdObject.MaxSimulateousItems = math.max(1, math.min(createdObject.MaxProductionItems, ProductionItems))
    end
  end)
end

local characterClass = StaticFindObject("/Script/Maine.SurvivalPlayerCharacter")
if HaulingCapacity ~= nil then
  RegisterHook("/Script/Maine.SurvivalCharacter:OnStatusEffectChanged", function(self)
    local character = self:get()
    if character:IsA(characterClass) then
      playerEffects[character:GetFullName()] = character.StatusEffectComponent:GetValueForStat(9)
    end
  end)
  RegisterHook("/Script/Maine.HaulingComponent:GetAdjustedCapacity", function(self)
    local component = self:get()
    local parent = component:GetOuter()
    if parent:IsA(characterClass) then
      return HaulingCapacity + playerEffects[parent:GetFullName()]
    end
  end)
end

NotifyOnNewObject("/Script/Maine.SurvivalPlayerCharacter", function(player)
  playerEffects[player:GetFullName()] = player.StatusEffectComponent:GetValueForStat(9)
  ExecuteWithDelay(2000, function() UpdatePlayer(player) end)
end)

if DisableFOG or DisableDOF then
  NotifyOnNewObject("/Script/Maine.TimeOfDayLightingManager", function(createdObject)
    if DisableFOG then
      createdObject.FogMultiplierRandom = 0
    end
    if DisableDOF then
      createdObject.DOF = false
    end
  end)
end

if DayLengthMultiplier ~= nil or NightLengthMultiplier ~= nil then
  RegisterHook("/Script/Maine.ZoneManagerComponent:OnDayNightChange", function(self, isDayParam)
    local isDay = isDayParam:get()
    SetDayTimeMultiplier(isDay)
  end)
end

RegisterHook("/Script/Engine.PlayerController:ClientRestart", Init)

if EnableBuildHotKey ~= nil then
  if EnableBuildHotKeyModifier ~= nil then
    RegisterKeyBind(EnableBuildHotKey, {EnableBuildHotKeyModifier}, EnableBuild)
  else
    RegisterKeyBind(EnableBuildHotKey, EnableBuild)
  end
end

if RestoreMaterialsHotKey ~= nil then
  if RestoreMaterialsModifier ~= nil then
    RegisterKeyBind(RestoreMaterialsHotKey, {RestoreMaterialsModifier}, RestoreMaterials)
  else
    RegisterKeyBind(RestoreMaterialsHotKey, RestoreMaterials)
  end
end
