--------------封装获取帕鲁Mod实例的函数集合SimpleCmdUtil,以及部分功能函数
--------------@Author 祈拉之之影 该文件主要提供获取幻兽帕鲁的实例以及修改纯函数，再这里加上你要的功能,该文件会一直更新
local SimpleCmdShared = require("scShared")
----private
local G_UPalUtility = nil
local G_Setting = nil
local G_BP_OtomoPalHolderComponent_C
local G_PalCharacterManager
local G_PalAIController

local GetPalHolder = function()
    if G_BP_OtomoPalHolderComponent_C then
        return G_BP_OtomoPalHolderComponent_C
    else
        local ActorInstances = FindFirstOf("BP_OtomoPalHolderComponent_C")
        if not ActorInstances then
            print("No instances of 'BP_OtomoPalHolderComponent_C' were found\n")
            return nil
        else
            G_BP_OtomoPalHolderComponent_C =  ActorInstances
            return G_BP_OtomoPalHolderComponent_C
        end
    end
end

local GetPalAIController = function()
    if G_PalAIController then
        return G_PalAIController
    else
        local ActorInstances = FindFirstOf("PalAIController")
        if not ActorInstances then
            print("No instances of 'PalAIController' were found\n")
            return nil
        else
            G_PalAIController =  ActorInstances
            return G_PalAIController
        end
    end
end

local GetPalIndividualHandleByCharacter = function(act)
    return act:GetCharacterParameterComponent().IndividualHandle
end

local GetPalIndividualByCharacter = function(act)
    return act:GetCharacterParameterComponent().IndividualParameter
end

local GetUPalCharacterManager = function()
    if G_PalCharacterManager then
        return G_PalCharacterManager
    else
        local ActorInstances = FindFirstOf("PalCharacterManager")
        if not ActorInstances then
            print("No instances of 'PalCharacterManager' were found\n")
            return nil
        else
            G_PalCharacterManager =  ActorInstances
            return G_PalCharacterManager
        end
    end
end

local ArrayContains = function(array, element)
    for _, value in ipairs(array) do
        if value == element then
              return true
        end
    end 
    return false
end

----public

local SimpleCmdUtil = {}

---comment
---@return UPalUtility 全局公用组件[获取全局公用的组件]
function SimpleCmdUtil.GetUPalUtility()
    if G_UPalUtility then
        return G_UPalUtility
    else
        local ActorInstances = StaticFindObject("/Script/Pal.Default__PalUtility")
        if not ActorInstances then
            print("No instances of 'UPalUtility' were found\n")
            return nil
        else
            G_UPalUtility =  ActorInstances
            return G_UPalUtility
        end
    end
end

---comment
---@return UPalGameSetting 游戏设置[获取游戏设置]
function SimpleCmdUtil.GetPalSetting()
    if G_Setting then
        return G_Setting
    end
    local setting = FindFirstOf("PalGameSetting")
    if setting ~= nil then
        G_Setting = setting
        return  G_Setting
    else
        return nil
    end
end

---comment
---@return APalPlayerState 玩家状态[获取玩家状态]
function SimpleCmdUtil.GetPlayState()
    return SimpleCmdShared.GetPawn():GetPalPlayerController():GetPalPlayerState()
end

---comment
---@param APalCharacter 帕鲁Character
---@param str 对比字符串
---@return boolean|[帕鲁名称里是否有子串]
function SimpleCmdUtil.PalNameInclude(actor,str)
    if string.find(SimpleCmdUtil.GetUPalUtility():GetCharacterIDFromCharacter(actor):ToString(), str) then
        return true
    end
    return false
end

---comment
---@param APalCharacter 帕鲁Character
---@return UPalIndividualCharacterParameter 帕鲁的ID[根据帕鲁Character获取帕鲁ID]
function SimpleCmdUtil.GetIndividual(actor)
    return GetPalIndividualByCharacter(actor)
end

---comment
---@param APalCharacter 帕鲁Character
---@return UPalIndividualCharacterHandle 帕鲁的ID控制句柄[根据帕鲁Character获取帕鲁ID控制句柄]
function SimpleCmdUtil.GetIndividualHandle(actor)
    return GetPalIndividualHandleByCharacter(actor)
end

---comment
---@param APalCharacter 帕鲁Character
---@return string 帕鲁的唯一标识ID字符串[根据帕鲁获取帕鲁的唯一ID字符串]
function SimpleCmdUtil.GetLuaID(actor)
    return tostring(GetPalIndividualByCharacter(actor).IndividualId.InstanceId.A)
    ..tostring(GetPalIndividualByCharacter(actor).IndividualId.InstanceId.B)
    ..tostring(GetPalIndividualByCharacter(actor).IndividualId.InstanceId.C)
    ..tostring(GetPalIndividualByCharacter(actor).IndividualId.InstanceId.D)
end

---comment
---@param APalCharacter 帕鲁Character
---@return string 获取帕鲁的名字[获取帕鲁种类的具体名字]
function SimpleCmdUtil.GetCharacterName(act)
    return SimpleCmdUtil.GetUPalUtility():GetCharacterIDFromCharacter(act):ToString()
end

---comment
---@param APalCharacter 帕鲁Character
---@return boolean 捕获是否成功[捕获帕鲁]
function SimpleCmdUtil.CapPal(act)
    if  SimpleCmdUtil.GetUPalUtility():IsOtomo(act) then
        return false
    end
    SimpleCmdUtil.GetUPalUtility():PalCaptureSuccess(SimpleCmdShared.GetPawn(), act)
    return true
end

---comment
---@param APalCharacter 帕鲁Character
---@return [骑乘选中帕鲁]
function SimpleCmdUtil.RideToPal(act)
    SimpleCmdUtil.GetUPalUtility():RideTo(SimpleCmdShared.GetPawn(),act,false)
    SimpleCmdShared.GetPawn():SetActorEnableCollision(true)
end

---comment
---@param APalCharacter 帕鲁Character
---@return [骑乘选中帕鲁-无碰撞]
function SimpleCmdUtil.RideToPalWithOutCollision(act)
    SimpleCmdUtil.GetUPalUtility():RideTo(SimpleCmdShared.GetPawn(),act,false)
    SimpleCmdShared.GetPawn():SetActorEnableCollision(false)
end

function SimpleCmdUtil.GetOffFromPal()
    SimpleCmdUtil.GetUPalUtility():GetOffFromPal(SimpleCmdShared.GetPawn(),false,true)
    SimpleCmdShared.GetPawn():SetActorEnableCollision(true)
end

---comment
---@param string palName对比名称,为""则是找第一只帕鲁
---@return APalCharacter 帕鲁Character[获取附近名字中含有palName的帕鲁]
function SimpleCmdUtil.GetPalCharacterNear(palName)
    local Target = nil
    local ActorInstances = FindAllOf("PalCharacter")
    if not ActorInstances then
        print("No instances of 'PalCharacter' were found\n")
    else
        for Index, act in pairs(ActorInstances) do 
            if SimpleCmdUtil.GetUPalUtility():IsPalMonster(act) and string.find(SimpleCmdUtil.GetCharacterName(act),palName) and not SimpleCmdUtil.GetUPalUtility():IsOtomo(act)  then
                Target = act
                break
           end
        end 
    end
    return Target
end

---comment
---@return List<APalCharacter> 帕鲁Character[获取周围所有的伙伴帕鲁]
function SimpleCmdUtil.GetAllOtomoNear()
    local Traget = {}
    local ActorInstances = FindAllOf("PalCharacter")
    if not ActorInstances then
        print("No instances of 'PalCharacter' were found\n")
    else
        for Index, act in pairs(ActorInstances) do 
            if SimpleCmdUtil.GetUPalUtility():IsPalMonster(act) and SimpleCmdUtil.GetUPalUtility():IsOtomo(act)  then
               table.insert(Traget,act)
           end
        end 
    end
    return Traget
end

---comment
---@param string palName对比名称,为""则是找第一只帕鲁
---@return List<APalCharacter> 帕鲁Character[获取名字中含有字串的伙伴帕鲁]
function SimpleCmdUtil.GetCharacterOtomo(palName)
    local Traget = nil
    local ActorInstances = FindAllOf("PalCharacter")
    if not ActorInstances then
        print("No instances of 'PalCharacter' were found\n")
    else
        for Index, act in pairs(ActorInstances) do 
            if SimpleCmdUtil.GetUPalUtility():IsPalMonster(act) and SimpleCmdUtil.GetUPalUtility():IsOtomo(act) and string.find(SimpleCmdUtil.GetUPalUtility():GetCharacterIDFromCharacter(act):ToString(),palName) then
                Traget = act
                break
           end
        end 
    end
    return Traget
end

---comment
---@param actorA 释放技能的帕鲁Character
---@param actorB 挨揍的Character，可以填释放的帕鲁自己
---@return 帕鲁Character[帕鲁释放技能]kk
function SimpleCmdUtil.PlayWaza(actorA,actorB,wazaID)
    SimpleCmdUtil.GetUPalUtility():PlayActionByWazaID(actorA,actorB,wazaID)
end

---comment
---@param actor 释放动作的主体
---@param actionID 动作的ID
function SimpleCmdUtil.PlayAction(actor,actionID)
    actor:GetActionComponent():CancelAllAction()
    actor:GetActionComponent():PlayActionLocationByType(nil,actionID)
end

---comment
---@param actor 移除动作的主体
function SimpleCmdUtil.CanCelAction(actor)
    actor:GetActionComponent():CancelAllAction()
end


---comment
---@param actorA 释放技能的帕鲁Character
---@param actorB 挨揍的Character，可以填释放的帕鲁自己
---@return List<APalCharacter> 帕鲁Character[获取名字中含有字串的伙伴帕鲁]
function SimpleCmdUtil.IsSafeLoadBetweenTwoActors(actorA,actorB)
    return SimpleCmdUtil.GetUPalUtility():IsNearTwoActor(actorA,actorB,6385,true)
end

---comment
---@param actorA 释放技能的帕鲁Character
---@param actorB 挨揍的Character，可以填释放的帕鲁自己
---@return List<APalCharacter> 帕鲁Character[获取名字中含有字串的伙伴帕鲁]
function SimpleCmdUtil.IsSafeLoadBetweenTwoActors(actorA,actorB)
    return SimpleCmdUtil.GetUPalUtility():IsNearTwoActor(actorA,actorB,6385,true)
end

---comment
---@param APalCharacter 帕鲁Character
---@return TArray<FName> 被动技能列表[获取帕鲁的被动技能列表]
function SimpleCmdUtil.GetCharacterPassiveSkills(act)
    return GetPalIndividualByCharacter(act).SaveParameter.PassiveSkillList
end

---comment
---@param APalCharacter 帕鲁Character
---@return TArray<integer> 掌握技能列表[获取帕鲁已掌握技能列表]
function SimpleCmdUtil.GetCharacterMasteredWaza(act)
     return GetPalIndividualByCharacter(act).SaveParameter.MasteredWaza
end

---comment
---@return List<APalcharacter> 周围野生帕鲁列表[获取周围所有帕鲁]
function SimpleCmdUtil.GetAllOfPalMonster()
    local acts = {}
    local ActorInstances = FindAllOf("PalCharacter")
    if not ActorInstances then
        print("No instances of 'PalCharacter' were found\n")
    else
        print(tostring(#ActorInstances))
        for Index, act in pairs(ActorInstances) do  
            if SimpleCmdUtil.GetUPalUtility():IsPalMonster(act) and not SimpleCmdUtil.GetUPalUtility():IsOtomo(act) and SimpleCmdUtil.IsSafeLoadBetweenTwoActors(act,SimpleCmdShared.GetPawn()) then
                table.insert(acts,act)
            end
        end 
    end
    return acts
end

---comment
---@param string 1表示覆盖显示，0表示隐藏
---@return boolean 是否成功[设置玩家主界面UI的显示/隐藏-非呼出界面]
function SimpleCmdUtil.SetMainUIState(str)
    local param = tonumber(str)
    local v = 2
    if param == 0 then
       v = 2
    elseif param == 1 then
       v = 3
    else
         SimpleCmdShared.SimpleCmdFail("参数错误")
    end 
    local ActorInstances = FindAllOf("UserWidget")
    if not ActorInstances then
        print("No instances of 'UserWidget' were found\n")
    else
        for Index, act in pairs(ActorInstances) do 
             if string.find(act:GetFName():ToString(),"WBP_PlayerUI_C") then
                 ExecuteWithDelay(100, function()
                    act:SetVisibility(v)
                 end)
                 break
             end
         end
    end
    return true
end

---comment
---@param boolean 1表示显示，0表示隐藏
---@return 移除挂灯[设置玩家主界面UI的显示/隐藏-非呼出界面]
function SimpleCmdUtil.NoLamp(hid)
     local ActorInstances = FindFirstOf("BP_Lamp_C")
     ActorInstances.SM_Lantern_Flames:ToggleVisibility(hid)
     ActorInstances.SM_lamp_01:ToggleVisibility(hid)
end

---comment
---@return 钢琴线火箭
function SimpleCmdUtil.LineRocket()
    local w = FindAllOf("PalWeaponBase")
    for index, value in ipairs(w) do
        if value.WeaponType == 6 and SimpleCmdUtil.GetCharacterName(value:GetOwnerCharacter()) == "JetDragon" then
           value.BulletDeleteTime = 385
           value.BulletDecayStartRate = 0
        end
    end
end
 
---@return Character 在hook事件之外获取当前出战的帕鲁
function SimpleCmdUtil.CurrentActivateOtomoPalCharacter()
    return  GetPalHolder():TryGetSpawnedOtomo()
end

---@return Character 获取帕鲁伙伴持有组件
function SimpleCmdUtil.GetOtomoPalHolder()
    return GetPalHolder()
end

---获取CharacterManager
function SimpleCmdUtil.GetPalCharacterManager()
    return GetUPalCharacterManager()
end

function SimpleCmdUtil.GetPalAIController()
   return  GetPalAIController()
end

function SimpleCmdUtil.NoTra()
        local ActorInstances = FindAllOf("BP_AIAction_OtomoFollow_C")
        if not ActorInstances then
            print("No instances of 'BP_AIAction_OtomoFollow_C' were found\n")
        else
            for Index, act in pairs(ActorInstances) do
                act.Trainer = nil
            end
        end
        print("is ok!!!go!\n")
end

function SimpleCmdUtil.RandomLine(maxv,maxr)
    local ActorInstances = FindAllOf("BP_AIAction_OtomoFollow_C")
    if not ActorInstances then
        print("No instances of 'BP_AIAction_OtomoFollow_C' were found\n")
    else
        for Index, act in pairs(ActorInstances) do
            act.TargetLocationDistanceForward = SimpleCmdShared.GetARandomValue(350,maxv)
            act.TargetLocationDistanceRight = SimpleCmdShared.GetARandomValue(maxr*-1,maxr)
        end
    end
end


return SimpleCmdUtil


