--------------通用的方法集合SimpleCmdShared
--------------@Author 祈拉之之影 该文件仅提供一些通用工具，可以在其他游戏中使用，一般无需修改 Line 385

--#region private field
local SimpleCmdShared = {}
local Version = "2024-05-06"
local delayTime = 2000
local CanViewLog = true
local WBPMySP = nil
local WBPMySPSuccess = nil
local WBPMySPFail = nil
local G_Pawn = nil
local GSceneComponent = nil
local debug = true
--#endregion

--#region public field
SimpleCmdShared.ModStart = false
--#endregion

--#region Private function
local GetWBPMySP = function()
    if WBPMySP then
        return WBPMySP
    else
        local ActorInstances = FindFirstOf("SimpleCmd_main_C")
        if not ActorInstances then
            print("No instances of 'SimpleCmd_main_C' were found\n")
        else
            WBPMySP =  ActorInstances
            return WBPMySP
        end
    end
end

local GetWBPMySPSuccess = function()
    if WBPMySPSuccess then
        return WBPMySPSuccess
    else
        local ActorInstances = FindFirstOf("SimpleCmd_success_C")
        if not ActorInstances then
            print("No instances of 'SimpleCmd_success_C' were found\n")
        else
            WBPMySPSuccess =  ActorInstances
            return WBPMySPSuccess
        end
    end
end

local GetWBPMySPFail = function()
    if WBPMySPFail then
        return WBPMySPFail
    else
        local ActorInstances = FindFirstOf("SimpleCmd_fail_C")
        if not ActorInstances then
            print("No instances of 'SimpleCmd_fail_C' were found\n")
        else
            WBPMySPFail =  ActorInstances
            return WBPMySPFail
        end
    end
end

local GetPlayerController = function ()
    if PlayerController and PlayerController:IsValid() then return PlayerController end
    -- local PlayerControllers = jsb.simpleBench("findallof", FindAllOf, "Controller")
    -- Uncomment line above and comment line below to profile this function
    local PlayerControllers = FindAllOf("PlayerController") or FindAllOf("Controller")
    if not PlayerControllers then return Print("No PlayerControllers found\n") end
    for _, Controller in pairs(PlayerControllers or {}) do
        if Controller.Pawn:IsValid() and Controller.Pawn:IsPlayerControlled() then
            PlayerController = Controller
            break
        -- else
        --     print("Not valid or not player controlled\n")
        end
    end
    if PlayerController and PlayerController:IsValid() then
        return PlayerController
    end
    error("No PlayerController found\n")
end
--#endregion

--#region Public function
function SimpleCmdShared.SimpleCmdStart()
    if not SimpleCmdShared.ModStart or not CanViewLog then
        return
    end
    ExecuteAsync(function()
        GetWBPMySP().Canvas_Main:SetVisibility(3)
        CanViewLog = false
        ExecuteWithDelay(delayTime, function()
            CanViewLog = true
            GetWBPMySP().Canvas_Main:SetVisibility(2)
        end)
    end)
end

function SimpleCmdShared.SimpleCmdSuccess()
    if not SimpleCmdShared.ModStart or not CanViewLog then
        return
    end
    ExecuteAsync(function()
        GetWBPMySPSuccess().Canvas_Success:SetVisibility(3)
        CanViewLog = false
        ExecuteWithDelay(delayTime, function()
            CanViewLog = true
            GetWBPMySPSuccess().Canvas_Success:SetVisibility(2)
        end)
    end)
end

function SimpleCmdShared.SimpleCmdFail(errMessage)
    if not SimpleCmdShared.ModStart or not CanViewLog then
        return
    end
    ExecuteAsync(function()
        GetWBPMySPFail().Canvas_Fail:SetVisibility(3)
        if errMessage ~= nil then
            local logMessage = GetWBPMySPFail().FailCmdText:GetText():ToString()..":"..errMessage
            GetWBPMySPFail().FailCmdText:setText(FText(logMessage))
        end
        CanViewLog = false
        ExecuteWithDelay(delayTime, function()
            CanViewLog = true
            GetWBPMySPFail().Canvas_Fail:SetVisibility(2)
            GetWBPMySPFail().FailCmdText:setText(FText("命令执行失败 ErrCmd"))
        end)
    end)
end

---@return float SimpleCmd版本号
function SimpleCmdShared.GetVersion()
    return Version
end

---@return Boolean SimpleCmd组件初始化是否失败
function SimpleCmdShared.InitFailed()
    return GetWBPMySPSuccess() == nil or GetWBPMySP()==nil or GetWBPMySPFail()==nil
end

---@param character  UE的Character对象
---@param multiplier 放缩倍率
---@return Vector3 放缩后的放缩比例值
function SimpleCmdShared.Setsize(character,multiplier)
    local temp = {X = multiplier, Y = multiplier, Z = multiplier}
    if multiplier > 1 then
        local h = multiplier*125
        local loc = character:K2_GetActorLocation()
        loc.Z = loc.Z+h
        character:K2_SetActorLocation(loc,false,{},false)  
    end
    character:SetActorScale3D(temp)
    return temp
end

---@param character UE的Character对象
---@param type 放缩类型，1表示放大，2表示缩小
---@param multiplier 放缩倍率
---@return Vector3 放缩后的放缩比例值
function SimpleCmdShared.Resize(character,type,multiplier)
    local originSize = character:GetActorScale3D()
    local temp = nil
    if type == 1 then
        temp = {X = originSize.X*multiplier, Y = originSize.Y*multiplier, Z = originSize.Z*multiplier}
    else
        temp = {X = (originSize.X)*1.0/multiplier, Y = originSize.Y*1.0/multiplier, Z = originSize.Z*1.0/multiplier}
    end
    character:SetActorScale3D(temp)
    return temp
end

---@return UPawn 获取当前玩家的Pawn
function SimpleCmdShared.GetPawn()
    if G_Pawn then
         return G_Pawn
     else
         local FirstPlayerController = GetPlayerController()
         if not FirstPlayerController then
             return nil
         end
         local Pawn = FirstPlayerController.Pawn
         if not Pawn then
             return nil
         end
         G_Pawn = Pawn
         return G_Pawn
    end
end

---@param characterA Character
---@param CharacterB Character
---@return boolean 是否成功 交换两个character之间的位置
function SimpleCmdShared.SwapPositions(characterA,CharacterB)
    local location = characterA:K2_GetActorLocation()
    local locationB = CharacterB:K2_GetActorLocation()
    local outTable = {
        swept = false,
    }
    location.Z = location.Z+300
    locationB.Z = locationB.Z+300
    CharacterB:K2_SetActorLocation(location,false,outTable,false)
    characterA:K2_SetActorLocation(locationB,false,outTable,false)
    return true
end

---@param length 瞬移参考距离
---@param Height 瞬移高度
---@return boolean 瞬移是否成功
function SimpleCmdShared.MoveDirectionTeleport(length,Height)
    local character = SimpleCmdShared.GetPawn()
    if not character then
        return false
    else
        local outTable = {
            swept = true,
        }
        local direct = character:GetActorForwardVector()
        local location =  character:K2_GetActorLocation()
        local TargetLocation = {X = direct.X * length+location.X,Y = direct.Y * length+location.Y,Z = direct.Z * length+location.Z + Height}
        location.Z = location.Z + 500
        character:K2_SetActorLocation(location,true,outTable,true)
        character:K2_SetActorLocation(TargetLocation,true,outTable,true)
    end
   return true
end

---@param length 瞬移参考距离
---@param Height 瞬移高度
---@return boolean 瞬移是否成功
function SimpleCmdShared.MoveDirectionTeleport_Character(character,length,baseHeight)
    local character = character
    local outTable = {
        swept = true,
    }
    local direct = character:GetActorForwardVector()
    local location =  character:K2_GetActorLocation()
    local TargetLocation = {X = direct.X * length+location.X,Y = direct.Y * length+location.Y,baseHeight}
    character:K2_SetActorLocation(TargetLocation,true,outTable,true)
   return true
end

---@param characterA 主:一般是第一个角色
---@param characterB 副
function SimpleCmdShared.CharacterGroup(characterA,characterB)
    characterA:SetActorHiddenInGame(true);
    SimpleCmdShared.Setsize(characterB,0.385)
    characterA:SetActorEnableCollision(false)
end

---@param character character
---@param isHide 是否隐藏 隐藏角色/可以用于Actor
function SimpleCmdShared.HideCharacter(character,isHide)
    character:SetActorHiddenInGame(isHide)
end

---@param character character
---@param isHide 是否启用`取消角色/可以用于Actor的物理碰撞
function SimpleCmdShared.EnableCollision(character,isOpen)
    character:SetActorEnableCollision(isOpen)
end
--#endregion

--#region Public function LuaNormal
---@param str 待移除空格的字符串
---@return string 处理后的字符串
function SimpleCmdShared.Strim(str)
    return (string.gsub(str, "^%s*(.-)%s*$", "%1"))
end

---@param input 待分割的字符串
---@param delimiter 用来分割的字符串
---@return Array 以delimiter分割后的字符串数组
function SimpleCmdShared.Split(input, delimiter)
    input = tostring(input)
    delimiter = tostring(delimiter)
    if (delimiter == "") then 
        return {}
    end
    local pos, arr = 0, {}
    for st, sp in function() return string.find(input, delimiter, pos, true) end do
        table.insert(arr, string.sub(input, pos, st - 1))
        pos = sp + 1
    end
    table.insert(arr, string.sub(input, pos))
    return arr
end

---@param array 源数组
---@param element 元素
---@return boolean 数组中是否包含元素
function SimpleCmdShared.FindElement(array, element)
    for _, value in ipairs(array) do
        if value == element then
              return true
        end
    end 
    return false
end

---@param Tarray Tarray数组
---@param List 增加的数组
---@param emptyValue 空余位置的值
---@return Tarray 处理过的新数组
function SimpleCmdShared.TarrayAddRange(Tarray,list,emptyValue)
    local i = 1
    for it = #Tarray+1, #Tarray+#list+1 do
        Tarray[it] = emptyValue
    end
    Tarray:ForEach(function (index,value)
        if i>#list then
            return 
        end
        if value:get() == emptyValue then
           value:set(list[i])
           i = i+1
        end
    end)
    return Tarray
end

---@param Tarray Tarray数组
---@param int index
---@param value 替换的值
---@param emptyValue 空余位置的值
---@return Tarray 处理后的数组
function SimpleCmdShared.TarraySetIndex(Tarray,index,setValue) 
    Tarray:ForEach(function(i,value)
             if index == i then
                value:set(setValue)
             end
    end)
    return Tarray
end

---@param Tarray Tarray数组
---@param list 覆盖的数组
---@param emptyValue 覆盖的值
---@param needNewSpace 是否需要开辟新的空间-大部分情况下请设置为false
---@return Tarray 处理后的数组
function SimpleCmdShared.TarraySet(Tarray,list,emptyValue,needNewSpace)
    if needNewSpace then
        for it = 1, #list+1 do
            if it>0 then
                Tarray[it] = emptyValue
            end
        end
    else
        for it = 1, #list do
            if it>0 then
                Tarray[it] = emptyValue
            end
        end
    end
    local i = 1
    Tarray:ForEach(function (index,value)
        if i>#list then
            return 
        end
        value:set(list[i])
        i= i + 1
    end)
    return Tarray
end

---@param MinValue number
---@param MaxValue number
---@return integer Min和Max之间的随机数
function SimpleCmdShared.GetARandomValue(minNum,maxNum)
    local random= math.floor((maxNum - minNum + 1) * math.random()) + minNum    
    return random
end

---@param t Array
---@return element 数组中随机某个元素 
function SimpleCmdShared.GetRandomElement(t)
    local randomIndex = math.random(#t)
    return t[randomIndex]
end

---comment
---@param character any
---@param DestRotation any
---@param DestLocation any
---@return bool 是否转移成功
function SimpleCmdShared.SetCharactertoLocation(character,DestLocation,DestRotation)
    return character:K2_TeleportTo(DestLocation,DestRotation)
end

---comment
---@param 字符串打印值
function SimpleCmdShared.LogValue(str)
    if debug then
       print(tostring(str).."\n")
    end
end

---comment
---@param fVector 打印Vector值
function SimpleCmdShared.LogVector(fVector)
    print("X:"..fVector.X..",Y:"..fVector.Y..",Z:"..fVector.Z.."\n")
end

---comment
---@param fRotator 打印Rotator值
function SimpleCmdShared.LogRotator(fRotator)
    print("X:"..fRotator.Pitch..",Y:"..fRotator.Yaw..",Z:"..fRotator.Roll.."\n")
end

---comment
---@return Vector3 获取当前的位置信息
function SimpleCmdShared.GetPlayerControllerLocation()
    return SimpleCmdShared.GetPawn():K2_GetActorLocation()
end

---comment
---@return Rotator 获取当前的方向信息
function SimpleCmdShared.GetPlayerControllerRotation()
    return SimpleCmdShared.GetPawn():K2_GetActorRotation()   
end
--#endregion
return SimpleCmdShared
