---@meta

---@class AB1X2_DispWorld : ADispLibEntityBase
AB1X2_DispWorld = {}

---@param EndPlayReason EEndPlayReason::Type
function AB1X2_DispWorld:ReceiveEndPlay(EndPlayReason) end


---@class AB1_StartupGameMode : AGameModeBase
AB1_StartupGameMode = {}

---@param EndPlayReason EEndPlayReason::Type
function AB1_StartupGameMode:ReceiveEndPlay(EndPlayReason) end


---@class ABGGGameStateB1 : ABGGGameStateCS
ABGGGameStateB1 = {}


---@class ABGGGameStateCS : ABGWGameState
---@field ActorCompContainerCS UActorCompContainerCS
ABGGGameStateCS = {}

function ABGGGameStateCS:BeginPlayCS() end
---@param EndPlayReason EEndPlayReason::Type
function ABGGGameStateCS:ReceiveEndPlay(EndPlayReason) end
function ABGGGameStateCS:ReceiveDestroyed() end
function ABGGGameStateCS:HandleBeginPlayCS() end
function ABGGGameStateCS:HandleLeavingMapCS() end
---@param DeltaTime float
function ABGGGameStateCS:OnTickDispatchEventCS(DeltaTime) end
function ABGGGameStateCS:HandleMatchHasEndedCS() end
function ABGGGameStateCS:HandleMatchHasStartedCS() end
---@return boolean
function ABGGGameStateCS:IsGSEventDebuggerOpenCS() end
function ABGGGameStateCS:OnPostTickDispatchEventCS() end
function ABGGGameStateCS:PostInitializeComponentsCS() end
function ABGGGameStateCS:HandleMatchIsWaitingToStartCS() end


---@class ABGGGameStateStartUpCS : AGameState
ABGGGameStateStartUpCS = {}

---@param EndPlayReason EEndPlayReason::Type
function ABGGGameStateStartUpCS:ReceiveEndPlay(EndPlayReason) end


---@class ABGG_GameMode : ABGWGameMode
---@field DataComp UActorDataContainer
---@field ActorCompContainerCS UActorCompContainerCS
---@field PlayerAllocNum int32
---@field EventCollection UBGS_GSEventCollection
ABGG_GameMode = {}

function ABGG_GameMode:StartPlayCS() end
---@param Player AController
---@return AActor
function ABGG_GameMode:ChoosePlayerStart(Player) end
function ABGG_GameMode:PostSeamlessTravelCS() end
---@param bToTransition boolean
---@param ActorList TArray<AActor>
function ABGG_GameMode:GetSeamlessTravelActorListCS(bToTransition, ActorList) end


---@class ABGG_GameModeB1 : ABGG_GameMode
---@field DefaultPawnClassBeforeRoleData TSubclassOf<APawn>
ABGG_GameModeB1 = {}

---@param Options FString
---@param LoginAddress FString
---@param UniqueId FString
---@param ErrorMessage FString
function ABGG_GameModeB1:PreLoginCS(Options, LoginAddress, UniqueId, ErrorMessage) end
---@param Exiting AController
function ABGG_GameModeB1:LoginOutCS(Exiting) end
---@param DeltaSeconds float
function ABGG_GameModeB1:ReceiveTick(DeltaSeconds) end
---@param NewPlayer APlayerController
function ABGG_GameModeB1:PostLoginCS(NewPlayer) end
function ABGG_GameModeB1:BeginPlayCS() end
---@param EndPlayReason EEndPlayReason::Type
function ABGG_GameModeB1:ReceiveEndPlay(EndPlayReason) end
function ABGG_GameModeB1:HandleMatchIsWaitingToStartCS() end
---@param InController AController
---@return UClass
function ABGG_GameModeB1:GetDefaultPawnClassForController(InController) end


---@class ABGG_GameModeB1Net : ABGG_GameModeB1
ABGG_GameModeB1Net = {}

---@param NewPlayer APlayerController
function ABGG_GameModeB1Net:PostLoginCS(NewPlayer) end
function ABGG_GameModeB1Net:BeginPlayCS() end
---@param EndPlayReason EEndPlayReason::Type
function ABGG_GameModeB1Net:ReceiveEndPlay(EndPlayReason) end


---@class ABGG_GameModeStartUp : ABGG_GameMode
---@field GameDefaultMapID int32
ABGG_GameModeStartUp = {}

function ABGG_GameModeStartUp:BeginPlayCS() end


---@class ABGLandmassActor : AActor
---@field WeightmapRT UTextureRenderTarget2D
---@field HeightmapRT UTextureRenderTarget2D
---@field LandscapeMPC UMaterialParameterCollection
---@field LandscapeQuads FIntPoint
---@field LandscapeRTRes FIntPoint
---@field LandscapeTransform FTransform
ABGLandmassActor = {}



---@class ABGP_AIPlayerControllerB1 : ABGP_AIPlayerControllerCS
ABGP_AIPlayerControllerB1 = {}


---@class ABGP_AIPlayerControllerCS : ABGUAIPlayerController
---@field DataComp UActorDataContainer
---@field ActorCompContainerCS UActorCompContainerCS
---@field EventCollection UBPS_GSEventCollection
ABGP_AIPlayerControllerCS = {}

---@param SendData TArray<uint8>
function ABGP_AIPlayerControllerCS:GSRpcSendServer(SendData) end
---@param SendData TArray<uint8>
function ABGP_AIPlayerControllerCS:GSRpcSendClient(SendData) end


---@class ABGP_PlayerCameraManagerCS : ABGPPlayerCameraManager
ABGP_PlayerCameraManagerCS = {}

---@param EndPlayReason EEndPlayReason::Type
function ABGP_PlayerCameraManagerCS:ReceiveEndPlay(EndPlayReason) end
---@param DeltaTime float
function ABGP_PlayerCameraManagerCS:UpdateCameraCS(DeltaTime) end
---@param NewViewTarget AActor
---@param TransitionParams FViewTargetTransitionParams
function ABGP_PlayerCameraManagerCS:SetViewTargetCS(NewViewTarget, TransitionParams) end
function ABGP_PlayerCameraManagerCS:OnBlendCompleteCS() end
---@param PC APlayerController
---@param OldViewTarget AActor
---@param NewViewTarget AActor
function ABGP_PlayerCameraManagerCS:OnViewTargetChangedCS(PC, OldViewTarget, NewViewTarget) end


---@class ABGP_PlayerControllerB1 : ABGP_PlayerControllerCS
ABGP_PlayerControllerB1 = {}

function ABGP_PlayerControllerB1:OnRep_PawnCS() end


---@class ABGP_PlayerControllerCS : ABGPPlayerController
---@field DataComp UActorDataContainer
---@field ActorCompContainerCS UActorCompContainerCS
---@field EventCollection UBPS_GSEventCollection
ABGP_PlayerControllerCS = {}

---@param SendData TArray<uint8>
function ABGP_PlayerControllerCS:GSRpcSendServer(SendData) end
---@param SendData TArray<uint8>
function ABGP_PlayerControllerCS:GSRpcSendClient(SendData) end
---@param OldPawn AActor
---@param NewPawn AActor
function ABGP_PlayerControllerCS:OnControlledPawnChange(OldPawn, NewPawn) end
function ABGP_PlayerControllerCS:BeginPlayCS() end
---@param EndPlayReason EEndPlayReason::Type
function ABGP_PlayerControllerCS:ReceiveEndPlay(EndPlayReason) end
---@param Command FString
function ABGP_PlayerControllerCS:ConsoleCommandCS(Command) end
function ABGP_PlayerControllerCS:InitInputSystemCS() end
function ABGP_PlayerControllerCS:OnRep_PlayerStateCS() end
---@param out_Location FVector
---@param out_Rotation FRotator
---@return boolean
function ABGP_PlayerControllerCS:GetPlayerViewPointCS(out_Location, out_Rotation) end
---@param bToEntry boolean
---@param ActorList TArray<AActor>
function ABGP_PlayerControllerCS:GetSeamlessTravelActorListCS(bToEntry, ActorList) end


---@class ABGP_PlayerStateB1 : ABGP_PlayerStateCS
ABGP_PlayerStateB1 = {}


---@class ABGP_PlayerStateCS : ABGPPlayerState
---@field ActorCompContainerCS UActorCompContainerCS
ABGP_PlayerStateCS = {}

---@param EndPlayReason EEndPlayReason::Type
function ABGP_PlayerStateCS:ReceiveEndPlay(EndPlayReason) end
function ABGP_PlayerStateCS:ReceiveDestroyed() end
function ABGP_PlayerStateCS:PostInitializeComponentsCS() end


---@class ABGP_ReplayPlayerController : ABGP_PlayerControllerCS
ABGP_ReplayPlayerController = {}

function ABGP_ReplayPlayerController:OnRep_PawnCS() end


---@class ABGUActionTriggerActor : ABGUActorBaseCS
---@field ActionTriggerConfigComp UBUS_ActionTriggerConfigComp
ABGUActionTriggerActor = {}



---@class ABGUActorBaseCS : ABGUSimpleActorBaseCS
---@field GuidComp UBUS_GuidComp
---@field SaveInitDataComp UBUS_SaveInitDataComp
---@field ActorConfigInfoComp UBUS_ActorConfigInfoComp
ABGUActorBaseCS = {}

---@param EndPlayReason EEndPlayReason::Type
function ABGUActorBaseCS:ReceiveEndPlay(EndPlayReason) end
---@param OutActorGuid FString
---@return boolean
function ABGUActorBaseCS:GetActorGuidCS(OutActorGuid) end
---@param Transform FTransform
function ABGUActorBaseCS:OnConstructionCS(Transform) end


---@class ABGUActorCallerBase : ABGUActorBaseCS
---@field ActorCallComp UBUS_ActorCallComp
ABGUActorCallerBase = {}



---@class ABGUAiWeakInteractionActorBase : ABGUActorBaseCS
---@field DefaultRootComp USceneComponent
---@field AiWeakInteractComp UBUS_AiWeakInteractComp
---@field InteractRangeDebugComp UBGUDebugSectorComponent
ABGUAiWeakInteractionActorBase = {}

---@param Transform FTransform
function ABGUAiWeakInteractionActorBase:OnConstructionCS(Transform) end


---@class ABGUAreaBase : ABGUActorBaseCS
---@field Root USceneComponent
---@field AreaType_ForView AreaType
---@field ExtAbilityMask FAreaAbilityMask
---@field BasicConfigInfoComp UBUS_AreaConfigInfoComp
---@field bAutoEnableOverlap boolean
ABGUAreaBase = {}

function ABGUAreaBase:BeginPlayCS() end
---@param EndPlayReason EEndPlayReason::Type
function ABGUAreaBase:ReceiveEndPlay(EndPlayReason) end
---@param Transform FTransform
function ABGUAreaBase:OnConstructionCS(Transform) end


---@class ABGUAudioEmitter : ABGUActorBaseCS
---@field Root USceneComponent
---@field Spline USplineComponent
---@field AkComponent UAkComponent
---@field AudioEmitterEditComp UBUS_AudioEmitterEditComp
ABGUAudioEmitter = {}



---@class ABGUAudioTriggerActor : ABGUActorBaseCS
---@field AudioTriggerComp UBUS_AudioTriggerComp
---@field AudioTriggerConfigComp UBUS_AudioTriggerConfigComp
ABGUAudioTriggerActor = {}



---@class ABGUAutoCloudMoveArea : ABGUAreaBase
---@field AutoCloudMoveAreaConfigComp UBUS_AutoCloudMoveAreaConfigComp
ABGUAutoCloudMoveArea = {}



---@class ABGUBattleFieldPerformanceOptArea : ABGUAreaBase
ABGUBattleFieldPerformanceOptArea = {}


---@class ABGUBattlePaceSpawnPointActor : AActor
ABGUBattlePaceSpawnPointActor = {}


---@class ABGUBattleSC : ABGUActorBaseCS
---@field MessageDistributionCenter UBUS_MessageDistributionCenter
ABGUBattleSC = {}



---@class ABGUBattleTriggerActor : ABGUActorBaseCS
---@field BattleTriggerConfigComp UBUS_BattleTriggerConfigComp
ABGUBattleTriggerActor = {}



---@class ABGUBuffTriggerActor : ABGUActorBaseCS
---@field BuffTriggerConfigComp UBUS_BuffTriggerConfigComp
ABGUBuffTriggerActor = {}



---@class ABGUBuffTriggerArea : ABGUAreaBase
---@field BuffTriggerAreaConfigComp UBUS_BuffTriggerAreaConfigComp
ABGUBuffTriggerArea = {}



---@class ABGUBulletBaseCS : ABGUProjectileBaseActor
---@field AttachBoneName FString
ABGUBulletBaseCS = {}

function ABGUBulletBaseCS:BulletDataMigrateTool() end


---@class ABGUBulletBaseManaged : ABGUBulletBaseCS
---@field Datas TArray<UObject>
ABGUBulletBaseManaged = {}



---@class ABGUCameraActor : ACameraActor
ABGUCameraActor = {}

---@param EndPlayReason EEndPlayReason::Type
function ABGUCameraActor:ReceiveEndPlay(EndPlayReason) end
function ABGUCameraActor:ReceiveBeginPlay() end


---@class ABGUCameraRig_Crane : ACameraRig_Crane
ABGUCameraRig_Crane = {}

---@param EndPlayReason EEndPlayReason::Type
function ABGUCameraRig_Crane:ReceiveEndPlay(EndPlayReason) end
function ABGUCameraRig_Crane:ReceiveBeginPlay() end


---@class ABGUCameraRig_Rail : ACameraRig_Rail
ABGUCameraRig_Rail = {}

---@param EndPlayReason EEndPlayReason::Type
function ABGUCameraRig_Rail:ReceiveEndPlay(EndPlayReason) end
function ABGUCameraRig_Rail:ReceiveBeginPlay() end


---@class ABGUChapterActor : AActor
---@field IsCheckBorder boolean
---@field CameraShake TSubclassOf<UCameraShakeBase>
---@field CameraShakeScaleBase float
---@field CameraRoamPowerMax float
---@field CameraRoamPowerCoe float
---@field CameraRoamPowerCoe_Gamepad float
---@field CameraScalePowerCoe float
---@field CameraRoamAccelerationCoe float
---@field CameraRoamDecelerationCoe float
---@field CameraBorderDecelerationCoe float
---@field CameraRoamPowerDirSpeed float
---@field CameraScaleMin FVector
---@field CameraScaleMax FVector
---@field FocusDistaceBase float
---@field BorderMap TMap<FName, float>
---@field CheckCameraRoamBorderDis float
---@field CameraLightRandomRange FVector2D
---@field CameraLightBase float
---@field CameraLightRandomTime float
---@field StayTimeBeforeNear float
---@field NearDistance float
---@field NearSpeed float
ABGUChapterActor = {}



---@class ABGUChapterCameraActor : AActor
---@field SceneRoot USphereComponent
---@field CameraBoom1 UBUS_SpringArmComponent
---@field BoomPerformance USceneComponent
---@field FollowCamera UCineCameraComponent
---@field FollowPoint UPointLightComponent
---@field CameraLineTraceDistance float
ABGUChapterCameraActor = {}



---@class ABGUChapterSurpriseActor : AActor
---@field DefaultRootComp USceneComponent
---@field ActiveDebugComp UBGUDebugCircleComponent
---@field InteractDebugComp UBGUDebugCircleComponent
---@field SurpriseID int32
---@field CameraStartTransform FTransform
---@field CameraTargetTransform FTransform
---@field CameraBlendTime float
---@field CameraBlendFunction EEasingFunc::Type
---@field CameraBlendExp float
---@field AudioEvent UAkAudioEvent
ABGUChapterSurpriseActor = {}

function ABGUChapterSurpriseActor:OnConstructionCS() end
---@param DeltaSeconds float
function ABGUChapterSurpriseActor:ReceiveTick(DeltaSeconds) end


---@class ABGUCharacterCS : ABGUCharacter
---@field ActorCompContainerCS UActorCompContainerCS
ABGUCharacterCS = {}

---@param OutActorGuid FString
---@return boolean
function ABGUCharacterCS:GetActorGuidCS(OutActorGuid) end
---@param EndPlayReason EEndPlayReason::Type
function ABGUCharacterCS:ReceiveEndPlay(EndPlayReason) end
function ABGUCharacterCS:ReceiveBeginPlay() end
function ABGUCharacterCS:ReceiveDestroyed() end
---@param Connection UNetConnection
function ABGUCharacterCS:OnActorChannelOpen(Connection) end
---@return boolean
function ABGUCharacterCS:IsPlayerCharacterCS() end
function ABGUCharacterCS:PostNetReceiveRoleCS() end
---@return APlayerController
function ABGUCharacterCS:GetGSAuthorityPlayerCS() end
---@param PrevMovementMode EMovementMode
---@param NewMovementMode EMovementMode
---@param PrevCustomMode uint8
---@param NewCustomMode uint8
function ABGUCharacterCS:OnMovementModeChangedCS(PrevMovementMode, NewMovementMode, PrevCustomMode, NewCustomMode) end
function ABGUCharacterCS:PostInitializeComponentsCS() end
function ABGUCharacterCS:PreDestroyFromReplicationCS() end


---@class ABGUCineCameraActor : ACineCameraActor
ABGUCineCameraActor = {}

---@param EndPlayReason EEndPlayReason::Type
function ABGUCineCameraActor:ReceiveEndPlay(EndPlayReason) end
function ABGUCineCameraActor:ReceiveBeginPlay() end


---@class ABGUCloudMoveRestrictArea : ABGUAreaBase
---@field CloudMoveRestrictAreaConfigComp UBUS_CloudMoveRestrictAreaConfigComp
ABGUCloudMoveRestrictArea = {}



---@class ABGUCloudMoveTriggerArea : ABGUAreaBase
---@field CloudMoveTriggerAreaConfigComp UBUS_CloudMoveTriggerAreaConfigComp
ABGUCloudMoveTriggerArea = {}



---@class ABGUCollectionActorCS : ABGUCollectionBase
ABGUCollectionActorCS = {}


---@class ABGUCollectionBase : ABGUInteractiveActorBase
---@field CollectionConfigComp UBUS_CollectionConfigComp
ABGUCollectionBase = {}



---@class ABGUCricketMgrActor : ABGUActorBaseCS
---@field CricketMgrConfigComp UBUS_CricketMgrConfigComp
ABGUCricketMgrActor = {}



---@class ABGUCutDeathActor : ABGUActorBaseCS
---@field CapsuleComp UCapsuleComponent
---@field EffectAttackSocket FName
ABGUCutDeathActor = {}

---@param OwnerChar ABGUCharacterCS
function ABGUCutDeathActor:PreviewPhy(OwnerChar) end


---@class ABGUDMCCameraBase : ABGU3rdCameraBase
ABGUDMCCameraBase = {}


---@class ABGUDamageCaster : ABGUActorBaseCS
ABGUDamageCaster = {}


---@class ABGUDeadZone : ABGUAreaBase
ABGUDeadZone = {}


---@class ABGUDebugNiaActor : ABGUActorBaseCS
ABGUDebugNiaActor = {}


---@class ABGUDecalActor : ABGUFXActorBase
---@field RootComp USceneComponent
---@field DecalComp UDecalComponent
---@field DecalConfigComp UBUS_DecalConfigComp
ABGUDecalActor = {}



---@class ABGUDestructibleActorBase : ABGUFXActorBase
---@field RootScaleFactor float
ABGUDestructibleActorBase = {}

function ABGUDestructibleActorBase:DisableCollision() end
function ABGUDestructibleActorBase:InitDestructedEffect() end
---@param SinkDelay float
---@param SinkVelocity float
---@param AtkActor AActor
function ABGUDestructibleActorBase:PlayDestructedEffect(SinkDelay, SinkVelocity, AtkActor) end
function ABGUDestructibleActorBase:ResetDestructedEffect() end
---@param DeltaSeconds float
function ABGUDestructibleActorBase:ReceiveTick(DeltaSeconds) end


---@class ABGUDialogueProxyActor : ABGUSimpleActorBaseCS
---@field AkComp UAkComponent
ABGUDialogueProxyActor = {}

---@param Transform FTransform
function ABGUDialogueProxyActor:OnConstructionCS(Transform) end


---@class ABGUDispInteractActor : ABGUActorBaseCS
---@field AttachTo AActor
---@field InteractDrawConfigComp UBUS_InteractDrawConfigComp
ABGUDispInteractActor = {}

function ABGUDispInteractActor:BeginPlayCS() end


---@class ABGUDispInteractAreaVolume : ABGUActorBaseCS
---@field DispInteractAreaVolume UBoxComponent
---@field LandscapeMaxHeight float
---@field Landscape ALandscape
---@field WeightLayerName FString
---@field SimulationSize_cm float
---@field InteractiveData_StorageSize_cm float
---@field InteractDistLimitToDispActor float
---@field NS_Landscape_Interactive_Particles UNiagaraSystem
---@field NS_Landscape_Interactive_Simulator UNiagaraSystem
---@field LS_HeightMap UTexture2D
---@field LS_WeightMap UTexture2D
---@field MinX int32
---@field MinY int32
---@field MaxX int32
---@field MaxY int32
---@field LandscapeOriginOffset FVector
ABGUDispInteractAreaVolume = {}

function ABGUDispInteractAreaVolume:UpdateLandScapeInfo() end
function ABGUDispInteractAreaVolume:BeginPlayCS() end


---@class ABGUDropItemActor : ABGUInteractiveActorBase
ABGUDropItemActor = {}


---@class ABGUDropItemActorCS : ABGUDropItemActor
---@field DropItemComp UBUS_DropItemComp
ABGUDropItemActorCS = {}

---@param FloatParam float
function ABGUDropItemActorCS:DropItemBPFunc(FloatParam) end
function ABGUDropItemActorCS:OnPlayDropEffect() end


---@class ABGUDroppableDestructionActorBase : ABGUInteractiveActorBase
---@field DestructibleConfigComp UBUS_DestructibleConfigComp
---@field FXAudioEditComp UBUS_FXAudioEditComp
ABGUDroppableDestructionActorBase = {}

---@param ParamName FName
---@param FloatValue float
function ABGUDroppableDestructionActorBase:SetFloatValueToMaterialAdvect(ParamName, FloatValue) end


---@class ABGUDroppedItemManagerActor : ABGUActorBaseCS
---@field DroppedItemManagerConfigComp UBUS_DroppedItemManagerConfigComp
ABGUDroppedItemManagerActor = {}



---@class ABGUDumperTruckTriggerActor : ABGUActorBaseCS
---@field TriggerBox UBoxComponent
---@field EndTriggerBox UBoxComponent
---@field DumperTruckTriggerConfigComp UBUS_DumperTruckTriggerConfigComp
ABGUDumperTruckTriggerActor = {}



---@class ABGUDynamicObstacleBase : ABGUActorBaseCS
---@field DynamicObstacleConfigComp UBUS_DynamicObstacleConfigComp
ABGUDynamicObstacleBase = {}



---@class ABGUDynamicSDFGenerator : ABGUActorBaseCS
---@field DefaultRootComp USceneComponent
---@field AttachTo AActor
---@field NS_DynamicSDF_Generator UNiagaraComponent
ABGUDynamicSDFGenerator = {}

function ABGUDynamicSDFGenerator:BeginPlayCS() end


---@class ABGUDynamicSDFGenerator2 : AGSDynamicSDFInitializer
---@field AttachTo AActor
ABGUDynamicSDFGenerator2 = {}

---@param DeltaTime float
function ABGUDynamicSDFGenerator2:ReceiveTick(DeltaTime) end
function ABGUDynamicSDFGenerator2:ReceiveBeginPlay() end


---@class ABGUEnvironmentControllerBase : ABGUActorBaseCS
ABGUEnvironmentControllerBase = {}


---@class ABGUEnvironmentItemStateMachineActor : ABGUEnvironmentItemStateMachineActorBase
---@field EnvironmentItemStateMachineComp UBUS_EnvironmentItemStateMachineComp
---@field TriggerBox UBoxComponent
---@field ExtAbilityMask FEnvironmentItemStateMachineExtAbilityMask
ABGUEnvironmentItemStateMachineActor = {}



---@class ABGUEnvironmentItemStateMachineActorBase : ABGUActorBaseCS
ABGUEnvironmentItemStateMachineActorBase = {}

function ABGUEnvironmentItemStateMachineActorBase:OnGSReset() end
function ABGUEnvironmentItemStateMachineActorBase:OnEnableOverlap() end
function ABGUEnvironmentItemStateMachineActorBase:OnDisableOverlap() end
---@param OtherActor AActor
function ABGUEnvironmentItemStateMachineActorBase:OnCollisionEndOverlap(OtherActor) end
function ABGUEnvironmentItemStateMachineActorBase:OnResetToOverlapEnable() end
function ABGUEnvironmentItemStateMachineActorBase:OnResetToOverlapDisable() end
---@param OtherActor AActor
function ABGUEnvironmentItemStateMachineActorBase:OnCollisionBeginOverlap(OtherActor) end
---@param AkComp UAkComponent
---@param AkEvent UAkAudioEvent
---@return int32
function ABGUEnvironmentItemStateMachineActorBase:PlayAkEventWithDialogue(AkComp, AkEvent) end


---@class ABGUEnvironmentSurfaceEffectMgr : AEnvironmentSurfaceEffectMgr
ABGUEnvironmentSurfaceEffectMgr = {}

---@param DeltaSeconds float
function ABGUEnvironmentSurfaceEffectMgr:ReceiveTick(DeltaSeconds) end
---@param EndPlayReason EEndPlayReason::Type
function ABGUEnvironmentSurfaceEffectMgr:ReceiveEndPlay(EndPlayReason) end
function ABGUEnvironmentSurfaceEffectMgr:ReceiveDestroyed() end
function ABGUEnvironmentSurfaceEffectMgr:ReceiveBeginPlay() end


---@class ABGUEquipPreviewActorBase : ABGUActorBaseCS
---@field Mesh USkeletalMeshComponent
---@field CharacterModularComp UBUS_CharacterModularComp
---@field Datas TArray<UObject>
ABGUEquipPreviewActorBase = {}

---@param Transform FTransform
function ABGUEquipPreviewActorBase:OnConstructionCS(Transform) end


---@class ABGUFXActorBase : ABGUActorBaseCS
---@field Root USceneComponent
---@field FXActorBaseConfigComp UBUS_FXActorBaseConfigComp
---@field DestructibleConfigComp UBUS_DestructibleConfigComp
---@field FXAudioEditComp UBUS_FXAudioEditComp
ABGUFXActorBase = {}

---@return boolean
function ABGUFXActorBase:IsDead() end
---@param HitLocation FVector
---@param ImpulseDir FVector
---@param ImpulseStrength float
---@param Damage float
function ABGUFXActorBase:OnHitDestructible(HitLocation, ImpulseDir, ImpulseStrength, Damage) end
---@param IsDestroyed boolean
function ABGUFXActorBase:OnResetDestructible(IsDestroyed) end
---@param HitLocation FVector
---@param ImpulseDir FVector
---@param ImpulseStrength float
---@param Damage float
function ABGUFXActorBase:OnDestroyDestructible(HitLocation, ImpulseDir, ImpulseStrength, Damage) end
---@param ParamName FName
---@param FloatValue float
function ABGUFXActorBase:SetFloatValueToMaterialAdvect(ParamName, FloatValue) end
function ABGUFXActorBase:ReceiveBeginPlay() end


---@class ABGUFXAnimalActor : ABGUActorBaseCS
---@field Root USceneComponent
---@field NiagaraComp UNiagaraComponent
---@field TriggerBox UBoxComponent
---@field FXAnimalConfigComp UBUS_FXAnimalEditComp
ABGUFXAnimalActor = {}



---@class ABGUFixCameraTriggerActor : ABGUActorBaseCS
---@field FixCameraTriggerConfigComp UBUS_FixCameraTriggerConfigComp
ABGUFixCameraTriggerActor = {}



---@class ABGUForceFightController : ABGUAreaBase
---@field ForceFightControllerConfigComp UBUS_ForceFightControllerConfigComp
ABGUForceFightController = {}



---@class ABGUForceOriginalFormOuterTriggerArea : ABGUAreaBase
ABGUForceOriginalFormOuterTriggerArea = {}


---@class ABGUForceOriginalFormTriggerArea : ABGUAreaBase
---@field ForceOriginalFormAreaConfigComp UBUS_ForceOriginalFormAreaConfigComp
ABGUForceOriginalFormTriggerArea = {}



---@class ABGUForceOriginalFormTriggerBoxActor : ABGUActorBaseCS
---@field ForceOriginalFormTriggerBox UBoxComponent
---@field ForceOriginalFormConfigComp UBUS_ForceOriginalFormConfigComp
ABGUForceOriginalFormTriggerBoxActor = {}



---@class ABGUGamePlusSpawnActor : ABGUActorBaseCS
---@field GamePlusSpawnConfigComp UBUS_GamePlusSpawnComp
ABGUGamePlusSpawnActor = {}



---@class ABGUGateStateMachineActor : ABGUActorBaseCS
---@field GateStateMachineConfigComp UBUS_GateStateMachineConfigComp
ABGUGateStateMachineActor = {}

function ABGUGateStateMachineActor:OnGateOpen() end
function ABGUGateStateMachineActor:OnGateClose() end
function ABGUGateStateMachineActor:OnResetToGateOpen() end
function ABGUGateStateMachineActor:OnResetToGateClose() end


---@class ABGUGateStateMachineRootActor : ABGUGateStateMachineActor
---@field DefaultRootComp USceneComponent
ABGUGateStateMachineRootActor = {}



---@class ABGUGhostActorBase : ABGUActorBaseCS
---@field PoseableMeshComp UPoseableMeshComponent
ABGUGhostActorBase = {}



---@class ABGUGroupAIArea : ABGUAreaBase
---@field GroupAIAreaConfigInfoComp UBUS_GroupAIAreaConfigInfoComp
ABGUGroupAIArea = {}



---@class ABGUGroupAIAreaActorBase : ABGUActorBaseCS
---@field GroupAIAreaComp UBUS_GroupAIAreaComp
---@field BoxCollisionComponent UBoxComponent
ABGUGroupAIAreaActorBase = {}



---@class ABGUInteractiveActorBase : ABGUActorBaseCS
---@field DefaultRootComp USceneComponent
---@field InteractComp UBUS_InteractComp
---@field InteractRangeDebugComp UBGUDebugSectorComponent
---@field InteractRangeDebugComp2 UBGUDebugSectorComponent
---@field InteractRangeDebugComp3 UBGUDebugSectorComponent
ABGUInteractiveActorBase = {}

function ABGUInteractiveActorBase:CallBPFunc() end
---@param HitLocation FVector
---@param ImpulseDir FVector
---@param ImpulseStrength float
---@param Damage float
function ABGUInteractiveActorBase:OnHitDestructible(HitLocation, ImpulseDir, ImpulseStrength, Damage) end
---@param IsDestroyed boolean
function ABGUInteractiveActorBase:OnResetDestructible(IsDestroyed) end
---@param HitLocation FVector
---@param ImpulseDir FVector
---@param ImpulseStrength float
---@param Damage float
function ABGUInteractiveActorBase:OnDestroyDestructible(HitLocation, ImpulseDir, ImpulseStrength, Damage) end
function ABGUInteractiveActorBase:RefreshInteractDebugRange() end
---@param Transform FTransform
function ABGUInteractiveActorBase:OnConstructionCS(Transform) end


---@class ABGUIntervalArea : ABGUAreaBase
---@field WanderBGMAreaConfigComp UBUS_WanderBGMAreaConfigComp
---@field IntervalTriggerConfigComp UBUS_IntervalTriggerConfigComp
ABGUIntervalArea = {}



---@class ABGUIntervalTriggerArea : ABGUAreaBase
---@field IntervalTriggerAreaConfigComp UBUS_IntervalTriggerAreaConfigComp
ABGUIntervalTriggerArea = {}



---@class ABGUItemInteractArea_CPU : ABGUActorBaseCS
---@field AreaBox UBoxComponent
---@field GridUnitLength int32
---@field ItemList TArray<AActor>
ABGUItemInteractArea_CPU = {}

function ABGUItemInteractArea_CPU:BeginPlayCS() end


---@class ABGUJJSObstacleBase : ABGUActorBaseCS
---@field DefaultRootComp USceneComponent
---@field JJSObstacleConfigComp UBUS_JJSObstacleConfigComp
ABGUJJSObstacleBase = {}



---@class ABGULandingZoneActor : ABGU_EQSPointRecorderActor
ABGULandingZoneActor = {}


---@class ABGULandscapeReaderActor : ABGUActorBaseCS
---@field LandscapeProxy ALandscapeProxy
---@field LandscapeReader ULandscapeReader
ABGULandscapeReaderActor = {}

function ABGULandscapeReaderActor:CacheLandscapeData() end


---@class ABGULightningFXActorBase : ABGUFXActorBase
---@field LightningFXSpawnComp UBUS_LightningFXSpawnComp
ABGULightningFXActorBase = {}



---@class ABGUMagicFieldBaseCS : ABGUProjectileBaseActor
ABGUMagicFieldBaseCS = {}

function ABGUMagicFieldBaseCS:MagicFieldDataMigrateTool() end


---@class ABGUMagicFieldBaseManaged : ABGUMagicFieldBaseCS
---@field Datas TArray<UObject>
ABGUMagicFieldBaseManaged = {}



---@class ABGUManualSplineMoveVolume : ABGUActorBaseCS
---@field ManualSplineMoveVolumeComp UBUS_ManualSplineMoveVolumeComp
---@field BoxCollisionComponent UBoxComponent
ABGUManualSplineMoveVolume = {}



---@class ABGUMedicineBasketActor : ABGUInteractiveActorBase
ABGUMedicineBasketActor = {}


---@class ABGUMeditationPointBase : ABGUInteractiveActorBase
---@field MeditationPointConfigComp UBUS_MeditationPointConfigComp
ABGUMeditationPointBase = {}

function ABGUMeditationPointBase:ReceiveBeginPlay() end


---@class ABGUModularMgrActor : ABGUActorBaseCS
---@field ModularMgrConfigComp UBUS_ModularMgrConfigComp
---@field SpawnedModularActors TArray<AActor>
---@field ModularMeshes TMap<UObject, FString>
ABGUModularMgrActor = {}

function ABGUModularMgrActor:SpawnModularActors() end
function ABGUModularMgrActor:ReceiveDestroyed() end


---@class ABGUNameTriggerActorBase : ABGUActorBaseCS
---@field NameTriggerConfigComp UBUS_NameTriggerConfigComp
ABGUNameTriggerActorBase = {}



---@class ABGUNarrator : ABGUActorBaseCS
---@field AkComp UAkComponent
ABGUNarrator = {}



---@class ABGUNetDefaultEmptyActor : ABGUCharacter
---@field ActorCompContainerCS UActorCompContainerCS
ABGUNetDefaultEmptyActor = {}

---@param DeltaSeconds float
function ABGUNetDefaultEmptyActor:ReceiveTick(DeltaSeconds) end
---@param NewController AController
function ABGUNetDefaultEmptyActor:OnPossessedCS(NewController) end
---@param Transform FTransform
function ABGUNetDefaultEmptyActor:OnConstructionCS(Transform) end
function ABGUNetDefaultEmptyActor:ReceiveBeginPlay() end
function ABGUNetDefaultEmptyActor:PostInitializeComponentsCS() end


---@class ABGUNeutralAnimalSpawnArea : ABGUAreaBase
---@field NeutralAnimalAreaConfigInfoComp UBUS_NeutralAnimalAreaConfigInfoComp
---@field TerritoryInfos TMap<FString, FNeutralAnimalTerritoryInfo>
---@field PreviewActor TSubclassOf<AActor>
---@field PresetPoints_EQS UEnvQuery
---@field QueryConfig TArray<FGSEnvNamedValue>
---@field GeneratedEQSActors TArray<TSoftObjectPtr<AActor>>
---@field CustomAddingActors TArray<TSoftObjectPtr<AActor>>
ABGUNeutralAnimalSpawnArea = {}

function ABGUNeutralAnimalSpawnArea:ReceiveDestroyed() end


---@class ABGUNeutralFXAnimalSpawnPoint : ABGUActorBaseCS
---@field Root USceneComponent
---@field ConfigComp UBUS_NeutralFXAnimalSpawnConfigComp
---@field TriggerBox UBoxComponent
---@field TriggerBox_OutSide UBoxComponent
ABGUNeutralFXAnimalSpawnPoint = {}



---@class ABGUOnFightTriggerActorBase : ABGUActorBaseCS
---@field OnFightTriggerConfigComp UBUS_OnFightTriggerConfigComp
ABGUOnFightTriggerActorBase = {}



---@class ABGUOnlineAssistTriggerActorBase : ABGUActorBaseCS
---@field OnlineAssistTriggerConfig UBUS_OnlineAssistTriggerConfigComp
ABGUOnlineAssistTriggerActorBase = {}



---@class ABGUOverlapArea : ABGUAreaBase
ABGUOverlapArea = {}


---@class ABGUPOMDecalActor : ABGUDecalActor
ABGUPOMDecalActor = {}

---@param Transform FTransform
function ABGUPOMDecalActor:OnConstructionCS(Transform) end


---@class ABGUPerformerActorCS : ABGUPerformerActor
---@field DataComp UActorDataContainer
---@field ActorCompContainerCS UActorCompContainerCS
---@field GuidComp UBUS_GuidComp
---@field ActorConfigInfoComp UBUS_ActorConfigInfoComp
---@field AudioEditComp UBUS_AudioEditComp
---@field CharacterModularComp UBUS_CharacterModularComp
---@field ConfigInfoComp UBUS_SeqPerformerConfigInfoComp
---@field bPlayerPerformer boolean
---@field bSupportAIConversation boolean
ABGUPerformerActorCS = {}

---@param EquipID int32
function ABGUPerformerActorCS:EquipFinish(EquipID) end
function ABGUPerformerActorCS:BeginPlayCS() end
---@param OutActorGuid FString
---@return boolean
function ABGUPerformerActorCS:GetActorGuidCS(OutActorGuid) end
---@param Transform FTransform
function ABGUPerformerActorCS:OnConstructionCS(Transform) end
function ABGUPerformerActorCS:PostInitializeComponentsCS() end


---@class ABGUPerformerController : ABGUActorBaseCS
---@field ConfigComp UBGUPerformerControlConfigComp
ABGUPerformerController = {}



---@class ABGUPlaceholderActorBase : ABGUSimpleActorBaseCS
---@field PlaceholderActorConfig UBUS_PlaceholderActorConfigComp
ABGUPlaceholderActorBase = {}



---@class ABGUPlayerCharacterCS : ABGU_CharacterAI
---@field CameraBoom1 UBUS_SpringArmComponent
---@field FollowCamera UCameraComponent
---@field ApproachNotifyComp USphereComponent
---@field PlayerInputComponent UInputComponent
---@field ParkourMoveComp UBUS_ParkourMoveComp
---@field PlayerConfigInfoComp UBUS_ConfigInfoComp
---@field PlayerExtendConfigComp UBUS_ExtendConfigComp
---@field CharacterModularComp UBUS_CharacterModularComp
ABGUPlayerCharacterCS = {}

---@param NewController AController
function ABGUPlayerCharacterCS:OnPossessedCS(NewController) end
---@param EndPlayReason EEndPlayReason::Type
function ABGUPlayerCharacterCS:ReceiveEndPlay(EndPlayReason) end
---@param Transform FTransform
function ABGUPlayerCharacterCS:OnConstructionCS(Transform) end
function ABGUPlayerCharacterCS:ReceiveBeginPlay() end
---@return boolean
function ABGUPlayerCharacterCS:IsPlayerCharacterCS() end
function ABGUPlayerCharacterCS:OnRep_PlayerStateCS() end
---@param PlayerInputComponent UInputComponent
function ABGUPlayerCharacterCS:SetupPlayerInputComponentCS(PlayerInputComponent) end


---@class ABGUPreloadContainerActor : AActor
ABGUPreloadContainerActor = {}


---@class ABGUPreviewFXActor : ABGUActorBaseCS
ABGUPreviewFXActor = {}


---@class ABGUProceduralEnvInteractionActor : ABGUActorBaseCS
---@field ProceduralEnvInteractionConfigComp UBUS_ProceduralEnvInteractionConfigComp
ABGUProceduralEnvInteractionActor = {}



---@class ABGUProceduralMapGenerator : ABGUActorBaseCS
---@field ProceduralMapDataConfigComp UBUS_ProceduralMapGeneratorDataConfigComp
ABGUProceduralMapGenerator = {}

---@param ID int32
---@param Linkage int32
function ABGUProceduralMapGenerator:OnProceduralStreamLevelLoaded(ID, Linkage) end


---@class ABGUProceduralSpawnCharacterBase : ABGUActorBaseCS
---@field ProceduralSpawnCharacterDataConfigComp UBUS_ProceduralSpawnCharacterDataConfigComp
ABGUProceduralSpawnCharacterBase = {}

---@param Transform FTransform
function ABGUProceduralSpawnCharacterBase:OnConstructionCS(Transform) end


---@class ABGUProceduralSpawnCharacterManaged : ABGUProceduralSpawnCharacterBase
---@field Datas TArray<UObject>
ABGUProceduralSpawnCharacterManaged = {}



---@class ABGUProceduralSpawnSceneItemBase : ABGUActorBaseCS
---@field ProceduralSpawnSceneItemDataConfigComp UBUS_ProceduralSpawnSceneItemDataConfigComp
ABGUProceduralSpawnSceneItemBase = {}

---@param Transform FTransform
function ABGUProceduralSpawnSceneItemBase:OnConstructionCS(Transform) end


---@class ABGUProjectileBaseActor : ABGUSimpleActorBaseCS
---@field ProjectileMovement UBGUProjectileMovementComponent
---@field SphereCollisionComp USphereComponent
---@field BoxCollisionComp UBoxComponent
---@field CapsuleCollisionComp UCapsuleComponent
---@field CustomCollisionComp UStaticMeshComponent
---@field LineTraceStartPoint USceneComponent
---@field StaticComp UStaticMeshComponent
---@field Interact_Start USphereComponent
---@field Interact_End USphereComponent
---@field ProjectileConfigInfoComp UBUS_ProjectileConfigInfoComp
ABGUProjectileBaseActor = {}

function ABGUProjectileBaseActor:OnDead() end
function ABGUProjectileBaseActor:SwitchPre() end
---@param HitActor AActor
---@param HitTransform FTransform
function ABGUProjectileBaseActor:OnDrawSign(HitActor, HitTransform) end
function ABGUProjectileBaseActor:SwitchBegin() end
---@param ProjectileSpawnEventInfo FProjectileSpawnEventInfo
function ABGUProjectileBaseActor:SpawnFinished(ProjectileSpawnEventInfo) end
function ABGUProjectileBaseActor:SwitchFinished() end
---@return int32
function ABGUProjectileBaseActor:GetProjectileID() end
---@return UBGUProjectileMovementComponent
function ABGUProjectileBaseActor:GetProjectileMovement() end
---@param HitActor AActor
---@return boolean
function ABGUProjectileBaseActor:CheckDrawSignCondition(HitActor) end
function ABGUProjectileBaseActor:BeginPlayCS() end
---@return int32
function ABGUProjectileBaseActor:GetStaticMeshCompChildsNum() end
---@param Transform FTransform
function ABGUProjectileBaseActor:OnConstructionCS(Transform) end
---@return boolean
function ABGUProjectileBaseActor:ProjectileAbilityCheck_ByBPConfig() end


---@class ABGUProjectileSpawnPreviewActor : ABGUPlacedEditorUtilityBase
---@field CharacterMesh USkeletalMeshComponent
---@field DefaultSpawnPos USceneComponent
---@field TargetPos USceneComponent
---@field ProjectileSpawnConfig UBGWDataAsset_ProjectileSpawnConfig
---@field DrawOnce boolean
---@field EnableDebugTick boolean
---@field DrawDebugLength float
---@field DrawDebugDuration float
---@field DrawDebugTickness float
---@field ArrowSize float
---@field ProjectileSize float
---@field SphereSegment int32
---@field SphereColor FLinearColor
ABGUProjectileSpawnPreviewActor = {}

---@param DeltaSeconds float
function ABGUProjectileSpawnPreviewActor:ReceiveTick(DeltaSeconds) end


---@class ABGURebirthPointBase : ABGUInteractiveActorBase
---@field RebirthPointConfigComp UBUS_RebirthPointConfigComp
ABGURebirthPointBase = {}



---@class ABGURideControlTriggerActor : ABGUActorBaseCS
ABGURideControlTriggerActor = {}


---@class ABGURuntimeMeshActor : AActor
ABGURuntimeMeshActor = {}

---@param PlanePosition FVector
---@param PlaneNormal FVector
---@param ApplyForce float
function ABGURuntimeMeshActor:OnSliceRuntimeMesh(PlanePosition, PlaneNormal, ApplyForce) end
function ABGURuntimeMeshActor:ReceiveBeginPlay() end


---@class ABGUSDFMaker : ABGUActorBaseCS
---@field RootComp USceneComponent
---@field Interact_1 USphereComponent
---@field Interact_2 USphereComponent
ABGUSDFMaker = {}



---@class ABGUSafeLandArea : ABGUAreaBase
ABGUSafeLandArea = {}


---@class ABGUSafeLandVolume : ABGUActorBaseCS
---@field SafeLandBox UBoxComponent
ABGUSafeLandVolume = {}

function ABGUSafeLandVolume:BeginPlayCS() end


---@class ABGUSceneInactiveActorBase : AActor
---@field SceneInactiveActorComp UBUS_SceneInactiveActorComp
ABGUSceneInactiveActorBase = {}



---@class ABGUSceneItemBase : ABGUActorBaseCS
---@field StaticMeshComp UStaticMeshComponent
---@field SceneItemCommComp UBUS_SceneItemCommComp
---@field SphereCollisionComp USphereComponent
---@field BoxCollisionComp UBoxComponent
---@field CapsuleCollisionComp UCapsuleComponent
ABGUSceneItemBase = {}

function ABGUSceneItemBase:BeginPlayCS() end


---@class ABGUSceneRotateTriggerArea : ABGUAreaBase
---@field SceneRotateTriggerConfigComp UBUS_SceneRotateTriggerConfigComp
ABGUSceneRotateTriggerArea = {}



---@class ABGUSelectAreaActor : ABGUActorBaseCS
---@field BoxArea UBoxComponent
ABGUSelectAreaActor = {}



---@class ABGUSeqAKBActor : ALevelSequenceActor
---@field DefaultEasingTime float
---@field DefaultEasingFunc EEasingFunc::Type
---@field DefaultEasingBlendExp float
---@field DefaultEasingSteps int32
---@field DefaultDelayEasingTime float
---@field DefaultEnumValEasingType EGSAnimKBEnumBoolEasing::Type
---@field DefaultBoolValEasingType EGSAnimKBEnumBoolEasing::Type
---@field IsStrictStateMatchCfg boolean
---@field IsAlwaysUsingEndStateAsChanging boolean
---@field GSBlendCfgList TArray<FFGSSeqAnimKeyStateBlendCfg>
---@field GSAnimKeyStateBlenderObj UGSAnimKeyStateBlender
ABGUSeqAKBActor = {}

---@param DeltaSeconds float
function ABGUSeqAKBActor:DoTick(DeltaSeconds) end
function ABGUSeqAKBActor:GSInit() end
---@param TargetState FName
---@param InStateDelayEasingTime float
---@param InStateOverideEasingTime float
function ABGUSeqAKBActor:ToState(TargetState, InStateDelayEasingTime, InStateOverideEasingTime) end
---@param BegineState FName
---@param EndState FName
---@param IsForceImSet boolean
function ABGUSeqAKBActor:OnAKBStateEndFunc(BegineState, EndState, IsForceImSet) end
---@param BegineState FName
---@param EndState FName
---@param IsForceImSet boolean
function ABGUSeqAKBActor:OnAKBStateBeginFunc(BegineState, EndState, IsForceImSet) end
---@param AnimName FString
---@param TargetState FString
---@param InStateDelayEasingTime float
---@param IsForce boolean
function ABGUSeqAKBActor:WoodTestAnimKeyState(AnimName, TargetState, InStateDelayEasingTime, IsForce) end
---@param BegineState FName
---@param EndState FName
---@param IsForceImSet boolean
function ABGUSeqAKBActor:OnAKBStateInteruptFunc(BegineState, EndState, IsForceImSet) end
---@param BindingActorTagName FName
---@param InActor AActor
function ABGUSeqAKBActor:GSBeforeInitAddBindingActor(BindingActorTagName, InActor) end
---@param TargetState FName
---@param PredicCfgEasingTime float
---@param PredicCfgDelayEasingTime float
function ABGUSeqAKBActor:GetPredicToStateCfgEasingTime(TargetState, PredicCfgEasingTime, PredicCfgDelayEasingTime) end


---@class ABGUSequenceBoundingBoxActor : ATriggerBox
---@field SceneRoot USceneComponent
ABGUSequenceBoundingBoxActor = {}



---@class ABGUShadowActorBase : ABGUActorBaseCS
---@field Mesh USkeletalMeshComponent
---@field CharacterModularComp UBUS_CharacterModularComp
ABGUShadowActorBase = {}

---@param Transform FTransform
function ABGUShadowActorBase:OnConstructionCS(Transform) end


---@class ABGUShadowActorStaticBase : ABGUActorBaseCS
---@field BodyMesh UStaticMeshComponent
---@field HeadMesh UStaticMeshComponent
---@field ArmMesh UStaticMeshComponent
---@field FootMesh UStaticMeshComponent
---@field WeaponMesh UStaticMeshComponent
---@field HuluMesh UStaticMeshComponent
---@field TailMesh UStaticMeshComponent
---@field HairMesh UStaticMeshComponent
ABGUShadowActorStaticBase = {}



---@class ABGUSimpleActorBaseCS : ABGUActorBase
---@field DataComp UActorDataContainer
---@field ActorCompContainerCS UActorCompContainerCS
ABGUSimpleActorBaseCS = {}

function ABGUSimpleActorBaseCS:BeginPlayCS() end
---@param EndPlayReason EEndPlayReason::Type
function ABGUSimpleActorBaseCS:ReceiveEndPlay(EndPlayReason) end
function ABGUSimpleActorBaseCS:ReceiveDestroyed() end
function ABGUSimpleActorBaseCS:PostInitializeComponentsCS() end


---@class ABGUSimpleCharacter : ABGUCharacterCS
ABGUSimpleCharacter = {}


---@class ABGUSimpleSplineActor : ABGUActorBaseCS
---@field Root USceneComponent
---@field SplineComp USplineComponent
ABGUSimpleSplineActor = {}



---@class ABGUSkillSelectHelperActor : ABGUActorBaseCS
ABGUSkillSelectHelperActor = {}


---@class ABGUSpawnMultiPointActor : ABGUActorBaseCS
---@field SpawnMultiPointConfigComp UBUS_SpawnMultiPointComp
ABGUSpawnMultiPointActor = {}



---@class ABGUSpecifyRebirthPosArea : ABGUAreaBase
---@field ConfigComp UBUS_SpecifyRebirthPosAreaConfigComp
ABGUSpecifyRebirthPosArea = {}



---@class ABGUSpiderNavPointActor : AActor
---@field Root UStaticMeshComponent
---@field Arrow UArrowComponent
---@field LinkRadius float
---@field LinkAngle float
---@field IsGroundPoint boolean
ABGUSpiderNavPointActor = {}



---@class ABGUSpiderNavigationActor : ABGUActorBaseCS
---@field Root USceneComponent
---@field NavPoints TArray<FGsSpiderNavPointInfo>
ABGUSpiderNavigationActor = {}

function ABGUSpiderNavigationActor:ShowSpiderNavPoint() end
function ABGUSpiderNavigationActor:HideSpiderNavPoint() end
function ABGUSpiderNavigationActor:RecordSpiderNavPoint() end
---@param DeltaSeconds float
function ABGUSpiderNavigationActor:ReceiveTick(DeltaSeconds) end


---@class ABGUSpiderOceanMgrActor : ABGUActorBaseCS
---@field SpiderOceanMgrComp UBUS_SpiderOceanMgrComp
---@field TriggerBox UBoxComponent
ABGUSpiderOceanMgrActor = {}



---@class ABGUSpiderWebActorBase : AActor
---@field WebComp UNiagaraComponent
---@field VisibleDistance int32
ABGUSpiderWebActorBase = {}

function ABGUSpiderWebActorBase:ReceiveData() end
function ABGUSpiderWebActorBase:ReceiveBeginPlay() end


---@class ABGUSplineActor : ABGUActorBaseCS
---@field SplineComp USplineComponent
---@field ProjectionTraceExtent FVector
ABGUSplineActor = {}

function ABGUSplineActor:ProjectPointsToNavigation() end


---@class ABGUSplineFlyMoveTriggerActor : ABGUActorBaseCS
---@field TriggerBox UBoxComponent
---@field EndTriggerBox UBoxComponent
---@field SplineFlyMoveTriggerConfigComp UBUS_SplineFlyMoveTriggerConfigComp
ABGUSplineFlyMoveTriggerActor = {}



---@class ABGUSplineTeleportActor : AActor
---@field SplineActor AActor
---@field CircleIndex int32
ABGUSplineTeleportActor = {}



---@class ABGUStealthTriggerActor : ABGUActorBaseCS
---@field StealthTriggerConfigComp UBUS_StealthTriggerConfigComp
ABGUStealthTriggerActor = {}



---@class ABGUStoryArea : ABGUAreaBase
---@field AreaID int32
---@field Pority int32
ABGUStoryArea = {}



---@class ABGUTakePhotoActor : AActor
---@field SceneRoot UCapsuleComponent
---@field CameraBoom1 UBUS_SpringArmComponent
---@field BoomPerformance USceneComponent
---@field FollowCamera UCineCameraComponent
ABGUTakePhotoActor = {}



---@class ABGUTamerConfigArea : ABGUAreaBase
---@field TamerStrategyArea TamerStrategyArea
ABGUTamerConfigArea = {}



---@class ABGUTaskStageCollectionBase : ABGUInteractiveActorBase
---@field TaskStageCollectionConfigComp UBUS_TaskStageCollectionConfigComp
ABGUTaskStageCollectionBase = {}



---@class ABGUTortoiseLevelStreamingMgrActor : ABGUActorBaseCS
---@field TortoiseLevelStreamingConfigComp UBUS_TortoiseLevelStreamingConfigComp
ABGUTortoiseLevelStreamingMgrActor = {}

function ABGUTortoiseLevelStreamingMgrActor:OnAllSetLevelsStateFinished() end
---@param LevelKeyword FString
---@param LevelState FString
---@param OperationID int32
function ABGUTortoiseLevelStreamingMgrActor:OnSingleSetLevelsStateFinished(LevelKeyword, LevelState, OperationID) end


---@class ABGUTortoiseMoveMgrActor : ABGUActorBaseCS
---@field TortoiseMoveMgrActorConfigComp UBUS_TortoiseMoveMgrActorConfigComp
ABGUTortoiseMoveMgrActor = {}



---@class ABGUTrainDummyMgrActor : ABGUActorBaseCS
---@field ZBBTrainMgrConfigComp UBUS_TrainDummyMgrConfigComp
ABGUTrainDummyMgrActor = {}

function ABGUTrainDummyMgrActor:BeginPlayCS() end


---@class ABGUTransPreviewActorBase : ABGUActorBaseCS
---@field Mesh USkeletalMeshComponent
---@field NormalLight USceneComponent
---@field Light USceneComponent
---@field DefaultRootComp USceneComponent
---@field AttachComp USceneComponent
---@field CharacterModularComp UBUS_CharacterModularComp
---@field Datas TArray<UObject>
ABGUTransPreviewActorBase = {}

---@param Transform FTransform
function ABGUTransPreviewActorBase:OnConstructionCS(Transform) end


---@class ABGUTreeBirdSpawnMgr : ABGUActorBaseCS
---@field Root USceneComponent
---@field ConfigComp UBUS_TreeBirdSpawnMgrConfigComp
---@field DrawDebugTime float
---@field DrawDebugThickness float
ABGUTreeBirdSpawnMgr = {}

function ABGUTreeBirdSpawnMgr:CollectAllTreesInfo() end
function ABGUTreeBirdSpawnMgr:DrawDebug_OnlyInEditor() end


---@class ABGUTriggerObjBase : ABGUInteractiveActorBase
---@field TriggerComp UBUS_TriggerComp
ABGUTriggerObjBase = {}

---@param Transform FTransform
function ABGUTriggerObjBase:OnConstructionCS(Transform) end


---@class ABGUTriggerObjBaseCS : ABGUTriggerObjBase
ABGUTriggerObjBaseCS = {}


---@class ABGUTriggerProcessControllerBase : ABGUActorBaseCS
---@field TriggerProcessControlComp UBUS_TriggerProcessControlComp
ABGUTriggerProcessControllerBase = {}



---@class ABGUUnitTeamMngActor : ABGUActorBaseCS
---@field UnitTeamMngConfigComp UBUS_UnitTeamMngConfigComp
ABGUUnitTeamMngActor = {}



---@class ABGUUpdraftActor : ABGUActorBaseCS
---@field UpdraftVolume UBoxComponent
---@field UpVelocity float
---@field CD float
ABGUUpdraftActor = {}



---@class ABGUUpdraftArea : ABGUAreaBase
---@field UpdraftConfigInfoComp UBUS_UpdraftConfigInfoComp
ABGUUpdraftArea = {}



---@class ABGUWanderBGMArea : ABGUAreaBase
---@field WanderBGMAreaConfigComp UBUS_WanderBGMAreaConfigComp
ABGUWanderBGMArea = {}



---@class ABGUWanderBGMVolumeActor : ABGUActorBaseCS
---@field WanderBGMVolumeComp UBUS_WanderBGMVolumeComp
ABGUWanderBGMVolumeActor = {}



---@class ABGUWeaponBase : ABGUActorBaseCS
---@field DefaultRootComponent USceneComponent
---@field SkeletalMeshComp USkeletalMeshComponent
ABGUWeaponBase = {}

---@param FloatParam float
function ABGUWeaponBase:WeaponBPFunc(FloatParam) end
function ABGUWeaponBase:SetMeshNoCollision() end
function ABGUWeaponBase:Tool_ReadWriteTrans() end
function ABGUWeaponBase:Tool_SetRelativeTrans() end
---@return boolean
function ABGUWeaponBase:Tool_CheckBoxChildren() end
function ABGUWeaponBase:SetWeaponHasCollision() end


---@class ABGUZBBCreatorActorBase : ABGUActorBaseCS
---@field UnitDist float
---@field ZBBConfigs TArray<FZBBPreviewConfig>
ABGUZBBCreatorActorBase = {}

---@param DeltaSeconds float
function ABGUZBBCreatorActorBase:ReceiveTick(DeltaSeconds) end


---@class ABGU_CharacterAI : ABGUCharacterCS
---@field GuidComp UBUS_GuidComp
---@field ConfigInfoComp UBUS_ConfigInfoComp
---@field ExtendConfigComp UBUS_ExtendConfigComp
ABGU_CharacterAI = {}

function ABGU_CharacterAI:OnRep_PlayerStateCS() end


---@class ABGU_DebugActor : ABGUActorBase
---@field SceneRoot USceneComponent
---@field SightPerceptionDebugSector UBGUDebugSectorComponent
---@field HearingPerceptionDebugCircle UBGUDebugCircleComponent
---@field WakeUpRangeCylinder UStaticMeshComponent
ABGU_DebugActor = {}

function ABGU_DebugActor:BeginPlayCS() end
---@param Transform FTransform
function ABGU_DebugActor:OnConstructionCS(Transform) end


---@class ABGU_DispLibDBCCarrierActor : ABGUActorBase
---@field ActorCompContainerCS UActorCompContainerCS
---@field DataComp UActorDataContainer
ABGU_DispLibDBCCarrierActor = {}

---@param InOffset FVector
---@param bWorldShift boolean
function ABGU_DispLibDBCCarrierActor:ApplyWorldOffsetCS(InOffset, bWorldShift) end
function ABGU_DispLibDBCCarrierActor:PostInitializeComponentsCS() end


---@class ABGU_EQSPointRecorderActor : ABGUActorBaseCS
---@field Root USceneComponent
---@field LocalMode boolean
---@field RelativeTarget AActor
---@field GeneratePointsEQSTemplate UEnvQuery
---@field QueryConfig TArray<FGSEnvNamedValue>
---@field PreviewActor TSubclassOf<AActor>
---@field CustomAddingActors TArray<TSoftObjectPtr<AActor>>
---@field EQSPoints TArray<FVector>
---@field CustomPoints TArray<FVector>
---@field GeneratedEQSActors TArray<TSoftObjectPtr<AActor>>
---@field bRunQueryWhenMove boolean
---@field bOnlyUpdateWhenMoveFinish boolean
---@field bEnableDebug boolean
ABGU_EQSPointRecorderActor = {}

function ABGU_EQSPointRecorderActor:ClearRecord() end
function ABGU_EQSPointRecorderActor:RunEQSQuery() end
function ABGU_EQSPointRecorderActor:RecordEQSPoints() end
function ABGU_EQSPointRecorderActor:ClearSpawnPoints() end
function ABGU_EQSPointRecorderActor:ClearCustomPoints() end
function ABGU_EQSPointRecorderActor:RecordCustomPoints() end
function ABGU_EQSPointRecorderActor:PreviewCustomPoints() end
function ABGU_EQSPointRecorderActor:ClearGenerateEQSActors() end
function ABGU_EQSPointRecorderActor:PreviewRecordSpawnPoints() end
function ABGU_EQSPointRecorderActor:BeginPlayCS() end
---@param bFinish boolean
function ABGU_EQSPointRecorderActor:OnPostEditMove(bFinish) end
function ABGU_EQSPointRecorderActor:ReceiveDestroyed() end


---@class ABGU_FlowActor : ABGUActorBaseCS
---@field FlowActorType FlowActorType
---@field RootFlow UCalliopeAsset
---@field bAutoStartRootFlow boolean
---@field bAllowMultipleInstances boolean
---@field bAutoEnableOverlap boolean
---@field SpawnUnitClass TSubclassOf<AActor>
---@field SpawnMontage UAnimMontage
---@field bFaceToPlayer boolean
---@field bAutoEnableDynamicObstacle boolean
---@field bEnableDynamicObstacleCollisionDebug boolean
ABGU_FlowActor = {}



---@class ABGU_PreloadDebugActor : ABGUActorBase
---@field Enablepreload boolean
---@field EnableHitSceneItemPerformPreload boolean
---@field EnableUnitTransPreloadPreload boolean
---@field WhiteListPreloadTypeMap TMap<FString, boolean>
---@field WhiteListPreloadTypeInfoMap TMap<FString, FSkillTypeInfo>
ABGU_PreloadDebugActor = {}



---@class ABGU_QuestActor : ABGUActorBaseCS
---@field QuestActorType QuestActorType
---@field bAutoEnableOverlap boolean
---@field AssignBirthPointID int32
---@field bAutoEnableDynamicObstacle boolean
---@field PerformID int32
---@field bEnableDynamicObstacleCollisionDebug boolean
---@field Timer_InArea float
---@field Timer_OutArea float
---@field HLMActor AActor
---@field NewTrans_HLM_State1 FTransform
---@field NewTrans_HLM_KillWa FTransform
---@field bRecoverToNoSpawn boolean
---@field SpawnWaveGroupID int32
---@field SpawnWaveGlobleGroupCD float
---@field EnsureBornPosCanNavToPlayer boolean
---@field SpawnWaveType SpawnWaveType
---@field WaveStopActionType WaveStopActionType
---@field FirstWaveStartCondition FCompositeCondition_SpawnWaveStart
---@field Waves TArray<FSpawnWaveConfig>
---@field InfiniteWave FSpawnWaveConfig_Infinite
ABGU_QuestActor = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function ABGU_QuestActor:OnCollisionEndOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function ABGU_QuestActor:OnCollisionBeginOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end
function ABGU_QuestActor:OnEnableDynamicObstacle() end
function ABGU_QuestActor:OnDisableDynamicObstacle() end
---@param EndPlayReason EEndPlayReason::Type
function ABGU_QuestActor:ReceiveEndPlay(EndPlayReason) end
---@param MemberName FString
---@param PropertyName FString
function ABGU_QuestActor:OnPropertyChanged(MemberName, PropertyName) end


---@class ABGU_TempExportForDS : AActor
---@field BotLifeTimeState EBGUBotLifeTimeState
---@field BGWTeleportNamedPoint TSubclassOf<ABGWTeleportNamedPoint>
---@field ChildActorComponent TSubclassOf<UChildActorComponent>
---@field BANS_GSTimedParticleEffect TSubclassOf<UBANS_GSTimedParticleEffect>
---@field BANS_GSEditorHelper TSubclassOf<UBANS_GSEditorHelper>
---@field GMTeleportPanel TSubclassOf<UBUI_GMTeleportPanel>
---@field BUI_GMInfo_Player TSubclassOf<UBUI_GMInfo_Player>
---@field BUI_GMInfo_Enemy TSubclassOf<UBUI_GMInfo_Enemy>
---@field BGUDebugCircleComponent TSubclassOf<UBGUDebugCircleComponent>
---@field BGUPlayerCharacterCS TSubclassOf<ABGUPlayerCharacterCS>
---@field BGU_CharacterAI TSubclassOf<ABGU_CharacterAI>
---@field BGU_DebugActor TSubclassOf<ABGU_DebugActor>
---@field BGUBulletBaseManaged TSubclassOf<ABGUBulletBaseManaged>
---@field BUAnimHumanoidCS_SpecialMove TSubclassOf<UBUAnimHumanoidCS_SpecialMove>
---@field BUAnimHumanoidCS_Move TSubclassOf<UBUAnimHumanoidCS_Move>
---@field BUAnimHumanoidCS_Simple4Dir TSubclassOf<UBUAnimHumanoidCS_Simple4Dir>
---@field BUAnimHumanoidCS_PlayerLocomotion TSubclassOf<UBUAnimHumanoidCS_PlayerLocomotion>
---@field BUAnimHumanoidCS_MotionMatching TSubclassOf<UBUAnimHumanoidCS_MotionMatching>
---@field BUAnimHumanoidCS_MonsterLocomotion TSubclassOf<UBUAnimHumanoidCS_MonsterLocomotion>
---@field BUAnimHumanoidCS_MMRetarget TSubclassOf<UBUAnimHumanoidCS_MMRetarget>
---@field BUAnimHumanoidCS_FlyControl TSubclassOf<UBUAnimHumanoidCS_FlyControl>
---@field BGWDataAsset_BeAttackedHitLevelConfig TSubclassOf<UBGWDataAsset_BeAttackedHitLevelConfig>
---@field BGWDataAsset_ProjectileSpawnConfig TSubclassOf<UBGWDataAsset_ProjectileSpawnConfig>
---@field BGWDataAsset_ScaleTimeSetting TSubclassOf<UBGWDataAsset_ScaleTimeSetting>
---@field BGWDataAsset_BuffSetCurveValueToMeshConfig TSubclassOf<UBGWDataAsset_BuffSetCurveValueToMeshConfig>
---@field BED_ComboAsset TSubclassOf<UBED_ComboAsset>
---@field BED_BehaviorAsset TSubclassOf<UBED_BehaviorAsset>
---@field BGWDataAsset_StateLib TSubclassOf<UBGWDataAsset_StateLib>
---@field BED_ComboNode_Reroute TSubclassOf<UBED_ComboNode_Reroute>
---@field BED_ComboNode_Start TSubclassOf<UBED_ComboNode_Start>
---@field BED_BehaviorNode_Start TSubclassOf<UBED_BehaviorNode_Start>
---@field BGWBeAtkPhysAnimDataAsset TSubclassOf<UBGWBeAtkPhysAnimDataAsset>
---@field BGP_PlayerStateB1 TSubclassOf<ABGP_PlayerStateB1>
---@field BED_StateNode_Reroute TSubclassOf<UBED_StateNode_Reroute>
---@field BED_StateNode_Initial TSubclassOf<UBED_StateNode_Initial>
---@field BGP_PlayerControllerB1 TSubclassOf<ABGP_PlayerControllerB1>
---@field BPS_PlayerControllerDataCompB1 TSubclassOf<UBPS_PlayerControllerDataCompB1>
---@field BUS_AttackFeedbackComp TSubclassOf<UBUS_AttackFeedbackComp>
---@field BUI_Button TSubclassOf<UBUI_Button>
---@field BUS_MovePhysicsTransformCompImpl TSubclassOf<UBUS_MovePhysicsTransformCompImpl>
---@field BUS_SkillSequenceComp TSubclassOf<UBUS_SkillSequenceComp>
---@field BUS_PlayerCameraSystem TSubclassOf<UBUS_PlayerCameraSystem>
---@field BGWDataAsset_SweepCheckDebugCollisionInfoConfig TSubclassOf<UBGWDataAsset_SweepCheckDebugCollisionInfoConfig>
---@field BUS_PlayerCameraCompUObj TSubclassOf<UBUS_PlayerCameraCompUObj>
---@field BANS_GSNvFlow TSubclassOf<UBANS_GSNvFlow>
---@field BANS_GSTrail TSubclassOf<UBANS_GSTrail>
---@field BGWDataAsset_PerformerConfig TSubclassOf<UBGWDataAsset_PerformerConfig>
---@field DispLibDispWorld TSubclassOf<ADispLibDispWorld>
---@field BGUPerformerActor TSubclassOf<ABGUPerformerActor>
---@field BED_QuestNode_Start TSubclassOf<UBED_QuestNode_Start>
---@field CLSManager TSubclassOf<ACLSManager>
---@field BED_BehaviorNode_GameDataCounter TSubclassOf<UBED_BehaviorNode_GameDataCounter>
---@field BGURebirthPointBase TSubclassOf<ABGURebirthPointBase>
---@field B1X2_DispWorld TSubclassOf<AB1X2_DispWorld>
---@field BUAnimShadowInstanceBase TSubclassOf<UBUAnimShadowInstanceBase>
---@field RebirthType RebirthType
---@field IKRigBoneDefinition FIKRigBoneDefinition
---@field FEffectInstReq FEffectInstReq
---@field MoveDirectionFive MoveDirectionFive
---@field MoveDirection MoveDirection
ABGU_TempExportForDS = {}

function ABGU_TempExportForDS:ReceiveBeginPlay() end


---@class ABGWTeleportNamedPoint : ABGUTeleportPoint
---@field TeleportID FName
ABGWTeleportNamedPoint = {}

---@param EndPlayReason EEndPlayReason::Type
function ABGWTeleportNamedPoint:ReceiveEndPlay(EndPlayReason) end
function ABGWTeleportNamedPoint:ReceiveBeginPlay() end


---@class ABGW_PlayerController_U3 : ABGWPlayerController
---@field InputHandler UBGW_PlayerInput_U3
ABGW_PlayerController_U3 = {}

---@param AxisValue float
function ABGW_PlayerController_U3:OnAxisMoveForward(AxisValue) end
---@param AxisValue float
function ABGW_PlayerController_U3:OnAxisMoveSideways(AxisValue) end
---@param AxisValue float
function ABGW_PlayerController_U3:OnAxisMoveForwardGamepad(AxisValue) end
---@param AxisValue float
function ABGW_PlayerController_U3:OnAxisMoveSidewaysGamepad(AxisValue) end
---@param DeltaTime float
---@param bGamePaused boolean
function ABGW_PlayerController_U3:ProcessPlayerInputCS(DeltaTime, bGamePaused) end
function ABGW_PlayerController_U3:SetupInputComponentCS() end


---@class ABGW_WorldSettings : ABGWWorldSettings
---@field DefaultGroupAIMgrConfigDataAsset UBGWGroupAIMgrConfigDataAsset
---@field DefaultGroupAIBattleHotZoneConfigDataAsset UBGWGroupAIBattleHotZoneConfigDataAsset
---@field DefaultEnvironmentSurfaceEffectID int32
---@field DefaultWeatherType EWeatherType
---@field EnterLevelEvent UAkAudioEvent
---@field ExitLevelEvent UAkAudioEvent
---@field EnterLevelEventLocation FVector
---@field bShowListener boolean
---@field bShowMaxAttentionRadius boolean
---@field bShowObjectDirectionAxis boolean
---@field AxisLength float
---@field GameObjectRefreshInterval float
---@field ShowObjectRangeMeter float
---@field RootQuestGraph UCalliopeAsset
---@field QuestRunDelaySeconds float
---@field PlayOnStartNiagaraPaths TArray<FDirectoryPath>
---@field NiagaraPlayLocation FVector
---@field CellPatitionInsatnceConfig TMap<FString, FFGSCellPatitionInsatnceConfig>
---@field TROCellPatitionLayerConfig TArray<FFGSTROConfig>
---@field RepGraphCellPatitionLayerConfig TArray<FFGSRepGraphConfig>
---@field EnableLevelOverride boolean
---@field TamerSettingConfigDataAsset UBGWTamerSettingConfigDataAsset
ABGW_WorldSettings = {}

---@param Level ULevel
---@param World UWorld
function ABGW_WorldSettings:OnLevelPreSave(Level, World) end
function ABGW_WorldSettings:ReceiveDestroyed() end


---@class ABP_ActorTouchDraggingController : AActor
---@field traceChnl ETraceTypeQuery
ABP_ActorTouchDraggingController = {}

---@param DeltaTime float
function ABP_ActorTouchDraggingController:OnTick(DeltaTime) end
function ABP_ActorTouchDraggingController:OnTouchPressed() end
function ABP_ActorTouchDraggingController:OnTouchReleased() end
function ABP_ActorTouchDraggingController:ReceiveBeginPlay() end


---@class ABUAbnormalDispMuseum : ABGUActorBaseCS
---@field Root USceneComponent
---@field SKMeshActors TArray<ASkeletalMeshActor>
---@field SKMeshActors_WithRowIndex TMap<int32, FGridRow_ForAbnormalDisp>
---@field SKMap TMap<FString, FTamerInfo_ForAbnormal>
---@field SKMap_Conflict TArray<FTamerInfo_ForAbnormal>
---@field csvFilePath FString
---@field ImmueStaticMesh UStaticMesh
---@field DebugNumerClass TSubclassOf<AActor>
---@field RowIndex int32
---@field AttackerDispID int32
---@field AbnormalType AbnormalStateType
---@field ActionTypeList TArray<AbnromalDispActionType>
---@field ActionTypeList_FreezeExt TArray<AbnromalDispActionType_FreezeExt>
---@field CurSelectedActors TArray<ASkeletalMeshActor>
ABUAbnormalDispMuseum = {}

function ABUAbnormalDispMuseum:Preview() end
function ABUAbnormalDispMuseum:SpawnGrid() end
function ABUAbnormalDispMuseum:UpdateData() end
function ABUAbnormalDispMuseum:GenSKMuseumData() end
---@param DeltaSeconds float
function ABUAbnormalDispMuseum:ReceiveTick(DeltaSeconds) end


---@class ABUAllowUseSpecialItemArea : ABGUAreaBase
---@field AllowUseSpecialItemAreaConfigComp UBUS_AllowUseSpecialItemAreaConfigComp
ABUAllowUseSpecialItemArea = {}



---@class ABUBirthPoint : ABGUBirthPoint
ABUBirthPoint = {}

---@param EndPlayReason EEndPlayReason::Type
function ABUBirthPoint:ReceiveEndPlay(EndPlayReason) end
function ABUBirthPoint:ReceiveBeginPlay() end


---@class ABUCircusBase : ABGUActorBaseCS
---@field FamilyTree TArray<FCircusCollector>
---@field AwakeSync boolean
ABUCircusBase = {}

function ABUCircusBase:CollectRelativeTamerData() end


---@class ABUIgnoreSkillMappingArea : ABGUAreaBase
---@field IgnoreSkillMappingAreaConfigComp UBUS_IgnoreSkillMappingAreaConfigComp
ABUIgnoreSkillMappingArea = {}



---@class ABULayerSceneInfoActor : ALayerSceneInfo
ABULayerSceneInfoActor = {}

function ABULayerSceneInfoActor:BeginPlayCS() end


---@class ABUMapsymblolocationActor : ABGUActorBaseCS
---@field MapsymblolConfigComp UBUS_MapSymbolConfigComp
---@field UseDebugDraw boolean
ABUMapsymblolocationActor = {}



---@class ABUS_SeqHelperActorBase : ABGUActorBaseCS
---@field SeqHelperActorComp UBUS_SeqHelperActorComp
ABUS_SeqHelperActorBase = {}



---@class ABUSpawnCollectionActor : ABGUActorBaseCS
---@field SpawnCollectionComp UBUS_SpawnCollectionComp
ABUSpawnCollectionActor = {}



---@class ABUTamerActor : ABGUTamerBase
---@field ConfigInfoComp UBUS_ConfigInfoComp
---@field GuidComp UBUS_GuidComp
---@field InteractRangeDebugComp UBGUDebugSectorComponent
---@field InteractRangeDebugComp2 UBGUDebugSectorComponent
---@field SightPerceptionDebugSector UBGUDebugSectorComponent
---@field HearingPerceptionDebugCircle UBGUDebugCircleComponent
---@field WakeUpRangeCylinder UStaticMeshComponent
---@field ExtendConfigComp UBUS_ExtendConfigComp
---@field CharacterModularComp UBUS_CharacterModularComp
---@field MonsterClass TSoftClassPtr<ABGUCharacterCS>
---@field MonsterClassObj UClass
ABUTamerActor = {}

---@return ABGUCharacterCS
function ABUTamerActor:GetMonster() end
function ABUTamerActor:CopyPropertiesFromUnit() end
function ABUTamerActor:BeginPlayCS() end
---@param Unit ABGUCharacterCS
function ABUTamerActor:CopyPropertiesFromUnitActor(Unit) end
---@param TamerActor ABUTamerActor
function ABUTamerActor:CopyPropertiesFromTamerActor(TamerActor) end
---@param OutActorGuid FString
---@return boolean
function ABUTamerActor:GetActorGuidCS(OutActorGuid) end
---@param EndPlayReason EEndPlayReason::Type
function ABUTamerActor:ReceiveEndPlay(EndPlayReason) end
---@param Transform FTransform
function ABUTamerActor:OnConstructionCS(Transform) end
---@param OutMeshConfig FTamerHighLODRootMeshConfig
---@return boolean
function ABUTamerActor:GetHighLODMeshConfig(OutMeshConfig) end


---@class ABWS_EnvInteractiveCapture : AActor
---@field ParticleArrayData UGSNiagaraArrayData
---@field RTSize int32
---@field RT UTextureRenderTarget2D
---@field SceneCaptureComponent USceneCaptureComponent2D
---@field CaptureMPC UMaterialParameterCollection
---@field CaptureInterval float
---@field ParticleFadeDuration float
---@field ParicleHeight float
ABWS_EnvInteractiveCapture = {}

function ABWS_EnvInteractiveCapture:Init() end
function ABWS_EnvInteractiveCapture:OnLateInit() end
---@param position FVector
---@param Size FVector
---@param InteractiveType int32
---@param Intensity float
---@param Duration float
---@return int32
function ABWS_EnvInteractiveCapture:TriggerOnce(position, Size, InteractiveType, Intensity, Duration) end
function ABWS_EnvInteractiveCapture:OnEnableDebug() end
function ABWS_EnvInteractiveCapture:OnTickCapture() end
---@param PrimComp UPrimitiveComponent
---@param InteractiveType int32
---@param Size FVector
---@param Intensity float
---@param Duration float
---@return int32
function ABWS_EnvInteractiveCapture:AddInteractor(PrimComp, InteractiveType, Size, Intensity, Duration) end
---@param InteractorID int32
function ABWS_EnvInteractiveCapture:RemoveInteractor(InteractorID) end


---@class ADisoLib_EditorSGDTool : ABGUPlacedEditorUtilityBase
---@field BoneNameList TArray<FName>
---@field CurBoneName FName
---@field SGDActor AActor
---@field AutoCompilingSaveAfterClean boolean
---@field DelectObjectsArray TArray<UStaticMesh>
---@field RetainObjectsArray TArray<UStaticMesh>
---@field AddTagToBoneChildComp FName
---@field CollisionPresetName DispLibCollisionProfileNames
---@field Override_CollisionEnable boolean
---@field CollisionEnable ECollisionEnabled::Type
---@field Override_CollisionObjectType boolean
---@field CollisionObjectType ECollisionChannel
ADisoLib_EditorSGDTool = {}

function ADisoLib_EditorSGDTool:CreateBoneComp() end
function ADisoLib_EditorSGDTool:CreateSubMeshComp() end
function ADisoLib_EditorSGDTool:CleanAllSubMeshComp() end
function ADisoLib_EditorSGDTool:AddTagToBoneChildComps() end
function ADisoLib_EditorSGDTool:CleanOneBoneSubMeshComp() end
function ADisoLib_EditorSGDTool:CreateOneBoneSubMeshComp() end
function ADisoLib_EditorSGDTool:CreateLevelActorFromUnit() end
function ADisoLib_EditorSGDTool:ToggleSubMeshCompVisable() end
function ADisoLib_EditorSGDTool:LogBoneChildCompsCPDData() end
function ADisoLib_EditorSGDTool:ToggleBoneChildCompsHidenInGame() end
function ADisoLib_EditorSGDTool:SetBoneChildCompsCollisionSetting() end
function ADisoLib_EditorSGDTool:CleanOneBoneSubMeshCompByDelectObjectsArray() end
function ADisoLib_EditorSGDTool:CleanOneBoneSubMeshCompByRetainObjectsArray() end


---@class ADispLibDebugTest_SpawnAttachedNiagara : AActor
---@field Template UNiagaraSystem
ADispLibDebugTest_SpawnAttachedNiagara = {}

function ADispLibDebugTest_SpawnAttachedNiagara:SpawnNS() end
---@param vis boolean
---@param Child boolean
function ADispLibDebugTest_SpawnAttachedNiagara:SetVisible(vis, Child) end


---@class ADispLibDispWorld : ADispLibEntityBase
---@field WEFMManager UNiagaraComponent
---@field WEFM_VisualDebugFX UNiagaraComponent
ADispLibDispWorld = {}

function ADispLibDispWorld:BeginPlayCS() end
---@param EndPlayReason EEndPlayReason::Type
function ADispLibDispWorld:ReceiveEndPlay(EndPlayReason) end


---@class ADispLibEntityBase : ABGUActorBase
---@field ActorCompContainerCS UActorCompContainerCS
---@field DataComp UActorDataContainer
ADispLibEntityBase = {}

function ADispLibEntityBase:ReceiveBeginPlay() end
---@param InOffset FVector
---@param bWorldShift boolean
function ADispLibEntityBase:ApplyWorldOffsetCS(InOffset, bWorldShift) end
function ADispLibEntityBase:PostInitializeComponentsCS() end


---@class ADispLib_EditorDBCPreviewToolActor : ABGUPlacedEditorUtilityBase
ADispLib_EditorDBCPreviewToolActor = {}

---@param DeltaSeconds float
function ADispLib_EditorDBCPreviewToolActor:ReceiveTick(DeltaSeconds) end
---@param World UWorld
---@param SessionEnded boolean
---@param CleanupResources boolean
function ADispLib_EditorDBCPreviewToolActor:OnWorldCleanup(World, SessionEnded, CleanupResources) end
---@param EndPlayReason EEndPlayReason::Type
function ADispLib_EditorDBCPreviewToolActor:ReceiveEndPlay(EndPlayReason) end
function ADispLib_EditorDBCPreviewToolActor:ReceiveDestroyed() end


---@class ADispLib_EditorExportLevelToHoudini : ABGUPlacedEditorUtilityBase
---@field FilterByTag FName
---@field UseExcludedObjects boolean
---@field ExcludedObjects TArray<UStaticMesh>
---@field LevelJsonFileExportPath FName
---@field LevelJsonFileName FName
---@field FileNameAutoIndexSuffix boolean
---@field UnrealAssetsExportPath FName
---@field NaniteFallbackMeshExportPath FName
---@field MeshExportMode AssetExportMode
---@field TextureExportMode AssetExportMode
---@field AutoDisableNanite boolean
---@field NotMeragedActorsJsonFilePath FName
---@field LimitBoxJsonFilePath FName
---@field PerUnitCellSize FVector
---@field LimitBoxCenterPosArray TArray<FVector>
---@field LimitBoxStartEndIndexInfo TArray<FVector>
---@field MergedChunkIndex int32
---@field HeightLimit float
ADispLib_EditorExportLevelToHoudini = {}

function ADispLib_EditorExportLevelToHoudini:ExportMeshAssets() end
function ADispLib_EditorExportLevelToHoudini:ImportLimitBoxInfo() end
function ADispLib_EditorExportLevelToHoudini:ExportLevelToHoudini() end
function ADispLib_EditorExportLevelToHoudini:SelectActorsInLimitBox() end
function ADispLib_EditorExportLevelToHoudini:SelectActorsByHeightLimit() end
function ADispLib_EditorExportLevelToHoudini:ExportLevelDescriptionJson() end
function ADispLib_EditorExportLevelToHoudini:ExportSplineDescriptionJson() end
function ADispLib_EditorExportLevelToHoudini:ExportActorBoundsDescriptionJson() end
function ADispLib_EditorExportLevelToHoudini:SelectActorsByNotMeragedActorsJson() end


---@class ADispLib_EditorSimpleMayaSceneImporter : ABGUPlacedEditorUtilityBase
---@field TextFilePath FName
---@field TranslateScale FVector
---@field QuatScale FVector4
---@field ScaleScale FVector
---@field SourceAssetLib TArray<FSourceAsset>
---@field SourceMaterialLib TArray<FMayaShadingEngineToUnrealMaterial>
ADispLib_EditorSimpleMayaSceneImporter = {}

function ADispLib_EditorSimpleMayaSceneImporter:LogEulerToQuat() end
function ADispLib_EditorSimpleMayaSceneImporter:DoRebuildScene() end


---@class ADispLib_EditorTreeImposterTool : ABGUPlacedEditorUtilityBase
---@field TempFileSaveRootFolderUnrealPath FString
---@field TempAutogenRootFolderDiskPath FString
---@field ManualSaveAssets boolean
---@field UseCustomSavePath boolean
---@field PerformanceMatInstanceSaveAt FString
---@field PerformanceMatDataTextureSaveAt FString
---@field TaskFromFolder TArray<FString>
---@field TaskList TArray<FTreeImposter_TaskData>
---@field DefaultCardMicoScale float
---@field DefaultCardPairCount int32
---@field DefaultCaptureRTSize int32
---@field DefaultShotTextureSize int32
---@field DefaultTrunkMaskThreshold float
---@field DefaultLeafMaskThreshold float
---@field DebugPause boolean
---@field CurTaskIndex int32
---@field TreeMesh UStaticMesh
---@field BakeLOD int32
---@field CardPairCount int32
---@field CardMicoScale float
---@field CaptureRTSize int32
---@field ShotTextureSize int32
---@field TrunkMaskThreshold float
---@field LeafMaskThreshold float
---@field ImposterCardMeshAsset UObject
---@field CardSize TArray<FVector>
---@field PosOffset TArray<FVector>
---@field LastMeshName FName
---@field GlobalOffset FVector
---@field ShadowMapCountEveryCard int32
---@field ForceResetExitstedMat boolean
---@field PerformanceMaterialUseOneTextureMode boolean
---@field AutoSetImposterMeshToTreeLOD boolean
---@field SaveImposterCardMesh boolean
---@field OverrideMPCParam TArray<FTreeImposter_OverrideMPCParam>
---@field OverrideTreeMeshMatScalarParam TArray<FTreeImposter_OverrideMatScalarParam>
---@field OverrideTreeMeshMatLinearColorParam TArray<FTreeImposter_OverrideMatLinearColorParam>
---@field OverrideShotTexSetting TArray<FTreeImposter_OverrideTexSetting>
---@field OverrideFinalTexSetting TArray<FTreeImposter_OverrideTexSetting>
---@field CopyScalarParamsFromHQToImposterMat TArray<FName>
---@field CopySwitchParamsFromHQToImposterMat TArray<FName>
---@field HDA_Asset UHoudiniAsset
---@field ToggleViewModeWaittngTime float
---@field RT_CustomShadowmap UTextureRenderTarget2D
---@field DebugColorArray TArray<FLinearColor>
---@field SkySphereToolMat UMaterial
---@field MergeActorToolMat UMaterial
---@field ColorDilateToolMat UMaterial
---@field CustomShadowMapMat UMaterial
---@field DistanceFieldToolMat UMaterial
---@field CombineRGBAndAlphaToolMat UMaterial
---@field OriginImposterMatIns UMaterialInstance
---@field OriginOneTexPerformanceImposterMatIns UMaterialInstance
---@field OriginMultiTexPerformanceImposterMatIns UMaterialInstance
---@field TreeActor AActor
---@field TreeStaticMeshComp UStaticMeshComponent
---@field CopyFromHQMatIndex int32
---@field ShadowMapTreeActor AActor
---@field ShadowMapTreeStaticMeshComp UStaticMeshComponent
---@field Capture2DActor AActor
---@field CaptureComponent2D USceneCaptureComponent2D
---@field CameraActor AActor
---@field CameraComp UCameraComponent
---@field ShadowMapCameraActor AActor
---@field ShadowMapCameraComp UCameraComponent
---@field ShadowMapCapture2DActor AActor
---@field ShadowMapCaptureComponent2D USceneCaptureComponent2D
---@field RT_4Capture_RGB UTextureRenderTarget2D
---@field RT_4Capture_NearestFillterRGB UTextureRenderTarget2D
---@field RT_4Capture_Alpha UTextureRenderTarget2D
---@field RT_4Capture_FinalTex UTextureRenderTarget2D
---@field isShadowMaskSceneShot boolean
---@field isPBRSceneShot boolean
---@field isCreateTreeImposter boolean
---@field ImposterMatInsAsset UMaterialInstance
---@field ImposterMatPerformanceModeInsAsset UMaterialInstance
ADispLib_EditorTreeImposterTool = {}

function ADispLib_EditorTreeImposterTool:DoSetLOD() end
function ADispLib_EditorTreeImposterTool:ShowCompare() end
---@param TaskIndex int32
---@return boolean
function ADispLib_EditorTreeImposterTool:SetCurrentTask(TaskIndex) end
---@return boolean
function ADispLib_EditorTreeImposterTool:FillHoudiniData() end
function ADispLib_EditorTreeImposterTool:ToggleDebugPause() end
function ADispLib_EditorTreeImposterTool:LogForwardVector() end
function ADispLib_EditorTreeImposterTool:CreateHDAInstance() end
---@return boolean
function ADispLib_EditorTreeImposterTool:CheckHDABakeResult() end
function ADispLib_EditorTreeImposterTool:CleanAllToolAssets() end
function ADispLib_EditorTreeImposterTool:AutoImportSceneShot() end
function ADispLib_EditorTreeImposterTool:AutoDelectSceneShot() end
---@param Visable boolean
function ADispLib_EditorTreeImposterTool:SetNewLevelEnvActor(Visable) end
function ADispLib_EditorTreeImposterTool:RemoveAllInvalidTask() end
---@return boolean
function ADispLib_EditorTreeImposterTool:CheckTaskMeshValidity() end
function ADispLib_EditorTreeImposterTool:SetAllTaskBakeZeroLOD() end
---@return boolean
function ADispLib_EditorTreeImposterTool:DoCombinedFinalTexture() end
function ADispLib_EditorTreeImposterTool:DoSaveImposterCardMesh() end
---@return boolean
function ADispLib_EditorTreeImposterTool:CreatSceneShotToolActor() end
function ADispLib_EditorTreeImposterTool:DoCreateTreeImposterTask() end
function ADispLib_EditorTreeImposterTool:ReleaseGeneratedTextures() end
function ADispLib_EditorTreeImposterTool:DoCleanTempMemoryResource() end
function ADispLib_EditorTreeImposterTool:SetTaskListFromFolderPath() end
function ADispLib_EditorTreeImposterTool:RemoveAllHasGSImposterTask() end
---@param ForceOverrideMat boolean
function ADispLib_EditorTreeImposterTool:CreatFinalImposterMaterial(ForceOverrideMat) end
---@param cardIndex int32
---@param shadowMaskIndex int32
function ADispLib_EditorTreeImposterTool:TestRenderCustomShadowMask(cardIndex, shadowMaskIndex) end
---@param DeltaSeconds float
function ADispLib_EditorTreeImposterTool:ReceiveTick(DeltaSeconds) end
function ADispLib_EditorTreeImposterTool:DoPBRTextureRenderBySceneShot() end
---@param CaptureRTSize FString
---@param PerformanceMatInstanceAssetPath FString
---@param ImposterCombinedStdTextureFolderPath FString
---@param ImposterDataTextureFolderPath FString
---@param TrunkMaskThreshold FString
---@param LeafMaskThreshold FString
function ADispLib_EditorTreeImposterTool:PythonCreatePerformanceTexture(CaptureRTSize, PerformanceMatInstanceAssetPath, ImposterCombinedStdTextureFolderPath, ImposterDataTextureFolderPath, TrunkMaskThreshold, LeafMaskThreshold) end
function ADispLib_EditorTreeImposterTool:DoShadowMaskTextureRenderBySceneShot() end


---@class ADispLib_EditorTreeLODTools : ABGUPlacedEditorUtilityBase
---@field CacaheActorName FName
---@field CustomMeshAssetsPath FName
---@field EnableSimBlock boolean
ADispLib_EditorTreeLODTools = {}

function ADispLib_EditorTreeLODTools:LogLevelTreeInfo() end
function ADispLib_EditorTreeLODTools:ConverToInstanceActor() end
function ADispLib_EditorTreeLODTools:ToggleAllTreeActorHide() end
---@param Visibility boolean
function ADispLib_EditorTreeLODTools:SetAllTreeActorVisibility(Visibility) end
---@param DeltaSeconds float
function ADispLib_EditorTreeLODTools:ReceiveTick(DeltaSeconds) end
function ADispLib_EditorTreeLODTools:RepleaceCustomMeshAssetToImposter() end
function ADispLib_EditorTreeLODTools:RepleaceCustomMeshAssetToReduceMesh() end
function ADispLib_EditorTreeLODTools:RepleaceOriginMeshAssetToCustomMeshAsset() end


---@class AGPUSplineMesh : ABGUPlacedEditorUtilityBase
AGPUSplineMesh = {}

---@param DeltaSeconds float
function AGPUSplineMesh:ReceiveTick(DeltaSeconds) end


---@class AGSDispLib_PP_VaFogOfWar : AGSDispLib_PostProcessActor
---@field FoWTex1 UTextureRenderTarget2D
---@field FoWTex2 UTextureRenderTarget2D
---@field FoWTex3 UTextureRenderTarget2D
---@field FoWOpaqueColor FLinearColor
---@field FoWTranslucentColor FLinearColor
---@field FoWTexName FName
---@field FoWTex2Name FName
---@field FoWOpaqueColorName FName
---@field FoWTranslucentColorName FName
---@field FoWVolumePosSizeName FName
---@field FoWIsDebug FName
---@field FoWCombineTexName FName
AGSDispLib_PP_VaFogOfWar = {}

---@param Context UGSDispLib_PostProcessContext
---@param Conf FUDispLib_PostPorcessCommonConf
function AGSDispLib_PP_VaFogOfWar:OnInit(Context, Conf) end
---@param Context UGSDispLib_PostProcessContext
function AGSDispLib_PP_VaFogOfWar:OnEndBegin(Context) end
---@param Context UGSDispLib_PostProcessContext
function AGSDispLib_PP_VaFogOfWar:OnEndFinish(Context) end
---@param Context UGSDispLib_PostProcessContext
function AGSDispLib_PP_VaFogOfWar:OnEnterBegin(Context) end
---@param DeltaTime float
---@param Progress float
---@param Context UGSDispLib_PostProcessContext
function AGSDispLib_PP_VaFogOfWar:OnEffectTick(DeltaTime, Progress, Context) end
---@param Context UGSDispLib_PostProcessContext
function AGSDispLib_PP_VaFogOfWar:OnEnterFinish(Context) end
---@param Context UGSDispLib_PostProcessContext
function AGSDispLib_PP_VaFogOfWar:OnAlreadyBegin(Context) end


---@class AGSDispLib_PostProcessActor : AActor
---@field MaterialPrototype UMaterialInstance
---@field MaterialInstDynamic UMaterialInstanceDynamic
---@field PPContext UGSDispLib_PostProcessContext
---@field PPConf FUDispLib_PostPorcessCommonConf
---@field Progress float
---@field IsAutoPlay boolean
---@field Parameters UDispLib_PPEffectParameters
---@field EffectID int32
AGSDispLib_PostProcessActor = {}

---@param Context UGSDispLib_PostProcessContext
---@param Conf FUDispLib_PostPorcessCommonConf
function AGSDispLib_PostProcessActor:OnInit(Context, Conf) end
---@param Context UGSDispLib_PostProcessContext
function AGSDispLib_PostProcessActor:OnEndBegin(Context) end
---@param Context UGSDispLib_PostProcessContext
function AGSDispLib_PostProcessActor:OnEndFinish(Context) end
---@param DeltaTime float
---@param Progress float
---@param Context UGSDispLib_PostProcessContext
function AGSDispLib_PostProcessActor:OnEffectTick(DeltaTime, Progress, Context) end
---@param Context UGSDispLib_PostProcessContext
function AGSDispLib_PostProcessActor:OnEnterBegin(Context) end
---@param Context UGSDispLib_PostProcessContext
function AGSDispLib_PostProcessActor:OnEnterFinish(Context) end
---@param Context UGSDispLib_PostProcessContext
function AGSDispLib_PostProcessActor:OnAlreadyBegin(Context) end
---@param Context UGSDispLib_PostProcessContext
function AGSDispLib_PostProcessActor:OnAlreadyFinish(Context) end


---@class AGSDispLib_PostProcessDebugger : AActor
---@field PPConf UDispLib_PostProcessConf
---@field PPContext UGSDispLib_PostProcessContext
---@field PPClass TSubclassOf<AGSDispLib_PostProcessActor>
---@field PPParameters UDispLib_PPEffectParameters
---@field ImageProcessorConfig UBWS_DispLibImageProcessorConfig
---@field AutoBegin boolean
AGSDispLib_PostProcessDebugger = {}

function AGSDispLib_PostProcessDebugger:StopEffect() end
function AGSDispLib_PostProcessDebugger:BeginEffect() end
---@param DeltaSeconds float
function AGSDispLib_PostProcessDebugger:ReceiveTick(DeltaSeconds) end
function AGSDispLib_PostProcessDebugger:ReceiveBeginPlay() end


---@class AGlobalAudioMgr : AActor
AGlobalAudioMgr = {}

function AGlobalAudioMgr:BeginPlay() end
---@return UApplicationLifecycleComponent
function AGlobalAudioMgr:GetUApplicationLifecycleComponent() end


---@class AHelloUFromUSharp : AActor
---@field Value123 int32
---@field Value456 FString
---@field DelegateTest FHelloUFromUSharpDelegateTest
---@field TestComp UHelloUTestComp
---@field TestArr2 TArray<int32>
---@field ActorClass TSubclassOf<AActor>
---@field ActorClass4 UClass
---@field Struct FHelloUStructTest
AHelloUFromUSharp = {}

---@param Arg1 FString
function AHelloUFromUSharp:CallMe(Arg1) end
function AHelloUFromUSharp:ReceiveBeginPlay() end


---@class AHelloWorldActor : AActor
---@field Value123 int32
AHelloWorldActor = {}

function AHelloWorldActor:CallMe() end
function AHelloWorldActor:ReceiveBeginPlay() end


---@class AIL2CPPStructPersistTest : AActor
---@field TestStruct FIL2CPPUnitTestStructOuter
AIL2CPPStructPersistTest = {}

---@param Input FCppTestStructOuter
function AIL2CPPStructPersistTest:PrintStruct(Input) end


---@class AIL2CPPUnitTest : AUSharpPerfTestBase
---@field CSIntProperty int32
---@field StructArrayTest FIL2CPPUnitTestStructOuter
---@field TestArrEdit TArray<FIL2CPPUnitTestStruct1>
AIL2CPPUnitTest = {}

---@param CheckIt FString
function AIL2CPPUnitTest:CallInBP(CheckIt) end
---@param p1 int32
---@param p2 int32
---@param p3 int32
---@param p4 int32
function AIL2CPPUnitTest:DelegateCB(p1, p2, p3, p4) end
---@param OuterStruct FIL2CPPUnitTestStructOuter
function AIL2CPPUnitTest:TestPassComplexStruct(OuterStruct) end
---@param DeltaTime float
function AIL2CPPUnitTest:TickInCS(DeltaTime) end
---@param p1 int32
---@param p2 float
---@param bP3 boolean
---@param Out1 int32
---@return int32
function AIL2CPPUnitTest:IntRetTest(p1, p2, bP3, Out1) end
---@param p1 int32
---@param p2 float
---@param bP3 boolean
---@return boolean
function AIL2CPPUnitTest:BoolRetTest(p1, p2, bP3) end
---@param p1 int32
---@param p2 float
---@param bP3 boolean
---@return int32
function AIL2CPPUnitTest:IntRetTest2(p1, p2, bP3) end
function AIL2CPPUnitTest:BeginPlayInCS() end


---@class ALandscapeRoadSpline : ABGUPlacedEditorUtilityBase
---@field RoadWidth float
---@field SplineMesh UStaticMesh
---@field RoadMaterial UMaterialInterface
---@field NodeWidth TArray<float>
---@field RoadRVT URuntimeVirtualTexture
ALandscapeRoadSpline = {}

---@param DeltaSeconds float
function ALandscapeRoadSpline:ReceiveTick(DeltaSeconds) end


---@class AListViewDemoItemObject : AActor
---@field itemText FString
---@field itemColor FLinearColor
AListViewDemoItemObject = {}



---@class AMouseInputControlActor : AActor
---@field traceChnl ETraceTypeQuery
---@field sphereActor AActor
---@field VerticalOffset float
AMouseInputControlActor = {}

function AMouseInputControlActor:OnTouchPressed() end
function AMouseInputControlActor:ReceiveBeginPlay() end


---@class AOldMKSpawnTest : AActor
AOldMKSpawnTest = {}

---@param ActorClass TSubclassOf<AActor>
---@return AActor
function AOldMKSpawnTest:SpawnActorCS(ActorClass) end


---@class ARenderTargetDebugger : AActor
---@field RT_Debug UTextureRenderTarget2D
---@field MID_RTPreview UMaterialInstanceDynamic
---@field Mesh_Previewer UStaticMeshComponent
ARenderTargetDebugger = {}



---@class AReplicationTest : ADefaultPawn
AReplicationTest = {}

function AReplicationTest:PrintInServer() end
function AReplicationTest:PrintMulticast() end
function AReplicationTest:RunPrintInServer() end


---@class ASharpPerfTest : AUSharpPerfTestBase
---@field CSIntProperty int32
ASharpPerfTest = {}

---@param p1 int32
---@param p2 int32
---@param p3 int32
---@param p4 int32
function ASharpPerfTest:DelegateCB(p1, p2, p3, p4) end
---@param DeltaTime float
function ASharpPerfTest:TickInCS(DeltaTime) end
---@param DeltaSeconds float
function ASharpPerfTest:ReceiveTick(DeltaSeconds) end
function ASharpPerfTest:ReceiveBeginPlay() end


---@class AStructGCTest : AActor
---@field DA UStructTestDataAsset
---@field bDoGCCheck boolean
---@field SMCActor AActor
---@field SMC UStaticMeshComponent
---@field QueueData UTestQueueData
AStructGCTest = {}

function AStructGCTest:DoInit() end
function AStructGCTest:DoCheck() end
function AStructGCTest:DestroyFX() end


---@class ATileViewDemoMediator : AActor
---@field tex0 UTexture2D
---@field tex1 UTexture2D
---@field tex2 UTexture2D
ATileViewDemoMediator = {}



---@class FAbnomalAttrConfigInfo
---@field DefaultAccumulatedValue int32
---@field DefaultAccValueDecreaseSpd int32
---@field BRKAbnormalNeedHP_INV10000 int32
---@field BRKAbnormalTriggerSkillEffectID int32
---@field MaxAccumulatedValue_Increase_PerINV10000 int32
---@field MaxAccumulatedValue_Increase_CounterMax int32
FAbnomalAttrConfigInfo = {}



---@class FAbnormalStateAccConfig
---@field Condition FTriggerAbnormalCondition
---@field AbnormalStateType AbnormalStateType
---@field Level int32
---@field AccType AccAbnormalValueType
FAbnormalStateAccConfig = {}



---@class FActorAttachConfig
---@field AttachBone FString
FActorAttachConfig = {}



---@class FAiBreakInteractionConversationInfo
---@field AiBreakInteractionType AiBreakInteractionType
---@field AiConversationIDList TArray<int32>
FAiBreakInteractionConversationInfo = {}



---@class FAiConversationFact
---@field KeyName FString
---@field FactType AiConversationFactType
---@field DefaultValue_Int int32
---@field DefaultValue_Bool boolean
---@field DefaultValue_Str FString
FAiConversationFact = {}



---@class FAnimHumanoidSetting_AdvancedMonsterLocomotion
---@field FreeMode ELMFreeMode
---@field LockMode ELMLockMode
---@field WalkMaxAcceleration float
---@field WalkBrakingFriction float
---@field WalkBrakingDecelerationWalking float
---@field RunMaxAcceleration float
---@field RunBrakingFriction float
---@field RunBrakingDecelerationWalking float
---@field RushMaxAcceleration float
---@field RushBrakingFriction float
---@field RushBrakingDecelerationWalking float
---@field StartAndTurnAnimPlayRateClamped FVector2D
---@field LoopAnimPlayRateClamped FVector2D
---@field ASIdleList TArray<UAnimSequence>
---@field ASWalkStartFwd UAnimSequence
---@field ASWalkStartBwd UAnimSequence
---@field ASWalkStartLeftMin UAnimSequence
---@field ASWalkStartLeftMax UAnimSequence
---@field ASWalkStartRightMin UAnimSequence
---@field ASWalkStartRightMax UAnimSequence
---@field ASWalkStartLF UAnimSequence
---@field ASWalkStartLB UAnimSequence
---@field ASWalkStartRF UAnimSequence
---@field ASWalkStartRB UAnimSequence
---@field ASWalkLoopFwd UAnimSequence
---@field ASWalkLoopBwd UAnimSequence
---@field ASWalkLoopLF UAnimSequence
---@field ASWalkLoopLB UAnimSequence
---@field ASWalkLoopRF UAnimSequence
---@field ASWalkLoopRB UAnimSequence
---@field ASWalkSharpturnLeftMin UAnimSequence
---@field ASWalkSharpturnLeftMax UAnimSequence
---@field ASWalkSharpturnRightMin UAnimSequence
---@field ASWalkSharpturnRightMax UAnimSequence
---@field ASWalkPivotFwd UAnimSequence
---@field ASWalkPivotBwd UAnimSequence
---@field ASWalkPivotLF UAnimSequence
---@field ASWalkPivotLB UAnimSequence
---@field ASWalkPivotRF UAnimSequence
---@field ASWalkPivotRB UAnimSequence
---@field ASWalkTransFRToBR UAnimSequence
---@field ASWalkTransBRToFR UAnimSequence
---@field ASWalkTransFLToBL UAnimSequence
---@field ASWalkTransBLToFL UAnimSequence
---@field ASWalkStopFwd UAnimSequence
---@field ASWalkStopBwd UAnimSequence
---@field ASWalkStopLF UAnimSequence
---@field ASWalkStopLB UAnimSequence
---@field ASWalkStopRF UAnimSequence
---@field ASWalkStopRB UAnimSequence
---@field ASWalkLoopAddPose UAnimSequence
---@field ASWalkLoopAdditiveList TArray<UAnimSequence>
---@field ASRunStartFwd UAnimSequence
---@field ASRunStartBwd UAnimSequence
---@field ASRunStartLeftMin UAnimSequence
---@field ASRunStartLeftMax UAnimSequence
---@field ASRunStartRightMin UAnimSequence
---@field ASRunStartRightMax UAnimSequence
---@field ASRunStartLF UAnimSequence
---@field ASRunStartLB UAnimSequence
---@field ASRunStartRF UAnimSequence
---@field ASRunStartRB UAnimSequence
---@field ASRunLoopFwd UAnimSequence
---@field ASRunLoopBwd UAnimSequence
---@field ASRunLoopLF UAnimSequence
---@field ASRunLoopLB UAnimSequence
---@field ASRunLoopRF UAnimSequence
---@field ASRunLoopRB UAnimSequence
---@field ASRunSharpturnLeftMin UAnimSequence
---@field ASRunSharpturnLeftMax UAnimSequence
---@field ASRunSharpturnRightMin UAnimSequence
---@field ASRunSharpturnRightMax UAnimSequence
---@field ASRunPivotFwd UAnimSequence
---@field ASRunPivotBwd UAnimSequence
---@field ASRunPivotLF UAnimSequence
---@field ASRunPivotLB UAnimSequence
---@field ASRunPivotRF UAnimSequence
---@field ASRunPivotRB UAnimSequence
---@field ASRunTransFRToBR UAnimSequence
---@field ASRunTransBRToFR UAnimSequence
---@field ASRunTransFLToBL UAnimSequence
---@field ASRunTransBLToFL UAnimSequence
---@field ASRunStopFwd UAnimSequence
---@field ASRunStopBwd UAnimSequence
---@field ASRunStopLF UAnimSequence
---@field ASRunStopLB UAnimSequence
---@field ASRunStopRF UAnimSequence
---@field ASRunStopRB UAnimSequence
---@field ASRunLoopAddPose UAnimSequence
---@field ASRunLoopAdditiveList TArray<UAnimSequence>
---@field ASRushStartFwd UAnimSequence
---@field ASRushStartLeftMin UAnimSequence
---@field ASRushStartLeftMax UAnimSequence
---@field ASRushStartRightMin UAnimSequence
---@field ASRushStartRightMax UAnimSequence
---@field ASRushLoopFwd UAnimSequence
---@field ASRushSharpturnLeftMin UAnimSequence
---@field ASRushSharpturnLeftMax UAnimSequence
---@field ASRushSharpturnRightMin UAnimSequence
---@field ASRushSharpturnRightMax UAnimSequence
---@field ASRushStopFwd UAnimSequence
---@field ASRushLoopAddPose UAnimSequence
---@field ASRushLoopAdditiveList TArray<UAnimSequence>
FAnimHumanoidSetting_AdvancedMonsterLocomotion = {}



---@class FAnimHumanoidSetting_AimOffset
---@field AimOffsetTurnSpeed int32
---@field AimOffsetBlindAngle int32
---@field DefaultAimOffset UAimOffsetBlendSpace
---@field AttackAimOffset UAimOffsetBlendSpace
FAnimHumanoidSetting_AimOffset = {}



---@class FAnimHumanoidSetting_BodyBlend
---@field BSUpperBodyBlendAdditive UBlendSpace
FAnimHumanoidSetting_BodyBlend = {}



---@class FAnimHumanoidSetting_CloudLocomotion
---@field RotationSpeedCurve UCurveFloat
---@field AnimIdleList TArray<UAnimSequence>
---@field LeanPitchAdditvie_Up UAnimSequence
---@field LeanPitchAdditvie_Down UAnimSequence
---@field StartFwd UAnimSequence
---@field StartFwdL UAnimSequence
---@field StartFwdR UAnimSequence
---@field StartBwdL UAnimSequence
---@field StartBwdR UAnimSequence
---@field RunLoop UAnimSequence
---@field RushLoop UAnimSequence
---@field RunLoopAdditvie_Left UAnimSequence
---@field RunLoopAdditvie_Right UAnimSequence
---@field RushLoopAdditvie_Left UAnimSequence
---@field RushLoopAdditvie_Right UAnimSequence
---@field RunStop UAnimSequence
---@field RushStop UAnimSequence
---@field CloudFallLoop UAnimSequence
---@field CloudLand_High FAnimHumanoidSetting_Jump_Land
---@field CloudLand_Low FAnimHumanoidSetting_Jump_Land
---@field CloudBreakAnimSettings TMap<int32, FCloudBreakAnimSetting>
FAnimHumanoidSetting_CloudLocomotion = {}



---@class FAnimHumanoidSetting_Common
---@field bDisableABPMove boolean
---@field ABPMoveMode EABPMoveMode
---@field AnimSeqIdle UAnimSequence
---@field RetargetAnimSeqIdle UAnimSequence
---@field bLockUseFreeMode boolean
---@field AnimTurnMinAngle float
---@field AnimTurnLeft90 UAnimSequence
---@field AnimTurnRight90 UAnimSequence
---@field AnimTurnLeft180 UAnimSequence
---@field AnimTurnRight180 UAnimSequence
FAnimHumanoidSetting_Common = {}



---@class FAnimHumanoidSetting_DingShen
---@field AnimDingShenStart UAnimSequence
---@field AnimDingShenHold UAnimSequence
FAnimHumanoidSetting_DingShen = {}



---@class FAnimHumanoidSetting_Fall
---@field AnimFallStart UAnimSequence
---@field AnimFallLoop UAnimSequence
---@field LandSetting FAnimHumanoidSetting_Jump_Land
FAnimHumanoidSetting_Fall = {}



---@class FAnimHumanoidSetting_FlyControl
---@field BSFly UBlendSpace
---@field ASFlyUpward UAnimSequence
---@field ASFlyDownward UAnimSequence
---@field ASFlyUpToDown UAnimSequence
---@field ASFlyDownToUp UAnimSequence
---@field BSFlyLean UBlendSpace
FAnimHumanoidSetting_FlyControl = {}



---@class FAnimHumanoidSetting_FootIK
---@field bEnableIK boolean
---@field bEnableForefootIK boolean
---@field bEnableQuadrupedIK boolean
---@field bFootUseFBIK boolean
FAnimHumanoidSetting_FootIK = {}



---@class FAnimHumanoidSetting_GlideJump
---@field ASGlideJumpStart UAnimSequence
FAnimHumanoidSetting_GlideJump = {}



---@class FAnimHumanoidSetting_GlideMove
---@field bEnableGlideAnim boolean
---@field MoveParamCurve UCurveVector
---@field Start FAnimHumanoidSetting_GlideMove_Start
---@field Loop FAnimHumanoidSetting_GlideMove_Loop
---@field End FAnimHumanoidSetting_GlideMove_End
FAnimHumanoidSetting_GlideMove = {}



---@class FAnimHumanoidSetting_GlideMove_End
---@field ASGlideEndSlow UAnimSequence
---@field ASGlideEndFast UAnimSequence
FAnimHumanoidSetting_GlideMove_End = {}



---@class FAnimHumanoidSetting_GlideMove_Loop
---@field ASGlideLoopSteep UAnimSequence
---@field BSGlideLoopSteepAdditive UBlendSpace
---@field ASGlideLoopFlatSlow UAnimSequence
---@field ASGlideLoopFlatFast UAnimSequence
---@field BSGlideLoopFlatSlowDirAdditive UBlendSpace
---@field BSGlideLoopFlatFastDirAdditive UBlendSpace
---@field BSGlideLoopFlatVerticalInputAdditive UBlendSpace
---@field BSGlideLoopFlatHorizonalInputAdditive UBlendSpace
---@field ASGlideLoopFlatRotationLeftAdditive UAnimSequence
---@field ASGlideLoopFlatRotationRightAdditive UAnimSequence
FAnimHumanoidSetting_GlideMove_Loop = {}



---@class FAnimHumanoidSetting_GlideMove_Start
---@field ASGlideStartGroundFlatSlow UAnimSequence
---@field ASGlideStartGroundFlatFast UAnimSequence
---@field ASGlideStartGroundSteepSlow UAnimSequence
---@field ASGlideStartGroundSteepFast UAnimSequence
---@field ASGlideStartAirFlatSlow UAnimSequence
---@field ASGlideStartAirFlatFast UAnimSequence
---@field ASGlideStartAirSteepSlow UAnimSequence
---@field ASGlideStartAirSteepFast UAnimSequence
---@field ASGlideStartBackAirFlat UAnimSequence
---@field ASGlideStartBackAirSteep UAnimSequence
FAnimHumanoidSetting_GlideMove_Start = {}



---@class FAnimHumanoidSetting_Jump
---@field CustomJumpVelocityIncrementWhenPressed float
---@field CustomJumpVelocityIncrementWhenPressed_Locked float
---@field BS_jump_start_fwd UBlendSpace
---@field BS_jump_start_bwd UBlendSpace
---@field BS_jump_loop_fwd UBlendSpace
---@field BS_jump_loop_bwd UBlendSpace
---@field BS_jump_additive_lean UBlendSpace
---@field BS_jump_additive_rot UBlendSpace
---@field AnimJumpStart_N UAnimSequence
---@field AnimJumpStart_F UAnimSequence
---@field AnimJumpStart_L UAnimSequence
---@field AnimJumpStart_R UAnimSequence
---@field AnimJumpStart_B UAnimSequence
---@field AnimFallStart_N UAnimSequence
---@field AnimFallStart_F UAnimSequence
---@field AnimFallStart_F_Dash UAnimSequence
---@field AnimFallStart_B UAnimSequence
---@field AnimFallStart_L UAnimSequence
---@field AnimFallStart_R UAnimSequence
---@field AnimFallLoop UAnimSequence
---@field TriggerLandHeight float
---@field HeightDividingLine_Low float
---@field HeightDividingLine_Mid float
---@field Land_F_Low FAnimHumanoidSetting_Jump_Land
---@field Land_F_Mid FAnimHumanoidSetting_Jump_Land
---@field Land_F_High FAnimHumanoidSetting_Jump_Land
---@field Land_L FAnimHumanoidSetting_Jump_Land
---@field Land_R FAnimHumanoidSetting_Jump_Land
---@field Land_B FAnimHumanoidSetting_Jump_Land
---@field AddtiveMoveAfterJump_F UAnimSequence
---@field AddtiveMoveAfterJump_B UAnimSequence
---@field AddtiveMoveAfterJump_L UAnimSequence
---@field AddtiveMoveAfterJump_R UAnimSequence
---@field GlideJump FAnimHumanoidSetting_GlideJump
FAnimHumanoidSetting_Jump = {}



---@class FAnimHumanoidSetting_Jump_Land
---@field AnimSeq_Land UAnimSequence
---@field WalkAnimLand_MoveTime float
---@field AnimLand_MoveTime float
---@field AnimLand_JumpTime float
---@field AnimLand_AttackTime float
---@field AnimLand_DodgeTime float
FAnimHumanoidSetting_Jump_Land = {}



---@class FAnimHumanoidSetting_MonsterLocomotion
---@field Free FAnimHumanoidSetting_MonsterLocomotion_Free
---@field Lock FAnimHumanoidSetting_MonsterLocomotion_Lock
FAnimHumanoidSetting_MonsterLocomotion = {}



---@class FAnimHumanoidSetting_MonsterLocomotion_Free
---@field ASFreeRunFwd UAnimSequence
---@field ASFreeRunStartFwd UAnimSequence
---@field ASFreeRunStartFR UAnimSequence
---@field ASFreeRunStartBR UAnimSequence
---@field ASFreeRunStartFL UAnimSequence
---@field ASFreeRunStartBL UAnimSequence
---@field BSFreeLeanAdditive UBlendSpace
---@field BSFreeRotAdditive UBlendSpace
---@field ASFreeRunStopLeftFoot UAnimSequence
---@field ASFreeRunStopRightFoot UAnimSequence
FAnimHumanoidSetting_MonsterLocomotion_Free = {}



---@class FAnimHumanoidSetting_MonsterLocomotion_Lock
---@field ASLockWalkFwd UAnimSequence
---@field ASLockWalkFR UAnimSequence
---@field ASLockWalkBR UAnimSequence
---@field ASLockWalkFL UAnimSequence
---@field ASLockWalkBL UAnimSequence
---@field ASLockWalkBwd UAnimSequence
---@field ExplicitTimeForLeftFootStop FAnimHumanoidSetting_MonsterLocomotion_Lock_ExplicitTimeForMoveStop
---@field ExplicitTimeForRightFootStop FAnimHumanoidSetting_MonsterLocomotion_Lock_ExplicitTimeForMoveStop
---@field StopLeftBlendAnim FAnimHumanoidSetting_MonsterLocomotion_Lock_StopBlendAnim
---@field StopRightBlendAnim FAnimHumanoidSetting_MonsterLocomotion_Lock_StopBlendAnim
FAnimHumanoidSetting_MonsterLocomotion_Lock = {}



---@class FAnimHumanoidSetting_MonsterLocomotion_Lock_ExplicitTimeForMoveStop
---@field Fwd float
---@field FL float
---@field BL float
---@field FR float
---@field BR float
---@field Bwd float
FAnimHumanoidSetting_MonsterLocomotion_Lock_ExplicitTimeForMoveStop = {}



---@class FAnimHumanoidSetting_MonsterLocomotion_Lock_StopBlendAnim
---@field ASStopBlendAnim UAnimSequence
---@field BlendInTime float
---@field BlendOutTime float
---@field PlayRate float
---@field StartPosition float
FAnimHumanoidSetting_MonsterLocomotion_Lock_StopBlendAnim = {}



---@class FAnimHumanoidSetting_MotionMatching
---@field Walk2RunAA UAnimationAnalyzer
---@field bMMLockUseFreeMode boolean
---@field RotateAdditiveBS UBlendSpace
---@field MMUpBodyStateAlpha float
---@field DefaultMMState State_MM
---@field SpareMoveMode EABPMoveMode
---@field MMState2AACS TMap<State_MM, UBUAnimationAnalyzer>
---@field AnimationAnalyzerBlendTime float
---@field MotionBlendTime float
---@field Retargeter UIKRetargeter
---@field PelvisOffsetZ float
---@field FootOffsetScale float
---@field ForceSetRotAnimSpeed float
---@field DisableRotVerifyAnimSpeed float
---@field ToIdleAnimSpeed float
---@field bNeedFixMM boolean
---@field MMAdditivePose UAnimSequence
---@field MMAdditiveWeight float
---@field bFixMMWeapon_MeshSpaceRotation boolean
---@field bFixMMAdditive_MeshSpaceRotation boolean
---@field MMAdditiveLayerSetup TArray<FGSInputBlendPose>
FAnimHumanoidSetting_MotionMatching = {}



---@class FAnimHumanoidSetting_ParkourMove
---@field bEnableParkourAnim boolean
---@field ASStrideUpLeftFootLow UAnimSequence
---@field ASStrideUpRightFootLow UAnimSequence
---@field ASStrideUpLeftFootHigh UAnimSequence
---@field ASStrideUpRightFootHigh UAnimSequence
---@field ASStrideUpLeftFootFall UAnimSequence
---@field ASStrideUpRightFootFall UAnimSequence
---@field ASStrideUpLeftFootEnd UAnimSequence
---@field ASStrideUpRightFootEnd UAnimSequence
---@field ASStrideUpLeftFootLandMove UAnimSequence
---@field ASStrideUpRightFootLandMove UAnimSequence
---@field ASStrideDownLeftFoot UAnimSequence
---@field ASStrideDownRightFoot UAnimSequence
---@field ASStrideDownLeftFootFall UAnimSequence
---@field ASStrideDownRightFootFall UAnimSequence
---@field ASStrideDownLeftFootEnd UAnimSequence
---@field ASStrideDownRightFootEnd UAnimSequence
---@field ASStrideDownLeftFootLandMove UAnimSequence
---@field ASStrideDownRightFootLandMove UAnimSequence
FAnimHumanoidSetting_ParkourMove = {}



---@class FAnimHumanoidSetting_ParkourMove_Across
---@field Low FAnimHumanoidSetting_ParkourMove_Across_Low
---@field Normal FAnimHumanoidSetting_ParkourMove_Across_Normal
---@field High FAnimHumanoidSetting_ParkourMove_Across_High
FAnimHumanoidSetting_ParkourMove_Across = {}



---@class FAnimHumanoidSetting_ParkourMove_Across_High
---@field ASParkourHighAcrossStart UAnimSequence
---@field ASParkourHighAcrossThrough UAnimSequence
---@field ASParkourHighAcrossFallLoop UAnimSequence
---@field ASParkourHighAcrossLand UAnimSequence
---@field ASParkourHighAcrossLandMove UAnimSequence
FAnimHumanoidSetting_ParkourMove_Across_High = {}



---@class FAnimHumanoidSetting_ParkourMove_Across_Low
---@field ASParkourLowAcrossStart UAnimSequence
---@field ASParkourLowAcrossThrough UAnimSequence
---@field ASParkourLowAcrossFallLoop UAnimSequence
---@field ASParkourLowAcrossLand UAnimSequence
---@field ASParkourLowAcrossLandMove UAnimSequence
FAnimHumanoidSetting_ParkourMove_Across_Low = {}



---@class FAnimHumanoidSetting_ParkourMove_Across_Normal
---@field ASParkourNormalAcrossStart UAnimSequence
---@field ASParkourNormalAcrossThrough UAnimSequence
---@field ASParkourNormalAcrossFallLoop UAnimSequence
---@field ASParkourNormalAcrossLand UAnimSequence
---@field ASParkourNormalAcrossLandMove UAnimSequence
FAnimHumanoidSetting_ParkourMove_Across_Normal = {}



---@class FAnimHumanoidSetting_ParkourMove_Climb
---@field Low FAnimHumanoidSetting_ParkourMove_Climb_Low
---@field Normal FAnimHumanoidSetting_ParkourMove_Climb_Normal
---@field High FAnimHumanoidSetting_ParkourMove_Climb_High
FAnimHumanoidSetting_ParkourMove_Climb = {}



---@class FAnimHumanoidSetting_ParkourMove_Climb_High
---@field ASParkourHighClimbStart UAnimSequence
---@field ASParkourHighClimbGetUp UAnimSequence
---@field ASParkourHighClimbFallLoop UAnimSequence
---@field ASParkourHighClimbLand UAnimSequence
---@field ASParkourHighClimbLandMove UAnimSequence
FAnimHumanoidSetting_ParkourMove_Climb_High = {}



---@class FAnimHumanoidSetting_ParkourMove_Climb_Low
---@field ASParkourLowClimbStart UAnimSequence
---@field ASParkourLowClimbGetUp UAnimSequence
---@field ASParkourLowClimbFallLoop UAnimSequence
---@field ASParkourLowClimbLand UAnimSequence
---@field ASParkourLowClimbLandMove UAnimSequence
FAnimHumanoidSetting_ParkourMove_Climb_Low = {}



---@class FAnimHumanoidSetting_ParkourMove_Climb_Normal
---@field ASParkourNormalClimbStart UAnimSequence
---@field ASParkourNormalClimbGetUp UAnimSequence
---@field ASParkourNormalClimbFallLoop UAnimSequence
---@field ASParkourNormalClimbLand UAnimSequence
---@field ASParkourNormalClimbLandMove UAnimSequence
FAnimHumanoidSetting_ParkourMove_Climb_Normal = {}



---@class FAnimHumanoidSetting_Patrol
---@field AnimIdle UAnimSequence
---@field BSWalkFwd UBlendSpace
---@field BSWalkBwd UBlendSpace
---@field BSWalkLeft UBlendSpace
---@field BSWalkRight UBlendSpace
---@field BSRunFwd UBlendSpace
---@field BSRunBwd UBlendSpace
---@field BSRunLeft UBlendSpace
---@field BSRunRight UBlendSpace
FAnimHumanoidSetting_Patrol = {}



---@class FAnimHumanoidSetting_PlayerLocomotion
---@field ASIdleList TArray<UAnimSequence>
---@field ASSequenceTransitionMoveFromWalkLFoot UAnimSequence
---@field ASSequenceTransitionMoveFromWalkRFoot UAnimSequence
---@field ASSequenceTransitionMoveFromRunLFoot UAnimSequence
---@field ASSequenceTransitionMoveFromRunRFoot UAnimSequence
---@field ASSequenceTransitionMoveFromRushLFoot UAnimSequence
---@field ASSequenceTransitionMoveFromRushRFoot UAnimSequence
---@field Free FAnimHumanoidSetting_PlayerLocomotion_Free
---@field Lock FAnimHumanoidSetting_PlayerLocomotion_Lock
FAnimHumanoidSetting_PlayerLocomotion = {}



---@class FAnimHumanoidSetting_PlayerLocomotion_Free
---@field FreeMovementCurve UCurveVector
---@field BSFreeAdditiveMovingLean UBlendSpace
---@field BSWalkLoopFwd UBlendSpace
---@field BSRunLoopFwd UBlendSpace
---@field BSRunLoopAdditive UBlendSpace
---@field BSRunLoopRotationAdditive UBlendSpace
---@field BSRushLoopFwd UBlendSpace
---@field BSRushLoopLean UBlendSpace
---@field ASWalkStartBwdL UAnimSequence
---@field ASWalkStartLeft UAnimSequence
---@field ASWalkStartFwd UAnimSequence
---@field ASWalkStartRight UAnimSequence
---@field ASWalkStartBwdR UAnimSequence
---@field ASWalkTurnBwdL UAnimSequence
---@field ASWalkTurnLeft UAnimSequence
---@field ASWalkTurnRight UAnimSequence
---@field ASWalkTurnBwdR UAnimSequence
---@field ASFreeWalkStop UAnimSequence
---@field ASRunStartBwdL UAnimSequence
---@field ASRunStartLeft UAnimSequence
---@field ASRunStartFwd UAnimSequence
---@field ASRunStartRight UAnimSequence
---@field ASRunStartBwdR UAnimSequence
---@field ASRunTurnBwdL UAnimSequence
---@field ASRunTurnLeft UAnimSequence
---@field ASRunTurnFwdL UAnimSequence
---@field ASRunTurnFwdR UAnimSequence
---@field ASRunTurnRight UAnimSequence
---@field ASRunTurnBwdR UAnimSequence
---@field ASRunTurnFwdFallingVelocityAdditive UAnimSequence
---@field ASRunTurnFwdSpeedAdditive UAnimSequence
---@field ASRunTurnBwdFallingVelocityAdditive UAnimSequence
---@field ASFreeRunStop UAnimSequence
---@field ASFreeSprintStartBwdL UAnimSequence
---@field ASFreeSprintStartLeft UAnimSequence
---@field ASFreeSprintStartFwd UAnimSequence
---@field ASFreeSprintStartRight UAnimSequence
---@field ASFreeSprintStartBwdR UAnimSequence
---@field ASFreeSprintTurnBwdL UAnimSequence
---@field ASFreeSprintTurnLeft UAnimSequence
---@field ASFreeSprintTurnRight UAnimSequence
---@field ASFreeSprintTurnBwdR UAnimSequence
---@field ASFreeSprintStop UAnimSequence
---@field SprintStopSlopeAngleThreshold float
---@field ASFreeSprintStopSlopeUp UAnimSequence
FAnimHumanoidSetting_PlayerLocomotion_Free = {}



---@class FAnimHumanoidSetting_PlayerLocomotion_Lock
---@field LockMovementCurve UCurveVector
---@field ASLockWalkLoopFwd UAnimSequence
---@field ASLockWalkLoopBwd UAnimSequence
---@field ASLockWalkLoopLeftF UAnimSequence
---@field ASLockWalkLoopRightF UAnimSequence
---@field ASLockWalkLoopLeftB UAnimSequence
---@field ASLockWalkLoopRightB UAnimSequence
---@field ASLockWalkLoopLeftFAdd UAnimSequence
---@field ASLockWalkLoopRightFAdd UAnimSequence
---@field ASLockRunLoopFwd UAnimSequence
---@field ASLockRunLoopLeftF UAnimSequence
---@field ASLockRunLoopLeftB UAnimSequence
---@field ASLockRunLoopLeftFAdd UAnimSequence
---@field ASLockRunLoopRightF UAnimSequence
---@field ASLockRunLoopRightB UAnimSequence
---@field ASLockRunLoopRightFAdd UAnimSequence
---@field ASLockRunLoopBwd UAnimSequence
---@field BSLockWalkStartFwd UBlendSpace
---@field BSLockWalkStartBwd UBlendSpace
---@field ASLockWalkStartFwdL UAnimSequence
---@field ASLockWalkStartFwdR UAnimSequence
---@field ASLockWalkStartBwdL UAnimSequence
---@field ASLockWalkStartBwdR UAnimSequence
---@field ASLockWalkStartLeftF UAnimSequence
---@field ASLockWalkStartLeftB UAnimSequence
---@field ASLockWalkStartRightF UAnimSequence
---@field ASLockWalkStartRightB UAnimSequence
---@field BSLockRunStartFwd UBlendSpace
---@field BSLockRunStartBwd UBlendSpace
---@field ASLockRunStartFwdL UAnimSequence
---@field ASLockRunStartFwdR UAnimSequence
---@field ASLockRunStartBwdL UAnimSequence
---@field ASLockRunStartBwdR UAnimSequence
---@field ASLockRunStartLeftF UAnimSequence
---@field ASLockRunStartLeftB UAnimSequence
---@field ASLockRunStartRightF UAnimSequence
---@field ASLockRunStartRightB UAnimSequence
---@field BSLockWalkTurnF2B UBlendSpace
---@field BSLockWalkTurnB2F UBlendSpace
---@field BSLockWalkTurnFR2BL UBlendSpace
---@field BSLockWalkTurnBR2FL UBlendSpace
---@field BSLockWalkTurnBL2FR UBlendSpace
---@field BSLockWalkTurnFL2BR UBlendSpace
---@field BSLockWalkTurnFR2FL UBlendSpace
---@field BSLockWalkTurnFL2FR UBlendSpace
---@field BSLockWalkTurnBL2FL UBlendSpace
---@field BSLockWalkTurnFL2BL UBlendSpace
---@field BSLockWalkTurnBR2FR UBlendSpace
---@field BSLockWalkTurnFR2BR UBlendSpace
---@field BSLockRunTurnF2B UBlendSpace
---@field BSLockRunTurnB2F UBlendSpace
---@field BSLockRunTurnBR2FL UBlendSpace
---@field BSLockRunTurnFR2FL UBlendSpace
---@field BSLockRunTurnBL2FL UBlendSpace
---@field BSLockRunTurnFR2BL UBlendSpace
---@field BSLockRunTurnFL2BL UBlendSpace
---@field BSLockRunTurnFL2FR UBlendSpace
---@field BSLockRunTurnBL2FR UBlendSpace
---@field BSLockRunTurnBR2FR UBlendSpace
---@field BSLockRunTurnFL2BR UBlendSpace
---@field BSLockRunTurnFR2BR UBlendSpace
---@field BSLockTurnFRFromFRBL UBlendSpace
---@field BSLockTurnFRFromFLBR UBlendSpace
---@field BSLockTurnBRFromFRBL UBlendSpace
---@field BSLockTurnBRFromFLBR UBlendSpace
---@field BSLockTurnBLFromFRBL UBlendSpace
---@field BSLockTurnBLFromFLBR UBlendSpace
---@field BSLockTurnFLFromFRBL UBlendSpace
---@field BSLockTurnFLFromFLBR UBlendSpace
---@field BSLockTurnStopFL UBlendSpace
---@field BSLockTurnStopFR UBlendSpace
---@field BSLockTurnStopBL UBlendSpace
---@field BSLockTurnStopBR UBlendSpace
---@field ASLockWalkStopFwd UAnimSequence
---@field ASLockWalkStopBwd UAnimSequence
---@field ASLockWalkStopLeftF UAnimSequence
---@field ASLockWalkStopLeftB UAnimSequence
---@field ASLockWalkStopRightF UAnimSequence
---@field ASLockWalkStopRightB UAnimSequence
---@field ASLockWalkStopFL45 UAnimSequence
---@field ASLockWalkStopFR45 UAnimSequence
---@field ASLockWalkStopBL45 UAnimSequence
---@field ASLockWalkStopBR45 UAnimSequence
---@field ASLockRunStopFwdL UAnimSequence
---@field ASLockRunStopFwdR UAnimSequence
---@field ASLockRunStopLeftF UAnimSequence
---@field ASLockRunStopLeftB UAnimSequence
---@field ASLockRunStopRightF UAnimSequence
---@field ASLockRunStopRightB UAnimSequence
---@field ASLockRunStopBwdL UAnimSequence
---@field ASLockRunStopBwdR UAnimSequence
FAnimHumanoidSetting_PlayerLocomotion_Lock = {}



---@class FAnimHumanoidSetting_QuadrupedLocomotion
---@field AnimIdleList TArray<UAnimSequence>
---@field BSMove UBlendSpace
---@field BSMoveBack UBlendSpace
---@field ASWalkStop UAnimSequence
---@field ASRunStartF UAnimSequence
---@field ASRunStartL UAnimSequence
---@field ASRunStartR UAnimSequence
---@field ASRunStartBL UAnimSequence
---@field ASRunStartBR UAnimSequence
---@field ASRunTurnStop UAnimSequence
---@field ASRunTurnL UAnimSequence
---@field ASRunTurnR UAnimSequence
---@field ASRunTurnBL UAnimSequence
---@field ASRunTurnBR UAnimSequence
---@field ASRunStop UAnimSequence
---@field ASRushStartF UAnimSequence
---@field ASRushStartL UAnimSequence
---@field ASRushStartR UAnimSequence
---@field ASRushStartBL UAnimSequence
---@field ASRushStartBR UAnimSequence
---@field ASRushTurnStop UAnimSequence
---@field ASRushTurnL UAnimSequence
---@field ASRushTurnR UAnimSequence
---@field ASRushTurnBL UAnimSequence
---@field ASRushTurnBR UAnimSequence
---@field ASRushStop UAnimSequence
---@field ASRunJump UAnimSequence
---@field ASRushJump UAnimSequence
---@field ASRunJumpSlope UAnimSequence
---@field ASRushJumpSlope UAnimSequence
---@field JumpSlopeAngleThreahold float
---@field ASRunFall UAnimSequence
---@field ASRushFall UAnimSequence
---@field ASRunFallSlope UAnimSequence
---@field ASRushFallSlope UAnimSequence
---@field ASRunLandMove UAnimSequence
---@field ASRushLandMove UAnimSequence
---@field ASRunLandMoveSlope UAnimSequence
---@field ASRushLandMoveSlope UAnimSequence
---@field ASRunLandStop UAnimSequence
---@field ASRushLandStop UAnimSequence
---@field ASRunLandStopSlope UAnimSequence
---@field ASRushLandStopSlope UAnimSequence
FAnimHumanoidSetting_QuadrupedLocomotion = {}



---@class FAnimHumanoidSetting_Simple4Dir
---@field BSStart UBlendSpace
---@field BSEnd UBlendSpace
---@field CardinalDirectionBlendTime float
---@field BSWalkFwd UBlendSpace
---@field BSWalkBwd UBlendSpace
---@field BSWalkLeft UBlendSpace
---@field BSWalkRight UBlendSpace
---@field BSRunFwd UBlendSpace
---@field BSRunBwd UBlendSpace
---@field BSRunLeft UBlendSpace
---@field BSRunRight UBlendSpace
---@field BSSprint UBlendSpace
FAnimHumanoidSetting_Simple4Dir = {}



---@class FAnimHumanoidSetting_SpecialAdditive
---@field MinSlopeAngle float
---@field MaxSlopeAngle float
---@field ASSlopeAdditiveLocalSpace UAnimSequence
---@field ASSlopeAdditiveMeshSpace UAnimSequence
---@field BSMoveSpeedAdditive UBlendSpace
FAnimHumanoidSetting_SpecialAdditive = {}



---@class FAnimHumanoidSetting_Spider
---@field AnimSeqIdle UAnimSequence
---@field JumpStart UAnimSequence
---@field JumpLoop UAnimSequence
---@field JumpEndLight UAnimSequence
---@field JumpEndHeavy UAnimSequence
---@field FallingHeightThreshold float
---@field RelativeScale float
---@field LegMoveDistance TArray<float>
---@field LegForwardDistance TArray<float>
---@field LegNames TArray<FName>
FAnimHumanoidSetting_Spider = {}



---@class FAnimHumanoidSetting_Spider_Character
---@field bodyTransOffset FTransform
---@field TargetTransform FTransform
---@field bodyTransLerpSpeed float
---@field meanHeadHeight float
---@field meanGroundNormal FVector
---@field maxHeadHeight float
---@field GroundedFootNum float
---@field standardHeadHeight float
---@field capsuleHeightOffset float
FAnimHumanoidSetting_Spider_Character = {}



---@class FAnimHumanoidSetting_Spider_Speed
---@field forwardSpeed float
---@field turnSpeed float
---@field sideStepSpeed float
---@field targetForwardSpeed float
---@field targetTurnSpeed float
---@field targetSideStepSpeed float
---@field forwardSpeedScale float
---@field turnSpeedScale float
---@field sideStepSpeedScale float
---@field speedLerpSpeed float
---@field IKInterpSpeedFast float
---@field IKInterpSpeedSlow float
FAnimHumanoidSetting_Spider_Speed = {}



---@class FAnimHumanoidSetting_Spider_Trace
---@field traceHeadDistance float
---@field traceHalfHeight float
---@field traceHalfWidth float
---@field traceGridHeight float
---@field traceGridWidth float
---@field maxTraceNumber int32
---@field verticalDivisionNumber int32
---@field horizontalDivisionNumber int32
---@field IKTraceDistance float
---@field maxLegIkOffset float
FAnimHumanoidSetting_Spider_Trace = {}



---@class FAnimHumanoidSetting_SpineIK
---@field bEnableSpineIK boolean
---@field bEnableSpineIKDebug boolean
---@field SpineIKTraceUpDistance float
---@field SpineIKTraceDownDistance float
---@field OffsetPitch float
---@field OffsetRoll float
---@field LerpSpeed float
---@field DisableLimbIKAlpha boolean
---@field IgnoreDistance float
---@field LimbIKDataList TArray<FLimbIKData>
FAnimHumanoidSetting_SpineIK = {}



---@class FAnimHumanoidSetting_StriderMove
---@field StriderStopTime float
---@field StriderStopDistance float
---@field StriderLoopAnimTimeStart float
---@field StriderGuiChuTime float
---@field StriderSingleStep float
FAnimHumanoidSetting_StriderMove = {}



---@class FAnimKeyStateBlendCfg
---@field AnimationName FString
---@field EasingFullTime float
---@field EasingFunc EEasingFunc::Type
---@field NeedEasingBlendExp boolean
---@field EasingBlendExp float
---@field NeedEasingSteps boolean
---@field EasingSteps int32
---@field DelayEasingTime float
---@field EnumValEasingType EGSAnimKBEnumBoolEasing::Type
---@field BoolValEasingType EGSAnimKBEnumBoolEasing::Type
FAnimKeyStateBlendCfg = {}



---@class FAnimMotionMatchingConfig
FAnimMotionMatchingConfig = {}


---@class FAnimWheelSetting_WheelMove
---@field MoveNearParamCurve UCurveVector
---@field MoveFarParamCurve UCurveVector
---@field ASIdle UAnimSequence
---@field ASSpeedUp UAnimSequence
---@field ASSpeedDown UAnimSequence
---@field ASMoveLoop UAnimSequence
---@field BSRotationAdditive UBlendSpace
FAnimWheelSetting_WheelMove = {}



---@class FAnimalSpawnTemplate
---@field AnimalTamerClass TSubclassOf<ABUTamerActor>
---@field SpawnCountRange FInt32Range
---@field ScaleRange FFloatRange
FAnimalSpawnTemplate = {}



---@class FAnimationInfo
---@field AnimationClipName FString
---@field AnimationClipStartTime float
---@field AnimationClipEndTime float
---@field DisableInputAtStart boolean
FAnimationInfo = {}



---@class FAnimationInfoWithRef
---@field WidgetAnimationRef UWidgetAnimation
---@field AnimInfo FAnimationInfo
FAnimationInfoWithRef = {}



---@class FAnimationRestoreInfo
---@field RestoreState boolean
FAnimationRestoreInfo = {}



---@class FAreaAbilityMask
---@field mask int32
FAreaAbilityMask = {}



---@class FAreaUnitFilter
---@field UnitFilterType AreaUnitFilterType
---@field SpecifiedResIDList TArray<int32>
FAreaUnitFilter = {}



---@class FAttackIKBonePairs
---@field AttackIKRootBoneName FName
---@field AttackIKLimbBoneName FName
---@field AttackIKRoll float
---@field AttackIKPitch float
---@field AttackIKTargetActorBoneName FName
---@field AttackIKBlendMinDistance float
---@field AttackIKBlendMaxDistance float
---@field AttackIKLimitEnable boolean
---@field AttackIKPitchLimit FVector2D
FAttackIKBonePairs = {}



---@class FAttackIKBoneScale
---@field TargetBoneScaleName FName
---@field TargetBoneName FName
---@field BoneScaleOffset float
---@field BoneScaleDistanceLimit FVector2D
---@field BoneScaleYawLimit float
FAttackIKBoneScale = {}



---@class FAudioConfig
---@field AudioEvent UAkAudioEvent
---@field DelayTime float
FAudioConfig = {}



---@class FAutoMoveMonitorConfigItem
---@field AssetPath FString
---@field Desc FString
FAutoMoveMonitorConfigItem = {}



---@class FAutoSizeScrollData
---@field StopSpeed float
---@field Acceleration float
---@field ScrollTime float
---@field AttractTime float
FAutoSizeScrollData = {}



---@class FAutoTestPlayerCastSkillConditionGroup
---@field describe FString
---@field ConditionConfigs TArray<FAutoTestPlayerConditionConfig>
FAutoTestPlayerCastSkillConditionGroup = {}



---@class FAutoTestPlayerConditionConfig
---@field ConditionType EGSAutoTestPlayerCastConditionType
---@field UnitState EBGUUnitState
---@field AttrFloatType EBGUAttrFloat
---@field CompareOperation ValueCompareOperations
---@field FloatValue float
---@field IntValue int32
---@field InverseCondition boolean
FAutoTestPlayerConditionConfig = {}



---@class FAvoidObstacleSection
---@field StartAngle float
---@field EndAngle float
---@field SkillList TArray<int32>
FAvoidObstacleSection = {}



---@class FB1DBC_ExtraSetting
---@field TransformType EDBCTransformType
FB1DBC_ExtraSetting = {}



---@class FBGUCostAttrInfo
---@field Attr EBGUAttrFloat
---@field CostValue float
FBGUCostAttrInfo = {}



---@class FBUC_DispLibDBC_CameraEnvFXInfo
---@field LevelName FName
---@field NiagaraSystem UNiagaraSystem
FBUC_DispLibDBC_CameraEnvFXInfo = {}



---@class FBUC_DispLibDBC_ChangeMaterial
---@field FilterMode FBUC_DispLibDBC_MaterialEffectTargetInfo
---@field Delay float
---@field EndMode DispLibDBCEndMode
---@field Duration float
---@field DelayTimeAfterStop float
---@field Template UMaterialInterface
---@field InheriParamsMode DispLibMaterialParamsInheritMode
---@field InheritScalarParam TArray<FName>
---@field InheritFLinearColorParam TArray<FName>
---@field InheritTextureParam TArray<FName>
---@field SetScalarParam TArray<FBUC_DispLibUtil_NameAndScalar>
---@field SetColorParam TArray<FBUC_DispLibUtil_NameAndLColor>
---@field SetCurveScalarParam TArray<FBUC_DispLibUtil_NameAndScalarCurve>
---@field SetCurveLColorParam TArray<FBUC_DispLibUtil_NameAndLColorCurve>
---@field SetCurveV3Param TArray<FBUC_DispLibUtil_NameAndVectorCurve>
---@field EndStage_SetPCurveScalarParam TArray<FBUC_DispLibUtil_PCurve_NameAndScalar>
---@field EndStage_SetPCurveLColorParam TArray<FBUC_DispLibUtil_PCurve_NameAndLColor>
---@field PausePriority int32
---@field EndStagePriority int32
FBUC_DispLibDBC_ChangeMaterial = {}



---@class FBUC_DispLibDBC_CustomEvent
---@field TriggerMode DispLibDBCCustomEventTriggerMode
---@field DelayTime float
---@field EndMode DispLibDBCEndMode
---@field Duration float
---@field DelayTimeAfterStop float
---@field ParametersDataAssets UDispLibDBCCustomEventDataAssetBase
FBUC_DispLibDBC_CustomEvent = {}



---@class FBUC_DispLibDBC_EntityEffectTargetInfo
---@field CompsFilterMode DispLibDBCCompsFilterMode
---@field CompTags TArray<FName>
FBUC_DispLibDBC_EntityEffectTargetInfo = {}



---@class FBUC_DispLibDBC_Heat
---@field EventName FName
---@field SocketName FName
---@field SocketLocalOffset FVector
---@field SocketLocalRotation FVector
---@field Radius float
---@field TriggerProbability float
---@field MinIntensity float
---@field MaxIntensity float
---@field DistanceDamplingRate float
---@field RangeAxis DispLibDBCAxisMode
---@field RangeMask float
---@field PausePriority int32
FBUC_DispLibDBC_Heat = {}



---@class FBUC_DispLibDBC_MaterialEffectTargetInfo
---@field CompsFilterMode DispLibDBCCompsFilterMode
---@field CompTags TArray<FName>
---@field MatsFilterMode DispLibDBCMaterialsFilterMode
---@field MatSlotNames TArray<FName>
---@field MatIndexes TArray<int32>
---@field MatShaders TArray<UMaterial>
FBUC_DispLibDBC_MaterialEffectTargetInfo = {}



---@class FBUC_DispLibDBC_ModifyMaterial
---@field FilterMode FBUC_DispLibDBC_MaterialEffectTargetInfo
---@field Delay float
---@field EndMode DispLibDBCEndMode
---@field Duration float
---@field DelayTimeAfterStop float
---@field Template UMaterialInterface
---@field InheriParamsMode DispLibMaterialParamsInheritMode
---@field InheritScalarParam TArray<FName>
---@field InheritFLinearColorParam TArray<FName>
---@field InheritTextureParam TArray<FName>
---@field SetScalarParam TArray<FBUC_DispLibUtil_DBCAdvProcessScalarMatLayerParam>
---@field SetFLinearColorParam TArray<FBUC_DispLibUtil_DBCAdvProcessFLinearColorMatLayerParam>
---@field SetTextureParam TArray<FBUC_DispLibUtil_DBCTextureMatLayerParam>
---@field SetPCurveScalarParam TArray<FBUC_DispLibUtil_DBCPCurveScalarMatLayerParam>
---@field SetPCurveFLinearColorParam TArray<FBUC_DispLibUtil_DBCPCurveColorMatLayerParam>
---@field PausePriority int32
---@field EndStagePriority int32
---@field ModMatPriority int32
---@field ModMatEndStagePriority int32
FBUC_DispLibDBC_ModifyMaterial = {}



---@class FBUC_DispLibDBC_ModifyMaterialParameterCollection
---@field MPCAssetPath FString
---@field Delay float
---@field EndMode DispLibDBCEndMode
---@field Duration float
---@field DelayTimeAfterStop float
---@field SetScalarParam TArray<FBUC_DispLibUtil_DBCAdvProcessScalarParam>
---@field SetFLinearColorParam TArray<FBUC_DispLibUtil_DBCAdvProcessFLinearColorParam>
---@field SetPCurveScalarParam TArray<FBUC_DispLibUtil_DBCPCurveScalarParam>
---@field SetPCurveFLinearColorParam TArray<FBUC_DispLibUtil_DBCPCurveColorParam>
---@field PausePriority int32
---@field EndStagePriority int32
---@field ModMPCPriority int32
---@field ModMPCEndStagePriority int32
FBUC_DispLibDBC_ModifyMaterialParameterCollection = {}



---@class FBUC_DispLibDBC_ModifyNiagaraParams
---@field MeshCompFilterInfo FBUC_DispLibDBC_EntityEffectTargetInfo
---@field NiagaraCompFilterInfo FBUC_DispLibDBC_ModifyNiagaraTargetInfo
---@field Delay float
---@field EndMode DispLibDBCEndMode
---@field Duration float
---@field DelayTimeAfterStop float
---@field SetBoolParam TArray<FBUC_DispLibUtil_ModNiagara_NameAndBoolValue>
---@field SetFloatParam TArray<FBUC_DispLibUtil_ModifyNiagaraParams_FloatParam>
---@field SetInt32Param TArray<FBUC_DispLibUtil_ModifyNiagaraParams_FloatParam>
---@field SetFVectorParam TArray<FBUC_DispLibUtil_ModifyNiagaraParams_FVectorParam>
---@field SetFLinearColorParam TArray<FBUC_DispLibUtil_ModifyNiagaraParams_FLinearColorParam>
---@field SetFloatArrayParam TArray<FBUC_DispLibUtil_NameAndFloatArray>
---@field SetInt32ArrayParam TArray<FBUC_DispLibUtil_NameAndInt32Array>
---@field SetFVectorArrayParam TArray<FBUC_DispLibUtil_NameAndFVectorArray>
---@field SetOverrideSelfMeshBones TArray<FName>
---@field SetOverrideSelfMeshSockets TArray<FName>
---@field PauseMode DispLibDBCModNiagaraParamsPauseMode
---@field PausePriority int32
---@field EndStagePriority int32
FBUC_DispLibDBC_ModifyNiagaraParams = {}



---@class FBUC_DispLibDBC_ModifyNiagaraTargetInfo
---@field FilterMode DispLibDBCNiagaraFilterMode
---@field TargetString TArray<FName>
---@field TargetSystem UNiagaraSystem
FBUC_DispLibDBC_ModifyNiagaraTargetInfo = {}



---@class FBUC_DispLibDBC_NiagaraEventMergedSettings
---@field Enable boolean
---@field PerCreateCount int32
---@field SendRotationInfo boolean
---@field SendScaleInfo boolean
---@field SendScaleEveryTick boolean
---@field HasCustomVectorParam boolean
---@field CustomVectorParamNameMap TMap<FName, FName>
---@field MergeMangerSystem UNiagaraSystem
FBUC_DispLibDBC_NiagaraEventMergedSettings = {}



---@class FBUC_DispLibDBC_NiagaraEventScalabilitySettings
---@field Enable boolean
---@field PoolMode DispLibDBCNiagaraScalabilityPoolMode
---@field Low FBUC_DispLibDBC_OneEffectQualityNiagaraScalabilitySettings
---@field Medium FBUC_DispLibDBC_OneEffectQualityNiagaraScalabilitySettings
---@field High FBUC_DispLibDBC_OneEffectQualityNiagaraScalabilitySettings
---@field Epic FBUC_DispLibDBC_OneEffectQualityNiagaraScalabilitySettings
---@field Cinematic FBUC_DispLibDBC_OneEffectQualityNiagaraScalabilitySettings
FBUC_DispLibDBC_NiagaraEventScalabilitySettings = {}



---@class FBUC_DispLibDBC_OneEffectQualityNiagaraScalabilitySettings
---@field Enable boolean
---@field MaxSystemInstanceCount int32
---@field Mode DispLibDBCNiagaraScalabilityKillMode
---@field AgeWeight FVector2D
---@field CameraDistanceWeight FVector2D
---@field CameraForwardDirDotWeight FVector2D
---@field CustomWeightAdd float
FBUC_DispLibDBC_OneEffectQualityNiagaraScalabilitySettings = {}



---@class FBUC_DispLibDBC_PlayAdvanceNiagara
---@field Delay float
---@field EndMode DispLibDBCEndMode
---@field Duration float
---@field DelayTimeAfterStop float
---@field DispLogicMode DispLibAdvanceNiagaraDispLogicMode
---@field DestroyTiming DispLibDBCEffectDestroyTiming
---@field Template UNiagaraSystem
---@field OverrideMeshCompTagName FName
---@field AttachedTarget boolean
---@field TargetSocketSearchMode DispLibSocketSearchMode
---@field AttachedTargetSocketName FName
---@field OffsetInLocalSpace boolean
---@field AttachedTargetLocationOffset FVector
---@field AttachedTargetRotationOffset FRotator
---@field AttachedEmitter boolean
---@field EmitterSocketSearchMode DispLibSocketSearchMode
---@field AttachedEmitterSocketName FName
---@field AttachedEmitterLocationOffset FVector
---@field AttachedEmitterRotationOffset FRotator
---@field Scale FVector
---@field SnapGround boolean
---@field SnapGroundRotationMode DispLibDBCSnapGroundRotationMode
---@field CustomV4Param FVector4
---@field SetDBCTransformAsParam boolean
---@field SetSelfSKMeshParam boolean
---@field SetMinorSKMeshParam boolean
---@field UseExtraCustomParams boolean
---@field SetScalarParam TArray<FBUC_DispLibUtil_NameAndScalar>
---@field SetColorParam TArray<FBUC_DispLibUtil_NameAndLColor>
---@field SetCurveScalarParam TArray<FBUC_DispLibUtil_NameAndScalarCurve>
---@field SetCurveLColorParam TArray<FBUC_DispLibUtil_NameAndLColorCurve>
---@field SetCurveV3Param TArray<FBUC_DispLibUtil_NameAndVectorCurve>
---@field DetachOnEndDispStageBegin boolean
---@field AttachConstraintMode DispLibAttachConstraintMode
---@field AttachConstraintValue FVector2D
---@field EnableShadow boolean
---@field EnableVolumetricTranslucentShadow boolean
---@field TranslucentSortPriority int32
---@field DeactiveAtSpawn boolean
---@field ForcePoolModeNone boolean
---@field PausePriority int32
---@field PauseMode DispLibDBCPauseMode
---@field EndStagePriority int32
---@field ForceChangeVisibleStateDEFPriority int32
---@field ForceVisibleStateDefaultMode DispLibDBCNiagaraForceVisibleStateMode
---@field ForceVisibleStateCustomMode TArray<FBUC_DispLibUtil_ForceVisibleStateCustomMode>
---@field MetaString FName
---@field ScalabilitySettings FBUC_DispLibDBC_NiagaraEventScalabilitySettings
---@field MergedSettings FBUC_DispLibDBC_NiagaraEventMergedSettings
FBUC_DispLibDBC_PlayAdvanceNiagara = {}



---@class FBUC_DispLibDBC_PlayArtFresnel
---@field FilterMode FBUC_DispLibDBC_MaterialEffectTargetInfo
---@field Delay float
---@field CustomUAFDataAsset UBUC_DispLibUnitArtFresnelDataAsset
---@field Priority int32
---@field EndMode DispLibDBCEndMode
---@field OverrideTime float
---@field OverrideSimpleProgrammedCurve int32
---@field OverrideFadeInTime float
---@field OverrideCommonTime float
---@field OverrideFadeOutTime float
---@field OverrideProgrammedPowerMax float
---@field OverrideOnePeriodTime float
---@field OverrideLoop int32
---@field PausePriority int32
FBUC_DispLibDBC_PlayArtFresnel = {}



---@class FBUC_DispLibDBC_PlayAudio
---@field Delay float
---@field EndMode DispLibDBCEndMode
---@field Duration float
---@field FollowActor boolean
---@field CompTag FName
---@field SocketName FName
---@field StopOnFollowActorDestroy boolean
---@field AkAudioEvent UAkAudioEvent
---@field RTPC TArray<FBUC_DispLibUtil_DBCAdvProcessScalarParam>
---@field FadeOutTime float
---@field PausePriority int32
FBUC_DispLibDBC_PlayAudio = {}



---@class FBUC_DispLibDBC_PlayCameraShake
---@field Delay float
---@field CameraShake TSubclassOf<UMatineeCameraShake>
---@field Override_Oscillation_Duration float
---@field ForceApply boolean
---@field CustomScaleCurve FBUC_DispLibUtil_DBCPCurveScalar
---@field UseDistanceDamping boolean
---@field AttachedTarget boolean
---@field AttachedTargetSocketName FName
---@field CamShakeScaleByDistCurve UCurveFloat
---@field MaxDistance float
---@field PausePriority int32
FBUC_DispLibDBC_PlayCameraShake = {}



---@class FBUC_DispLibDBC_PlayCascade
---@field Delay float
---@field EndMode DispLibDBCEndMode
---@field Duration float
---@field Template UParticleSystem
---@field AttachedTarget boolean
---@field AttachedTargetSocketName FName
---@field LocationOffset FVector
---@field RotationOffset FRotator
---@field Scale FVector
---@field TranslucentSortPriority int32
FBUC_DispLibDBC_PlayCascade = {}



---@class FBUC_DispLibDBC_PlayCustomCameraShake
---@field Delay float
---@field TotalTime float
---@field DelayTimeAfterStop float
---@field ForceApply boolean
---@field CtrlRO boolean
---@field RO_Noise EOscillatorWaveform
---@field RO_Pitch_Amplitude FBUC_DispLibUtil_DBCPCurveScalar
---@field RO_Yaw_Amplitude FBUC_DispLibUtil_DBCPCurveScalar
---@field RO_Roll_Amplitude FBUC_DispLibUtil_DBCPCurveScalar
---@field RO_Pitch_Frequency FBUC_DispLibUtil_DBCPCurveScalar
---@field RO_Yaw_Frequency FBUC_DispLibUtil_DBCPCurveScalar
---@field RO_Roll_Frequency FBUC_DispLibUtil_DBCPCurveScalar
---@field CtrlLO boolean
---@field LO_Noise EOscillatorWaveform
---@field LO_X_Amplitude FBUC_DispLibUtil_DBCPCurveScalar
---@field LO_Y_Amplitude FBUC_DispLibUtil_DBCPCurveScalar
---@field LO_Z_Amplitude FBUC_DispLibUtil_DBCPCurveScalar
---@field LO_X_Frequency FBUC_DispLibUtil_DBCPCurveScalar
---@field LO_Y_Frequency FBUC_DispLibUtil_DBCPCurveScalar
---@field LO_Z_Frequency FBUC_DispLibUtil_DBCPCurveScalar
---@field CtrlFOV boolean
---@field FOV_Noise EOscillatorWaveform
---@field FOV_Amplitude FBUC_DispLibUtil_DBCPCurveScalar
---@field FOV_Frequency FBUC_DispLibUtil_DBCPCurveScalar
---@field UseDistanceDamping boolean
---@field AttachedTarget boolean
---@field AttachedTargetSocketName FName
---@field CamShakeScaleByDistCurve UCurveFloat
---@field MaxDistance float
---@field PausePriority int32
FBUC_DispLibDBC_PlayCustomCameraShake = {}



---@class FBUC_DispLibDBC_PlayNiagara
---@field Delay float
---@field EndMode DispLibDBCEndMode
---@field Duration float
---@field DelayTimeAfterStop float
---@field DestroyTiming DispLibDBCEffectDestroyTiming
---@field Template UNiagaraSystem
---@field OverrideMeshCompTagName FName
---@field AttachedTarget boolean
---@field AttachedTargetSocketName FName
---@field OffsetInLocalSpace boolean
---@field LocationOffset FVector
---@field RotationOffset FRotator
---@field Scale FVector
---@field SnapGround boolean
---@field SnapGroundRotationMode DispLibDBCSnapGroundRotationMode
---@field DetachOnEndDispStageBegin boolean
---@field EnableShadow boolean
---@field TranslucentSortPriority int32
---@field ForcePoolModeNone boolean
---@field PausePriority int32
---@field PauseMode DispLibDBCPauseMode
---@field EndStagePriority int32
---@field ForceChangeVisibleStateDEFPriority int32
---@field ForceVisibleStateDefaultMode DispLibDBCNiagaraForceVisibleStateMode
---@field MetaString FName
---@field ScalabilitySettings FBUC_DispLibDBC_NiagaraEventScalabilitySettings
FBUC_DispLibDBC_PlayNiagara = {}



---@class FBUC_DispLibDBC_ScenePhysicalInteractor
---@field Delay float
---@field EffectSize FVector
---@field EffectType SceneInteractorType
---@field DestructibleTriggerLevel uint8
---@field Intensity float
---@field Duration float
---@field QueryObjectTypes TArray<EObjectTypeQuery>
---@field DestructibleDamage float
---@field PausePriority int32
FBUC_DispLibDBC_ScenePhysicalInteractor = {}



---@class FBUC_DispLibDBC_SpawnSimpleActor
---@field Delay float
---@field Template TSubclassOf<AActor>
---@field EndMode DispLibDBCEndMode
---@field Duration float
---@field DelayTimeAfterStop float
---@field AttachedTarget boolean
---@field AttachedTargetSocketName FName
---@field AttachedTargetLocationOffset FVector
---@field AttachedTargetRotationOffset FRotator
---@field AttachedEmitter boolean
---@field AttachedEmitterSocketName FName
---@field AttachedEmitterLocationOffset FVector
---@field AttachedEmitterRotationOffset FRotator
---@field DetachOnEndDispStageBegin boolean
---@field PausePriority int32
---@field EndStagePriority int32
FBUC_DispLibDBC_SpawnSimpleActor = {}



---@class FBUC_DispLibDBC_WEFMPermanentWind
---@field EventName FName
---@field SocketName FName
---@field SocketLocalOffset FVector
---@field Radius float
---@field VelocityThreshold float
---@field BaseIntensity float
---@field ScaleVelocityIntensity float
---@field DistanceDamplingRate float
---@field WindMotorMode DispLibDBCWindMotorMode
---@field RangeAxis DispLibDBCAxisMode
---@field RangeAxisLocalRotation FVector
---@field RangeMask float
---@field VelocityDir DispLibDBCAxisMode
---@field VelocityDirLocalRotation FVector
---@field ScaleSecondVelocity float
FBUC_DispLibDBC_WEFMPermanentWind = {}



---@class FBUC_DispLibDBC_WEFMWind
---@field EventName FName
---@field SocketName FName
---@field Delay float
---@field EndMode DispLibDBCEndMode
---@field Duration float
---@field SocketLocalOffset FVector
---@field TriggerProbability float
---@field Radius FBUC_DispLibUtil_DBCAdvProcessScalar
---@field VelocityThreshold float
---@field BaseIntensity FBUC_DispLibUtil_DBCAdvProcessScalar
---@field ScaleVelocityIntensity float
---@field DistanceDamplingRate float
---@field WindMotorMode DispLibDBCWindMotorMode
---@field RangeAxis DispLibDBCAxisMode
---@field RangeAxisLocalRotation FVector
---@field RangeMask float
---@field VelocityDir DispLibDBCAxisMode
---@field VelocityDirLocalRotation FVector
---@field ScaleSecondVelocity FBUC_DispLibUtil_DBCAdvProcessScalar
---@field PausePriority int32
FBUC_DispLibDBC_WEFMWind = {}



---@class FBUC_DispLibUtil_DBCAdvProcessFLinearColor
---@field Mode DispLibDBCAdvProcessFLinearColorMode
---@field Value FLinearColor
---@field Range FVector2D
---@field Loop boolean
---@field Period float
---@field Duration float
---@field EndStageDuration float
---@field EndValue FLinearColor
---@field ReleaseParameterControlMode DispLibDBCAdvProcessReleaseParameterControlMode
---@field Scale float
---@field Curve UCurveLinearColor
FBUC_DispLibUtil_DBCAdvProcessFLinearColor = {}



---@class FBUC_DispLibUtil_DBCAdvProcessFLinearColorMatLayerParam
---@field Association EMaterialParameterAssociation
---@field LayerFunction UMaterialFunctionInterface
---@field ParamName FName
---@field ProcessValue FBUC_DispLibUtil_DBCAdvProcessFLinearColor
FBUC_DispLibUtil_DBCAdvProcessFLinearColorMatLayerParam = {}



---@class FBUC_DispLibUtil_DBCAdvProcessFLinearColorParam
---@field ParamName FName
---@field ProcessValue FBUC_DispLibUtil_DBCAdvProcessFLinearColor
FBUC_DispLibUtil_DBCAdvProcessFLinearColorParam = {}



---@class FBUC_DispLibUtil_DBCAdvProcessScalar
---@field Mode DispLibDBCAdvProcessScalarMode
---@field Value float
---@field Range FVector2D
---@field Loop boolean
---@field Period float
---@field Duration float
---@field EndStageDuration float
---@field EndValue float
---@field ReleaseParameterControlMode DispLibDBCAdvProcessReleaseParameterControlMode
---@field Scale float
---@field Curve UCurveFloat
FBUC_DispLibUtil_DBCAdvProcessScalar = {}



---@class FBUC_DispLibUtil_DBCAdvProcessScalarMatLayerParam
---@field Association EMaterialParameterAssociation
---@field LayerFunction UMaterialFunctionInterface
---@field ParamName FName
---@field ProcessValue FBUC_DispLibUtil_DBCAdvProcessScalar
FBUC_DispLibUtil_DBCAdvProcessScalarMatLayerParam = {}



---@class FBUC_DispLibUtil_DBCAdvProcessScalarParam
---@field ParamName FName
---@field ProcessValue FBUC_DispLibUtil_DBCAdvProcessScalar
FBUC_DispLibUtil_DBCAdvProcessScalarParam = {}



---@class FBUC_DispLibUtil_DBCPCurveColor
---@field PointsList TArray<FOnePCurveColorPoint>
---@field Loop boolean
---@field Duration float
---@field EndToPoint FOnePCurveColorPoint
---@field ReleaseParameterControlMode DispLibDBCAdvProcessReleaseParameterControlMode
FBUC_DispLibUtil_DBCPCurveColor = {}



---@class FBUC_DispLibUtil_DBCPCurveColorMatLayerParam
---@field Association EMaterialParameterAssociation
---@field LayerFunction UMaterialFunctionInterface
---@field ParamName FName
---@field PCurve FBUC_DispLibUtil_DBCPCurveColor
FBUC_DispLibUtil_DBCPCurveColorMatLayerParam = {}



---@class FBUC_DispLibUtil_DBCPCurveColorParam
---@field ParamName FName
---@field PCurve FBUC_DispLibUtil_DBCPCurveColor
FBUC_DispLibUtil_DBCPCurveColorParam = {}



---@class FBUC_DispLibUtil_DBCPCurveScalar
---@field PointsList TArray<FOnePCurveScalarPoint>
---@field Loop boolean
---@field Duration float
---@field EndToPoint FOnePCurveScalarPoint
---@field ReleaseParameterControlMode DispLibDBCAdvProcessReleaseParameterControlMode
FBUC_DispLibUtil_DBCPCurveScalar = {}



---@class FBUC_DispLibUtil_DBCPCurveScalarMatLayerParam
---@field Association EMaterialParameterAssociation
---@field LayerFunction UMaterialFunctionInterface
---@field ParamName FName
---@field PCurve FBUC_DispLibUtil_DBCPCurveScalar
FBUC_DispLibUtil_DBCPCurveScalarMatLayerParam = {}



---@class FBUC_DispLibUtil_DBCPCurveScalarParam
---@field ParamName FName
---@field PCurve FBUC_DispLibUtil_DBCPCurveScalar
FBUC_DispLibUtil_DBCPCurveScalarParam = {}



---@class FBUC_DispLibUtil_DBCTexture
---@field TextureValue UTexture
---@field Duration float
FBUC_DispLibUtil_DBCTexture = {}



---@class FBUC_DispLibUtil_DBCTextureMatLayerParam
---@field Association EMaterialParameterAssociation
---@field LayerFunction UMaterialFunctionInterface
---@field ParamName FName
---@field TextureValue FBUC_DispLibUtil_DBCTexture
FBUC_DispLibUtil_DBCTextureMatLayerParam = {}



---@class FBUC_DispLibUtil_ForceVisibleStateCustomMode
---@field RequestATKPriority int32
---@field Mode DispLibDBCNiagaraForceVisibleStateMode
FBUC_DispLibUtil_ForceVisibleStateCustomMode = {}



---@class FBUC_DispLibUtil_ModNiagara_NameAndBoolValue
---@field ParamName FName
---@field Value boolean
---@field EndDispStageValue boolean
---@field AfterParamEventRealEndValue boolean
---@field Duration float
---@field EndStageDuration float
---@field SetEveryFrame boolean
FBUC_DispLibUtil_ModNiagara_NameAndBoolValue = {}



---@class FBUC_DispLibUtil_ModifyNiagaraParams_FLinearColor
---@field Mode DispLibDBCAdvProcessModifyNiagaraParamUtilMode
---@field SetEveryFrame boolean
---@field SpecAttType DispLibDBCSpecialAttritubeTpye
---@field Value FLinearColor
---@field RangeMin FLinearColor
---@field RangeMax FLinearColor
---@field Loop boolean
---@field Period float
---@field Duration float
---@field EndStageDuration float
---@field EndValue FLinearColor
---@field Scale float
---@field Curve UCurveLinearColor
FBUC_DispLibUtil_ModifyNiagaraParams_FLinearColor = {}



---@class FBUC_DispLibUtil_ModifyNiagaraParams_FLinearColorParam
---@field ParamName FName
---@field ProcessValue FBUC_DispLibUtil_ModifyNiagaraParams_FLinearColor
FBUC_DispLibUtil_ModifyNiagaraParams_FLinearColorParam = {}



---@class FBUC_DispLibUtil_ModifyNiagaraParams_FVector
---@field Mode DispLibDBCAdvProcessModifyNiagaraParamUtilMode
---@field SetEveryFrame boolean
---@field SpecAttType DispLibDBCSpecialAttritubeTpye
---@field Value FVector
---@field RangeMin FVector
---@field RangeMax FVector
---@field Loop boolean
---@field Period float
---@field Duration float
---@field EndStageDuration float
---@field EndValue FVector
---@field Scale float
---@field Curve UCurveVector
FBUC_DispLibUtil_ModifyNiagaraParams_FVector = {}



---@class FBUC_DispLibUtil_ModifyNiagaraParams_FVectorParam
---@field ParamName FName
---@field ProcessValue FBUC_DispLibUtil_ModifyNiagaraParams_FVector
FBUC_DispLibUtil_ModifyNiagaraParams_FVectorParam = {}



---@class FBUC_DispLibUtil_ModifyNiagaraParams_Float
---@field Mode DispLibDBCAdvProcessModifyNiagaraParamUtilMode
---@field SetEveryFrame boolean
---@field SpecAttType DispLibDBCSpecialAttritubeTpye
---@field Value float
---@field RangeMin float
---@field RangeMax float
---@field Loop boolean
---@field Period float
---@field Duration float
---@field EndStageDuration float
---@field EndValue float
---@field Scale float
---@field Curve UCurveFloat
FBUC_DispLibUtil_ModifyNiagaraParams_Float = {}



---@class FBUC_DispLibUtil_ModifyNiagaraParams_FloatParam
---@field ParamName FName
---@field ProcessValue FBUC_DispLibUtil_ModifyNiagaraParams_Float
FBUC_DispLibUtil_ModifyNiagaraParams_FloatParam = {}



---@class FBUC_DispLibUtil_NameAndFVectorArray
---@field ParamName FName
---@field FVectorArray TArray<FVector>
---@field SetEveryFrame boolean
FBUC_DispLibUtil_NameAndFVectorArray = {}



---@class FBUC_DispLibUtil_NameAndFloatArray
---@field ParamName FName
---@field FloatArray TArray<float>
---@field SetEveryFrame boolean
FBUC_DispLibUtil_NameAndFloatArray = {}



---@class FBUC_DispLibUtil_NameAndInt
---@field ParamName FName
---@field Value int32
FBUC_DispLibUtil_NameAndInt = {}



---@class FBUC_DispLibUtil_NameAndInt32Array
---@field ParamName FName
---@field Int32Array TArray<int32>
---@field SetEveryFrame boolean
FBUC_DispLibUtil_NameAndInt32Array = {}



---@class FBUC_DispLibUtil_NameAndLColor
---@field ParamName FName
---@field Value FLinearColor
FBUC_DispLibUtil_NameAndLColor = {}



---@class FBUC_DispLibUtil_NameAndLColorCurve
---@field ParamName FName
---@field Value UCurveLinearColor
---@field Time float
FBUC_DispLibUtil_NameAndLColorCurve = {}



---@class FBUC_DispLibUtil_NameAndScalar
---@field ParamName FName
---@field Value float
---@field TimeStage FVector
FBUC_DispLibUtil_NameAndScalar = {}



---@class FBUC_DispLibUtil_NameAndScalarCurve
---@field ParamName FName
---@field Value UCurveFloat
---@field Time float
FBUC_DispLibUtil_NameAndScalarCurve = {}



---@class FBUC_DispLibUtil_NameAndString
---@field ParamName FName
---@field Value FString
FBUC_DispLibUtil_NameAndString = {}



---@class FBUC_DispLibUtil_NameAndV4
---@field ParamName FName
---@field Value FVector4
FBUC_DispLibUtil_NameAndV4 = {}



---@class FBUC_DispLibUtil_NameAndVectorCurve
---@field ParamName FName
---@field Value UCurveVector
---@field Time float
FBUC_DispLibUtil_NameAndVectorCurve = {}



---@class FBUC_DispLibUtil_PCurve_NameAndLColor
---@field ParamName FName
---@field Value FLinearColor
---@field TimeStage FVector
FBUC_DispLibUtil_PCurve_NameAndLColor = {}



---@class FBUC_DispLibUtil_PCurve_NameAndScalar
---@field ParamName FName
---@field Value float
---@field TimeStage FVector
FBUC_DispLibUtil_PCurve_NameAndScalar = {}



---@class FBaskstabUIInfo
---@field BackstabMatArrayA UMaterialInstance
---@field BackstabMatArrayB UMaterialInstance
FBaskstabUIInfo = {}



---@class FBattleAttrSnapShot
---@field Attr_CritRate float
---@field Attr_Atk float
---@field Attr_CritMultiplier float
---@field Attr_DmgAddition float
---@field Attr_FreezeAtk float
---@field Attr_BurnAtk float
---@field Attr_PoisonAtk float
---@field Attr_ThunderAtk float
---@field Attr_IgnoreTargetElemDef boolean
---@field bSettedFlag boolean
---@field bDmgFromAbnormal boolean
---@field bAttackerIsPlayer_ForDmgNumer boolean
FBattleAttrSnapShot = {}



---@class FBattleSCInfo
---@field BattleEventMap TMap<FGameplayTag, FGameplayTag>
FBattleSCInfo = {}



---@class FBattleStartCondition
---@field StartConditionType BattleStartConditionType
---@field Unit FGsSmartParam
---@field Spawner FGsSmartParam
---@field Overlap FGsSmartParam
FBattleStartCondition = {}



---@class FBattleTriggerConfig
---@field BattleUnitConfigs TArray<FBattleTriggerUnitConfig>
FBattleTriggerConfig = {}



---@class FBattleTriggerUnitConfig
---@field Unit FGsActorGuidReference
---@field SwitchTeamID int32
---@field TargetUnit TArray<FGsActorGuidReference>
FBattleTriggerUnitConfig = {}



---@class FBeAttackedBlockDamageInfo
---@field TriggerDeductBlockArmorLevel int32
---@field DeductBlockArmorValue float
FBeAttackedBlockDamageInfo = {}



---@class FBehaviorNodeGroupBuffList
---@field BuffID int32
---@field BuffLayer int32
---@field BuffDuration int32
---@field AddNum int32
---@field CheckBuffId int32
---@field CheckReverse boolean
FBehaviorNodeGroupBuffList = {}



---@class FBehaviorNodeGroupSkillList
---@field SkillID int32
---@field CheckBuffId int32
---@field CheckReverse boolean
---@field ForceCast boolean
---@field MontagePath FString
FBehaviorNodeGroupSkillList = {}



---@class FBirth_AbnomalState
---@field AbnormalStateType AbnormalStateType
---@field AbnormalStateLevel int32
FBirth_AbnomalState = {}



---@class FBlockAMInfo
---@field BlockBuffList TArray<int32>
---@field BlockBouncedBuffList TArray<int32>
---@field DirectBlockAMInfo FDirectBlockAMInfo
FBlockAMInfo = {}



---@class FBlockInfoByHitLevel
---@field HitLevel int32
---@field BlockAMInfoList TArray<FBlockAMInfo>
FBlockInfoByHitLevel = {}



---@class FBlockInfoWarp_BeAttacked
---@field BeAttackedBlockDamageInfo TArray<FBeAttackedBlockDamageInfo>
---@field BeAttackedBlockDamageInfoByStiffLevel TArray<FBeAttackedBlockDamageInfo>
FBlockInfoWarp_BeAttacked = {}



---@class FBlockInfoWarp_Normal
---@field BlockInfoByHitLevelList TArray<FBlockInfoByHitLevel>
---@field BreakBlockAM UAnimMontage
---@field TriggerBlock2WeakMinHitWeight int32
---@field BreakBlock2WeakAM UAnimMontage
FBlockInfoWarp_Normal = {}



---@class FBlockInfoWarp_Perfect
---@field PerfectBlockDamageInfoList TArray<FPerfectBlockDamageInfo>
---@field BlockAMInfoList TArray<FBlockAMInfo>
---@field BreakBlockAM UAnimMontage
---@field TriggerBlock2WeakMinHitWeight int32
---@field BreakBlock2WeakAM UAnimMontage
FBlockInfoWarp_Perfect = {}



---@class FBoneUseForDispList
---@field InfoList TArray<FBoneUseForDispMap>
FBoneUseForDispList = {}



---@class FBoneUseForDispMap
---@field WeaponIndex int32
---@field FirstBoneName FName
---@field FirstRadius float
---@field NextBoneName FName
---@field NextRadius float
FBoneUseForDispMap = {}



---@class FBossPhaseInfo
---@field HasPhasePerformance boolean
FBossPhaseInfo = {}



---@class FBtlBGMBPConfig
---@field bDisableBattleBGM boolean
---@field TransMusicConfig TransMusicConfig
---@field BGMStopDistance int32
---@field AkEventBegin UAkAudioEvent
---@field AkEventStop UAkAudioEvent
---@field StopEventConditionConfig FStopEventConditionConfig
FBtlBGMBPConfig = {}



---@class FBuffDispTickData
FBuffDispTickData = {}


---@class FBulletBeAttackedReactionInfo
---@field CheckID int32
---@field TriggerEffectID TArray<int32>
---@field AttackerTriggerEffectID TArray<int32>
FBulletBeAttackedReactionInfo = {}



---@class FBulletSkillTestInfo
---@field TamerActor ABUTamerActor
---@field SkillIdList TArray<int32>
FBulletSkillTestInfo = {}



---@class FBulletSweepReactionInfo
---@field CheckID int32
---@field TriggerEffectID TArray<int32>
FBulletSweepReactionInfo = {}



---@class FBulletSweepSimpleStateReactionInfo
---@field ConditionSimpleState EBGUSimpleState
---@field TriggerEffectID TArray<int32>
FBulletSweepSimpleStateReactionInfo = {}



---@class FCameraBlendData
---@field ControllerRotation FRotator
---@field SpringArmTargetLength float
---@field SpringArmTargetLengthOffset float
---@field SprintArmSocketOffset FVector
---@field SprintArmTargetOffset FVector
---@field CameraOffset FVector
---@field CameraRotation FRotator
---@field FieldOfView float
---@field FieldOfViewOffset float
---@field ControllerYawInput float
---@field IsXAxisSmoothed boolean
---@field IsYAxisSmoothed boolean
---@field IsZAxisSmoothed boolean
---@field SpringArmRelativeLocation FVector
---@field CurrentCameraLagSpeed float
---@field FocalDistance float
---@field DepthBlurKM float
---@field DepthBlurRadius float
FCameraBlendData = {}



---@class FCanvasPainterData
---@field RTTextureParamName FName
---@field RTPing TSoftObjectPtr<UTextureRenderTarget2D>
---@field RTPong TSoftObjectPtr<UTextureRenderTarget2D>
---@field RTResult TSoftObjectPtr<UTextureRenderTarget2D>
---@field PainterMaterial UMaterial
---@field CanvasMaterial UMaterial
---@field FadeOutTime float
---@field EndTime float
---@field RTSize int32
FCanvasPainterData = {}



---@class FCastSkillInfo
---@field SkillID int32
---@field NeedCheckSkillCanCast boolean
---@field MontageStartSectionName FName
---@field SkillMontageBeginPos float
---@field SkillDirection SkillDirection
---@field HasSetSkillBaseTarget boolean
---@field Reason MontageBindReason
---@field SourceType CastSkillSourceType
FCastSkillInfo = {}



---@class FChangeMaterialByUnitAttrConfig
---@field UnitAttrType ChangeMatUnitAttrType
---@field MaterialParameterConfig TArray<FMaterialParameterConfig>
FChangeMaterialByUnitAttrConfig = {}



---@class FCharacterAssetConfig
---@field MobAttackTypeList TArray<MobAttackType>
---@field MinSpawnNum int32
---@field MaxSpawnNum int32
FCharacterAssetConfig = {}



---@class FCharacterSpawnerLibInfo
---@field SpawnClass TSubclassOf<ABGUCharacterCS>
---@field CanBeElite boolean
FCharacterSpawnerLibInfo = {}



---@class FChargeLevelConfig
---@field InfoList TArray<FChargeLevelUnitInfo>
FChargeLevelConfig = {}



---@class FChargeLevelUnitInfo
---@field Duration float
---@field BuffList TArray<int32>
---@field LoopBuffList TArray<int32>
FChargeLevelUnitInfo = {}



---@class FCheckAngleTest
---@field LeftAngle float
---@field RightAngle float
---@field AngleBaseType AngleBaseType
FCheckAngleTest = {}



---@class FCheckAssignTargetInfo
---@field CheckPlayer boolean
---@field CheckUnitGUID FString
---@field CheckConditionType CheckConditionType
---@field CheckSelfIsAITarget boolean
---@field HpLowPercent int32
---@field RangeDistance float
---@field PartId int32
---@field IsPartBreak boolean
---@field BuffID int32
---@field BuffLayer int32
---@field BeatbackStiffLevel int32
---@field IsPlayerAttack boolean
---@field SkillID int32
---@field CheckAbnormalStateType AbnormalStateType
FCheckAssignTargetInfo = {}



---@class FChildActorActionInfo
---@field ActionType ChildActorActionType
---@field SkillID int32
---@field NeedCheckSkillCanCast boolean
---@field MontageStartSectionName FName
---@field BuffID int32
---@field BuffLayer int32
---@field BuffDuration int32
---@field TriggerRemoveEffect boolean
FChildActorActionInfo = {}



---@class FCircusCollector
---@field IsRootMember boolean
---@field SpawnByDefault boolean
---@field Socket FName
---@field ResID int32
---@field Member AActor
---@field MemberType CircusMemberType
---@field NickName TArray<FGameplayTag>
---@field ChildMembers TArray<AActor>
FCircusCollector = {}



---@class FCircusConfig
---@field SpawnByDefault boolean
---@field NickName TArray<FGameplayTag>
FCircusConfig = {}



---@class FCircusConfigNonCharacter
---@field NickName TArray<FGameplayTag>
FCircusConfigNonCharacter = {}



---@class FCliffUnbalanceAMConfig
---@field CliffUnbalance_F UAnimMontage
---@field CliffUnbalance_B UAnimMontage
---@field CliffUnbalance_L UAnimMontage
---@field CliffUnbalance_R UAnimMontage
FCliffUnbalanceAMConfig = {}



---@class FCloudBreakAnimSetting
---@field CloudBreakAnimSetting_Low FAnimHumanoidSetting_Fall
---@field CloudBreakAnimSetting_High FAnimHumanoidSetting_Fall
FCloudBreakAnimSetting = {}



---@class FCloudMoveBreakSkillConfig
---@field BreakSkill_Low int32
---@field BreakSkill_High int32
FCloudMoveBreakSkillConfig = {}



---@class FCloudMoveGroundEffectConfig
---@field RunEffectDBC UBGWDataAsset_B1DBC
---@field RushEffectDBC UBGWDataAsset_B1DBC
FCloudMoveGroundEffectConfig = {}



---@class FCoinFXNum
---@field LowerLimit int32
---@field FXNum int32
FCoinFXNum = {}



---@class FCollisionProfileInfo
---@field Type CollisionBodyType
---@field ProfileName FName
FCollisionProfileInfo = {}



---@class FComboCondition
---@field ConditionType ComboConditionType
---@field UnitState EBGUUnitState
---@field SimpleState EBGUSimpleState
---@field AttrFloatType EBGUAttrFloat
---@field CompareOperation ValueCompareOperations
---@field CompareValue float
---@field BuffID int32
---@field TalentID int32
---@field ComparePotentialEnergyOperation ValueCompareOperations
---@field PotentialEnergyLevel int32
---@field CompareChargeOperation ValueCompareOperations
---@field ChargeLevel int32
---@field CompareCeilingHeightOperation ValueCompareOperations
---@field CeilingHeight int32
---@field StanceType StanceType_Combo
---@field SkillIdList TArray<int32>
---@field MoveMode EBGUMoveMode
---@field ConditionIdentity FString
FComboCondition = {}



---@class FComboConditionSkill_UnitResIDInfo
---@field ResID int32
---@field SkillID int32
FComboConditionSkill_UnitResIDInfo = {}



---@class FComboSkill
---@field SkillID TArray<int32>
FComboSkill = {}



---@class FComboSkillNumInfo
---@field ComboNum int32
---@field ComboPercenRatio int32
FComboSkillNumInfo = {}



---@class FCompositeCondition_SpawnWaveStart
---@field Single FSpawnWaveStartCondition
---@field bUseCompositeCondition boolean
---@field Conditions TArray<FSpawnWaveStartCondition>
---@field ConditionalRelation ConditionalRelation
---@field bReverseCondition boolean
---@field Comment FString
FCompositeCondition_SpawnWaveStart = {}



---@class FCompositeTransitionCondition_Battle
---@field Single FTransitionCondition_Battle
---@field bUseCompositeCondition boolean
---@field Conditions TArray<FTransitionCondition_Battle>
---@field ConditionalRelation ConditionalRelation
---@field bReverseCondition boolean
---@field Comment FString
FCompositeTransitionCondition_Battle = {}



---@class FCompositeTransitionCondition_Group
---@field Single FTransitionCondition_Group
---@field bUseCompositeCondition boolean
---@field Conditions TArray<FTransitionCondition_Group>
---@field ConditionalRelation ConditionalRelation
---@field bReverseCondition boolean
---@field Comment FString
FCompositeTransitionCondition_Group = {}



---@class FCompositeTransitionCondition_Guide
---@field Single FTransitionCondition_Guide
---@field bUseCompositeCondition boolean
---@field Conditions TArray<FTransitionCondition_Guide>
---@field ConditionalRelation ConditionalRelation
---@field bReverseCondition boolean
---@field Comment FString
FCompositeTransitionCondition_Guide = {}



---@class FCompositeTransitionCondition_Idle
---@field Single FTransitionCondition_Idle
---@field bUseCompositeCondition boolean
---@field Conditions TArray<FTransitionCondition_Idle>
---@field ConditionalRelation ConditionalRelation
---@field bReverseCondition boolean
---@field Comment FString
FCompositeTransitionCondition_Idle = {}



---@class FCompositeTransitionCondition_State
---@field Single FTransitionCondition_State
---@field bUseCompositeCondition boolean
---@field Conditions TArray<FTransitionCondition_State>
---@field ConditionalRelation ConditionalRelation
---@field Comment FString
---@field BossPhaseInfo FBossPhaseInfo
FCompositeTransitionCondition_State = {}



---@class FContinueBehaviorInfo
---@field CBT ContinueBehaviorType
---@field MontagePos float
---@field SkillID int32
---@field BeatbackMontage UAnimMontage
FContinueBehaviorInfo = {}



---@class FCricketJumpPlayerAnimConfig
---@field AMPlayerJump UAnimMontage
---@field AnimDummyMeshJump UAnimationAsset
FCricketJumpPlayerAnimConfig = {}



---@class FCricketMovePointConfig
---@field PointTrans FTransform
---@field IdleTime float
---@field AnimIdleList TArray<UAnimSequence>
---@field JumpAnim UAnimMontage
FCricketMovePointConfig = {}



---@class FCustomDepthStencilInfo
---@field ComponentTag FName
---@field bRenderCustomDepth boolean
---@field CustomDepthStencilValue int32
FCustomDepthStencilInfo = {}



---@class FCustomizedInputOverrideConfig
---@field InputMappingContext UInputMappingContext
---@field OverrideInputActionTriggerEvents TMap<UInputAction, FInputActionOverrideConfig>
---@field IsOverridePriority boolean
---@field Priority int32
---@field TriggerPriority int32
FCustomizedInputOverrideConfig = {}



---@class FCustomizedKeyConfig
---@field ActionName FString
---@field UIWordID int32
---@field ChangeType EGSInputChangeType
---@field InputTab EGSInputTab
---@field KeyMappingType EGSKeyMappingType
---@field GroupName FString
---@field GroupNameUIWordID int32
---@field UnlockCondition CustomizedKeyUnlockCondition
FCustomizedKeyConfig = {}



---@class FDBCTestStruct
---@field Delay float
---@field EndMode DispLibDBCEndMode
---@field Duration float
---@field DelayTimeAfterStop float
FDBCTestStruct = {}



---@class FDebugDrawPoint
---@field Name FString
---@field Point FVector2D
---@field Color FLinearColor
---@field Size float
FDebugDrawPoint = {}



---@class FDelaySpawnInfo
FDelaySpawnInfo = {}


---@class FDemo820LevelInfo
---@field LevelIndex int32
---@field LevelID int32
---@field BossID int32
---@field Name FText
---@field Desc FText
---@field VictoryDesc FText
---@field LevelImageIndex int32
---@field RoleDataConfId int32
---@field PlayerDesiredHp int32
---@field DefaultPos FVector
---@field DefaultRot FRotator
---@field RebrithPoint int32
FDemo820LevelInfo = {}



---@class FDemo820TimeInfo
---@field SmallTipsTimeDur float
---@field TipsTimeDur float
---@field TipsTime TArray<int32>
---@field GameplayTimeMax float
FDemo820TimeInfo = {}



---@class FDetailLevelInfo
---@field MainMenuLevelId int32
---@field SetConfigLevelId int32
---@field PrologueLevelId int32
---@field AfterPrologueLevelId int32
---@field StandAlonePartyId int32
---@field OnlinePartyId int32
FDetailLevelInfo = {}



---@class FDetectCondition
---@field DetectedElementType DetectedElementType
---@field SimpleState EBGUSimpleState
---@field UnitState EBGUUnitState
---@field BuffID int32
---@field AttrFloatType EBGUAttrFloat
---@field CompareOperation ValueCompareOperations
---@field CompareValue float
---@field AbnormalStateType AbnormalStateType
---@field FsmState EBGUFSMStateName
---@field SkillID int32
---@field DistanceCompareOperations ValueCompareOperations
---@field DistanceCompareValue float
---@field CustomFsmState FGameplayTag
---@field CompareValueInt int32
---@field BaseDirection RotationBaseDirection
---@field MinYawAngle float
---@field MaxYawAngle float
---@field SkillIdList TArray<int32>
---@field MatchInfo FTamerFamilyMatchChildInfo
---@field ResID int32
---@field SuccessRate float
---@field AliveUnitNum int32
---@field BuffLayer int32
---@field OperationType ValueCompareOperationType
---@field GamePlusCount int32
---@field SurfaceType SceneItemSurfaceType
---@field PlayerLeisureOverTime float
---@field bReverseCondition boolean
---@field Comment FString
FDetectCondition = {}



---@class FDetectCondition_AbnormalState
---@field AbnormalStateType AbnormalStateType
FDetectCondition_AbnormalState = {}



---@class FDetectCondition_ActorYawRotation
---@field BaseDirection RotationBaseDirection
---@field MinYawAngle float
---@field MaxYawAngle float
FDetectCondition_ActorYawRotation = {}



---@class FDetectCondition_CheckSurfaceType
---@field SurfaceType SceneItemSurfaceType
FDetectCondition_CheckSurfaceType = {}



---@class FDetectCondition_CompareBuffLayer
---@field BuffID int32
---@field BuffLayer int32
---@field OperationType ValueCompareOperationType
FDetectCondition_CompareBuffLayer = {}



---@class FDetectCondition_CompareGamePlusCount
---@field OperationType ValueCompareOperationType
---@field GamePlusCount int32
FDetectCondition_CompareGamePlusCount = {}



---@class FDetectCondition_CurSkillCostDmgNum
---@field CompareOperation ValueCompareOperations
---@field CompareValueInt int32
FDetectCondition_CurSkillCostDmgNum = {}



---@class FDetectCondition_CurrentBeAttackedStiffLevel
---@field CompareOperation ValueCompareOperations
---@field CompareValueInt int32
FDetectCondition_CurrentBeAttackedStiffLevel = {}



---@class FDetectCondition_CustomFsmState
---@field CustomFsmState FGameplayTag
FDetectCondition_CustomFsmState = {}



---@class FDetectCondition_DistanceFromMaster
---@field DistanceCompareOperations ValueCompareOperations
---@field DistanceCompareValue float
FDetectCondition_DistanceFromMaster = {}



---@class FDetectCondition_DistanceFromNearestPlayer
---@field CompareOperation ValueCompareOperations
---@field CompareValueInt int32
FDetectCondition_DistanceFromNearestPlayer = {}



---@class FDetectCondition_DistanceFromTarget
---@field DistanceCompareOperations ValueCompareOperations
---@field DistanceCompareValue float
FDetectCondition_DistanceFromTarget = {}



---@class FDetectCondition_DurCastSkill
---@field SkillIdList TArray<int32>
FDetectCondition_DurCastSkill = {}



---@class FDetectCondition_FamilySpecifyUnitAttr
---@field MatchInfo FTamerFamilyMatchChildInfo
---@field AttrFloatType EBGUAttrFloat
---@field CompareOperation ValueCompareOperations
---@field CompareValue float
FDetectCondition_FamilySpecifyUnitAttr = {}



---@class FDetectCondition_FamilyUnitAliveNum
---@field MatchInfo FTamerFamilyMatchChildInfo
---@field CompareOperation ValueCompareOperations
---@field AliveUnitNum int32
FDetectCondition_FamilyUnitAliveNum = {}



---@class FDetectCondition_FsmState
---@field FsmState EBGUFSMStateName
FDetectCondition_FsmState = {}



---@class FDetectCondition_GlobalCastSkillCount
---@field SkillID int32
---@field CompareOperation ValueCompareOperations
---@field CompareValueInt int32
FDetectCondition_GlobalCastSkillCount = {}



---@class FDetectCondition_HasBuff
---@field BuffID int32
FDetectCondition_HasBuff = {}



---@class FDetectCondition_LastBeAttackedStiffLevel
---@field CompareOperation ValueCompareOperations
---@field CompareValueInt int32
FDetectCondition_LastBeAttackedStiffLevel = {}



---@class FDetectCondition_PlayerLeisureOverTime
---@field PlayerLeisureOverTime float
FDetectCondition_PlayerLeisureOverTime = {}



---@class FDetectCondition_Random
---@field SuccessRate float
FDetectCondition_Random = {}



---@class FDetectCondition_SimpleState
---@field SimpleState EBGUSimpleState
FDetectCondition_SimpleState = {}



---@class FDetectCondition_SkillCanCast
---@field SkillID int32
FDetectCondition_SkillCanCast = {}



---@class FDetectCondition_SkillCoolDown
---@field SkillID int32
FDetectCondition_SkillCoolDown = {}



---@class FDetectCondition_SocketUnitsDead
---@field MatchInfo FTamerFamilyMatchChildInfo
FDetectCondition_SocketUnitsDead = {}



---@class FDetectCondition_SpecifyResIdUnitsDead
---@field ResID int32
FDetectCondition_SpecifyResIdUnitsDead = {}



---@class FDetectCondition_TargetInAngleRange
---@field MinYawAngle float
---@field MaxYawAngle float
FDetectCondition_TargetInAngleRange = {}



---@class FDetectCondition_UnitAttr
---@field AttrFloatType EBGUAttrFloat
---@field CompareOperation ValueCompareOperations
---@field CompareValue float
FDetectCondition_UnitAttr = {}



---@class FDetectCondition_UnitState
---@field UnitState EBGUUnitState
FDetectCondition_UnitState = {}



---@class FDetectUnitCondition
---@field UnitType DetectedUnitType
---@field SmartUnit FGsSmartParam
---@field Conditions TArray<FDetectCondition>
---@field ConditionalRelation ConditionalRelation
---@field Comment FString
---@field BossPhaseInfo FBossPhaseInfo
FDetectUnitCondition = {}



---@class FDirectBlockAMInfo
---@field ForwardBlockAMInfo FOneDirectBlockAMInfo
---@field BackwardBlockAMInfo FOneDirectBlockAMInfo
---@field LeftSideBlockAMInfo FOneDirectBlockAMInfo
---@field RightSideBlockAMInfo FOneDirectBlockAMInfo
FDirectBlockAMInfo = {}



---@class FDispInteractInfo
---@field FirstPos FVector
---@field NextPos FVector
---@field FirstRadius float
---@field NextRadius float
FDispInteractInfo = {}



---@class FDispInteractLandscapeInfo
---@field Landscape ALandscape
---@field LS_HeightMap UTexture2D
---@field LS_WeightMap UTexture2D
---@field _LandscapeOriginOffset FVector
---@field VertexCount_Width int32
---@field VertexCount_Height int32
---@field MaxHeight float
---@field SimulationSize_cm float
---@field InteractiveData_StorageSize_cm float
---@field InteractDistLimitToDispActor float
FDispInteractLandscapeInfo = {}



---@class FDispInteractOverride
---@field FirstBoneName FName
---@field NextBoneName FName
---@field FirstScaleValue float
---@field NextScaleValue float
---@field FirstScaleCurve UCurveFloat
---@field NextScaleCurve UCurveFloat
---@field FirstOffsetValue float
---@field NextOffsetValue float
---@field FirstOffsetCurve UCurveFloat
---@field NextOffsetCurve UCurveFloat
FDispInteractOverride = {}



---@class FDispInteractSolverConfig
---@field SpawnDSDFSolver boolean
---@field Pority int32
FDispInteractSolverConfig = {}



---@class FDistanceTest
---@field DisTestType DisTestFilterType
---@field DisBaseType DisTestBaseType
FDistanceTest = {}



---@class FDynamicTamerSpawnReq
---@field TamerGuidOverride FString
---@field TamerClass TSubclassOf<ABUTamerActor>
---@field SpawnWorldTransform FTransform
---@field TriggerSpawnActor AActor
FDynamicTamerSpawnReq = {}



---@class FEffectInstReq
---@field ObjectId int32
---@field HitLocation FVector
---@field HitPointNormalDir FRotator
---@field HitActionDir HitActionDir
---@field SweepCheckBegin FVector
---@field SweepCheckEnd FVector
---@field HitDiretionRealDir FVector
---@field HitBoneName FName
---@field HitComp UPrimitiveComponent
---@field Attacker AActor
---@field AudioID_HitChr int32
---@field FXWeight_HitChr int32
---@field TriggerSkillId int32
---@field bFromBullet boolean
---@field LaserStiffDir FRotator
---@field HitPartID int32
FEffectInstReq = {}



---@class FEffectorData
---@field EffectorRootName FName
---@field BoneName FName
---@field position FVector
---@field alpha float
---@field AlphaCurveValue float
FEffectorData = {}



---@class FEnvChangeConfig
FEnvChangeConfig = {}


---@class FEnvOverlapByObjectTypeData
---@field ExtentX float
---@field ExtentY float
---@field ExtentZ float
---@field ShapeOffset FVector
---@field OverlapObjectTypes TArray<EObjectTypeQuery>
---@field OverlapShape EGSSweepCheckShapeType
---@field bSkipOverlapQuerier boolean
FEnvOverlapByObjectTypeData = {}



---@class FEnvironmentAbnormalEffectConfig
---@field AbnormalStateConfig FAbnormalStateAccConfig
---@field bDisableAutoRecover boolean
FEnvironmentAbnormalEffectConfig = {}



---@class FEnvironmentAbnormalRecoverRate
---@field AbnormalStateType AbnormalStateType
---@field AutoRecoverRate float
FEnvironmentAbnormalRecoverRate = {}



---@class FEnvironmentInteractionConfig
---@field EnvironmentSurfaceType SceneItemSurfaceType
---@field SurfaceTypeOverrideMethod SurfaceTypeOverrideMethod
---@field SurfaceTypeGenerationMapping TMap<SceneItemSurfaceType, SceneItemSurfaceType>
---@field Priority int32
FEnvironmentInteractionConfig = {}



---@class FEnvironmentItemStateMachineExtAbilityMask
---@field mask int32
FEnvironmentItemStateMachineExtAbilityMask = {}



---@class FEnvironmentMaskData
---@field SurfaceType SceneItemSurfaceType
---@field Increment float
FEnvironmentMaskData = {}



---@class FEnvironmentMaskMappingData
---@field ParamName FString
---@field LayerMappingName_Layer FString
---@field AccumulateSpeed float
---@field AccumulateMaxValue float
---@field FadeSpeed float
FEnvironmentMaskMappingData = {}



---@class FEquipAbpConfig
---@field Head TSubclassOf<UAnimInstance>
---@field UpWear TSubclassOf<UAnimInstance>
---@field Arm TSubclassOf<UAnimInstance>
---@field Foot TSubclassOf<UAnimInstance>
---@field Hulu TSubclassOf<UAnimInstance>
---@field Weapon TSubclassOf<UAnimInstance>
FEquipAbpConfig = {}



---@class FEquipMeshConfig
---@field Head USkeletalMesh
---@field UpWear USkeletalMesh
---@field Arm USkeletalMesh
---@field Foot USkeletalMesh
---@field Hulu USkeletalMesh
---@field Weapon USkeletalMesh
FEquipMeshConfig = {}



---@class FEquipPreviewPositionConfig
---@field DBCDAMap TMap<EquipFXType, UBGWDataAsset>
---@field AnimIn UAnimMontage
---@field HeadAnimIn UAnimMontage
---@field AnimOutSuccess UAnimMontage
---@field HeadAnimOutSuccess UAnimMontage
---@field AnimOutBack UAnimMontage
---@field HeadAnimOutBack UAnimMontage
---@field MarkIcon UTexture2D
FEquipPreviewPositionConfig = {}



---@class FExponentialHeightFogConfig
FExponentialHeightFogConfig = {}


---@class FFAKEventParamter
---@field AttachPointName FString
---@field AkEvent TSoftObjectPtr<UAkAudioEvent>
---@field AkStopEvent TSoftObjectPtr<UAkAudioEvent>
---@field Follow boolean
---@field EventName FString
FFAKEventParamter = {}



---@class FFBGMVolumeCondition
---@field Condition EBGMVolumeConditionType
---@field InverseCondition boolean
---@field Actors TArray<FGsActorGuidReference>
---@field ConditionSusCountType EBGMVolumeConditionSusCountType
FFBGMVolumeCondition = {}



---@class FFBGMVolumeConditionConfig
---@field ConditionGroups TArray<FFBGMVolumeConditionGroup>
---@field AkEventBegin UAkAudioEvent
---@field AkEventStop UAkAudioEvent
---@field VolumeBGMConfigDA UBGWBGMConfigDataAsset
---@field VolumeGroupConfig FFBGMVolumeGroupConfig
FFBGMVolumeConditionConfig = {}



---@class FFBGMVolumeConditionGroup
---@field Conditions TArray<FFBGMVolumeCondition>
FFBGMVolumeConditionGroup = {}



---@class FFBGMVolumeGroupConfig
---@field VolumeGroupName FName
---@field VolumePriority int32
---@field PriorityEvent UAkAudioEvent
FFBGMVolumeGroupConfig = {}



---@class FFBPTreeInfo
---@field LeaveBoxOri FVector
---@field LeaveBoxExtent FVector
---@field TreeName FString
FFBPTreeInfo = {}



---@class FFCBGCastSkillInfo
---@field SkillID int32
---@field MontageStartSectionName FName
---@field DontCheckSkillCanCast boolean
---@field CanCastWhenDead boolean
FFCBGCastSkillInfo = {}



---@class FFEQSRunParamInfo
---@field AcceptableRadius float
---@field IncludeSelfRadius boolean
---@field EQSTemplate UEnvQuery
---@field MoveAIType EBGUMoveAIType
---@field SpeedRateType EAIMoveSpeedType
---@field SpeedRateDistanceCurve UCurveFloat
---@field EnableRangeAcceptableRadius boolean
---@field MinAcceptableRadius float
---@field MaxAcceptableRadius float
---@field bEnableContinuousPathFinding boolean
---@field ContinuousPathFindingRadiusThreshold float
---@field AutoUpdatePathTime float
---@field EnableDebug boolean
---@field EnableLeisure boolean
---@field IntervalTime float
---@field LeisureList TArray<FFGSLeisureWithWeight>
---@field EnableDrawLineDebug boolean
FFEQSRunParamInfo = {}



---@class FFFXActorConfig
---@field LifeTime float
---@field DelayDestroyTime float
---@field FXActorType EFXActorType
FFFXActorConfig = {}



---@class FFGSArmorCounterWithBlood
---@field BloodChangeLine int32
---@field BeHitNum_Min int32
---@field BeHitNum_Max int32
FFGSArmorCounterWithBlood = {}



---@class FFGSArmorSettingInBP
---@field Armor_Enable boolean
---@field IsGetTopRandomSkill boolean
---@field TopRandomSkillPercent int32
---@field Armor_SkillID TArray<int32>
---@field Armor_Timer float
---@field BeHitCountType FightBackCountType
---@field OriBeHitNum_Min int32
---@field OriBeHitNum_Max int32
---@field CounterWithBloodConfig TArray<FFGSArmorCounterWithBlood>
---@field MaxBlockTimes int32
---@field PerfectBlockTimes int32
---@field BlockCoolDownTime float
---@field ResetBlockCounterTime float
---@field DefaultBlockInfoConfig UBGWDataAsset_BlockInfoConfig
FFGSArmorSettingInBP = {}



---@class FFGSBeamFXPlaySetting
---@field BeamTemplate TSoftObjectPtr<UNiagaraSystem>
---@field IsAttach boolean
---@field AttachSocketName FName
---@field Scale FVector
---@field GSBeamTargetType EBeamFXTargetActorType
---@field GSBeamTargetParamName FString
---@field TargetSocketName FName
FFGSBeamFXPlaySetting = {}



---@class FFGSBuffInfo
---@field BuffID int32
---@field BuffDuration int32
FFGSBuffInfo = {}



---@class FFGSBuffTriggerConfig
---@field AddBuffIDList TArray<int32>
---@field AddBuffCondition BuffControlCondition
---@field AddBuffTarget BuffTarget
---@field AddSceneTamer TArray<TSoftObjectPtr<ABUTamerActor>>
---@field AddSceneTamerRef TArray<FGsActorGuidReference>
---@field RemoveBuffIDList TArray<int32>
---@field RemoveBuffCondition BuffControlCondition
---@field RemoveBuffTarget BuffTarget
---@field RemoveSceneTamer TArray<TSoftObjectPtr<ABUTamerActor>>
---@field RemoveSceneTamerRef TArray<FGsActorGuidReference>
---@field AddSceneUnit TArray<TSoftObjectPtr<ABGUCharacterCS>>
---@field RemoveSceneUnit TArray<TSoftObjectPtr<ABGUCharacterCS>>
FFGSBuffTriggerConfig = {}



---@class FFGSBuffTriggerUnitCondition
---@field ConditionsTarget ConditionsTarget
---@field Tags TArray<FName>
---@field ObservedTamers TArray<TSoftObjectPtr<ABUTamerActor>>
---@field ObservedTamerRefs TArray<FGsActorGuidReference>
---@field ObserveIsActivedUnit boolean
---@field ObserveActiveTamers TArray<TSoftObjectPtr<ABUTamerActor>>
---@field ObserveActiveTamerRefs TArray<FGsActorGuidReference>
---@field ObserveIsDeadUnit boolean
---@field ObserveDeadTamers TArray<TSoftObjectPtr<ABUTamerActor>>
---@field ObserveDeadTamerRefs TArray<FGsActorGuidReference>
---@field ObserveHasUnitState boolean
---@field ObserveUnitStates TArray<EBGUUnitState>
---@field ObserveHasSimpleState boolean
---@field ObserveSimpleStates TArray<EBGUSimpleState>
---@field ObserveHasBuff boolean
---@field ObserveBuffIDs TArray<int32>
---@field ObserveHasUnitAttr boolean
---@field ObserveUnitAttrs TArray<FUnitAttrCondition>
---@field BuffTriggerConfig FFGSBuffTriggerConfig
---@field ObservedUnits TArray<ABGUCharacterCS>
---@field ObserveActiveUnits TArray<ABGUCharacterCS>
---@field ObserveDeadUnits TArray<ABGUCharacterCS>
FFGSBuffTriggerUnitCondition = {}



---@class FFGSCameraAutoLockSetting
---@field MaxCamLockTargetDistance float
---@field CamLockAngleMax float
---@field CamLockSwitchAngleMax float
---@field DistScoreRate float
---@field G4SpotTurnSpeed float
---@field CamLockTurnSpeed float
---@field RollSkillTurnSpeed float
---@field RotateToCameraTurnSpeed float
---@field SkillResumeMoveBlendTime float
---@field Camera4GRotateSpeed float
FFGSCameraAutoLockSetting = {}



---@class FFGSCameraOffsetSetting
---@field EnableArmLength boolean
---@field ArmLengthOffsetCurve UCurveFloat
---@field EnableFOVOffset boolean
---@field FOVOffsetCurve UCurveFloat
FFGSCameraOffsetSetting = {}



---@class FFGSCastDingShenSetting
---@field DingShenBuffID int32
---@field EnableRangeSelect boolean
---@field SelectCount int32
---@field RangeRadius int32
---@field TargetFilter int32
---@field TargetTypeFilter int32
---@field AffiliationTypeFilter int32
FFGSCastDingShenSetting = {}



---@class FFGSCellPatitionInsatnceConfig
---@field WorldCellPatitionSize FVector2D
---@field WorldCellPatitionBias FVector2D
---@field CellXCount int32
---@field CellYCount int32
FFGSCellPatitionInsatnceConfig = {}



---@class FFGSCellPatitionLayerConfig
---@field CellPartionInstanceName FString
---@field Radius float
---@field UnitFilter int32
---@field TeamFilter int32
---@field Priority int32
---@field FilterAnd boolean
FFGSCellPatitionLayerConfig = {}



---@class FFGSDataTableRowHandle
---@field RowName FName
---@field DataTable UDataTable
FFGSDataTableRowHandle = {}



---@class FFGSDescRowHandle
---@field DescID int32
---@field RowName FName
---@field DescCustomizationHelperClass TSubclassOf<UGSDescPropertyDetailCustomizationHelper>
FFGSDescRowHandle = {}



---@class FFGSForceFightTriggerUnitFilter
---@field FilterType EGSForceFightUnitFilterType
---@field FilterUnits TArray<TSoftObjectPtr<ABGUCharacterCS>>
---@field FilterTamers TArray<TSoftObjectPtr<ABUTamerActor>>
---@field FilterTamerRefs TArray<FGsActorGuidReference>
---@field FilterUnitTypes TArray<EGSForceFightUnitType>
FFGSForceFightTriggerUnitFilter = {}



---@class FFGSForceFightUnitCondition
---@field ObservedUnits TArray<ABGUCharacterCS>
---@field ObservedTamers TArray<ABUTamerActor>
---@field ObservedTamerRefs TArray<FGsActorGuidReference>
---@field ObserveHasUnitState boolean
---@field ObserveUnitStates TArray<EBGUUnitState>
---@field ObserveHasSimpleState boolean
---@field ObserveSimpleStates TArray<EBGUSimpleState>
---@field ObserveHasBuff boolean
---@field ObserveBuffIDs TArray<int32>
FFGSForceFightUnitCondition = {}



---@class FFGSForceFightUnitGroupConfig
---@field TriggerCondition EGSForceFightCondition
---@field TriggerUnitFilter FFGSForceFightTriggerUnitFilter
---@field ObserveUnitsConditions TArray<FFGSForceFightUnitCondition>
---@field ForceFightTargetType EGSForceFightTargetType
---@field TargetUnit TSoftObjectPtr<ABGUCharacterCS>
---@field TargetTamer TSoftObjectPtr<ABUTamerActor>
---@field TargetTamerRef FGsActorGuidReference
---@field TriggerUnitsType TArray<EGSForceFightTriggerUnitType>
---@field TriggerUnits TArray<TSoftObjectPtr<ABGUCharacterCS>>
---@field TriggerTamers TArray<TSoftObjectPtr<ABUTamerActor>>
---@field TriggerTamerRefs TArray<FGsActorGuidReference>
---@field TriggerUnitsWhiteList FFGSForceFightWhiteListConfig
---@field CanRepeat boolean
FFGSForceFightUnitGroupConfig = {}



---@class FFGSForceFightWhiteListConfig
---@field IgnorePlayer boolean
---@field IgnoreUnits TArray<TSoftObjectPtr<ABGUCharacterCS>>
---@field IgnoreTamers TArray<TSoftObjectPtr<ABUTamerActor>>
---@field IgnoreTamerRefs TArray<FGsActorGuidReference>
FFGSForceFightWhiteListConfig = {}



---@class FFGSGroupFollowConfig
---@field bEnableAdjustTimeRate boolean
---@field MinTimeRate float
---@field MaxTimeRate float
---@field MinRateDistance float
---@field DecreaseRateDistance float
---@field IncreaseRateDistance float
---@field MaxRateDistance float
FFGSGroupFollowConfig = {}



---@class FFGSGroupPatrolConfig
---@field SplineWaitPointConfig TMap<int32, FFGSSplinePatrolWaitPoint>
---@field GroupFollowConfig FFGSGroupFollowConfig
FFGSGroupPatrolConfig = {}



---@class FFGSLeisureConfig
---@field LeisureAnim UAnimMontage
---@field bGroupSyncLeisure boolean
---@field bRandomStartTime boolean
---@field RandomConfig TArray<FFGSLeisureRandomConfig>
FFGSLeisureConfig = {}



---@class FFGSLeisureRandomConfig
---@field Weight float
---@field RandomAnim UAnimMontage
---@field CD_Time float
FFGSLeisureRandomConfig = {}



---@class FFGSLeisureWithWeight
---@field LeisureReference UAnimMontage
---@field Weight int32
FFGSLeisureWithWeight = {}



---@class FFGSMeleeAutoLockSetting
---@field Range float
---@field AngleMax float
---@field turnSpeed float
---@field PreferActorDistTolerance float
FFGSMeleeAutoLockSetting = {}



---@class FFGSMontageMoveData
---@field Montage UAnimMontage
---@field Scale float
---@field PlayTimeRate float
---@field MontagePosOffset float
---@field StartSectionName FName
FFGSMontageMoveData = {}



---@class FFGSMotionMatchingSetting
---@field UseMotionMatching boolean
---@field DefaultMMState State_MM
---@field AA_Locking UAnimationAnalyzer
---@field AA_Free UAnimationAnalyzer
---@field AnimationAnalyzerBlendTime float
---@field MotionBlendTime float
---@field ControllerInputReactionSpeed float
---@field ControllerRotationReactionSpeed float
---@field BeginStandRotateAngleOffset float
---@field StandRotateReactionSpeed float
---@field ForceSetRotAnimSpeed float
---@field DisableRotVerifyAnimSpeed float
FFGSMotionMatchingSetting = {}



---@class FFGSMultiSplinePatrolConfig
---@field SplineList TArray<TSoftObjectPtr<AActor>>
---@field TriggerBox ATriggerBase
---@field WaitPointConfig TMap<int32, FFGSSplinePatrolWaitPoint>
---@field JumpPointConfig TMap<int32, FFGSSplinePatrolJumpPoint>
FFGSMultiSplinePatrolConfig = {}



---@class FFGSRepGraphConfig
---@field PatitionLayerConfig FFGSCellPatitionLayerConfig
---@field RepGraphLevel int32
FFGSRepGraphConfig = {}



---@class FFGSSceneActorActivationInfo
---@field SceneActorActivationType EGSSceneActorActivationType
---@field ActivateDistance float
---@field Tag FName
FFGSSceneActorActivationInfo = {}



---@class FFGSSeqAnimKeyStateBlendCfg
---@field FromStateName FString
---@field ToStateName FString
---@field EasingTime float
---@field EasingFunc EEasingFunc::Type
---@field NeedEasingBlendExp boolean
---@field EasingBlendExp float
---@field NeedEasingSteps boolean
---@field EasingSteps int32
---@field DelayEasingTime float
---@field EnumValEasingType EGSAnimKBEnumBoolEasing::Type
---@field BoolValEasingType EGSAnimKBEnumBoolEasing::Type
FFGSSeqAnimKeyStateBlendCfg = {}



---@class FFGSSpawnMagicFieldInfo
FFGSSpawnMagicFieldInfo = {}


---@class FFGSSpawnProbabilityConfig
---@field describe FString
---@field MaxNum int32
---@field MinNum int32
---@field PlusRate int32
---@field ChiefRate int32
---@field FreshDelta int32
---@field ActorDict TMap<int32, FString>
FFGSSpawnProbabilityConfig = {}



---@class FFGSSpawnProbabilityGroup
---@field SpawnProbabilityGroup TMap<int32, FFGSSpawnProbabilityConfig>
FFGSSpawnProbabilityGroup = {}



---@class FFGSSplineFlyMoveInfo
---@field WaitPointDict TMap<int32, FFGSSplineFlyMoveWaitPoint>
FFGSSplineFlyMoveInfo = {}



---@class FFGSSplineFlyMoveWaitPoint
---@field IsUnlimitedNeedWaitTime boolean
---@field WaitTime float
---@field WaitAM UAnimMontage
---@field ForwardSplineRangeAfterWaiting float
---@field TransitionInterpSpeed float
---@field RotationInterpSpeed float
FFGSSplineFlyMoveWaitPoint = {}



---@class FFGSSplinePatrolConfig
---@field SplineActor AActor
---@field SingleDirection boolean
---@field TriggerBox ATriggerBase
---@field WaitPointConfig TMap<int32, FFGSSplinePatrolWaitPoint>
---@field JumpPointConfig TMap<int32, FFGSSplinePatrolJumpPoint>
FFGSSplinePatrolConfig = {}



---@class FFGSSplinePatrolJumpPoint
---@field JumpAM UAnimMontage
---@field JumpForce float
FFGSSplinePatrolJumpPoint = {}



---@class FFGSSplinePatrolWaitPoint
---@field WaitAM UAnimMontage
FFGSSplinePatrolWaitPoint = {}



---@class FFGSTROConfig
---@field PatitionLayerConfig FFGSCellPatitionLayerConfig
---@field TROLevel int32
FFGSTROConfig = {}



---@class FFGSTimeScaleSetting
---@field TimeScale float
---@field BlendInRealTime float
---@field BlendInType EGSBlendTypeG
---@field BlendInExp float
---@field BlendOutRealTime float
---@field BlendOutType EGSBlendTypeG
---@field BlendOutExp float
---@field ExceptSelf boolean
FFGSTimeScaleSetting = {}



---@class FFGSTurnSkillConfig
---@field TurnDegreeThresholdLow int32
---@field TurnDegreeThresholdHigh int32
---@field LeftSmallTurnSkillID int32
---@field LeftBigTurnSkillID int32
---@field RightSmallTurnSkillID int32
---@field RightBigTurnSkillID int32
---@field bDisableImmediatePathfinding boolean
FFGSTurnSkillConfig = {}



---@class FFGSTurnSkillRange
---@field AngleLow float
---@field AngleHigh float
FFGSTurnSkillRange = {}



---@class FFGSWakeUpConfig
---@field OnFightSkillID int32
---@field DirectionOnFightSkillConfig FFGSWakeUpDirectionOnFightSkillConfig
---@field bJustUseOnFightSkillFirstTime boolean
---@field SurpriseSkillID TArray<int32>
---@field WakeUpLinkEnable boolean
---@field CanTriggerWakeUpLinkWhenDead boolean
---@field UseManualSelect boolean
---@field TargetList TArray<ABGUCharacter>
---@field TargetTamerList TArray<ABUTamerActor>
---@field UseRangeSelect boolean
---@field RangeType RangeType
---@field RangeParam_1 float
---@field RangeParam_2 float
---@field RangeParam_3 float
---@field ResIDList TArray<int32>
---@field bSelectUnitHasTarget boolean
---@field bSelectPassiveUnit boolean
FFGSWakeUpConfig = {}



---@class FFGSWakeUpDirectionOnFightSkillConfig
---@field OnFightSkillIDBack int32
---@field OnFightSkillIDLeft int32
---@field OnFightSkillIDRight int32
FFGSWakeUpDirectionOnFightSkillConfig = {}



---@class FFGSwitchBulletMovableInfo
FFGSwitchBulletMovableInfo = {}


---@class FFNPCIdleAnimInfo
---@field IdleAnim UAnimSequence
---@field Comment FString
FFNPCIdleAnimInfo = {}



---@class FFNPCLeisureAnimInfo
---@field LeisureAnim UAnimMontage
---@field OnFightSkillID int32
---@field OnFightSkillIDBack int32
---@field OnFightSkillIDLeft int32
---@field OnFightSkillIDRight int32
---@field Comment FString
FFNPCLeisureAnimInfo = {}



---@class FFPAQI_SelectUnitTypeInfo
---@field SelectUnitType PriorityActionSelectUnitType
---@field SelectUnitTypeIntParams TArray<int32>
---@field SelectUnitTypeFloatParams TArray<float>
FFPAQI_SelectUnitTypeInfo = {}



---@class FFPEConfig
---@field ProtectTime float
---@field DecreaseValuePerSecond float
---@field LevelValue float
---@field DBC_EnterLevel UBGWDataAsset_B1DBC
---@field BuffIDList TArray<int32>
---@field BuffIDList_LevelUp TArray<int32>
FFPEConfig = {}



---@class FFSCDCollisionInfo
---@field ScaleRate float
---@field KeepTime float
---@field CollisionColor FColor
FFSCDCollisionInfo = {}



---@class FFTPModeConfigTabInfo
---@field ImageTex UTexture2D
FFTPModeConfigTabInfo = {}



---@class FFTPModeFilterInfo
---@field DisplayName FText
---@field LUTTexture UTexture
FFTPModeFilterInfo = {}



---@class FFTPModeFrame
---@field DisplayName FText
---@field TargetAKB FString
FFTPModeFrame = {}



---@class FFTPModeStickerImage
---@field DisplayName FText
---@field ImageTex UTexture2D
FFTPModeStickerImage = {}



---@class FFTWForceData
---@field VectorUseType TWVectorUseType
---@field bUseRandomVector boolean
---@field VectorBaseLow FVector
---@field VectorBaseHigh FVector
---@field BlendCurve UCurveFloat
---@field ScalarMultiplier float
FFTWForceData = {}



---@class FFTWImpulseData
---@field VectorUseType TWVectorUseType
---@field bUseRandomVector boolean
---@field VectorBaseLow FVector
---@field VectorBaseHigh FVector
---@field ZAmplitudeRatio float
---@field BlendCurve UCurveFloat
---@field ScalarMultiplier float
FFTWImpulseData = {}



---@class FFUIData
---@field Con TArray<FWidgetConfig>
---@field Img TArray<FImageWidget>
---@field Text TArray<FTextWidget>
---@field AdvancedHitTexture UTexture2D
---@field AdvancedHitDA UDataAsset
---@field AdvancedHitAlpha float
FFUIData = {}



---@class FFieldBuffInfo
---@field bIgnoreTypeFilter boolean
---@field TargetTeamFilter int32
---@field TargetTypeFilter int32
---@field BuffID int32
FFieldBuffInfo = {}



---@class FFollowPartnerDodgeInfo
---@field CanTrigger boolean
---@field TriggerCD int32
---@field TriggerRadius int32
---@field VelocityDifferent int32
---@field ForwardDodgeMontageList TArray<UAnimMontage>
---@field BackwardDodgeMontageList TArray<UAnimMontage>
---@field LeftSideDodgeMontageList TArray<UAnimMontage>
---@field RightSideDodgeMontageList TArray<UAnimMontage>
---@field CanTriggerEQSRun boolean
---@field EQSRunParamInfo FFEQSRunParamInfo
FFollowPartnerDodgeInfo = {}



---@class FFollowPartnerIdleWaitingInfo
---@field CanTrigger boolean
---@field TriggerCD int32
---@field IdleRandomMontageList TArray<UAnimMontage>
FFollowPartnerIdleWaitingInfo = {}



---@class FFollowPatrolConfig
---@field FollowTarget ACharacter
FFollowPatrolConfig = {}



---@class FFreqConfig
---@field Percent float
---@field Freq float
FFreqConfig = {}



---@class FGMCharaterConfig
FGMCharaterConfig = {}


---@class FGSObjActorMoveInfo
FGSObjActorMoveInfo = {}


---@class FGainItemConfig
---@field ItemId int32
---@field ItemCount int32
FGainItemConfig = {}



---@class FGamePlusSpawnConfig
---@field GamePlusCount int32
---@field SpawnerConfig TArray<FGamePlusSpawnerConfig>
FGamePlusSpawnConfig = {}



---@class FGamePlusSpawnerConfig
---@field Rate int32
---@field ActorClass TSubclassOf<AActor>
FGamePlusSpawnerConfig = {}



---@class FGamepadCustomizedInputConfig
---@field DetailConfigs TArray<FGamepadCustomizedInputDetailConfig>
FGamepadCustomizedInputConfig = {}



---@class FGamepadCustomizedInputDetailConfig
---@field DetailUIWord int32
---@field AnimationName FName
---@field FirstMappableNames TArray<FName>
---@field SecondMappableNames TArray<FName>
FGamepadCustomizedInputDetailConfig = {}



---@class FGlobalFXConfigInfo
---@field FXTemplate UNiagaraSystem
---@field FXTag FGameplayTag
---@field BulletPositionParamName FName
---@field MFSpherePosParamName FName
---@field MFSphereRadiusParamName FName
---@field bMFSphereUseRadiusArray boolean
---@field AvoidanceMFSpherePosParamName FName
---@field AvoidanceMFSphereRadiusParamName FName
---@field bAvoidanceMFSphereUseRadiusArray boolean
---@field FXStartPointTag FName
---@field FXStartPointParamName FName
FGlobalFXConfigInfo = {}



---@class FGridRow_ForAbnormalDisp
---@field ActorList TArray<ASkeletalMeshActor>
FGridRow_ForAbnormalDisp = {}



---@class FGroupAIBPConfig
---@field IsForceDisableGroupAI boolean
---@field IsBossUnit boolean
---@field OnlyUseOnceOnFightSkill boolean
---@field GroupAIOnFightSkillList TArray<int32>
---@field OnlyTriggerOnceAddBuffWhenReceiveToken boolean
---@field BuffListWhenReceiveToken TArray<int32>
---@field OnlyTriggerOnceAddBuffWhenLostToken boolean
---@field BuffListWhenLostToken TArray<int32>
FGroupAIBPConfig = {}



---@class FGroupAIHotZoneCircleCustomInfo
---@field EnableCustomSetting boolean
---@field BattleCirclePointRingNum int32
---@field BattleCirclePointAngleInterval int32
FGroupAIHotZoneCircleCustomInfo = {}



---@class FGsActorGuidReference
---@field ActorRef TSoftObjectPtr<AActor>
---@field ActorGuid FString
FGsActorGuidReference = {}



---@class FGsSpiderNavPointInfo
---@field Location FVector
---@field Normal FVector
---@field LinkRadius float
---@field LinkAngle float
---@field NavLinkPoints TArray<FGsSpiderNavPointLinkInfo>
---@field IsGroundPoint boolean
FGsSpiderNavPointInfo = {}



---@class FGsSpiderNavPointLinkInfo
---@field LinkPointIndex int32
---@field Cost float
FGsSpiderNavPointLinkInfo = {}



---@class FHatchConfigInfo
---@field TamerClass TSubclassOf<ABUTamerActor>
---@field SpawnAMList TArray<UAnimMontage>
---@field SpawnSocketName FName
---@field bFaceToTarget boolean
---@field SpawnDBC UBGWDataAsset_B1DBC
---@field bSyncCurTarget boolean
---@field BirthBuffIDList TArray<int32>
FHatchConfigInfo = {}



---@class FHelloUStructTest
---@field TestValue float
FHelloUStructTest = {}



---@class FHeroIconInfo
---@field ResID int32
---@field IconTexture UTexture2D
FHeroIconInfo = {}



---@class FHiAltFxAnimalRotInfo
---@field RotType HitAltFxAnimalRotType
---@field SurroundOffset FVector
FHiAltFxAnimalRotInfo = {}



---@class FHiAltFxAnimalSpawnTemplate
---@field FXAnimalTemplateList TArray<TSubclassOf<ABGUFXAnimalActor>>
---@field EQSTemplateList TArray<UEnvQuery>
---@field ZOffset FFloatRange
---@field bUseHighestScorePoint boolean
---@field RotInfo FHiAltFxAnimalRotInfo
---@field ReSpawnCoolDown float
FHiAltFxAnimalSpawnTemplate = {}



---@class FHitCheckConf
---@field HitActionDir HitActionDir
---@field ResultFilterType ESweepCheckHitFilterType
---@field IsRenderDebugShape boolean
FHitCheckConf = {}



---@class FHitDestructibleActorConfig
---@field EnableCanHitDestructible boolean
---@field HitStrengthLevel EGSHitDestructibleStrengthLevel
---@field HitDirection EGSHitDestructibleDirection
FHitDestructibleActorConfig = {}



---@class FHitForZBBInfo
FHitForZBBInfo = {}


---@class FHitModifySkillScoreInfo
---@field SkillID int32
---@field ModifyScore float
FHitModifySkillScoreInfo = {}



---@class FIKRigBoneDefinition
---@field TargetTransform FTransform
---@field BoneName FName
FIKRigBoneDefinition = {}



---@class FIL2CPPUnitTestStruct1
---@field CSClassProperty UAnimMontage
---@field CSIntProperty int32
---@field CSIntProperty2 int32
FIL2CPPUnitTestStruct1 = {}



---@class FIL2CPPUnitTestStructInner
---@field ItemInts TArray<FName>
---@field InnerStruct TArray<FIL2CPPUnitTestStructInnerInner>
FIL2CPPUnitTestStructInner = {}



---@class FIL2CPPUnitTestStructInnerInner
---@field FloatVal float
---@field YesNo EGSYesNo
---@field GameTag FGameplayTag
---@field AnimSub UAnimSequence
FIL2CPPUnitTestStructInnerInner = {}



---@class FIL2CPPUnitTestStructOuter
---@field TestInt int32
---@field ItemStructs TArray<FIL2CPPUnitTestStructInner>
---@field Anim UAnimSequence
---@field TestInt2 int32
FIL2CPPUnitTestStructOuter = {}



---@class FIdleProcessAction
---@field ActionType IdleProcessActionType
---@field bTeleportToOtherLevel boolean
---@field TargetLevelID int32
---@field PointName FName
---@field BeforeTeleportMontage TSoftObjectPtr<UAnimMontage>
---@field AfterTeleportMontage TSoftObjectPtr<UAnimMontage>
---@field bSaveArchiveAfterTeleport boolean
---@field ArchiveLabel FName
---@field RebirthPointId int32
---@field IsBlockRebirthpoint boolean
---@field Unit FGsSmartParam
---@field UnitOrPlayerorNPC FGsSmartParam
---@field DropItemManageGuid FString
---@field AiConversation FGsSmartParam
---@field NPCUnit FGsSmartParam
---@field NPCTeamID int32
---@field NPCIdleAMIdx int32
---@field NPCLeisureAnimIndex int32
---@field NPCActionSkillID int32
---@field NPCInteractGroupID int32
---@field TargetActor FGsActorGuidReference
---@field MoveAIType EBGUMoveAIType
---@field MoveSpeedType EAIMoveSpeedType
---@field MoveAcceptableRadius float
---@field NPCShowState EGsNPCShowState
---@field UnitTriggerBattleConfigs TArray<FProcessUnitTriggerBattleConfig>
---@field AssociationUnitInfoConfigId FGsSmartParam
---@field AssociationUnitSpawnInfoDelayExecuteTime int32
---@field AssociationUnitSpawnInfoSpawnType AssociationUnitSpawnType
---@field AssociationUnitSpawnInfoActiveType AssociationUnitActiveType
---@field AssociationUnitTarget FGsSmartParam
---@field AssociationOnFightSkillID int32
---@field NpcMoveType NpcMoveType
---@field NpcGuideSplineMoveConfig FNpcGuideSplineMoveConfig
---@field WeakPerformConfigID int32
---@field FollowPartnerConfigId FGsSmartParam
---@field GameplayTag FGameplayTag
---@field bDontResetPlayerState boolean
---@field LoadingScreenType EGSLoadingScreenType
---@field UnitExtendID int32
---@field TeleportLoadingTips TArray<int32>
FIdleProcessAction = {}



---@class FImageConfig
---@field ImgBrush FSlateBrush
---@field UseImgSize boolean
---@field ImgSize FVector2D
---@field UseImgPos boolean
---@field ImgPos FVector2D
---@field MatSyncType MatSyncType
---@field ExMatSyncList TArray<FMatSyncConfig>
---@field UseAtlas boolean
---@field SyncSprite boolean
---@field Sprite UObject
FImageConfig = {}



---@class FImageWidget
---@field WidgetName FString
---@field ImgConfig FImageConfig
FImageWidget = {}



---@class FInputActionOverrideConfig
---@field OverrideTriggerEvents TMap<ETriggerEvent, ETriggerEvent>
FInputActionOverrideConfig = {}



---@class FInputBrushStruct
---@field ImgIconBGBrush FSlateBrush
---@field ImgProgBarBrush FSlateBrush
---@field ImgProgressBrush FSlateBrush
FInputBrushStruct = {}



---@class FInputMappingContextConfigV2
---@field InputMappingContext UInputMappingContext
---@field Priority int32
---@field TriggerPriority int32
---@field TriggerContextTags TArray<InputMappingContextTagV2>
---@field InputMode InputMappingContextMode
---@field IsInitLoading boolean
---@field IsIgnoreBlockRequest boolean
---@field LevelInfo FInputMappingContextLevelInfo
---@field IsPermanent boolean
---@field CustomizedInputOverrideConfigs TMap<CustomizedInputType, FCustomizedInputOverrideConfig>
FInputMappingContextConfigV2 = {}



---@class FInputMappingContextLevelInfo
---@field LevelInfoType InputMappingContextLevelInfoType
---@field LevelTag LevelTag
FInputMappingContextLevelInfo = {}



---@class FInputTipsCfg
---@field AwalysShowInput FInputTipsList
---@field OptionShowInput TMap<InputTipsType, FInputTipsList>
FInputTipsCfg = {}



---@class FInputTipsLeftRightCfg
---@field LeftInputTipsCfg FInputTipsCfg
---@field RightInputTipsCfg FInputTipsCfg
FInputTipsLeftRightCfg = {}



---@class FInputTipsList
---@field InputActionList TArray<FInputTipsOneCfg>
FInputTipsList = {}



---@class FInputTipsOneCfg
---@field InputAction UInputAction
---@field TxtDesc FText
FInputTipsOneCfg = {}



---@class FInteractInfoTemplateNameList
---@field BoneNameList TArray<FName>
FInteractInfoTemplateNameList = {}



---@class FInteractInfoTemplateWithLOD
---@field InfoTemplateWithLOD TMap<int32, FInteractInfoTemplateNameList>
FInteractInfoTemplateWithLOD = {}



---@class FInterpSpeed
---@field InterpMode SpeedInterpMode
---@field Speed float
FInterpSpeed = {}



---@class FIntimidateBPConfig
---@field IntimidatingProbability int32
---@field IntimidatingMinStiffLevel int32
---@field IntimidatingCD float
---@field IntimidatingRange int32
---@field IntimidatingInfluenceMaxNum int32
---@field IntimidatedSkillList TArray<int32>
---@field IntimidatedProbability int32
---@field IntimidatedCD float
FIntimidateBPConfig = {}



---@class FKeyIconInfo
---@field Key FKey
---@field Offset float
FKeyIconInfo = {}



---@class FKillUnitMapConfig
---@field Cond KillUnitMapCond
---@field Result KillUnitMapResult
FKillUnitMapConfig = {}



---@class FLandCamShake
---@field CameraShake_Mid TSubclassOf<UMatineeCameraShake>
---@field CameraShake_High TSubclassOf<UMatineeCameraShake>
---@field CameraShake_Dead TSubclassOf<UMatineeCameraShake>
FLandCamShake = {}



---@class FLeisureWithWeight
---@field LeisureReference UAnimMontage
---@field Weight int32
FLeisureWithWeight = {}



---@class FLevelIdListInfo
---@field LevelIdList TArray<int32>
FLevelIdListInfo = {}



---@class FLevelNameConfig
---@field NameList TArray<int32>
FLevelNameConfig = {}



---@class FLevelSequenceConfig
---@field Sequence TSoftObjectPtr<ULevelSequence>
---@field CameraStartTransform FTransform
---@field CameraTag FName
---@field RailTag FName
---@field CraneTag FName
FLevelSequenceConfig = {}



---@class FLevelSkeletalMeshCheckActorInfoHelper
---@field ActorLabel FString
---@field Path FString
FLevelSkeletalMeshCheckActorInfoHelper = {}



---@class FLevelSkeletalMeshCheckInfoHelper
---@field LevelPath FString
---@field ActorWithoutPerfInfos TArray<FLevelSkeletalMeshCheckActorInfoHelper>
FLevelSkeletalMeshCheckInfoHelper = {}



---@class FLightningFXSpawnConfig
---@field LightningTemplate UNiagaraSystem
---@field DecalActorClass TSubclassOf<ABGUDecalActor>
---@field SpawnWaves int32
---@field WaveGap float
---@field SpawnNumPerWave int32
---@field LightningDelaySpawnDecalTime float
---@field bRecalcPointPerWave boolean
---@field bSpawnBySelfMode boolean
---@field DirBaseOnParent boolean
---@field RangeDir_X FFloatRange
---@field RangeDir_Y FFloatRange
---@field RangeDir_Z FFloatRange
---@field LineTraceMaxLength float
---@field TraceTypeQuery ETraceTypeQuery
---@field PointMinBetween float
FLightningFXSpawnConfig = {}



---@class FLimbIKBonePair
---@field BoneName FName
---@field VBoneName FName
FLimbIKBonePair = {}



---@class FLimbIKData
---@field LimbRootBoneName FName
---@field LimbEndBoneName TArray<FName>
---@field LimbTraceUP float
---@field LimbTraceDown float
---@field LimbCurveName FName
FLimbIKData = {}



---@class FLimbIKEffectorsInfo
FLimbIKEffectorsInfo = {}


---@class FMFDirectionEffect
---@field TriggerEvent MagicFieldEffectTriggerEvent
---@field bIgnoreTypeFilter boolean
---@field TargetTeamFilter int32
---@field TargetTypeFilter int32
---@field EffectDirectionType MagicFieldEffectDirectionType
---@field ForwardAngle float
---@field BackwardAngle float
---@field LeftSideAngle float
---@field RightSideAngle float
---@field ForwardEffects TArray<FMFEffect>
---@field BackwardEffects TArray<FMFEffect>
---@field LeftSideEffects TArray<FMFEffect>
---@field RightSideEffects TArray<FMFEffect>
---@field DisplayNote FString
FMFDirectionEffect = {}



---@class FMFEffect
---@field OverlapEventType MFOverlapEventType
---@field BuffList TArray<FFGSBuffInfo>
---@field SkillEffectList TArray<int32>
---@field SpecificFlags int32
---@field DisplayNote FString
FMFEffect = {}



---@class FMFEvent
---@field bIgnoreTypeFilter boolean
---@field TargetTeamFilter int32
---@field TargetTypeFilter int32
---@field MFEffectList TArray<FMFEffect>
---@field DisplayNote FString
FMFEvent = {}



---@class FMFOverlapEvent
---@field OverlapEventType MFOverlapEventType
---@field TargetTeamFilter int32
---@field TargetTypeFilter int32
---@field BuffList TArray<FFGSBuffInfo>
---@field SkillEffectList TArray<int32>
---@field Note FString
FMFOverlapEvent = {}



---@class FMagicallyChangeConfig_TFXConfig
---@field TFXAsset UTressFXAsset
---@field HairMaterial UMaterialInterface
---@field ShadeSettings FTressFXShadeSettings
---@field LodScreenSize float
---@field bEnableSimulation boolean
FMagicallyChangeConfig_TFXConfig = {}



---@class FManagedLevelStates
---@field LevelState EGSLevelState
---@field bDisableKeyword boolean
---@field LevelNames TArray<FString>
FManagedLevelStates = {}



---@class FManagedNPCObj
---@field Actor TSoftObjectPtr<ABGUActorBaseCS>
---@field ActorGuid FString
---@field AliasName FName
---@field ManagedNPCUnitType ManagedNPCUnitType
FManagedNPCObj = {}



---@class FManagedNPCUnit
---@field Actor TSoftObjectPtr<ABGUCharacterCS>
---@field Tamer TSoftObjectPtr<ABUTamerActor>
---@field ActorGuid FString
---@field AliasName FName
FManagedNPCUnit = {}



---@class FManagedObjectsForTask
---@field TaskUnitCollection TArray<FManagedTaskUnit>
---@field TaskObjCollection TArray<FManagedTaskObj>
FManagedObjectsForTask = {}



---@class FManagedStreamingLevelStateBoxConfig
---@field Actor FGsActorGuidReference
---@field ManagedStateLevelsConfig FManagedStreamingLevelStateConfig
FManagedStreamingLevelStateBoxConfig = {}



---@class FManagedStreamingLevelStateConfig
---@field Description FString
---@field LevelStateConfigs TArray<FManagedLevelStates>
FManagedStreamingLevelStateConfig = {}



---@class FManagedTaskObj
---@field Actor TSoftObjectPtr<ABGUActorBaseCS>
---@field ActorGuid FString
---@field AliasName FName
FManagedTaskObj = {}



---@class FManagedTaskUnit
---@field Actor TSoftObjectPtr<ABGUCharacterCS>
---@field Tamer TSoftObjectPtr<ABUTamerActor>
---@field ActorGuid FString
---@field AliasName FName
FManagedTaskUnit = {}



---@class FMapAttrNode
---@field BlockCatDir MapCatFlag
---@field IsPointBlock boolean
---@field InPointLoc PointBlockLocFlag
---@field PathCatID uint64
FMapAttrNode = {}



---@class FMapLevelConfig
---@field Priority int32
---@field Size float
---@field Range float
---@field Friction float
---@field MinScale float
---@field MaxScale float
---@field IsCanSelect boolean
---@field SelectedScale float
---@field MinCanShowScale float
FMapLevelConfig = {}



---@class FMapLineData
FMapLineData = {}


---@class FMapPointData
FMapPointData = {}


---@class FMapProceduralInfo
---@field MapInfoMatrix TArray<FMapAttrNode>
---@field MapBlockMapping TMap<MapCatFlag, FSoftObjectPath>
---@field MapCustomLightConfigs TArray<FSoftObjectPath>
---@field EntranceX int32
---@field EntranceY int32
---@field ExitX int32
---@field ExitY int32
---@field ExpectedPointNumber int32
---@field MapWidth int32
---@field MapHeight int32
---@field BlockWidth int32
---@field BlockHeight int32
---@field MaxPointWidth int32
---@field MaxPointHeight int32
---@field MinPointWidth int32
---@field MinPointHeight int32
---@field IsUsingRanEE boolean
---@field MapType ProceduralMapType
---@field PathCount uint16
FMapProceduralInfo = {}



---@class FMapSymbolConfig
---@field Name FString
---@field MapSymbolType MapSymbolType
---@field UnlockRadius int32
---@field UnlockHeight int32
FMapSymbolConfig = {}



---@class FMatCommParams
---@field UseTimerParam boolean
---@field Timer float
---@field UseRandomParam boolean
---@field RandomUpdate float
---@field UseMouseParam boolean
---@field IsShowFocusPosInGamepad boolean
---@field MousePos FVector2D
---@field MouseSpeed float
---@field UseWidgetParam boolean
---@field IsDynamic boolean
---@field ViewportScale float
---@field AbsPos FVector2D
---@field AbsSize FVector2D
---@field InHover boolean
FMatCommParams = {}



---@class FMatLayerFunctionInfo
---@field Association EMaterialParameterAssociation
---@field LayerFunction UMaterialFunctionInterface
FMatLayerFunctionInfo = {}



---@class FMatParam
---@field ParamType EGSMatParamType
---@field ParameterName FName
---@field FloatValue float
---@field VectorValue FVector
---@field LinearColorValue FLinearColor
---@field FloatCurve UCurveFloat
---@field VectorCurve UCurveVector
---@field LinearColorCurve UCurveLinearColor
---@field SocketName FName
---@field CharacterInfoRefresh boolean
---@field bUseScreenSpace boolean
---@field bUseLastFrameValue boolean
FMatParam = {}



---@class FMatParamInfo
---@field ParameterName FName
---@field FloatCurve UCurveFloat
FMatParamInfo = {}



---@class FMatSyncConfig
---@field Name FName
---@field MatType MatType
FMatSyncConfig = {}



---@class FMaterialLayerKeyData
---@field LayerMappingInfo FMaterialLayerMappingInfo
---@field ParamName FName
FMaterialLayerKeyData = {}



---@class FMaterialLayerMappingInfo
---@field LayerMappingIdx int32
---@field LayerMappingName FName
FMaterialLayerMappingInfo = {}



---@class FMaterialLayerParamData
---@field LayerKeyData FMaterialLayerKeyData
---@field ParamType MaterialLayerParamType
---@field ScalarValue float
---@field ColorValue FLinearColor
---@field ScalarCurve UCurveFloat
---@field ColorCurve UCurveLinearColor
---@field bEnableAutoBlendOut boolean
---@field AutoBlendOutScalarValue float
---@field AutoBlendOutColorValue FLinearColor
FMaterialLayerParamData = {}



---@class FMaterialLayerParamGlobalConfigData
---@field ParamEvaluateType MaterialLayerParamEvaluateType
---@field ClampMin float
---@field ClampMax float
---@field AutoBlendOutSpeedCurve UCurveFloat
FMaterialLayerParamGlobalConfigData = {}



---@class FMaterialParameterConfig
---@field InterpSpeed float
---@field AttrValueMapCurve UCurveFloat
---@field ParameterAssociation EMaterialParameterAssociation
---@field ParameterName FName
---@field ParameterLayerFunction UMaterialFunctionInterface
FMaterialParameterConfig = {}



---@class FMayaShadingEngineToUnrealMaterial
---@field MayaShadingEngineName FName
---@field Material UMaterial
FMayaShadingEngineToUnrealMaterial = {}



---@class FMeditationPointConfig
---@field MeditationPointID int32
---@field TargetCheckRange int32
FMeditationPointConfig = {}



---@class FMonsterManualInfo
---@field ScalarParameterMap TMap<FName, float>
---@field VectorParameterMap TMap<FName, FLinearColor>
FMonsterManualInfo = {}



---@class FMontageTestUnit
---@field Montage UAnimMontage
---@field describe FString
FMontageTestUnit = {}



---@class FMoveAMPath
---@field OriginPath FString
---@field NewAMName FString
FMoveAMPath = {}



---@class FMovieConditionQueryConfig
---@field ConditionQueryType MovieConditionQueryType
---@field GroupUnitGuid FGameplayTag
FMovieConditionQueryConfig = {}



---@class FMovieGraphPlaySettings
---@field PlaybackSettings FMovieSceneSequencePlaybackSettings
---@field CameraSettings FLevelSequenceCameraSettings
---@field bUsePlayerCamera boolean
---@field bTriggerMonsterGoHome boolean
FMovieGraphPlaySettings = {}



---@class FMovieLevelStateRequestConfig
---@field LevelID int32
---@field ConfigID int32
FMovieLevelStateRequestConfig = {}



---@class FMovieRelationInfo
---@field MovieRelationType MovieRelationType
---@field ActorGuid FString
---@field Location FVector
FMovieRelationInfo = {}



---@class FMovieRelationInfoCollection
---@field SequenceID int32
---@field bCanRepeatPlay boolean
---@field RelationInfos TArray<FMovieRelationInfo>
---@field ManualRelationInfos TArray<FMovieRelationInfo>
FMovieRelationInfoCollection = {}



---@class FMovieSequencePlaySettings
---@field Sequences TArray<ULevelSequence>
---@field CameraTransforms TArray<FTransform>
---@field CameraTags TArray<FString>
---@field RailTags TArray<FString>
---@field CraneTags TArray<FString>
---@field bUseCinematicCamera boolean
---@field bUseRail boolean
---@field bUseCrane boolean
---@field StartTimeSeconds float
---@field InCameraBlendTime float
---@field InCameraBlendFunction EViewTargetBlendFunction
---@field InCameraBlendFactor float
---@field bLoopPlay boolean
FMovieSequencePlaySettings = {}



---@class FMovieTriggerRelationInfo
---@field TriggerType MovieTriggerType
---@field bHasMultiActor boolean
---@field Monsters TArray<FString>
---@field ActorGuid FString
---@field Location FVector
---@field TaskStageStatus StageStatus
---@field TaskStage int32
FMovieTriggerRelationInfo = {}



---@class FNeutralAnimalConfig
---@field NeutralAnimalType NeutralAnimalType
---@field BackToPatrolRange float
FNeutralAnimalConfig = {}



---@class FNeutralAnimalTerritoryInfo
---@field BoxTransform FTransform
---@field PresetSpawnPositions TArray<FVector>
---@field BoxExtend FVector
---@field AnimalTemplates TArray<FAnimalSpawnTemplate>
FNeutralAnimalTerritoryInfo = {}



---@class FNormalDeadAMInfo
---@field StiffLevelID int32
---@field IsEnableStiffContinue boolean
---@field IsEnableReuse boolean
---@field StiffLevelReuseID int32
---@field DeadEllipsisType DeadEllipsisType
---@field EnableBeAttackedRotate boolean
---@field SectorsType NormalStiffSectorsType
---@field NormalStiffRotateForwardLeft_FNB float
---@field NormalStiffRotateForwardRight_FNB float
---@field NormalStiffRotateForwardLeft_FourDir float
---@field NormalStiffRotateForwardRight_FourDir float
---@field NormalStiffRotateBackwardLeft_FourDir float
---@field NormalStiffRotateBackwardRight_FourDir float
FNormalDeadAMInfo = {}



---@class FNormalStiffInfo
---@field StiffLevelID int32
---@field IsEnableReuse boolean
---@field StiffLevelReuseID int32
---@field EllipsisType EllipsisType
---@field EnableBeAttackedRotate boolean
---@field SectorsType NormalStiffSectorsType
---@field NormalStiffRotateForwardLeft_FNB float
---@field NormalStiffRotateForwardRight_FNB float
---@field NormalStiffRotateForwardLeft_FourDir float
---@field NormalStiffRotateForwardRight_FourDir float
---@field NormalStiffRotateBackwardLeft_FourDir float
---@field NormalStiffRotateBackwardRight_FourDir float
FNormalStiffInfo = {}



---@class FNpcGuideSplineMoveConfig
---@field SplineActor FGsActorGuidReference
---@field NeedSwitchSpeedByDistanceToPlayer boolean
---@field SplineMoveSpeed EAIMoveSpeedType
---@field MaxDistance_Sprint float
---@field MaxDistance_Run float
---@field MaxDistance_Jog float
---@field DistanceBuffer float
FNpcGuideSplineMoveConfig = {}



---@class FObservationModeConfig
---@field ObserveOpType ModelOperateType
---@field RotationRangeYaw float
---@field YawRotationAccMultipleFactorMouse float
---@field YawRotationAccMultipleFactorGamepad float
---@field YawRotationMaxAcc float
---@field YawRotationStopAcc float
---@field YawRotationMaxSpeed float
---@field RotationRangePitch float
---@field PitchRotationAccMultipleFactorMouse float
---@field PitchRotationAccMultipleFactorGamepad float
---@field PitchRotationMaxAcc float
---@field PitchRotationStopAcc float
---@field PitchRotationMaxSpeed float
---@field ZoomUpRange float
---@field ZoomDownRange float
---@field ZoomSpeedMouse float
---@field ZoomSpeedGamepad float
---@field DragAreaName FString
---@field ObsDragAreaName FString
---@field StopJudgmentTime float
---@field LeftStickXInputThreshold float
FObservationModeConfig = {}



---@class FObserveActorInfo
---@field ConditionType ObserveConditionType
---@field ObservedPlayerOrUnitOrActor FGsSmartParam
---@field UnitState EBGUUnitState
---@field SimpleState EBGUSimpleState
---@field AttrFloatType EBGUAttrFloat
---@field CompareOperation ValueCompareOperations
---@field CompareValue float
---@field Buff FGsSmartParam
FObserveActorInfo = {}



---@class FObserveRoleDataInfo
---@field ObserveType RoleDataType
---@field TaskStage FGsSmartParam
---@field ObserveTaskStageState TaskStageState
---@field InteractorGroupID FGsSmartParam
---@field InteractionStep int32
---@field OwningItemID int32
---@field OwningNum int32
---@field ConsumeItemID int32
---@field ConsumptionQuantity int32
---@field Comment FString
---@field NeedObserveTaskStageID int32
---@field InteractionGroupID int32
FObserveRoleDataInfo = {}



---@class FObstacleCheckPointWeight
---@field Angle float
---@field Weight float
FObstacleCheckPointWeight = {}



---@class FOneBlockListInfo
---@field IsUseSkill2Block boolean
---@field Skill2Block int32
---@field AM2Block UAnimMontage
---@field IsUseSkill2BlockBounce boolean
---@field Skill2BlockBounce int32
---@field BlockBounceAM UAnimMontage
FOneBlockListInfo = {}



---@class FOneDirectBlockAMInfo
---@field IsUseSkill2Block boolean
---@field Skill2Block int32
---@field AM2Block UAnimMontage
---@field IsUseSkill2BlockBounce boolean
---@field Skill2BlockBounce int32
---@field BlockBounceAM UAnimMontage
---@field IsUseBlockListInfo boolean
---@field OneBlockListInfo TArray<FOneBlockListInfo>
FOneDirectBlockAMInfo = {}



---@class FOnePCurveColorPoint
---@field Mode DispLibDBCPCurvePointColorMode
---@field Value FLinearColor
---@field DurationToPrePoint float
FOnePCurveColorPoint = {}



---@class FOnePCurveScalarPoint
---@field Mode DispLibDBCPCurvePointScalarMode
---@field Value float
---@field DurationToPrePoint float
FOnePCurveScalarPoint = {}



---@class FOnePriorityActionInfo
---@field WaitForBeginTime float
---@field IsRandomNoiseTime boolean
---@field BeginNoiseTime float
---@field ActionType GroupPriorityActionType
---@field PAI_MoveToPos FPriorityActInfo_MoveToPos
---@field PAI_CastSkill FPriorityActInfo_CastSkill
---@field PAI_AddBuff FPriorityActInfo_AddBuff
FOnePriorityActionInfo = {}



---@class FOneUnitPreloadInfo
---@field EnableUnitTransPreloadPreload boolean
---@field WhiteListPreloadTypeMap TMap<FString, boolean>
---@field WhiteListPreloadTypeInfoMap TMap<FString, FSkillTypeInfo>
FOneUnitPreloadInfo = {}



---@class FOnlineSpawnConfig
---@field SpawnNumOnline int32
---@field LowerLimitNumOnline int32
---@field ReSpawnNumOnline int32
FOnlineSpawnConfig = {}



---@class FPairSkillIDBeginEnd
---@field SkillIDBegin int32
---@field SkillIDEnd int32
FPairSkillIDBeginEnd = {}



---@class FPartDamagedAMInfo
---@field DamagedAMPathForward UAnimMontage
---@field DamagedAMPathBackward UAnimMontage
---@field DamagedAMPathLeftSide UAnimMontage
---@field DamagedAMPathRightSide UAnimMontage
FPartDamagedAMInfo = {}



---@class FPatrolBlendSpaceSetting
---@field UseExPatrol boolean
---@field BSRunFwdPatrol UBlendSpace
---@field BSRunBwdPatrol UBlendSpace
---@field BSRunLeftPatrol UBlendSpace
---@field BSRunRightPatrol UBlendSpace
---@field BSJogFwdSlopeLeanPatrol UBlendSpace
---@field BSJogBwdSlopeLeanPatrol UBlendSpace
---@field BSJogLeftSlopeLeanPatrol UBlendSpace
---@field BSJogRightSlopeLeanPatrol UBlendSpace
FPatrolBlendSpaceSetting = {}



---@class FPatrolGroupSetting
---@field SplineActor FGsActorGuidReference
---@field GroupSplinePatrolType EGSGroupSplinePatrolType
---@field GroupMembers TArray<FGsActorGuidReference>
---@field GroupFormation TArray<FVector>
FPatrolGroupSetting = {}



---@class FPerfectBlockDamageInfo
---@field TriggerDeductPerfectBlockValueHitWeight int32
---@field DeductPerfectBlockValueRadio int32
FPerfectBlockDamageInfo = {}



---@class FPerformerInfo
---@field PerformerActorFixedGuid FGameplayTag
---@field Comment FString
FPerformerInfo = {}



---@class FPerformerStateConfig
---@field bPauseAI boolean
---@field bDisableCollision boolean
---@field bDisableMeshCollision boolean
---@field bDisableGravity boolean
---@field bCannotSelected boolean
---@field bInvisible boolean
---@field bInvincible boolean
---@field bPerforming boolean
FPerformerStateConfig = {}



---@class FPerformerTag
---@field GameplayTagContainer FGameplayTagContainer
---@field Name TArray<FName>
FPerformerTag = {}



---@class FPhysicBlendInfo
---@field BoneName FName
---@field PhysicBlendInType PhysicBlendInType
---@field BlendInTime float
---@field PhysicBlendOutType PhysicBlendOutType
---@field BlendOutTime float
FPhysicBlendInfo = {}



---@class FPhysicBlendInfoForDeath
---@field BoneName FName
---@field PhysicBlendInType PhysicBlendInType
---@field BlendFinalValue float
FPhysicBlendInfoForDeath = {}



---@class FPickingConditionItem
---@field UseCondi_HasItem boolean
---@field Condi_HasItem_TargetItemID int32
---@field Condi_HasItem_InteractGroupID int32
FPickingConditionItem = {}



---@class FPlayNiagaraConditions
---@field UnitType DetectedUnitType
---@field Conditions TArray<FDetectCondition>
---@field ConditionalRelation ConditionalRelation
---@field IsReverseCondition boolean
---@field bForDebug boolean
FPlayNiagaraConditions = {}



---@class FPlayerTransactionInteractStartParams
---@field InteractTarget AActor
FPlayerTransactionInteractStartParams = {}



---@class FPointsGenExtParam
---@field SocketName FName
---@field SocketNameList TArray<FName>
---@field EQSPath FString
---@field EQSTemplate UEnvQuery
---@field SceneItemTag FString
---@field Explode_DesiredNum int32
---@field Explode_LineTraceMaxLength float
---@field Explode_TraceTypeQuery ETraceTypeQuery
---@field Explode_PointMinBetween float
---@field Explode_RangeDir_X FFloatRange
---@field Explode_RangeDir_Y FFloatRange
---@field Explode_RangeDir_Z FFloatRange
FPointsGenExtParam = {}



---@class FPointsRegisterReq
---@field RegistID int32
---@field GenType PointsGenType
---@field ExtParam FPointsGenExtParam
FPointsRegisterReq = {}



---@class FPoleDrinkCondition
---@field ConditionType PoleDrinkConditionType
---@field TalentID int32
FPoleDrinkCondition = {}



---@class FPreciseDodgeAwards
---@field AddBuffIds TArray<FFGSBuffInfo>
---@field RemoveBuffIds TArray<int32>
---@field SkillEffectIds TArray<int32>
---@field MaxAwardCount int32
FPreciseDodgeAwards = {}



---@class FPriorityActInfo_AddBuff
---@field BuffIDList TArray<int32>
FPriorityActInfo_AddBuff = {}



---@class FPriorityActInfo_CastSkill
---@field SkillID int32
FPriorityActInfo_CastSkill = {}



---@class FPriorityActInfo_MoveToPos
---@field MoveActionEnvQueryTemplate UEnvQuery
---@field WaitTime float
---@field AcceptableRadius float
---@field SpeedType EAIMoveSpeedType
---@field MoveAIType EBGUMoveAIType
FPriorityActInfo_MoveToPos = {}



---@class FPriorityActionQueInfo
---@field ExecutorNum int32
---@field ResID int32
---@field SelectUnitTypeInfo FFPAQI_SelectUnitTypeInfo
---@field UnitType PriorityActionUnitType
---@field Actions TArray<FOnePriorityActionInfo>
FPriorityActionQueInfo = {}



---@class FProcBarConfig
---@field DefValue float
---@field MaxValue float
FProcBarConfig = {}



---@class FProceduralSpawnCharaterConfig
---@field ProceduralSpawnRadius float
---@field EnableEditorPreviewing boolean
---@field ProceduralWaveConfigs TArray<FProceduralSpawnWaveConfig>
FProceduralSpawnCharaterConfig = {}



---@class FProceduralSpawnSceneItemConfig
---@field ProceduralSpawnList TArray<FProceduralSpawnSceneItemInfo>
---@field EnablePreviewing boolean
---@field SpawnRadius float
FProceduralSpawnSceneItemConfig = {}



---@class FProceduralSpawnSceneItemInfo
---@field SpawnClass TSubclassOf<AActor>
FProceduralSpawnSceneItemInfo = {}



---@class FProceduralSpawnWaveConfig
---@field CharacterAssetConfig FCharacterAssetConfig
---@field SpawnEffectDataAsset UBGWDataAsset
---@field SpawnMethod SPAWN_METHOD
---@field SpawnBaseLoc SPAWN_BASE_LOCATION
---@field SpawnCondition SPAWN_CONDITION
---@field SpawnPercentageParam float
---@field SpawnWaveIndexParam int32
---@field SpawnTriggerDistanceParam float
FProceduralSpawnWaveConfig = {}



---@class FProcessQueryConditionInfo
---@field TaskQueryConditionType TaskQueryCompoundConditionType
---@field bReverseCondition boolean
---@field TaskStageID int32
---@field TaskStageStateType TaskStageStateType
---@field InteractionGroupID int32
---@field InteractionStep int32
---@field IsPlayer boolean
---@field QueryUnitConditions TArray<FDetectCondition>
---@field OwningItemID int32
---@field OwningItemNum int32
---@field Comment FString
FProcessQueryConditionInfo = {}



---@class FProcessUnitTriggerBattleConfig
---@field Unit FGsSmartParam
---@field SwitchTeamID int32
---@field TargetUnit FGsSmartParam
FProcessUnitTriggerBattleConfig = {}



---@class FProjectileBaseStruct
---@field BaseType ProjectileBaseType
---@field UseSocket boolean
---@field SocketName FName
---@field PointSetCachedReqID int32
---@field EQSTemplate UEnvQuery
---@field DontUpdatePosPerWave boolean
---@field DontUpdateBornIndexPerWave boolean
FProjectileBaseStruct = {}



---@class FProjectileBornDirOffsetStruct
---@field UseExtraAimPoint boolean
---@field ExtraAimPointUseSocket boolean
---@field ExtraAimPointName FName
---@field MaxDiffAngle float
---@field AimConstraintAxis FVector
---@field BornDirOffsetX FSpawnBulletMinMaxValue
---@field BornDirOffsetY FSpawnBulletMinMaxValue
---@field BornDirOffsetZ FSpawnBulletMinMaxValue
FProjectileBornDirOffsetStruct = {}



---@class FProjectileBornDirStruct
---@field BornDirType ProjectileBornDirType
---@field JustUseYawInfo boolean
---@field PointSetCachedReqID int32
FProjectileBornDirStruct = {}



---@class FProjectileDisableAbilityMask
---@field mask int32
FProjectileDisableAbilityMask = {}



---@class FProjectileExtAbilityMask
---@field mask int32
FProjectileExtAbilityMask = {}



---@class FProjectileMulTargetRule
---@field HalfAngle float
---@field MaxDistance float
---@field MaxTargetNum int32
FProjectileMulTargetRule = {}



---@class FProjectilePosOffsetStruct
---@field PosOffsetType ProjectilePosOffsetType
---@field OffsetSpace ProjectilePosOffsetSpace
---@field BaseType ProjectileBaseType
---@field UseSocket boolean
---@field SocketName FName
---@field PosOffset FVector
---@field RangeOffsetInfo FRangePointSetRule
---@field VerticalOffset_World float
FProjectilePosOffsetStruct = {}



---@class FProjectileSpawnEventInfo
---@field TotalNumInAWave int32
---@field SelfIndexInAWave int32
FProjectileSpawnEventInfo = {}



---@class FRandomAnims
---@field AnimSequences TArray<UAnimSequence>
FRandomAnims = {}



---@class FRandomPatrolConfig
---@field EnvQuery UEnvQuery
---@field WaitAMProbability float
---@field WaitAM TArray<UAnimMontage>
FRandomPatrolConfig = {}



---@class FRangePointSetRule
---@field RangePointSetType RangePointSetType
---@field MatrixDensity int32
---@field CircleRadius float
---@field InnerCircleRadius float
---@field Noise FVector
FRangePointSetRule = {}



---@class FRebirthPointConfig
---@field RebirthPointId int32
---@field bActiveSetCurrentRebirthPoint boolean
---@field TargetCheckRange int32
FRebirthPointConfig = {}



---@class FRectParam
---@field Height float
---@field Width float
---@field RotateAngle float
FRectParam = {}



---@class FRelationLevelInfo
---@field LevelName FString
---@field RelationInfo FString
FRelationLevelInfo = {}



---@class FResourceID_PreloadOutlaw
---@field Type EIDType_Outlaw
---@field ID int32
---@field RefInfo FString
FResourceID_PreloadOutlaw = {}



---@class FResourceID_PreloadOutlaws
---@field Array TArray<FResourceID_PreloadOutlaw>
FResourceID_PreloadOutlaws = {}



---@class FRingPointGenerate
---@field MinR float
---@field MaxR float
---@field RingNum int32
---@field PointNumPerRing int32
FRingPointGenerate = {}



---@class FRoundParam
---@field Radius float
FRoundParam = {}



---@class FSTBarUninterruptData
FSTBarUninterruptData = {}


---@class FSceneObjTriggerEvent
---@field UnitGuid FString
---@field UnTriggerEvent SceneObjTransitionEvent
---@field TriggerEvent SceneObjTransitionEvent
FSceneObjTriggerEvent = {}



---@class FSceneObjWithState
---@field UnitGuid FString
---@field ActiveState SceneObjTransitionState
FSceneObjWithState = {}



---@class FScrollData
---@field MaxSpeed float
---@field Resistance float
---@field UseSecOrdDyn boolean
---@field Frequency float
---@field Damping float
---@field InitResponse float
FScrollData = {}



---@class FScrollInputData
---@field KeyboardInputTime float
---@field KeyboardScrollMultiplier float
---@field GamepadInputTime float
---@field GamepadScrollOriSpeed float
---@field GamepadScrollMultiplier float
FScrollInputData = {}



---@class FSectorParam
---@field MinR float
---@field MaxR float
---@field LeftAngle float
---@field RightAngle float
FSectorParam = {}



---@class FSeqLevelRelationInfo
---@field LevelName FString
---@field RelationMovie TArray<int32>
FSeqLevelRelationInfo = {}



---@class FSeqSimpleStatePair
---@field SimpleState EBGUSimpleState
---@field IsRemoving boolean
FSeqSimpleStatePair = {}



---@class FServantReq
---@field SummonInstanceID FCalliopeGuid
---@field ServantTamerGuid FString
---@field Summoner AActor
---@field CatchTarget AActor
---@field ServantType ServantType
---@field CBI FContinueBehaviorInfo
---@field AnimationSyncHostGuid FString
---@field SearchTargetType ServantSearchTargetType
---@field CooperativeSCGuid FString
---@field DelayBornTime float
---@field BornMontage UAnimMontage
---@field BornSkill int32
---@field DelayEffectTime float
---@field DelaySummonTime float
---@field BornTransform FTransform
---@field AliveTime float
---@field TamerTemplate UClass
---@field MasterActor AActor
---@field DummyServantActor AActor
---@field MapEquip TMap<EquipPosition, int32>
---@field AttrSnapShot TArray<float>
---@field AttrCopyConfigDesc TArray<uint8>
---@field bFaceToPlayer boolean
---@field InitSpeed float
---@field BornParticle UParticleSystem
---@field BornNiagara UNiagaraSystem
---@field BornDBC UBGWDataAsset_B1DBC
---@field BirthBuffIDs TArray<int32>
---@field DisappearMontagePathList TArray<FString>
---@field DestroyDelayTime float
---@field SafeClampToLand boolean
FServantReq = {}



---@class FSettingHpConfig
---@field Name FString
---@field HPLowPostProcessPercent float
---@field HPLimitPostProcessPercent float
FSettingHpConfig = {}



---@class FSilkEntangleNiagaraParamMapping
---@field NiagaraParamName FName
---@field Ratio float
---@field MappingCurve_CountTotal UCurveFloat
FSilkEntangleNiagaraParamMapping = {}



---@class FSingleBGMConfig
---@field AkEventBegin UAkAudioEvent
---@field AkEventStop UAkAudioEvent
FSingleBGMConfig = {}



---@class FSingleBattleBGMConfig
---@field AkEventBegin UAkAudioEvent
---@field AkEventStop UAkAudioEvent
---@field StopEventConditionConfig FStopEventConditionConfig
FSingleBattleBGMConfig = {}



---@class FSingleTransBGMConfig
---@field AkEventBegin UAkAudioEvent
---@field AkEventStop UAkAudioEvent
---@field LeaveBattleEventStop UAkAudioEvent
FSingleTransBGMConfig = {}



---@class FSkillDamageConfig
---@field DmgReason DamageReason
---@field DmgReasonEffectID int32
---@field DmgReasonEffectIdx int32
---@field BuffOwner AActor
---@field DamageCalcType DamageCalcType
---@field DamageImmueLevel int32
---@field HPMaxINV10000Damage_Abs float
---@field CameraShakeDA FString
FSkillDamageConfig = {}



---@class FSkillPreviewConfig
FSkillPreviewConfig = {}


---@class FSkillSequencePlaySettings
---@field SequenceList TArray<ULevelSequence>
---@field SequenceCameraTransforms TArray<FTransform>
---@field RotationType SkillCameraRotationType
---@field bAttachToUnit boolean
---@field DummyMeshAttachSocketName FName
---@field ExtraCameraForSeqBindTag FName
---@field AttachedCameraFOV float
---@field TeleportAngleDeg float
---@field InCameraBlendTime float
---@field InCameraBlendFactor float
---@field bEnableCameraAutoBlendOut boolean
---@field bStopWhenMontageInterrupted boolean
---@field OutCameraBlendTime float
---@field OutCameraBlendFactor float
---@field TotalDuration float
FSkillSequencePlaySettings = {}



---@class FSkillTypeInfo
---@field SkillIDBeginEndList TArray<FPairSkillIDBeginEnd>
FSkillTypeInfo = {}



---@class FSourceAsset
---@field AssetName FName
---@field MeshAsset UStaticMesh
FSourceAsset = {}



---@class FSpawnBulletMinMaxValue
---@field LeftValue float
---@field RightValue float
---@field IsEquidistance boolean
FSpawnBulletMinMaxValue = {}



---@class FSpawnBulletSpeed
---@field Spd FSpawnBulletMinMaxValue
---@field AccelerationTime float
---@field SpdCurve UCurveFloat
FSpawnBulletSpeed = {}



---@class FSpawnBulletSpeedGroup
---@field SpdGroup TArray<FSpeedGroupValue>
FSpawnBulletSpeedGroup = {}



---@class FSpawnWaveConfig
---@field NextWaveStartCondition FCompositeCondition_SpawnWaveStart
---@field SpawnIntervalRnage FVector2D
---@field SpawnWaveUnits TArray<FSpawnWaveUnitConfig>
FSpawnWaveConfig = {}



---@class FSpawnWaveConfig_Infinite
---@field NextWaveStartCondition FCompositeCondition_SpawnWaveStart
---@field SpawnIntervalRnage FVector2D
---@field SpawnWaveUnits TArray<FSpawnWaveConfig_Infinite_OneWaveWrap>
FSpawnWaveConfig_Infinite = {}



---@class FSpawnWaveConfig_Infinite_OneWaveWrap
---@field SpawnWaveUnits TArray<FSpawnWaveUnitConfig>
---@field RemainUnitNumToTriggerFill int32
---@field SpawnWaveUnits_Fill TArray<FSpawnWaveUnitConfig>
FSpawnWaveConfig_Infinite_OneWaveWrap = {}



---@class FSpawnWaveStartCondition
---@field ConditionType SpawnWaveStartConditionType
---@field Time float
FSpawnWaveStartCondition = {}



---@class FSpawnWaveUnitConfig
---@field SpawnPointType SpawnPointType
---@field EQSTemplate UEnvQuery
---@field QueryConfig TArray<FGSEnvNamedValue>
---@field LocalSpaceType SpawnWaveLocalSpaceType
---@field LocalSpaceOffset FVector
---@field UnitType TSubclassOf<ABGUCharacterCS>
---@field TamerClass TSubclassOf<ABUTamerActor>
---@field SpawnPoints TArray<TSoftObjectPtr<ABGUBattlePaceSpawnPointActor>>
---@field BirthBuff TArray<int32>
---@field SpawnMontage UAnimMontage
---@field bIsFacePlayer boolean
---@field bIsCatchPlayer boolean
---@field SpawnMaster TSoftObjectPtr<ABGUCharacterCS>
---@field MasterTamer TSoftObjectPtr<ABUTamerActor>
FSpawnWaveUnitConfig = {}



---@class FSpecialItemObModeConfig
---@field SpecialItemConfigMap TMap<ObModeSource, FObservationModeConfig>
FSpecialItemObModeConfig = {}



---@class FSpecialStateAM
---@field LoopAM UAnimMontage
---@field EndAM UAnimMontage
FSpecialStateAM = {}



---@class FSpeedGroupValue
---@field LeftValue float
---@field RightValue float
---@field AccelerationTime float
FSpeedGroupValue = {}



---@class FSpiderSpawnPointData
---@field Tag FName
---@field SpiderSpawnPoints TArray<ATargetPoint>
FSpiderSpawnPointData = {}



---@class FSplineFlyMoveConfig
---@field UnitType SplineFlyUnitType
---@field Unit TSoftObjectPtr<ABUTamerActor>
---@field SplineActor TSoftObjectPtr<AActor>
---@field FlySpeed UCurveFloat
---@field DelayTime float
---@field JogSpeed float
---@field RunSpeed float
---@field SprintSpeed float
FSplineFlyMoveConfig = {}



---@class FSplineInfo
---@field SplineStart FVector
---@field SplineEnd FVector
---@field SplineActor ABGUSimpleSplineActor
---@field Guid FString
FSplineInfo = {}



---@class FStalemateInfo
---@field StalemateSkillID TArray<int32>
---@field ReturnHomeSkillID int32
---@field ReturnHomeBuffID int32
FStalemateInfo = {}



---@class FStaminaTextureInfo
---@field StaminaTextureConfig TMap<FName, UTexture>
---@field StaminaCostTextureConfig TMap<FName, UTexture>
---@field StaminaRecoverColorConfig TMap<FName, FLinearColor>
FStaminaTextureInfo = {}



---@class FStateNodeChildActorControl
---@field JJSObstacleCollection TArray<FStateNodeChildActorControlJJSObstacle>
FStateNodeChildActorControl = {}



---@class FStateNodeChildActorControlJJSObstacle
---@field NickName FGameplayTag
---@field State DynamicObstacleState
FStateNodeChildActorControlJJSObstacle = {}



---@class FStiffLevelInfo
---@field StiffLevelValue float
---@field StiffLevelName FString
FStiffLevelInfo = {}



---@class FStopEventConditionConfig
---@field LeaveBattleEventStop UAkAudioEvent
---@field PlayerDeadEventStop UAkAudioEvent
FStopEventConditionConfig = {}



---@class FSummonReq
---@field SummonType SummonType
---@field SummonGuid FCalliopeGuid
---@field SummonID int32
---@field SummonCount int32
---@field Summoner AActor
---@field bTeleportSelf boolean
---@field bConfuseSelf boolean
---@field EffectCaster AActor
---@field BuffOwner AActor
---@field HitLocation FVector
---@field SpawnPointRot FRotator
---@field ContinueBehaviorInfo FContinueBehaviorInfo
---@field bUseContinuousRefresh boolean
---@field SpawnConfigWrap FSummonSpawnConfigWrap
FSummonReq = {}



---@class FSummonSetting
---@field SummonID int32
---@field SummonWeight float
---@field SummonPointIndex int32
FSummonSetting = {}



---@class FSummonSpawnConfigWrap
---@field SummonAliveTime float
---@field BornDelayTime float
---@field BornEffDisplayTime float
---@field BeforeBornTime float
---@field TamerTemplate UClass
---@field SearchTargetType ServantSearchTargetType
---@field SummonUnitRotationType SummonUnitRotationType
---@field SummonUnitLocationType SummonUnitLocationType
---@field SummonPointDA UBGWMonkeySummonDataAsset
---@field EQSTemplate UEnvQuery
---@field PointSetCachedReqID int32
---@field SpawnSocketName FName
---@field SelectPointsRandom boolean
---@field SpawnScaleRange FFloatRange
---@field UseBornSkill boolean
---@field BornSkillIDs TArray<int32>
---@field BornMontages TArray<UAnimMontage>
---@field CopyAttrConfigID int32
---@field IsCopyEquip boolean
---@field SyncBattleSC boolean
---@field IsSummonerAsMaster boolean
---@field IsDestroyWhenSummonerDead boolean
---@field InitSpeed float
---@field SpawnBirthBuff TArray<int32>
---@field BornParticle UParticleSystem
---@field BornNiagara UNiagaraSystem
---@field BornDBC UBGWDataAsset_B1DBC
---@field DisappearMontagePathList TArray<FString>
---@field DestroyDelayTime float
---@field SafeClampToLand boolean
---@field EnsureBornPosCanNavToPlayer boolean
FSummonSpawnConfigWrap = {}



---@class FSummonSpawnPoints
---@field SpawnPoints TArray<FTransform>
FSummonSpawnPoints = {}



---@class FSummonSpawnQuene
---@field SpawnQuenes TArray<FSummonSpawnPoints>
FSummonSpawnQuene = {}



---@class FSweepCheckParamter
---@field WeaponIndex int32
---@field SweepCheckShape TArray<FUStCheckShape>
---@field EffectIDList TArray<int32>
---@field AbnormalStateEffectList TArray<FAbnormalStateAccConfig>
---@field EffectIDListForSceneItem TArray<int32>
---@field HitDestructibleActorConfig FHitDestructibleActorConfig
---@field HitChrAudioID int32
---@field HitChrFXWeight int32
---@field HitCheckConfl FHitCheckConf
---@field CanHitBackBullet boolean
---@field SweepCheckProtectTime float
---@field Animation UAnimSequenceBase
---@field AtkReboundingAM UAnimMontage
---@field LowAtkReboundingAM UAnimMontage
---@field SweepCheckGroupID int32
---@field EffectsWithCondition_Before TArray<FTriggerEffectWithCondition>
---@field EffectsWithCondition_After TArray<FTriggerEffectWithCondition>
FSweepCheckParamter = {}



---@class FTamerFamilyMatchChildInfo
---@field Filter ChildActorFilterType
---@field MatchSocketType SocketMatchTamerType
---@field SocketName FName
---@field ResID int32
---@field NickName FGameplayTag
---@field BuffID int32
FTamerFamilyMatchChildInfo = {}



---@class FTamerInfo_ForAbnormal
---@field TamerFileName FString
---@field TamerPath FString
---@field ResID int32
---@field SKMeshPath FString
---@field SKScale float
---@field FinnalExtendID int32
---@field AbnormalDispID_Attacker int32
---@field AbnormalDispID_Victim int32
---@field ErrorFlag boolean
---@field ErrorLog FString
---@field ImmueList TArray<Birth_AbnormalStateImmueType>
FTamerInfo_ForAbnormal = {}



---@class FTamerRoleSync
---@field Guid FString
---@field SyncState ClientTamerInitNetState
FTamerRoleSync = {}



---@class FTamerStrategyPreDefinesForLevelOverride
---@field DistanceForForceSpawn float
---@field ZOffsetSpawnLimitMeter float
---@field ZOffsetUnloadLimitMeter float
---@field DefaultDelayDestroyTime float
---@field DistanceForActorBeginPlayMeter float
---@field DistanceForUnloadMeter float
---@field AsyncTraceMinEffectRange float
---@field AsyncTraceMaxEffectRange float
---@field DistanceForPatrolActorBeginPlayMeter float
---@field DistanceForUnloadPatrolUnitMeter float
---@field PreloadDistanceMedium float
---@field PreloadDistanceFarthest float
---@field PreloadDistanceLoadMonsterClass float
---@field PreloadDistanceUnLoadMonsterClass float
FTamerStrategyPreDefinesForLevelOverride = {}



---@class FTaskQueryConditionInfo
---@field TaskQueryConditionType TaskQueryCompoundConditionType
---@field bReverseCondition boolean
---@field TaskStage FGsSmartParam
---@field TaskStageStateType TaskStageStateType
---@field InteractionGroup FGsSmartParam
---@field InteractionStep int32
---@field Unit FGsSmartParam
---@field QueryUnitConditions TArray<FDetectCondition>
---@field OwningItemID int32
---@field OwningItemNum int32
---@field Comment FString
FTaskQueryConditionInfo = {}



---@class FTaskStageConditionInfo
---@field TaskStageID int32
---@field TaskStageConditionType TaskStageConditionType
---@field CustomConditionDisplayName FName
FTaskStageConditionInfo = {}



---@class FTeleportParam_Dream
---@field LevelID int32
---@field TeleportPointName FName
---@field RebirthPointId int32
---@field DontResetPlayerState boolean
---@field LoadingScreenType EGSLoadingScreenType
FTeleportParam_Dream = {}



---@class FTeleportParam_NextChapter
---@field LevelID int32
FTeleportParam_NextChapter = {}



---@class FTeleportParam_PlayerRebirth
---@field LevelID int32
---@field TeleportPointName FName
FTeleportParam_PlayerRebirth = {}



---@class FTeleportParam_RebirthPoint
---@field RebirthPointId int32
---@field RebirthType RebirthType
---@field FromSettingUI boolean
FTeleportParam_RebirthPoint = {}



---@class FTeleportParam_SimpleLevelIdAndTransform
---@field LevelID int32
---@field TeleportTransform FTransform
---@field LevelTravelUseDefaultPlayerStart boolean
FTeleportParam_SimpleLevelIdAndTransform = {}



---@class FTeleportParam_TeleportNamedPoint
---@field LevelID int32
---@field TeleportPointName FName
FTeleportParam_TeleportNamedPoint = {}



---@class FTerrainEffectInfo
---@field BuffID int32
FTerrainEffectInfo = {}



---@class FTextConfig
---@field Anchors FAnchors
---@field Alignment FVector2D
---@field Pos FVector2D
---@field Color FSlateColor
---@field UseFontSize boolean
---@field FontSize int32
---@field UseLetterSpacing boolean
---@field LetterSpacing int32
---@field ShadowOffset FVector2D
---@field ShadowColor FLinearColor
---@field Justification ETextJustify::Type
---@field FontInfo FSlateFontInfo
---@field ColorMap TMap<TextColorType, FSlateColor>
FTextConfig = {}



---@class FTextWidget
---@field WidgetName FString
---@field TextConfig FTextConfig
FTextWidget = {}



---@class FTileItemConfig
---@field Size FVector2D
---@field Spacer FVector2D
---@field ItemPath FString
FTileItemConfig = {}



---@class FTireMarkUnit
---@field DecalComp UDecalComponent
---@field SocketName FName
---@field SpawnPos FVector
---@field OriDecalLength float
---@field DelayFadeTimer float
---@field FadeTime float
FTireMarkUnit = {}



---@class FTortoiseLevelGroupConfig
---@field ManagedLevels TArray<FString>
FTortoiseLevelGroupConfig = {}



---@class FTortoiseLevelStreamingBoxConfig
---@field Actor FGsActorGuidReference
---@field ManagedStateLevelsConfig FTortoiseManagedStateLevelConfig
FTortoiseLevelStreamingBoxConfig = {}



---@class FTortoiseManagedStateLevelConfig
---@field ManagedStateLevels TMap<EGSLevelState, FTortoiseLevelGroupConfig>
FTortoiseManagedStateLevelConfig = {}



---@class FTortoiseRotateTriggerBoxInfo
---@field UseCurveSettings boolean
---@field RotationAnimation UAnimationAsset
---@field RotationCurve UCurveVector
---@field TransitionCurve UCurveVector
FTortoiseRotateTriggerBoxInfo = {}



---@class FTrainDummySpecialDamageTypeConfig
---@field describe FString
---@field SkillID TArray<int32>
---@field AttackerResIdCondition TArray<int32>
---@field AttackerSimpleStateCondition TArray<EBGUSimpleState>
---@field AttackerUnitStateCondition TArray<EBGUUnitState>
---@field VictimSimpleStateCondition TArray<EBGUSimpleState>
---@field VictimUnitStateCondition TArray<EBGUUnitState>
FTrainDummySpecialDamageTypeConfig = {}



---@class FTransitionCondition_Battle
---@field ConditionType TransitionConditionType_Battle
---@field UnitList FGsSmartParamArray
---@field UnitSpawner FGsSmartParam
---@field Unit FGsSmartParam
---@field Buff FGsSmartParam
---@field UnitKillOrder FGsSmartParamArray
---@field GroupUnit FGsSmartParam
---@field Overlap FGsSmartParam
---@field UnitDeadNum int32
---@field CountdownTime int32
---@field bReverseCondition boolean
---@field Comment FString
FTransitionCondition_Battle = {}



---@class FTransitionCondition_Group
---@field ConditionType TransitionConditionType_Group
---@field UnitList FGsSmartParamArray
---@field UnitSpawner FGsSmartParam
---@field Unit FGsSmartParam
---@field Buff FGsSmartParam
---@field UnitKillOrder FGsSmartParamArray
---@field Overlap FGsSmartParam
---@field Interactor FGsSmartParam
---@field GameStateCondition QueryGameStateCondition
---@field Sequence FGsSmartParam
---@field TaskStage FGsSmartParam
---@field TaskStageStatus StageStatus
---@field bReverseCondition boolean
---@field Comment FString
FTransitionCondition_Group = {}



---@class FTransitionCondition_Guide
---@field ConditionType TransitionConditionType_Guide
---@field Overlap FGsSmartParam
---@field AbnormalState AbnormalStateType
---@field RebirthPointId int32
---@field Unit FGsSmartParam
---@field ItemId int32
---@field CheckRange int32
---@field CheckResIdList TArray<int32>
---@field AttrFloatType EBGUAttrFloat
---@field CompareOperation ValueCompareOperations
---@field CompareValue float
---@field TaskStage FGsSmartParam
---@field TaskStageStatus StageStatus
---@field MapId int32
---@field TalentID int32
---@field UIPageType EUIPageType
---@field GuideGroupId int32
---@field SequenceID int32
---@field SequencePhase SequencePhase
---@field ItemNum int32
FTransitionCondition_Guide = {}



---@class FTransitionCondition_Idle
---@field ConditionType TransitionConditionType_Idle
---@field Overlap FGsSmartParam
---@field Interactor FGsSmartParam
---@field Unit FGsSmartParam
---@field NPCUnit FGsSmartParam
---@field GameStateCondition QueryGameStateCondition
---@field Timer_InArea float
---@field Timer_OutArea float
---@field TaskStage FGsSmartParam
---@field TaskStageStatus StageStatus
---@field InteractionGroupID int32
---@field InteractionStep int32
---@field OwningItemID int32
---@field OwningNum int32
---@field ConsumeItemID int32
---@field ConsumptionQuantity int32
---@field TargetActor FGsActorGuidReference
---@field SplineActor FGsActorGuidReference
---@field NpcMoveType NpcMoveType
---@field MoveAcceptableRadius float
---@field SkillID int32
---@field bReverseCondition boolean
---@field Comment FString
FTransitionCondition_Idle = {}



---@class FTransitionCondition_State
---@field ConditionType TransitionConditionType_State
---@field UnitList FGsSmartParamArray
---@field UnitSpawner FGsSmartParam
---@field Unit FGsSmartParam
---@field Buff FGsSmartParam
---@field Overlap FGsSmartParam
---@field Interactor FGsSmartParam
---@field Sequence FGsSmartParam
---@field TaskStage FGsSmartParam
---@field TaskStageStatus StageStatus
---@field CounterType GameplayCounterType
---@field CounterValue float
---@field Comment FString
---@field CircusMemberNickName FGameplayTag
FTransitionCondition_State = {}



---@class FTreeBirdSpawnConfig
---@field SpawnTemplate TSubclassOf<ABGUNeutralFXAnimalSpawnPoint>
---@field InnerRadius float
---@field OutRadius float
---@field PlayerSpdControl float
---@field SprintSpawnAreaAngle float
---@field SpawnCheckInterval float
---@field RefreshDistance float
---@field SpawnNum FInt32Range
---@field DestroyDist float
FTreeBirdSpawnConfig = {}



---@class FTreeImposter_OverrideMPCParam
---@field MPC UMaterialParameterCollection
---@field ScalarParam TArray<FTreeImposter_OverrideMatScalarParam>
---@field LinearColorParam TArray<FTreeImposter_OverrideMatLinearColorParam>
FTreeImposter_OverrideMPCParam = {}



---@class FTreeImposter_OverrideMatLinearColorParam
---@field ParamName FName
---@field Value FLinearColor
FTreeImposter_OverrideMatLinearColorParam = {}



---@class FTreeImposter_OverrideMatScalarParam
---@field ParamName FName
---@field Value float
FTreeImposter_OverrideMatScalarParam = {}



---@class FTreeImposter_OverrideTexSetting
---@field TexName FName
---@field sRGB boolean
---@field CompressionSettings TextureCompressionSettings
---@field LODGroup TextureGroup
---@field CompressionNoAlpha boolean
---@field Filter TextureFilter
---@field isVT boolean
FTreeImposter_OverrideTexSetting = {}



---@class FTreeImposter_TaskData
---@field TreeMeshAsset UStaticMesh
---@field BakeLOD int32
---@field CardMicoScale float
---@field CardPairCount int32
---@field CaptureRTSize int32
---@field ShotTextureSize int32
---@field TrunkMaskThreshold float
---@field LeafMaskThreshold float
FTreeImposter_TaskData = {}



---@class FTreeInfo
---@field Bounds_WithScaled FVector
---@field Pos FVector
---@field Rot FRotator
FTreeInfo = {}



---@class FTriggerAbnormalCondition
---@field UnitType DetectedUnitType
---@field Conditions TArray<FDetectCondition>
---@field ConditionalRelation ConditionalRelation
---@field IsReverseCondition boolean
FTriggerAbnormalCondition = {}



---@class FTriggerEffectWithCondition
---@field UnitType DetectedUnitType
---@field Conditions TArray<FDetectCondition>
---@field ConditionalRelation ConditionalRelation
---@field IsReverseCondition boolean
---@field EffectIDList TArray<int32>
FTriggerEffectWithCondition = {}



---@class FUAkEventConfig
---@field StopMode AkEventStopMode
---@field AttachPointName FName
---@field AkEvent UAkAudioEvent
---@field bFollowAttachPoint boolean
---@field StopTimeMs int32
---@field FadeOutTimeMs int32
---@field CurveInterpolation AkCurveInterpolationCS
FUAkEventConfig = {}



---@class FUDispLib_PostPorcessCommonConf
---@field ID int32
---@field Name FString
---@field ActorType TSubclassOf<AGSDispLib_PostProcessActor>
---@field BeginningDuration float
---@field FinishingDuration float
---@field AutoEnable boolean
FUDispLib_PostPorcessCommonConf = {}



---@class FUDispLib_PostProcessBlueprintConf
---@field Blueprint TSubclassOf<AGSDispLib_PostProcessActor>
FUDispLib_PostProcessBlueprintConf = {}



---@class FUDispLib_PostProcessRadialBlurConf
---@field Material UMaterialInstance
---@field RadialCenter FLinearColor
---@field BlurIntensity float
---@field IterationCount int32
---@field DepthRange float
---@field DepthMaskBias float
---@field TintColor FLinearColor
---@field DesaturationFaction float
---@field BeginningDuration float
---@field FinishingDuration float
FUDispLib_PostProcessRadialBlurConf = {}



---@class FUltimateSkillConfigInfo
---@field TeamID int32
---@field MaxUltimateValue float
---@field UltimateCastingCountDown float
FUltimateSkillConfigInfo = {}



---@class FUnitAIDesc
---@field bOverrideEnableLoSVisualizationInTable boolean
---@field bEnableLoSVisualization boolean
---@field SightRange float
---@field VisionAngleDegrees float
---@field HearRange float
---@field PursuitRange float
---@field AIWatchTimeMin float
---@field AIWatchTimeMax float
---@field bOverrideUnitAIAttackType boolean
---@field UnitAIAttackType UnitAIAttackType
---@field StalemateInfoMap TMap<int32, FStalemateInfo>
FUnitAIDesc = {}



---@class FUnitAttrCondition
---@field AttrFloatType EBGUAttrFloat
---@field CompareOperation ValueCompareOperations
---@field CompareValue float
FUnitAttrCondition = {}



---@class FUnitCDesc
---@field Weapons TArray<FUnitWeapon>
---@field ResID int32
---@field OverrideID int32
---@field BirthBuffs TArray<int32>
---@field StealthSkillIDPair FUnitSealthSkillIDPair
---@field PhysicBlendInfos TArray<FPhysicBlendInfo>
---@field PhysicBlendWeight float
---@field BeAttackedDirForwardRight float
---@field BeAttackedDirForwardLeft float
---@field BeAttackedDirBackwardLeft float
---@field BeAttackedDirBackwardRight float
---@field bSurfaceTypeTraceFromPelvis boolean
FUnitCDesc = {}



---@class FUnitCompFlagConfig
---@field UnitTemplateType UnitTagType
---@field PlayerAlterTags TMap<FString, boolean>
---@field MonsterAlterTags TMap<FString, boolean>
---@field MonsterRejectTags TMap<FString, boolean>
FUnitCompFlagConfig = {}



---@class FUnitDeadPhysicsConfig
---@field DistanceToWall int32
---@field StiffLevel int32
---@field HitActionDir HitActionDir
FUnitDeadPhysicsConfig = {}



---@class FUnitGuidData
---@field GameplayTagGuid FGameplayTag
---@field GameplayTagGuidForGroup FGameplayTag
FUnitGuidData = {}



---@class FUnitLockTargetInfo
---@field LockTargetEntity uint32
---@field LockTargetWayType LockTargetWayType
---@field LockTargetType LockTargetType
---@field LockTargetSceneCompName FString
---@field LockTargetSkeletonSocketName FString
---@field LockPointLocation FVector
---@field SourceType TargetSourceType
FUnitLockTargetInfo = {}



---@class FUnitPhysicsDesc
---@field DefaultTigerWoodsConfig UBGWDataAsset_TigerWoodsConfig
FUnitPhysicsDesc = {}



---@class FUnitSealthSkillIDPair
---@field BeginStealthSkillID int32
---@field EndStealthSkillID int32
FUnitSealthSkillIDPair = {}



---@class FUnitTeam
---@field CharacterList TArray<ABGUCharacterCS>
FUnitTeam = {}



---@class FUnitWeapon
---@field Weapon TSubclassOf<AActor>
---@field SocketName FName
---@field bDefaultInactive boolean
FUnitWeapon = {}



---@class FUnitZBBInfo
FUnitZBBInfo = {}


---@class FUnitsAndSpawners
---@field UnitList FGsSmartParamArray
---@field SpawnerList FGsSmartParamArray
---@field GroupUnitList FGsSmartParamArray
FUnitsAndSpawners = {}



---@class FWEFMLODSetting
---@field CellLength float
---@field CellNumV3 FVector
---@field ScaleRT2DSize float
FWEFMLODSetting = {}



---@class FWaterSplashResource
---@field ApplyDir boolean
---@field AdvanceNiagara FBUC_DispLibDBC_PlayAdvanceNiagara
---@field NiagaraSys UNiagaraSystem
---@field AkEvent UAkAudioEvent
FWaterSplashResource = {}



---@class FWaterSplashResourceMap_WithSurfaceType
---@field FXMap TMap<SceneItemSurfaceType, FWaterSplashResource>
FWaterSplashResourceMap_WithSurfaceType = {}



---@class FWeightConfig
---@field Weight int32
---@field Comment FName
---@field RandomValue float
FWeightConfig = {}



---@class FWidgetConfig
---@field WidgetName FString
---@field Visibility ESlateVisibility
---@field UseSize boolean
---@field Size FVector2D
---@field UsePos boolean
---@field Pos FVector2D
FWidgetConfig = {}



---@class FZBBPreviewConfig
---@field EnableZBBTest boolean
---@field AttackerClass TSubclassOf<ABUTamerActor>
---@field SkillID int32
---@field Delay float
---@field TargetAddBati boolean
---@field OpenLowDensityTest boolean
---@field DistRange FVector2D
---@field MapSize int32
---@field SectorFilterList TArray<int32>
FZBBPreviewConfig = {}



---@class UAFAttackableEnemy : UAttentionFeatureBase
---@field EnemyActors TArray<ABGUCharacterCS>
UAFAttackableEnemy = {}



---@class UAFNearestEnemy : UAttentionFeatureBase
---@field EnemyCharacter ACharacter
UAFNearestEnemy = {}



---@class UAFSkillArea : UAttentionFeatureBase
UAFSkillArea = {}


---@class UAFStandInSkillArea : UAttentionFeatureBase
UAFStandInSkillArea = {}


---@class UAIFeatureTestInfo : UObject
---@field RequiredFeatureList TArray<EAIAttentionFeatureType>
---@field InverseList TArray<boolean>
---@field FeatureTestList TArray<PointTestType>
---@field CheckAngleTestList TArray<FCheckAngleTest>
---@field DistanceTest FDistanceTest
UAIFeatureTestInfo = {}



---@class UAIPointTestInfo : UObject
---@field RingPointGenerate FRingPointGenerate
---@field PointTestList TArray<PointTestType>
---@field CheckAngleTestList TArray<FCheckAngleTest>
---@field DistanceTest FDistanceTest
---@field PointGenBaseType PointGenBaseType
UAIPointTestInfo = {}



---@class UAIReqDirDamage : UAIRequestBase
UAIReqDirDamage = {}


---@class UAIReqMoveSkill : UAIRequestBase
UAIReqMoveSkill = {}


---@class UAIReqMoveToActor : UAIRequestBase
UAIReqMoveToActor = {}


---@class UAIReqMoveToLoc : UAIRequestBase
UAIReqMoveToLoc = {}


---@class UAIRequestBase : UObject
---@field AIRequestType EAIRequestType
---@field FeatureActor AActor
---@field PointTestInfo UAIPointTestInfo
---@field FeatureTestInfo UAIFeatureTestInfo
UAIRequestBase = {}



---@class UActorCompBaseUObj : UObject
UActorCompBaseUObj = {}


---@class UActorCompContainerCS : UBaseActorComp
---@field CompsRef TArray<UActorCompBaseUObj>
---@field bUserForUnit boolean
UActorCompContainerCS = {}

---@param EndPlayReason EEndPlayReason::Type
function UActorCompContainerCS:EndPlayInCS(EndPlayReason) end
---@param InOffset FVector
---@param bWorldShift boolean
function UActorCompContainerCS:ApplyWorldOffsetCS(InOffset, bWorldShift) end


---@class UActorEditCompBase : UEditorOnlyCompBase
UActorEditCompBase = {}


---@class UAnimNotifyState_GSFootSlide : UBANS_GSBase
UAnimNotifyState_GSFootSlide = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UAnimNotifyState_GSFootSlide:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UAnimNotify_GSFootStep : UBAN_GSBase
---@field FootStepType FootStepType
UAnimNotify_GSFootStep = {}

---@param NotifyParam FUStGSNotifyParam
function UAnimNotify_GSFootStep:GSNotifyCS(NotifyParam) end


---@class UAnimNotify_GSFootStep_FootL : UAnimNotify_GSFootStep
UAnimNotify_GSFootStep_FootL = {}

---@param NotifyParam FUStGSNotifyParam
function UAnimNotify_GSFootStep_FootL:GSNotifyCS(NotifyParam) end


---@class UAnimNotify_GSFootStep_FootR : UAnimNotify_GSFootStep
UAnimNotify_GSFootStep_FootR = {}

---@param NotifyParam FUStGSNotifyParam
function UAnimNotify_GSFootStep_FootR:GSNotifyCS(NotifyParam) end


---@class UAsyncLoadAssetHolder : UObject
UAsyncLoadAssetHolder = {}


---@class UAttentionFeatureBase : UObject
---@field FeatureType EAIAttentionFeatureType
UAttentionFeatureBase = {}



---@class UAudioTriggerCompFunctionBinder : UObject
UAudioTriggerCompFunctionBinder = {}

---@param CallbackType EAkCallbackType
---@param CallbackInfo UAkCallbackInfo
function UAudioTriggerCompFunctionBinder:AudioCallback(CallbackType, CallbackInfo) end


---@class UAutoTestHelperLib : UBlueprintFunctionLibrary
UAutoTestHelperLib = {}

---@param WorldContext UObject
function UAutoTestHelperLib:Jump(WorldContext) end
---@param WorldContext UObject
function UAutoTestHelperLib:Dodge(WorldContext) end
---@param WorldContext UObject
---@param IsOpen boolean
function UAutoTestHelperLib:OpenBag(WorldContext, IsOpen) end
---@param WorldContext UObject
function UAutoTestHelperLib:TestCode(WorldContext) end
---@param WorldContext UObject
---@param Text FString
---@param bNeedClick boolean
---@return boolean
function UAutoTestHelperLib:FindText(WorldContext, Text, bNeedClick) end
---@param World UWorld
---@param ActorClass TSubclassOf<AActor>
function UAutoTestHelperLib:GenActor(World, ActorClass) end
---@param Unit AActor
function UAutoTestHelperLib:SetMaxHp(Unit) end
---@param WorldContext UObject
---@param SpellID int32
---@return boolean
function UAutoTestHelperLib:HasSpell(WorldContext, SpellID) end
---@param WorldContext UObject
---@return boolean
function UAutoTestHelperLib:Interact(WorldContext) end
---@param WorldContext UObject
---@param SkillType SpellType
function UAutoTestHelperLib:CastSpell(WorldContext, SkillType) end
---@param Unit AActor
---@param Status boolean
function UAutoTestHelperLib:QAPauseBT(Unit, Status) end
---@param WorldContext UObject
---@param KillTarget AActor
function UAutoTestHelperLib:KillEnemy(WorldContext, KillTarget) end
---@param WorldContext UObject
---@param Enemy ABGUCharacterCS
---@param ReachRadius int32
---@return boolean
function UAutoTestHelperLib:RunToEnemy(WorldContext, Enemy, ReachRadius) end
---@param Btn UWidget
function UAutoTestHelperLib:ClickButton(Btn) end
---@param WorldContext UObject
function UAutoTestHelperLib:LightAttack(WorldContext) end
---@param WorldContext UObject
function UAutoTestHelperLib:HeavyAttack(WorldContext) end
---@param WorldContext UObject
function UAutoTestHelperLib:MouseGoBack(WorldContext) end
---@param Unit AActor
---@param Hp int32
function UAutoTestHelperLib:SetCurrentHp(Unit, Hp) end
---@param WorldContext UObject
---@param OwnerActor AActor
function UAutoTestHelperLib:RemoveGroupAI(WorldContext, OwnerActor) end
---@param WorldContext UObject
---@param TargetLocation FVector
---@param ReachRadius int32
---@return boolean
function UAutoTestHelperLib:RunToPosition(WorldContext, TargetLocation, ReachRadius) end
---@param WorldContext UObject
---@param ItemId int32
---@return int32
function UAutoTestHelperLib:HasItemNumber(WorldContext, ItemId) end
---@param ID int32
---@return FString
function UAutoTestHelperLib:ReadDataTable(ID) end
---@param WorldContext UObject
---@param AttackRadius int32
---@param EnemyUnit ABGUCharacterCS
---@param UnitBP FString
---@return boolean
function UAutoTestHelperLib:FindNearbyUnit(WorldContext, AttackRadius, EnemyUnit, UnitBP) end
---@param Unit AActor
---@return boolean
function UAutoTestHelperLib:IsUnitInBattle(Unit) end
---@param World UWorld
function UAutoTestHelperLib:GenShiXianFeng(World) end
---@param Enemy ABGUCharacterCS
---@return boolean
function UAutoTestHelperLib:CanUnitBeTarget(Enemy) end
---@param Unit AActor
---@param AttackNum int32
function UAutoTestHelperLib:SetPlayerAttack(Unit, AttackNum) end
---@param Unit AActor
---@param SkillID int32
---@param Duration float
function UAutoTestHelperLib:QADrawSkillRange(Unit, SkillID, Duration) end
---@param WorldContext UObject
---@param LockTarget AActor
function UAutoTestHelperLib:CameraLockTarget(WorldContext, LockTarget) end
---@param WorldContext UObject
function UAutoTestHelperLib:AutoMoveComplete(WorldContext) end
---@param WorldContext UObject
---@param SpellID int32
---@return boolean
function UAutoTestHelperLib:IsEquippingSpell(WorldContext, SpellID) end
---@param Unit AActor
---@return TArray<int32>
function UAutoTestHelperLib:GetUnitAllSkillID(Unit) end
---@param StringList TArray<FString>
---@return TArray<FString>
function UAutoTestHelperLib:QAStringArraySort(StringList) end
---@param Target AActor
---@return FString
function UAutoTestHelperLib:QAGetCurrentAMName(Target) end
---@param Widget UWidget
---@return boolean
function UAutoTestHelperLib:JudgeWidgetVisible(Widget) end
---@param Target AActor
---@return FString
function UAutoTestHelperLib:QAGetCurrentSkillID(Target) end
---@param WorldContext UObject
function UAutoTestHelperLib:GetTamerInViewCount(WorldContext) end
---@param WorldContext UObject
---@return ABGUCharacterCS
function UAutoTestHelperLib:GetPlayerTargetActor(WorldContext) end
---@param WorldContext UObject
---@param SequenceID int32
---@return boolean
function UAutoTestHelperLib:GetPlayingSequenceID(WorldContext, SequenceID) end
---@param WorldContext UObject
---@return boolean
function UAutoTestHelperLib:IsPlayingCameraMovie(WorldContext) end
---@param WorldContext UObject
---@param ActorName FString
---@param ActorLocation FVector
---@return boolean
function UAutoTestHelperLib:GetActorLocationByName(WorldContext, ActorName, ActorLocation) end
---@param WorldContext UObject
---@param Catelog FString
---@param Summary FString
---@param FileList TArray<FString>
function UAutoTestHelperLib:QAUploadPerformanceData(WorldContext, Catelog, Summary, FileList) end
---@param WorldContext UObject
---@param Choice FString
---@return boolean
function UAutoTestHelperLib:RebirthPointChoiceClick(WorldContext, Choice) end
---@param WorldContext UObject
---@param ActionName FString
---@param TriggerEvent ETriggerEvent
function UAutoTestHelperLib:AutoTestInjectInputEvent(WorldContext, ActionName, TriggerEvent) end


---@class UAutoTestLoggerLib : UBlueprintFunctionLibrary
UAutoTestLoggerLib = {}


---@class UAutoTest_AllUI : UAutoTest_Template
UAutoTest_AllUI = {}


---@class UAutoTest_BYS_Start : UAutoTest_Template
UAutoTest_BYS_Start = {}


---@class UAutoTest_BYS_Tanglang : UAutoTest_Template
UAutoTest_BYS_Tanglang = {}


---@class UAutoTest_BYS_Xiniu : UAutoTest_Template
UAutoTest_BYS_Xiniu = {}


---@class UAutoTest_BYS_Xuelu : UAutoTest_Template
UAutoTest_BYS_Xuelu = {}


---@class UAutoTest_BagUI : UAutoTest_Template
UAutoTest_BagUI = {}


---@class UAutoTest_BattleTrace : UAutoTest_Template
UAutoTest_BattleTrace = {}


---@class UAutoTest_BattleWithUnit : UAutoTest_Template
---@field TamerClassList TArray<TSubclassOf<ABUTamerActor>>
---@field StartIndex int32
UAutoTest_BattleWithUnit = {}

function UAutoTest_BattleWithUnit:GetTamersInFolder() end


---@class UAutoTest_BianShenCastAllSkill : UAutoTest_Template
---@field SkillIds TArray<int32>
---@field StartIndex int32
UAutoTest_BianShenCastAllSkill = {}



---@class UAutoTest_BulletTrace : UAutoTest_Template
UAutoTest_BulletTrace = {}


---@class UAutoTest_DingShenEffectCheckTool : UAutoTest_Template
---@field TamerClassList TArray<TSubclassOf<ABUTamerActor>>
---@field DistanceBetween int32
---@field StartIndex int32
UAutoTest_DingShenEffectCheckTool = {}

function UAutoTest_DingShenEffectCheckTool:GetTamersInFolder() end


---@class UAutoTest_ENDA_ShiZhongJing : UAutoTest_Template
UAutoTest_ENDA_ShiZhongJing = {}


---@class UAutoTest_ENDB_Fate : UAutoTest_Template
UAutoTest_ENDB_Fate = {}


---@class UAutoTest_EquipmentUI : UAutoTest_Template
UAutoTest_EquipmentUI = {}


---@class UAutoTest_ExportInfo : UAutoTest_Template
UAutoTest_ExportInfo = {}


---@class UAutoTest_HFM_Cave : UAutoTest_Template
UAutoTest_HFM_Cave = {}


---@class UAutoTest_HFM_FuZiShu : UAutoTest_Template
UAutoTest_HFM_FuZiShu = {}


---@class UAutoTest_HFM_HFDS : UAutoTest_Template
UAutoTest_HFM_HFDS = {}


---@class UAutoTest_HFM_HuStone : UAutoTest_Template
UAutoTest_HFM_HuStone = {}


---@class UAutoTest_HFM_HuangCun : UAutoTest_Template
UAutoTest_HFM_HuangCun = {}


---@class UAutoTest_HFM_SandSkiing : UAutoTest_Template
UAutoTest_HFM_SandSkiing = {}


---@class UAutoTest_HFM_ShaMenGang : UAutoTest_Template
UAutoTest_HFM_ShaMenGang = {}


---@class UAutoTest_HFM_ShiXianFeng : UAutoTest_Template
UAutoTest_HFM_ShiXianFeng = {}


---@class UAutoTest_HFM_Start : UAutoTest_Template
UAutoTest_HFM_Start = {}


---@class UAutoTest_HFM_StartSeqOnly : UAutoTest_Template
UAutoTest_HFM_StartSeqOnly = {}


---@class UAutoTest_HFS_Bamboo : UAutoTest_Template
UAutoTest_HFS_Bamboo = {}


---@class UAutoTest_HFS_FirstBattle : UAutoTest_Template
UAutoTest_HFS_FirstBattle = {}


---@class UAutoTest_HFS_Forest : UAutoTest_Template
UAutoTest_HFS_Forest = {}


---@class UAutoTest_HFS_GYCY : UAutoTest_Template
UAutoTest_HFS_GYCY = {}


---@class UAutoTest_HFS_GoUp : UAutoTest_Template
UAutoTest_HFS_GoUp = {}


---@class UAutoTest_HFS_HFDW : UAutoTest_Template
UAutoTest_HFS_HFDW = {}


---@class UAutoTest_HFS_NV_Niu : UAutoTest_Template
UAutoTest_HFS_NV_Niu = {}


---@class UAutoTest_HFS_NV_Waterfall : UAutoTest_Template
UAutoTest_HFS_NV_Waterfall = {}


---@class UAutoTest_HFS_NV_WoodDragon : UAutoTest_Template
UAutoTest_HFS_NV_WoodDragon = {}


---@class UAutoTest_HFS_Swamp : UAutoTest_Template
UAutoTest_HFS_Swamp = {}


---@class UAutoTest_HFS_Xiong : UAutoTest_Template
UAutoTest_HFS_Xiong = {}


---@class UAutoTest_HYS_AshForest : UAutoTest_Template
UAutoTest_HYS_AshForest = {}


---@class UAutoTest_HYS_FoxGuide : UAutoTest_Template
UAutoTest_HYS_FoxGuide = {}


---@class UAutoTest_HYS_GoUp : UAutoTest_Template
UAutoTest_HYS_GoUp = {}


---@class UAutoTest_HYS_HongHaiEr : UAutoTest_Template
UAutoTest_HYS_HongHaiEr = {}


---@class UAutoTest_HYS_LavaPavement : UAutoTest_Template
UAutoTest_HYS_LavaPavement = {}


---@class UAutoTest_HYS_LuoChaPalace : UAutoTest_Template
UAutoTest_HYS_LuoChaPalace = {}


---@class UAutoTest_HYS_RoundAbout : UAutoTest_Template
UAutoTest_HYS_RoundAbout = {}


---@class UAutoTest_HYS_Start : UAutoTest_Template
UAutoTest_HYS_Start = {}


---@class UAutoTest_HYS_StoneForest : UAutoTest_Template
UAutoTest_HYS_StoneForest = {}


---@class UAutoTest_IdleTrace : UAutoTest_Template
UAutoTest_IdleTrace = {}


---@class UAutoTest_LYS_BuddahInside : UAutoTest_Template
UAutoTest_LYS_BuddahInside = {}


---@class UAutoTest_LYS_BuddahOutside : UAutoTest_Template
UAutoTest_LYS_BuddahOutside = {}


---@class UAutoTest_LYS_HuangMei : UAutoTest_Template
UAutoTest_LYS_HuangMei = {}


---@class UAutoTest_LYS_LeiYinTemple : UAutoTest_Template
UAutoTest_LYS_LeiYinTemple = {}


---@class UAutoTest_LYS_OutsideTemple : UAutoTest_Template
UAutoTest_LYS_OutsideTemple = {}


---@class UAutoTest_LYS_QuietLake : UAutoTest_Template
UAutoTest_LYS_QuietLake = {}


---@class UAutoTest_LYS_Start : UAutoTest_Template
UAutoTest_LYS_Start = {}


---@class UAutoTest_LYS_StupasDungeon_1 : UAutoTest_Template
UAutoTest_LYS_StupasDungeon_1 = {}


---@class UAutoTest_LYS_StupasDungeon_3 : UAutoTest_Template
UAutoTest_LYS_StupasDungeon_3 = {}


---@class UAutoTest_LYS_Tortoise : UAutoTest_Template
UAutoTest_LYS_Tortoise = {}


---@class UAutoTest_MGD_Opening : UAutoTest_Template
UAutoTest_MGD_Opening = {}


---@class UAutoTest_NiagaraPerformance : UAutoTest_Template
---@field TestType GetTamerMethod
---@field SkillIDBlackList TArray<int32>
---@field TamerList UBGWDataAsset_TamerListConfig
---@field QuitEditorPerUnit boolean
---@field TamerString FString
UAutoTest_NiagaraPerformance = {}



---@class UAutoTest_NiagaraPerformanceTest : UAutoTest_Template
UAutoTest_NiagaraPerformanceTest = {}


---@class UAutoTest_PSD_BaJie : UAutoTest_Template
UAutoTest_PSD_BaJie = {}


---@class UAutoTest_PSD_BaiYanMoJun : UAutoTest_Template
UAutoTest_PSD_BaiYanMoJun = {}


---@class UAutoTest_PSD_ErCeng : UAutoTest_Template
UAutoTest_PSD_ErCeng = {}


---@class UAutoTest_PSD_HuangHuaGuan : UAutoTest_Template
UAutoTest_PSD_HuangHuaGuan = {}


---@class UAutoTest_PSD_SanCeng : UAutoTest_Template
UAutoTest_PSD_SanCeng = {}


---@class UAutoTest_PSD_StartVillage : UAutoTest_Template
UAutoTest_PSD_StartVillage = {}


---@class UAutoTest_PSD_YiCeng : UAutoTest_Template
UAutoTest_PSD_YiCeng = {}


---@class UAutoTest_PSD_YouYan : UAutoTest_Template
UAutoTest_PSD_YouYan = {}


---@class UAutoTest_PSD_ZiZhuEr : UAutoTest_Template
UAutoTest_PSD_ZiZhuEr = {}


---@class UAutoTest_PlaneMover : UAutoTest_Template
---@field StartPoints TMap<FString, FVector>
---@field HasMaxClampValue boolean
---@field MaxClampValue float
---@field HasMinClampValue boolean
---@field MinClampValue float
UAutoTest_PlaneMover = {}



---@class UAutoTest_PlayEverySequence : UAutoTest_Template
UAutoTest_PlayEverySequence = {}


---@class UAutoTest_PlayerCastAllSkill : UAutoTest_Template
---@field RoleDataConfigIDs TArray<int32>
---@field SkillIDBlackList TArray<int32>
---@field StartIndex int32
UAutoTest_PlayerCastAllSkill = {}



---@class UAutoTest_SandBag : UAutoTest_Template
UAutoTest_SandBag = {}


---@class UAutoTest_SingleTest : UAutoTest_Template
UAutoTest_SingleTest = {}


---@class UAutoTest_SpawnTrace : UAutoTest_Template
UAutoTest_SpawnTrace = {}


---@class UAutoTest_Start_Editor : UAutoTest_Template
UAutoTest_Start_Editor = {}


---@class UAutoTest_Template : UObject
UAutoTest_Template = {}

function UAutoTest_Template:RunTest() end
function UAutoTest_Template:StopTest() end
function UAutoTest_Template:SetupTest() end
---@param DeltaTime float
function UAutoTest_Template:ReceiveTick(DeltaTime) end
function UAutoTest_Template:ReceiveStartTest() end


---@class UAutoTest_UnitCastAllSkill : UAutoTest_Template
---@field TamerClassList TArray<TSubclassOf<ABUTamerActor>>
---@field SkillIDBlackList TArray<int32>
---@field DistanceBetween int32
---@field StartIndex int32
UAutoTest_UnitCastAllSkill = {}

function UAutoTest_UnitCastAllSkill:GetTamersInFolder() end


---@class UAutoTest_UnitDeadCheckTool : UAutoTest_Template
---@field TamerList UBGWDataAsset_TamerListConfig
---@field DistanceBetween int32
---@field StartIndex int32
---@field Buff int32
UAutoTest_UnitDeadCheckTool = {}



---@class UAutoTest_UnitDeadPhysicsCheckTool : UAutoTest_Template
---@field TamerList UBGWDataAsset_TamerListConfig
---@field DistanceBetween int32
---@field Configs TArray<FUnitDeadPhysicsConfig>
---@field StartIndex int32
UAutoTest_UnitDeadPhysicsCheckTool = {}



---@class UAutoTest_UnitPicTaker : UAutoTest_Template
---@field UnitClassList TArray<TSubclassOf<ABGUCharacter>>
---@field DistanceBetween int32
---@field StartIndex int32
UAutoTest_UnitPicTaker = {}

function UAutoTest_UnitPicTaker:GetUnitsInFolder() end


---@class UAutoTest_ZYS_Whole : UAutoTest_Template
UAutoTest_ZYS_Whole = {}


---@class UB1NetReplicationGraphConnectionCS : UB1NetReplicationGraphConnection
UB1NetReplicationGraphConnectionCS = {}

---@param Actor AActor
---@param Channel UActorChannel
function UB1NetReplicationGraphConnectionCS:NotifyActorChannelAddedCS(Actor, Channel) end
---@param Actor AActor
function UB1NetReplicationGraphConnectionCS:NotifyActorChannelRemovedCS(Actor) end
---@param Channel UActorChannel
---@param CloseReason int32
function UB1NetReplicationGraphConnectionCS:NotifyActorChannelCleanedUpCS(Channel, CloseReason) end


---@class UB1OnlineSessionCS : UB1OnlineSession
UB1OnlineSessionCS = {}

---@param World UWorld
---@param NetDriver UNetDriver
function UB1OnlineSessionCS:HandleDisconnectCS(World, NetDriver) end


---@class UB1ReplicationGraphCS : UB1ReplicationGraph
UB1ReplicationGraphCS = {}

---@param Actor AActor
function UB1ReplicationGraphCS:AddNetworkActorCS(Actor) end
---@param Actor AActor
function UB1ReplicationGraphCS:RemoveNetworkActorCS(Actor) end


---@class UB1ReplicationGraphForStandAloneHookCS : UB1ReplicationGraphCS
UB1ReplicationGraphForStandAloneHookCS = {}


---@class UB1ReplicationGraphNode_ClientAlwaysRelevant : UB1ReplicationGraphNode_CSBase
UB1ReplicationGraphNode_ClientAlwaysRelevant = {}

---@param Actor AActor
function UB1ReplicationGraphNode_ClientAlwaysRelevant:NotifyAddNetworkActorCS(Actor) end
---@param Actor AActor
---@param bWarnIfNotFound boolean
---@return boolean
function UB1ReplicationGraphNode_ClientAlwaysRelevant:NotifyRemoveNetworkActorCS(Actor, bWarnIfNotFound) end
---@param PlayerController APlayerController
function UB1ReplicationGraphNode_ClientAlwaysRelevant:GatherActorListsForConnectionCS(PlayerController) end


---@class UB1ReplicationGraphNode_PlayerRelatedActor : UB1ReplicationGraphNode_CSBase
UB1ReplicationGraphNode_PlayerRelatedActor = {}

---@param PlayerController APlayerController
function UB1ReplicationGraphNode_PlayerRelatedActor:GatherActorListsForConnectionCS(PlayerController) end


---@class UB1ReplicationGraphNode_TamerMonster : UB1ReplicationGraphNode_CSBase
UB1ReplicationGraphNode_TamerMonster = {}

function UB1ReplicationGraphNode_TamerMonster:PostServerReplicateActorCS() end
---@param PlayerController APlayerController
function UB1ReplicationGraphNode_TamerMonster:GatherActorListsForConnectionCS(PlayerController) end


---@class UB1ReplicationGraphOnline : UB1ReplicationGraphCS
UB1ReplicationGraphOnline = {}

---@param Actor AActor
function UB1ReplicationGraphOnline:AddNetworkActorCS(Actor) end
---@param Outer UObject
---@param OriginName FString
---@param Name FString
function UB1ReplicationGraphOnline:GSNetworkRemapPathCS(Outer, OriginName, Name) end
---@param Actor AActor
function UB1ReplicationGraphOnline:RemoveNetworkActorCS(Actor) end
---@param RepGraphConnection UNetReplicationGraphConnection
function UB1ReplicationGraphOnline:InitConnectionGraphNodesCS(RepGraphConnection) end
function UB1ReplicationGraphOnline:InitGlobalActorClassSettingsCS() end
---@param Controller APlayerController
---@param Actor AActor
---@param FuncAddr int64
---@return boolean
function UB1ReplicationGraphOnline:ShouldServerMultiCastRPCForPlayerCS(Controller, Actor, FuncAddr) end


---@class UB1X2_DispWorldDataComp : UBUS_ActorBaseDataComp
UB1X2_DispWorldDataComp = {}


---@class UB2D_DispLibFXActorCameraShakeData : UBGU_DispLibUComponentBase
---@field CameraShake TSubclassOf<UMatineeCameraShake>
---@field FirstDelayTime float
UB2D_DispLibFXActorCameraShakeData = {}



---@class UBADirectionDamage : UBasicActionBase
---@field ReqDirDamage UAIReqDirDamage
UBADirectionDamage = {}



---@class UBADirectionMove : UBasicActionBase
---@field ReqMoveToLoc UAIReqMoveToLoc
UBADirectionMove = {}



---@class UBAID_AssistStateCheck : UBAID_Base
---@field AssistState PartnerAssistState
UBAID_AssistStateCheck = {}



---@class UBAID_Base : UBTDecorator_USharpBase
UBAID_Base = {}


---@class UBAID_BulletNumCheck : UBAID_Base
---@field ProjectileIDFilter int32
---@field UperNumber float
---@field DestroyTimeFilter float
UBAID_BulletNumCheck = {}



---@class UBAID_CanTraceHitTarget : UBAID_Base
---@field TraceTypeQuery ETraceTypeQuery
---@field StartSocketName FName
---@field TargetSocketName FName
---@field TraceDistance float
---@field EnableDebug boolean
UBAID_CanTraceHitTarget = {}



---@class UBAID_CheckAssignTargetCondition : UBAID_Base
---@field CheckAssignTargetInfo FCheckAssignTargetInfo
UBAID_CheckAssignTargetCondition = {}



---@class UBAID_CheckAttackValid : UBAID_Base
UBAID_CheckAttackValid = {}


---@class UBAID_CheckBuffLayer : UBAID_Base
---@field isUpper boolean
---@field BuffID int32
---@field BuffLayer int32
---@field CheckTargetType int32
UBAID_CheckBuffLayer = {}



---@class UBAID_CheckBuffLayersFromBuffGroup : UBAID_Base
---@field BuffGroupID int32
---@field TotalLayerCount int32
UBAID_CheckBuffLayersFromBuffGroup = {}



---@class UBAID_CheckCacheSceneItem : UBAID_Base
UBAID_CheckCacheSceneItem = {}


---@class UBAID_CheckCanCastAnySkill : UBAID_Base
---@field Skills TArray<int32>
UBAID_CheckCanCastAnySkill = {}



---@class UBAID_CheckCanCastStalemateSkill : UBAID_Base
UBAID_CheckCanCastStalemateSkill = {}


---@class UBAID_CheckCanWanderInGroupAI : UBAID_Base
UBAID_CheckCanWanderInGroupAI = {}


---@class UBAID_CheckCurRamdomComboLength : UBAID_Base
---@field ComboLengthYouWant int32
---@field PreferCloser boolean
UBAID_CheckCurRamdomComboLength = {}



---@class UBAID_CheckCurTargetState : UBAID_Base
---@field UnitStateCheckList TArray<EBGUUnitState>
---@field SimpleStateCheckList TArray<EBGUSimpleState>
---@field UsePlayerForTarget boolean
UBAID_CheckCurTargetState = {}



---@class UBAID_CheckCurTargetType : UBAID_Base
---@field UnitIDList TArray<int32>
---@field UsePlayerForTarget boolean
UBAID_CheckCurTargetType = {}



---@class UBAID_CheckCurrentMoveMode : UBAID_Base
---@field ToCheckMoveMode EMovementMode
UBAID_CheckCurrentMoveMode = {}



---@class UBAID_CheckDistance : UBAID_Base
---@field CheckTarget EAICheckTarget
---@field CheckDistanceType EAICheckDistanceType
---@field Distance float
---@field PreferCloser boolean
UBAID_CheckDistance = {}



---@class UBAID_CheckEscapeWay : UBAID_Base
---@field EscapeWay EscapeWay
UBAID_CheckEscapeWay = {}



---@class UBAID_CheckFSMStateActive : UBAID_Base
---@field FsmState EBGUFSMStateName
UBAID_CheckFSMStateActive = {}



---@class UBAID_CheckFSMStateActive_Custom : UBAID_Base
---@field FSMStateTag FGameplayTag
UBAID_CheckFSMStateActive_Custom = {}



---@class UBAID_CheckFamilyTreeRootHasBuff : UBAID_Base
---@field BuffID int32
---@field IsReverseConidtion boolean
UBAID_CheckFamilyTreeRootHasBuff = {}



---@class UBAID_CheckHPIsLow : UBAID_Base
---@field HpLowPercent float
---@field bDoOnce boolean
UBAID_CheckHPIsLow = {}



---@class UBAID_CheckHasBuff : UBAID_Base
---@field BuffID int32
UBAID_CheckHasBuff = {}



---@class UBAID_CheckHasPointSetByRegisterID : UBAID_Base
---@field RegisterID int32
---@field PointMinNum int32
UBAID_CheckHasPointSetByRegisterID = {}



---@class UBAID_CheckInAngle : UBAID_Base
---@field CheckTarget EAICheckTarget
---@field LeftAngle float
---@field RightAngle float
---@field UseSocketDirection boolean
---@field DirectionBaseSocket FName
---@field ForwardSocket FName
UBAID_CheckInAngle = {}



---@class UBAID_CheckIsUnitActive : UBAID_Base
UBAID_CheckIsUnitActive = {}


---@class UBAID_CheckMasterCurrentHeavyAttackType : UBAID_Base
---@field CheckCurType AttackStyle
UBAID_CheckMasterCurrentHeavyAttackType = {}



---@class UBAID_CheckMasterEquipMagic : UBAID_Base
---@field ItemId int32
UBAID_CheckMasterEquipMagic = {}



---@class UBAID_CheckMasterHasTalent : UBAID_Base
---@field TalentID int32
UBAID_CheckMasterHasTalent = {}



---@class UBAID_CheckMaxComboValue : UBAID_Base
---@field CompareType ValueCompareType
---@field KeyValue int32
UBAID_CheckMaxComboValue = {}



---@class UBAID_CheckMoveValid : UBAID_Base
UBAID_CheckMoveValid = {}


---@class UBAID_CheckNearObstacle : UBAID_Base
---@field EscapeThreshold int32
UBAID_CheckNearObstacle = {}



---@class UBAID_CheckOwnerIsInBattleState : UBAID_Base
UBAID_CheckOwnerIsInBattleState = {}


---@class UBAID_CheckProbability : UBAID_Base
---@field Probability float
UBAID_CheckProbability = {}



---@class UBAID_CheckRootComponentSimulatingPhysics : UBAID_Base
UBAID_CheckRootComponentSimulatingPhysics = {}


---@class UBAID_CheckSceneItemAngleByTag : UBAID_Base
---@field BoneName FName
---@field SceneItemTag FName
---@field MinDistance int32
---@field MaxDistance int32
---@field AngleValue int32
UBAID_CheckSceneItemAngleByTag = {}



---@class UBAID_CheckSpeed : UBAID_Base
---@field CompareType ValueCompareType
---@field BasedSpeed float
UBAID_CheckSpeed = {}



---@class UBAID_CheckStalemateMoveTimeAbove : UBAID_Base
---@field TimeValue float
---@field bShowDebugLog boolean
UBAID_CheckStalemateMoveTimeAbove = {}



---@class UBAID_CheckSummonAmount : UBAID_Base
---@field SummonResIDFilter TArray<int32>
---@field OperationType ValueCompareOperationType
---@field CompareValue int32
UBAID_CheckSummonAmount = {}



---@class UBAID_CheckSummonBehaviorShouldUseSkill : UBAID_Base
UBAID_CheckSummonBehaviorShouldUseSkill = {}


---@class UBAID_CheckSurfaceType : UBAID_Base
---@field SurfaceType SceneItemSurfaceType
UBAID_CheckSurfaceType = {}



---@class UBAID_CheckSurpriseSkill : UBAID_Base
UBAID_CheckSurpriseSkill = {}


---@class UBAID_CheckTargetAttackTime : UBAID_Base
---@field Time float
---@field ConsiSelfIsLastAttacker boolean
UBAID_CheckTargetAttackTime = {}



---@class UBAID_CheckTargetFSMStateActive : UBAID_Base
---@field FsmState EBGUFSMStateName
UBAID_CheckTargetFSMStateActive = {}



---@class UBAID_CheckTargetHasBuff : UBAID_Base
---@field BuffID int32
UBAID_CheckTargetHasBuff = {}



---@class UBAID_CheckTargetInAngle : UBAID_Base
---@field LeftAngle float
---@field RightAngle float
---@field UseSocketDirection boolean
---@field DirectionBaseSocket FName
---@field ForwardSocket FName
UBAID_CheckTargetInAngle = {}



---@class UBAID_CheckTargetIsInPursuitRange : UBAID_Base
UBAID_CheckTargetIsInPursuitRange = {}


---@class UBAID_CheckUnitHasSimpleState : UBAID_Base
---@field UnitSimpleState EBGUSimpleState
---@field IsCheckTarget boolean
UBAID_CheckUnitHasSimpleState = {}



---@class UBAID_CheckUnitHasState : UBAID_Base
---@field UnitState EBGUUnitState
---@field IsCheckTarget boolean
UBAID_CheckUnitHasState = {}



---@class UBAID_CheckUnitInRange : UBAID_Base
---@field UnitResID int32
---@field CheckRange float
---@field CheckCount int32
---@field bLessOrEqual boolean
---@field bCheckUnitAlive boolean
UBAID_CheckUnitInRange = {}



---@class UBAID_CheckUpAxisAngle : UBAID_Base
---@field MinAngle float
---@field MaxAngle float
---@field UseSocketDirection boolean
---@field DirectionBaseSocket FName
---@field ForwardSocket FName
---@field UpSocket FName
UBAID_CheckUpAxisAngle = {}



---@class UBAID_CheckWatchTimeNotEnd : UBAID_Base
UBAID_CheckWatchTimeNotEnd = {}


---@class UBAID_CreateRequest : UBAID_Base
---@field RequiredFeatureList TArray<EAIAttentionFeatureType>
---@field InverseList TArray<boolean>
---@field AIRequestType EAIRequestType
---@field FeatureTestList TArray<PointTestType>
---@field FeatureCheckAngleTestList TArray<FCheckAngleTest>
---@field FeatureDistanceTest FDistanceTest
---@field RingPointGenerate FRingPointGenerate
---@field IsRandomPoint boolean
---@field PointGenBaseType PointGenBaseType
---@field PointTestList TArray<PointTestType>
---@field CheckAngleTestList TArray<FCheckAngleTest>
---@field DistanceTest FDistanceTest
UBAID_CreateRequest = {}



---@class UBAID_DistanceCheckTest : UBAID_Base
---@field CheckTarget EAICheckTarget
---@field CheckDistanceType EAICheckDistanceType
---@field Distance float
---@field PreferCloser boolean
UBAID_DistanceCheckTest = {}



---@class UBAID_EnvironmentChangeCheck : UBAID_Base
---@field SwitchSchedule float
UBAID_EnvironmentChangeCheck = {}



---@class UBAID_HasValidEQSTarget : UBAID_Base
UBAID_HasValidEQSTarget = {}


---@class UBAID_HasValidTarget : UBAID_Base
UBAID_HasValidTarget = {}


---@class UBAID_InitAI : UBAID_Base
---@field IsLoaded boolean
UBAID_InitAI = {}



---@class UBAID_InitThink : UBAID_Base
UBAID_InitThink = {}


---@class UBAID_SelfBeyondPursuitRange : UBAID_Base
UBAID_SelfBeyondPursuitRange = {}


---@class UBAID_TargetBeyondPursuitRange : UBAID_Base
UBAID_TargetBeyondPursuitRange = {}


---@class UBAIS_Base : UBTService_USharpBase
UBAIS_Base = {}


---@class UBAIS_StalemateTimeTick : UBAIS_Base
UBAIS_StalemateTimeTick = {}


---@class UBAIS_StdUnitAITick : UBAIS_Base
UBAIS_StdUnitAITick = {}


---@class UBAIS_SurroundObstacleTick : UBAIS_Base
---@field CheckObstacleEQSTemplate UEnvQuery
---@field CheckDistance float
---@field CheckPointNum int32
---@field CheckPointsWeightList TArray<FVector2D>
---@field EscapeWay EscapeWay
---@field OwnerCharacter ABGUCharacter
UBAIS_SurroundObstacleTick = {}

---@param MemberName FString
---@param PropertyName FString
function UBAIS_SurroundObstacleTick:OnPropertyChanged(MemberName, PropertyName) end


---@class UBAIS_WatchTimeTick : UBAIS_Base
UBAIS_WatchTimeTick = {}


---@class UBAIT_AddOrRemoveBuffToSelf : UBAIT_Base
---@field IsAdd boolean
---@field BuffID int32
---@field BuffDurationTime float
---@field BuffLayer int32
UBAIT_AddOrRemoveBuffToSelf = {}



---@class UBAIT_AdjustTransformBySpline : UBAIT_Base
---@field bHint boolean
---@field bShowDebug boolean
---@field SplineGuid FGameplayTag
---@field RotateType TransformBySplineRotateType
---@field AdjustTime float
UBAIT_AdjustTransformBySpline = {}



---@class UBAIT_Base : UBTTask_USharpBase
UBAIT_Base = {}


---@class UBAIT_BeginIdle : UBAIT_Base
UBAIT_BeginIdle = {}


---@class UBAIT_CalcComboSkillLength : UBAIT_Base
---@field ComboSkillNumInfo TArray<FComboSkillNumInfo>
UBAIT_CalcComboSkillLength = {}



---@class UBAIT_ChangeMMMode : UBAIT_Base
---@field MotionMatchingState State_MM
UBAIT_ChangeMMMode = {}



---@class UBAIT_ClearHasCastComboInfo : UBAIT_Base
UBAIT_ClearHasCastComboInfo = {}


---@class UBAIT_Combo : UBAIT_Base
---@field ComboTargetType ComboTargetType
---@field SkillSourceType ZatoichiSkillSourceType
---@field CanUpdateComboTargetWhenPursuit boolean
---@field PursuitInAllSkill boolean
---@field PursuitAnyWhere boolean
---@field ForceCastSkillAfterPursuitFailed boolean
---@field PursuitRangePos float
---@field SpeedRateType EAIMoveSpeedType
---@field MotionMatchingMoveMode State_MM
---@field MoveAIType EBGUMoveAIType
---@field MoveAcceptableRadiusType EBGUMoveAcceptableRadiusType
---@field BeginRotateAngle float
---@field IsUseSkillForTurn boolean
---@field IsUseSkillForMove boolean
---@field BeginMoveDistanceWhenUseSkill float
---@field CanCheckCastSkillDuringWholeComboWindow boolean
---@field EnableInterruptReduceCBNum boolean
---@field NeedTraceHitTargetBefore boolean
---@field EnableForceComboRelation boolean
---@field EnableComboCondition boolean
---@field TraceDistance float
---@field TraceTypeQuery ETraceTypeQuery
---@field IsGetTopRandomSkill boolean
---@field TopRandomSkillPercent int32
---@field SkillArray TArray<FComboSkill>
---@field IsGetAdvanceComboLength boolean
---@field ComboSkillNumInfo TArray<FComboSkillNumInfo>
---@field bCanBeForceAbort boolean
---@field bCanBeInterruptedByHRCounterattack boolean
---@field UseSocketDirection boolean
---@field DirectionBaseSocket FName
---@field ForwardSocket FName
---@field RightSocket FName
---@field SkillConfigMode EscapeSkillConfigMode
---@field SingleDirectionSkills TArray<int32>
---@field AvoidObstacleSectionNum int32
---@field SectionsStartAngle float
---@field IntervalAngle float
---@field AvoidObstacleSections TArray<FAvoidObstacleSection>
UBAIT_Combo = {}

---@return FString
function UBAIT_Combo:QACalcSkillArray() end
---@return TArray<FString>
function UBAIT_Combo:QACalcTrueComboArray() end
---@param MemberName FString
---@param PropertyName FString
function UBAIT_Combo:OnPropertyChanged(MemberName, PropertyName) end


---@class UBAIT_EQSRun : UBAIT_Base
---@field AcceptableRadius float
---@field IncludeSelfRadius boolean
---@field EQSTemplate UEnvQuery
---@field MotionMatchingState State_MM
---@field MoveAIType EBGUMoveAIType
---@field SpeedRateType EAIMoveSpeedType
---@field SpeedRateDistanceCurve UCurveFloat
---@field EnableRangeAcceptableRadius boolean
---@field MinAcceptableRadius float
---@field MaxAcceptableRadius float
---@field bEnableContinuousPathFinding boolean
---@field ContinuousPathFindingRadiusThreshold float
---@field bAutoCastTurnSkillIfNeeded boolean
---@field TurnSkillConfig FFGSTurnSkillConfig
---@field AutoUpdatePathTime float
---@field EnableLeisure boolean
---@field IntervalTime float
---@field LeisureList TArray<FFGSLeisureWithWeight>
---@field EnableDrawLineDebug boolean
UBAIT_EQSRun = {}



---@class UBAIT_EQSRunBeforeAtkTmp : UBAIT_Base
---@field ImmueStiff boolean
---@field NeedTraceHitTargetBefore boolean
---@field TraceTypeQuery ETraceTypeQuery
---@field AcceptableRadius float
---@field IncludeSelfRadius boolean
---@field EQSTemplate UEnvQuery
---@field MoveAIType EBGUMoveAIType
---@field SpeedRateType EAIMoveSpeedType
---@field EnableRangeAcceptableRadius boolean
---@field MinAcceptableRadius float
---@field MaxAcceptableRadius float
---@field AutoUpdatePathTime float
---@field IntervalTime float
---@field OwnerCharacter ACharacter
UBAIT_EQSRunBeforeAtkTmp = {}



---@class UBAIT_EQSTurnAround : UBAIT_Base
---@field PerferCloser boolean
---@field BeginRotateAngle float
---@field AcceptableRadius float
---@field EQSTemplate UEnvQuery
---@field MoveAIType EBGUMoveAIType
---@field SpeedRateType EAIMoveSpeedType
---@field AutoUpdatePathTime float
---@field EnableDebug boolean
---@field OwnerCharacter ACharacter
UBAIT_EQSTurnAround = {}



---@class UBAIT_EnableFightBack : UBAIT_Base
---@field IsEnableFightBack boolean
UBAIT_EnableFightBack = {}



---@class UBAIT_ExecuteBasicAction : UBAIT_Base
---@field BaseActionType EAIBasicActionType
UBAIT_ExecuteBasicAction = {}



---@class UBAIT_ExitGroupAI : UBAIT_Base
UBAIT_ExitGroupAI = {}


---@class UBAIT_FSMEvent : UBAIT_Base
---@field EventName EBGUFSMEventName
UBAIT_FSMEvent = {}



---@class UBAIT_FSMEvent_Custom : UBAIT_Base
---@field Event FGameplayTag
UBAIT_FSMEvent_Custom = {}



---@class UBAIT_FindEscapePoint : UBAIT_Base
---@field QueryEscapeDirectionTemplate UEnvQuery
---@field MinCircleDistance float
---@field MaxCircleDistance float
---@field OwnerCharacter ABGUCharacter
---@field AutoGenPointTag FName
UBAIT_FindEscapePoint = {}



---@class UBAIT_FlyMoveTo : UBAIT_Base
---@field BTTargetType EBTTargetType
---@field MinimumProximityRequired float
---@field QueryParams FDoNNavigationQueryParams
---@field DebugParams FDoNNavigationDebugParams
---@field bVisualizePawnAsVoxels boolean
---@field bTeleportToDestinationUponFailure boolean
UBAIT_FlyMoveTo = {}

---@param Data FDoNNavigationQueryData
function UBAIT_FlyMoveTo:Pathfinding_OnFinish(Data) end
---@param Data FDonNavigationDynamicCollisionPayload
function UBAIT_FlyMoveTo:Pathfinding_OnDynamicCollisionAlert(Data) end


---@class UBAIT_FollowMaster : UBAIT_Base
---@field AcceptableRaidus float
---@field IncludeSelfRadius boolean
---@field IncludeTargetRadius boolean
---@field MoveAIType EBGUMoveAIType
---@field SpeedRateType EAIMoveSpeedType
UBAIT_FollowMaster = {}



---@class UBAIT_FollowPlayer : UBAIT_Base
---@field AcceptableRaidus float
---@field IncludeSelfRadius boolean
---@field IncludeTargetRadius boolean
---@field MoveAIType EBGUMoveAIType
---@field SpeedRateType EAIMoveSpeedType
UBAIT_FollowPlayer = {}



---@class UBAIT_GenAndCachePointSet : UBAIT_Base
---@field GenType PointsGenType
---@field GenExtParam FPointsGenExtParam
---@field RegisterID int32
UBAIT_GenAndCachePointSet = {}



---@class UBAIT_HandleAiConversation : UBAIT_Base
---@field ConversationContentIDList TArray<int32>
UBAIT_HandleAiConversation = {}



---@class UBAIT_HandleBattleMessage : UBAIT_Base
---@field BattleMessage FGameplayTag
UBAIT_HandleBattleMessage = {}



---@class UBAIT_MontageRootMotionMove : UBAIT_Base
---@field ScaleRate float
---@field MoveMontage UAnimMontage
---@field BK_Target FBlackboardKeySelector
UBAIT_MontageRootMotionMove = {}



---@class UBAIT_MoveTo : UBAIT_Base
---@field MaxMoveTime float
---@field AcceptableRadius float
---@field IncludeSelfRadius boolean
---@field IncludeTargetRadius boolean
---@field MotionMatchingState State_MM
---@field BTTargetType EBTTargetType
---@field MoveAIType EBGUMoveAIType
---@field SpeedRateType EAIMoveSpeedType
---@field SpeedRateDistanceCurve UCurveFloat
---@field EnableRangeAcceptableRadius boolean
---@field MinAcceptableRadius float
---@field MaxAcceptableRadius float
UBAIT_MoveTo = {}



---@class UBAIT_MoveToEnterBattlePos : UBAIT_Base
---@field AcceptableRadius float
---@field IncludeSelfRadius boolean
---@field IncludeTargetRadius boolean
---@field MoveAIType EBGUMoveAIType
---@field SpeedRateType EAIMoveSpeedType
---@field SpeedRateDistanceCurve UCurveFloat
---@field EnableRangeAcceptableRadius boolean
---@field MinAcceptableRadius float
---@field MaxAcceptableRadius float
---@field EnableDebug boolean
UBAIT_MoveToEnterBattlePos = {}



---@class UBAIT_MoveToOnWallAndCell : UBAIT_Base
---@field AcceptableRadius float
---@field IncludeSelfRadius boolean
---@field TargetPointTag FName
---@field SpeedRateType EAIMoveSpeedType
---@field turnSpeed float
---@field EnableRangeAcceptableRadius boolean
---@field MinAcceptableRadius float
---@field MaxAcceptableRadius float
---@field EnableDebug boolean
UBAIT_MoveToOnWallAndCell = {}



---@class UBAIT_MoveToPerceivedTarget : UBAIT_Base
---@field AcceptableRadius float
UBAIT_MoveToPerceivedTarget = {}



---@class UBAIT_MoveToSceneItemAndCastSkill : UBAIT_Base
---@field BeginRotateAngle float
---@field IsUseSkillForTurn boolean
---@field MoveToSceneItemCastSkill int32
---@field EnableRetryAimToSceneItem boolean
---@field RetryAimToSceneItemLimitTime int32
---@field MoveToBuff int32
---@field MoveToBuffDuration float
---@field SignatrueBuff int32
---@field MoveToAllowOffset float
UBAIT_MoveToSceneItemAndCastSkill = {}



---@class UBAIT_RegisterAIElem : UBAIT_Base
---@field ElemID int32
---@field ElemType EAIElemType
---@field Score int32
UBAIT_RegisterAIElem = {}



---@class UBAIT_RemoveCacheSceneItem : UBAIT_Base
UBAIT_RemoveCacheSceneItem = {}


---@class UBAIT_ResetEQSTarget : UBAIT_Base
UBAIT_ResetEQSTarget = {}


---@class UBAIT_ResetSceneItem : UBAIT_Base
---@field SceneActorTags TArray<FName>
UBAIT_ResetSceneItem = {}



---@class UBAIT_ResetStalemateMoveTime : UBAIT_Base
UBAIT_ResetStalemateMoveTime = {}


---@class UBAIT_ReturnHome : UBAIT_Base
UBAIT_ReturnHome = {}


---@class UBAIT_RunAway : UBAIT_Base
---@field RestRadius float
---@field RestTime float
---@field RestTimeInterval float
---@field MoveTimeInterval float
---@field LifeTime float
---@field MoveToTargetPoint boolean
---@field ToTargetPoint FVector
---@field AchieveLifeTime float
---@field AcceptableRadius float
---@field IncludeSelfRadius boolean
---@field SpeedRateType EAIMoveSpeedType
---@field MoveAIType EBGUMoveAIType
UBAIT_RunAway = {}



---@class UBAIT_SelectTargetByEQS : UBAIT_Base
---@field EQSTemplate UEnvQuery
---@field IsSetTarget boolean
UBAIT_SelectTargetByEQS = {}



---@class UBAIT_SetBossWatchTime : UBAIT_Base
---@field WatchTime float
---@field bEnableDebugLog boolean
UBAIT_SetBossWatchTime = {}



---@class UBAIT_SetBossWatchTimeInRange : UBAIT_Base
---@field WatchTimeMIN float
---@field WatchTimeMAX float
---@field bEnableDebugLog boolean
UBAIT_SetBossWatchTimeInRange = {}



---@class UBAIT_SetMaxComboValue : UBAIT_Base
---@field ComboNumMin int32
---@field ComboNumMax int32
---@field bEnableDebugLog boolean
UBAIT_SetMaxComboValue = {}



---@class UBAIT_SetSpeedRate : UBAIT_Base
---@field NewSpeedRate float
UBAIT_SetSpeedRate = {}



---@class UBAIT_SetUnitSimpleState : UBAIT_Base
---@field UnitSimpleState EBGUSimpleState
---@field IsRemove boolean
UBAIT_SetUnitSimpleState = {}



---@class UBAIT_ShieldDefence : UBAIT_Base
---@field IsShieldUp boolean
UBAIT_ShieldDefence = {}



---@class UBAIT_SpiderMoveTo : UBAIT_Base
---@field MaxMoveTime float
---@field AcceptableRadius float
---@field IncludeSelfRadius boolean
---@field IncludeTargetRadius boolean
---@field BTTargetType EBTTargetType
---@field TargetPositionType SpiderNavPositionType
---@field SpeedRateType EAIMoveSpeedType
UBAIT_SpiderMoveTo = {}



---@class UBAIT_StandAndFace : UBAIT_Base
UBAIT_StandAndFace = {}


---@class UBAIT_StopMoveAndWait : UBAIT_Base
---@field WaitTime float
UBAIT_StopMoveAndWait = {}



---@class UBAIT_SummonBehaviorUseSkill : UBAIT_Base
UBAIT_SummonBehaviorUseSkill = {}


---@class UBAIT_SwitchAttackAndWander : UBAIT_Base
---@field SwitchBattleFSMState SwitchBattleFSMState
---@field MinWanderTime float
---@field MaxWanderTime float
---@field MinComboNum int32
---@field MaxComboNum int32
UBAIT_SwitchAttackAndWander = {}

---@param MemberName FString
---@param PropertyName FString
function UBAIT_SwitchAttackAndWander:OnPropertyChanged(MemberName, PropertyName) end


---@class UBAIT_TeleportByEQS : UBAIT_Base
---@field EQSTemplate UEnvQuery
---@field IsRandom boolean
---@field TurnRotationType ChangeTargetType
UBAIT_TeleportByEQS = {}



---@class UBAIT_TriggerEffectByID : UBAIT_Base
---@field EffectID int32
UBAIT_TriggerEffectByID = {}



---@class UBAIT_TryFindSceneItem : UBAIT_Base
---@field SceneActorTags TArray<FName>
---@field FindSceneItemWay FindSceneItemWay
---@field DistanceWeight float
---@field AngleWeight float
---@field LineTraceWeight float
---@field NeedRemoveCurrentCatch boolean
---@field EnableSearchDistanceScope boolean
---@field MinSearchDistance float
---@field MaxSearchDistance float
---@field EnableSearchAngleRequirement boolean
---@field RequiredMaxSearchAngle float
UBAIT_TryFindSceneItem = {}



---@class UBAIT_TurnToTarget : UBAIT_Base
---@field BTTargetType EBTTargetType
---@field BeginRotateAngle float
---@field IsUseSkillForTurn boolean
UBAIT_TurnToTarget = {}



---@class UBAIT_UseRandomSkillWithID : UBAIT_Base
---@field SkillID TArray<int32>
---@field IsEndSkill boolean
---@field EnableDebug boolean
UBAIT_UseRandomSkillWithID = {}



---@class UBAIT_UseSkillWithID : UBAIT_Base
---@field SkillIDSource SkillIDSource
---@field SkillID int32
---@field IsEndSkill boolean
---@field EnableDebug boolean
UBAIT_UseSkillWithID = {}



---@class UBAIT_WanderRun : UBAIT_Base
---@field EQSTemplate UEnvQuery
---@field AcceptableRadius float
---@field MoveAIType EBGUMoveAIType
---@field OwnerCharacter ACharacter
UBAIT_WanderRun = {}



---@class UBAMoveSkill : UBasicActionBase
---@field ReqMoveSkill UAIReqMoveSkill
UBAMoveSkill = {}



---@class UBANSM_AttackRotation : UBANSM_MarkFoot
---@field MinFootOnGroundCanRotate int32
---@field MaxFootOnGroundCanRotate int32
UBANSM_AttackRotation = {}

---@param AnimBase UAnimSequenceBase
---@param CurTime float
---@return boolean
function UBANSM_AttackRotation:CheckState(AnimBase, CurTime) end


---@class UBANSM_AttackState : UBANSM_Base
UBANSM_AttackState = {}

---@param AnimBase UAnimSequenceBase
---@param CurTime float
---@return boolean
function UBANSM_AttackState:CheckState(AnimBase, CurTime) end


---@class UBANSM_Base : UObject
---@field NotifyStateClass TSubclassOf<UAnimNotifyState>
---@field NotifyClass TSubclassOf<UAnimNotify>
---@field NotifyTrackName FName
---@field NotifyTrackName_SweepCheck FName
---@field NotifyTrackName_Socket FName
---@field AWTag_GenerateBySweepCheck FName
---@field AWTag_GenerateWithSocket FName
UBANSM_Base = {}

---@param AnimSeq UAnimSequenceBase
---@param StartTime float
function UBANSM_Base:MarkNotify(AnimSeq, StartTime) end
---@param AnimBase UAnimSequenceBase
---@param CurTime float
---@return boolean
function UBANSM_Base:CheckState(AnimBase, CurTime) end
function UBANSM_Base:GenerateNotify() end
---@param AnimSeq UAnimSequenceBase
---@param StartTime float
---@param EndTime float
function UBANSM_Base:MarkNotifyState(AnimSeq, StartTime, EndTime) end
function UBANSM_Base:GenerateNotifyState() end
---@param AnimMontage UAnimMontage
---@param PreTimeSeconds float
---@param PostTimeSeconds float
function UBANSM_Base:RefreshAttackWarning(AnimMontage, PreTimeSeconds, PostTimeSeconds) end
---@param AnimMontage UAnimMontage
---@param CheckSphereRadiusIncrease float
function UBANSM_Base:AddSweepCheckAttackWarning(AnimMontage, CheckSphereRadiusIncrease) end
---@param AnimMontage UAnimMontage
---@param SocketNum int32
---@param SocketRadius float
---@param LengthFrame int32
function UBANSM_Base:AddExtraSocketAttackWarning(AnimMontage, SocketNum, SocketRadius, LengthFrame) end
---@param AnimMontage UAnimMontage
---@param LengthFrame int32
function UBANSM_Base:UpdateExtraSocketAttackWarning(AnimMontage, LengthFrame) end
---@return UClass
function UBANSM_Base:GetSupportedClass() end
---@param AnimMontage UAnimMontage
---@param _SocketName FName
---@param SweepRadius float
---@param PointBetweenMin float
---@param SampleStep float
function UBANSM_Base:AddPlayerWaterSplash_BySweepCheck(AnimMontage, _SocketName, SweepRadius, PointBetweenMin, SampleStep) end
---@param AnimMontage UAnimMontage
function UBANSM_Base:ClearGeneratedAttackWarningsByTrack(AnimMontage) end
---@param AnimMontage UAnimMontage
---@param PreTimeSeconds float
---@param PostTimeSeconds float
---@param CheckSphereRadius float
---@param AddSocketNumPerAnim int32
function UBANSM_Base:AddPreciseDodgeAttackWarningAndSocket(AnimMontage, PreTimeSeconds, PostTimeSeconds, CheckSphereRadius, AddSocketNumPerAnim) end


---@class UBANSM_ComboWindow : UBANSM_Base
UBANSM_ComboWindow = {}

---@param AnimBase UAnimSequenceBase
---@param CurTime float
---@return boolean
function UBANSM_ComboWindow:CheckState(AnimBase, CurTime) end


---@class UBANSM_MarkFoot : UBANSM_Base
---@field FootNames TArray<FName>
---@field SlotName FName
---@field DistTolerance float
UBANSM_MarkFoot = {}

---@param AnimBase UAnimSequenceBase
---@param CurTime float
---@return boolean
function UBANSM_MarkFoot:CheckState(AnimBase, CurTime) end


---@class UBANS_AdjustTransformBySpline : UBANS_GSBase
---@field bShowDebug boolean
---@field SplineGuid FGameplayTag
---@field RotateType TransformBySplineRotateType
UBANS_AdjustTransformBySpline = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_AdjustTransformBySpline:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_AdjustTransformBySpline:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_AdjustTransformBySpline:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_ChangeAimOffset : UBANS_GSBase
---@field bIsDefaultAO boolean
---@field AimOffset UAimOffsetBlendSpace
UBANS_ChangeAimOffset = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_ChangeAimOffset:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_ChangeAimOffset:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_CostAttrByChargeLevel : UBANS_GSBase
---@field Config TMap<int32, FBGUCostAttrInfo>
UBANS_CostAttrByChargeLevel = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_CostAttrByChargeLevel:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_DispLibApplyWindSource : UBANS_GSBase
---@field EditorActive boolean
---@field EditorPlayActive boolean
---@field EventName FName
---@field PauseEventNames TArray<FName>
---@field SocketName FName
---@field SocketLocalOffset FVector
---@field TriggerProbability float
---@field Radius FBUC_DispLibUtil_DBCAdvProcessScalar
---@field VelocityThreshold float
---@field BaseIntensity FBUC_DispLibUtil_DBCAdvProcessScalar
---@field ScaleVelocityIntensity float
---@field DistanceDamplingRate float
---@field WindMotorMode DispLibDBCWindMotorMode
---@field RangeAxis DispLibDBCAxisMode
---@field RangeAxisLocalRotation FVector
---@field RangeMask float
---@field VelocityDir DispLibDBCAxisMode
---@field VelocityDirLocalRotation FVector
---@field ScaleSecondVelocity FBUC_DispLibUtil_DBCAdvProcessScalar
---@field DBC_IdentityID int32
---@field LastFrameSocketPosWS FVector
---@field WindType int32
UBANS_DispLibApplyWindSource = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_DispLibApplyWindSource:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_DispLibApplyWindSource:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@param MeshComp USkeletalMeshComponent
---@param Animation UAnimSequenceBase
---@param FrameDeltaTime float
---@param EventReference FAnimNotifyEventReference
---@return boolean
function UBANS_DispLibApplyWindSource:Received_NotifyTick(MeshComp, Animation, FrameDeltaTime, EventReference) end


---@class UBANS_DispLibTimedModifyMPC : UBANS_GSBase
---@field MPC UMaterialParameterCollection
---@field DelayTimeAfterStop float
---@field SetScalarParam TArray<FBUC_DispLibUtil_DBCAdvProcessScalarParam>
---@field SetFLinearColorParam TArray<FBUC_DispLibUtil_DBCAdvProcessFLinearColorParam>
---@field SetPCurveScalarParam TArray<FBUC_DispLibUtil_DBCPCurveScalarParam>
---@field SetPCurveFLinearColorParam TArray<FBUC_DispLibUtil_DBCPCurveColorParam>
---@field PausePriority int32
---@field EndStagePriority int32
---@field ModMPCPriority int32
---@field ModMPCEndStagePriority int32
UBANS_DispLibTimedModifyMPC = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_DispLibTimedModifyMPC:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_DispLibTimedModifyMPC:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_DispLibTimedModifyMaterial : UBANS_GSBase
---@field EditorActive boolean
---@field FilterMode FBUC_DispLibDBC_MaterialEffectTargetInfo
---@field Delay float
---@field DelayTimeAfterStop float
---@field Template UMaterialInterface
---@field InheriParamsMode DispLibMaterialParamsInheritMode
---@field InheritScalarParam TArray<FName>
---@field InheritFLinearColorParam TArray<FName>
---@field InheritTextureParam TArray<FName>
---@field SetScalarParam TArray<FBUC_DispLibUtil_DBCAdvProcessScalarMatLayerParam>
---@field SetFLinearColorParam TArray<FBUC_DispLibUtil_DBCAdvProcessFLinearColorMatLayerParam>
---@field SetTextureParam TArray<FBUC_DispLibUtil_DBCTextureMatLayerParam>
---@field SetPCurveScalarParam TArray<FBUC_DispLibUtil_DBCPCurveScalarMatLayerParam>
---@field SetPCurveFLinearColorParam TArray<FBUC_DispLibUtil_DBCPCurveColorMatLayerParam>
---@field PausePriority int32
---@field EndStagePriority int32
---@field ModMatPriority int32
---@field ModMatEndStagePriority int32
UBANS_DispLibTimedModifyMaterial = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_DispLibTimedModifyMaterial:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_DispLibTimedModifyMaterial:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_FBIK_StandBar : UBANS_GSBase
UBANS_FBIK_StandBar = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_FBIK_StandBar:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_FBIK_StandBar:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_FBIK_StandBar:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_FloatingHitState : UBANS_GSBase
UBANS_FloatingHitState = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_FloatingHitState:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSAISkillFeature : UBANS_GSBase
---@field DurationTime float
---@field IsUseNotifyTime boolean
---@field SectorParam FSectorParam
---@field RectParam FRectParam
UBANS_GSAISkillFeature = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAISkillFeature:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSAMCurveMove : UBANS_GSBase
---@field MoveCurveXAsix UCurveFloat
---@field MoveCurveZAsix UCurveFloat
---@field MoveCurveType EBGUMoveCurveType
---@field bShouldClearVelocityOnEnd boolean
---@field NotUseWhenHaveTarget boolean
---@field UseBeHitDir boolean
---@field UseAttractionDir boolean
---@field UseForwarXDir boolean
---@field UseTargetBaseDisScale boolean
---@field TargetBaseDisScaleOffset float
---@field bAutoResetMovementMode boolean
---@field CliffFallCheckLength float
UBANS_GSAMCurveMove = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSAMCurveMove:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAMCurveMove:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSAbortWindow : UBANS_GSBase
UBANS_GSAbortWindow = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAbortWindow:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSAddBuff : UBANS_GSBase
---@field BuffID EBPBuffID
---@field BuffLayer int32
---@field UseBuffDescDuration boolean
UBANS_GSAddBuff = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSAddBuff:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSAddBuff:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAddBuff:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSAddBuffByID : UBANS_GSBase
---@field BuffID int32
---@field BuffLayer int32
---@field UseBuffDescDuration boolean
UBANS_GSAddBuffByID = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSAddBuffByID:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSAddBuffByID:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAddBuffByID:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@param Actor AActor
function UBANS_GSAddBuffByID:GSValidateInputCS(Actor) end


---@class UBANS_GSAddPostProcessMat : UBANS_GSBase
---@field PostProcessMatSetting UBGWDataAsset_PostProcessMatSetting
UBANS_GSAddPostProcessMat = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSAddPostProcessMat:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAddPostProcessMat:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSAimOffsetBlendOutToBlendIn : UBANS_GSBase
---@field BlendOutTime float
---@field BlendInTime float
UBANS_GSAimOffsetBlendOutToBlendIn = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSAimOffsetBlendOutToBlendIn:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAimOffsetBlendOutToBlendIn:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSAlignAttackToSlope : UBANS_GSBase
---@field AlignType CharacterSlopeAlignType
UBANS_GSAlignAttackToSlope = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSAlignAttackToSlope:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSAlignAttackToSlope:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAlignAttackToSlope:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSAttachDropItemToSocket : UBANS_GSBase
---@field ActorTag FName
---@field SocketName FName
---@field AttachmentLocationRule EAttachmentRule
---@field AttachmentRotationRule EAttachmentRule
---@field AttachmentScaleRule EAttachmentRule
---@field ScaleUseCurve boolean
---@field ScaleCurve UCurveVector
---@field CallBPFunc boolean
---@field CallBPFloatParam float
---@field TriggerEffect boolean
---@field TriggerEffectDelay float
---@field InteractItem ABGUDropItemActorCS
UBANS_GSAttachDropItemToSocket = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSAttachDropItemToSocket:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAttachDropItemToSocket:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSAttachEquipCompToSocket : UBANS_GSBase
---@field EquipPosition EquipPosition
---@field AttachSocketName FName
UBANS_GSAttachEquipCompToSocket = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSAttachEquipCompToSocket:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAttachEquipCompToSocket:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSAttackIK : UBANS_GSBase
---@field BlendInTime float
---@field BlendOutTime float
---@field AttackReferencePos FVector
---@field TouchIKType TouchIKType
---@field OffsetRangeMin FVector
---@field OffsetRangeMax FVector
---@field bDrawDebugRange boolean
---@field DebugCapsuleThickness float
---@field DebugBoxThickness float
---@field bUseFullBodyIK boolean
---@field AttackIKType AttackIKType
---@field AttackIKBonePairList TArray<FAttackIKBonePairs>
---@field FishSpikeJumpType FishSpikeJumpType
---@field FishSpikeDistance float
---@field JumpMax float
---@field DebugFishSpikeEnable boolean
---@field BoneScaleEnable boolean
---@field BoneScaleData FAttackIKBoneScale
UBANS_GSAttackIK = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSAttackIK:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSAttackIK:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAttackIK:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSAttackIKCancle : UBANS_GSBase
---@field DisableIK boolean
---@field ShowDebug boolean
UBANS_GSAttackIKCancle = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSAttackIKCancle:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSAttackIKCancle:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAttackIKCancle:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSAttackRangeOffset : UBANS_GSBase
---@field EnablePitch boolean
---@field PitchMin float
---@field PitchMax float
---@field AimSocketName FName
---@field AnimSequence UAnimSequence
---@field BaseAnimSequencePosition float
---@field BasePosition_Local FVector
---@field BlendInTime float
---@field BlendOutTime float
UBANS_GSAttackRangeOffset = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSAttackRangeOffset:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSAttackRangeOffset:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAttackRangeOffset:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSAttackRotation : UBANS_GSBase
---@field IsRotateTraceCurrentTarget boolean
---@field IsRotateTraceSceneItem boolean
---@field NeedFindSceneItem boolean
---@field SceneActorTags TArray<FName>
---@field MinDistance float
---@field MaxDistance float
---@field FindSceneItemWay FindSceneItemWay
---@field Angle float
---@field NeedRemoveCurrentCatch boolean
---@field IsRotateTraceRegisteredPointCache boolean
---@field OverlayRotateTraceTargetType ChangeTargetType
---@field PointsRegisterID int32
---@field RotateTraceSocketName FString
---@field RotateSpeed float
---@field RotateDirection RotateDirection
---@field MaxRotateAngle float
---@field bStillRotateWhenAboveMaxRotateAngle boolean
---@field RotateDeflectionAngle float
---@field DeadzoneAngle float
---@field FootType EBUHandFootType
---@field IsRotateAroundLoc boolean
---@field EnableDebug boolean
---@field IsNeedForceRotateToSceneItemInEnd boolean
UBANS_GSAttackRotation = {}

---@return boolean
function UBANS_GSAttackRotation:MarkDirty() end
---@param NotifyParam FUStGSNotifyParam
function UBANS_GSAttackRotation:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAttackRotation:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@return boolean
function UBANS_GSAttackRotation:GSAllowCrossSection() end
---@param OwnerChar ABGUCharacter
---@param RemainingDuration float
function UBANS_GSAttackRotation:GSOnSectionManuallyChanged(OwnerChar, RemainingDuration) end


---@class UBANS_GSAttackRotationForUpperBody : UBANS_GSBase
---@field TargetType EBTTargetType
UBANS_GSAttackRotationForUpperBody = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSAttackRotationForUpperBody:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAttackRotationForUpperBody:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSAttackState : UBANS_GSBase
---@field EnableMove boolean
---@field KeepMMRunning boolean
UBANS_GSAttackState = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSAttackState:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAttackState:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@return boolean
function UBANS_GSAttackState:GSAllowCrossSection() end
---@param OwnerChar ABGUCharacter
---@param RemainingDuration float
function UBANS_GSAttackState:GSOnSectionManuallyChanged(OwnerChar, RemainingDuration) end


---@class UBANS_GSAttackWarnning : UBANS_GSBase
---@field HitActionDir HitActionDir
---@field HitLevel int32
---@field WeaponIndex int32
---@field AttackWarnningCheckShape TArray<FUStCheckShape>
---@field IsRenderDebugShape boolean
---@field AttackWarnningFixedLocalOffset FVector
---@field ResultFilterType ESweepCheckHitFilterType
---@field Tags TArray<FName>
---@field AttackWarningGroupID int32
UBANS_GSAttackWarnning = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSAttackWarnning:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSAttackWarnning:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAttackWarnning:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSAutoCheckBlock : UBANS_GSBase
---@field BlockInfoConfig UBGWDataAsset_BlockInfoConfig
---@field TriggerResetBlockCounterWhenEnd boolean
UBANS_GSAutoCheckBlock = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSAutoCheckBlock:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSAutoCheckBlock:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSB1TimedPlayNiagaraFX : UBANS_GSBase
---@field Template TSoftObjectPtr<UNiagaraSystem>
---@field SocketName FName
---@field LocationOffset FVector
---@field RotationOffset FRotator
---@field Scale FVector
---@field ignoreRootBoneScale boolean
---@field destroyAtEnd boolean
---@field customParams TArray<FGSNiagaraSysParam>
---@field TranslucentSortPriority int32
---@field AddTagForSearch FName
UBANS_GSB1TimedPlayNiagaraFX = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSB1TimedPlayNiagaraFX:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSB1TimedPlayNiagaraFX:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@return TArray<FSoftObjectPath>
function UBANS_GSB1TimedPlayNiagaraFX:GetSoftReferences() end


---@class UBANS_GSBase : UAnimNotifyState_GSBase
UBANS_GSBase = {}

---@param Actor AActor
function UBANS_GSBase:GSValidateInputCS(Actor) end
---@return TArray<FSoftObjectPath>
function UBANS_GSBase:GetSoftReferences() end
---@param NotifyParam FUStGSNotifyParam
---@return int32
function UBANS_GSBase:GSNotifyDebugPreEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@return int32
function UBANS_GSBase:GSNotifyDebugPostEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@return int32
function UBANS_GSBase:GSNotifyDebugPreTickCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@return int32
function UBANS_GSBase:GSNotifyDebugPreBeginCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@return int32
function UBANS_GSBase:GSNotifyDebugPostTickCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@return int32
function UBANS_GSBase:GSNotifyDebugPostBeginCS(NotifyParam) end


---@class UBANS_GSBlendPhysic : UBANS_GSBase
---@field PhysicBlendInfoArray TArray<FPhysicBlendInfo>
---@field EnableSimulate boolean
UBANS_GSBlendPhysic = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSBlendPhysic:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSBlendPhysicForDeath : UBANS_GSBase
---@field EnableWeaponAutoSwitchPhysic boolean
UBANS_GSBlendPhysicForDeath = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSBlendPhysicForDeath:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCalcAMScale : UBANS_GSBase
---@field AMScaleAxis EAMScaleRateAxis
---@field AMScaleType EAMScaleType
---@field AMScaleMinRate float
---@field AMScaleMaxRate float
---@field AMScaleMoveOffset float
---@field AMScaleMoveOffsetZ float
---@field PureScaleValue float
---@field CachedDataID int32
---@field LandingTraceLength float
---@field AttackRangeLimit boolean
---@field DebugMode boolean
UBANS_GSCalcAMScale = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCalcAMScale:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@param Actor AActor
function UBANS_GSCalcAMScale:GSValidateInputCS(Actor) end
---@return boolean
function UBANS_GSCalcAMScale:GSAllowCrossSection() end


---@class UBANS_GSCallDeathDissolve : UBANS_GSBase
UBANS_GSCallDeathDissolve = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCallDeathDissolve:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCallMultiPointsRegister : UBANS_GSBase
---@field ReqList TArray<FPointsRegisterReq>
UBANS_GSCallMultiPointsRegister = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCallMultiPointsRegister:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCallPointsRegister : UBANS_GSBase
---@field RegistID int32
---@field GenType PointsGenType
---@field ExtParam FPointsGenExtParam
UBANS_GSCallPointsRegister = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCallPointsRegister:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCamArmLengthCurve : UBANS_GSBase
---@field ArmLengthCurve FGSFloatCurveToParam
---@field BlendInTime float
---@field BlendOutTime float
UBANS_GSCamArmLengthCurve = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCamArmLengthCurve:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSCamArmLengthCurve:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCamArmLengthCurve:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCamPitchCurve : UBANS_GSBase
---@field PitchCurve FGSFloatCurveToParam
---@field BlendInTime float
UBANS_GSCamPitchCurve = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCamPitchCurve:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSCamPitchCurve:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCamPitchCurve:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCamSASOCurve : UBANS_GSBase
---@field SASOCurve UCurveVector
---@field BlendInTime float
---@field BlendOutTime float
UBANS_GSCamSASOCurve = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCamSASOCurve:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSCamSASOCurve:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCamSASOCurve:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCameraArmLocationZCurve : UBANS_GSBase
---@field Curve FGSFloatCurveToParam
---@field BlendInTime float
---@field BlendOutTime float
UBANS_GSCameraArmLocationZCurve = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCameraArmLocationZCurve:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCameraArmLocationZCurve:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCameraFixedParam : UBANS_GSBase
---@field FixedCameraParam CameraParamType
UBANS_GSCameraFixedParam = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCameraFixedParam:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCameraFixedParam:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCanBlendToDeadAM : UBANS_GSBase
UBANS_GSCanBlendToDeadAM = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCanBlendToDeadAM:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCanBlendToDeadAM:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCantInteractState : UBANS_GSBase
UBANS_GSCantInteractState = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCantInteractState:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSCantInteractState:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCantInteractState:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCastDingShen : UBANS_GSBase
---@field ImmobilizeConfigID int32
UBANS_GSCastDingShen = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCastDingShen:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCastTTTB : UBANS_GSBase
UBANS_GSCastTTTB = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCastTTTB:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSCastTTTB:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCastTTTB:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCastingState : UBANS_GSBase
UBANS_GSCastingState = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCastingState:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSCastingState:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCastingState:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCatchAndThrow : UBANS_GSBase
---@field CatchSocketName FName
---@field VictimDuringCatchMontage UAnimMontage
---@field VictimBeThrownMontage UAnimMontage
---@field bEnablePhysicsBlending boolean
UBANS_GSCatchAndThrow = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCatchAndThrow:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSCatchAndThrow:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCatchAndThrow:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSChangeMIParam : UBANS_GSBase
---@field TargetMaterialName FString
---@field ParamName FName
---@field ParamStart float
---@field ParamEnd float
UBANS_GSChangeMIParam = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSChangeMIParam:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSChangeMIParam:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSChangeMIParam:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSChargeKeyCache : UBANS_GSBase
UBANS_GSChargeKeyCache = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSChargeKeyCache:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSChargeKeyCache:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCloseCollisionCompHitMove : UBANS_GSBase
---@field CollisionCompNames TArray<FString>
UBANS_GSCloseCollisionCompHitMove = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCloseCollisionCompHitMove:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCloseCollisionCompHitMove:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCloseGravity : UBANS_GSBase
UBANS_GSCloseGravity = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCloseGravity:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCloseGravity:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCloseHitMove : UBANS_GSBase
UBANS_GSCloseHitMove = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCloseHitMove:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCloseHitMove:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCloudWindow : UBANS_GSBase
UBANS_GSCloudWindow = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCloudWindow:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCollisionResponseToChannel : UBANS_GSBase
---@field ApplyToCapsule boolean
---@field ChannelResponseType TMap<ECollisionChannel, ECollisionResponse>
---@field ApplyToMesh boolean
---@field MeshChannelResponseType TMap<ECollisionChannel, ECollisionResponse>
---@field bNotReset boolean
UBANS_GSCollisionResponseToChannel = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCollisionResponseToChannel:GSNotifyEndCS(NotifyParam) end
---@return TArray<int32>
function UBANS_GSCollisionResponseToChannel:GetCollisionChannelIndex_Mesh() end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCollisionResponseToChannel:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@return TArray<int32>
function UBANS_GSCollisionResponseToChannel:GetCollisionChannelIndex_Capsule() end


---@class UBANS_GSComboKeyCache : UBANS_GSBase
UBANS_GSComboKeyCache = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSComboKeyCache:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSComboWindow : UBANS_GSBase
---@field EnableHitModifySkillScore boolean
---@field HitSuccessSkillInfoList TArray<FHitModifySkillScoreInfo>
---@field HitFailedSkillInfoList TArray<FHitModifySkillScoreInfo>
---@field WhiteListComboSkillID TArray<int32>
---@field BlackListComboSkillID TArray<int32>
UBANS_GSComboWindow = {}

---@return EGsEnAnimNS
function UBANS_GSComboWindow:GetAnimNSType() end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSComboWindow:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCostAttrByBuff : UBANS_GSBase
---@field BuffID int32
UBANS_GSCostAttrByBuff = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCostAttrByBuff:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCostAttrByBuff:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCostAttrBySkillEffect : UBANS_GSBase
---@field SkillEffectID int32
UBANS_GSCostAttrBySkillEffect = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCostAttrBySkillEffect:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCostAttrBySkillEffect:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCostStamina : UBANS_GSBase
UBANS_GSCostStamina = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCostStamina:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSCostStamina:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCostStamina:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSCricketJumpUp : UBANS_GSBase
UBANS_GSCricketJumpUp = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSCricketJumpUp:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSCricketJumpUp:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSDashHitWallCheck : UBANS_GSBase
---@field CheckShapeList TArray<FUStCheckShape>
---@field ObjectTypeList TArray<EObjectTypeQuery>
---@field ValidTag FString
---@field HitWallStiffAM UAnimMontage
---@field IsRenderDebugShape boolean
UBANS_GSDashHitWallCheck = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSDashHitWallCheck:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSDashHitWallCheck:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSDashHitWallCheck:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSDestroyWeapon : UBANS_GSBase
---@field WeaponIndexList TArray<int32>
UBANS_GSDestroyWeapon = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSDestroyWeapon:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSDetonateBuff : UBANS_GSBase
---@field ChargeLevel int32
UBANS_GSDetonateBuff = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSDetonateBuff:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSDevLineHit : UAnimNotifyState_GSDevLineHit
UBANS_GSDevLineHit = {}


---@class UBANS_GSDisableEnterGlide : UBANS_GSBase
UBANS_GSDisableEnterGlide = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSDisableEnterGlide:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSDisableEnterGlide:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSDispInteract : UBANS_GSBase
---@field ExtraInteractBones TArray<FBoneUseForDispMap>
---@field OverrideInfo TArray<FDispInteractOverride>
UBANS_GSDispInteract = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSDispInteract:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSDispInteract:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSDispInteract:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSDodgeComboKeyCache : UBANS_GSBase
UBANS_GSDodgeComboKeyCache = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSDodgeComboKeyCache:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSDodgeWindow : UBANS_GSBase
UBANS_GSDodgeWindow = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSDodgeWindow:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSEditorHelper : UAnimNotifyState_GSEditorHelper
UBANS_GSEditorHelper = {}


---@class UBANS_GSEmpty : UBANS_GSBase
UBANS_GSEmpty = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSEmpty:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSEmpty:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSEmpty:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@return boolean
function UBANS_GSEmpty:GSAllowCrossSection() end


---@class UBANS_GSEnableIK : UBANS_GSBase
---@field bEnableIK boolean
---@field bEnableForefootIK boolean
UBANS_GSEnableIK = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSEnableIK:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSEnableIK:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSEnableMontageFootstep : UBANS_GSBase
---@field bEnableFootDecal boolean
---@field bEnableFootstepAudio boolean
---@field bEnableFootstepFX boolean
UBANS_GSEnableMontageFootstep = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSEnableMontageFootstep:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSEnableMontageFootstep:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSFaBaoCastSucceed : UBANS_GSBase
UBANS_GSFaBaoCastSucceed = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSFaBaoCastSucceed:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSHandleBattleMessage : UBAN_GSBase
---@field BattleMessage FGameplayTag
UBANS_GSHandleBattleMessage = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSHandleBattleMessage:GSNotifyCS(NotifyParam) end
---@return boolean
function UBANS_GSHandleBattleMessage:bIsNativeBranchingPointCS() end


---@class UBANS_GSHatch : UBANS_GSBase
UBANS_GSHatch = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSHatch:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSHatch:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSHeadLock : UAnimNotifyState_GSHeadLock
UBANS_GSHeadLock = {}


---@class UBANS_GSHiddenBossBar : UBANS_GSBase
UBANS_GSHiddenBossBar = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSHiddenBossBar:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSHiddenBossBar:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSHitMoveCollisionScale : UBANS_GSBase
---@field CollisionCompName FName
---@field UpdateCurve UCurveVector
---@field NeedUpdateScale boolean
---@field NeedSetRelaLocForScale boolean
---@field NeedUpdateRadius boolean
---@field HitMoveDir HitMoveDir
UBANS_GSHitMoveCollisionScale = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSHitMoveCollisionScale:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSHitMoveCollisionScale:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSItemSkillKeyCache : UBANS_GSBase
UBANS_GSItemSkillKeyCache = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSItemSkillKeyCache:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSItemSkillWindow : UBANS_GSBase
---@field ItemSkillWhiteList TArray<int32>
UBANS_GSItemSkillWindow = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSItemSkillWindow:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSJumpReady : UBANS_GSBase
UBANS_GSJumpReady = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSJumpReady:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSJumpReady:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSJumpToCeiling : UBANS_GSBase
---@field HeightCurve UCurveFloat
---@field PitchCurve UCurveFloat
---@field MaxHeight float
---@field bJumpUp boolean
UBANS_GSJumpToCeiling = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSJumpToCeiling:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSJumpToCeiling:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSJumpToCeiling:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSJumpToPosition : UBANS_GSBase
---@field JumpTarget EBGUJumpTargetType
---@field Height float
---@field TargetAddCapsuleHalfHeight boolean
---@field CalibrationTrans boolean
---@field bResetSceneItemOnFinish boolean
UBANS_GSJumpToPosition = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSJumpToPosition:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSLimitCharacterOnLand : UBANS_GSBase
---@field RayLength float
UBANS_GSLimitCharacterOnLand = {}

---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSLimitCharacterOnLand:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end


---@class UBANS_GSLockHandAndFoot : UAnimNotifyState_GSLockHandFoot
UBANS_GSLockHandAndFoot = {}


---@class UBANS_GSMagicKeyCache : UBANS_GSBase
UBANS_GSMagicKeyCache = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSMagicKeyCache:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSMagicWindow : UBANS_GSBase
---@field SkillBlackList TArray<int32>
---@field SkillWhiteList TArray<int32>
UBANS_GSMagicWindow = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSMagicWindow:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSMarkRolling : UBANS_GSBase
UBANS_GSMarkRolling = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSMarkRolling:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSMarkRolling:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSMatchingTransform : UBANS_GSBase
---@field IsNeedForceMatchingInEnd boolean
---@field IsUseSceneItemToMatchingTransfrom boolean
---@field NeedFindSceneItem boolean
---@field SceneActorTags TArray<FName>
---@field MinDistance float
---@field MaxDistance float
---@field FindSceneItemWay FindSceneItemWay
---@field Angle float
---@field NeedRemoveCurrentCatch boolean
---@field ExtraTransform FTransform
---@field IsRotatorToItem boolean
---@field EnableBow boolean
---@field EnableZAxisMove boolean
---@field IgnoreLocation boolean
---@field IgnoreRotation boolean
---@field EnableDrawDebug boolean
UBANS_GSMatchingTransform = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSMatchingTransform:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSMatchingTransform:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSModifyDestructible : UBANS_GSBase
---@field ModifyType EGSDestructibleModifyType
---@field ImpulseType EGSHitDestructibleImpulseType
---@field ImpulseStrengthLevel EGSHitDestructibleStrengthLevel
---@field ImpulseStrength float
---@field MassLevel DestructibleMassLevel
---@field StrengthLevel DestructibleStrengthLevel
UBANS_GSModifyDestructible = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSModifyDestructible:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSModifyDestructible:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSModifyDestructible:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSMontageJumpToSection : UBANS_GSBase
---@field bReversePreDetectionResult boolean
---@field bJumpImmediately boolean
---@field JumpToSectionName FName
---@field JumpableSectionPrefix FString
UBANS_GSMontageJumpToSection = {}

---@return EGsEnAnimNS
function UBANS_GSMontageJumpToSection:GetAnimNSType() end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSMontageJumpToSection:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@return boolean
function UBANS_GSMontageJumpToSection:GSAllowCrossSection() end
---@return FString
function UBANS_GSMontageJumpToSection:GetJumpableSectionPrefix() end


---@class UBANS_GSMontageJumpToSectionWhenHasBuff : UBANS_GSBase
---@field BuffID int32
---@field bJumpImmediately boolean
---@field JumpToSectionName FName
---@field JumpableSectionPrefix FString
UBANS_GSMontageJumpToSectionWhenHasBuff = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSMontageJumpToSectionWhenHasBuff:GSNotifyEndCS(NotifyParam) end
---@return EGsEnAnimNS
function UBANS_GSMontageJumpToSectionWhenHasBuff:GetAnimNSType() end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSMontageJumpToSectionWhenHasBuff:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSMontageJumpToSectionWhenHasBuff:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@return boolean
function UBANS_GSMontageJumpToSectionWhenHasBuff:GSAllowCrossSection() end
---@return FString
function UBANS_GSMontageJumpToSectionWhenHasBuff:GetJumpableSectionPrefix() end


---@class UBANS_GSMoveToSceneItem : UBANS_GSBase
---@field NoteString1 uint8
---@field IsTeleport boolean
---@field CalibrationTrans boolean
---@field bResetSceneItemOnFinish boolean
---@field ScaleXAxisOnly boolean
---@field EnableDebugMode boolean
UBANS_GSMoveToSceneItem = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSMoveToSceneItem:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSMoveToSceneItem:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSMoveWindow : UBANS_GSBase
UBANS_GSMoveWindow = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSMoveWindow:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSMyriapodsFootStep : UBANS_GSBase
UBANS_GSMyriapodsFootStep = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSMyriapodsFootStep:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSMyriapodsFootStep:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSNotFinishTrans : UAnimNotifyState
UBANS_GSNotFinishTrans = {}


---@class UBANS_GSNvFlow : UAnimNotifyState_GSNvFlow
UBANS_GSNvFlow = {}


---@class UBANS_GSPauseAI : UBANS_GSBase
UBANS_GSPauseAI = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSPauseAI:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSPauseAI:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSPausePhysics : UBANS_GSBase
---@field IncludeChildren boolean
UBANS_GSPausePhysics = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSPausePhysics:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSPausePhysics:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSPausePhysics:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSPerfectChargeState : UBANS_GSBase
UBANS_GSPerfectChargeState = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSPerfectChargeState:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSPerfectChargeState:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSPhysicsForce : UBANS_GSBase
---@field PhysicsForceType PhysicsForceType
---@field ForceFieldSize float
---@field ForceFieldOffset FVector
---@field DestructibleDamage float
---@field ImpulseStrength float
---@field QueryObjectTypes TArray<EObjectTypeQuery>
---@field IsDrawDebugShape boolean
UBANS_GSPhysicsForce = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSPhysicsForce:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSPhysicsForce:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSPhysicsForce:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSPlayAMInAMing : UBANS_GSBase
---@field AnimMontage UAnimMontage
---@field BlendInTime float
---@field BlendOutTime float
UBANS_GSPlayAMInAMing = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSPlayAMInAMing:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSPlayAMInAMing:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSPlayAMInAMing:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSPlayActorSequence : UBANS_GSBase
UBANS_GSPlayActorSequence = {}


---@class UBANS_GSPlayCameraSequence : UBANS_GSBase
UBANS_GSPlayCameraSequence = {}


---@class UBANS_GSPlayCameraShake : UBANS_GSBase
---@field CameraShake TSubclassOf<UMatineeCameraShake>
---@field CamShakeScaleByDistCurve UCurveFloat
---@field EpicenterIsAttach boolean
---@field SocketName FName
---@field StopWhenNotifyEnded boolean
---@field Stop_Immediately boolean
---@field bDisableWhenViewTargetIsntPlayer boolean
UBANS_GSPlayCameraShake = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSPlayCameraShake:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSPlayCameraShake:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSPlayCameraShake:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSPlayDummyAnim : UBANS_GSBase
---@field AnimSeq UAnimSequence
---@field bLoop boolean
---@field DummySKMeshCompTag FName
UBANS_GSPlayDummyAnim = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSPlayDummyAnim:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSPlayDummyAnim:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSPlayerInteractWindow : UBANS_GSBase
UBANS_GSPlayerInteractWindow = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSPlayerInteractWindow:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSPoleDrink : UBANS_GSBase
---@field Condition FPoleDrinkCondition
---@field DrinkHPBottomSuccessAM UAnimMontage
---@field DrinkHPBottomFailedAM UAnimMontage
---@field UseItemAMMapping TMap<int32, UAnimMontage>
---@field BlendInTime float
---@field BlendOutTime float
UBANS_GSPoleDrink = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSPoleDrink:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSPoleDrink:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSPreMontageSectionJumpDetection : UBANS_GSBase
---@field OverlayDetectTargetType ChangeTargetType
---@field SectionJumpType MontageSectionJumpType
---@field IgnoreSimplateState EBGUSimpleState
---@field BuffsToAddWhenSectionJumpApproved TArray<int32>
---@field bForceSuccess boolean
---@field DetectionCenterSocketName FName
---@field DetectionRadius float
---@field AdditionalDetectionConfig TMap<FName, float>
---@field DetectOnlyAtStart boolean
---@field bEnableDebugDraw boolean
---@field AnimationSyncMontage UAnimMontage
---@field bReversePreDetectionResult boolean
---@field bJumpImmediately boolean
---@field JumpToSectionName FName
---@field JumpableSectionPrefix FString
UBANS_GSPreMontageSectionJumpDetection = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSPreMontageSectionJumpDetection:GSNotifyEndCS(NotifyParam) end
---@return EGsEnAnimNS
function UBANS_GSPreMontageSectionJumpDetection:GetAnimNSType() end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSPreMontageSectionJumpDetection:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@return FString
function UBANS_GSPreMontageSectionJumpDetection:GetJumpableSectionPrefix() end


---@class UBANS_GSPreciseDodge : UBANS_GSBase
---@field Level int32
UBANS_GSPreciseDodge = {}



---@class UBANS_GSProcessDeathInASS : UBANS_GSBase
---@field DeathMontageList TMap<int32, UAnimMontage>
---@field SectionName FName
UBANS_GSProcessDeathInASS = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSProcessDeathInASS:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSRebirthPointInteract : UBANS_GSBase
---@field bAttachToOwner boolean
---@field AttachToSocket FName
---@field Actor TSubclassOf<AActor>
---@field bAttachOtherOnFinish boolean
---@field AttachToOtherSocket FName
---@field AttachToOtherActorTag FName
UBANS_GSRebirthPointInteract = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSRebirthPointInteract:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSRebirthPointInteract:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSRebirthPointInteract:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSReleaseBlockState : UBANS_GSBase
UBANS_GSReleaseBlockState = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSReleaseBlockState:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSRotateWithCamFwd : UBANS_GSBase
---@field RotSpeed float
UBANS_GSRotateWithCamFwd = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSRotateWithCamFwd:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSRotateWithCamFwd:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSRotateWithCamFwd:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSetAMSpeedRate : UBANS_GSBase
---@field SectionSpeedRate float
UBANS_GSSetAMSpeedRate = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSetAMSpeedRate:GSNotifyEndCS(NotifyParam) end
---@return EGsEnAnimNS
function UBANS_GSSetAMSpeedRate:GetAnimNSType() end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSetAMSpeedRate:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@param Actor AActor
function UBANS_GSSetAMSpeedRate:GSValidateInputCS(Actor) end
---@return float
function UBANS_GSSetAMSpeedRate:GetModifySpeedRate() end


---@class UBANS_GSSetBattleMainCon : UBANS_GSBase
---@field IsActiveBattleMainUI boolean
UBANS_GSSetBattleMainCon = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSetBattleMainCon:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSetCharacterModuleConstraintProfile : UBANS_GSBase
---@field EquipPosition EquipPosition
---@field ConstraintProfileName FName
UBANS_GSSetCharacterModuleConstraintProfile = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSetCharacterModuleConstraintProfile:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSetCharacterModuleConstraintProfile:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSetCloudMoveEnabled : UBANS_GSBase
---@field bIsEnabled boolean
UBANS_GSSetCloudMoveEnabled = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSetCloudMoveEnabled:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSetCollisionEnabledByTag : UBANS_GSBase
---@field CollisionCompTag FName
---@field EnableType ECollisionEnabled::Type
UBANS_GSSetCollisionEnabledByTag = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSetCollisionEnabledByTag:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSetCollisionEnabledByTag:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSetCompVisibility : UBANS_GSBase
---@field ForOwnerActor boolean
---@field ForWeaponActor boolean
---@field IsVisible boolean
---@field CompTagName FName
---@field NeedRecoverInEnd boolean
UBANS_GSSetCompVisibility = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSetCompVisibility:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSSetCompVisibility:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSetCompVisibility:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSetCurveValueForCamOffset : UBANS_GSBase
---@field CameraOffsetSetting FFGSCameraOffsetSetting
UBANS_GSSetCurveValueForCamOffset = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSetCurveValueForCamOffset:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSetCurveValueForCamOffset:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSetCurveValueToMesh : UBANS_GSBase
---@field TemporaryClose boolean
---@field FloatCurveParamList TArray<FGSFloatCurveToParam>
---@field LinearColorCurveParamList TArray<FGSLinearColorCurveToParam>
---@field NotApplyToChrMesh boolean
---@field MatIndexList TArray<int32>
---@field BothWeapons boolean
---@field WeaponIndexList TArray<int32>
---@field WeaponMatIndexList TArray<int32>
---@field BothChildSkeltalMeshes boolean
---@field ChildSKMeshTagList TArray<FName>
---@field ChildSKMatIndexList TArray<int32>
---@field BothChildActor boolean
---@field ChildActorMeshMatIndexList TArray<int32>
---@field NeedRecovery boolean
---@field bFitRealTime boolean
UBANS_GSSetCurveValueToMesh = {}

---@param LogArr TArray<FString>
---@param SKMesh USkeletalMesh
---@param WhiteParamNameList TArray<FName>
---@param TotallyBelongToDBC boolean
---@return boolean
function UBANS_GSSetCurveValueToMesh:FilterByRule(LogArr, SKMesh, WhiteParamNameList, TotallyBelongToDBC) end
---@return EGsEnAnimNS
function UBANS_GSSetCurveValueToMesh:GetAnimNSType() end
---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSetCurveValueToMesh:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSetCurveValueToMesh:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSetCurveValueToSimulateFog : UBANS_GSBase
---@field FloatCurveParamList TArray<FGSFloatCurveToParam>
UBANS_GSSetCurveValueToSimulateFog = {}



---@class UBANS_GSSetDmgNumCanEnable : UBANS_GSBase
---@field IsActiveBattleMainUI boolean
UBANS_GSSetDmgNumCanEnable = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSetDmgNumCanEnable:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSetSkillSuperArmor : UBANS_GSBase
---@field SkillSuperArmorLevel FFGSDescRowHandle
---@field SkillSuperArmorValue float
---@field SSABreakAssignedAnim UAnimMontage
UBANS_GSSetSkillSuperArmor = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSetSkillSuperArmor:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSetSkillSuperArmor:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@return boolean
function UBANS_GSSetSkillSuperArmor:UpdateSkillSuperArmorLevelInfo() end
---@return boolean
function UBANS_GSSetSkillSuperArmor:GSAllowCrossSection() end


---@class UBANS_GSShooterMode : UBANS_GSBase
UBANS_GSShooterMode = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSShooterMode:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSShooterMode:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSShooterMode:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSliceRuntimeMesh : UBANS_GSBase
---@field OutwardSocketName FName
---@field PivotSocketName FName
---@field SliceLength float
---@field ApplyForce float
---@field bIsReflexAngle boolean
---@field bShowDebug boolean
UBANS_GSSliceRuntimeMesh = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSliceRuntimeMesh:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSSliceRuntimeMesh:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSliceRuntimeMesh:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSlowIK : UBANS_GSBase
---@field SlowIKType SlowIKType
---@field SlowTime float
---@field SlowTime_Crit float
---@field ProtectGap float
UBANS_GSSlowIK = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSlowIK:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSSlowIK:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSlowIK:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSlowTime : UBANS_GSBase
---@field TimeScaleSetting FFGSTimeScaleSetting
UBANS_GSSlowTime = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSlowTime:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSlowTime_LifeSaving : UBANS_GSBase
---@field TimeScaleSetting FFGSTimeScaleSetting
UBANS_GSSlowTime_LifeSaving = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSlowTime_LifeSaving:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSpawnActorAndSyncAnimation : UBANS_GSBase
---@field SpawnActorTemplate TSubclassOf<AActor>
---@field bFoundHostSyncPointOnDummyMesh boolean
---@field SelfSyncPointOnHost FName
---@field TargetSyncPointOnHost FName
---@field SelfSyncPointOnGuest FName
---@field GuestMontage UAnimMontage
---@field bActorKeepAlive boolean
---@field DestroyDelayTime float
---@field bStopGuestMontageOnEnd boolean
UBANS_GSSpawnActorAndSyncAnimation = {}

---@return EGsEnAnimNS
function UBANS_GSSpawnActorAndSyncAnimation:GetAnimNSType() end
---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSpawnActorAndSyncAnimation:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSpawnActorAndSyncAnimation:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSpawnBullets : UBANS_GSBase
---@field bNeedHandleStopReq boolean
---@field bNeedDestorySpawnedBullet boolean
---@field BuffIDList TArray<int32>
---@field BulletID int32
---@field BulletWave int32
---@field WaveIntervalNoise float
---@field BulletNumInOneWave int32
---@field SpawnBase FProjectileBaseStruct
---@field SpawnPosOffsetInfo FProjectilePosOffsetStruct
---@field AttachToSpawnBase boolean
---@field AttachRule_Rot EAttachmentRule
---@field TargetBase FProjectileBaseStruct
---@field TargetPosOffsetInfo FProjectilePosOffsetStruct
---@field BornDirBaseInfo FProjectileBornDirStruct
---@field BornDirOffset FProjectileBornDirOffsetStruct
---@field BulletFlySpd FSpawnBulletSpeed
---@field BulletRotSpd FSpawnBulletSpeed
---@field bEnableMultiTargetMode boolean
---@field MutilTargetRule FProjectileMulTargetRule
---@field bEnableSpawnBase_NoneTarget boolean
---@field SpawnBase_NoneTarget FProjectileBaseStruct
---@field SpawnPosOffsetInfo_NoneTarget FProjectilePosOffsetStruct
---@field bEnableTargetBase_NoneTarget boolean
---@field TargetBase_NoneTarget FProjectileBaseStruct
---@field TargetPosOffsetInfo_NoneTarget FProjectilePosOffsetStruct
UBANS_GSSpawnBullets = {}

---@return boolean
function UBANS_GSSpawnBullets:MarkDirty() end
---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSpawnBullets:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSpawnBullets:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@param InActor AActor
function UBANS_GSSpawnBullets:GSValidateInputCS(InActor) end


---@class UBANS_GSSweepCheck : UBANS_GSBase
---@field WeaponIndex int32
---@field SweepCheckShape TArray<FUStCheckShape>
---@field SweepCheckShapeExtend TArray<int32>
---@field bForceUpdateDescData boolean
---@field AbnormalStateEffectList TArray<FAbnormalStateAccConfig>
---@field EffectsWithCondition_Before TArray<FTriggerEffectWithCondition>
---@field EffectIDList TArray<int32>
---@field EffectsWithCondition_After TArray<FTriggerEffectWithCondition>
---@field EffectIDListForSceneItem TArray<int32>
---@field HitChrAudioID int32
---@field HitChrFXWeight int32
---@field HitCheckConf FHitCheckConf
---@field CanHitBackBullet boolean
---@field HitDestructibleConfig FHitDestructibleActorConfig
---@field AtkReboundingAM UAnimMontage
---@field LowAtkReboundingAM UAnimMontage
---@field SweepCheckGroupID int32
UBANS_GSSweepCheck = {}

---@return boolean
function UBANS_GSSweepCheck:HasAbnormalStateData() end
---@param NewCollisionChanel ECollisionChannel
function UBANS_GSSweepCheck:ResetSweepCheckChanel(NewCollisionChanel) end
---@param OldPreID int32
---@param NewPreID int32
---@return boolean
function UBANS_GSSweepCheck:ReplaceEffectIDByPreID(OldPreID, NewPreID) end
---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSweepCheck:GSNotifyEndCS(NotifyParam) end
---@param AssistBreakFrozenEffectID int32
---@return boolean
function UBANS_GSSweepCheck:AddAssistBreakFrozenEffectID(AssistBreakFrozenEffectID) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSSweepCheck:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSweepCheck:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@param Actor AActor
function UBANS_GSSweepCheck:GSValidateInputCS(Actor) end


---@class UBANS_GSSwitchAimingSetting : UBANS_GSBase
---@field AimAndShoot UBGWDataAsset_AbpHumanoidSetting
UBANS_GSSwitchAimingSetting = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSwitchAimingSetting:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSwitchAimingSetting:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSwitchCollisionProfile : UBANS_GSBase
---@field ProfileList TArray<FCollisionProfileInfo>
UBANS_GSSwitchCollisionProfile = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSwitchCollisionProfile:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSwitchCollisionProfile:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSwitchMovementMode : UBANS_GSBase
---@field MovementMode EMovementMode
UBANS_GSSwitchMovementMode = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSwitchMovementMode:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSwitchMovementMode:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSwitchPlayerCamID : UBANS_GSBase
---@field CameraID int32
UBANS_GSSwitchPlayerCamID = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSwitchPlayerCamID:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSwitchPlayerCamID:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSyncAnimations : UBANS_GSBase
---@field bFoundHostSyncPointOnDummyMesh boolean
---@field SelfSyncPointOnHost FName
---@field TargetSyncPointOnHost FName
---@field SelfSyncPointOnGuest FName
---@field TargetSyncPointOnGuest FName
---@field GuestMontage UAnimMontage
---@field bForceSyncDummyMeshAnimation boolean
---@field bEnableDebugDraw boolean
UBANS_GSSyncAnimations = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSyncAnimations:GSNotifyEndCS(NotifyParam) end
---@return EGsEnAnimNS
function UBANS_GSSyncAnimations:GetAnimNSType() end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSSyncAnimations:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSyncAnimations:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSSyncAnimationsIgnoreHitMove : UBANS_GSBase
UBANS_GSSyncAnimationsIgnoreHitMove = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSSyncAnimationsIgnoreHitMove:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSSyncAnimationsIgnoreHitMove:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSSyncAnimationsIgnoreHitMove:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSTestIn426 : UBANS_GSBase
---@field TestValue float
---@field BuffID int32
---@field UseBuffDescDuration boolean
UBANS_GSTestIn426 = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSTestIn426:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSTestIn426:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSTestIn426:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSTimedParticleEffect : UAnimNotifyState_GSTimedParticleEffect
UBANS_GSTimedParticleEffect = {}


---@class UBANS_GSTimedPlayNiagaraFX : UBANS_GSBase
---@field EditorActive boolean
---@field Template TSoftObjectPtr<UNiagaraSystem>
---@field DelayTimeAfterStop float
---@field DestroyTiming DispLibDBCEffectDestroyTiming
---@field OverrideSKMTagName FName
---@field Attached boolean
---@field SocketName FName
---@field offsetInLocaSpace boolean
---@field LocationOffset FVector
---@field RotationOffset FRotator
---@field Scale FVector
---@field SnapGround boolean
---@field SnapGroundRotationMode DispLibDBCSnapGroundRotationMode
---@field ignoreRootBoneScale boolean
---@field SetSelfMeshParam boolean
---@field OverrideSKMBones TArray<FName>
---@field OverrideSKMSockets TArray<FName>
---@field customParams TArray<FGSNiagaraSysParam>
---@field DetachOnEndDispStageBegin boolean
---@field EnableShadow boolean
---@field TranslucentSortPriority int32
---@field PausePriority int32
---@field PauseMode DispLibDBCPauseMode
---@field EndStagePriority int32
---@field ForceChangeVisibleStateDEFPriority int32
---@field ForceVisibleStateDefaultMode DispLibDBCNiagaraForceVisibleStateMode
---@field CompTag FName
---@field ScalabilitySettings FBUC_DispLibDBC_NiagaraEventScalabilitySettings
---@field hasAttachedSocket boolean
UBANS_GSTimedPlayNiagaraFX = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSTimedPlayNiagaraFX:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSTimedPlayNiagaraFX:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@return TArray<FSoftObjectPath>
function UBANS_GSTimedPlayNiagaraFX:GetSoftReferences() end


---@class UBANS_GSTimedPlayNiagaraFX_WithCondition : UBANS_GSTimedPlayNiagaraFX
---@field Condition FPlayNiagaraConditions
UBANS_GSTimedPlayNiagaraFX_WithCondition = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSTimedPlayNiagaraFX_WithCondition:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSTimedPlayNiagaraFX_WithCondition:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSTireMarks : UBANS_GSBase
---@field DecalMat UMaterialInstance
---@field SocketName FName
---@field DecalSize FVector
---@field DecalFadeOutTime float
---@field DecalDelayFadeOutTime float
UBANS_GSTireMarks = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSTireMarks:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSTireMarks:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSTireMarks:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSToNextSectionWhenLand : UBANS_GSBase
---@field LineTraceStartSocket FName
---@field LineTraceLengthFix float
---@field JumpSectionName FName
---@field EnableDebug boolean
UBANS_GSToNextSectionWhenLand = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSToNextSectionWhenLand:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSToNextSectionWhenLand:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSToNextSectionWhenLand:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSTouchItem : UBANS_GSBase
---@field BlendInTime float
---@field BlendOutTime float
---@field TouchIKType TouchIKType
---@field FindActorRadius float
---@field TouchActorTag FName
---@field TouchActorSocketName FName
---@field TouchCenterSocketName FName
---@field bUseFullBodyIK boolean
---@field bUseIKPositionOffset boolean
---@field OffsetCurve UCurveVector
UBANS_GSTouchItem = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSTouchItem:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSTouchItem:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSTouchItem:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSTrail : UAnimNotifyState_GSTrail
UBANS_GSTrail = {}


---@class UBANS_GSTrailWithArray : UAnimNotifyState_GSTrailWithArray
UBANS_GSTrailWithArray = {}


---@class UBANS_GSTriggerEffect : UBANS_GSBase
---@field EffectID int32
UBANS_GSTriggerEffect = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSTriggerEffect:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSTriggerEffect:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSTriggerEffect:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@param Actor AActor
function UBANS_GSTriggerEffect:GSValidateInputCS(Actor) end


---@class UBANS_GSTriggerSkillCam : UBANS_GSBase
---@field SkillCamID int32
UBANS_GSTriggerSkillCam = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSTriggerSkillCam:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSTriggerSkillCam:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSTriggerSkillCam:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@param Actor AActor
function UBANS_GSTriggerSkillCam:GSValidateInputCS(Actor) end


---@class UBANS_GSTriggerTransEffect : UBANS_GSBase
---@field TransEffectSettings TSoftObjectPtr<UBGWDataAsset_TransEffectSetting>
---@field EffectOffset FVector
UBANS_GSTriggerTransEffect = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSTriggerTransEffect:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@return TArray<FSoftObjectPath>
function UBANS_GSTriggerTransEffect:GetSoftReferences() end


---@class UBANS_GSTryHRCouonterAttack : UBANS_GSBase
UBANS_GSTryHRCouonterAttack = {}

---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_GSTryHRCouonterAttack:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSTryHRCouonterAttack:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSVigorKeyCache : UBANS_GSBase
UBANS_GSVigorKeyCache = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSVigorKeyCache:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSVigorWindow : UBANS_GSBase
---@field VigorSkillWhiteList TArray<int32>
UBANS_GSVigorWindow = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSVigorWindow:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSWeaponAimTo : UBANS_GSBase
---@field WeaponBoneName FName
---@field AimAxis FVector
---@field AimToType AimToType
---@field TargetSocketName FName
---@field BlendInTime float
---@field BlendOutTime float
---@field TraceSpd float
---@field DegreesConstraint float
---@field EnableDebug boolean
UBANS_GSWeaponAimTo = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSWeaponAimTo:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSWeaponAimTo:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_GSWeponHide : UBANS_GSBase
---@field WeaponIndex TArray<int32>
---@field IsHidden boolean
---@field OpenCollisionIfNotHidden boolean
---@field NotRestore boolean
UBANS_GSWeponHide = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_GSWeponHide:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_GSWeponHide:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_JumpWindow : UBANS_GSBase
UBANS_JumpWindow = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_JumpWindow:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_JumpWindow:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_JumpWindow:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_LifeSavingHairBlocking : UBANS_GSBase
UBANS_LifeSavingHairBlocking = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_LifeSavingHairBlocking:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_LifeSavingHairBlocking:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_LifeSavingHairWindow : UBANS_GSBase
UBANS_LifeSavingHairWindow = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_LifeSavingHairWindow:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_LifeSavingHairWindow:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_OnSpiderSkillEntangleStiffEnded : UBANS_GSBase
UBANS_OnSpiderSkillEntangleStiffEnded = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_OnSpiderSkillEntangleStiffEnded:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_OnSpiderSkillEntangleStiffEnded:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_OnSpiderSkillEntangleStiffEnded:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_PlayRotAMByCamRotInAM : UBANS_GSBase
---@field RotTypeInSmallAngle RotTypeInSmallAngle
---@field RotTypeInLargeAngle RotTypeInLargeAngle
---@field AngleThreshold float
---@field TurnSpd float
---@field RotateWithCamSpeed float
---@field TurnRightAM UAnimMontage
---@field TurnLeftAM UAnimMontage
---@field BlendInTime float
---@field BlendOutTime float
UBANS_PlayRotAMByCamRotInAM = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_PlayRotAMByCamRotInAM:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_PlayRotAMByCamRotInAM:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_PlayRotAMByCamRotInAM:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_PlaySkillSequence : UBANS_GSBase
---@field SequenceList TArray<FLevelSequenceConfig>
---@field RotationType SkillCameraRotationType
---@field bAttachToUnit boolean
---@field DummyMeshAttachSocketName FName
---@field ExtraCameraForSeqBindTag FName
---@field bMoveCameraSpringArmRotToNearestAfterAS boolean
---@field TeleportAngleDeg float
---@field bInCameraBlendTimeUseNotifyStateLength boolean
---@field InCameraBlendTime float
---@field InCameraBlendFactor float
---@field bEnableCameraAutoBlendOut boolean
---@field OutCameraBlendTime float
---@field OutCameraBlendFactor float
UBANS_PlaySkillSequence = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_PlaySkillSequence:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@return TArray<FSoftObjectPath>
function UBANS_PlaySkillSequence:GetSoftReferences() end


---@class UBANS_PlayWaterSplash : UBANS_GSBase
---@field MappingID int32
---@field SweepRadius float
---@field WeaponIndex int32
---@field SocketNameList TArray<FName>
---@field PresetLocalPoints TMap<float, FVector>
---@field PresetLocalSweepTangentArray TArray<FVector>
---@field bDrawDebug boolean
UBANS_PlayWaterSplash = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_PlayWaterSplash:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_PlayWaterSplash:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_PlayWaterSplash:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_RespectCollisionInASS : UBANS_GSBase
UBANS_RespectCollisionInASS = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_RespectCollisionInASS:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_RespectCollisionInASS:GSNotifyBeginCS(NotifyParam, TotalDuration) end
---@return boolean
function UBANS_RespectCollisionInASS:GSAllowCrossSection() end


---@class UBANS_SetCurveValueToHair : UBANS_GSBase
---@field TemporaryClose boolean
---@field HairType EGSHairType
---@field HairCompTagList TArray<FName>
---@field FloatCurveParamList TArray<FGSFloatCurveToParam>
UBANS_SetCurveValueToHair = {}

---@return EGsEnAnimNS
function UBANS_SetCurveValueToHair:GetAnimNSType() end


---@class UBANS_SetMPCParam : UBANS_GSBase
---@field MPC UMaterialParameterCollection
---@field FloatParams TMap<FString, UCurveFloat>
UBANS_SetMPCParam = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_SetMPCParam:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_SpawnFXByDispConfig : UBANS_GSBase
---@field DispConfigDA UBUC_DispLibDispBaseConfigDataAsset
UBANS_SpawnFXByDispConfig = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_SpawnFXByDispConfig:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_SpawnFXByDispConfig:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_StopMontagePreLand : UBANS_GSBase
---@field LineTraceLengthFix float
---@field EnableDebug boolean
UBANS_StopMontagePreLand = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_StopMontagePreLand:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_StopMontagePreLand:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_StopMontagePreLand:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_StopMontageWhenLand : UBANS_GSBase
UBANS_StopMontageWhenLand = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_StopMontageWhenLand:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_StopMontageWhenLand:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_StopMontageWhenLand:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_SweepHitSceneItems : UBANS_GSBase
---@field SweepCheckShape TArray<FUStCheckShape>
---@field BulletID int32
---@field AimType AimType
---@field BulletFlySpd FSpawnBulletSpeed
---@field AimConstraintAxis FVector
---@field BornDirOffsetX FSpawnBulletMinMaxValue
---@field BornDirOffsetY FSpawnBulletMinMaxValue
---@field BornDirOffsetZ FSpawnBulletMinMaxValue
UBANS_SweepHitSceneItems = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_SweepHitSceneItems:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param FrameDeltaTime float
function UBANS_SweepHitSceneItems:GSNotifyTickCS(NotifyParam, FrameDeltaTime) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_SweepHitSceneItems:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_SwicthMoveState : UBANS_GSBase
---@field MovementMode EMovementMode
UBANS_SwicthMoveState = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_SwicthMoveState:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_SwicthMoveState:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_Teleport : UBANS_GSBase
---@field TeleportPointType TeleportPointType
---@field TeleportPointLocationOffset FVector
UBANS_Teleport = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_Teleport:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_ToggleWeaponStatus : UBANS_GSBase
---@field WeaponIndexList TArray<int32>
---@field TriggerShowFirst boolean
UBANS_ToggleWeaponStatus = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_ToggleWeaponStatus:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_ToggleWeaponStatus:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_TriggerBanTrans2DaSheng : UBANS_GSBase
UBANS_TriggerBanTrans2DaSheng = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_TriggerBanTrans2DaSheng:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_TriggerSealingSpell : UBANS_GSBase
UBANS_TriggerSealingSpell = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_TriggerSealingSpell:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_TriggerSkillCameraGroup : UBANS_GSBase
---@field CameraGroupId int32
UBANS_TriggerSkillCameraGroup = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_TriggerSkillCameraGroup:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_TriggerSkillCameraGroup:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_TriggerTrans2DaSheng : UBANS_GSBase
UBANS_TriggerTrans2DaSheng = {}

---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_TriggerTrans2DaSheng:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_UnhideAndPlayAnim : UBANS_GSBase
---@field SKTag FName
---@field AnimationToPlay UAnimationAsset
UBANS_UnhideAndPlayAnim = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_UnhideAndPlayAnim:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_UnhideAndPlayAnim:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBANS_X2_PlayDBCDataAsset : UBANS_GSBase
---@field Play boolean
---@field DataAsset UBUC_DispLibDispBaseConfigDataAsset
---@field PlayByDispWorld boolean
---@field MainSockNameIfDW FName
---@field DBC_Main DispLibDBCAnimNotifyTarget
---@field DBC_Minor DispLibDBCAnimNotifyTarget
---@field StopIfTargetNull boolean
UBANS_X2_PlayDBCDataAsset = {}

---@param NotifyParam FUStGSNotifyParam
function UBANS_X2_PlayDBCDataAsset:GSNotifyEndCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@param TotalDuration float
function UBANS_X2_PlayDBCDataAsset:GSNotifyBeginCS(NotifyParam, TotalDuration) end


---@class UBAN_DispLibApplySceneInteractor : UBAN_GSBase
---@field DataAsset UBUC_DispLibSceneInteractorData
---@field ConfigInfo FBUC_DispLibDBC_ScenePhysicalInteractor
UBAN_DispLibApplySceneInteractor = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_DispLibApplySceneInteractor:GSNotifyCS(NotifyParam) end


---@class UBAN_DispLibChangeUnitMaterial : UBAN_GSBase
---@field FilterMode FBUC_DispLibDBC_MaterialEffectTargetInfo
---@field Template UMaterialInterface
---@field InheriParamsMode DispLibMaterialParamsInheritMode
---@field InheritScalarParam TArray<FName>
---@field InheritFLinearColorParam TArray<FName>
---@field InheritTextureParam TArray<FName>
UBAN_DispLibChangeUnitMaterial = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_DispLibChangeUnitMaterial:GSNotifyCS(NotifyParam) end


---@class UBAN_DispLibEndDBCEffects : UBAN_GSBase
---@field EditorActive boolean
---@field EditorPlayActive boolean
---@field CompTag FName
---@field OnlyEndFX boolean
---@field OnlyEndProcedureEndMode boolean
---@field EndStagePriority int32
UBAN_DispLibEndDBCEffects = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_DispLibEndDBCEffects:GSNotifyCS(NotifyParam) end


---@class UBAN_DispLibModifyMaterial : UBAN_GSBase
---@field EditorActive boolean
---@field FilterMode FBUC_DispLibDBC_MaterialEffectTargetInfo
---@field Delay float
---@field Duration float
---@field DelayTimeAfterStop float
---@field Template UMaterialInterface
---@field InheriParamsMode DispLibMaterialParamsInheritMode
---@field InheritScalarParam TArray<FName>
---@field InheritFLinearColorParam TArray<FName>
---@field InheritTextureParam TArray<FName>
---@field SetScalarParam TArray<FBUC_DispLibUtil_DBCAdvProcessScalarMatLayerParam>
---@field SetFLinearColorParam TArray<FBUC_DispLibUtil_DBCAdvProcessFLinearColorMatLayerParam>
---@field SetTextureParam TArray<FBUC_DispLibUtil_DBCTextureMatLayerParam>
---@field SetPCurveScalarParam TArray<FBUC_DispLibUtil_DBCPCurveScalarMatLayerParam>
---@field SetPCurveFLinearColorParam TArray<FBUC_DispLibUtil_DBCPCurveColorMatLayerParam>
---@field PausePriority int32
---@field EndStagePriority int32
---@field ModMatPriority int32
---@field ModMatEndStagePriority int32
UBAN_DispLibModifyMaterial = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_DispLibModifyMaterial:GSNotifyCS(NotifyParam) end


---@class UBAN_DispLibPlayCameraShake : UBAN_GSBase
---@field EditorActive boolean
---@field Delay float
---@field CameraShake TSubclassOf<UMatineeCameraShake>
---@field Override_Oscillation_Duration float
---@field ForceApply boolean
---@field CustomScaleCurve FBUC_DispLibUtil_DBCPCurveScalar
---@field UseDistanceDamping boolean
---@field AttachedTarget boolean
---@field AttachedTargetSocketName FName
---@field CamShakeScaleByDistCurve UCurveFloat
---@field MaxDistance float
UBAN_DispLibPlayCameraShake = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_DispLibPlayCameraShake:GSNotifyCS(NotifyParam) end


---@class UBAN_DispLibPlayCustomCameraShake : UBAN_GSBase
---@field EditorActive boolean
---@field EditorPlayActive boolean
---@field CustomCameraShake FBUC_DispLibDBC_PlayCustomCameraShake
UBAN_DispLibPlayCustomCameraShake = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_DispLibPlayCustomCameraShake:GSNotifyCS(NotifyParam) end


---@class UBAN_DispLibPlayDBCDataAsset : UBAN_GSBase
---@field DataAsset UBUC_DispLibDispBaseConfigDataAsset
---@field PlayByDispWorld boolean
---@field MainSockNameIfDW FName
UBAN_DispLibPlayDBCDataAsset = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_DispLibPlayDBCDataAsset:GSNotifyCS(NotifyParam) end


---@class UBAN_DispLibSimpleRibbonTrailsArray : UBAN_GSBase
---@field EditorActive boolean
---@field Template TSoftObjectPtr<UNiagaraSystem>
---@field Duration float
---@field DelayTimeAfterStop float
---@field SocketName FName
---@field LocationOffset FVector
---@field RotationOffset FRotator
---@field Scale FVector
---@field ignoreRootBoneScale boolean
---@field customParams TArray<FGSNiagaraSysParam>
---@field TranslucentSortPriority int32
---@field CompTag FName
UBAN_DispLibSimpleRibbonTrailsArray = {}

---@return TArray<FSoftObjectPath>
function UBAN_DispLibSimpleRibbonTrailsArray:GetSoftReferences() end


---@class UBAN_DispLibUnitArtFresnel : UBAN_GSBase
---@field EditorActive boolean
---@field UseUniversalUAF boolean
---@field UniversalUAFIndex int32
---@field CustomUAFDataAsset UBUC_DispLibUnitArtFresnelDataAsset
---@field FilterMode FBUC_DispLibDBC_MaterialEffectTargetInfo
---@field Priority int32
---@field OverrideTime float
---@field OverrideSimpleProgrammedCurve int32
---@field OverrideFadeInTime float
---@field OverrideCommonTime float
---@field OverrideFadeOutTime float
---@field OverrideProgrammedPowerMax float
---@field OverrideOnePeriodTime float
---@field OverrideLoop int32
UBAN_DispLibUnitArtFresnel = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_DispLibUnitArtFresnel:GSNotifyCS(NotifyParam) end


---@class UBAN_EnterSkillCameraGroup : UBAN_GSBase
---@field CameraGroupId int32
UBAN_EnterSkillCameraGroup = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_EnterSkillCameraGroup:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_EnterSkillCameraGroup:bIsNativeBranchingPointCS() end


---@class UBAN_ExitPhasePerformance : UBAN_GSBase
UBAN_ExitPhasePerformance = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_ExitPhasePerformance:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_ExitPhasePerformance:bIsNativeBranchingPointCS() end


---@class UBAN_ExitSkillCameraGroup : UBAN_GSBase
UBAN_ExitSkillCameraGroup = {}


---@class UBAN_GSAIJumpEnd : UBAN_GSBase
UBAN_GSAIJumpEnd = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSAIJumpEnd:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSAIJumpEnd:bIsNativeBranchingPointCS() end


---@class UBAN_GSAIJumpStart : UBAN_GSBase
UBAN_GSAIJumpStart = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSAIJumpStart:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSAIJumpStart:bIsNativeBranchingPointCS() end


---@class UBAN_GSAkEvent : UBAN_GSBase
---@field CanHandleStopRequest boolean
---@field PlaySubtitle boolean
---@field AttachPointName FString
---@field AkEvent TSoftObjectPtr<UAkAudioEvent>
---@field AkStopEvent TSoftObjectPtr<UAkAudioEvent>
---@field Follow boolean
---@field EventName FString
UBAN_GSAkEvent = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSAkEvent:GSNotifyCS(NotifyParam) end
---@return TArray<FSoftObjectPath>
function UBAN_GSAkEvent:GetSoftReferences() end
---@return boolean
function UBAN_GSAkEvent:bIsNativeBranchingPointCS() end


---@class UBAN_GSApplyEnvironmentMask : UBAN_GSBase
---@field EnvironmentMaskDataList TArray<FEnvironmentMaskData>
UBAN_GSApplyEnvironmentMask = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSApplyEnvironmentMask:GSNotifyCS(NotifyParam) end


---@class UBAN_GSAttachWeaponToSocket : UBAN_GSBase
---@field ActorTag FName
---@field SocketName FName
---@field WeaponIndex int32
---@field AttachmentLocationRule EAttachmentRule
---@field AttachmentRotationRule EAttachmentRule
---@field AttachmentScaleRule EAttachmentRule
---@field WeaponNeedPlayAnim boolean
---@field AnimAsset UAnimationAsset
---@field WeaponScaleUseCurve boolean
---@field WeaponScaleCurve UCurveVector
---@field WeaponNeedDoCallBP boolean
---@field WeaponCallBPFloatParam float
UBAN_GSAttachWeaponToSocket = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSAttachWeaponToSocket:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSAttachWeaponToSocket:bIsNativeBranchingPointCS() end


---@class UBAN_GSAwakePartner : UBAN_GSBase
---@field PartnerFilter int32
---@field ResIDList TArray<int32>
---@field AwakeUnitInFight boolean
---@field CircleRadius int32
---@field Height_Up float
---@field Height_Down float
UBAN_GSAwakePartner = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSAwakePartner:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSAwakePartner:bIsNativeBranchingPointCS() end


---@class UBAN_GSB1SpawnDecalActor : UBAN_GSBase
---@field DecalActorClass TSubclassOf<ABGUDecalActor>
---@field SocketName FName
---@field SpawnPosOffset FVector
UBAN_GSB1SpawnDecalActor = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSB1SpawnDecalActor:GSNotifyCS(NotifyParam) end


---@class UBAN_GSBase : UAnimNotify_GSBase
UBAN_GSBase = {}

---@param Actor AActor
function UBAN_GSBase:GSValidateInputCS(Actor) end
---@return TArray<FSoftObjectPath>
function UBAN_GSBase:GetSoftReferences() end
---@param NotifyParam FUStGSNotifyParam
---@return int32
function UBAN_GSBase:GSPreNotifyDebugCS(NotifyParam) end
---@param NotifyParam FUStGSNotifyParam
---@return int32
function UBAN_GSBase:GSPostNotifyDebugCS(NotifyParam) end


---@class UBAN_GSCallMasterUseSkill : UBAN_GSBase
---@field MasterSkillID int32
UBAN_GSCallMasterUseSkill = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSCallMasterUseSkill:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSCallMasterUseSkill:bIsNativeBranchingPointCS() end


---@class UBAN_GSCallMultiPointsRegister : UBAN_GSBase
---@field ReqList TArray<FPointsRegisterReq>
UBAN_GSCallMultiPointsRegister = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSCallMultiPointsRegister:GSNotifyCS(NotifyParam) end


---@class UBAN_GSCallPointsRegister : UBAN_GSBase
---@field RegistID int32
---@field GenType PointsGenType
---@field ExtParam FPointsGenExtParam
UBAN_GSCallPointsRegister = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSCallPointsRegister:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSCallPointsRegister:bIsNativeBranchingPointCS() end


---@class UBAN_GSClearComboKeyCache : UBAN_GSBase
UBAN_GSClearComboKeyCache = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSClearComboKeyCache:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSClearComboKeyCache:bIsNativeBranchingPointCS() end


---@class UBAN_GSCloudMoveAkEvent : UBAN_GSBase
---@field bIsStop boolean
---@field AkEvent TSoftObjectPtr<UAkAudioEvent>
UBAN_GSCloudMoveAkEvent = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSCloudMoveAkEvent:GSNotifyCS(NotifyParam) end
---@return TArray<FSoftObjectPath>
function UBAN_GSCloudMoveAkEvent:GetSoftReferences() end


---@class UBAN_GSCollectTrigger : UBAN_GSBase
UBAN_GSCollectTrigger = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSCollectTrigger:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSCollectTrigger:bIsNativeBranchingPointCS() end


---@class UBAN_GSDestroyFXCompByTag : UBAN_GSBase
---@field DestroyImmediately boolean
---@field CompTag FName
UBAN_GSDestroyFXCompByTag = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSDestroyFXCompByTag:GSNotifyCS(NotifyParam) end


---@class UBAN_GSDestroyProjectileByID : UBAN_GSBase
---@field ProjetcileIDList TArray<int32>
UBAN_GSDestroyProjectileByID = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSDestroyProjectileByID:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSDestroyProjectileByID:bIsNativeBranchingPointCS() end


---@class UBAN_GSDestroyProjectile_ExceptID : UBAN_GSBase
---@field ProjetcileIDList TArray<int32>
UBAN_GSDestroyProjectile_ExceptID = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSDestroyProjectile_ExceptID:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSDestroyProjectile_ExceptID:bIsNativeBranchingPointCS() end


---@class UBAN_GSDetachMultipleWeapons : UBAN_GSBase
---@field WeaponIndexList TArray<int32>
---@field DetachmentLocationRule EDetachmentRule
---@field DetachmentRotationRule EDetachmentRule
---@field DetachmentScaleRule EDetachmentRule
---@field IsEnableInteract boolean
---@field DestroyDelayTime float
UBAN_GSDetachMultipleWeapons = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSDetachMultipleWeapons:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSDetachMultipleWeapons:bIsNativeBranchingPointCS() end


---@class UBAN_GSDetachWeapon : UBAN_GSBase
---@field WeaponIndex int32
---@field DetachmentLocationRule EDetachmentRule
---@field DetachmentRotationRule EDetachmentRule
---@field DetachmentScaleRule EDetachmentRule
---@field IsEnableInteract boolean
---@field DestroyDelayTime float
UBAN_GSDetachWeapon = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSDetachWeapon:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSDetachWeapon:bIsNativeBranchingPointCS() end


---@class UBAN_GSEnableAIPerception : UBAN_GSBase
---@field EnableAIPerception boolean
UBAN_GSEnableAIPerception = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSEnableAIPerception:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSEnableAIPerception:bIsNativeBranchingPointCS() end


---@class UBAN_GSEndForcePerformance : UBAN_GSBase
UBAN_GSEndForcePerformance = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSEndForcePerformance:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSEndForcePerformance:bIsNativeBranchingPointCS() end


---@class UBAN_GSFallDyingCheck : UBAN_GSBase
UBAN_GSFallDyingCheck = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSFallDyingCheck:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSFallDyingCheck:bIsNativeBranchingPointCS() end


---@class UBAN_GSFindSceneLocation : UBAN_GSBase
---@field SceneLocationType SceneLocationType
---@field LocationCachedDataId int32
---@field FindSceneItemWay FindSceneItemWay
---@field DistanceWeight float
---@field AngleWeight float
---@field LineTraceWeight float
---@field DistanceCoefficient float
---@field AngleCoefficient float
---@field BestLandingDistance float
---@field EnableSearchDistanceScope boolean
---@field MinSearchDistance float
---@field MaxSearchDistance float
---@field EnableSearchAngleRequirement boolean
---@field RequiredMaxSearchAngle float
UBAN_GSFindSceneLocation = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSFindSceneLocation:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSFindSceneLocation:bIsNativeBranchingPointCS() end


---@class UBAN_GSFinishMedicineTalkAnim : UBAN_GSBase
UBAN_GSFinishMedicineTalkAnim = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSFinishMedicineTalkAnim:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSFinishMedicineTalkAnim:bIsNativeBranchingPointCS() end


---@class UBAN_GSFinishSeedSubmitAnim : UBAN_GSBase
UBAN_GSFinishSeedSubmitAnim = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSFinishSeedSubmitAnim:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSFinishSeedSubmitAnim:bIsNativeBranchingPointCS() end


---@class UBAN_GSGhost : UBAN_GSBase
---@field GhostSettings UBGWDataAsset_GhostActorSetting
---@field MontageToMapTo UAnimMontage
UBAN_GSGhost = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSGhost:GSNotifyCS(NotifyParam) end


---@class UBAN_GSIGuideRebirthFinish : UBAN_GSBase
UBAN_GSIGuideRebirthFinish = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSIGuideRebirthFinish:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSIGuideRebirthFinish:bIsNativeBranchingPointCS() end


---@class UBAN_GSIncreaseChargeLevel : UBAN_GSBase
---@field IncreaseValue int32
UBAN_GSIncreaseChargeLevel = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSIncreaseChargeLevel:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSIncreaseChargeLevel:bIsNativeBranchingPointCS() end


---@class UBAN_GSItemTeleportTrigger : UBAN_GSBase
---@field ItemTeleportType BANItemTeleportType
---@field TargetRebirthPointId int32
UBAN_GSItemTeleportTrigger = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSItemTeleportTrigger:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSItemTeleportTrigger:bIsNativeBranchingPointCS() end


---@class UBAN_GSItemTeleportTriggerPrepare : UBAN_GSBase
UBAN_GSItemTeleportTriggerPrepare = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSItemTeleportTriggerPrepare:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSItemTeleportTriggerPrepare:bIsNativeBranchingPointCS() end


---@class UBAN_GSLaunchCharacter : UBAN_GSBase
---@field LaunchVelocity FVector
---@field bXYOverride boolean
---@field bZOverride boolean
UBAN_GSLaunchCharacter = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSLaunchCharacter:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSLaunchCharacter:bIsNativeBranchingPointCS() end


---@class UBAN_GSMagicallyChange : UBAN_GSBase
---@field MagicallyChangeConfig UBGWDataAsset_MagicallyChangeConfig
---@field MagicallyChangeSkillID int32
---@field RecoverySkillID int32
UBAN_GSMagicallyChange = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSMagicallyChange:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSMagicallyChange:bIsNativeBranchingPointCS() end


---@class UBAN_GSMagicallyChangeFadeOut : UBAN_GSBase
UBAN_GSMagicallyChangeFadeOut = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSMagicallyChangeFadeOut:GSNotifyCS(NotifyParam) end


---@class UBAN_GSMagicallyChangeRecover : UBAN_GSBase
---@field RecoverySkillID int32
UBAN_GSMagicallyChangeRecover = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSMagicallyChangeRecover:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSMagicallyChangeRecover:bIsNativeBranchingPointCS() end


---@class UBAN_GSMontageJumpToSectionByCondition : UBAN_GSBase
---@field JumpSectionConditionType JumpSectionCondition
---@field bJumpImmediately boolean
---@field JumpToSectionName FName
---@field JumpToSectionNameList TArray<FName>
---@field JumpableSectionPrefix FString
UBAN_GSMontageJumpToSectionByCondition = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSMontageJumpToSectionByCondition:GSNotifyCS(NotifyParam) end
---@return EGsEnAnimN
function UBAN_GSMontageJumpToSectionByCondition:GetAnimNType() end
---@return FString
function UBAN_GSMontageJumpToSectionByCondition:GetJumpableSectionPrefix() end
---@return boolean
function UBAN_GSMontageJumpToSectionByCondition:bIsNativeBranchingPointCS() end


---@class UBAN_GSMoveActor : UBAN_GSBase
---@field LocationOffset FVector
---@field RotationOffset FRotator
---@field IsLocalSpace boolean
UBAN_GSMoveActor = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSMoveActor:GSNotifyCS(NotifyParam) end


---@class UBAN_GSNotifyBehaviorGraph : UBAN_GSBase
---@field NotifyTag FString
UBAN_GSNotifyBehaviorGraph = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSNotifyBehaviorGraph:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSNotifyBehaviorGraph:bIsNativeBranchingPointCS() end


---@class UBAN_GSParkourAnimInfo : UBAN_GSBase
---@field AnimForwardMovement float
---@field AnimRightMovement float
---@field AnimUpMovement float
UBAN_GSParkourAnimInfo = {}

---@param Movement FVector
function UBAN_GSParkourAnimInfo:SetAnimMovementValue(Movement) end
---@param NotifyParam FUStGSNotifyParam
function UBAN_GSParkourAnimInfo:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSParkourAnimInfo:bIsNativeBranchingPointCS() end


---@class UBAN_GSParkourLandCanMove : UBAN_GSBase
UBAN_GSParkourLandCanMove = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSParkourLandCanMove:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSParkourLandCanMove:bIsNativeBranchingPointCS() end


---@class UBAN_GSPlayAtkFXOnGround : UBAN_GSBase
---@field AtkFXOnGroundTypeList TArray<AtkFXOnGroundType>
---@field HitFXRadiusMin float
---@field HitFXRadiusMax float
---@field HitFXRadiusExpandTime float
---@field SocketName FName
---@field SlopeSamplingRadiuseRadius float
---@field SurfaceSamplingRadius float
---@field LineTraceHeight float
---@field SkillEffectID int32
---@field EnableCheckThroughWall boolean
UBAN_GSPlayAtkFXOnGround = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSPlayAtkFXOnGround:GSNotifyCS(NotifyParam) end


---@class UBAN_GSPlayBeamFX : UBAN_GSBase
---@field BeamFXSetting FFGSBeamFXPlaySetting
UBAN_GSPlayBeamFX = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSPlayBeamFX:GSNotifyCS(NotifyParam) end
---@return TArray<FSoftObjectPath>
function UBAN_GSPlayBeamFX:GetSoftReferences() end


---@class UBAN_GSPlayCameraSequence : UAnimNotify_GSPlayCameraSequence
UBAN_GSPlayCameraSequence = {}


---@class UBAN_GSPlayCameraShake : UBAN_GSBase
---@field CameraShake TSubclassOf<UMatineeCameraShake>
---@field CamShakeScaleByDistCurve UCurveFloat
---@field EpicenterIsAttach boolean
---@field SocketName FName
---@field bDisableWhenViewTargetIsntPlayer boolean
UBAN_GSPlayCameraShake = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSPlayCameraShake:GSNotifyCS(NotifyParam) end


---@class UBAN_GSPlayDummyAnim : UBAN_GSBase
---@field AnimSeq UAnimSequence
---@field bLoop boolean
---@field DummySKMeshCompTag FName
UBAN_GSPlayDummyAnim = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSPlayDummyAnim:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSPlayDummyAnim:bIsNativeBranchingPointCS() end


---@class UBAN_GSPlayLevelSequence : UBAN_GSBase
---@field SequenceID int32
---@field bUsePlayerCamera boolean
---@field StartTime float
---@field bDisableMovementInput boolean
---@field bDisableLookAtInput boolean
---@field bUseCrane boolean
---@field bUseRail boolean
---@field bHidePlayer boolean
---@field bHideHud boolean
---@field bDisableCameraCuts boolean
UBAN_GSPlayLevelSequence = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSPlayLevelSequence:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSPlayLevelSequence:bIsNativeBranchingPointCS() end


---@class UBAN_GSPlayMappedSoundFX : UBAN_GSBase
---@field EquipPosition EquipPosition
---@field ActionTypeID int32
---@field bIsFollow boolean
---@field SocketName FName
UBAN_GSPlayMappedSoundFX = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSPlayMappedSoundFX:GSNotifyCS(NotifyParam) end


---@class UBAN_GSPlayNiagaraFX : UBAN_GSBase
---@field EditorActive boolean
---@field Template TSoftObjectPtr<UNiagaraSystem>
---@field Duration float
---@field DelayTimeAfterStop float
---@field DestroyTiming DispLibDBCEffectDestroyTiming
---@field OverrideSKMTagName FName
---@field Attached boolean
---@field attachLocationMode EAttachLocation::Type
---@field SocketName FName
---@field offsetInLocaSpace boolean
---@field LocationOffset FVector
---@field RotationOffset FRotator
---@field Scale FVector
---@field SnapGround boolean
---@field SnapGroundRotationMode DispLibDBCSnapGroundRotationMode
---@field ignoreRootBoneScale boolean
---@field SetSelfMeshParam boolean
---@field OverrideSKMBones TArray<FName>
---@field OverrideSKMSockets TArray<FName>
---@field customParams TArray<FGSNiagaraSysParam>
---@field DetachOnEndDispStageBegin boolean
---@field EnableShadow boolean
---@field TranslucentSortPriority int32
---@field PausePriority int32
---@field PauseMode DispLibDBCPauseMode
---@field EndStagePriority int32
---@field ForceChangeVisibleStateDEFPriority int32
---@field ForceVisibleStateDefaultMode DispLibDBCNiagaraForceVisibleStateMode
---@field CompTag FName
---@field ScalabilitySettings FBUC_DispLibDBC_NiagaraEventScalabilitySettings
---@field DBC_IdentityID int32
---@field hasAttachedSocket boolean
UBAN_GSPlayNiagaraFX = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSPlayNiagaraFX:GSNotifyCS(NotifyParam) end
---@return EGsEnAnimN
function UBAN_GSPlayNiagaraFX:GetAnimNType() end
---@return TArray<FSoftObjectPath>
function UBAN_GSPlayNiagaraFX:GetSoftReferences() end


---@class UBAN_GSPlayNiagaraFX_WithCondition : UBAN_GSPlayNiagaraFX
---@field Condition FPlayNiagaraConditions
UBAN_GSPlayNiagaraFX_WithCondition = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSPlayNiagaraFX_WithCondition:GSNotifyCS(NotifyParam) end


---@class UBAN_GSPlaySequence : UBAN_GSBase
---@field LevelSequence TSoftObjectPtr<ULevelSequence>
UBAN_GSPlaySequence = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSPlaySequence:GSNotifyCS(NotifyParam) end
---@return TArray<FSoftObjectPath>
function UBAN_GSPlaySequence:GetSoftReferences() end
---@return boolean
function UBAN_GSPlaySequence:bIsNativeBranchingPointCS() end


---@class UBAN_GSPlayerJump : UBAN_GSBase
UBAN_GSPlayerJump = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSPlayerJump:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSPlayerJump:bIsNativeBranchingPointCS() end


---@class UBAN_GSQTEDecHP : UBAN_GSBase
---@field DecHPPercent float
---@field bIsDecToZero int32
UBAN_GSQTEDecHP = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSQTEDecHP:GSNotifyCS(NotifyParam) end


---@class UBAN_GSQTESceneNotify : UBAN_GSBase
UBAN_GSQTESceneNotify = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSQTESceneNotify:GSNotifyCS(NotifyParam) end


---@class UBAN_GSRagDoll : UBAN_GSBase
UBAN_GSRagDoll = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSRagDoll:GSNotifyCS(NotifyParam) end


---@class UBAN_GSReSetHoldShield : UBAN_GSBase
---@field IsRemove boolean
---@field ABPSetting UBGWDataAsset_AbpHumanoidSetting
---@field PartId int32
UBAN_GSReSetHoldShield = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSReSetHoldShield:GSNotifyCS(NotifyParam) end
---@param Actor AActor
function UBAN_GSReSetHoldShield:GSValidateInputCS(Actor) end
---@return boolean
function UBAN_GSReSetHoldShield:bIsNativeBranchingPointCS() end


---@class UBAN_GSRecreateClothing : UBAN_GSBase
UBAN_GSRecreateClothing = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSRecreateClothing:GSNotifyCS(NotifyParam) end


---@class UBAN_GSRemoveBuffByID : UBAN_GSBase
---@field BuffID int32
---@field BuffLayer int32
---@field WithTriggerRemmoveEffect boolean
UBAN_GSRemoveBuffByID = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSRemoveBuffByID:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSRemoveBuffByID:bIsNativeBranchingPointCS() end


---@class UBAN_GSRemoveSceneItemData : UBAN_GSBase
UBAN_GSRemoveSceneItemData = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSRemoveSceneItemData:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSRemoveSceneItemData:bIsNativeBranchingPointCS() end


---@class UBAN_GSReplaceDropItem : UBAN_GSBase
---@field WeaponIndexList TMap<int32, int32>
---@field ReplacementLocationRule EDetachmentRule
---@field ReplacementRotationRule EDetachmentRule
---@field ReplacementScaleRule EDetachmentRule
UBAN_GSReplaceDropItem = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSReplaceDropItem:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSReplaceDropItem:bIsNativeBranchingPointCS() end


---@class UBAN_GSSetActorScale : UBAN_GSBase
---@field Scale FVector
UBAN_GSSetActorScale = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSSetActorScale:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSSetActorScale:bIsNativeBranchingPointCS() end


---@class UBAN_GSSetCachePoint : UBAN_GSBase
---@field Forward int32
---@field TempDataID int32
UBAN_GSSetCachePoint = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSSetCachePoint:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSSetCachePoint:bIsNativeBranchingPointCS() end


---@class UBAN_GSSetCompVisibility : UBAN_GSBase
---@field ForOwnerActor boolean
---@field ForWeaponActor boolean
---@field CompClass TSubclassOf<UActorComponent>
---@field IsVisible boolean
---@field CompTagName FName
UBAN_GSSetCompVisibility = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSSetCompVisibility:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSSetCompVisibility:bIsNativeBranchingPointCS() end


---@class UBAN_GSSetCustomDepthStencil : UBAN_GSBase
---@field RenderCustomDepth boolean
---@field CustomDepthStencilValue int32
UBAN_GSSetCustomDepthStencil = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSSetCustomDepthStencil:GSNotifyCS(NotifyParam) end


---@class UBAN_GSSetFPStateEnd : UBAN_GSBase
UBAN_GSSetFPStateEnd = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSSetFPStateEnd:GSNotifyCS(NotifyParam) end


---@class UBAN_GSSetSimpleState : UBAN_GSBase
---@field SimpleState EBGUSimpleState
---@field IsRemove boolean
UBAN_GSSetSimpleState = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSSetSimpleState:GSNotifyCS(NotifyParam) end


---@class UBAN_GSSimulatePhysics : UBAN_GSBase
---@field PhysicsSimulateEnable boolean
---@field IncludeChildren boolean
UBAN_GSSimulatePhysics = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSSimulatePhysics:GSNotifyCS(NotifyParam) end


---@class UBAN_GSSpawnLightningActor : UBAN_GSBase
---@field LightningFXActorClass TSubclassOf<ABGULightningFXActorBase>
---@field SocketName FName
---@field NeedAttach boolean
UBAN_GSSpawnLightningActor = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSSpawnLightningActor:GSNotifyCS(NotifyParam) end


---@class UBAN_GSSpawnSceneItem : UBAN_GSBase
---@field SceneItemTag FName
---@field SocketName FName
UBAN_GSSpawnSceneItem = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSSpawnSceneItem:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSSpawnSceneItem:bIsNativeBranchingPointCS() end


---@class UBAN_GSSpawnStaticMeshActor : UBAN_GSBase
---@field bAttachToOwner boolean
---@field StaticMeshActorSetting UBGWDataAsset_StaticMeshActorSetting
UBAN_GSSpawnStaticMeshActor = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSSpawnStaticMeshActor:GSNotifyCS(NotifyParam) end


---@class UBAN_GSSplineFlyMove : UBAN_GSBase
---@field bEnableSplineFlyMove boolean
---@field SpeedRateType EAIMoveSpeedType
---@field TraceVelocityCameraSpeedRate float
---@field SplineActorTag FName
UBAN_GSSplineFlyMove = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSSplineFlyMove:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSSplineFlyMove:bIsNativeBranchingPointCS() end


---@class UBAN_GSStopInteractTargetIdleFX : UBAN_GSBase
UBAN_GSStopInteractTargetIdleFX = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSStopInteractTargetIdleFX:GSNotifyCS(NotifyParam) end


---@class UBAN_GSSummonUnit : UBAN_GSBase
---@field SummonID int32
---@field SummonPointIndex int32
---@field Command FString
UBAN_GSSummonUnit = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSSummonUnit:GSNotifyCS(NotifyParam) end


---@class UBAN_GSSwitchMovementMode : UBAN_GSBase
---@field MovementMode EMovementMode
UBAN_GSSwitchMovementMode = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSSwitchMovementMode:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSSwitchMovementMode:bIsNativeBranchingPointCS() end


---@class UBAN_GSTriggerChargeSkill : UBAN_GSBase
---@field ChargeTimeMax float
---@field ChargeTimeMin float
---@field Command FString
UBAN_GSTriggerChargeSkill = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSTriggerChargeSkill:GSNotifyCS(NotifyParam) end
---@param Actor AActor
function UBAN_GSTriggerChargeSkill:GSValidateInputCS(Actor) end
---@return boolean
function UBAN_GSTriggerChargeSkill:bIsNativeBranchingPointCS() end


---@class UBAN_GSTriggerCostItem : UBAN_GSBase
---@field UseHulu boolean
UBAN_GSTriggerCostItem = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSTriggerCostItem:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSTriggerCostItem:bIsNativeBranchingPointCS() end


---@class UBAN_GSTriggerEffect : UBAN_GSBase
---@field EffectID int32
---@field TargetType EANTriggerEffectTargetType
---@field Command FString
UBAN_GSTriggerEffect = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSTriggerEffect:GSNotifyCS(NotifyParam) end
---@param Actor AActor
function UBAN_GSTriggerEffect:GSValidateInputCS(Actor) end
---@return boolean
function UBAN_GSTriggerEffect:bIsNativeBranchingPointCS() end


---@class UBAN_GSTriggerSplineMoveDBC : UBAN_GSBase
UBAN_GSTriggerSplineMoveDBC = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSTriggerSplineMoveDBC:GSNotifyCS(NotifyParam) end


---@class UBAN_GSTriggerWinePartner : UBAN_GSBase
---@field TriggerId int32
UBAN_GSTriggerWinePartner = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSTriggerWinePartner:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSTriggerWinePartner:bIsNativeBranchingPointCS() end


---@class UBAN_GSTryAttachSceneItem : UBAN_GSBase
---@field AttachSocketName FName
UBAN_GSTryAttachSceneItem = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSTryAttachSceneItem:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSTryAttachSceneItem:bIsNativeBranchingPointCS() end


---@class UBAN_GSTryFindSceneItem : UBAN_GSBase
---@field SceneActorTags TArray<FName>
---@field MinDistance float
---@field MaxDistance float
---@field FindSceneItemWay FindSceneItemWay
---@field Angle float
---@field NeedRemoveCurrentCatch boolean
---@field EnableDrawDebug boolean
UBAN_GSTryFindSceneItem = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSTryFindSceneItem:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSTryFindSceneItem:bIsNativeBranchingPointCS() end


---@class UBAN_GSTryHRCounterattack : UBAN_GSBase
UBAN_GSTryHRCounterattack = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GSTryHRCounterattack:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_GSTryHRCounterattack:bIsNativeBranchingPointCS() end


---@class UBAN_GainItem : UBAN_GSBase
---@field ItemId int32
UBAN_GainItem = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_GainItem:GSNotifyCS(NotifyParam) end


---@class UBAN_HandleAiConversation : UBAN_GSBase
---@field ConversationContentIDList TArray<int32>
---@field UseInteractTemplete boolean
UBAN_HandleAiConversation = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_HandleAiConversation:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_HandleAiConversation:bIsNativeBranchingPointCS() end


---@class UBAN_InteractTriggerFinish : UBAN_GSBase
UBAN_InteractTriggerFinish = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_InteractTriggerFinish:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_InteractTriggerFinish:bIsNativeBranchingPointCS() end


---@class UBAN_PlayDBCWithTargetInfo : UBAN_GSBase
---@field DBCOwnerType EANTriggerEffectTargetType
---@field MinorTargetType EANTriggerEffectTargetType
---@field DBC UBGWDataAsset
UBAN_PlayDBCWithTargetInfo = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_PlayDBCWithTargetInfo:GSNotifyCS(NotifyParam) end


---@class UBAN_ShowCommTips : UBAN_GSBase
---@field UIWordID int32
UBAN_ShowCommTips = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_ShowCommTips:GSNotifyCS(NotifyParam) end


---@class UBAN_ShowMapTips : UBAN_GSBase
---@field UIWordID int32
UBAN_ShowMapTips = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_ShowMapTips:GSNotifyCS(NotifyParam) end


---@class UBAN_ShowShrineMain : UBAN_GSBase
UBAN_ShowShrineMain = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_ShowShrineMain:GSNotifyCS(NotifyParam) end


---@class UBAN_SkillValidAttackEnded : UBAN_GSBase
UBAN_SkillValidAttackEnded = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_SkillValidAttackEnded:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_SkillValidAttackEnded:bIsNativeBranchingPointCS() end


---@class UBAN_SpawnLightningFXActor : UBAN_GSBase
---@field Template TSoftClassPtr<ABGULightningFXActorBase>
---@field SocketNameList TArray<FName>
---@field LocationRule EAttachmentRule
---@field RotationRule EAttachmentRule
---@field ScaleRule EAttachmentRule
---@field GetPointsType PointsGenType
---@field EQSReqID int32
UBAN_SpawnLightningFXActor = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_SpawnLightningFXActor:GSNotifyCS(NotifyParam) end
---@return TArray<FSoftObjectPath>
function UBAN_SpawnLightningFXActor:GetSoftReferences() end


---@class UBAN_SpawnLightningFXActor_MultiSockets : UBAN_GSBase
---@field Template TSubclassOf<ABGULightningFXActorBase>
---@field SocketNameList TArray<FName>
---@field LocationRule EAttachmentRule
---@field RotationRule EAttachmentRule
---@field ScaleRule EAttachmentRule
---@field EQSReqID int32
UBAN_SpawnLightningFXActor_MultiSockets = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_SpawnLightningFXActor_MultiSockets:GSNotifyCS(NotifyParam) end


---@class UBAN_Suicide : UBAN_GSBase
UBAN_Suicide = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_Suicide:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_Suicide:bIsNativeBranchingPointCS() end


---@class UBAN_SwitchTransSpellSolution : UAnimNotify_GSBase
---@field SolutionID int32
UBAN_SwitchTransSpellSolution = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_SwitchTransSpellSolution:GSNotifyCS(NotifyParam) end
---@return FString
function UBAN_SwitchTransSpellSolution:GetNotifyName() end
---@return boolean
function UBAN_SwitchTransSpellSolution:bIsNativeBranchingPointCS() end


---@class UBAN_TeleportPlayerTo : UBAN_GSBase
---@field TeleportPointName FString
---@field ResetCamera boolean
---@field ControlRot FRotator
UBAN_TeleportPlayerTo = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_TeleportPlayerTo:GSNotifyCS(NotifyParam) end
---@return boolean
function UBAN_TeleportPlayerTo:bIsNativeBranchingPointCS() end


---@class UBAN_X2_PlayDBCDataAsset : UBAN_GSBase
---@field Play boolean
---@field DataAsset UBUC_DispLibDispBaseConfigDataAsset
---@field PlayByDispWorld boolean
---@field MainSockNameIfDW FName
---@field DBC_Main DispLibDBCAnimNotifyTarget
---@field DBC_Minor DispLibDBCAnimNotifyTarget
---@field StopIfTargetNull boolean
UBAN_X2_PlayDBCDataAsset = {}

---@param NotifyParam FUStGSNotifyParam
function UBAN_X2_PlayDBCDataAsset:GSNotifyCS(NotifyParam) end


---@class UBARootMotionMove : UBasicActionBase
---@field ReqMoveToLoc UAIReqMoveToLoc
UBARootMotionMove = {}



---@class UBATraceMove : UBasicActionBase
---@field ReqMoveToActor UAIReqMoveToActor
UBATraceMove = {}



---@class UBED_BehaviorAsset : UBED_CalliopeAssetBase
UBED_BehaviorAsset = {}

---@return ECalliopeViewType
function UBED_BehaviorAsset:GetViewType() end
---@return UClass
function UBED_BehaviorAsset:GetStartNodeClass() end
---@return UClass
function UBED_BehaviorAsset:GetRerouteNodeClass() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_BehaviorAsset:GetExtraDefaultInputNodes(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_BehaviorAsset:GetExtraDefaultOutputNodes(OutClasses) end
---@return UClass
function UBED_BehaviorAsset:GetStartNodeClassInBranchGraph() end
---@return UClass
function UBED_BehaviorAsset:GetRerouteNodeClassInBranchGraph() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_BehaviorAsset:GetExtraDefaultInputNodesInBranchGraph(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_BehaviorAsset:GetExtraDefaultOutputNodesInBranchGraph(OutClasses) end


---@class UBED_BehaviorNode : UBED_CalliopeNodeBae
UBED_BehaviorNode = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode:IsSupportViewType(InViewType) end


---@class UBED_BehaviorNode_AMNotify : UBED_BehaviorNode_ListenerTrigger
---@field UnitType DetectedUnitType
---@field SmartUnit FGsSmartParam
---@field NotifyTag FString
UBED_BehaviorNode_AMNotify = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_AMNotify:IsSupportViewType(InViewType) end
---@return FString
function UBED_BehaviorNode_AMNotify:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_Action : UBED_BehaviorNode
UBED_BehaviorNode_Action = {}


---@class UBED_BehaviorNode_AddBuff : UBED_BehaviorNode_Action
---@field BuffID int32
---@field BuffLayer int32
---@field BuffDuration int32
UBED_BehaviorNode_AddBuff = {}

---@return FString
function UBED_BehaviorNode_AddBuff:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_AiConversation : UBED_BehaviorNode_Action
---@field AiConversationContentIDList TArray<int32>
UBED_BehaviorNode_AiConversation = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_AiConversation:IsSupportViewType(InViewType) end
function UBED_BehaviorNode_AiConversation:OnRefreshAssetInCS() end
---@return FString
function UBED_BehaviorNode_AiConversation:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_BeAttackedNumFromSkill : UBED_BehaviorNode_ListenerTrigger
---@field UnitType DetectedUnitType
---@field SmartUnit FGsSmartParam
---@field SkillID int32
---@field CompareOperationType ValueCompareOperationType
---@field BeHittedNum int32
---@field TimeDuration float
UBED_BehaviorNode_BeAttackedNumFromSkill = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_BeAttackedNumFromSkill:IsSupportViewType(InViewType) end
---@return FString
function UBED_BehaviorNode_BeAttackedNumFromSkill:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_BeAttackedNumFromSkillEffect : UBED_BehaviorNode_ListenerTrigger
---@field UnitType DetectedUnitType
---@field SmartUnit FGsSmartParam
---@field SkillEffectID int32
---@field CompareOperationType ValueCompareOperationType
---@field BeHittedNum int32
---@field TimeDuration float
UBED_BehaviorNode_BeAttackedNumFromSkillEffect = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_BeAttackedNumFromSkillEffect:IsSupportViewType(InViewType) end
---@return FString
function UBED_BehaviorNode_BeAttackedNumFromSkillEffect:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_BeHurt : UBED_BehaviorNode_ListenerTrigger
---@field UnitType DetectedUnitType
---@field SmartUnit FGsSmartParam
---@field CompareOperationType ValueCompareOperationType
---@field DmgValue int32
---@field UnitType_Attacker DetectedUnitType
---@field SmartUnit_Attacker FGsSmartParam
UBED_BehaviorNode_BeHurt = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_BeHurt:IsSupportViewType(InViewType) end
---@return FString
function UBED_BehaviorNode_BeHurt:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_BeKilled : UBED_BehaviorNode_ListenerTrigger
---@field UnitType_Victim DetectedUnitType
---@field SmartUnit_Victim FGsSmartParam
---@field UnitType_Attacker DetectedUnitType
---@field SmartUnit_Attacker FGsSmartParam
UBED_BehaviorNode_BeKilled = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_BeKilled:IsSupportViewType(InViewType) end
---@return FString
function UBED_BehaviorNode_BeKilled:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_CastSkill : UBED_BehaviorNode_Action
---@field SkillID int32
---@field NeedCheckSkillCanCast boolean
---@field MontageStartSectionName FName
---@field bCanCastWhenDead boolean
UBED_BehaviorNode_CastSkill = {}

---@return FString
function UBED_BehaviorNode_CastSkill:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_CastSkillByScore : UBED_BehaviorNode_Action
---@field SkillInfoList TArray<FFCBGCastSkillInfo>
---@field IsGetTopRandomSkill boolean
---@field TopRandomSkillPercent int32
---@field NeedTryCastAllSkillUntilSuccess boolean
UBED_BehaviorNode_CastSkillByScore = {}

---@return FString
function UBED_BehaviorNode_CastSkillByScore:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_Combo : UBED_BehaviorNode_Action
---@field ComboTargetType ComboTargetType
---@field SkillSourceType ZatoichiSkillSourceType
---@field PursuitInAllSkill boolean
---@field PursuitAnyWhere boolean
---@field ForceCastSkillAfterPursuitFailed boolean
---@field PursuitRangePos float
---@field SpeedRateType EAIMoveSpeedType
---@field MotionMatchingMoveMode State_MM
---@field MoveAIType EBGUMoveAIType
---@field MoveAcceptableRadiusType EBGUMoveAcceptableRadiusType
---@field BeginRotateAngle float
---@field IsUseSkillForTurn boolean
---@field IsUseSkillForMove boolean
---@field BeginMoveDistanceWhenUseSkill float
---@field EnableInterruptReduceCBNum boolean
---@field NeedTraceHitTargetBefore boolean
---@field EnableForceComboRelation boolean
---@field EnableComboCondition boolean
---@field TraceDistance float
---@field TraceTypeQuery ETraceTypeQuery
---@field IsGetTopRandomSkill boolean
---@field TopRandomSkillPercent int32
---@field SkillArray TArray<FComboSkill>
---@field IsGetAdvanceComboLength boolean
---@field ComboSkillNumInfo TArray<FComboSkillNumInfo>
---@field IsCanBeForceAbort boolean
---@field UseSocketDirection boolean
---@field DirectionBaseSocket FName
---@field ForwardSocket FName
---@field RightSocket FName
---@field SkillConfigMode EscapeSkillConfigMode
---@field SingleDirectionSkills TArray<int32>
---@field AvoidObstacleSectionNum int32
---@field SectionsStartAngle float
---@field IntervalAngle float
---@field AvoidObstacleSections TArray<FAvoidObstacleSection>
UBED_BehaviorNode_Combo = {}



---@class UBED_BehaviorNode_Condition : UBED_BehaviorNode
---@field bReverseCondition boolean
---@field ConditionCoolDownTimeMs int32
UBED_BehaviorNode_Condition = {}



---@class UBED_BehaviorNode_ControlChildActor : UBED_BehaviorNode_Action
---@field MatchInfo FTamerFamilyMatchChildInfo
---@field ActionInfo FChildActorActionInfo
UBED_BehaviorNode_ControlChildActor = {}

---@return FString
function UBED_BehaviorNode_ControlChildActor:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_Desc : UBED_BehaviorNode
UBED_BehaviorNode_Desc = {}


---@class UBED_BehaviorNode_DetectEnvironment : UBED_BehaviorNode_Condition
UBED_BehaviorNode_DetectEnvironment = {}


---@class UBED_BehaviorNode_DetectExclusiveItemState : UBED_BehaviorNode_Condition
---@field ActorTag FGameplayTag
---@field StateTags FGameplayTagContainer
UBED_BehaviorNode_DetectExclusiveItemState = {}

---@return FString
function UBED_BehaviorNode_DetectExclusiveItemState:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_DetectForce : UBED_BehaviorNode_Condition
---@field ForceType DetectedForceType
---@field bDetectUnit boolean
---@field bDetectBullet boolean
---@field bDetectMagicField boolean
---@field Conditions TArray<FDetectCondition>
---@field SuccessCount int32
UBED_BehaviorNode_DetectForce = {}

---@return FString
function UBED_BehaviorNode_DetectForce:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_DetectUnit : UBED_BehaviorNode_Condition
---@field UnitType DetectedUnitType
---@field SmartUnit FGsSmartParam
---@field Conditions TArray<FDetectCondition>
---@field ConditionalRelation ConditionalRelation
UBED_BehaviorNode_DetectUnit = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_DetectUnit:IsSupportViewType(InViewType) end
---@return FString
function UBED_BehaviorNode_DetectUnit:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_DetectUnitOnce : UBED_BehaviorNode
---@field UnitType DetectedUnitType
---@field SmartUnit FGsSmartParam
---@field Conditions TArray<FDetectCondition>
---@field ConditionalRelation ConditionalRelation
---@field bReverseCondition boolean
UBED_BehaviorNode_DetectUnitOnce = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_DetectUnitOnce:IsSupportViewType(InViewType) end
---@return FString
function UBED_BehaviorNode_DetectUnitOnce:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_EnterState : UBED_BehaviorNode
---@field StateTag FGameplayTag
UBED_BehaviorNode_EnterState = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_EnterState:IsSupportViewType(InViewType) end
---@return FString
function UBED_BehaviorNode_EnterState:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_ExitPhasePerformance : UBED_BehaviorNode_Action
UBED_BehaviorNode_ExitPhasePerformance = {}

---@return FString
function UBED_BehaviorNode_ExitPhasePerformance:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_ExitState : UBED_BehaviorNode
---@field StateTag FGameplayTag
UBED_BehaviorNode_ExitState = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_ExitState:IsSupportViewType(InViewType) end
---@return FString
function UBED_BehaviorNode_ExitState:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_GameDataCounter : UBED_BehaviorNode
---@field UnitType DetectedUnitType
---@field CounterType GameplayCounterType
---@field CounterValue float
UBED_BehaviorNode_GameDataCounter = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_GameDataCounter:IsSupportViewType(InViewType) end


---@class UBED_BehaviorNode_GenAndCachePointSet : UBED_BehaviorNode_Action
---@field RegisterID int32
---@field GenType PointsGenType
---@field GenExtParam FPointsGenExtParam
UBED_BehaviorNode_GenAndCachePointSet = {}

---@return FString
function UBED_BehaviorNode_GenAndCachePointSet:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_HandleBattleMessage : UBED_BehaviorNode_Action
---@field BattleMessage FGameplayTag
UBED_BehaviorNode_HandleBattleMessage = {}



---@class UBED_BehaviorNode_ListenerTrigger : UBED_BehaviorNode
UBED_BehaviorNode_ListenerTrigger = {}


---@class UBED_BehaviorNode_Log : UBED_BehaviorNode_Action
---@field LogString FString
---@field LogTime int32
UBED_BehaviorNode_Log = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_Log:IsSupportViewType(InViewType) end


---@class UBED_BehaviorNode_LogicalAnd : UBED_BehaviorNode
UBED_BehaviorNode_LogicalAnd = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_LogicalAnd:IsSupportViewType(InViewType) end
---@return boolean
function UBED_BehaviorNode_LogicalAnd:CanUserAddInputInCS() end


---@class UBED_BehaviorNode_LogicalOr : UBED_BehaviorNode
UBED_BehaviorNode_LogicalOr = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_LogicalOr:IsSupportViewType(InViewType) end
---@return boolean
function UBED_BehaviorNode_LogicalOr:CanUserAddInputInCS() end


---@class UBED_BehaviorNode_MulticastCachedPointSet : UBED_BehaviorNode_Action
---@field RequestID int32
UBED_BehaviorNode_MulticastCachedPointSet = {}

---@return FString
function UBED_BehaviorNode_MulticastCachedPointSet:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_NotifyExclusiveItem : UBED_BehaviorNode_Action
---@field ActorTag FGameplayTag
---@field NotifyTag FGameplayTag
UBED_BehaviorNode_NotifyExclusiveItem = {}

---@return FString
function UBED_BehaviorNode_NotifyExclusiveItem:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_OnAllSummonBeKilled : UBED_BehaviorNode_ListenerTrigger
---@field UnitType DetectedUnitType
---@field SmartUnit FGsSmartParam
---@field SummonIDList TArray<int32>
UBED_BehaviorNode_OnAllSummonBeKilled = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_OnAllSummonBeKilled:IsSupportViewType(InViewType) end
---@return FString
function UBED_BehaviorNode_OnAllSummonBeKilled:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_OnSkillValidAttackFrameEnded : UBED_BehaviorNode_ListenerTrigger
---@field UnitType DetectedUnitType
---@field SmartUnit FGsSmartParam
---@field SkillID int32
UBED_BehaviorNode_OnSkillValidAttackFrameEnded = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_OnSkillValidAttackFrameEnded:IsSupportViewType(InViewType) end
---@return FString
function UBED_BehaviorNode_OnSkillValidAttackFrameEnded:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_OnTrigerFSMEvent : UBED_BehaviorNode
---@field EventTag FGameplayTag
UBED_BehaviorNode_OnTrigerFSMEvent = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_OnTrigerFSMEvent:IsSupportViewType(InViewType) end


---@class UBED_BehaviorNode_OnUnitTrans : UBED_BehaviorNode_ListenerTrigger
---@field UnitType DetectedUnitType
---@field SmartUnit FGsSmartParam
---@field TransType PlayerTransEndType
UBED_BehaviorNode_OnUnitTrans = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_OnUnitTrans:IsSupportViewType(InViewType) end
---@return FString
function UBED_BehaviorNode_OnUnitTrans:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_PlayLevelSeq : UBED_BehaviorNode_Action
---@field SequenceID int32
---@field UsePlayerCamera boolean
---@field StartTime float
---@field IsDisableMovementInput boolean
---@field IsDisableLookAtInput boolean
---@field IsHideHud boolean
---@field IsDisableCameraCuts boolean
UBED_BehaviorNode_PlayLevelSeq = {}

---@return FString
function UBED_BehaviorNode_PlayLevelSeq:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_PlayPigsyStory : UBED_BehaviorNode_Action
UBED_BehaviorNode_PlayPigsyStory = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_PlayPigsyStory:IsSupportViewType(InViewType) end


---@class UBED_BehaviorNode_Random : UBED_BehaviorNode
---@field SuccessRate float
---@field bReverseCondition boolean
UBED_BehaviorNode_Random = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_Random:IsSupportViewType(InViewType) end
---@return FString
function UBED_BehaviorNode_Random:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_RemoveBuff : UBED_BehaviorNode_Action
---@field BuffID int32
---@field BuffLayer int32
---@field bTriggerRemoveEffect boolean
UBED_BehaviorNode_RemoveBuff = {}

---@return FString
function UBED_BehaviorNode_RemoveBuff:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_Sequence : UBED_BehaviorNode
UBED_BehaviorNode_Sequence = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_Sequence:IsSupportViewType(InViewType) end
---@return boolean
function UBED_BehaviorNode_Sequence:CanUserAddOutputInCS() end


---@class UBED_BehaviorNode_SimpleState : UBED_BehaviorNode_Action
---@field SimpleState EBGUSimpleState
---@field bAdd boolean
UBED_BehaviorNode_SimpleState = {}

---@return FString
function UBED_BehaviorNode_SimpleState:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_Start : UBED_BehaviorNode
UBED_BehaviorNode_Start = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_Start:IsSupportViewType(InViewType) end


---@class UBED_BehaviorNode_TriggerAttackStiff : UBED_BehaviorNode_ListenerTrigger
---@field UnitType DetectedUnitType
---@field SmartUnit FGsSmartParam
---@field CompareOperationType ValueCompareOperationType
---@field StiffLevel int32
---@field UnitType_Attacker DetectedUnitType
---@field SmartUnit_Attacker FGsSmartParam
UBED_BehaviorNode_TriggerAttackStiff = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_TriggerAttackStiff:IsSupportViewType(InViewType) end
---@return FString
function UBED_BehaviorNode_TriggerAttackStiff:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_TriggerAttackStiff_ListenAttacker : UBED_BehaviorNode_ListenerTrigger
---@field UnitType DetectedUnitType
---@field SmartUnit FGsSmartParam
---@field CompareOperationType ValueCompareOperationType
---@field StiffLevel int32
---@field UnitType_Victim DetectedUnitType
---@field SmartUnit_Victim FGsSmartParam
UBED_BehaviorNode_TriggerAttackStiff_ListenAttacker = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_TriggerAttackStiff_ListenAttacker:IsSupportViewType(InViewType) end
---@return FString
function UBED_BehaviorNode_TriggerAttackStiff_ListenAttacker:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_TriggerSkillEffect : UBED_BehaviorNode_Action
---@field EffectID int32
UBED_BehaviorNode_TriggerSkillEffect = {}

---@return FString
function UBED_BehaviorNode_TriggerSkillEffect:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_UnitStateTrigger : UBED_BehaviorNode_Action
---@field UnitStateTrigger EBUStateTrigger
---@field Time float
UBED_BehaviorNode_UnitStateTrigger = {}

---@return FString
function UBED_BehaviorNode_UnitStateTrigger:GetNodeDescriptionInCS() end


---@class UBED_BehaviorNode_WeightRandom : UBED_BehaviorNode
---@field Weights TArray<FWeightConfig>
UBED_BehaviorNode_WeightRandom = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_BehaviorNode_WeightRandom:IsSupportViewType(InViewType) end
function UBED_BehaviorNode_WeightRandom:OnRefreshAssetInCS() end
---@return TArray<FName>
function UBED_BehaviorNode_WeightRandom:GetContextOutputsInCS() end


---@class UBED_Behavior_CheckCurrentCastSkillId : UBED_BehaviorNode
---@field SkillIds TArray<int32>
UBED_Behavior_CheckCurrentCastSkillId = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_Behavior_CheckCurrentCastSkillId:PostPropertyChanged(MemberName, PropertyName) end


---@class UBED_CalliopeAssetBase : UCalliopeAsset
UBED_CalliopeAssetBase = {}

---@param InActor AActor
---@param OutActorGuid FString
---@return boolean
function UBED_CalliopeAssetBase:GetActorGuid(InActor, OutActorGuid) end
---@return boolean
function UBED_CalliopeAssetBase:CanManageStates() end
---@return TArray<UBED_QuestNode_SubGraph>
function UBED_CalliopeAssetBase:GetSubGraphNodes() end
---@return boolean
function UBED_CalliopeAssetBase:ExportDataByExtern() end
---@param PropertyName FString
---@param OutOptions TArray<FActorGuidOption>
---@return int32
function UBED_CalliopeAssetBase:GetActorGuidOptions(PropertyName, OutOptions) end
---@return TArray<UBED_QuestNode_ObserveByCondition>
function UBED_CalliopeAssetBase:GetObserveActorNodes() end
---@param InGuid FCalliopeGuid
---@return UCalliopeNode
function UBED_CalliopeAssetBase:GetNode(InGuid) end
---@return TMap<FCalliopeGuid, UCalliopeNode>
function UBED_CalliopeAssetBase:GetNodes() end
---@return ECalliopeViewType
function UBED_CalliopeAssetBase:GetViewType() end
---@param NewGuid FCalliopeGuid
---@param NewNode UCalliopeNode
function UBED_CalliopeAssetBase:RegisterNode(NewGuid, NewNode) end
---@return boolean
function UBED_CalliopeAssetBase:ExportToData() end
---@param NodeGuid FCalliopeGuid
function UBED_CalliopeAssetBase:UnregisterNode(NodeGuid) end
---@param Node UCalliopeNode
function UBED_CalliopeAssetBase:OnNodeActivate(Node) end
---@return TArray<FName>
function UBED_CalliopeAssetBase:GetCustomInputs() end
---@param Node UCalliopeNode
function UBED_CalliopeAssetBase:OnNodeDeactivate(Node) end
---@return TArray<FName>
function UBED_CalliopeAssetBase:GetCustomOutputs() end
---@return UClass
function UBED_CalliopeAssetBase:GetStartNodeClass() end
function UBED_CalliopeAssetBase:PreFinishInstance() end
function UBED_CalliopeAssetBase:PostStartInstance() end
---@param MemberName FString
---@param PropertyName FString
function UBED_CalliopeAssetBase:OnPropertyChanged(MemberName, PropertyName) end
---@param bDuplicateForPIE boolean
function UBED_CalliopeAssetBase:PostDuplicateInCS(bDuplicateForPIE) end
---@return UClass
function UBED_CalliopeAssetBase:GetRerouteNodeClass() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_CalliopeAssetBase:GetExtraDefaultInputNodes(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_CalliopeAssetBase:GetExtraDefaultOutputNodes(OutClasses) end
---@return UClass
function UBED_CalliopeAssetBase:GetStartNodeClassInBranchGraph() end
---@return UClass
function UBED_CalliopeAssetBase:GetRerouteNodeClassInBranchGraph() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_CalliopeAssetBase:GetExtraDefaultInputNodesInBranchGraph(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_CalliopeAssetBase:GetExtraDefaultOutputNodesInBranchGraph(OutClasses) end


---@class UBED_CalliopeInteractor : UCalliopeInteractor
UBED_CalliopeInteractor = {}

---@param OutClasses TArray<UClass>
---@return int32
function UBED_CalliopeInteractor:GetStartNodeClasses(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_CalliopeInteractor:GetFinishNodeClasses(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_CalliopeInteractor:GetRerouteNodeClasses(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_CalliopeInteractor:GetSubGraphNodeClasses(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_CalliopeInteractor:GetCustomInputNodeClasses(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_CalliopeInteractor:GetCustomOutputNodeClasses(OutClasses) end
---@param Node UCalliopeNode
---@param InEventName FName
---@return boolean
function UBED_CalliopeInteractor:SetCustomInputNodeEventName(Node, InEventName) end
---@param Node UCalliopeNode
---@param OutEventName FName
---@return boolean
function UBED_CalliopeInteractor:GetCustomInputNodeEventName(Node, OutEventName) end
---@param Node UCalliopeNode
---@param InEventName FName
---@return boolean
function UBED_CalliopeInteractor:SetCustomOutputNodeEventName(Node, InEventName) end
---@param Node UCalliopeNode
---@param OutEventName FName
---@return boolean
function UBED_CalliopeInteractor:GetCustomOutputNodeEventName(Node, OutEventName) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_CalliopeInteractor:GetComponentObserverNodeClasses(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_CalliopeInteractor:GetExecutionSequenceNodeClasses(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_CalliopeInteractor:GetExecutionMultiGateNodeClasses(OutClasses) end


---@class UBED_CalliopeNodeBae : UCalliopeNode
UBED_CalliopeNodeBae = {}

---@param InActor AActor
---@param OutActorGuid FString
---@return boolean
function UBED_CalliopeNodeBae:GetActorGuid(InActor, OutActorGuid) end
---@return boolean
function UBED_CalliopeNodeBae:CanManageStates() end
---@param PropertyName FString
---@param OutOptions TArray<FActorGuidOption>
---@return int32
function UBED_CalliopeNodeBae:GetActorGuidOptions(PropertyName, OutOptions) end
---@return FCalliopeGuid
function UBED_CalliopeNodeBae:GetGuid() end
---@param InViewType ECalliopeViewType
---@return boolean
function UBED_CalliopeNodeBae:IsSupportViewType(InViewType) end
---@return boolean
function UBED_CalliopeNodeBae:IsBranchGraphNode() end
---@param OutBranchGraphIdentifier FString
---@return boolean
function UBED_CalliopeNodeBae:GetBranchGraphToEditInCS(OutBranchGraphIdentifier) end


---@class UBED_ComboAsset : UBED_CalliopeAssetBase
UBED_ComboAsset = {}

---@return ECalliopeViewType
function UBED_ComboAsset:GetViewType() end
---@return UClass
function UBED_ComboAsset:GetStartNodeClass() end
---@return UClass
function UBED_ComboAsset:GetRerouteNodeClass() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_ComboAsset:GetExtraDefaultInputNodes(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_ComboAsset:GetExtraDefaultOutputNodes(OutClasses) end
---@return UClass
function UBED_ComboAsset:GetStartNodeClassInBranchGraph() end
---@return UClass
function UBED_ComboAsset:GetRerouteNodeClassInBranchGraph() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_ComboAsset:GetExtraDefaultInputNodesInBranchGraph(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_ComboAsset:GetExtraDefaultOutputNodesInBranchGraph(OutClasses) end


---@class UBED_ComboNode : UBED_CalliopeNodeBae
UBED_ComboNode = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_ComboNode:IsSupportViewType(InViewType) end


---@class UBED_ComboNode_Condition : UBED_ComboNode
---@field ComboConditions TArray<FComboCondition>
UBED_ComboNode_Condition = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_ComboNode_Condition:PostPropertyChanged(MemberName, PropertyName) end
---@return TArray<FName>
function UBED_ComboNode_Condition:GetContextOutputsInCS() end


---@class UBED_ComboNode_Idle : UBED_ComboNode_State
UBED_ComboNode_Idle = {}


---@class UBED_ComboNode_Reroute : UBED_ComboNode
UBED_ComboNode_Reroute = {}


---@class UBED_ComboNode_Restart : UBED_ComboNode_State
UBED_ComboNode_Restart = {}

---@return TArray<FName>
function UBED_ComboNode_Restart:GetContextInputsInCS() end
---@return TArray<FName>
function UBED_ComboNode_Restart:GetContextOutputsInCS() end


---@class UBED_ComboNode_Skill : UBED_ComboNode_State
---@field SkillID int32
---@field SkillMappingRuleIDList TArray<int32>
UBED_ComboNode_Skill = {}

---@return FString
function UBED_ComboNode_Skill:GetNodeDescriptionInCS() end


---@class UBED_ComboNode_Start : UBED_ComboNode
---@field ComboConditions TArray<FComboCondition>
UBED_ComboNode_Start = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_ComboNode_Start:PostPropertyChanged(MemberName, PropertyName) end
---@return TArray<FName>
function UBED_ComboNode_Start:GetContextOutputsInCS() end


---@class UBED_ComboNode_State : UBED_ComboNode
---@field OptionalPins TMap<FName, boolean>
UBED_ComboNode_State = {}

function UBED_ComboNode_State:PostLoadInCS() end
---@param MemberName FString
---@param PropertyName FString
function UBED_ComboNode_State:PostPropertyChanged(MemberName, PropertyName) end
---@return TArray<FName>
function UBED_ComboNode_State:GetContextOutputsInCS() end


---@class UBED_DialogueAsset : UBED_CalliopeAssetBase
UBED_DialogueAsset = {}

---@return ECalliopeViewType
function UBED_DialogueAsset:GetViewType() end
---@return UClass
function UBED_DialogueAsset:GetStartNodeClass() end
---@return UClass
function UBED_DialogueAsset:GetRerouteNodeClass() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_DialogueAsset:GetExtraDefaultInputNodes(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_DialogueAsset:GetExtraDefaultOutputNodes(OutClasses) end
---@return UClass
function UBED_DialogueAsset:GetStartNodeClassInBranchGraph() end
---@return UClass
function UBED_DialogueAsset:GetRerouteNodeClassInBranchGraph() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_DialogueAsset:GetExtraDefaultInputNodesInBranchGraph(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_DialogueAsset:GetExtraDefaultOutputNodesInBranchGraph(OutClasses) end


---@class UBED_DialogueNode_OnPlayerApproached : UBED_BehaviorNode_ListenerTrigger
---@field ResID int32
UBED_DialogueNode_OnPlayerApproached = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_DialogueNode_OnPlayerApproached:IsSupportViewType(InViewType) end
---@return FString
function UBED_DialogueNode_OnPlayerApproached:GetNodeDescriptionInCS() end


---@class UBED_FSMAsset : UBED_CalliopeAssetBase
UBED_FSMAsset = {}

---@return ECalliopeViewType
function UBED_FSMAsset:GetViewType() end
---@return UClass
function UBED_FSMAsset:GetStartNodeClass() end
---@return UClass
function UBED_FSMAsset:GetRerouteNodeClass() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_FSMAsset:GetExtraDefaultInputNodes(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_FSMAsset:GetExtraDefaultOutputNodes(OutClasses) end
---@return UClass
function UBED_FSMAsset:GetStartNodeClassInBranchGraph() end
---@return UClass
function UBED_FSMAsset:GetRerouteNodeClassInBranchGraph() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_FSMAsset:GetExtraDefaultInputNodesInBranchGraph(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_FSMAsset:GetExtraDefaultOutputNodesInBranchGraph(OutClasses) end


---@class UBED_FSMNode : UBED_CalliopeNodeBae
UBED_FSMNode = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_FSMNode:IsSupportViewType(InViewType) end


---@class UBED_FSMNode_ConditionBase : UBED_FSMNode
UBED_FSMNode_ConditionBase = {}


---@class UBED_FSMNode_Condition_GI_Global_IsIgnoreWXLogin : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Global_IsIgnoreWXLogin = {}

---@return FString
function UBED_FSMNode_Condition_GI_Global_IsIgnoreWXLogin:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_BattleLevelTravelNeedWaitCameraBlend : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_BattleLevelTravelNeedWaitCameraBlend = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_BattleLevelTravelNeedWaitCameraBlend:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_CheckGMFlagsSupportUnknownTravel : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_CheckGMFlagsSupportUnknownTravel = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_CheckGMFlagsSupportUnknownTravel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_CheckGlobalTravelMode : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_CheckGlobalTravelMode = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_CheckGlobalTravelMode:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_DetermineTravelLevelByHandlingArchive : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_DetermineTravelLevelByHandlingArchive = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_DetermineTravelLevelByHandlingArchive:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_HasArchive : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_HasArchive = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_HasArchive:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_HasArchiveIdInContext : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_HasArchiveIdInContext = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_HasArchiveIdInContext:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_HasPlayerLoginBtlSvr : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_HasPlayerLoginBtlSvr = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_HasPlayerLoginBtlSvr:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsDriverVersionMismatch : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsDriverVersionMismatch = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsDriverVersionMismatch:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsEnableLoadingUserInput : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsEnableLoadingUserInput = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsEnableLoadingUserInput:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsFirstStartGame : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsFirstStartGame = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsFirstStartGame:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsInBattleLevel : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsInBattleLevel = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsInBattleLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsInContextLevel : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsInContextLevel = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsInContextLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsInDedicateServer : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsInDedicateServer = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsInDedicateServer:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsInDefaultBattleLevel : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsInDefaultBattleLevel = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsInDefaultBattleLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsInListenServer : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsInListenServer = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsInListenServer:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsInMap : UBED_FSMNode_ConditionBase
---@field LevelName FString
UBED_FSMNode_Condition_GI_Loading_IsInMap = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsInMap:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsInNetClient : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsInNetClient = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsInNetClient:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsInPIEClient : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsInPIEClient = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsInPIEClient:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsInPreviewSeqContext : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsInPreviewSeqContext = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsInPreviewSeqContext:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsInServer : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsInServer = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsInServer:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsInStartUpLevel : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsInStartUpLevel = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsInStartUpLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsInToilet : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsInToilet = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsInToilet:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsNeedCloseLoadingScreen : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsNeedCloseLoadingScreen = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsNeedCloseLoadingScreen:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsNeedOpenLoadingScreen : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsNeedOpenLoadingScreen = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsNeedOpenLoadingScreen:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsNeedPostLeaveLevel : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsNeedPostLeaveLevel = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsNeedPostLeaveLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsNeedPreEnterLevel : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsNeedPreEnterLevel = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsNeedPreEnterLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsNeedPreStartGameProcess : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsNeedPreStartGameProcess = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsNeedPreStartGameProcess:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsNeedResetGameInstanceData : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsNeedResetGameInstanceData = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsNeedResetGameInstanceData:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsPlayGoDownloadIncomplete : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsPlayGoDownloadIncomplete = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsPlayGoDownloadIncomplete:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsReplayWorldLoadFinish : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsReplayWorldLoadFinish = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsReplayWorldLoadFinish:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_IsStandAlone : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_IsStandAlone = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_IsStandAlone:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_MonsterTeleportArchiveExist : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_MonsterTeleportArchiveExist = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_MonsterTeleportArchiveExist:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_NeedSwitchPlayerGameMode : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_NeedSwitchPlayerGameMode = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_NeedSwitchPlayerGameMode:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_OpenSeamlessLevelTravel : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_OpenSeamlessLevelTravel = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_OpenSeamlessLevelTravel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_PlayerGameStateCheck : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_PlayerGameStateCheck = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_PlayerGameStateCheck:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_SwitchFillContextArchiveDataType : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_SwitchFillContextArchiveDataType = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_SwitchFillContextArchiveDataType:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_SwitchSaveArchiveDegree : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_SwitchSaveArchiveDegree = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_SwitchSaveArchiveDegree:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_SwitchTeleportType : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_SwitchTeleportType = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_SwitchTeleportType:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_TeleportNeedLevelTravel : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_TeleportNeedLevelTravel = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_TeleportNeedLevelTravel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_TravelUrlHasHost : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_TravelUrlHasHost = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_TravelUrlHasHost:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_GI_Loading_TravelUrlIsListen : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_GI_Loading_TravelUrlIsListen = {}

---@return FString
function UBED_FSMNode_Condition_GI_Loading_TravelUrlIsListen:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Condition_PS_Transaction_TaskCondition : UBED_FSMNode_ConditionBase
UBED_FSMNode_Condition_PS_Transaction_TaskCondition = {}

---@return FString
function UBED_FSMNode_Condition_PS_Transaction_TaskCondition:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_End : UBED_FSMNode
UBED_FSMNode_End = {}


---@class UBED_FSMNode_GI_GlobalAnyState : UBED_FSMNode_GI_GlobalBase
---@field AcceptEvents TArray<EGI_Global>
UBED_FSMNode_GI_GlobalAnyState = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_GlobalAnyState:PostPropertyChanged(MemberName, PropertyName) end


---@class UBED_FSMNode_GI_GlobalBase : UBED_FSMNode
UBED_FSMNode_GI_GlobalBase = {}


---@class UBED_FSMNode_GI_Global_AsClientInGame : UBED_FSMNode_GI_GlobalBase
---@field AcceptEvents TArray<EGI_Global>
UBED_FSMNode_GI_Global_AsClientInGame = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Global_AsClientInGame:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Global_AsClientInGame:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_AsListenServerInGame : UBED_FSMNode_GI_GlobalBase
---@field AcceptEvents TArray<EGI_Global>
UBED_FSMNode_GI_Global_AsListenServerInGame = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Global_AsListenServerInGame:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Global_AsListenServerInGame:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_InBattleOnLineClient : UBED_FSMNode_GI_GlobalBase
---@field AcceptEvents TArray<EGI_Global>
UBED_FSMNode_GI_Global_InBattleOnLineClient = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Global_InBattleOnLineClient:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Global_InBattleOnLineClient:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_InBattleOnLineDS : UBED_FSMNode_GI_GlobalBase
---@field AcceptEvents TArray<EGI_Global>
UBED_FSMNode_GI_Global_InBattleOnLineDS = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Global_InBattleOnLineDS:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Global_InBattleOnLineDS:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_InBattleOnLineLS : UBED_FSMNode_GI_GlobalBase
---@field AcceptEvents TArray<EGI_Global>
UBED_FSMNode_GI_Global_InBattleOnLineLS = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Global_InBattleOnLineLS:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Global_InBattleOnLineLS:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_InBattleParty : UBED_FSMNode_GI_GlobalBase
---@field AcceptEvents TArray<EGI_Global>
UBED_FSMNode_GI_Global_InBattleParty = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Global_InBattleParty:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Global_InBattleParty:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_InBattleStandAlone : UBED_FSMNode_GI_GlobalBase
---@field AcceptEvents TArray<EGI_Global>
UBED_FSMNode_GI_Global_InBattleStandAlone = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Global_InBattleStandAlone:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Global_InBattleStandAlone:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_InBattleWaitingStartNewGame : UBED_FSMNode_GI_GlobalBase
---@field AcceptEvents TArray<EGI_Global>
UBED_FSMNode_GI_Global_InBattleWaitingStartNewGame = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Global_InBattleWaitingStartNewGame:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Global_InBattleWaitingStartNewGame:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_InBenchMark : UBED_FSMNode_GI_GlobalBase
---@field AcceptEvents TArray<EGI_Global>
UBED_FSMNode_GI_Global_InBenchMark = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Global_InBenchMark:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Global_InBenchMark:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_MainMenu : UBED_FSMNode_GI_GlobalBase
---@field AcceptEvents TArray<EGI_Global>
UBED_FSMNode_GI_Global_MainMenu = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Global_MainMenu:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Global_MainMenu:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_OpenMainMenuLevel : UBED_FSMNode_GI_GlobalBase
---@field AcceptEvents TArray<EGI_Global>
UBED_FSMNode_GI_Global_OpenMainMenuLevel = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Global_OpenMainMenuLevel:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Global_OpenMainMenuLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Global_BenchMark : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Global_BenchMark = {}

function UBED_FSMNode_GI_Global_SubG_GI_Global_BenchMark:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Global_BenchMark:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Global_WXLogin : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Global_WXLogin = {}

function UBED_FSMNode_GI_Global_SubG_GI_Global_WXLogin:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Global_WXLogin:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_820DemoReSetGameData : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_820DemoReSetGameData = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_820DemoReSetGameData:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_820DemoReSetGameData:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_820DemoStartUp : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_820DemoStartUp = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_820DemoStartUp:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_820DemoStartUp:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_BackToMainMenu : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_BackToMainMenu = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_BackToMainMenu:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_BackToMainMenu:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_BackToStandAlone : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_BackToStandAlone = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_BackToStandAlone:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_BackToStandAlone:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_CheckGSSdkServerConfig : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_CheckGSSdkServerConfig = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_CheckGSSdkServerConfig:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_CheckGSSdkServerConfig:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_GameLevelPass : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_GameLevelPass = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_GameLevelPass:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_GameLevelPass:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_HandleDisConnect : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_HandleDisConnect = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_HandleDisConnect:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_HandleDisConnect:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_InitWXLogin : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_InitWXLogin = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_InitWXLogin:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_InitWXLogin:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_PartyRoomClient : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_PartyRoomClient = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_PartyRoomClient:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_PartyRoomClient:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_PartyRoomServer : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_PartyRoomServer = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_PartyRoomServer:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_PartyRoomServer:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_PostWXLoginFinish : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_PostWXLoginFinish = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_PostWXLoginFinish:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_PostWXLoginFinish:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_PreEnterMainMenu : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_PreEnterMainMenu = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_PreEnterMainMenu:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_PreEnterMainMenu:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_PreviewSequence : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_PreviewSequence = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_PreviewSequence:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_PreviewSequence:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_ReplayBattle : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_ReplayBattle = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_ReplayBattle:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_ReplayBattle:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_SaveArchiveAndWaitFinish : UBED_FSMNode_SubGraph
---@field ArchiveSaveSource ArchiveSaveSource
UBED_FSMNode_GI_Global_SubG_GI_Loading_SaveArchiveAndWaitFinish = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_SaveArchiveAndWaitFinish:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_SaveArchiveAndWaitFinish:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_ServerLogin : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_ServerLogin = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_ServerLogin:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_ServerLogin:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_SetConfigAndPrecompilePSO : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_SetConfigAndPrecompilePSO = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_SetConfigAndPrecompilePSO:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_SetConfigAndPrecompilePSO:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_StartNewGame : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_StartNewGame = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_StartNewGame:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_StartNewGame:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_StartNewGamePlus : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_StartNewGamePlus = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_StartNewGamePlus:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_StartNewGamePlus:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_StartUp : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_StartUp = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_StartUp:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_StartUp:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_Teleport : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_Teleport = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_Teleport:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_Teleport:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_ToiletClient : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_ToiletClient = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_ToiletClient:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_ToiletClient:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_ToiletDedicateServer : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_ToiletDedicateServer = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_ToiletDedicateServer:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_ToiletDedicateServer:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_ToiletListenServer : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_ToiletListenServer = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_ToiletListenServer:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_ToiletListenServer:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_ToiletStandAlone : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_ToiletStandAlone = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_ToiletStandAlone:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_ToiletStandAlone:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_TravelLevel : UBED_FSMNode_SubGraph
---@field TravelLevelType GlobalTravelLevelType
---@field TargetLevelNetType TargetLevelNetType
UBED_FSMNode_GI_Global_SubG_GI_Loading_TravelLevel = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_TravelLevel:PostPropertyChanged(MemberName, PropertyName) end
function UBED_FSMNode_GI_Global_SubG_GI_Loading_TravelLevel:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_TravelLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_TravelToNextChapter : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_TravelToNextChapter = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_TravelToNextChapter:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_TravelToNextChapter:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_SubG_GI_Loading_UnKnowLevelTravel : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Global_SubG_GI_Loading_UnKnowLevelTravel = {}

function UBED_FSMNode_GI_Global_SubG_GI_Loading_UnKnowLevelTravel:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Global_SubG_GI_Loading_UnKnowLevelTravel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_WXLogin : UBED_FSMNode_GI_GlobalBase
---@field AcceptEvents TArray<EGI_Global>
UBED_FSMNode_GI_Global_WXLogin = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Global_WXLogin:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Global_WXLogin:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_WaitGameStart : UBED_FSMNode_GI_GlobalBase
---@field AcceptEvents TArray<EGI_Global>
UBED_FSMNode_GI_Global_WaitGameStart = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Global_WaitGameStart:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Global_WaitGameStart:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Global_WaittingSelectLevel820Demo : UBED_FSMNode_GI_GlobalBase
---@field AcceptEvents TArray<EGI_Global>
UBED_FSMNode_GI_Global_WaittingSelectLevel820Demo = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Global_WaittingSelectLevel820Demo:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Global_WaittingSelectLevel820Demo:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_LoadingAnyState : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_LoadingAnyState = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_LoadingAnyState:PostPropertyChanged(MemberName, PropertyName) end


---@class UBED_FSMNode_GI_LoadingBase : UBED_FSMNode
UBED_FSMNode_GI_LoadingBase = {}


---@class UBED_FSMNode_GI_Loading_AdjustPSOCachePrecompileBatch : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_AdjustPSOCachePrecompileBatch = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_AdjustPSOCachePrecompileBatch:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_AdjustPSOCachePrecompileBatch:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_CacheArchiveDataForClient : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_CacheArchiveDataForClient = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_CacheArchiveDataForClient:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_CacheArchiveDataForClient:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_ChangeGameDefaultMap : UBED_FSMNode_GI_LoadingBase
---@field LevelName FString
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_ChangeGameDefaultMap = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_ChangeGameDefaultMap:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_ChangeGameDefaultMap:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_CheckArchiveDataIsValid : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_CheckArchiveDataIsValid = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_CheckArchiveDataIsValid:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_CheckArchiveDataIsValid:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_CheckGSSdkServerConfig : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_CheckGSSdkServerConfig = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_CheckGSSdkServerConfig:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_CheckGSSdkServerConfig:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_CheckGSSdkUserConfig : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_CheckGSSdkUserConfig = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_CheckGSSdkUserConfig:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_CheckGSSdkUserConfig:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_CloseLoadingScreen : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_CloseLoadingScreen = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_CloseLoadingScreen:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_CloseLoadingScreen:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_CreateNewRoleData : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_CreateNewRoleData = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_CreateNewRoleData:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_CreateNewRoleData:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_ECSWorldBeginPlay : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_ECSWorldBeginPlay = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_ECSWorldBeginPlay:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_ECSWorldBeginPlay:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_ECSWorldReset : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_ECSWorldReset = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_ECSWorldReset:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_ECSWorldReset:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_EngineHandleDisconnect : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_EngineHandleDisconnect = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_EngineHandleDisconnect:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_EngineHandleDisconnect:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_FillIsInToilet : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_FillIsInToilet = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_FillIsInToilet:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_FillIsInToilet:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_FillLocalBPCRoleData : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_FillLocalBPCRoleData = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_FillLocalBPCRoleData:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_FillLocalBPCRoleData:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_FillLoginRoleData : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_FillLoginRoleData = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_FillLoginRoleData:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_FillLoginRoleData:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_FirstStartGameSettings : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_FirstStartGameSettings = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_FirstStartGameSettings:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_FirstStartGameSettings:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_GMRecordRebirthPos : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_GMRecordRebirthPos = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_GMRecordRebirthPos:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_GMRecordRebirthPos:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_GSGBtlOnBattleDestroy : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_GSGBtlOnBattleDestroy = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_GSGBtlOnBattleDestroy:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_GSGBtlOnBattleDestroy:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_GSGBtlOnBattleStart : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_GSGBtlOnBattleStart = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_GSGBtlOnBattleStart:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_GSGBtlOnBattleStart:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_GSGEnterBattleLevel : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_GSGEnterBattleLevel = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_GSGEnterBattleLevel:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_GSGEnterBattleLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_GSGEnterLevel : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_GSGEnterLevel = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_GSGEnterLevel:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_GSGEnterLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_GSGExitLevel : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_GSGExitLevel = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_GSGExitLevel:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_GSGExitLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_GSGOnBattleDestroy : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_GSGOnBattleDestroy = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_GSGOnBattleDestroy:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_GSGOnBattleDestroy:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_GSGOnBattleStart : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_GSGOnBattleStart = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_GSGOnBattleStart:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_GSGOnBattleStart:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_GSGRecoverMuseum : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_GSGRecoverMuseum = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_GSGRecoverMuseum:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_GSGRecoverMuseum:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_GSGShowBattleUI : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_GSGShowBattleUI = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_GSGShowBattleUI:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_GSGShowBattleUI:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_GSGShowLoginUI : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_GSGShowLoginUI = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_GSGShowLoginUI:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_GSGShowLoginUI:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_GSGShowWXlogin : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_GSGShowWXlogin = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_GSGShowWXlogin:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_GSGShowWXlogin:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_InitClientPlayerContainer : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_InitClientPlayerContainer = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_InitClientPlayerContainer:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_InitClientPlayerContainer:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_InitCollectionSpawnActorState : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_InitCollectionSpawnActorState = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_InitCollectionSpawnActorState:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_InitCollectionSpawnActorState:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_InitDispLibWorld : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_InitDispLibWorld = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_InitDispLibWorld:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_InitDispLibWorld:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_InitLocalPlayerContainer : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_InitLocalPlayerContainer = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_InitLocalPlayerContainer:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_InitLocalPlayerContainer:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_InitNewArchiveData : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_InitNewArchiveData = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_InitNewArchiveData:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_InitNewArchiveData:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_LoadChapterViewLevel : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_LoadChapterViewLevel = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_LoadChapterViewLevel:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_LoadChapterViewLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_LoadCharacterViewLevel : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_LoadCharacterViewLevel = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_LoadCharacterViewLevel:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_LoadCharacterViewLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_LoadCommLevel : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_LoadCommLevel = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_LoadCommLevel:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_LoadCommLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_LoadingUIBeginFadeAway : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_LoadingUIBeginFadeAway = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_LoadingUIBeginFadeAway:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_LoadingUIBeginFadeAway:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_LoadingUIFadeAway : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_LoadingUIFadeAway = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_LoadingUIFadeAway:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_LoadingUIFadeAway:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_LoadingUIFadeIn : UBED_FSMNode_GI_LoadingBase
---@field WaitTick int32
---@field Reason LoadingUIFadeInReason
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_LoadingUIFadeIn = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_LoadingUIFadeIn:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_LoadingUIFadeIn:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_LoadingUILinearTime : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_LoadingUILinearTime = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_LoadingUILinearTime:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_LoadingUILinearTime:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_LoadingUIWaitUserInput : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_LoadingUIWaitUserInput = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_LoadingUIWaitUserInput:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_LoadingUIWaitUserInput:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_LockSaveArchiveByTravelLevel : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_LockSaveArchiveByTravelLevel = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_LockSaveArchiveByTravelLevel:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_LockSaveArchiveByTravelLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_LoginByRoleData : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_LoginByRoleData = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_LoginByRoleData:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_LoginByRoleData:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_MarkCanFinishLoopMovie : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_MarkCanFinishLoopMovie = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_MarkCanFinishLoopMovie:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_MarkCanFinishLoopMovie:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_MarkFirstStartGameFlag : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_MarkFirstStartGameFlag = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_MarkFirstStartGameFlag:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_MarkFirstStartGameFlag:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_MarkNewGameplusReady : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_MarkNewGameplusReady = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_MarkNewGameplusReady:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_MarkNewGameplusReady:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_NetConectionFailurePreprocess : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_NetConectionFailurePreprocess = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_NetConectionFailurePreprocess:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_NetConectionFailurePreprocess:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_NextChapterReqAndArchive : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_NextChapterReqAndArchive = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_NextChapterReqAndArchive:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_NextChapterReqAndArchive:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_OpenLevelByIdInContext : UBED_FSMNode_GI_LoadingBase
---@field ContextOptions FString
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_OpenLevelByIdInContext = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_OpenLevelByIdInContext:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_OpenLevelByIdInContext:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_OpenLevelByName : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_OpenLevelByName = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_OpenLevelByName:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_OpenLevelByName:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_OpenLevelDefaultBattle : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_OpenLevelDefaultBattle = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_OpenLevelDefaultBattle:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_OpenLevelDefaultBattle:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_OpenLevelStartUp : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_OpenLevelStartUp = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_OpenLevelStartUp:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_OpenLevelStartUp:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_OpenLoadingScreen : UBED_FSMNode_GI_LoadingBase
---@field WaitTick int32
---@field Reason LoadingUIFadeInReason
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_OpenLoadingScreen = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_OpenLoadingScreen:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_OpenLoadingScreen:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_PauseGame : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_PauseGame = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_PauseGame:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_PauseGame:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_PausePsoCachePrecompile : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_PausePsoCachePrecompile = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_PausePsoCachePrecompile:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_PausePsoCachePrecompile:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_PlayGoDownloadIncompleteImpl : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_PlayGoDownloadIncompleteImpl = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_PlayGoDownloadIncompleteImpl:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_PlayGoDownloadIncompleteImpl:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_PlayerDataInitPreEnterLevel : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_PlayerDataInitPreEnterLevel = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_PlayerDataInitPreEnterLevel:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_PlayerDataInitPreEnterLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_PlayerTeleportToTemplatetargetPos : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_PlayerTeleportToTemplatetargetPos = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_PlayerTeleportToTemplatetargetPos:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_PlayerTeleportToTemplatetargetPos:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_PostLogin : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_PostLogin = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_PostLogin:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_PostLogin:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_PostSeamlessLevelTravel : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_PostSeamlessLevelTravel = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_PostSeamlessLevelTravel:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_PostSeamlessLevelTravel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_PreLogin : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_PreLogin = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_PreLogin:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_PreLogin:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_PrepareFadeAway : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_PrepareFadeAway = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_PrepareFadeAway:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_PrepareFadeAway:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_QuitGame : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_QuitGame = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_QuitGame:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_QuitGame:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_ReadLatestArchive : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_ReadLatestArchive = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_ReadLatestArchive:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_ReadLatestArchive:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_ReleaseSaveArchiveByTravelLevel : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_ReleaseSaveArchiveByTravelLevel = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_ReleaseSaveArchiveByTravelLevel:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_ReleaseSaveArchiveByTravelLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_RequestFadeAway : UBED_FSMNode_GI_LoadingBase
---@field WaitSecond float
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_RequestFadeAway = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_RequestFadeAway:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_RequestFadeAway:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_RequestTemplateCreateArchiveData : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_RequestTemplateCreateArchiveData = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_RequestTemplateCreateArchiveData:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_RequestTemplateCreateArchiveData:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_RequestTemplateLoadArchiveData : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_RequestTemplateLoadArchiveData = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_RequestTemplateLoadArchiveData:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_RequestTemplateLoadArchiveData:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_RequestTemplateOpenLevel : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_RequestTemplateOpenLevel = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_RequestTemplateOpenLevel:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_RequestTemplateOpenLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_RequestTemplatePerformActionsFromArchive : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_RequestTemplatePerformActionsFromArchive = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_RequestTemplatePerformActionsFromArchive:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_RequestTemplatePerformActionsFromArchive:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_RequestTemplatePostEnterLevelFinish : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_RequestTemplatePostEnterLevelFinish = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_RequestTemplatePostEnterLevelFinish:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_RequestTemplatePostEnterLevelFinish:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_RequestTemplatePostGSLoginFinish : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_RequestTemplatePostGSLoginFinish = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_RequestTemplatePostGSLoginFinish:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_RequestTemplatePostGSLoginFinish:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_RequestTemplatePostSaveArchiveFinish : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_RequestTemplatePostSaveArchiveFinish = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_RequestTemplatePostSaveArchiveFinish:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_RequestTemplatePostSaveArchiveFinish:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_RequestTemplatePreLeaveLevel : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_RequestTemplatePreLeaveLevel = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_RequestTemplatePreLeaveLevel:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_RequestTemplatePreLeaveLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_RequestTemplatePreSaveArchive : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_RequestTemplatePreSaveArchive = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_RequestTemplatePreSaveArchive:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_RequestTemplatePreSaveArchive:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_RequestTemplateTravelLevelBegin : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_RequestTemplateTravelLevelBegin = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_RequestTemplateTravelLevelBegin:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_RequestTemplateTravelLevelBegin:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_RequestTemplateTravelLevelEnd : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_RequestTemplateTravelLevelEnd = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_RequestTemplateTravelLevelEnd:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_RequestTemplateTravelLevelEnd:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_Reset820DemoGameData : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_Reset820DemoGameData = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_Reset820DemoGameData:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_Reset820DemoGameData:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_ResetGameInstanceData : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_ResetGameInstanceData = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_ResetGameInstanceData:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_ResetGameInstanceData:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_ResetNewGameplusArchive : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_ResetNewGameplusArchive = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_ResetNewGameplusArchive:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_ResetNewGameplusArchive:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_ResumeGame : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_ResumeGame = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_ResumeGame:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_ResumeGame:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_ResumePsoCachePrecompile : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_ResumePsoCachePrecompile = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_ResumePsoCachePrecompile:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_ResumePsoCachePrecompile:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_SaveArchiveAndWaitFinish : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_SaveArchiveAndWaitFinish = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_SaveArchiveAndWaitFinish:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_SaveArchiveAndWaitFinish:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_SaveArchiveInTravelLevel : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_SaveArchiveInTravelLevel = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_SaveArchiveInTravelLevel:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_SaveArchiveInTravelLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_ServerBattleReady : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_ServerBattleReady = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_ServerBattleReady:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_ServerBattleReady:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_SetPSOCacheUsageMask : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_SetPSOCacheUsageMask = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_SetPSOCacheUsageMask:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_SetPSOCacheUsageMask:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_ShowAgreementPolicyInStartGame : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_ShowAgreementPolicyInStartGame = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_ShowAgreementPolicyInStartGame:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_ShowAgreementPolicyInStartGame:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_ShowArchiveMarkInStartGame : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_ShowArchiveMarkInStartGame = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_ShowArchiveMarkInStartGame:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_ShowArchiveMarkInStartGame:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_ShowGameDisclaimerInStartGame : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_ShowGameDisclaimerInStartGame = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_ShowGameDisclaimerInStartGame:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_ShowGameDisclaimerInStartGame:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_ShowHealthyGamingAdviceInStartGame : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_ShowHealthyGamingAdviceInStartGame = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_ShowHealthyGamingAdviceInStartGame:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_ShowHealthyGamingAdviceInStartGame:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_ShowLogoInStartGame : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_ShowLogoInStartGame = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_ShowLogoInStartGame:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_ShowLogoInStartGame:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_ShowMessageBoxAndWaitConfirm : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_ShowMessageBoxAndWaitConfirm = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_ShowMessageBoxAndWaitConfirm:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_ShowMessageBoxAndWaitConfirm:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_ShowReplayUI : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_ShowReplayUI = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_ShowReplayUI:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_ShowReplayUI:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_SpawnCharacterForClient : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_SpawnCharacterForClient = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_SpawnCharacterForClient:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_SpawnCharacterForClient:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_SpawnPlayerPawnWithOutECSBeginPlay : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_SpawnPlayerPawnWithOutECSBeginPlay = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_SpawnPlayerPawnWithOutECSBeginPlay:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_SpawnPlayerPawnWithOutECSBeginPlay:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_StartNewGamePlus : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_StartNewGamePlus = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_StartNewGamePlus:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_StartNewGamePlus:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_SubG_GI_Loading_BattleLevelTravel : UBED_FSMNode_SubGraph
---@field NeedWaitCameraBlend boolean
UBED_FSMNode_GI_Loading_SubG_GI_Loading_BattleLevelTravel = {}

function UBED_FSMNode_GI_Loading_SubG_GI_Loading_BattleLevelTravel:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Loading_SubG_GI_Loading_BattleLevelTravel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_SubG_GI_Loading_ClientEnvInit : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Loading_SubG_GI_Loading_ClientEnvInit = {}

function UBED_FSMNode_GI_Loading_SubG_GI_Loading_ClientEnvInit:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Loading_SubG_GI_Loading_ClientEnvInit:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_SubG_GI_Loading_GSLogin : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Loading_SubG_GI_Loading_GSLogin = {}

function UBED_FSMNode_GI_Loading_SubG_GI_Loading_GSLogin:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Loading_SubG_GI_Loading_GSLogin:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_SubG_GI_Loading_HandleArchiveInTravelLevel : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Loading_SubG_GI_Loading_HandleArchiveInTravelLevel = {}

function UBED_FSMNode_GI_Loading_SubG_GI_Loading_HandleArchiveInTravelLevel:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Loading_SubG_GI_Loading_HandleArchiveInTravelLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_SubG_GI_Loading_HideLoadingUI : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Loading_SubG_GI_Loading_HideLoadingUI = {}

function UBED_FSMNode_GI_Loading_SubG_GI_Loading_HideLoadingUI:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Loading_SubG_GI_Loading_HideLoadingUI:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_SubG_GI_Loading_PostLeaveLevel : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Loading_SubG_GI_Loading_PostLeaveLevel = {}

function UBED_FSMNode_GI_Loading_SubG_GI_Loading_PostLeaveLevel:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Loading_SubG_GI_Loading_PostLeaveLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_SubG_GI_Loading_PreEnterLevel : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Loading_SubG_GI_Loading_PreEnterLevel = {}

function UBED_FSMNode_GI_Loading_SubG_GI_Loading_PreEnterLevel:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Loading_SubG_GI_Loading_PreEnterLevel:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_SubG_GI_Loading_ReStartGSLogin : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Loading_SubG_GI_Loading_ReStartGSLogin = {}

function UBED_FSMNode_GI_Loading_SubG_GI_Loading_ReStartGSLogin:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Loading_SubG_GI_Loading_ReStartGSLogin:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_SubG_GI_Loading_ResetGameInstanceDataAndSaveArchive : UBED_FSMNode_SubGraph
UBED_FSMNode_GI_Loading_SubG_GI_Loading_ResetGameInstanceDataAndSaveArchive = {}

function UBED_FSMNode_GI_Loading_SubG_GI_Loading_ResetGameInstanceDataAndSaveArchive:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Loading_SubG_GI_Loading_ResetGameInstanceDataAndSaveArchive:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_SubG_GI_Loading_SaveArchiveAndWaitFinish : UBED_FSMNode_SubGraph
---@field ArchiveSaveSource ArchiveSaveSource
UBED_FSMNode_GI_Loading_SubG_GI_Loading_SaveArchiveAndWaitFinish = {}

function UBED_FSMNode_GI_Loading_SubG_GI_Loading_SaveArchiveAndWaitFinish:OnCreateGraphNodeInCS() end
---@return FString
function UBED_FSMNode_GI_Loading_SubG_GI_Loading_SaveArchiveAndWaitFinish:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_TeleportTemplateBegin : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_TeleportTemplateBegin = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_TeleportTemplateBegin:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_TeleportTemplateBegin:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_TeleportTemplateEnd : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_TeleportTemplateEnd = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_TeleportTemplateEnd:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_TeleportTemplateEnd:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_TriggerBackToStandAlone : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_TriggerBackToStandAlone = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_TriggerBackToStandAlone:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_TriggerBackToStandAlone:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_TriggerTeleportAndWaitFinish : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_TriggerTeleportAndWaitFinish = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_TriggerTeleportAndWaitFinish:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_TriggerTeleportAndWaitFinish:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_UnlockScopeReplayScrubComplete : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_UnlockScopeReplayScrubComplete = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_UnlockScopeReplayScrubComplete:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_UnlockScopeReplayScrubComplete:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_UnrealTravelToServer : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_UnrealTravelToServer = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_UnrealTravelToServer:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_UnrealTravelToServer:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitAllAssetLoadFinsh : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitAllAssetLoadFinsh = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitAllAssetLoadFinsh:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitAllAssetLoadFinsh:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitCheck820DemoGameVersion : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitCheck820DemoGameVersion = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitCheck820DemoGameVersion:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitCheck820DemoGameVersion:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitFirstPlayerLogin : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitFirstPlayerLogin = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitFirstPlayerLogin:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitFirstPlayerLogin:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitGSLoginSuccess : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitGSLoginSuccess = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitGSLoginSuccess:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitGSLoginSuccess:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitGamePlayerInit : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitGamePlayerInit = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitGamePlayerInit:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitGamePlayerInit:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitImportantAssetLoadFinsh : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitImportantAssetLoadFinsh = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitImportantAssetLoadFinsh:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitImportantAssetLoadFinsh:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitLevelStreamingLoad : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitLevelStreamingLoad = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitLevelStreamingLoad:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitLevelStreamingLoad:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitLocalPlayerFillLoginOption : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitLocalPlayerFillLoginOption = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitLocalPlayerFillLoginOption:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitLocalPlayerFillLoginOption:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitLocalPlayerStartPlay : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitLocalPlayerStartPlay = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitLocalPlayerStartPlay:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitLocalPlayerStartPlay:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitMatchStart : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitMatchStart = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitMatchStart:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitMatchStart:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitPlayerCameraBlend : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitPlayerCameraBlend = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitPlayerCameraBlend:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitPlayerCameraBlend:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitPostLoadMap : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitPostLoadMap = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitPostLoadMap:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitPostLoadMap:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitPostLoadMapClient : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitPostLoadMapClient = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitPostLoadMapClient:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitPostLoadMapClient:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitPsoCachePrecompileFinish : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitPsoCachePrecompileFinish = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitPsoCachePrecompileFinish:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitPsoCachePrecompileFinish:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitReplayPlayerSpawn : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitReplayPlayerSpawn = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitReplayPlayerSpawn:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitReplayPlayerSpawn:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitStartGamePsoPrecompileFinish : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitStartGamePsoPrecompileFinish = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitStartGamePsoPrecompileFinish:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitStartGamePsoPrecompileFinish:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitTick : UBED_FSMNode_GI_LoadingBase
---@field WaitTotalTick int32
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitTick = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitTick:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitTick:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_GI_Loading_WaitUntilGameStateInit : UBED_FSMNode_GI_LoadingBase
---@field AcceptEvents TArray<EGI_Loading>
UBED_FSMNode_GI_Loading_WaitUntilGameStateInit = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_GI_Loading_WaitUntilGameStateInit:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_GI_Loading_WaitUntilGameStateInit:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_PS_TransactionAnyState : UBED_FSMNode_PS_TransactionBase
---@field AcceptEvents TArray<EPS_Transaction>
UBED_FSMNode_PS_TransactionAnyState = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_PS_TransactionAnyState:PostPropertyChanged(MemberName, PropertyName) end


---@class UBED_FSMNode_PS_TransactionBase : UBED_FSMNode
UBED_FSMNode_PS_TransactionBase = {}


---@class UBED_FSMNode_PS_Transaction_TransactionTask : UBED_FSMNode_PS_TransactionBase
---@field TransactionTaskType TransactionTaskType
---@field AcceptEvents TArray<EPS_Transaction>
UBED_FSMNode_PS_Transaction_TransactionTask = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_PS_Transaction_TransactionTask:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_PS_Transaction_TransactionTask:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Reroute : UBED_FSMNode
UBED_FSMNode_Reroute = {}


---@class UBED_FSMNode_Start : UBED_FSMNode
UBED_FSMNode_Start = {}


---@class UBED_FSMNode_SubGraph : UBED_FSMNode
---@field SubGraphAsset TSoftObjectPtr<UBED_FSMAsset>
UBED_FSMNode_SubGraph = {}

---@return UObject
function UBED_FSMNode_SubGraph:GetAssetToEditInCS() end
---@param PropertyName FString
function UBED_FSMNode_SubGraph:PrePropertyChanged(PropertyName) end
---@param MemberName FString
---@param PropertyName FString
function UBED_FSMNode_SubGraph:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_FSMNode_SubGraph:GetNodeDescriptionInCS() end


---@class UBED_FSMNode_Transit : UBED_FSMNode_SubGraph
UBED_FSMNode_Transit = {}


---@class UBED_GuideAsset : UBED_CalliopeAssetBase
UBED_GuideAsset = {}

---@return ECalliopeViewType
function UBED_GuideAsset:GetViewType() end
---@return UClass
function UBED_GuideAsset:GetStartNodeClass() end
---@return UClass
function UBED_GuideAsset:GetRerouteNodeClass() end


---@class UBED_GuideNode_Base : UBED_CalliopeNodeBae
UBED_GuideNode_Base = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_GuideNode_Base:IsSupportViewType(InViewType) end


---@class UBED_GuideNode_Initial : UBED_GuideNode_Base
UBED_GuideNode_Initial = {}


---@class UBED_GuideNode_Listener : UBED_GuideNode_Base
---@field TransitionConditions TArray<FCompositeTransitionCondition_Guide>
---@field RelatedGuideGroupList TMap<FName, FString>
UBED_GuideNode_Listener = {}

---@return TArray<FName>
function UBED_GuideNode_Listener:GetContextOutputsInCS() end


---@class UBED_GuideNode_Mark : UBED_GuideNode_Base
---@field GuildGroupId int32
---@field IsWaitUntilGuideFinish boolean
UBED_GuideNode_Mark = {}

---@return FString
function UBED_GuideNode_Mark:GetNodeDescriptionInCS() end


---@class UBED_GuideNode_Reroute : UBED_GuideNode_Base
UBED_GuideNode_Reroute = {}


---@class UBED_GuideNode_Wait : UBED_GuideNode_Base
---@field WaitSecond int32
---@field WaitSecondFloat float
UBED_GuideNode_Wait = {}

---@return FString
function UBED_GuideNode_Wait:GetNodeDescriptionInCS() end


---@class UBED_LevelConfUtil : UBlueprintFunctionLibrary
UBED_LevelConfUtil = {}

---@param LevelStreaming ULevelStreaming
---@param Center FVector
---@param BoxExtent FVector
function UBED_LevelConfUtil:GetLevelStreamingBoundingBox(LevelStreaming, Center, BoxExtent) end


---@class UBED_MovieAsset : UBED_CalliopeAssetBase
UBED_MovieAsset = {}

---@return ECalliopeViewType
function UBED_MovieAsset:GetViewType() end
---@return UClass
function UBED_MovieAsset:GetStartNodeClass() end
---@return UClass
function UBED_MovieAsset:GetRerouteNodeClass() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_MovieAsset:GetExtraDefaultInputNodes(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_MovieAsset:GetExtraDefaultOutputNodes(OutClasses) end
---@return UClass
function UBED_MovieAsset:GetStartNodeClassInBranchGraph() end
---@return UClass
function UBED_MovieAsset:GetRerouteNodeClassInBranchGraph() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_MovieAsset:GetExtraDefaultInputNodesInBranchGraph(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_MovieAsset:GetExtraDefaultOutputNodesInBranchGraph(OutClasses) end


---@class UBED_MovieNode : UBED_CalliopeNodeBae
UBED_MovieNode = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_MovieNode:IsSupportViewType(InViewType) end


---@class UBED_MovieNode_AfterPlay : UBED_MovieNode_Event
UBED_MovieNode_AfterPlay = {}


---@class UBED_MovieNode_BeforePlay : UBED_MovieNode_Event
---@field DelayTime float
---@field TimeDilationCurve UCurveFloat
---@field bUseAsyncTransBack boolean
UBED_MovieNode_BeforePlay = {}

---@return FString
function UBED_MovieNode_BeforePlay:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_ClearPlayerStates : UBED_MovieNode
---@field bStopJump boolean
UBED_MovieNode_ClearPlayerStates = {}



---@class UBED_MovieNode_ConditionQuery : UBED_MovieNode
---@field MovieConditionQueryConfig FMovieConditionQueryConfig
UBED_MovieNode_ConditionQuery = {}

---@return FString
function UBED_MovieNode_ConditionQuery:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_CustomEvent : UBED_MovieNode
---@field EventTag FGameplayTag
UBED_MovieNode_CustomEvent = {}

---@return FString
function UBED_MovieNode_CustomEvent:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_Cut : UBED_MovieNode
---@field CutSequence TSoftObjectPtr<ULevelSequence>
---@field bUseCinematicCamera boolean
---@field bUseRail boolean
---@field bUseCrane boolean
---@field CameraTag FName
---@field RailTag FName
---@field CraneTag FName
---@field InCameraBlendTime float
---@field InCameraBlendFunction EViewTargetBlendFunction
---@field InCameraBlendFactor float
---@field bLoopPlay boolean
UBED_MovieNode_Cut = {}

---@return FString
function UBED_MovieNode_Cut:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_Delay : UBED_MovieNode
---@field DelayTime float
---@field TimeDilationCurve UCurveFloat
UBED_MovieNode_Delay = {}

---@return FString
function UBED_MovieNode_Delay:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_Event : UBED_MovieNode
UBED_MovieNode_Event = {}


---@class UBED_MovieNode_Finish : UBED_MovieNode
UBED_MovieNode_Finish = {}


---@class UBED_MovieNode_GiveBackControlRight : UBED_MovieNode
---@field CameraBlendOutTime float
---@field CameraBlendOutFunction EViewTargetBlendFunction
---@field CameraBlendOutFuncExp float
UBED_MovieNode_GiveBackControlRight = {}



---@class UBED_MovieNode_GiveBackControlRightForMonster : UBED_MovieNode
---@field MonsterGuid FGameplayTag
UBED_MovieNode_GiveBackControlRightForMonster = {}



---@class UBED_MovieNode_LoadOrUnloadStreamingLevel : UBED_MovieNode
---@field StreamingLevelName FName
---@field bLoadOrUnload boolean
---@field FinishLoadEventTag FGameplayTag
UBED_MovieNode_LoadOrUnloadStreamingLevel = {}

---@return FString
function UBED_MovieNode_LoadOrUnloadStreamingLevel:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_ManipulateStreamingSource : UBED_MovieNode
---@field bEnable boolean
---@field StreamingSourcePositions TArray<FVector>
UBED_MovieNode_ManipulateStreamingSource = {}

---@return FString
function UBED_MovieNode_ManipulateStreamingSource:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_OnSkipping : UBED_MovieNode_Event
UBED_MovieNode_OnSkipping = {}


---@class UBED_MovieNode_PerformerAction : UBED_MovieNode
---@field Performer FGameplayTag
UBED_MovieNode_PerformerAction = {}



---@class UBED_MovieNode_PerformerAddBuff : UBED_MovieNode_PerformerAction
---@field BuffID int32
---@field BuffLayer int32
---@field BuffDuration int32
---@field bPlayerAsPerformer boolean
UBED_MovieNode_PerformerAddBuff = {}

---@return FString
function UBED_MovieNode_PerformerAddBuff:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_PerformerCatchTarget : UBED_MovieNode_PerformerAction
UBED_MovieNode_PerformerCatchTarget = {}

---@return FString
function UBED_MovieNode_PerformerCatchTarget:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_PerformerExitPhasePerformance : UBED_MovieNode_PerformerAction
UBED_MovieNode_PerformerExitPhasePerformance = {}

---@return FString
function UBED_MovieNode_PerformerExitPhasePerformance:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_PerformerHiddenInGame : UBED_MovieNode_PerformerAction
---@field bHiddenInGame boolean
UBED_MovieNode_PerformerHiddenInGame = {}

---@return FString
function UBED_MovieNode_PerformerHiddenInGame:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_PerformerPostEvent : UBED_MovieNode_PerformerAction
---@field AkEvent UAkAudioEvent
---@field AttachPointName FName
---@field Follow boolean
UBED_MovieNode_PerformerPostEvent = {}

---@return FString
function UBED_MovieNode_PerformerPostEvent:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_PerformerRemoveBuff : UBED_MovieNode_PerformerAction
---@field BuffID int32
---@field BuffLayer int32
---@field bTriggerRemoveEffect boolean
---@field bPlayerAsPerformer boolean
UBED_MovieNode_PerformerRemoveBuff = {}

---@return FString
function UBED_MovieNode_PerformerRemoveBuff:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_PerformerSetTransform : UBED_MovieNode_PerformerAction
---@field Transform FTransform
---@field bPlayerAsPerformer boolean
UBED_MovieNode_PerformerSetTransform = {}

---@return FString
function UBED_MovieNode_PerformerSetTransform:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_PerformerStopWaiting : UBED_MovieNode_PerformerAction
UBED_MovieNode_PerformerStopWaiting = {}

---@return FString
function UBED_MovieNode_PerformerStopWaiting:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_PerformerSyncTransformToRefObj : UBED_MovieNode_PerformerAction
---@field RefObj FGameplayTag
---@field LocalOffset_InRefObjSpace FVector
---@field PerformerTag FString
---@field bPlayerAsPerformer boolean
UBED_MovieNode_PerformerSyncTransformToRefObj = {}

---@return FString
function UBED_MovieNode_PerformerSyncTransformToRefObj:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_PerformerTriggerSkillEffect : UBED_MovieNode_PerformerAction
---@field SkillEffectID int32
UBED_MovieNode_PerformerTriggerSkillEffect = {}

---@return FString
function UBED_MovieNode_PerformerTriggerSkillEffect:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_PlayEnd : UBED_MovieNode
---@field CameraBlendOutTime float
---@field CameraBlendOutFunction EViewTargetBlendFunction
---@field CameraBlendOutFuncExp float
---@field BlendOutBeforeCamera boolean
---@field ResetSpringArmRotationWay ResetSpringArmRotationWay
---@field CustomControllerRotation FRotator
UBED_MovieNode_PlayEnd = {}

---@return FString
function UBED_MovieNode_PlayEnd:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_PlayFromMarkedFrame : UBED_MovieNode
---@field MarkedFrameLabel FName
UBED_MovieNode_PlayFromMarkedFrame = {}

---@return FString
function UBED_MovieNode_PlayFromMarkedFrame:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_PlayerBlendPosition : UBED_MovieNode
---@field AlternativeTransforms TArray<FTransform>
---@field BlendMaxTime float
---@field BlendPositionAcceptRadius float
---@field MoveSpeedType EAIMoveSpeedType
---@field BlendPositionInterpTime float
---@field TeleportDistance float
UBED_MovieNode_PlayerBlendPosition = {}



---@class UBED_MovieNode_PlayerLockTarget : UBED_MovieNode
---@field Target FGameplayTag
---@field bUnlock boolean
UBED_MovieNode_PlayerLockTarget = {}

---@return FString
function UBED_MovieNode_PlayerLockTarget:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_PlayerSetCloudMoveEnabled : UBED_MovieNode
---@field bIsEnabled boolean
UBED_MovieNode_PlayerSetCloudMoveEnabled = {}

---@return FString
function UBED_MovieNode_PlayerSetCloudMoveEnabled:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_PreRoll : UBED_MovieNode_Event
---@field PreRollSequence TSoftObjectPtr<ULevelSequence>
---@field bUseCinematicCamera boolean
---@field CameraTag FName
---@field InCameraBlendTime float
---@field InCameraBlendFunction EViewTargetBlendFunction
---@field InCameraBlendFactor float
---@field bStopSequenceWhenFinish boolean
UBED_MovieNode_PreRoll = {}

---@return FString
function UBED_MovieNode_PreRoll:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_SetStreamingLevelStateInfo : UBED_MovieNode
---@field LevelStateRequestConfig TArray<FMovieLevelStateRequestConfig>
UBED_MovieNode_SetStreamingLevelStateInfo = {}

---@return FString
function UBED_MovieNode_SetStreamingLevelStateInfo:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_SetStreamingManagerViewSource : UBED_MovieNode
---@field bAlive boolean
---@field StreamingSourcePositions TArray<FVector>
UBED_MovieNode_SetStreamingManagerViewSource = {}

---@return FString
function UBED_MovieNode_SetStreamingManagerViewSource:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_ShowOrHiddenStreamingLevel : UBED_MovieNode
---@field StreamingLevelName FName
---@field bVisible boolean
UBED_MovieNode_ShowOrHiddenStreamingLevel = {}

---@return FString
function UBED_MovieNode_ShowOrHiddenStreamingLevel:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_Start : UBED_MovieNode_Event
---@field StartSequences TArray<FLevelSequenceConfig>
---@field StartTimeSeconds float
---@field bUseCinematicCamera boolean
---@field bUseRail boolean
---@field bUseCrane boolean
---@field CameraBlendInTime float
---@field CameraBlendInFunction EViewTargetBlendFunction
---@field CameraBlendInFuncExp float
---@field bLoopPlay boolean
UBED_MovieNode_Start = {}

---@return FString
function UBED_MovieNode_Start:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_Timer : UBED_MovieNode
---@field CompletionTime float
---@field StepTime float
UBED_MovieNode_Timer = {}

---@return FString
function UBED_MovieNode_Timer:GetNodeDescriptionInCS() end


---@class UBED_MovieNode_Transformation : UBED_MovieNode
---@field ResID int32
UBED_MovieNode_Transformation = {}

---@return FString
function UBED_MovieNode_Transformation:GetNodeDescriptionInCS() end


---@class UBED_ProcessAsset : UBED_CalliopeAssetBase
---@field StateTags FGameplayTagContainer
---@field EventTags FGameplayTagContainer
---@field CustomDetectConditions TArray<FName>
---@field SubMachineStateTags FGameplayTagContainer
---@field NodeBranchGraphNames TMap<FCalliopeGuid, FGameplayTagContainer>
UBED_ProcessAsset = {}

---@return boolean
function UBED_ProcessAsset:HasRevertCondition() end
---@return ECalliopeViewType
function UBED_ProcessAsset:GetViewType() end
---@param NewGuid FCalliopeGuid
---@param NewNode UCalliopeNode
function UBED_ProcessAsset:RegisterNode(NewGuid, NewNode) end
---@param NodeGuid FCalliopeGuid
function UBED_ProcessAsset:UnregisterNode(NodeGuid) end
---@return boolean
function UBED_ProcessAsset:IsEditorOnlyCS() end
---@return boolean
function UBED_ProcessAsset:CanManageStates() end
---@return UClass
function UBED_ProcessAsset:GetStartNodeClass() end
---@param MemberName FString
---@param PropertyName FString
function UBED_ProcessAsset:OnPropertyChanged(MemberName, PropertyName) end
function UBED_ProcessAsset:OnRefreshAssetInCS() end
---@return UClass
function UBED_ProcessAsset:GetRerouteNodeClass() end
function UBED_ProcessAsset:PostRefreshAssetInCS() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_ProcessAsset:GetExtraDefaultInputNodes(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_ProcessAsset:GetExtraDefaultOutputNodes(OutClasses) end
---@return UClass
function UBED_ProcessAsset:GetStartNodeClassInBranchGraph() end
---@return UClass
function UBED_ProcessAsset:GetRerouteNodeClassInBranchGraph() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_ProcessAsset:GetExtraDefaultInputNodesInBranchGraph(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_ProcessAsset:GetExtraDefaultOutputNodesInBranchGraph(OutClasses) end


---@class UBED_ProcessMachineNode : UBED_ProcessNode
UBED_ProcessMachineNode = {}

function UBED_ProcessMachineNode:OnRefreshAssetInCS() end


---@class UBED_ProcessMachineNode_Battle : UBED_ProcessMachineNode_TemplateBase
---@field StartCondition FBattleStartCondition
---@field BattleStartActiveList FUnitsAndSpawners
---@field TransitionConditions TArray<FCompositeTransitionCondition_Battle>
UBED_ProcessMachineNode_Battle = {}

---@return TArray<FName>
function UBED_ProcessMachineNode_Battle:GetContextOutputsInCS() end


---@class UBED_ProcessMachineNode_Counter : UBED_ProcessMachineNode_TemplateBase
---@field Goal int32
UBED_ProcessMachineNode_Counter = {}



---@class UBED_ProcessMachineNode_Final : UBED_ProcessMachineNode
UBED_ProcessMachineNode_Final = {}


---@class UBED_ProcessMachineNode_Fork : UBED_ProcessMachineNode
UBED_ProcessMachineNode_Fork = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_ProcessMachineNode_Fork:IsSupportViewType(InViewType) end
---@return boolean
function UBED_ProcessMachineNode_Fork:CanUserAddOutputInCS() end


---@class UBED_ProcessMachineNode_GroupStart : UBED_ProcessMachineNode
---@field GroupName FName
UBED_ProcessMachineNode_GroupStart = {}

---@return FString
function UBED_ProcessMachineNode_GroupStart:GetNodeDescriptionInCS() end


---@class UBED_ProcessMachineNode_Idle : UBED_ProcessMachineNode_TemplateBase
---@field TransitionConditions TArray<FCompositeTransitionCondition_Idle>
---@field ProcessActions TArray<FIdleProcessAction>
---@field bUseResetPin boolean
UBED_ProcessMachineNode_Idle = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_ProcessMachineNode_Idle:PostPropertyChanged(MemberName, PropertyName) end
---@return TArray<FName>
function UBED_ProcessMachineNode_Idle:GetContextOutputsInCS() end


---@class UBED_ProcessMachineNode_Initial : UBED_ProcessMachineNode
UBED_ProcessMachineNode_Initial = {}


---@class UBED_ProcessMachineNode_Join : UBED_ProcessMachineNode
UBED_ProcessMachineNode_Join = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_ProcessMachineNode_Join:IsSupportViewType(InViewType) end
---@return boolean
function UBED_ProcessMachineNode_Join:CanUserAddInputInCS() end


---@class UBED_ProcessMachineNode_Junction : UBED_ProcessMachineNode
---@field StateList TMap<FName, boolean>
---@field CurrentState FName
UBED_ProcessMachineNode_Junction = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_ProcessMachineNode_Junction:IsSupportViewType(InViewType) end
---@param MemberName FString
---@param PropertyName FString
function UBED_ProcessMachineNode_Junction:PostPropertyChanged(MemberName, PropertyName) end
---@return TArray<FName>
function UBED_ProcessMachineNode_Junction:GetContextOutputsInCS() end
---@return FString
function UBED_ProcessMachineNode_Junction:GetNodeDescriptionInCS() end


---@class UBED_ProcessMachineNode_NPCState : UBED_ProcessMachineNode
---@field StateList TMap<FName, boolean>
---@field TaskStageConditionList TArray<FTaskStageConditionInfo>
---@field CurrentState FName
UBED_ProcessMachineNode_NPCState = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_ProcessMachineNode_NPCState:PostPropertyChanged(MemberName, PropertyName) end
---@return TArray<FName>
function UBED_ProcessMachineNode_NPCState:GetContextOutputsInCS() end
---@return FString
function UBED_ProcessMachineNode_NPCState:GetNodeDescriptionInCS() end
---@param OutBranchGraphIdentifier FString
---@return boolean
function UBED_ProcessMachineNode_NPCState:GetBranchGraphToEditInCS(OutBranchGraphIdentifier) end


---@class UBED_ProcessMachineNode_ReportOSS : UBED_ProcessMachineNode_TemplateBase
---@field TaskLine FGsSmartParam
---@field StageNote FName
UBED_ProcessMachineNode_ReportOSS = {}

---@return FString
function UBED_ProcessMachineNode_ReportOSS:GetNodeDescriptionInCS() end


---@class UBED_ProcessMachineNode_Reroute : UBED_ProcessMachineNode
UBED_ProcessMachineNode_Reroute = {}


---@class UBED_ProcessMachineNode_ResetGroup : UBED_ProcessMachineNode_TemplateBase
---@field GroupName FName
---@field TransitionConditions TArray<FCompositeTransitionCondition_Group>
UBED_ProcessMachineNode_ResetGroup = {}

function UBED_ProcessMachineNode_ResetGroup:OnRefreshAssetInCS() end
---@return TArray<FName>
function UBED_ProcessMachineNode_ResetGroup:GetContextOutputsInCS() end
---@return FString
function UBED_ProcessMachineNode_ResetGroup:GetNodeDescriptionInCS() end


---@class UBED_ProcessMachineNode_SaveArchive : UBED_ProcessMachineNode_TemplateBase
---@field ArchiveLabel FName
---@field ArchiveLabelParam FGsSmartParam
UBED_ProcessMachineNode_SaveArchive = {}

---@return FString
function UBED_ProcessMachineNode_SaveArchive:GetNodeDescriptionInCS() end


---@class UBED_ProcessMachineNode_State : UBED_ProcessMachineNode
---@field StateList TMap<FName, boolean>
---@field EventList TMap<FName, boolean>
---@field CurrentState FName
UBED_ProcessMachineNode_State = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_ProcessMachineNode_State:PostPropertyChanged(MemberName, PropertyName) end
---@return TArray<FName>
function UBED_ProcessMachineNode_State:GetContextOutputsInCS() end
---@return FString
function UBED_ProcessMachineNode_State:GetNodeDescriptionInCS() end
---@param OutBranchGraphIdentifier FString
---@return boolean
function UBED_ProcessMachineNode_State:GetBranchGraphToEditInCS(OutBranchGraphIdentifier) end


---@class UBED_ProcessMachineNode_Story : UBED_ProcessMachineNode_TemplateBase
---@field MatchPositionType SequenceBlendInMatchPositionType
---@field Overlap FGsSmartParam
---@field bWaitPlayFinish boolean
---@field Sequence FGsSmartParam
---@field SequenceID int32
---@field bGainItemWhenFinish boolean
---@field GainItems TArray<FGainItemConfig>
---@field bChapterEndStory boolean
---@field ChapterID int32
---@field bTriggerTransBack boolean
---@field bTriggerMonsterGoHome boolean
---@field bDisablePlayerControl boolean
---@field bDisableMovementInput boolean
---@field bDisableLookAtInput boolean
---@field bHidePlayer boolean
---@field bHideHud boolean
UBED_ProcessMachineNode_Story = {}

---@return FString
function UBED_ProcessMachineNode_Story:GetNodeDescriptionInCS() end


---@class UBED_ProcessMachineNode_TemplateBase : UBED_ProcessMachineNode
UBED_ProcessMachineNode_TemplateBase = {}

---@return TArray<FName>
function UBED_ProcessMachineNode_TemplateBase:GetContextOutputsInCS() end


---@class UBED_ProcessMachineNode_Terminate : UBED_ProcessMachineNode
UBED_ProcessMachineNode_Terminate = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_ProcessMachineNode_Terminate:IsSupportViewType(InViewType) end


---@class UBED_ProcessNode : UBED_CalliopeNodeBae
UBED_ProcessNode = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_ProcessNode:IsSupportViewType(InViewType) end


---@class UBED_ProcessStateNode : UBED_ProcessNode
UBED_ProcessStateNode = {}

---@return boolean
function UBED_ProcessStateNode:IsBranchGraphNode() end


---@class UBED_ProcessStateNode_ActiveUnit : UBED_ProcessStateNode
UBED_ProcessStateNode_ActiveUnit = {}


---@class UBED_ProcessStateNode_AddBuff : UBED_ProcessStateNode
---@field BuffID int32
---@field BuffLayer int32
---@field BuffDuration int32
UBED_ProcessStateNode_AddBuff = {}



---@class UBED_ProcessStateNode_CastSkill : UBED_ProcessStateNode
---@field SkillID int32
---@field NeedCheckSkillCanCast boolean
UBED_ProcessStateNode_CastSkill = {}



---@class UBED_ProcessStateNode_DetectStart : UBED_ProcessStateNode
---@field DetectConditionList TMap<FName, boolean>
---@field CurrentCondition FName
UBED_ProcessStateNode_DetectStart = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_ProcessStateNode_DetectStart:PostPropertyChanged(MemberName, PropertyName) end
---@return TArray<FName>
function UBED_ProcessStateNode_DetectStart:GetContextOutputsInCS() end
---@return FString
function UBED_ProcessStateNode_DetectStart:GetNodeDescriptionInCS() end


---@class UBED_ProcessStateNode_DisableDetect : UBED_ProcessStateNode
---@field DetectConditionList TMap<FName, boolean>
---@field CurrentCondition FName
UBED_ProcessStateNode_DisableDetect = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_ProcessStateNode_DisableDetect:PostPropertyChanged(MemberName, PropertyName) end
---@return TArray<FName>
function UBED_ProcessStateNode_DisableDetect:GetContextOutputsInCS() end
---@return FString
function UBED_ProcessStateNode_DisableDetect:GetNodeDescriptionInCS() end


---@class UBED_ProcessStateNode_EnableDetect : UBED_ProcessStateNode
---@field DetectConditionList TMap<FName, boolean>
---@field CurrentCondition FName
UBED_ProcessStateNode_EnableDetect = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_ProcessStateNode_EnableDetect:PostPropertyChanged(MemberName, PropertyName) end
---@return TArray<FName>
function UBED_ProcessStateNode_EnableDetect:GetContextOutputsInCS() end
---@return FString
function UBED_ProcessStateNode_EnableDetect:GetNodeDescriptionInCS() end


---@class UBED_ProcessStateNode_EnterAction : UBED_ProcessStateNode
---@field bOverride boolean
UBED_ProcessStateNode_EnterAction = {}



---@class UBED_ProcessStateNode_ExecutionSequence : UBED_ProcessStateNode
UBED_ProcessStateNode_ExecutionSequence = {}

---@return boolean
function UBED_ProcessStateNode_ExecutionSequence:CanUserAddOutputInCS() end


---@class UBED_ProcessStateNode_ExitAction : UBED_ProcessStateNode
---@field bOverride boolean
UBED_ProcessStateNode_ExitAction = {}



---@class UBED_ProcessStateNode_Log : UBED_ProcessStateNode
---@field Message FString
---@field bPrintToScreen boolean
---@field Duration float
---@field TextColor FLinearColor
UBED_ProcessStateNode_Log = {}

---@return FString
function UBED_ProcessStateNode_Log:GetNodeDescriptionInCS() end


---@class UBED_ProcessStateNode_LogicalAnd : UBED_ProcessStateNode
UBED_ProcessStateNode_LogicalAnd = {}

---@return boolean
function UBED_ProcessStateNode_LogicalAnd:CanUserAddInputInCS() end


---@class UBED_ProcessStateNode_LogicalOr : UBED_ProcessStateNode
UBED_ProcessStateNode_LogicalOr = {}

---@return boolean
function UBED_ProcessStateNode_LogicalOr:CanUserAddInputInCS() end


---@class UBED_ProcessStateNode_NPCChangeIdleAnim : UBED_ProcessStateNode
---@field NeedChangeIdleAnimIdx int32
UBED_ProcessStateNode_NPCChangeIdleAnim = {}



---@class UBED_ProcessStateNode_NPCChangeLeisureAnim : UBED_ProcessStateNode
---@field NeedChangeLeisureAnimIdx int32
UBED_ProcessStateNode_NPCChangeLeisureAnim = {}



---@class UBED_ProcessStateNode_NPCShow : UBED_ProcessStateNode
---@field bIsShow boolean
UBED_ProcessStateNode_NPCShow = {}



---@class UBED_ProcessStateNode_NPCSwitchNoInteraction : UBED_ProcessStateNode
---@field bIsRecover boolean
UBED_ProcessStateNode_NPCSwitchNoInteraction = {}



---@class UBED_ProcessStateNode_NotifyActor : UBED_ProcessStateNode
---@field NotifyTags FGameplayTagContainer
UBED_ProcessStateNode_NotifyActor = {}



---@class UBED_ProcessStateNode_NotifySelf : UBED_ProcessStateNode
---@field EventList TMap<FName, boolean>
---@field CurrentEvent FName
UBED_ProcessStateNode_NotifySelf = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_ProcessStateNode_NotifySelf:PostPropertyChanged(MemberName, PropertyName) end
---@return TArray<FName>
function UBED_ProcessStateNode_NotifySelf:GetContextOutputsInCS() end
---@return FString
function UBED_ProcessStateNode_NotifySelf:GetNodeDescriptionInCS() end


---@class UBED_ProcessStateNode_ObserveActor : UBED_ProcessStateNode
---@field SuccessLimit int32
---@field ObserveActorInfo FObserveActorInfo
UBED_ProcessStateNode_ObserveActor = {}

---@return FString
function UBED_ProcessStateNode_ObserveActor:GetNodeDescriptionInCS() end


---@class UBED_ProcessStateNode_ObserveRoleData : UBED_ProcessStateNode
---@field ObserveMinSuccessConditionNum int32
---@field ObserveRoleDataInfoList TArray<FObserveRoleDataInfo>
UBED_ProcessStateNode_ObserveRoleData = {}

---@return FString
function UBED_ProcessStateNode_ObserveRoleData:GetNodeDescriptionInCS() end


---@class UBED_ProcessStateNode_ObserveSequence : UBED_ProcessStateNode
---@field SequenceID int32
---@field SuccessLimit int32
UBED_ProcessStateNode_ObserveSequence = {}

---@return FString
function UBED_ProcessStateNode_ObserveSequence:GetNodeDescriptionInCS() end


---@class UBED_ProcessStateNode_PlayLevelSequence : UBED_ProcessStateNode
---@field SequenceID int32
---@field bUsePlayerCamera boolean
---@field StartTime float
---@field bTriggerTransBack boolean
---@field bTriggerMonsterGoHome boolean
---@field bDisableMovementInput boolean
---@field bDisableLookAtInput boolean
---@field bUseCrane boolean
---@field bUseRail boolean
---@field bHidePlayer boolean
---@field bHideHud boolean
---@field bDisableCameraCuts boolean
UBED_ProcessStateNode_PlayLevelSequence = {}

---@return FString
function UBED_ProcessStateNode_PlayLevelSequence:GetNodeDescriptionInCS() end


---@class UBED_ProcessStateNode_QueryCompoundCondition : UBED_ProcessStateNode
---@field ConditionRelation ConditionalRelation
---@field bReverseCondition boolean
---@field Conditions TArray<FProcessQueryConditionInfo>
UBED_ProcessStateNode_QueryCompoundCondition = {}

---@return FString
function UBED_ProcessStateNode_QueryCompoundCondition:GetNodeDescriptionInCS() end


---@class UBED_ProcessStateNode_RemoveBuff : UBED_ProcessStateNode
---@field BuffID int32
---@field BuffLayer int32
---@field bTriggerRemoveEffect boolean
UBED_ProcessStateNode_RemoveBuff = {}



---@class UBED_ProcessStateNode_Reroute : UBED_ProcessStateNode
UBED_ProcessStateNode_Reroute = {}


---@class UBED_ProcessStateNode_ResetAction : UBED_ProcessStateNode
---@field bOverride boolean
UBED_ProcessStateNode_ResetAction = {}



---@class UBED_ProcessStateNode_ResetActor : UBED_ProcessStateNode
---@field ResetType EBGUResetType
UBED_ProcessStateNode_ResetActor = {}



---@class UBED_ProcessStateNode_ResetDetect : UBED_ProcessStateNode
---@field DetectConditionList TMap<FName, boolean>
---@field CurrentCondition FName
UBED_ProcessStateNode_ResetDetect = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_ProcessStateNode_ResetDetect:PostPropertyChanged(MemberName, PropertyName) end
---@return TArray<FName>
function UBED_ProcessStateNode_ResetDetect:GetContextOutputsInCS() end
---@return FString
function UBED_ProcessStateNode_ResetDetect:GetNodeDescriptionInCS() end


---@class UBED_ProcessStateNode_TickAction : UBED_ProcessStateNode
---@field bOverride boolean
UBED_ProcessStateNode_TickAction = {}



---@class UBED_ProcessStateNode_Timer : UBED_ProcessStateNode
---@field CompletionTime float
---@field StepTime float
UBED_ProcessStateNode_Timer = {}

---@return FString
function UBED_ProcessStateNode_Timer:GetNodeDescriptionInCS() end


---@class UBED_ProcessStateNode_UpdateInteractGroup : UBED_ProcessStateNode
---@field InteractGroupID int32
UBED_ProcessStateNode_UpdateInteractGroup = {}



---@class UBED_QuestAsset : UBED_CalliopeAssetBase
UBED_QuestAsset = {}

---@return ECalliopeViewType
function UBED_QuestAsset:GetViewType() end
---@param MemberName FString
---@param PropertyName FString
function UBED_QuestAsset:OnPropertyChanged(MemberName, PropertyName) end
---@return UClass
function UBED_QuestAsset:GetStartNodeClass() end
---@return UClass
function UBED_QuestAsset:GetRerouteNodeClass() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_QuestAsset:GetExtraDefaultInputNodes(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_QuestAsset:GetExtraDefaultOutputNodes(OutClasses) end
---@return UClass
function UBED_QuestAsset:GetStartNodeClassInBranchGraph() end
---@return UClass
function UBED_QuestAsset:GetRerouteNodeClassInBranchGraph() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_QuestAsset:GetExtraDefaultInputNodesInBranchGraph(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_QuestAsset:GetExtraDefaultOutputNodesInBranchGraph(OutClasses) end


---@class UBED_QuestNode : UBED_CalliopeNodeBae
UBED_QuestNode = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_QuestNode:IsSupportViewType(InViewType) end


---@class UBED_QuestNode_AddBuff : UBED_QuestNode
---@field UnitOrPlayer FGsSmartParam
---@field Buff FGsSmartParam
---@field BuffLayer int32
---@field BuffDuration int32
---@field BuffID int32
---@field Unit TSoftObjectPtr<ABGUCharacterCS>
---@field UnitGuid FString
---@field bPlayerAsObserveUnit boolean
UBED_QuestNode_AddBuff = {}

---@return FString
function UBED_QuestNode_AddBuff:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_AiConversation : UBED_QuestNode
---@field UnitOrPlayer FGsSmartParam
---@field AiConversationContentIDList TArray<int32>
---@field Caster TSoftObjectPtr<ABGUCharacterCS>
---@field bUseLocalPlayerAsCaster boolean
UBED_QuestNode_AiConversation = {}

---@return FString
function UBED_QuestNode_AiConversation:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_AwardPrizesRandom : UBED_QuestNode
---@field RandomCount int32
---@field SuccessLimit int32
---@field NormalProbability int32
---@field FirstProbability int32
---@field SecondProbability int32
---@field EventID int32
---@field RefreshDelta int32
---@field AwardCd int32
UBED_QuestNode_AwardPrizesRandom = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_QuestNode_AwardPrizesRandom:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_QuestNode_AwardPrizesRandom:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_BackToCheckPoint : UBED_QuestNode
---@field CheckPointId FName
UBED_QuestNode_BackToCheckPoint = {}

---@return FString
function UBED_QuestNode_BackToCheckPoint:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_BlendToCamera : UBED_QuestNode
---@field bPlayerAsViewTarget boolean
---@field ViewTarget TSoftObjectPtr<AActor>
---@field BlendTime float
---@field BlendFunc EViewTargetBlendFunction
---@field BlendExp float
---@field bLockOutgoing boolean
UBED_QuestNode_BlendToCamera = {}

---@return FString
function UBED_QuestNode_BlendToCamera:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_ChallengeSuccess : UBED_QuestNode
---@field ChallengeId int32
UBED_QuestNode_ChallengeSuccess = {}

---@return FString
function UBED_QuestNode_ChallengeSuccess:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_Counter : UBED_QuestNode
---@field Goal int32
---@field CurrentSum int32
UBED_QuestNode_Counter = {}

---@return FString
function UBED_QuestNode_Counter:GetStatusStringInCS() end
---@return FString
function UBED_QuestNode_Counter:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_CustomInput : UBED_QuestNode
---@field EventName FName
UBED_QuestNode_CustomInput = {}

---@return FString
function UBED_QuestNode_CustomInput:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_CustomOutput : UBED_QuestNode
---@field EventName FName
UBED_QuestNode_CustomOutput = {}

---@return FString
function UBED_QuestNode_CustomOutput:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_ExecutionMultiGate : UBED_QuestNode
---@field bRandom boolean
---@field bLoop boolean
---@field StartIndex int32
UBED_QuestNode_ExecutionMultiGate = {}



---@class UBED_QuestNode_ExecutionSequence : UBED_QuestNode
UBED_QuestNode_ExecutionSequence = {}

---@return boolean
function UBED_QuestNode_ExecutionSequence:CanUserAddOutputInCS() end


---@class UBED_QuestNode_Finish : UBED_QuestNode
UBED_QuestNode_Finish = {}


---@class UBED_QuestNode_GainItem : UBED_QuestNode
---@field ItemId int32
---@field Count int32
UBED_QuestNode_GainItem = {}

---@return FString
function UBED_QuestNode_GainItem:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_GainItemPerformance : UBED_QuestNode
---@field ItemId int32
---@field Count int32
UBED_QuestNode_GainItemPerformance = {}

---@return FString
function UBED_QuestNode_GainItemPerformance:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_GamePass : UBED_QuestNode
UBED_QuestNode_GamePass = {}

---@return FString
function UBED_QuestNode_GamePass:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_LevelStream : UBED_QuestNode
---@field LoadStreamingVolumes TArray<TSoftObjectPtr<ABGWLevelStreamingVolume>>
---@field UnloadStreamingVolumes TArray<TSoftObjectPtr<ABGWLevelStreamingVolume>>
UBED_QuestNode_LevelStream = {}

---@return FString
function UBED_QuestNode_LevelStream:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_Log : UBED_QuestNode
---@field Message FString
---@field bPrintToScreen boolean
---@field Duration float
---@field TextColor FLinearColor
UBED_QuestNode_Log = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_QuestNode_Log:IsSupportViewType(InViewType) end
---@return FString
function UBED_QuestNode_Log:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_LogicalAnd : UBED_QuestNode
UBED_QuestNode_LogicalAnd = {}

---@return boolean
function UBED_QuestNode_LogicalAnd:CanUserAddInputInCS() end


---@class UBED_QuestNode_LogicalOr : UBED_QuestNode
UBED_QuestNode_LogicalOr = {}

---@return boolean
function UBED_QuestNode_LogicalOr:CanUserAddInputInCS() end


---@class UBED_QuestNode_NotifyActor : UBED_QuestNode
---@field NotifySceneActor FGsSmartParam
---@field NotifyTags FGameplayTagContainer
---@field NotifyActor TSoftObjectPtr<ABGUActorBaseCS>
---@field NotifyUnit TSoftObjectPtr<ABGUCharacterCS>
---@field NotifyActorGuid FString
UBED_QuestNode_NotifyActor = {}

---@return FString
function UBED_QuestNode_NotifyActor:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_ObserveByCondition : UBED_QuestNode
---@field ConditionType ObserveConditionType
---@field SuccessLimit int32
---@field ObservedPlayerOrUnitOrActor FGsSmartParam
---@field UnitState EBGUUnitState
---@field SimpleState EBGUSimpleState
---@field AttrFloatType EBGUAttrFloat
---@field CompareOperation ValueCompareOperations
---@field CompareValue float
---@field Buff FGsSmartParam
---@field ItemNumOnline int32
---@field Reversal boolean
---@field ChallengeLevel int32
---@field BuffID int32
---@field ObservedActor TSoftObjectPtr<ABGUActorBaseCS>
---@field ObservedUnit TSoftObjectPtr<ABGUCharacterCS>
---@field ObservedActorGuid FString
---@field bPlayerAsObserveUnit boolean
UBED_QuestNode_ObserveByCondition = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_QuestNode_ObserveByCondition:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_QuestNode_ObserveByCondition:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_ObserveOnlineCondition : UBED_QuestNode
---@field ConditionType ObserveOnlineConditionType
---@field SuccessLimit int32
---@field ObservedPlayerOrUnit FGsSmartParam
---@field PlayerCount int32
---@field KillMonsterCount int32
---@field GainItemCount int32
---@field ItemId int32
---@field TraceDistance int32
---@field EventID int32
---@field RandomCount int32
---@field ObservedActor TSoftObjectPtr<ABGUActorBaseCS>
---@field bPlayerAsObserveUnit boolean
UBED_QuestNode_ObserveOnlineCondition = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_QuestNode_ObserveOnlineCondition:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_QuestNode_ObserveOnlineCondition:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_OlineScreenMsg : UBED_QuestNode
---@field EventID int32
UBED_QuestNode_OlineScreenMsg = {}

---@return FString
function UBED_QuestNode_OlineScreenMsg:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_PlayAnimMontage : UBED_QuestNode
---@field Unit FGsSmartParam
---@field AM TSoftObjectPtr<UAnimMontage>
---@field Caster TSoftObjectPtr<ABGUCharacterCS>
UBED_QuestNode_PlayAnimMontage = {}

---@return FString
function UBED_QuestNode_PlayAnimMontage:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_PlayDBCEfxToInteract : UBED_QuestNode
---@field Interactor FGsSmartParam
---@field B1DBC TSoftObjectPtr<UBGWDataAsset_B1DBC>
UBED_QuestNode_PlayDBCEfxToInteract = {}

---@return FString
function UBED_QuestNode_PlayDBCEfxToInteract:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_PlayLevelSequence : UBED_QuestNode
---@field Sequence FGsSmartParam
---@field bUsePlayerCamera boolean
---@field StartTime float
---@field bTriggerTransBack boolean
---@field bTriggerMonsterGoHome boolean
---@field bDisableMovementInput boolean
---@field bDisableLookAtInput boolean
---@field bUseCrane boolean
---@field bUseRail boolean
---@field bHidePlayer boolean
---@field bHideHud boolean
---@field bDisableCameraCuts boolean
---@field SequenceID int32
UBED_QuestNode_PlayLevelSequence = {}

---@return FString
function UBED_QuestNode_PlayLevelSequence:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_PlayerCastMagic : UBED_QuestNode
---@field CastType EBGUAutoTestPlayerMagicType
---@field Direction SkillDirection
---@field SkillCastConditions TArray<FAutoTestPlayerCastSkillConditionGroup>
UBED_QuestNode_PlayerCastMagic = {}

---@return FString
function UBED_QuestNode_PlayerCastMagic:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_PlayerCastSkill : UBED_QuestNode
---@field ComboKey EBGUAutoTestPlayerComboKey
---@field Direction SkillDirection
---@field SkillID int32
---@field SkillCastConditions TArray<FAutoTestPlayerCastSkillConditionGroup>
UBED_QuestNode_PlayerCastSkill = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_QuestNode_PlayerCastSkill:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_QuestNode_PlayerCastSkill:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_PlayerCondition : UBED_QuestNode
---@field ConditionConfigs TArray<FAutoTestPlayerCastSkillConditionGroup>
UBED_QuestNode_PlayerCondition = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_QuestNode_PlayerCondition:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_QuestNode_PlayerCondition:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_PlayerLockTrainDummyTarget : UBED_QuestNode
UBED_QuestNode_PlayerLockTrainDummyTarget = {}

---@return FString
function UBED_QuestNode_PlayerLockTrainDummyTarget:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_PlayerMoveToTrainDummyTarget : UBED_QuestNode
---@field MoveFinishDistance float
UBED_QuestNode_PlayerMoveToTrainDummyTarget = {}

---@return FString
function UBED_QuestNode_PlayerMoveToTrainDummyTarget:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_PlayerUseItem : UBED_QuestNode
---@field ItemId int32
UBED_QuestNode_PlayerUseItem = {}

---@return FString
function UBED_QuestNode_PlayerUseItem:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_PostAkEvent : UBED_QuestNode
---@field AkEvent TSoftObjectPtr<UAkAudioEvent>
UBED_QuestNode_PostAkEvent = {}

---@return FString
function UBED_QuestNode_PostAkEvent:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_QueryGameState : UBED_QuestNode
---@field QueryCondition QueryGameStateCondition
UBED_QuestNode_QueryGameState = {}



---@class UBED_QuestNode_QuitGame : UBED_QuestNode
UBED_QuestNode_QuitGame = {}

---@return FString
function UBED_QuestNode_QuitGame:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_RaiseAwardProbability : UBED_QuestNode
---@field EventID int32
---@field RaiseType AwardProbabilityRaiseType
---@field Probability int32
---@field CanReduce boolean
UBED_QuestNode_RaiseAwardProbability = {}

---@return FString
function UBED_QuestNode_RaiseAwardProbability:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_RemoveBuff : UBED_QuestNode
---@field UnitOrPlayer FGsSmartParam
---@field Buff FGsSmartParam
---@field BuffLayer int32
---@field BuffID int32
---@field Unit TSoftObjectPtr<ABGUCharacterCS>
---@field UnitGuid FString
---@field bPlayerAsObserveUnit boolean
UBED_QuestNode_RemoveBuff = {}

---@return FString
function UBED_QuestNode_RemoveBuff:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_Reroute : UBED_QuestNode
UBED_QuestNode_Reroute = {}


---@class UBED_QuestNode_RunProcessGraph : UBED_QuestNode
---@field Asset TSoftObjectPtr<UBED_ProcessAsset>
UBED_QuestNode_RunProcessGraph = {}

---@return UObject
function UBED_QuestNode_RunProcessGraph:GetAssetToEditInCS() end
---@param PropertyName FString
function UBED_QuestNode_RunProcessGraph:PrePropertyChanged(PropertyName) end
---@param MemberName FString
---@param PropertyName FString
function UBED_QuestNode_RunProcessGraph:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_QuestNode_RunProcessGraph:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_SaveArchive : UBED_QuestNode
---@field ArchiveLabel FName
UBED_QuestNode_SaveArchive = {}

---@return FString
function UBED_QuestNode_SaveArchive:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_SetAwardState : UBED_QuestNode
---@field EventID int32
---@field Distance int32
---@field CenterDistance int32
---@field CenterPoint FVector
---@field ConditionList TArray<AwardStateConditionType>
---@field UnitOrPlayer FGsSmartParam
---@field bPlayerAsObserveUnit boolean
---@field ObservedActor TSoftObjectPtr<ABGUCharacterCS>
UBED_QuestNode_SetAwardState = {}

---@return FString
function UBED_QuestNode_SetAwardState:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_SetCameraTransform : UBED_QuestNode
---@field CameraTag FName
---@field bCineCamera boolean
---@field CameraTransform FTransform
UBED_QuestNode_SetCameraTransform = {}



---@class UBED_QuestNode_SetInteractState : UBED_QuestNode
---@field InteractState boolean
---@field NotifySceneActor FGsSmartParam
---@field ByChallengeLevel boolean
---@field ChallengeId int32
---@field InteractorList FGsSmartParamArray
---@field IngoreHideLogic boolean
UBED_QuestNode_SetInteractState = {}

---@return FString
function UBED_QuestNode_SetInteractState:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_SetPlayerRebirthPoint : UBED_QuestNode
---@field RebirthPointId int32
UBED_QuestNode_SetPlayerRebirthPoint = {}

---@return FString
function UBED_QuestNode_SetPlayerRebirthPoint:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_SpawnBossTrace : UBED_QuestNode
---@field SpawnType TraceSpawnType
---@field TraceEfxPath TSoftObjectPtr<UBGWDataAsset_B1DBC>
UBED_QuestNode_SpawnBossTrace = {}

---@return FString
function UBED_QuestNode_SpawnBossTrace:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_Start : UBED_QuestNode
UBED_QuestNode_Start = {}


---@class UBED_QuestNode_StartWaveSpawnByChallenge : UBED_QuestNode
---@field SpawnerList FGsSmartParamArray
---@field ChallengeId int32
---@field NeedPlayMontage boolean
---@field Unit FGsSmartParam
---@field AMEasy TSoftObjectPtr<UAnimMontage>
---@field AMNoraml TSoftObjectPtr<UAnimMontage>
---@field AMHard TSoftObjectPtr<UAnimMontage>
UBED_QuestNode_StartWaveSpawnByChallenge = {}

---@return FString
function UBED_QuestNode_StartWaveSpawnByChallenge:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_StopWaveSpawnByChallenge : UBED_QuestNode
---@field SpawnerList FGsSmartParamArray
---@field ChallengeId int32
UBED_QuestNode_StopWaveSpawnByChallenge = {}

---@return FString
function UBED_QuestNode_StopWaveSpawnByChallenge:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_SubGraph : UBED_QuestNode
---@field Asset TSoftObjectPtr<UBED_QuestAsset>
UBED_QuestNode_SubGraph = {}

---@return UObject
function UBED_QuestNode_SubGraph:GetAssetToEditInCS() end
---@param PropertyName FString
function UBED_QuestNode_SubGraph:PrePropertyChanged(PropertyName) end
---@param MemberName FString
---@param PropertyName FString
function UBED_QuestNode_SubGraph:PostPropertyChanged(MemberName, PropertyName) end
---@return TArray<FName>
function UBED_QuestNode_SubGraph:GetContextInputsInCS() end
---@return TArray<FName>
function UBED_QuestNode_SubGraph:GetContextOutputsInCS() end
---@return FString
function UBED_QuestNode_SubGraph:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_SwitchCameraGroup : UBED_QuestNode
---@field CameraGroupId int32
UBED_QuestNode_SwitchCameraGroup = {}

---@return FString
function UBED_QuestNode_SwitchCameraGroup:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_Teleport : UBED_QuestNode
---@field bTeleportToOtherLevel boolean
---@field TargetLevelID int32
---@field PointName FName
---@field TargetRebirthPointId int32
---@field bDropTeleportPoint boolean
---@field DroppedTeleportPointId FName
---@field BeforeTeleportMontage TSoftObjectPtr<UAnimMontage>
---@field AfterTeleportMontage TSoftObjectPtr<UAnimMontage>
---@field bSaveArchiveAfterTeleport boolean
---@field ArchiveLabel FName
---@field bDontResetPlayerState boolean
---@field LoadingScreenType EGSLoadingScreenType
UBED_QuestNode_Teleport = {}

---@return FString
function UBED_QuestNode_Teleport:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_Timer : UBED_QuestNode
---@field CompletionTime float
---@field StepTime float
UBED_QuestNode_Timer = {}

---@return FString
function UBED_QuestNode_Timer:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_TrainDummyResultReport : UBED_QuestNode
---@field TrainDummyMgrActor FGsActorGuidReference
UBED_QuestNode_TrainDummyResultReport = {}

---@return FString
function UBED_QuestNode_TrainDummyResultReport:GetNodeDescriptionInCS() end


---@class UBED_QuestNode_UnitTeleport : UBED_QuestNode
---@field Unit FGsSmartParam
---@field SkillBeforeTeleport int32
---@field SkillAfterTeleport int32
---@field LocationType TeleportLocationType
---@field RotationType int32
---@field NotifyUnit TSoftObjectPtr<ABGUCharacterCS>
UBED_QuestNode_UnitTeleport = {}

---@return FString
function UBED_QuestNode_UnitTeleport:GetNodeDescriptionInCS() end


---@class UBED_SkillAsset : UBED_CalliopeAssetBase
UBED_SkillAsset = {}

---@return ECalliopeViewType
function UBED_SkillAsset:GetViewType() end
---@return UClass
function UBED_SkillAsset:GetStartNodeClass() end
---@return UClass
function UBED_SkillAsset:GetRerouteNodeClass() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_SkillAsset:GetExtraDefaultInputNodes(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_SkillAsset:GetExtraDefaultOutputNodes(OutClasses) end
---@return UClass
function UBED_SkillAsset:GetStartNodeClassInBranchGraph() end
---@return UClass
function UBED_SkillAsset:GetRerouteNodeClassInBranchGraph() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_SkillAsset:GetExtraDefaultInputNodesInBranchGraph(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_SkillAsset:GetExtraDefaultOutputNodesInBranchGraph(OutClasses) end


---@class UBED_SkillNode : UBED_CalliopeNodeBae
UBED_SkillNode = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_SkillNode:IsSupportViewType(InViewType) end


---@class UBED_SkillNode_Desc : UBED_SkillNode
UBED_SkillNode_Desc = {}


---@class UBED_SkillNode_Start : UBED_SkillNode
UBED_SkillNode_Start = {}


---@class UBED_StateAsset : UBED_CalliopeAssetBase
---@field PhaseBehaviorAsset UBED_BehaviorAsset
UBED_StateAsset = {}

---@return ECalliopeViewType
function UBED_StateAsset:GetViewType() end
---@return UClass
function UBED_StateAsset:GetStartNodeClass() end
---@return UClass
function UBED_StateAsset:GetRerouteNodeClass() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_StateAsset:GetExtraDefaultInputNodes(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_StateAsset:GetExtraDefaultOutputNodes(OutClasses) end
---@return UClass
function UBED_StateAsset:GetStartNodeClassInBranchGraph() end
---@return UClass
function UBED_StateAsset:GetRerouteNodeClassInBranchGraph() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_StateAsset:GetExtraDefaultInputNodesInBranchGraph(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_StateAsset:GetExtraDefaultOutputNodesInBranchGraph(OutClasses) end


---@class UBED_StateNode : UBED_CalliopeNodeBae
UBED_StateNode = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_StateNode:IsSupportViewType(InViewType) end


---@class UBED_StateNode_CustomEnter : UBED_StateNode
UBED_StateNode_CustomEnter = {}

---@return TArray<FName>
function UBED_StateNode_CustomEnter:GetContextOutputsInCS() end


---@class UBED_StateNode_CustomExit : UBED_StateNode
UBED_StateNode_CustomExit = {}

---@return TArray<FName>
function UBED_StateNode_CustomExit:GetContextInputsInCS() end


---@class UBED_StateNode_Final : UBED_StateNode
UBED_StateNode_Final = {}


---@class UBED_StateNode_Fork : UBED_StateNode
UBED_StateNode_Fork = {}

---@return boolean
function UBED_StateNode_Fork:CanUserAddOutputInCS() end


---@class UBED_StateNode_Initial : UBED_StateNode
UBED_StateNode_Initial = {}


---@class UBED_StateNode_Join : UBED_StateNode
UBED_StateNode_Join = {}

---@return boolean
function UBED_StateNode_Join:CanUserAddInputInCS() end


---@class UBED_StateNode_Junction : UBED_StateNode
---@field JunctionState FGameplayTag
UBED_StateNode_Junction = {}

---@return FString
function UBED_StateNode_Junction:GetNodeDescriptionInCS() end


---@class UBED_StateNode_Reroute : UBED_StateNode
UBED_StateNode_Reroute = {}


---@class UBED_StateNode_Single : UBED_StateNode
---@field StateName FGameplayTag
---@field SubStateMachine UBED_StateAsset
---@field SubGraphAssetInstance UBED_StateAsset
---@field Events FGameplayTagContainer
---@field DetectUnitConditions TArray<FDetectUnitCondition>
---@field OtherConditions TArray<FCompositeTransitionCondition_State>
---@field ChildActorCollection FStateNodeChildActorControl
UBED_StateNode_Single = {}

function UBED_StateNode_Single:JumpToEnterStateNode() end
---@return boolean
function UBED_StateNode_Single:IsSubGraphNode() end
function UBED_StateNode_Single:OnSelectNodeInCS() end
---@param PropertyName FString
function UBED_StateNode_Single:PrePropertyChanged(PropertyName) end
---@return UObject
function UBED_StateNode_Single:GetAssetToEditInCS() end
---@param MemberName FString
---@param PropertyName FString
function UBED_StateNode_Single:PostPropertyChanged(MemberName, PropertyName) end
---@return TArray<FName>
function UBED_StateNode_Single:GetContextInputsInCS() end
---@param InSubGraphAsset UCalliopeAsset
function UBED_StateNode_Single:SetSubGraphAssetInPIE(InSubGraphAsset) end
---@return TArray<FName>
function UBED_StateNode_Single:GetContextOutputsInCS() end
---@return FString
function UBED_StateNode_Single:GetNodeDescriptionInCS() end


---@class UBED_StateNode_Terminate : UBED_StateNode
UBED_StateNode_Terminate = {}


---@class UBED_TaskAsset : UBED_CalliopeAssetBase
---@field ManagedObjectsForTask FManagedObjectsForTask
UBED_TaskAsset = {}

---@return ECalliopeViewType
function UBED_TaskAsset:GetViewType() end
---@return boolean
function UBED_TaskAsset:IsEditorOnlyCS() end
---@return UClass
function UBED_TaskAsset:GetStartNodeClass() end
---@param PropertyName FString
---@param OutOptions TArray<FActorGuidOption>
---@return int32
function UBED_TaskAsset:GetActorGuidOptions(PropertyName, OutOptions) end
---@return UClass
function UBED_TaskAsset:GetRerouteNodeClass() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_TaskAsset:GetExtraDefaultInputNodes(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_TaskAsset:GetExtraDefaultOutputNodes(OutClasses) end
---@return UClass
function UBED_TaskAsset:GetStartNodeClassInBranchGraph() end
---@return UClass
function UBED_TaskAsset:GetRerouteNodeClassInBranchGraph() end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_TaskAsset:GetExtraDefaultInputNodesInBranchGraph(OutClasses) end
---@param OutClasses TArray<UClass>
---@return int32
function UBED_TaskAsset:GetExtraDefaultOutputNodesInBranchGraph(OutClasses) end


---@class UBED_TaskNode : UBED_CalliopeNodeBae
UBED_TaskNode = {}

---@param InViewType ECalliopeViewType
---@return boolean
function UBED_TaskNode:IsSupportViewType(InViewType) end


---@class UBED_TaskNode_ChapterClear : UBED_TaskNode
---@field ChapterID int32
UBED_TaskNode_ChapterClear = {}



---@class UBED_TaskNode_Demo820LevelAward : UBED_TaskNode
UBED_TaskNode_Demo820LevelAward = {}


---@class UBED_TaskNode_Demo820LevelPass : UBED_TaskNode
UBED_TaskNode_Demo820LevelPass = {}


---@class UBED_TaskNode_ExecutionSequence : UBED_TaskNode
UBED_TaskNode_ExecutionSequence = {}

---@return boolean
function UBED_TaskNode_ExecutionSequence:CanUserAddOutputInCS() end


---@class UBED_TaskNode_GameLevelPassFinal : UBED_TaskNode
UBED_TaskNode_GameLevelPassFinal = {}


---@class UBED_TaskNode_GamePass : UBED_TaskNode
UBED_TaskNode_GamePass = {}

---@return FString
function UBED_TaskNode_GamePass:GetNodeDescriptionInCS() end


---@class UBED_TaskNode_LogicalAnd : UBED_TaskNode
UBED_TaskNode_LogicalAnd = {}

---@return boolean
function UBED_TaskNode_LogicalAnd:CanUserAddInputInCS() end


---@class UBED_TaskNode_ObserveRoleData : UBED_TaskNode
---@field ObserveMinSuccessConditionNum int32
---@field ObserveRoleDataInfoList TArray<FObserveRoleDataInfo>
UBED_TaskNode_ObserveRoleData = {}

---@return FString
function UBED_TaskNode_ObserveRoleData:GetNodeDescriptionInCS() end


---@class UBED_TaskNode_ObserveSequence : UBED_TaskNode
---@field SequencePhase SequencePhase
---@field Sequence FGsSmartParam
---@field SuccessLimit int32
---@field SequenceID int32
UBED_TaskNode_ObserveSequence = {}

---@return FString
function UBED_TaskNode_ObserveSequence:GetNodeDescriptionInCS() end


---@class UBED_TaskNode_ObserveUnitByCondition : UBED_TaskNode
---@field SuccessLimit int32
---@field ObserveActorInfo FObserveActorInfo
UBED_TaskNode_ObserveUnitByCondition = {}

---@param MemberName FString
---@param PropertyName FString
function UBED_TaskNode_ObserveUnitByCondition:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_TaskNode_ObserveUnitByCondition:GetNodeDescriptionInCS() end


---@class UBED_TaskNode_ObserveUnitsDeadWithOrder : UBED_TaskNode
---@field UnitList FGsSmartParamArray
UBED_TaskNode_ObserveUnitsDeadWithOrder = {}

function UBED_TaskNode_ObserveUnitsDeadWithOrder:OnRefreshAssetInCS() end
---@param MemberName FString
---@param PropertyName FString
function UBED_TaskNode_ObserveUnitsDeadWithOrder:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_TaskNode_ObserveUnitsDeadWithOrder:GetNodeDescriptionInCS() end


---@class UBED_TaskNode_PrologueCompleted : UBED_TaskNode
UBED_TaskNode_PrologueCompleted = {}


---@class UBED_TaskNode_PushTaskStageState : UBED_TaskNode
---@field PushTaskStage FGsSmartParam
---@field IsPushToEnd boolean
---@field IsTriggerSaveArchive boolean
---@field ArchiveLabelParam FGsSmartParam
---@field PushTaskStageID int32
---@field ArchiveLabel FName
UBED_TaskNode_PushTaskStageState = {}

---@return FString
function UBED_TaskNode_PushTaskStageState:GetNodeDescriptionInCS() end


---@class UBED_TaskNode_QueryCompoundCondition : UBED_TaskNode
---@field ConditionRelation ConditionalRelation
---@field bReverseCondition boolean
---@field Conditions TArray<FTaskQueryConditionInfo>
UBED_TaskNode_QueryCompoundCondition = {}

---@return FString
function UBED_TaskNode_QueryCompoundCondition:GetNodeDescriptionInCS() end


---@class UBED_TaskNode_Reroute : UBED_TaskNode
UBED_TaskNode_Reroute = {}


---@class UBED_TaskNode_RunProcessGraph : UBED_TaskNode
---@field Asset TSoftObjectPtr<UBED_ProcessAsset>
UBED_TaskNode_RunProcessGraph = {}

---@return UObject
function UBED_TaskNode_RunProcessGraph:GetAssetToEditInCS() end
---@param PropertyName FString
function UBED_TaskNode_RunProcessGraph:PrePropertyChanged(PropertyName) end
---@param MemberName FString
---@param PropertyName FString
function UBED_TaskNode_RunProcessGraph:PostPropertyChanged(MemberName, PropertyName) end
---@return FString
function UBED_TaskNode_RunProcessGraph:GetNodeDescriptionInCS() end


---@class UBED_TaskNode_SaveArchive : UBED_TaskNode
---@field ArchiveLabel FName
UBED_TaskNode_SaveArchive = {}

---@return FString
function UBED_TaskNode_SaveArchive:GetNodeDescriptionInCS() end


---@class UBED_TaskNode_Start : UBED_TaskNode
UBED_TaskNode_Start = {}


---@class UBED_TaskNode_SubGraph : UBED_TaskNode
---@field Asset TSoftObjectPtr<UBED_TaskAsset>
UBED_TaskNode_SubGraph = {}

---@return UObject
function UBED_TaskNode_SubGraph:GetAssetToEditInCS() end
---@param PropertyName FString
function UBED_TaskNode_SubGraph:PrePropertyChanged(PropertyName) end
---@param MemberName FString
---@param PropertyName FString
function UBED_TaskNode_SubGraph:PostPropertyChanged(MemberName, PropertyName) end
---@return TArray<FName>
function UBED_TaskNode_SubGraph:GetContextInputsInCS() end
---@return TArray<FName>
function UBED_TaskNode_SubGraph:GetContextOutputsInCS() end
---@return FString
function UBED_TaskNode_SubGraph:GetNodeDescriptionInCS() end


---@class UBGAnimDragon : UAnimInstance
---@field ChainRootName FName
---@field ChainEndName FName
---@field Spline USplineComponent
---@field BonesRot TArray<FRotator>
---@field BonesLocCS TArray<FVector>
---@field EffectiveNumBones int32
UBGAnimDragon = {}

---@param DeltaTimeX float
function UBGAnimDragon:BlueprintUpdateAnimation(DeltaTimeX) end
function UBGAnimDragon:BlueprintInitializeAnimation() end
---@param DeltaSeconds float
function UBGAnimDragon:BlueprintThreadSafeUpdateAnimation(DeltaSeconds) end


---@class UBGAnimSpider : UAnimInstance
---@field ABPSetting UBGWDataAsset_SpiderSetting
---@field DefaultIdle UAnimSequence
---@field JumpStart UAnimSequence
---@field JumpLoop UAnimSequence
---@field JumpEndLight UAnimSequence
---@field JumpEndHeavy UAnimSequence
---@field bUseJumpEndLight boolean
---@field LegTargetCS TArray<FVector>
---@field LegRecordTargetCS TArray<FVector>
---@field LegLastTargetCS TArray<FVector>
---@field LegRatio TArray<float>
---@field LegCurTargetWS TArray<FVector>
---@field LegLastTargetWS TArray<FVector>
---@field LegTargetWS TArray<FVector>
---@field SpineTargetRot FRotator
---@field SpineLerpSpeed float
---@field SpineCurRot FRotator
---@field bIsOnPlatform boolean
---@field bIsFalling boolean
---@field bStartJump boolean
---@field bIsAISpiderMove boolean
---@field bUsePoseOverride boolean
---@field PoseSnapshot FPoseSnapshot
---@field EnableSnapshotBlendTime float
---@field DisableSnapshotBlendTime float
UBGAnimSpider = {}

---@param DeltaSeconds float
function UBGAnimSpider:BlueprintUpdateAnimation(DeltaSeconds) end
function UBGAnimSpider:BlueprintInitializeAnimation() end


---@class UBGG_GameModeDataCompB1 : UBUS_ActorBaseDataComp
UBGG_GameModeDataCompB1 = {}


---@class UBGG_GameModeDataCompStartUp : UBUS_ActorBaseDataComp
UBGG_GameModeDataCompStartUp = {}


---@class UBGG_GameStateDataCompB1 : UBUS_ActorBaseDataComp
UBGG_GameStateDataCompB1 = {}

function UBGG_GameStateDataCompB1:PreECSBeginPlay() end
function UBGG_GameStateDataCompB1:LateECSBeginPlay() end


---@class UBGS_EventCollectionCS : UBUS_EventCollection
UBGS_EventCollectionCS = {}


---@class UBGS_GSEventCollection : UGSEventCollectionBase
UBGS_GSEventCollection = {}

---@param EndPlayReason EEndPlayReason::Type
function UBGS_GSEventCollection:EndPlayInCS(EndPlayReason) end
function UBGS_GSEventCollection:BeginPlayInCS() end
---@param b1 boolean
---@param p2 int32
function UBGS_GSEventCollection:Evt_BGS_TriggerShortcutServer(b1, p2) end
---@param AkEvent UAkAudioEvent
function UBGS_GSEventCollection:Evt_PostMulticastAkEventServer(AkEvent) end
function UBGS_GSEventCollection:Evt_TeamWipeOut_Multicast_Invoke() end
---@param b1 boolean
---@param p2 int32
function UBGS_GSEventCollection:Evt_BGS_TriggerShortcutMultiCast(b1, p2) end
---@param UnitGuid FString
---@param DeadReason DeadReason
function UBGS_GSEventCollection:Evt_BGS_UnitDead_Multicast_Invoke(UnitGuid, DeadReason) end
---@param AkEvent UAkAudioEvent
function UBGS_GSEventCollection:Evt_PostMulticastAkEventMultiCast(AkEvent) end
function UBGS_GSEventCollection:Evt_CrusadeSuccess_Multicast_Invoke() end
---@param PlayerState APlayerState
function UBGS_GSEventCollection:Evt_BGS_PlayerJoin_Multicast_Invoke(PlayerState) end
---@param PlayerState APlayerState
function UBGS_GSEventCollection:Evt_BGS_PlayerLogOut_Multicast_Invoke(PlayerState) end
---@param p1 int32
function UBGS_GSEventCollection:Evt_BGS_TestGameState_Multicast_Invoke(p1) end
function UBGS_GSEventCollection:Evt_OnlineDebugInfoEnd_Multicast_Invoke() end
---@param p1 int32
function UBGS_GSEventCollection:Evt_BGS_ItemFullOnline_Multicast_Invoke(p1) end
---@param Exitting AController
function UBGS_GSEventCollection:Evt_BGS_OnPlayerLogOut_Multicast_Invoke(Exitting) end
---@param OldUnit AActor
---@param NewlySpawnedUnit AActor
function UBGS_GSEventCollection:Evt_BGS_OnUnitTransited_Multicast_Invoke(OldUnit, NewlySpawnedUnit) end
---@param NewPlayer APlayerController
function UBGS_GSEventCollection:Evt_BGS_OnPlayerPostLogin_Multicast_Invoke(NewPlayer) end
---@param OldTarget AActor
---@param NewTarget AActor
---@param TriggerTaunt boolean
---@param TargetSourceType TargetSourceType
function UBGS_GSEventCollection:Evt_BGS_NotifySwitchTarget_Multicast_Invoke(OldTarget, NewTarget, TriggerTaunt, TargetSourceType) end
---@param ScreenMsgType ScreenMsgType
---@param Msg FString
---@param TipsDuration int32
function UBGS_GSEventCollection:Evt_BGS_SendOnlineScreenMsg_Multicast_Invoke(ScreenMsgType, Msg, TipsDuration) end
---@param p1 int32
function UBGS_GSEventCollection:Evt_BGS_SwitchTickRateLogic_Multicast_Invoke(p1) end
---@param OriginActor AActor
---@param CopyActor AActor
---@param bRemoveOriginHatredInfo boolean
function UBGS_GSEventCollection:Evt_BGS_NotifyCopyHatredInfo_Multicast_Invoke(OriginActor, CopyActor, bRemoveOriginHatredInfo) end
---@param p1 int32
---@param p2 int32
function UBGS_GSEventCollection:Evt_BGS_OnlineChallengeStateTrigger_Multicast_Invoke(p1, p2) end


---@class UBGUAudioSystem : UActorComponent
---@field StateGroup FName
---@field AliveStateName FName
---@field DeadStateName FName
UBGUAudioSystem = {}

---@param Attacker AActor
function UBGUAudioSystem:OnDead(Attacker) end
function UBGUAudioSystem:ReceiveBeginPlay() end


---@class UBGUBaseOnUnitRotateComponent : USceneComponentTickable
---@field BaseOnUnitRotation FRotator
---@field OffsetLocation FVector
UBGUBaseOnUnitRotateComponent = {}

---@param BaseUnit AActor
---@param TargteRotation FRotator
---@param OffsetVector FVector
function UBGUBaseOnUnitRotateComponent:BGUSetBaseOnUnitRotation(BaseUnit, TargteRotation, OffsetVector) end
function UBGUBaseOnUnitRotateComponent:BeginPlayGS() end
---@param DeltaSeconds float
function UBGUBaseOnUnitRotateComponent:TickComponentGS(DeltaSeconds) end


---@class UBGUBoundCircleComp : USceneComponentTickable
---@field Radius float
---@field DragSpeed float
---@field BackSpeed float
---@field TimeStep float
---@field DrawDebug boolean
UBGUBoundCircleComp = {}

---@param DragVectorInWorld FVector
---@param DragFactor float
function UBGUBoundCircleComp:AddDragVec(DragVectorInWorld, DragFactor) end
---@param IsEnabled boolean
function UBGUBoundCircleComp:SetGSEnabled(IsEnabled) end
function UBGUBoundCircleComp:GSTmpBeginPlay() end
function UBGUBoundCircleComp:BeginPlayGS() end
---@param DeltaTime float
function UBGUBoundCircleComp:TickComponentGS(DeltaTime) end


---@class UBGUCopyABPSettingComp : UBaseActorComp
UBGUCopyABPSettingComp = {}

function UBGUCopyABPSettingComp:BeginPlayInCS() end


---@class UBGUCreateDeadConfigComp : UBaseActorComp
---@field SmallSizeUDDConfig UBGWDataAsset_UnitDeathDispConfig
---@field MediumSizeUDDConfig UBGWDataAsset_UnitDeathDispConfig
---@field MediumBigSizeUDDConfig UBGWDataAsset_UnitDeathDispConfig
---@field BigSizeUDDConfig UBGWDataAsset_UnitDeathDispConfig
---@field HugeSizeUDDConfig UBGWDataAsset_UnitDeathDispConfig
UBGUCreateDeadConfigComp = {}

---@param DeltaSeconds float
function UBGUCreateDeadConfigComp:ReceiveTick(DeltaSeconds) end
function UBGUCreateDeadConfigComp:BeginPlayInCS() end


---@class UBGUEQSFunctionBinder : UBGUFunctionBinder
---@field EQSObject UBGUEQSObject
UBGUEQSFunctionBinder = {}

---@param Results TArray<FVector>
---@param Scores TArray<float>
---@param ExParam FGSEQSExParam
---@param QueryID int32
function UBGUEQSFunctionBinder:OnEQSFinish(Results, Scores, ExParam, QueryID) end


---@class UBGUFuncLibAICS : UBlueprintFunctionLibrary
UBGUFuncLibAICS = {}

---@param Unit AActor
---@param MoveForwardValue float
---@param MoveHorizonValue float
---@return int32
function UBGUFuncLibAICS:BGUAISideWalk(Unit, MoveForwardValue, MoveHorizonValue) end
---@param Unit AActor
---@param RequestIdx int32
function UBGUFuncLibAICS:BGUCancelAIMoveTo(Unit, RequestIdx) end
---@param Unit AActor
---@param bEnable boolean
function UBGUFuncLibAICS:BGUAISwitchSideWalk(Unit, bEnable) end
---@param Unit AActor
---@param FSMEvent EBGUFSMEventName
function UBGUFuncLibAICS:BGUAITriggerFSMEvent(Unit, FSMEvent) end
---@param Unit AActor
function UBGUFuncLibAICS:BGUCancelAICurrentMove(Unit) end
---@param Unit ABGUCharacterCS
---@param IsInBattle boolean
function UBGUFuncLibAICS:BGUUpdateUnitBattleState(Unit, IsInBattle) end
---@param Unit AActor
---@param Montage UAnimMontage
---@param ScaleRate float
---@param PlayTimeRate float
---@param PosOffset float
---@return int32
function UBGUFuncLibAICS:BGURequestAIMontageMoveTo(Unit, Montage, ScaleRate, PlayTimeRate, PosOffset) end
---@param Unit AActor
function UBGUFuncLibAICS:BGUAISetUnitTargetAsPlayer(Unit) end
---@param Unit AActor
---@param position FVector
---@param SpeedRateType EAIMoveSpeedType
---@param AcceptableRadius float
---@param MoveAIType EBGUMoveAIType
---@param IncludeSelfRadius boolean
---@param IncludeTargetRadius boolean
---@return int32
function UBGUFuncLibAICS:BGURequestAIMoveToLocation(Unit, position, SpeedRateType, AcceptableRadius, MoveAIType, IncludeSelfRadius, IncludeTargetRadius) end
---@param WorldContextObject UObject
function UBGUFuncLibAICS:BGUAISetUnitsTargetAsPlayer(WorldContextObject) end
---@param Unit AActor
---@param SkillID int32
---@param SourceType CastSkillSourceType
---@return int32
function UBGUFuncLibAICS:BGURequestAIUseSkillWithSkillID(Unit, SkillID, SourceType) end
---@param Unit AActor
---@param position FVector
---@param SpeedRateType EAIMoveSpeedType
---@param AcceptableRadius float
---@param MoveAIType EBGUMoveAIType
---@param IncludeSelfRadius boolean
---@param IncludeTargetRadius boolean
---@param MotionMatchingState State_MM
---@return int32
function UBGUFuncLibAICS:BGURequestAIMoveToLocationWithMM(Unit, position, SpeedRateType, AcceptableRadius, MoveAIType, IncludeSelfRadius, IncludeTargetRadius, MotionMatchingState) end
---@param Unit AActor
---@param position FVector
---@param SpeedRateType EAIMoveSpeedType
---@param turnSpeed float
---@param AcceptableRadius float
---@param IncludeSelfRadius boolean
---@return int32
function UBGUFuncLibAICS:BGURequestAIWallAndCellMoveToLocation(Unit, position, SpeedRateType, turnSpeed, AcceptableRadius, IncludeSelfRadius) end
---@param WorldContextObject UObject
---@param MatchTag FName
function UBGUFuncLibAICS:BGUAISetUnitsTargetAsPlayerByTamerActorTag(WorldContextObject, MatchTag) end


---@class UBGUFuncLibAnim : UBlueprintFunctionLibrary
UBGUFuncLibAnim = {}

---@param Owner AActor
function UBGUFuncLibAnim:BGURootMotionJumpEnd(Owner) end
---@param Owner AActor
---@param bUseSnapshot boolean
---@param BlendTime float
function UBGUFuncLibAnim:BGUSetUseSnapshotPose(Owner, bUseSnapshot, BlendTime) end
---@param Owner AActor
---@param Montage UAnimMontage
---@param StartSectionName FName
---@param Reason MontageBindReason
---@param Scale float
---@param PlayTimeRate float
---@param MontagePosOffset float
---@return float
function UBGUFuncLibAnim:BGUActorTryPlayMontage(Owner, Montage, StartSectionName, Reason, Scale, PlayTimeRate, MontagePosOffset) end
---@param Owner AActor
function UBGUFuncLibAnim:BGURootMotionJumpStart(Owner) end
---@param Owner AActor
---@param State GlideMoveAnimState
function UBGUFuncLibAnim:BGUSetGlideMoveAnimState(Owner, State) end
---@param Owner AActor
---@param State ParkourMoveAnimState
function UBGUFuncLibAnim:BGUSetParkourMoveAnimState(Owner, State) end
---@param Owner AActor
function UBGUFuncLibAnim:BGUSplineMoveEnterStopState(Owner) end
---@param Owner AActor
function UBGUFuncLibAnim:BGUPlayerLocomotionStartIdle(Owner) end
---@param Owner AActor
---@param IsPlaying boolean
function UBGUFuncLibAnim:BGUSetCharacterMontagePlaying(Owner, IsPlaying) end
---@param Owner AActor
---@param MonsterLocomotionAnimInst UAnimInstance
function UBGUFuncLibAnim:BGUMonsterLocomotionLockStopLeft(Owner, MonsterLocomotionAnimInst) end
---@param Owner AActor
---@param MonsterLocomotionAnimInst UAnimInstance
function UBGUFuncLibAnim:BGUMonsterLocomotionLockStopRight(Owner, MonsterLocomotionAnimInst) end
---@param Owner AActor
---@param MonsterLocomotionAnimInst UAnimInstance
function UBGUFuncLibAnim:BGUMonsterLocomotionEnterMoveLoop(Owner, MonsterLocomotionAnimInst) end
---@param Owner AActor
---@param MoveDir MoveDirectionEight
function UBGUFuncLibAnim:BGUSetMonsterLocomotionLockMoveDir(Owner, MoveDir) end
---@param Owner AActor
---@param Direction LockMoveDirectionSix
function UBGUFuncLibAnim:BGUPlayerLocomotionLockTurnStopDir(Owner, Direction) end
---@param Owner AActor
function UBGUFuncLibAnim:BGUPlayerLocomotionEnterLockMoveState(Owner) end
---@param CPG UBED_ProcessAsset
---@param TargetAction IdleProcessActionType
---@return boolean
function UBGUFuncLibAnim:BGUTryFindCPGIdleNodeWithoutResetGroup(CPG, TargetAction) end
---@param Owner AActor
---@param Direction LockMoveDirectionSix
function UBGUFuncLibAnim:BGUSetPlayerLocomotionLockMoveDirection(Owner, Direction) end


---@class UBGUFuncLibDeviceInfoCS : UBlueprintFunctionLibrary
UBGUFuncLibDeviceInfoCS = {}


---@class UBGUFuncLibGMCS : UBlueprintFunctionLibrary
UBGUFuncLibGMCS = {}

---@param Chr ABGUCharacterCS
function UBGUFuncLibGMCS:TestECSWorldObj(Chr) end
---@return boolean
function UBGUFuncLibGMCS:IsShenZhenDebug() end
---@param Chr ABGUCharacterCS
function UBGUFuncLibGMCS:PrintTestECSWorldObj(Chr) end
---@param Chr ABGUCharacterCS
function UBGUFuncLibGMCS:TestDestroyECSWorldObj(Chr) end
---@param Chr ABGUCharacterCS
function UBGUFuncLibGMCS:TestReleaseECSWorldObjRef(Chr) end


---@class UBGUFuncLibInput : UBlueprintFunctionLibrary
UBGUFuncLibInput = {}

---@return boolean
function UBGUFuncLibInput:IsGamepadType() end
---@param WorldContext UObject
---@param IsOpen boolean
---@param ChangeReason EGSInputModeChangeReason
function UBGUFuncLibInput:SetSuperUserInputMode(WorldContext, IsOpen, ChangeReason) end
---@param bOpen boolean
function UBGUFuncLibInput:OpenAcceptNavigationAction(bOpen) end


---@class UBGUFuncLibMap : UBlueprintFunctionLibrary
UBGUFuncLibMap = {}


---@class UBGUFuncLibMeshCS : UBlueprintFunctionLibrary
UBGUFuncLibMeshCS = {}

---@param SkeletalMeshComp USkeletalMeshComponent
---@param BaseBoneName FName
---@param ChildBoneNames TArray<FName>
---@return int32
function UBGUFuncLibMeshCS:GetChildBones(SkeletalMeshComp, BaseBoneName, ChildBoneNames) end


---@class UBGUFuncLibNonRuntime : UBlueprintFunctionLibrary
UBGUFuncLibNonRuntime = {}

---@param Assets UAssetDataArray
---@return UObject
function UBGUFuncLibNonRuntime:GetCDO(Assets) end
---@return FString
function UBGUFuncLibNonRuntime:TestCode() end
---@param Unit AActor
---@param SkillID int32
---@return boolean
function UBGUFuncLibNonRuntime:SkillSVaild(Unit, SkillID) end
---@param PathWithGameHead FString
---@param FullPath FString
---@return boolean
function UBGUFuncLibNonRuntime:BGUIsFileExist(PathWithGameHead, FullPath) end
function UBGUFuncLibNonRuntime:CheckBuffRemove() end
function UBGUFuncLibNonRuntime:ScanCBGTemplate() end
---@param Src UBGWDataAsset_AbpHumanoidSetting
---@param Dest UBGWDataAsset_AbpHumanoidSetting
function UBGUFuncLibNonRuntime:BGUCopyABPSetting(Src, Dest) end
---@param Assets UAssetDataArray
---@return TArray<UShapeComponent>
function UBGUFuncLibNonRuntime:GetResIDFromAsset(Assets) end
---@param Spawnner AActor
---@param Target AActor
---@param ProjectileSpawnConfig UBGWDataAsset_ProjectileSpawnConfig
function UBGUFuncLibNonRuntime:ProjectileSpawnTest(Spawnner, Target, ProjectileSpawnConfig) end
---@param WorldContext UObject
---@return FString
function UBGUFuncLibNonRuntime:CheckHitMoveCapsules(WorldContext) end
---@param Assets UAssetDataArray
---@return int32
function UBGUFuncLibNonRuntime:GetResIDFromUnitAsset(Assets) end
---@param UDDC UBGWDataAsset_UnitDeathDispConfig
function UBGUFuncLibNonRuntime:BindDeathDispAMInUDDC(UDDC) end
---@param PathList_Exist TArray<FString>
function UBGUFuncLibNonRuntime:GetAllProjectileBPPath(PathList_Exist) end
---@param ActorComp UActorComponent
---@param bIsEditorOnly boolean
function UBGUFuncLibNonRuntime:SetActorCompEditorOnly(ActorComp, bIsEditorOnly) end
---@param UBAC UBGWDataAsset_UnitBeAttackedConfig
function UBGUFuncLibNonRuntime:BindNormalStiffAMInUBAC(UBAC) end
---@param AnimSequence UAnimSequence
---@param LeftFootBoneName FName
---@param RightFootBoneName FName
---@param FootLockHeight float
---@param FootUnlockHeight float
---@param FootLockSpeed float
---@param FootUnlockSpeed float
function UBGUFuncLibNonRuntime:BGUAutoAddFootLockCurve(AnimSequence, LeftFootBoneName, RightFootBoneName, FootLockHeight, FootUnlockHeight, FootLockSpeed, FootUnlockSpeed) end
---@param AssetPathName FString
---@param AssetName FString
---@return FString
function UBGUFuncLibNonRuntime:GetOriFilePathByAssetPath(AssetPathName, AssetName) end
---@param PathList_Exist TArray<FString>
---@return int32
function UBGUFuncLibNonRuntime:UpdateHitAudioPreloadList(PathList_Exist) end
---@param bCheckBasicRuleOnly boolean
---@return FString
function UBGUFuncLibNonRuntime:CheckBeAttacked2Resources(bCheckBasicRuleOnly) end
---@param CurrentUsedBPPath TArray<FString>
function UBGUFuncLibNonRuntime:GetAllSummonBPPathFromDesc(CurrentUsedBPPath) end
---@param WorldContext UObject
---@return FString
function UBGUFuncLibNonRuntime:CheckUnitCapsuleCollisions(WorldContext) end
function UBGUFuncLibNonRuntime:Analysis_BuffUseSimpleState() end
---@param TamerActor ABUTamerActor
---@param AudioPath FSoftObjectPath
---@return boolean
function UBGUFuncLibNonRuntime:BGUSetUpDefaultFootstepAudio(TamerActor, AudioPath) end
---@param Assets UAssetDataArray
---@return TSubclassOf<ABGUCharacterCS>
function UBGUFuncLibNonRuntime:GetTemplateClassFromUnitAsset(Assets) end
---@param BlameName FString
function UBGUFuncLibNonRuntime:BGUMigrateDataFromUnitCommDesc(BlameName) end
---@param AnimMontage UAnimMontage
---@param SpeedThreshold float
---@param BuffID int32
---@param NewNotifyStateClass TSubclassOf<UAnimNotifyState>
---@param FirstRemoveAddBuffID boolean
---@param SocketName FString
---@param TickTime float
function UBGUFuncLibNonRuntime:BGUAddNofityStateByPelvisSpeed(AnimMontage, SpeedThreshold, BuffID, NewNotifyStateClass, FirstRemoveAddBuffID, SocketName, TickTime) end
---@param WorldContext UObject
---@param RecordFilePath FString
function UBGUFuncLibNonRuntime:BGUEditorRecordSubLevelsInWorld(WorldContext, RecordFilePath) end
---@param Montage UAnimMontage
function UBGUFuncLibNonRuntime:AddMagicallyChangeFadeOutNotify(Montage) end
function UBGUFuncLibNonRuntime:Analysis_BuffUseSpecialHitPartID() end
---@param JsonPath FString
---@param Actors TArray<AActor>
function UBGUFuncLibNonRuntime:BGUSerializeActorTransformsToJson(JsonPath, Actors) end
---@param BlameName FString
function UBGUFuncLibNonRuntime:BGUMigrateDataFromSkillEffectDesc(BlameName) end
---@param ResID int32
---@param Mesh USkeletalMeshComponent
---@return float
function UBGUFuncLibNonRuntime:BGUGetLeftFootHeightByFootStepConfig(ResID, Mesh) end
---@param JsonPath FString
---@param ActorsToDeserialize TArray<AActor>
function UBGUFuncLibNonRuntime:BGUDeserializeActorTransformsFromJson(JsonPath, ActorsToDeserialize) end
---@param AnimSequence UAnimSequence
---@param LeftFootBoneName FName
---@param RightFootBoneName FName
---@param GroundFootLimitHeight float
---@return boolean
function UBGUFuncLibNonRuntime:BGUAutoAddFootSyncMarkerToAnimSequence(AnimSequence, LeftFootBoneName, RightFootBoneName, GroundFootLimitHeight) end
---@param LevelAsset FString
---@param RecordFilePath FString
function UBGUFuncLibNonRuntime:BGUEditorRecordSubLevelsInLevelPackage(LevelAsset, RecordFilePath) end
---@param BlameName FString
function UBGUFuncLibNonRuntime:BGUMigrateDataFromUnitCommDesc_OverrideData(BlameName) end


---@class UBGUFuncLibPlayer : UBlueprintFunctionLibrary
UBGUFuncLibPlayer = {}


---@class UBGUFuncLibProceduralMap : UBlueprintFunctionLibrary
UBGUFuncLibProceduralMap = {}

---@param MapInfo FMapProceduralInfo
---@return boolean
function UBGUFuncLibProceduralMap:BuildDemoMapInfo(MapInfo) end
---@param MapInfo FMapProceduralInfo
---@param AllowedGeneralCatDir MapCatFlag
---@param AllowedEntranceOutCatDir MapCatFlag
---@param AllowedExitInCatDir MapCatFlag
function UBGUFuncLibProceduralMap:MapConnectAllPoints(MapInfo, AllowedGeneralCatDir, AllowedEntranceOutCatDir, AllowedExitInCatDir) end
---@param MapInfo FMapProceduralInfo
function UBGUFuncLibProceduralMap:MapPopulateWithPoints(MapInfo) end
---@param MapConfigDataAsset UBGWProceduralMapConfigDataAsset
---@param MapBlockMappingInfo UBGWProceduralMapBlockMappingDataAsset
---@param MapLightInfo UBGWCustomLightConfigDataAsset
---@param MapInfo FMapProceduralInfo
function UBGUFuncLibProceduralMap:InitProceduralMapConfig(MapConfigDataAsset, MapBlockMappingInfo, MapLightInfo, MapInfo) end
---@param MapInfo FMapProceduralInfo
---@return boolean
function UBGUFuncLibProceduralMap:BuildWildernessLinearInfo(MapInfo) end
---@param MapInfo FMapProceduralInfo
---@return boolean
function UBGUFuncLibProceduralMap:GenerateProceduralMapData(MapInfo) end
---@param MapInfo FMapProceduralInfo
---@return boolean
function UBGUFuncLibProceduralMap:BuildProceduralDungeonsInfo(MapInfo) end


---@class UBGUFuncLibProjectile : UBlueprintFunctionLibrary
UBGUFuncLibProjectile = {}

---@param ProjectileID int32
---@return int32
function UBGUFuncLibProjectile:GetProjectileType(ProjectileID) end
---@param BuffID int32
---@return TArray<BuffAndSkillEffectType>
function UBGUFuncLibProjectile:GetBuffEffectTypes(BuffID) end
---@param CurCharacter ABGUCharacterCS
---@param ProjectileID int32
---@return AActor
function UBGUFuncLibProjectile:GetCtrProjectileByID(CurCharacter, ProjectileID) end
---@param ErrorBPPathList TArray<FString>
function UBGUFuncLibProjectile:CheckCompHasChildComp(ErrorBPPathList) end
---@return TArray<int32>
function UBGUFuncLibProjectile:CheckBuffUsedInBullet() end
---@param CheckOutMap FString
---@return boolean
function UBGUFuncLibProjectile:CheckOutAllProjectileBP(CheckOutMap) end
---@param ErrorLog FString
---@return boolean
function UBGUFuncLibProjectile:FindProjectileAboutFlame(ErrorLog) end
---@return TArray<int32>
function UBGUFuncLibProjectile:CheckBuffDispUsedInBullet() end
---@param ErrorLog FString
---@param MarkDirtyList TArray<FString>
---@return boolean
function UBGUFuncLibProjectile:ProjectileAssetCheck_Full(ErrorLog, MarkDirtyList) end
---@param ProjectileBaseActor_CDO ABGUProjectileBaseActor
---@param ErrorLog FString
---@param bNeedLoadData boolean
---@return boolean
function UBGUFuncLibProjectile:ProjectileAssetCheck_Single(ProjectileBaseActor_CDO, ErrorLog, bNeedLoadData) end
---@param ProjectileBaseActor_CDO ABGUProjectileBaseActor
---@param BP UBlueprint
---@param CheckShape ProjectileCheckShapeType
---@param ErrorLog FString
---@param bNeedLoadData boolean
---@return boolean
function UBGUFuncLibProjectile:CreateCheckCompForProjectile(ProjectileBaseActor_CDO, BP, CheckShape, ErrorLog, bNeedLoadData) end
---@param ProjectileBaseActor_CDO ABGUProjectileBaseActor
---@param BP UBlueprint
---@param CheckShape ProjectileCheckShapeType
---@param ErrorLog FString
---@return boolean
function UBGUFuncLibProjectile:ModifyProjectileCheckShapeType(ProjectileBaseActor_CDO, BP, CheckShape, ErrorLog) end
---@return FString
function UBGUFuncLibProjectile:CheckEffectsUsedInBulletExpand() end
---@param ProjectileBaseActor_CDO ABGUProjectileBaseActor
---@param BP UBlueprint
---@param ErrorLog FString
---@return boolean
function UBGUFuncLibProjectile:CreateInteractCompForProjectile(ProjectileBaseActor_CDO, BP, ErrorLog) end
---@param ErrorLog FString
function UBGUFuncLibProjectile:ProjectileAssetMoveCompToBP_Full(ErrorLog) end
---@param ProjectileBaseActor_CDO ABGUProjectileBaseActor
---@param BP UBlueprint
---@param ErrorLog FString
---@param bNeedLoadData boolean
function UBGUFuncLibProjectile:ProjectileAssetMoveCompToBP_Single(ProjectileBaseActor_CDO, BP, ErrorLog, bNeedLoadData) end
---@param CurrentUsedBPPath TArray<FString>
function UBGUFuncLibProjectile:GetAllProjectileBPPathFromDesc_with_C(CurrentUsedBPPath) end
---@param CurrentUsedBPPath TArray<FString>
function UBGUFuncLibProjectile:GetAllProjectileBPPathFromDesc_without_C(CurrentUsedBPPath) end


---@class UBGUFuncLibReplication : UBlueprintFunctionLibrary
UBGUFuncLibReplication = {}

---@param Owner AActor
---@return int32
function UBGUFuncLibReplication:GetActorNetRole(Owner) end


---@class UBGUFuncLibResCS : UBlueprintFunctionLibrary
UBGUFuncLibResCS = {}

---@param WorldContext UObject
---@param IsB1 boolean
---@param BeginResID int32
---@param EndResID int32
---@param NeedDeleteBHCatalogList TArray<FString>
---@param Result TArray<FMoveAMPath>
function UBGUFuncLibResCS:BGUCopyAndRenameBHAM(WorldContext, IsB1, BeginResID, EndResID, NeedDeleteBHCatalogList, Result) end
---@param BeginResID int32
---@param EndResID int32
---@param NeedDeleteDeadAMCatalogList TArray<FString>
---@param Result TArray<FMoveAMPath>
function UBGUFuncLibResCS:BGUCopyAndRenameDEADAM(BeginResID, EndResID, NeedDeleteDeadAMCatalogList, Result) end
---@param Objects TArray<UObject>
---@param FailedPackages TArray<UPackage>
---@param bCheckDirty boolean
---@param bPromptToSave boolean
---@param bAlreadyCheckedOut boolean
---@param bCanBeDeclined boolean
---@return boolean
function UBGUFuncLibResCS:CheckoutAndSavePackage(Objects, FailedPackages, bCheckDirty, bPromptToSave, bAlreadyCheckedOut, bCanBeDeclined) end
---@param InMontage UAnimMontage
---@param TrackName FName
---@param StartPos float
---@param Duration float
---@param NotifyClass TSubclassOf<UBANS_GSBase>
---@param bRemoveOldTrack boolean
function UBGUFuncLibResCS:BGUAddNotifyStateToMontage(InMontage, TrackName, StartPos, Duration, NotifyClass, bRemoveOldTrack) end
---@param UDDConfig UBGWDataAsset_UnitDeathDispConfig
---@param NormalDeadAMPath FString
---@param UnitResName FString
function UBGUFuncLibResCS:BGUSetUnitNameForUDDConfig(UDDConfig, NormalDeadAMPath, UnitResName) end
---@param UBAConfig UBGWDataAsset_UnitBeAttackedConfig
---@param NormalStiffAMPath FString
---@param UnitResName FString
function UBGUFuncLibResCS:BGUSetUnitNameForUBAConfig(UBAConfig, NormalStiffAMPath, UnitResName) end
---@param InMontage UAnimMontage
---@return int32
function UBGUFuncLibResCS:BGUGetNewSweepCheckGroupIdInAM(InMontage) end
---@param InMontage UAnimMontage
---@param Thresholds float
---@param BoneName FName
function UBGUFuncLibResCS:BGUAddBlendPhysicToDeathMontage(InMontage, Thresholds, BoneName) end
function UBGUFuncLibResCS:BGUCopyInfoFromUnitComm2UnitDead() end
---@param InMontage UAnimMontage
function UBGUFuncLibResCS:BGUAddLifeSavingHairWindowToDeathMontage(InMontage) end
---@param LevelName FString
---@return FString
function UBGUFuncLibResCS:GetLevelAllLevelStreamingDataAssetConfigByCPG(LevelName) end
---@param Volume ABGWLevelStreamingStateVolume
---@return FString
function UBGUFuncLibResCS:GetLevelStreamingStateVolumeControlledLevelInfo(Volume) end


---@class UBGUFuncLibSceneObj : UBlueprintFunctionLibrary
UBGUFuncLibSceneObj = {}


---@class UBGUFuncLibSelectTargetsCS : UBlueprintFunctionLibrary
UBGUFuncLibSelectTargetsCS = {}

---@param Unit AActor
function UBGUFuncLibSelectTargetsCS:DeadPhyTest(Unit) end
---@param Unit AActor
function UBGUFuncLibSelectTargetsCS:DeadPhyReset(Unit) end


---@class UBGUFuncLibSkillCS : UBlueprintFunctionLibrary
UBGUFuncLibSkillCS = {}

---@param Unit AActor
---@return int32
function UBGUFuncLibSkillCS:BGUGetLastSkillID(Unit) end
---@param Unit ACharacter
---@return int32
function UBGUFuncLibSkillCS:BGUGetCastingSkillID(Unit) end
---@param Unit AActor
---@param SkillID int32
---@return float
function UBGUFuncLibSkillCS:BGUGetLastSkillCastTime(Unit, SkillID) end
---@param Unit ACharacter
---@param TargetPos FVector
---@param NotifyBeginTime float
---@param NotifyEndTime float
---@param AMScaleMinRate float
---@param AMScaleMaxRate float
---@param AMScaleMoveOffset float
---@param AMScaleMoveOffsetZ float
---@param EnableDebug boolean
---@return FVector
function UBGUFuncLibSkillCS:BGUCalcSkillMontageScaleRate(Unit, TargetPos, NotifyBeginTime, NotifyEndTime, AMScaleMinRate, AMScaleMaxRate, AMScaleMoveOffset, AMScaleMoveOffsetZ, EnableDebug) end


---@class UBGUFuncLibWXLogin : UBlueprintFunctionLibrary
UBGUFuncLibWXLogin = {}

---@param WorldCtx UObject
---@return FString
function UBGUFuncLibWXLogin:GetIpList(WorldCtx) end
---@param WorldCtx UObject
---@return TArray<FString>
function UBGUFuncLibWXLogin:LoadUserInfo(WorldCtx) end
---@param WorldCtx UObject
---@param Val FString
---@return int32
function UBGUFuncLibWXLogin:SaveUserInfo(WorldCtx, Val) end
---@param WorldCtx UObject
---@return FString
function UBGUFuncLibWXLogin:ReadLoginCookie(WorldCtx) end
---@param WorldCtx UObject
---@param Val FString
---@return int32
function UBGUFuncLibWXLogin:WriteLoginCookie(WorldCtx, Val) end
---@param WorldCtx UObject
---@param Params TArray<FString>
function UBGUFuncLibWXLogin:QywxLoginSuccess(WorldCtx, Params) end


---@class UBGUFunclibEditorUtility : UBlueprintFunctionLibrary
UBGUFunclibEditorUtility = {}

---@param Infos TArray<FString>
---@param CSVPath FString
function UBGUFunclibEditorUtility:PrintStringsToCSV(Infos, CSVPath) end
---@param AMPath FString
---@return TArray<int32>
function UBGUFunclibEditorUtility:GetSkillIDByAMPath(AMPath) end
---@param SkillID int32
---@return FString
function UBGUFunclibEditorUtility:GetAMPathBySkillID(SkillID) end
---@param Actor AActor
function UBGUFunclibEditorUtility:SwitchDebugWidgetState(Actor) end
---@param Level ULevel
---@return TArray<AActor>
function UBGUFunclibEditorUtility:GetAllSkeletalActorInLevel(Level) end
---@param Actor AActor
---@return boolean
function UBGUFunclibEditorUtility:CheckIsActorInactiveManaged(Actor) end
---@param LevelSkeletalMeshInfo TArray<FLevelSkeletalMeshCheckInfoHelper>
---@param CSVPath FString
function UBGUFunclibEditorUtility:PrintSkeletalMeshPerfInfoCSV(LevelSkeletalMeshInfo, CSVPath) end
---@param InActor AActor
function UBGUFunclibEditorUtility:SetupSkeletalActorInactiveInfo(InActor) end
---@param SelectedLevels TArray<FString>
---@return TArray<FLevelSkeletalMeshCheckInfoHelper>
function UBGUFunclibEditorUtility:GetAllSkeletalActorWithoutPerfFromSelected(SelectedLevels) end


---@class UBGUFunctionBinder : UObject
UBGUFunctionBinder = {}


---@class UBGUFunctionLibraryCS : UBlueprintFunctionLibrary
UBGUFunctionLibraryCS = {}

---@param Unit AActor
function UBGUFunctionLibraryCS:BGUGMDead(Unit) end
---@param Unit AActor
---@param AttrType EBGUAttrFloat
---@param AddValue float
function UBGUFunctionLibraryCS:GM_AddAttr(Unit, AttrType, AddValue) end
---@param Caster AActor
---@param Target AActor
---@param BuffID int32
---@param BuffSourceType BuffSourceType
---@param BuffDurationTimer float
function UBGUFunctionLibraryCS:BGUAddBuff(Caster, Target, BuffID, BuffSourceType, BuffDurationTimer) end
---@param OwnerActor AActor
---@param RTType RenderTargetType
---@return UTextureRenderTarget2D
function UBGUFunctionLibraryCS:GetRTForFX(OwnerActor, RTType) end
---@param Owner AActor
---@param DBCPath FString
function UBGUFunctionLibraryCS:BGUDBCTest(Owner, DBCPath) end
---@param A FVector
function UBGUFunctionLibraryCS:TestVector(A) end
---@param Unit AActor
---@param BuffID EBPBuffID
---@return boolean
function UBGUFunctionLibraryCS:BGUHasBuff(Unit, BuffID) end
---@param Unit AActor
function UBGUFunctionLibraryCS:UnitSuicide(Unit) end
---@param Unit AActor
---@return int32
function UBGUFunctionLibraryCS:BGUGetResID(Unit) end
---@param Unit AActor
function UBGUFunctionLibraryCS:DicSortTest(Unit) end
---@param Actor APawn
---@param ID int32
function UBGUFunctionLibraryCS:ChangeEquip(Actor, ID) end
---@param Unit AActor
---@param AttrCostType AttrCostType
---@param CostBase float
---@param CostRatio float
function UBGUFunctionLibraryCS:BGUCostAttr(Unit, AttrCostType, CostBase, CostRatio) end
---@param InWorldContext UObject
---@param InAudioEvent UAkAudioEvent
---@return int32
function UBGUFunctionLibraryCS:PlayUISound(InWorldContext, InAudioEvent) end
---@param Unit AActor
---@param SimpleState EBGUSimpleState
function UBGUFunctionLibraryCS:BGUTestEnum(Unit, SimpleState) end
---@param WorldContext UObject
---@return boolean
function UBGUFunctionLibraryCS:CanShutdown(WorldContext) end
---@param CameraActor ACameraActor
---@return float
function UBGUFunctionLibraryCS:GetCameraFOV(CameraActor) end
---@param Unit AActor
---@return AActor
function UBGUFunctionLibraryCS:BGUGetTarget(Unit) end
---@param CameraActor ACameraActor
---@param NewFOV float
function UBGUFunctionLibraryCS:SetCameraFOV(CameraActor, NewFOV) end
---@param Unit AActor
---@param AttrID EBGUAttrFloat
---@return float
function UBGUFunctionLibraryCS:GetAttrValue(Unit, AttrID) end
---@param Unit AActor
function UBGUFunctionLibraryCS:BGUShowFPSUI(Unit) end
---@param Actor AActor
---@param Cmd FString
---@param JustRunInBin boolean
function UBGUFunctionLibraryCS:RunGMCommand(Actor, Cmd, JustRunInBin) end
---@return TArray<int32>
function UBGUFunctionLibraryCS:GetAllEquipId() end
function UBGUFunctionLibraryCS:RefreshGameDB() end
---@param WorldContext UObject
function UBGUFunctionLibraryCS:StopFetchTick(WorldContext) end
---@param Unit AActor
---@return boolean
function UBGUFunctionLibraryCS:BGUIsUnitDead(Unit) end
---@param Unit AActor
---@param BuffID int32
---@param EffectTriggerType BuffEffectTriggerType
---@param Layer int32
function UBGUFunctionLibraryCS:BGURemoveBuff(Unit, BuffID, EffectTriggerType, Layer) end
---@param _World UWorld
---@param ActorClass TSubclassOf<AActor>
---@param Location FVector
---@param Rotation FRotator
---@return AActor
function UBGUFunctionLibraryCS:BGUSpawnActor(_World, ActorClass, Location, Rotation) end
---@param Unit AActor
---@param EffectID int32
function UBGUFunctionLibraryCS:TriggerEffect(Unit, EffectID) end
---@param SeqActor ABGUPerformerActor
---@param EquipID int32
function UBGUFunctionLibraryCS:SeqChangeEquip(SeqActor, EquipID) end
---@param SelfUnit AActor
---@param OtherUnit AActor
---@return boolean
function UBGUFunctionLibraryCS:BGUIsEnemyTeam(SelfUnit, OtherUnit) end
---@param Unit AActor
---@param BuffID int32
---@return boolean
function UBGUFunctionLibraryCS:BGUHasBuffByID(Unit, BuffID) end
---@param Unit AActor
function UBGUFunctionLibraryCS:PlayPigsyStory(Unit) end
---@param Querier AActor
---@param Env UEnvQuery
function UBGUFunctionLibraryCS:RunEQSForDebug(Querier, Env) end
---@param A FKeyEvent
function UBGUFunctionLibraryCS:TestInputEvent(A) end
---@param Actor AActor
---@param Type PhysAnimType
function UBGUFunctionLibraryCS:SetPhysSetting(Actor, Type) end
---@param Owner AActor
function UBGUFunctionLibraryCS:BGUClearWeapon(Owner) end
---@param Unit AActor
---@param BreakAnimId int32
function UBGUFunctionLibraryCS:BreakCloudMove(Unit, BreakAnimId) end
---@param Unit AActor
function UBGUFunctionLibraryCS:BGUHideLevelUI(Unit) end
---@return boolean
function UBGUFunctionLibraryCS:IsCheatGMLevel() end
---@return boolean
function UBGUFunctionLibraryCS:IsDebugGMLevel() end
---@param Unit AActor
---@param UnitState EBGUUnitState
---@return boolean
function UBGUFunctionLibraryCS:BGUHasUnitState(Unit, UnitState) end
---@param SeqActor ABGUPerformerActor
function UBGUFunctionLibraryCS:SeqChangeEquip2(SeqActor) end
---@param Unit AActor
---@param Times int32
function UBGUFunctionLibraryCS:GlobalEventTest(Unit, Times) end
---@param TempleteActor AActor
function UBGUFunctionLibraryCS:GenerateGrayBox(TempleteActor) end
---@param Unit AActor
---@param AttrID EBGUAttrFloat
---@return float
function UBGUFunctionLibraryCS:BGUGetFloatAttr(Unit, AttrID) end
---@param Unit AActor
function UBGUFunctionLibraryCS:SummonEventTest(Unit) end
---@param Unit AActor
function UBGUFunctionLibraryCS:SetSolverCenter(Unit) end
---@param Unit AActor
---@return int32
function UBGUFunctionLibraryCS:BGUGetWeaponNum(Unit) end
---@param Unit AActor
---@param AttrID EBGUAttrFloat
---@param TargetValue float
function UBGUFunctionLibraryCS:BGUSetAttrValue(Unit, AttrID, TargetValue) end
---@param Unit AActor
---@param SkillID int32
---@param SourceType CastSkillSourceType
---@param IsUseComboingSection boolean
---@return int32
function UBGUFunctionLibraryCS:BGUTryCastSpell(Unit, SkillID, SourceType, IsUseComboingSection) end
---@param Unit AActor
function UBGUFunctionLibraryCS:ToggleCloudMove(Unit) end
---@param Unit AActor
---@param Timer float
function UBGUFunctionLibraryCS:BGUSetImmobility(Unit, Timer) end
---@param Unit AActor
---@param QTEID int32
---@param TargetCharacter AActor
function UBGUFunctionLibraryCS:BGUStartSceneQTE(Unit, QTEID, TargetCharacter) end
---@param Unit AActor
---@param EffectTriggerType BuffEffectTriggerType
function UBGUFunctionLibraryCS:BGURemoveAllBuff(Unit, EffectTriggerType) end
---@return boolean
function UBGUFunctionLibraryCS:IsUEDebugGMLevel() end
---@param Actor AActor
function UBGUFunctionLibraryCS:ResetPhysSetting(Actor) end
---@param Unit AActor
---@param DialogContent FString
---@param Duration float
function UBGUFunctionLibraryCS:BGUShowDialogueUI(Unit, DialogContent, Duration) end
---@param WorldContext UObject
---@param TrainDummyClassPath FString
---@param PlayerRoleDataConfigID int32
---@param TrainDummyConfigPath FString
---@param CqgPath FString
---@param DPSCalTime float
---@return boolean
function UBGUFunctionLibraryCS:SetTrainDummyInfo(WorldContext, TrainDummyClassPath, PlayerRoleDataConfigID, TrainDummyConfigPath, CqgPath, DPSCalTime) end
---@param Unit AActor
---@param FaBaoID int32
function UBGUFunctionLibraryCS:BGUUnitEquipFaBao(Unit, FaBaoID) end
---@param WorldContext UObject
---@param CameraGroupId int32
function UBGUFunctionLibraryCS:SwitchCameraGroup(WorldContext, CameraGroupId) end
---@param Owner AActor
---@param TargetChr ABGUCharacterCS
function UBGUFunctionLibraryCS:BGUPlayLockTarget(Owner, TargetChr) end
---@param Unit AActor
---@param SpeedRate float
function UBGUFunctionLibraryCS:BGUAISetSpeedRate(Unit, SpeedRate) end
---@param TotalTime float
---@param TimePointNum int32
---@param NoiseInterregional float
---@param CurveFloat UCurveFloat
---@param InterpMode ERichCurveInterpMode
function UBGUFunctionLibraryCS:TimeLineNoiseTest(TotalTime, TimePointNum, NoiseInterregional, CurveFloat, InterpMode) end
---@param WorldContext UObject
function UBGUFunctionLibraryCS:BGUFullTransEnergy(WorldContext) end
---@param Unit AActor
function UBGUFunctionLibraryCS:InteruptPigsyStory(Unit) end
---@param bPlay boolean
---@param Unit AActor
---@param FacialAnim UAnimSequence
---@param TimeOffset float
---@param AutoBlendOutTime float
function UBGUFunctionLibraryCS:PlayFacialAnimTest(bPlay, Unit, FacialAnim, TimeOffset, AutoBlendOutTime) end
---@param BulletSpawner AActor
---@param Target AActor
---@param PointGeneratorTag FString
---@param BulletID int32
---@param LimitDistance_ToPlayer float
---@param LightningBeam UNiagaraSystem
---@param LightningEndParamName FString
---@param SocketList TArray<FString>
---@param DummyBulletNum int32
---@param EndPos_Noise FVector
---@param DummyNiagara UNiagaraComponent
---@param DummyActiveDistance float
---@param RandomInterval FVector2D
function UBGUFunctionLibraryCS:KJLSpawnProjectile(BulletSpawner, Target, PointGeneratorTag, BulletID, LimitDistance_ToPlayer, LightningBeam, LightningEndParamName, SocketList, DummyBulletNum, EndPos_Noise, DummyNiagara, DummyActiveDistance, RandomInterval) end
---@param Unit AActor
---@param BT UBehaviorTree
function UBGUFunctionLibraryCS:BGUSetBehaviorTree(Unit, BT) end
---@param Target AActor
---@param DAPath FString
function UBGUFunctionLibraryCS:BGUSpawnGhostActor(Target, DAPath) end
function UBGUFunctionLibraryCS:SwitchLanguageEnZh() end
---@param UObj UObject
---@param bEnable boolean
function UBGUFunctionLibraryCS:BGUToggleGlobalURO(UObj, bEnable) end
---@param Unit AActor
function UBGUFunctionLibraryCS:BGURemoveImmobility(Unit) end
---@param Actor AActor
---@param StateTrigger EBUStateTrigger
---@param Time float
function UBGUFunctionLibraryCS:BGUTriggerUnitState(Actor, StateTrigger, Time) end
---@param Unit AActor
---@param bDisable boolean
function UBGUFunctionLibraryCS:DisablePhysicalMove(Unit, bDisable) end
---@param Unit AActor
function UBGUFunctionLibraryCS:BGUUnitUnequipFaBao(Unit) end
---@param WorldContext UObject
---@param Name FString
---@return float
function UBGUFunctionLibraryCS:FindTraceStatResult(WorldContext, Name) end
---@param Owner AActor
---@param Index int32
---@return AActor
function UBGUFunctionLibraryCS:BGUGetWeaponByIndex(Owner, Index) end
---@param ehfcomp UExponentialHeightFogComponent
---@param SecondFogData FExponentialHeightFogData
function UBGUFunctionLibraryCS:BGUSetSecondFogData(ehfcomp, SecondFogData) end
---@param WorldContext UObject
function UBGUFunctionLibraryCS:SkipCurrentSequence(WorldContext) end
---@param Unit AActor
---@return int32
function UBGUFunctionLibraryCS:ClearPhysAnimSetting(Unit) end
---@param Unit AActor
---@param BeginPos FVector
---@param EndPos FVector
---@param Speed float
function UBGUFunctionLibraryCS:BGUPlatformPatroMove(Unit, BeginPos, EndPos, Speed) end
---@param Unit AActor
---@param MaxRate int32
---@param Speed float
function UBGUFunctionLibraryCS:BGUPlatformPatroRota(Unit, MaxRate, Speed) end
---@param InWorldContext UObject
function UBGUFunctionLibraryCS:ExitWeakPerformState(InWorldContext) end
---@param OwnerCharacter AActor
---@param RequestID int32
---@return TArray<FVector>
function UBGUFunctionLibraryCS:BGUGetCachedPointSet(OwnerCharacter, RequestID) end
---@param Unit AActor
function UBGUFunctionLibraryCS:DestroyAllProjectile(Unit) end
---@param InWorldContext UObject
function UBGUFunctionLibraryCS:SwitchFreeCameraMode(InWorldContext) end
---@param Unit AActor
---@return int32
function UBGUFunctionLibraryCS:TriggerSwitchPhysics(Unit) end
---@return int32
function UBGUFunctionLibraryCS:BGUGetActiveGameMode() end
---@return FString
function UBGUFunctionLibraryCS:GetProjectBranchName() end
---@param InWorldContext UObject
---@param InArea TamerStrategyArea
function UBGUFunctionLibraryCS:SetTamerStrategyArea(InWorldContext, InArea) end
---@param Caster AActor
---@param ConversationContentID int32
function UBGUFunctionLibraryCS:HandleAiConversation(Caster, ConversationContentID) end
---@param InWorldContext UObject
---@param ConfigID int32
function UBGUFunctionLibraryCS:EnterWeakPerformState(InWorldContext, ConfigID) end
---@param WorldContext UObject
function UBGUFunctionLibraryCS:ExitPlayerSkillCamera(WorldContext) end
---@param Unit AActor
---@param SimpleState EBGUSimpleState
---@return boolean
function UBGUFunctionLibraryCS:BGUHasUnitSimpleState(Unit, SimpleState) end
---@param Character ACharacter
---@param LineTraceLength float
---@return float
function UBGUFunctionLibraryCS:CheckCurCeilingHeight(Character, LineTraceLength) end
---@param Unit AActor
---@param EffectID int32
---@param Target AActor
function UBGUFunctionLibraryCS:TriggerEffectToTarget(Unit, EffectID, Target) end
---@param Unit AActor
function UBGUFunctionLibraryCS:BGUUnitCastFaBaoSkill(Unit) end
---@param Unit AActor
---@param SimpleState EBGUSimpleState
---@param IsRemove boolean
function UBGUFunctionLibraryCS:BGUSetUnitSimpleState(Unit, SimpleState, IsRemove) end
---@param Unit AActor
---@param BreakSkillSupperArmorAM UAnimMontage
---@param SkillSuperArmorValue float
function UBGUFunctionLibraryCS:BGUSetSkillSuperArmor(Unit, BreakSkillSupperArmorAM, SkillSuperArmorValue) end
---@param OwnerCharacter AActor
---@param RequestID int32
---@param GenType PointsGenType
---@param ExtParam FPointsGenExtParam
function UBGUFunctionLibraryCS:BGUCallPointsRegister(OwnerCharacter, RequestID, GenType, ExtParam) end
---@return int32
function UBGUFunctionLibraryCS:BGUGetCurrentUserType() end
---@param Actor AActor
---@param Name FName
---@return UActorComponent
function UBGUFunctionLibraryCS:TryGetComponentByFName(Actor, Name) end
---@param Attacker AActor
---@param Victim AActor
---@param Config FAbnormalStateAccConfig
---@param AddValue float
function UBGUFunctionLibraryCS:BGUHandleAbnormalState(Attacker, Victim, Config, AddValue) end
---@param Unit AActor
---@param CritRate float
function UBGUFunctionLibraryCS:BGUSetUnitCritRateBase(Unit, CritRate) end
---@param WorldContext UObject
---@param CameraID int32
function UBGUFunctionLibraryCS:EnterPlayerSkillCamera(WorldContext, CameraID) end
---@param CameraActor ACameraActor
---@param NewFocusDistance float
function UBGUFunctionLibraryCS:SetCameraFocusDistance(CameraActor, NewFocusDistance) end
---@param CameraActor ACameraActor
---@return float
function UBGUFunctionLibraryCS:GetCameraFocusDistance(CameraActor) end
---@param Monster AActor
function UBGUFunctionLibraryCS:ExitMonsterSkillCamera(Monster) end
---@param Unit AActor
---@return AActor
function UBGUFunctionLibraryCS:GetUnitLockTargetActor(Unit) end
---@param WorldContext UObject
---@param CanTrigger boolean
function UBGUFunctionLibraryCS:BGUSetCanTriggerGroupAI(WorldContext, CanTrigger) end
---@param Monster AActor
---@param CameraID int32
function UBGUFunctionLibraryCS:EnterMonsterSkillCamera(Monster, CameraID) end
---@param _World UWorld
---@param ActorClass TSubclassOf<AActor>
---@return AActor
function UBGUFunctionLibraryCS:BGUSpawnActorNoBeginPlay(_World, ActorClass) end
---@param World UWorld
---@param UnitClass TSubclassOf<ABGUCharacterCS>
---@param ResID int32
---@param SkillID int32
---@param bNeedsSpawnNewUnit boolean
---@param SpawnedUnit ABGUCharacterCS
---@param PlayedMontage UAnimMontage
function UBGUFunctionLibraryCS:PrepareForSkillRecording(World, UnitClass, ResID, SkillID, bNeedsSpawnNewUnit, SpawnedUnit, PlayedMontage) end
---@param Unit AActor
function UBGUFunctionLibraryCS:BGURemoveSkillSuperArmor(Unit) end
---@param Unit AActor
---@param ClampToLand boolean
---@param AlignToLand boolean
---@param DeltaTime float
---@param InterpSpd float
function UBGUFunctionLibraryCS:ClampAndAlignToLandScape(Unit, ClampToLand, AlignToLand, DeltaTime, InterpSpd) end
---@param Unit AActor
---@param BuffID int32
---@param EffectTriggerType BuffEffectTriggerType
function UBGUFunctionLibraryCS:BGURemoveBuffImmediately(Unit, BuffID, EffectTriggerType) end
---@param Unit AActor
function UBGUFunctionLibraryCS:BGUOneHitBreakImmobility(Unit) end
---@param Unit AActor
---@param Config UBGWDataAsset_MagicallyChangeConfig
---@param SkillID int32
---@param RecoverSkillID int32
function UBGUFunctionLibraryCS:CastMagicallyChangeSkill(Unit, Config, SkillID, RecoverSkillID) end
---@return boolean
function UBGUFunctionLibraryCS:CanActivateConsoleCommad() end
---@param CineCameraActor ACineCameraActor
---@return float
function UBGUFunctionLibraryCS:GetCineCameraFocalLength(CineCameraActor) end
---@param CineCameraActor ACineCameraActor
---@param NewFocalLength float
function UBGUFunctionLibraryCS:SetCineCameraFocalLength(CineCameraActor, NewFocalLength) end
---@param WorldContext UObject
function UBGUFunctionLibraryCS:TestProfileSimpleOverlap(WorldContext) end
---@param Player AActor
---@param Target AActor
function UBGUFunctionLibraryCS:BGUPlayerCameraLockTarget(Player, Target) end
---@param Unit AActor
---@return AActor
function UBGUFunctionLibraryCS:BGUClosestPerceivedTarget(Unit) end
function UBGUFunctionLibraryCS:ExportAllTamerToDataAsset() end
---@param DestructibleActor AActor
function UBGUFunctionLibraryCS:BGUTryDestroyDestructible(DestructibleActor) end
---@param OwnerChr ACharacter
---@param SurfaceNormal_Normalized FVector
---@return FRotator
function UBGUFunctionLibraryCS:BGUCalcCharacterRotOnSlope(OwnerChr, SurfaceNormal_Normalized) end
---@param Unit AActor
---@param BeginPos FVector
---@param EndPos FVector
---@param Speed float
---@param PlayerCount int32
---@param Range float
function UBGUFunctionLibraryCS:BGUPlatformPatroMoveSingle(Unit, BeginPos, EndPos, Speed, PlayerCount, Range) end
---@param Actor AActor
---@return int32
function UBGUFunctionLibraryCS:BGUGetMultiPointCurrentUnit(Actor) end
---@param WorldContext UObject
---@param CurInverseAnimRotation FRotator
function UBGUFunctionLibraryCS:BGUEnablePlayerGuiBeiCamera(WorldContext, CurInverseAnimRotation) end
---@param TempleteActor AActor
function UBGUFunctionLibraryCS:GenerateNavMeshBoundsVolumes(TempleteActor) end
---@param WorldContext UObject
function UBGUFunctionLibraryCS:BGUDisablePlayerGuiBeiCamera(WorldContext) end
---@param _World UWorld
---@param ActorClass TSubclassOf<AActor>
---@return AActor
function UBGUFunctionLibraryCS:BGUSpawnActorAndECSBeginPlay(_World, ActorClass) end
---@param TM ABUTamerActor
function UBGUFunctionLibraryCS:ExportBulletSkillToDataAsset(TM) end
---@param Actor AActor
---@param OldTamer FString
---@param NewTimer FString
---@param BlameName FString
---@return boolean
function UBGUFunctionLibraryCS:ExportTamerListToNewDAByBlame(Actor, OldTamer, NewTimer, BlameName) end
---@param CameraShakeCls TSubclassOf<UMatineeCameraShake>
---@param Target AActor
function UBGUFunctionLibraryCS:PlayCamShakeWithControlByClass(CameraShakeCls, Target) end
---@param Target AActor
---@param bPause boolean
function UBGUFunctionLibraryCS:PauseCamShakeWithControlByActor(Target, bPause) end
---@param AttachTo AActor
function UBGUFunctionLibraryCS:BGUSetDispInteractActorAttachTo(AttachTo) end
---@param Unit AActor
---@param SkillID int32
---@param MontageStartSectionName FName
---@return int32
function UBGUFunctionLibraryCS:BGUTryCastSpellWithStartSection(Unit, SkillID, MontageStartSectionName) end
---@param Owner AActor
---@param bValue boolean
function UBGUFunctionLibraryCS:BGUSetPlayerInSequenceTransition(Owner, bValue) end
---@param WorldContext UObject
---@param ItemId int32
---@param bShowTips boolean
---@return boolean
function UBGUFunctionLibraryCS:BGUCheckSpecialConsumeItemUseAble(WorldContext, ItemId, bShowTips) end
---@param AnimSeq UAnimSequence
---@param CurTime float
---@param LastTime float
---@param BoneName FName
---@return FTransform
function UBGUFunctionLibraryCS:GetGuibeiBoneTransformFromLastTick(AnimSeq, CurTime, LastTime, BoneName) end
---@param Actor AActor
---@param OldTamer FString
---@param NewTimer FString
---@param BlameName FString
---@return boolean
function UBGUFunctionLibraryCS:ExportTamerListToNewDAByWeaponInfo(Actor, OldTamer, NewTimer, BlameName) end
---@param WorldContextObject UObject
---@param LevelName FName
---@param ParentTransform FTransform
---@param ParentTransformOffset FTransform
function UBGUFunctionLibraryCS:RotateLevelRelativeToParentTransform(WorldContextObject, LevelName, ParentTransform, ParentTransformOffset) end
---@param SelfTransform FTransform
---@param ParentTransform FTransform
---@param ParentTransformOffset FTransform
---@return FTransform
function UBGUFunctionLibraryCS:CalTransformRelativeToParentTransformOffset(SelfTransform, ParentTransform, ParentTransformOffset) end
---@param PlayerController APlayerController
---@param WorldPos FVector
---@param ScreenPos FVector2D
function UBGUFunctionLibraryCS:ProjectWorldLocationToWidgetPositionWithSZInS(PlayerController, WorldPos, ScreenPos) end


---@class UBGUFunctionLibraryManaged : UBlueprintFunctionLibrary
UBGUFunctionLibraryManaged = {}

---@param GMCommand FString
---@param WorldContext UObject
function UBGUFunctionLibraryManaged:RunScriptGM(GMCommand, WorldContext) end
---@param WorldContext UObject
---@param PageId EUIPageID
function UBGUFunctionLibraryManaged:BGUSwitchPage(WorldContext, PageId) end
---@param ClassName FString
---@return UClass
function UBGUFunctionLibraryManaged:FindOrLoadClass(ClassName) end
---@param WorldContext UObject
---@param PageId EUIPageID
---@param IsActive boolean
function UBGUFunctionLibraryManaged:BGUSetPageActive(WorldContext, PageId, IsActive) end
---@param TmpWidget UUserWidget
function UBGUFunctionLibraryManaged:BGUSaveTempWidget(TmpWidget) end
---@param InAsset UBED_CalliopeAssetBase
---@param NodeClass TSubclassOf<UBED_CalliopeNodeBae>
---@param Nodes TArray<UBED_CalliopeNodeBae>
function UBGUFunctionLibraryManaged:FindAllNodeByClass(InAsset, NodeClass, Nodes) end
---@param WorldContext UObject
---@param IsActive boolean
function UBGUFunctionLibraryManaged:BGUActiveUIBlackOut(WorldContext, IsActive) end
---@param WorldContext UObject
function UBGUFunctionLibraryManaged:FixTransactionalTamer(WorldContext) end
---@param WorldContext UObject
---@param BPPath FString
---@param TamerObject UObject
---@param TamerClass UClass
---@return boolean
function UBGUFunctionLibraryManaged:CreateTamerFromBPPath(WorldContext, BPPath, TamerObject, TamerClass) end
---@param WorldContext UObject
---@param UnitClass UClass
---@param TamerObject UObject
---@param TamerClass UClass
---@return boolean
function UBGUFunctionLibraryManaged:CreateTamerFromUnitClass(WorldContext, UnitClass, TamerObject, TamerClass) end
---@param WorldContext UObject
---@param RefGSGridConScreenAdapter UGSGridConScreenAdapter
function UBGUFunctionLibraryManaged:RegGSGridConScreenAdapter(WorldContext, RefGSGridConScreenAdapter) end
---@param WorldContext UObject
---@param LightBase float
function UBGUFunctionLibraryManaged:BGUChangeChapterLightBase(WorldContext, LightBase) end
---@param InAsset UBED_CalliopeAssetBase
---@return boolean
function UBGUFunctionLibraryManaged:IsAnyStoryNodeHasGainItem(InAsset) end
---@param WorldContext UObject
---@param RefGSGridConScreenAdapter UGSGridConScreenAdapter
function UBGUFunctionLibraryManaged:UnRegGSGridConScreenAdapter(WorldContext, RefGSGridConScreenAdapter) end
---@param WorldContext UObject
---@param BPPath FString
---@return FString
function UBGUFunctionLibraryManaged:ConvertToTamerPathFromBPPath(WorldContext, BPPath) end
---@param WorldContext UObject
function UBGUFunctionLibraryManaged:BatchReplaceMapUnitWithTamer(WorldContext) end
---@param WorldContext UObject
---@param folder FString
---@param bRecursive boolean
function UBGUFunctionLibraryManaged:AutoGenTamerFromUnitBlueprint(WorldContext, folder, bRecursive) end
---@param WorldContext UObject
---@param IsEnable boolean
---@param TargetPlayerController APlayerController
function UBGUFunctionLibraryManaged:SetShaderPipelineCacheEnabled(WorldContext, IsEnable, TargetPlayerController) end
---@param InAsset UBED_CalliopeAssetBase
---@return boolean
function UBGUFunctionLibraryManaged:IsContainNonexistentTaskStage(InAsset) end
---@param WorldContext UObject
function UBGUFunctionLibraryManaged:BatchReplaceMapSpawnerWithTamer(WorldContext) end
---@param TargetWidget UUserWidget
function UBGUFunctionLibraryManaged:FixFontForPIEPreviewInEditorDebug(TargetWidget) end


---@class UBGULevelStateFunctionBinder : UObject
UBGULevelStateFunctionBinder = {}

---@param LevelKeyword FString
---@param LevelState FString
---@param OperationID int32
function UBGULevelStateFunctionBinder:OnSetLevelsStateFinished(LevelKeyword, LevelState, OperationID) end
function UBGULevelStateFunctionBinder:OnRequestUpdateLevelState() end


---@class UBGULightFlickerComp : UBaseActorCompTickable
---@field flickRange float
---@field flickTimeRandomMin float
---@field flickTimeRandomMax float
---@field randomRemapPower float
---@field destroyTime float
---@field posFlickRange FVector
UBGULightFlickerComp = {}

---@param flickRange float
---@param flickTimeRandomMin float
---@param flickTimeRandomMax float
---@param randomRemapPower float
---@param destroyTime float
---@param posFlickRange FVector
function UBGULightFlickerComp:OverrideProperty(flickRange, flickTimeRandomMin, flickTimeRandomMax, randomRemapPower, destroyTime, posFlickRange) end
function UBGULightFlickerComp:ReceiveBeginPlay() end
---@param DeltaTime float
function UBGULightFlickerComp:TickComponentInCS(DeltaTime) end


---@class UBGULightFlickerForSequenceComp : UBGULightFlickerComp
---@field StartIntensity float
---@field TargetIntensity float
---@field LerpTime float
---@field bBeginTick boolean
UBGULightFlickerForSequenceComp = {}

function UBGULightFlickerForSequenceComp:ReceiveBeginPlay() end
---@param DeltaTime float
function UBGULightFlickerForSequenceComp:TickComponentInCS(DeltaTime) end


---@class UBGUMotionMatchingDebugComp : UBaseActorCompTickable
---@field bDisable boolean
---@field bDebugPlayer boolean
---@field TamerBP TSubclassOf<ABUTamerActor>
UBGUMotionMatchingDebugComp = {}

function UBGUMotionMatchingDebugComp:Restart() end
function UBGUMotionMatchingDebugComp:StopDebugPlayer() end
function UBGUMotionMatchingDebugComp:BeginPlayInCS() end
---@param DeltaTime float
function UBGUMotionMatchingDebugComp:TickComponentInCS(DeltaTime) end


---@class UBGUNvFlowCameraBlockLogic : UActorComponentCS
---@field CameraComp USceneComponent
---@field ActorComp USceneComponent
---@field CapsuleBlocker UCapsuleComponent
---@field CapsuleBlockerRaidusRate float
UBGUNvFlowCameraBlockLogic = {}

---@param Cam USceneComponent
---@param Actor USceneComponent
---@param Blocker UCapsuleComponent
function UBGUNvFlowCameraBlockLogic:Init(Cam, Actor, Blocker) end
---@param DeltaSeconds float
function UBGUNvFlowCameraBlockLogic:ReceiveTick(DeltaSeconds) end


---@class UBGUPerformerControlConfigComp : UActorEditCompBase
---@field Phases TArray<UPerformerPhase>
---@field Params TArray<UPerformerParamBase>
UBGUPerformerControlConfigComp = {}

---@param ParentPropertyName FString
---@param PropertyName FString
---@param OutParamArray TArray<FCalliopeGuid>
function UBGUPerformerControlConfigComp:GetPossibleParamsCS(ParentPropertyName, PropertyName, OutParamArray) end
---@param PropertyName FString
---@param ConfigGuid FCalliopeGuid
---@return FString
function UBGUPerformerControlConfigComp:GetParamDisplayNameCS(PropertyName, ConfigGuid) end


---@class UBGUPerformerControlDataComp : UBUS_ActorBaseDataComp
UBGUPerformerControlDataComp = {}


---@class UBGUPhysicalAnimTail : UPhysicalAnimationComponent
---@field PhysicalAnimationData FPhysicalAnimationData
---@field BonesName TArray<FName>
---@field BoneBlendCurve UCurveFloat
UBGUPhysicalAnimTail = {}

function UBGUPhysicalAnimTail:InitializePhysicalAnimation() end
function UBGUPhysicalAnimTail:ReceiveBeginPlay() end


---@class UBGUPlayMontageBinder : UBGUFunctionBinder
UBGUPlayMontageBinder = {}

---@param _ReqIdx int32
---@param AnimInstance UAnimInstance
---@param Montage UAnimMontage
function UBGUPlayMontageBinder:OnBlendOut(_ReqIdx, AnimInstance, Montage) end
---@param _ReqIdx int32
---@param AnimInstance UAnimInstance
---@param Montage UAnimMontage
function UBGUPlayMontageBinder:OnCompleted(_ReqIdx, AnimInstance, Montage) end
---@param _ReqIdx int32
---@param AnimInstance UAnimInstance
---@param Montage UAnimMontage
function UBGUPlayMontageBinder:OnInterrupted(_ReqIdx, AnimInstance, Montage) end


---@class UBGUPredefinedBezierCurveHepler : UActorComponent
UBGUPredefinedBezierCurveHepler = {}


---@class UBGUSkillPreviewSystem : UBaseActorCompTickable
---@field AttackerClass TSubclassOf<ABUTamerActor>
---@field SkillID int32
---@field SkillIdList TArray<int32>
---@field Delay float
---@field bDrawSweepCheckSphere boolean
---@field bDrawSkillEffectArea boolean
---@field bDrawBuffArea boolean
---@field bDrawBulletCollision boolean
---@field bDrawBulletDestroyPos boolean
---@field TargetAddBati boolean
---@field EnableZBBTest boolean
---@field OpenLowDensityTest boolean
---@field DistRange FVector2D
---@field MapSize int32
---@field SectorFilterList TArray<int32>
UBGUSkillPreviewSystem = {}

---@param DrawAll boolean
---@param SectorNum int32
function UBGUSkillPreviewSystem:DrawforDebug(DrawAll, SectorNum) end
---@param Config FZBBPreviewConfig
function UBGUSkillPreviewSystem:OnSetPreviewConfig(Config) end
function UBGUSkillPreviewSystem:StopTestAndOutputConfig() end
function UBGUSkillPreviewSystem:BeginPlayInCS() end
---@param DeltaTime float
function UBGUSkillPreviewSystem:TickComponentInCS(DeltaTime) end


---@class UBGUStaminaBarUIComp : USceneComponentTickable
---@field DrawDebug boolean
---@field PlayerCameraManager APlayerCameraManager
UBGUStaminaBarUIComp = {}

---@param IsEnabled boolean
function UBGUStaminaBarUIComp:SetGSEnabled(IsEnabled) end
function UBGUStaminaBarUIComp:BeginPlayGS() end
---@param DeltaTime float
function UBGUStaminaBarUIComp:TickComponentGS(DeltaTime) end


---@class UBGU_DispLibDBCCarrierActorDataComp : UBUS_ActorBaseDataComp
UBGU_DispLibDBCCarrierActorDataComp = {}


---@class UBGU_DispLibFXActorGSArtFresnelData : UBGU_DispLibUComponentBase
---@field Priority int32
---@field FirstDelayTime float
---@field Time float
---@field OnePeriodTime float
---@field Loop boolean
---@field InvertGSArtFresnel boolean
---@field UseVertexNormalNotTex boolean
---@field UseContrastInsteadPower boolean
---@field BrightValue float
---@field DarkValue float
---@field GSArtFresnelPower UCurveFloat
---@field ClampGSArtFresnelDotProduct boolean
---@field UseHeightGradientRamp boolean
---@field BottomAlpha float
---@field TopAlpha float
---@field FColor_Out UCurveLinearColor
---@field FColor_In UCurveLinearColor
UBGU_DispLibFXActorGSArtFresnelData = {}



---@class UBGU_DispLibUComponentBase : UBaseActorComp
UBGU_DispLibUComponentBase = {}


---@class UBGU_ValidateMgrFuncLib : UBlueprintFunctionLibrary
UBGU_ValidateMgrFuncLib = {}

---@param Actor AActor
function UBGU_ValidateMgrFuncLib:ImArtDev(Actor) end


---@class UBGWAISkillScoreConfigDataAsset : UBGWDataAsset
---@field RealComboAddition float
---@field OtherComboSkillSubtraction float
---@field FirstSkillRealComboAddition float
---@field FirstSkillRealComboSkillReduceNum int32
---@field EndSkillAddition float
---@field EndSkillSubtraction float
UBGWAISkillScoreConfigDataAsset = {}



---@class UBGWAssetLoaderRequestCS : UBGWAssetLoaderRequest
---@field loadedObjHolder TArray<UObject>
UBGWAssetLoaderRequestCS = {}

function UBGWAssetLoaderRequestCS:ExecuteCS() end


---@class UBGWBGMConfigDataAsset : UBGWDataAsset
---@field DefaultWanderBGMList TArray<FSingleBGMConfig>
---@field DefaultMonsterBattleBGMList TArray<FSingleBattleBGMConfig>
---@field DefaultEliteBattleBGMList TArray<FSingleBattleBGMConfig>
---@field DefaultBossBattleBGMList TArray<FSingleBattleBGMConfig>
---@field DefaultSequenceStopBGMEvent UAkAudioEvent
---@field DefaultShrineBGM FSingleBGMConfig
---@field DefaultRoleBGM FSingleBGMConfig
---@field DisabledBGMTypes TArray<EBGMDisableType>
UBGWBGMConfigDataAsset = {}



---@class UBGWBHLItemTmpDataAsset : UBGWDataAsset
---@field JTItemNumMax int32
---@field JHItemId int32
UBGWBHLItemTmpDataAsset = {}



---@class UBGWBasePhysAnimDataAsset : UBGWDataAsset
---@field ConstraintProfile FName
---@field PhysAnimProfile FName
---@field KinematicBones TArray<FName>
UBGWBasePhysAnimDataAsset = {}



---@class UBGWBeAtkPhysAnimDataAsset : UBGWBasePhysAnimDataAsset
---@field PhysWeightCurve UCurveFloat
---@field MotorStrengthCurve UCurveFloat
---@field HitImpulse float
---@field bPartPhysics boolean
---@field bHitOnPelvis boolean
---@field bScaledByTotalMass boolean
---@field bCanHitSpine boolean
UBGWBeAtkPhysAnimDataAsset = {}



---@class UBGWBeCatchThrowPhysAnimDataAsset : UBGWBasePhysAnimDataAsset
---@field BoneNameBelowToSimulatePhysics FName
---@field PhysicsBlendWeight float
UBGWBeCatchThrowPhysAnimDataAsset = {}



---@class UBGWCellPatitionWorldSubSystem : UBGWTickableWorldSubSystem
UBGWCellPatitionWorldSubSystem = {}

---@param DeltaTime float
function UBGWCellPatitionWorldSubSystem:OnTickCS(DeltaTime) end
function UBGWCellPatitionWorldSubSystem:PostInitializeCS() end
---@param InWorld UWorld
function UBGWCellPatitionWorldSubSystem:OnWorldBeginPlayCS(InWorld) end
---@param WorldType int32
---@return boolean
function UBGWCellPatitionWorldSubSystem:DoesSupportWorldTypeCS(WorldType) end


---@class UBGWCharaterAnimMgrDataAsset : UBGWDataAsset
---@field Anim int32
---@field ExAS_Default FBUAnimSettingsLocomotionEx
---@field ExBS_Patrol FPatrolBlendSpaceSetting
---@field ExAS_EQSRun FBUAnimSettingsLocomotionEx
---@field ExAS_Shield FBUAnimSettingsLocomotionEx
---@field ExAS_PowerStorage FBUAnimSettingsLocomotionEx
UBGWCharaterAnimMgrDataAsset = {}



---@class UBGWConsoleCommands : UGameInstanceSystemBaseUObj
UBGWConsoleCommands = {}

function UBGWConsoleCommands:GenerateArrow() end


---@class UBGWCricketBattleDataAsset : UBGWDataAsset
---@field BuffID int32
---@field CameraWaitTime float
---@field CameraBlendTime float
---@field NameShowTime float
---@field DelayShowName float
---@field CricketUnitIndexList TArray<int32>
---@field PressStartGameTime float
---@field PressBlackTime float
---@field BaodiKillTime float
UBGWCricketBattleDataAsset = {}



---@class UBGWCustomLightConfigDataAsset : UBGWDataAsset
---@field MapCustsomLightConfigs TArray<FSoftObjectPath>
UBGWCustomLightConfigDataAsset = {}



---@class UBGWDamageNumberConfigDataAsset : UBGWDataAsset
---@field DamageUIMap TMap<DamageNumberType, TSubclassOf<UUserWidget>>
UBGWDamageNumberConfigDataAsset = {}



---@class UBGWDataAsset_ABSPosToUVConfig : UBGWDataAsset
---@field RecordTime float
---@field RecordMinValue float
---@field DelayTime float
---@field SpeedClamp FVector2D
UBGWDataAsset_ABSPosToUVConfig = {}



---@class UBGWDataAsset_AIHatredConfig : UBGWDataAsset
---@field UnitBaseHatreds TMap<int32, int32>
---@field DistanceWeightMultiplier float
UBGWDataAsset_AIHatredConfig = {}



---@class UBGWDataAsset_AIPerceptionConfig : UBGWDataAsset
---@field HearRange float
---@field SightRange float
---@field LoseSightRange float
---@field VisionAngleDegrees float
---@field ASRangeFromLastSeenLoc float
---@field IsSightDominantSense boolean
UBGWDataAsset_AIPerceptionConfig = {}



---@class UBGWDataAsset_AbnormalAttrConfig : UBGWDataAsset
---@field AbnomalAttrConfigInfo_Freeze FAbnomalAttrConfigInfo
---@field AbnomalAttrConfigInfo_Burn FAbnomalAttrConfigInfo
---@field AbnomalAttrConfigInfo_Poison FAbnomalAttrConfigInfo
---@field AbnomalAttrConfigInfo_Thunder FAbnomalAttrConfigInfo
---@field AbnomalAttrConfigInfo_Yin FAbnomalAttrConfigInfo
---@field AbnomalAttrConfigInfo_Yang FAbnomalAttrConfigInfo
UBGWDataAsset_AbnormalAttrConfig = {}



---@class UBGWDataAsset_AbpHumanoidSetting : UBGWDataAsset
---@field CommonSetting FAnimHumanoidSetting_Common
---@field FootIKSetting FAnimHumanoidSetting_FootIK
---@field MotionMatchingSetting FAnimHumanoidSetting_MotionMatching
---@field Simple4DirSetting FAnimHumanoidSetting_Simple4Dir
---@field PlayerLocomotionSetting FAnimHumanoidSetting_PlayerLocomotion
---@field MonsterLocomotionSetting FAnimHumanoidSetting_MonsterLocomotion
---@field AdvancedMonsterLocomotionSetting FAnimHumanoidSetting_AdvancedMonsterLocomotion
---@field FlyControlSetting FAnimHumanoidSetting_FlyControl
---@field AimOffsetSetting FAnimHumanoidSetting_AimOffset
---@field SpineIKSetting FAnimHumanoidSetting_SpineIK
---@field DingShenSetting FAnimHumanoidSetting_DingShen
---@field JumpSetting FAnimHumanoidSetting_Jump
---@field PatrolSetting FAnimHumanoidSetting_Patrol
---@field GlideMoveSetting FAnimHumanoidSetting_GlideMove
---@field ParkourMoveSetting FAnimHumanoidSetting_ParkourMove
---@field BodyBlendSetting FAnimHumanoidSetting_BodyBlend
---@field CloudLocomotionSetting FAnimHumanoidSetting_CloudLocomotion
---@field SpecialAdditiveSetting FAnimHumanoidSetting_SpecialAdditive
---@field WheelMoveSetting FAnimWheelSetting_WheelMove
---@field StriderMoveSetting FAnimHumanoidSetting_StriderMove
---@field QuadrupedLocomotionSetting FAnimHumanoidSetting_QuadrupedLocomotion
UBGWDataAsset_AbpHumanoidSetting = {}



---@class UBGWDataAsset_AbpPerformerSetting : UBGWDataAsset
---@field IdleAnim UAnimSequence
---@field AimOffsetMappingCurve UCurveVector
---@field HeadAimOffset TArray<UAimOffsetBlendSpace>
---@field HeadAimOffsetTurnSpeed FInterpSpeed
---@field HeadAimPitchRange FVector2D
---@field HeadAimYawRange FVector2D
---@field EyeAimOffset TArray<UAimOffsetBlendSpace>
---@field EyeAimOffsetTurnSpeed FInterpSpeed
---@field EyeAimPitchRange FVector2D
---@field EyeAimYawRange FVector2D
---@field BlinkAnim TArray<FRandomAnims>
---@field BlinkTimeRange FVector2D
UBGWDataAsset_AbpPerformerSetting = {}



---@class UBGWDataAsset_AnimInteractiveActorSetting : UBGWDataAsset
---@field AnimIdle UAnimSequence
UBGWDataAsset_AnimInteractiveActorSetting = {}



---@class UBGWDataAsset_AnimationSyncStateConfig : UBGWDataAsset
---@field PreState_bHostCantBeDead boolean
---@field PreState_bGuestCantBeDead boolean
---@field PreState_bIgnoreAllInput boolean
---@field InState_bHostCantBeDead boolean
---@field InState_bGuestCantBeDead boolean
---@field InState_bBothImmuneStiff boolean
---@field InState_bBothImmuneImmobilizing boolean
---@field InState_bHostImmuneFrozen boolean
---@field InState_bHostImmuneBurn boolean
---@field InState_bHostImmunePoison boolean
---@field InState_bHostImmuneThunder boolean
---@field InState_bGuestImmuneFrozen boolean
---@field InState_bGuestImmuneBurn boolean
---@field InState_bGuestImmunePoison boolean
---@field InState_bGuestImmuneThunder boolean
---@field InState_bHostImmuneDamage boolean
---@field InState_bHostImmuneDmgExceptElementDmg boolean
---@field bIgnoreAllInput boolean
UBGWDataAsset_AnimationSyncStateConfig = {}



---@class UBGWDataAsset_AutoMoveMonitorsConfig : UBGWDataAsset
---@field AutoMoveCaptureModes TArray<FAutoMoveMonitorConfigItem>
---@field AutoMoveMotionPatterns TArray<FAutoMoveMonitorConfigItem>
UBGWDataAsset_AutoMoveMonitorsConfig = {}



---@class UBGWDataAsset_AutoTestComboConfig : UBGWDataAsset
---@field SkillSourceType ZatoichiSkillSourceType
---@field PursuitAnyWhere boolean
---@field PursuitInAllSkill boolean
---@field PursuitRangePos float
---@field SpeedRateType EAIMoveSpeedType
---@field MotionMatchingMoveMode State_MM
---@field MoveAIType EBGUMoveAIType
---@field MoveAcceptableRadiusType EBGUMoveAcceptableRadiusType
---@field BeginRotateAngle float
---@field IsUseSkillForTurn boolean
---@field IsUseSkillForMove boolean
---@field BeginMoveDistanceWhenUseSkill float
---@field EnableInterruptReduceCBNum boolean
---@field NeedTraceHitTargetBefore boolean
---@field EnableForceComboRelation boolean
---@field EnableComboCondition boolean
---@field TraceDistance float
---@field TraceTypeQuery ETraceTypeQuery
---@field IsGetTopRandomSkill boolean
---@field TopRandomSkillPercent int32
---@field SkillArray TArray<FComboSkill>
---@field IsGetAdvanceComboLength boolean
---@field ComboSkillNumInfo TArray<FComboSkillNumInfo>
---@field bCanBeForceAbort boolean
---@field bCanBeInterruptedByHRCounterattack boolean
---@field UseSocketDirection boolean
---@field DirectionBaseSocket FName
---@field ForwardSocket FName
---@field RightSocket FName
---@field SkillConfigMode EscapeSkillConfigMode
---@field SingleDirectionSkills TArray<int32>
---@field AvoidObstacleSectionNum int32
---@field SectionsStartAngle float
---@field IntervalAngle float
---@field AvoidObstacleSections TArray<FAvoidObstacleSection>
UBGWDataAsset_AutoTestComboConfig = {}



---@class UBGWDataAsset_AutoTestEQSRunConfig : UBGWDataAsset
---@field AcceptableRadius float
---@field IncludeSelfRadius boolean
---@field EQSTemplate UEnvQuery
---@field MoveAIType EBGUMoveAIType
---@field SpeedRateType EAIMoveSpeedType
---@field SpeedRateDistanceCurve UCurveFloat
---@field EnableRangeAcceptableRadius boolean
---@field MinAcceptableRadius float
---@field MaxAcceptableRadius float
---@field AutoUpdatePathTime float
---@field EnableLeisure boolean
---@field IntervalTime float
---@field LeisureList TArray<FFGSLeisureWithWeight>
UBGWDataAsset_AutoTestEQSRunConfig = {}



---@class UBGWDataAsset_AutoTestMoveToConfig : UBGWDataAsset
---@field MaxMoveTime float
---@field AcceptableRadius float
---@field IncludeSelfRadius boolean
---@field IncludeTargetRadius boolean
---@field BTTargetType EBTTargetType
---@field MoveAIType EBGUMoveAIType
---@field SpeedRateType EAIMoveSpeedType
---@field SpeedRateDistanceCurve UCurveFloat
---@field EnableRangeAcceptableRadius boolean
---@field MinAcceptableRadius float
---@field MaxAcceptableRadius float
UBGWDataAsset_AutoTestMoveToConfig = {}



---@class UBGWDataAsset_B1DBC : UBUC_DispLibDispBaseConfigDataAsset
---@field ExtraSetting FB1DBC_ExtraSetting
UBGWDataAsset_B1DBC = {}



---@class UBGWDataAsset_BPTreeInfo : UBGWDataAsset
---@field TreeInfoMap TMap<TSubclassOf<AActor>, FFBPTreeInfo>
---@field StaticMeshTreeInfoMap TMap<UStaticMesh, FFBPTreeInfo>
UBGWDataAsset_BPTreeInfo = {}



---@class UBGWDataAsset_BattleFieldPerformanceOptConfig : UBGWDataAsset
---@field Enable boolean
---@field DrawDebug boolean
---@field TickInterval float
---@field DistThreshold_ToPlayer float
UBGWDataAsset_BattleFieldPerformanceOptConfig = {}



---@class UBGWDataAsset_BattleSCConfig : UBGWDataAsset
---@field BattleSCConfigMap TMap<FGameplayTag, FBattleSCInfo>
UBGWDataAsset_BattleSCConfig = {}



---@class UBGWDataAsset_BeAttackedHitLevelConfig : UBGWDataAsset
---@field StiffLevelInfoList TArray<FStiffLevelInfo>
---@field FlyHitWithoutRMValue float
---@field NoFeelingDeadValue float
---@field LightDeadValue float
---@field HeavyDeadValue float
---@field StrikeFlyDeadValue float
---@field NoFeelingRoarValue float
---@field LightRoarValue float
---@field MediumRoarValue float
---@field HeavyRoarValue float
UBGWDataAsset_BeAttackedHitLevelConfig = {}



---@class UBGWDataAsset_BeImmobilizedConfig : UBGWDataAsset
---@field DefaultImmobilizeTimeFactorForBeAttacked float
---@field ImmobilizeTimeFactorForBeAttacked TMap<int32, float>
---@field SpecialImmobilizeTimeFactorForBeAttacked TMap<int32, float>
---@field ImmobilizeTimeFactorForBreakPart2Weak float
---@field SpecialImmobilizeTimeFactorForBreakPart2Weak float
---@field ImmobilizeTimeFactorForBlindStiff float
---@field SpecialImmobilizeTimeFactorForBlindStiff float
UBGWDataAsset_BeImmobilizedConfig = {}



---@class UBGWDataAsset_BlockInfoConfig : UBGWDataAsset
---@field BlockCounterType BlockCounterType
---@field BlockAMSelectMode BlockAMSelectMode
---@field BlockTiggerAngleLeft float
---@field BlockTiggerAngleRight float
---@field AreaDivisionLineForwardLeft float
---@field AreaDivisionLineForwardRight float
---@field AreaDivisionLineBackwardLeft float
---@field AreaDivisionLineBackwardRight float
---@field PerfectBlockInfoWarp FBlockInfoWarp_Perfect
---@field NormalBlockInfoWarp FBlockInfoWarp_Normal
---@field BeAttackedBlockInfoWarp FBlockInfoWarp_BeAttacked
UBGWDataAsset_BlockInfoConfig = {}



---@class UBGWDataAsset_BuffSetCurveValueToMeshConfig : UBGWDataAsset
---@field FloatCurveParamList TArray<FGSFloatCurveToParam>
---@field LinearColorCurveParamList TArray<FGSLinearColorCurveToParam>
---@field NotApplyToChrMesh boolean
---@field MatIndexList TArray<int32>
---@field BothWeapons boolean
---@field WeaponIndexList TArray<int32>
---@field WeaponMatIndexList TArray<int32>
---@field BothChildMeshes boolean
---@field ChildMeshTagList TArray<FName>
---@field ChildMeshMatIndexList TArray<int32>
---@field BothChildActor boolean
---@field ChildActorMeshMatIndexList TArray<int32>
---@field BothHair boolean
---@field HairType EGSHairType
---@field HairCompTagList TArray<FName>
---@field HairFloatCurveParamList TArray<FGSFloatCurveToParam>
---@field NeedRecovery boolean
---@field bFitRealTime boolean
UBGWDataAsset_BuffSetCurveValueToMeshConfig = {}



---@class UBGWDataAsset_BulletSmartSelectTargetConfig : UBGWDataAsset
---@field SearchRadius int32
---@field TargetTeamFilter int32
---@field TargetTypeFilter int32
---@field MultiTargetConditionTyp MultiTargetConditionType
---@field Param1 int32
---@field Param2 int32
---@field SearchTargetDelayTime float
---@field BeAttackedDecreaseValue float
---@field BulletDistanceDecreaseValue float
---@field LastTargetDotDecreaseValue float
---@field MasterDistanceDecreaseValue float
---@field HitCountAddition int32
---@field PerformanceProjectileID int32
---@field BackNestProjectileID int32
---@field LifeTime float
UBGWDataAsset_BulletSmartSelectTargetConfig = {}



---@class UBGWDataAsset_BulletSweepReactionConfig : UBGWDataAsset
---@field UseBeHitedReactionConfig boolean
---@field BulletBeHitedReactionConfigInfo TArray<FBulletBeAttackedReactionInfo>
---@field UseSweepBuffReactionConfig boolean
---@field BulletSweepBuffReactionConfigInfo TArray<FBulletSweepReactionInfo>
---@field UseSweepSimpleStateReactionConfig boolean
---@field BulletSweepSimpleStateReactionConfigInfo TArray<FBulletSweepSimpleStateReactionInfo>
UBGWDataAsset_BulletSweepReactionConfig = {}



---@class UBGWDataAsset_CameraShakeWithControl : UBGWDataAsset
---@field CameraShake TSubclassOf<UMatineeCameraShake>
---@field WithControl boolean
---@field CamShakeScaleByDistCurve UCurveFloat
---@field EpicenterIsAttach boolean
---@field SocketName FName
UBGWDataAsset_CameraShakeWithControl = {}



---@class UBGWDataAsset_ChangeMaterialByUnitAttrConfig : UBGWDataAsset
---@field ConfigList TArray<FChangeMaterialByUnitAttrConfig>
UBGWDataAsset_ChangeMaterialByUnitAttrConfig = {}



---@class UBGWDataAsset_ChargeLevelConfig : UBGWDataAsset
---@field ChargeLevelConfigs TArray<FChargeLevelConfig>
UBGWDataAsset_ChargeLevelConfig = {}



---@class UBGWDataAsset_CloudMoveConfig : UBGWDataAsset
---@field CloudSkillCooldownTime int32
---@field CloudSkill_Ride_Walk int32
---@field CloudSkill_Ride_Run int32
---@field CloudSkill_Ride_Sprint int32
---@field CloudSkill_Ride_Fall int32
---@field CloudSkill_Ride_Fall_MinHeight float
---@field CloudSkill_GetOff_Walk_Low int32
---@field CloudSkill_GetOff_Walk_High int32
---@field CloudSkill_GetOff_Run_Low_Forward int32
---@field CloudSkill_GetOff_Run_Low_Upward int32
---@field CloudSkill_GetOff_Run_Low_Downward int32
---@field CloudSkill_GetOff_Run_High_Forward int32
---@field CloudSkill_GetOff_Run_High_Upward int32
---@field CloudSkill_GetOff_Run_High_Downward int32
---@field CloudSkill_GetOff_Rush_Low_Forward int32
---@field CloudSkill_GetOff_Rush_Low_Upward int32
---@field CloudSkill_GetOff_Rush_Low_Downward int32
---@field CloudSkill_GetOff_Rush_High_Forward int32
---@field CloudSkill_GetOff_Rush_High_Upward int32
---@field CloudSkill_GetOff_Rush_High_Downward int32
---@field CloudSkill_BreakSkills TMap<int32, FCloudMoveBreakSkillConfig>
---@field HeightLimitThreshold float
---@field HeightLimitMaxPitchCurve UCurveFloat
---@field DisableHeightLimitIfNoInput boolean
---@field MinimumHeightRestriction float
---@field MinimumHeightRestrictionThreshold float
---@field HorizontalFlightUpAngleRange float
---@field HorizontalFlightDownAngleRange float
---@field RushEffectSpeed float
---@field RushEffectBuffList TArray<int32>
---@field RushAkEvent UAkAudioEvent
---@field CloudMoveItemId int32
---@field CloudMoveBuffId TArray<int32>
---@field CloudEffectDBC UBGWDataAsset_B1DBC
---@field CloudEffectDBC_RotateLerpSpeedCurve UCurveFloat
---@field CloudEffectDBC_LocationLerpSpeedCurve UCurveFloat
---@field CloudEffectDBC_OffsetCurve UCurveVector
---@field CloudAkEventBegin UAkAudioEvent
---@field CloudAkEventStop UAkAudioEvent
---@field CloudFoliageFadeScaleCurve UCurveFloat
---@field GroundEffectDistance float
---@field GroundEffectInterval float
---@field GroundEffectSpeed float
---@field GroundEffects TMap<SceneItemSurfaceType, FCloudMoveGroundEffectConfig>
UBGWDataAsset_CloudMoveConfig = {}



---@class UBGWDataAsset_CoinDropFXNumConfig : UBGWDataAsset
---@field CoinDropFXNumArray TArray<FCoinFXNum>
UBGWDataAsset_CoinDropFXNumConfig = {}



---@class UBGWDataAsset_CookRef : UBGWDataAsset
---@field PreloadDAList TArray<UBGWPreloadDataAsset>
UBGWDataAsset_CookRef = {}



---@class UBGWDataAsset_CricketInteractConfig : UBGWDataAsset
---@field CricketSocketName FString
---@field DummyMeshSocketName FString
---@field CameraAttachSocketName1 FString
---@field CameraAttachSocketName2 FString
---@field CameraBlendInTime float
---@field CameraBlendOutTime float
---@field FallDownCameraBlendOutTime float
---@field AMCricketPrepareInteract UAnimMontage
---@field AMPlayerPrepareInteract UAnimMontage
---@field AnimDummyMeshPrepareInteract UAnimationAsset
---@field JumpAnimConfig TArray<FCricketJumpPlayerAnimConfig>
---@field AMPlayerFinishInteract UAnimMontage
---@field AnimDummyMeshFinishInteract UAnimationAsset
---@field AMPlayerFallDown UAnimMontage
---@field AMCricketPrepareInteractLoop UAnimMontage
---@field AMPlayerPrepareInteractLoop UAnimMontage
---@field AnimDummyMeshPrepareInteractLoop UAnimationAsset
---@field AMCricketPrepareInteractBreak UAnimMontage
---@field AMPlayerPrepareInteractBreak UAnimMontage
---@field InteractFailCameraSequenceID int32
---@field AMCricketInteractFail UAnimMontage
UBGWDataAsset_CricketInteractConfig = {}



---@class UBGWDataAsset_CustomizedInputSetting : UBGWDataAsset
---@field WhiteKeyList TArray<FKey>
---@field Configs TMap<FName, FCustomizedKeyConfig>
---@field GamepadCustomizedInputConfigs TMap<CustomizedInputType, FGamepadCustomizedInputConfig>
UBGWDataAsset_CustomizedInputSetting = {}



---@class UBGWDataAsset_DamageNumConfig : UBGWDataAsset
---@field AmplitudeMin float
---@field AmplitudeMax float
---@field AmplitudeRandomParam float
---@field DefaultDir FVector2D
---@field DirRandomParam float
UBGWDataAsset_DamageNumConfig = {}



---@class UBGWDataAsset_DestructibleImpulseConfig : UBGWDataAsset
---@field DefaultImpulse float
---@field DestructibleHitImpulseMap TMap<EGSHitDestructibleStrengthLevel, float>
UBGWDataAsset_DestructibleImpulseConfig = {}



---@class UBGWDataAsset_DispB1ConstConfig : UBGW_DispLibConstDataAsset
UBGWDataAsset_DispB1ConstConfig = {}


---@class UBGWDataAsset_DropItemTemplete : UUBGWDropItemTemplete
UBGWDataAsset_DropItemTemplete = {}


---@class UBGWDataAsset_EnvEHF : UBGWDataAsset
---@field FogDensity float
---@field FogHeightFalloff float
---@field SecondFogData FExponentialHeightFogData
---@field FogInscatteringColor FLinearColor
---@field FogMaxOpacity float
---@field StartDistance float
---@field FogCutoffDistance float
---@field EnableVolumetricFog boolean
---@field Albedo FColor
UBGWDataAsset_EnvEHF = {}



---@class UBGWDataAsset_EnvironmentAbnormalEffectConfig : UBGWDataAsset
---@field EnvironmentAbnormalEffectList TArray<FEnvironmentAbnormalEffectConfig>
---@field interval float
---@field EnvironmentAbnormalAutoRecoverRateList TArray<FEnvironmentAbnormalRecoverRate>
UBGWDataAsset_EnvironmentAbnormalEffectConfig = {}



---@class UBGWDataAsset_EnvironmentMaskConfig : UBGWDataAsset
---@field EnvironmentMaskDataList TArray<FEnvironmentMaskData>
UBGWDataAsset_EnvironmentMaskConfig = {}



---@class UBGWDataAsset_EnvironmentMaskGlobalConfig : UBGWDataAsset
---@field EnvironmentMaskMappingList TMap<SceneItemSurfaceType, FEnvironmentMaskMappingData>
UBGWDataAsset_EnvironmentMaskGlobalConfig = {}



---@class UBGWDataAsset_EquipIllusionConfig : UBGWDataAsset
---@field position EquipPosition
---@field SM USkeletalMesh
---@field ABP TSubclassOf<UAnimInstance>
---@field StaticMesh TArray<UStaticMesh>
---@field ModularType int32
UBGWDataAsset_EquipIllusionConfig = {}



---@class UBGWDataAsset_FollowPartnerDisplayConfig : UBGWDataAsset
---@field WeakAiInteractConversationCD int32
---@field BreakInteractionConversationInfoList TArray<FAiBreakInteractionConversationInfo>
---@field IdleDodgeInfo FFollowPartnerDodgeInfo
---@field IdleWaitingInfo FFollowPartnerIdleWaitingInfo
UBGWDataAsset_FollowPartnerDisplayConfig = {}



---@class UBGWDataAsset_GameConfig : UBGWDataAsset
---@field RebirthDelayTimeWithAM float
---@field RebirthDelayTimeWithoutAM float
---@field RebirthDelayTimeSP TMap<int32, float>
---@field PlotDelayTimeWithAM float
UBGWDataAsset_GameConfig = {}



---@class UBGWDataAsset_GeneratePreloadDAConfig : UBGWDataAsset
---@field bAutoIncludeItemLevels boolean
---@field RootLevelFolderPaths TArray<FString>
---@field LevelsForPreload TArray<TSoftObjectPtr<UWorld>>
---@field TxtOutputName FString
---@field PreloadDAOutputName FString
UBGWDataAsset_GeneratePreloadDAConfig = {}



---@class UBGWDataAsset_GhostActorSetting : UBGWDataAsset
---@field GhostActorClass TSubclassOf<ABGUActorBase>
---@field JustCopyWeapon boolean
---@field WeaponIndex int32
---@field MatInstances TArray<UMaterialInterface>
---@field MatParams TArray<FMatParamInfo>
---@field PostProcessMatInstances TArray<UMaterialInterface>
---@field PostProcessMatParams TArray<FMatParam>
---@field bEnableCustomDepthStencil boolean
---@field CustomDepthStencilInfos TArray<FCustomDepthStencilInfo>
---@field Scale float
---@field ScaleUseCurve boolean
---@field ScaleCurve UCurveFloat
UBGWDataAsset_GhostActorSetting = {}



---@class UBGWDataAsset_GlobalBeImmobilizedConfig : UBGWDataAsset
---@field BeImmobilizedConfigs TArray<UBGWDataAsset_BeImmobilizedConfig>
UBGWDataAsset_GlobalBeImmobilizedConfig = {}



---@class UBGWDataAsset_GlobalFoliageInteractSoundConfig : UBGWDataAsset
---@field SoundMap TMap<FString, UAkAudioEvent>
UBGWDataAsset_GlobalFoliageInteractSoundConfig = {}



---@class UBGWDataAsset_GlobalRenderTargetConfig : UBGWDataAsset
---@field CanvasPainterMap TMap<SceneItemSurfaceType, FCanvasPainterData>
UBGWDataAsset_GlobalRenderTargetConfig = {}



---@class UBGWDataAsset_HatredBattleConfig : UBGWDataAsset
---@field HatredBattleBlackList TArray<int32>
UBGWDataAsset_HatredBattleConfig = {}



---@class UBGWDataAsset_HiAltFXAnimalSpawnConfig : UBGWDataAsset
---@field bEnableDebug boolean
---@field HighAltittude_Threshold float
---@field PresetCoolDown_AfterCloudMove float
---@field MaxCoutInWorld int32
---@field SpawnGap FFloatRange
---@field RandomTemplateList TArray<FHiAltFxAnimalSpawnTemplate>
UBGWDataAsset_HiAltFXAnimalSpawnConfig = {}



---@class UBGWDataAsset_HitAudioPreloadList : UBGWDataAsset
---@field ObjMapping TMap<FString, UObject>
UBGWDataAsset_HitAudioPreloadList = {}

function UBGWDataAsset_HitAudioPreloadList:UpdateConfig() end


---@class UBGWDataAsset_InputIconConfig : UBGWDataAsset
---@field IconInfo TArray<FKeyIconInfo>
UBGWDataAsset_InputIconConfig = {}



---@class UBGWDataAsset_InputMappingContextConfigV2 : UBGWDataAsset
---@field ChordActionDelayConflictActionDuration float
---@field DefaultCustomizedInputType CustomizedInputType
---@field Configs TMap<InputMappingContextTagV2, FInputMappingContextConfigV2>
UBGWDataAsset_InputMappingContextConfigV2 = {}



---@class UBGWDataAsset_InteractInfoTemplateMap : UBGWDataAsset
---@field TemplateMap TMap<InteractInfoTemplateType, FInteractInfoTemplateWithLOD>
UBGWDataAsset_InteractInfoTemplateMap = {}



---@class UBGWDataAsset_LevelInfo : UBGWDataAsset
---@field MainLevelInfo FDetailLevelInfo
---@field LiteLevelInfo FDetailLevelInfo
---@field LevelTagToLevelIdMap TMap<LevelTag, FLevelIdListInfo>
UBGWDataAsset_LevelInfo = {}



---@class UBGWDataAsset_LevelSequenceConfig : UBGWDataAsset
---@field StopEvent_WhenSkipping UAkAudioEvent
---@field MuteEvent_WhenSkipping UAkAudioEvent
---@field StopEvent_WhenSkippingOver UAkAudioEvent
UBGWDataAsset_LevelSequenceConfig = {}



---@class UBGWDataAsset_LocalFluid2DConfig : UBGWDataAsset
---@field toggleSim boolean
---@field bPostProcessCollisionData boolean
---@field blueprintDrivenParameters boolean
---@field bMovedCheck boolean
---@field blocationCheck boolean
---@field bLocalSim boolean
---@field bHighQualitySim boolean
---@field bSimAreaClamp boolean
---@field MaxIteration int32
---@field SimulationResX int32
---@field SimulationResY int32
---@field SimAreaSizeInCM float
---@field SnappedPosParameterName FName
---@field dynamicSDFMpc UMaterialParameterCollection
---@field worldOffsetThreshold float
---@field moveThreadhold float
---@field edgeExtendSize float
---@field bExportVeloDensity boolean
---@field bExportPressureDivergence boolean
---@field veloDensityOutput UTextureRenderTarget2D
---@field pressureDivergenceOutput UTextureRenderTarget2D
---@field CollisionQueryMaterial UMaterialInterface
---@field PPCollisionQueryMaterial UMaterialInterface
---@field CompositeMaterial UMaterialInterface
---@field AdvectMaterial UMaterialInterface
---@field DivergenceMaterial UMaterialInterface
---@field PressureStep1Material UMaterialInterface
---@field PressureStep2Material UMaterialInterface
---@field BrushPuncture float
---@field VeloDirNoise float
---@field Speed float
---@field VeloFromSimAreaMotion float
---@field SimEdgeBouncyness float
---@field FadeDensityAtSimEdge float
---@field VeloDirNoiseSize float
---@field VeloDirNoiseSpeed float
---@field VeloOffsetX float
---@field VeloOffsetY float
---@field VeloFromBrushMotion float
---@field VeloStrength float
---@field VeloRotate float
---@field VeloAmpNoise float
---@field InputFeedback float
---@field FlowFeedback float
---@field Divergence float
---@field BrushSize float
---@field BrushStrength float
---@field EraserMode float
---@field BrushHardness float
---@field DensityTemplate UTexture2D
---@field VelocityTemplate UTexture2D
---@field VelocityOffsetSpeed float
---@field EdgeMaskWidth float
---@field DensityTxtMult float
---@field DensityTxtScale float
---@field DensityTxtOffsetX float
---@field DensityTxtOffsetY float
---@field BrushNoise float
---@field VeloInputTile float
---@field DensityInputNoiseAmp float
---@field DensityInputNoiseOffset float
---@field DensityInputNoiseTile float
---@field BrushRnd float
UBGWDataAsset_LocalFluid2DConfig = {}



---@class UBGWDataAsset_MagicallyChangeConfig : UBGWDataAsset
---@field UnitScale float
---@field CapsuleHalfHeight float
---@field capsuleRadius float
---@field SKMesh USkeletalMesh
---@field Materials TArray<UMaterialInterface>
---@field ABPClass TSubclassOf<UAnimInstance>
---@field PhysicsAsset UPhysicsAsset
---@field TFXConfig TArray<FMagicallyChangeConfig_TFXConfig>
---@field Weapons TArray<FUnitWeapon>
---@field InteractBones TArray<FBoneUseForDispMap>
---@field Override_AbnormalDispID_Attacker int32
---@field Override_AbnormalDispID_Victim int32
---@field TamerAssetPath FString
UBGWDataAsset_MagicallyChangeConfig = {}

---@param Tamer ABUTamerActor
function UBGWDataAsset_MagicallyChangeConfig:ReadConfigFromUnit(Tamer) end


---@class UBGWDataAsset_ManualSplineMoveAnimConfig : UBGWDataAsset
---@field BeginMoveDBC UBGWDataAsset_B1DBC
---@field EndMoveDBC UBGWDataAsset_B1DBC
---@field MovingDBC UBGWDataAsset_B1DBC
---@field CameraType ManualSplineMoveCameraType
---@field RotationBlendTime float
---@field DirectionType ManualSplineMoveDirectionType
---@field LockDirectionDeltaAngle float
---@field MaxWalkSpeed float
---@field MaxAcceleration float
---@field AMBeginMove UAnimMontage
---@field AMEndMoveForward UAnimMontage
---@field AMEndMoveBackward UAnimMontage
---@field ASIdleForward UAnimSequence
---@field ASIdleBackward UAnimSequence
---@field ASStartForward UAnimSequence
---@field ASStartBackward UAnimSequence
---@field ASLoopForward UAnimSequence
---@field ASLoopBackward UAnimSequence
---@field ASStopForward UAnimSequence
---@field ASStopBackward UAnimSequence
---@field ASTurnF2B UAnimSequence
---@field ASTurnB2F UAnimSequence
UBGWDataAsset_ManualSplineMoveAnimConfig = {}



---@class UBGWDataAsset_MatLayerFunctionMappingConfig : UBGWDataAsset
---@field MatLayerFunctionInfoMap TMap<FName, FMatLayerFunctionInfo>
UBGWDataAsset_MatLayerFunctionMappingConfig = {}



---@class UBGWDataAsset_MaterialLayerParamGlobalConfig : UBGWDataAsset
---@field ConfigList TMap<FMaterialLayerKeyData, FMaterialLayerParamGlobalConfigData>
UBGWDataAsset_MaterialLayerParamGlobalConfig = {}



---@class UBGWDataAsset_NPCAnimInfoConfig : UBGWDataAsset
---@field IdleAnimInfoDic TMap<int32, FFNPCIdleAnimInfo>
---@field LeisureAnimInfoDic TMap<int32, FFNPCLeisureAnimInfo>
UBGWDataAsset_NPCAnimInfoConfig = {}



---@class UBGWDataAsset_NetMapConfig : UBGWDataAsset
---@field NetMapObjects TArray<FSoftObjectPath>
UBGWDataAsset_NetMapConfig = {}



---@class UBGWDataAsset_NiagaraParamColPreload : UBGWDataAsset
---@field Paths TArray<FString>
UBGWDataAsset_NiagaraParamColPreload = {}



---@class UBGWDataAsset_OSSCollectionConfig : UBGWDataAsset
---@field Battle_SpellFire_AngelUnit int32
---@field Battle_SpellFire_DistanceUnit int32
UBGWDataAsset_OSSCollectionConfig = {}



---@class UBGWDataAsset_ObservationModeConfig : UBGWDataAsset
---@field ObModeConfigMap TMap<ObModeSource, FObservationModeConfig>
---@field SpecialItemObModeConfigMap TMap<int32, FSpecialItemObModeConfig>
UBGWDataAsset_ObservationModeConfig = {}



---@class UBGWDataAsset_PELevelConfig : UBGWDataAsset
---@field Config TMap<int32, FFPEConfig>
---@field PELimit_Normal float
---@field PELimit_ByChargeSkill float
UBGWDataAsset_PELevelConfig = {}



---@class UBGWDataAsset_PartBreakAMInfoConfig : UBGWDataAsset
---@field EnableExtraAreaSelectType boolean
---@field SectorsType NormalStiffSectorsType
---@field PBAS_ForwardLeft_FNB float
---@field PBAS_ForwardRight_FNB float
---@field PBAS_ForwardLeft_FourDir float
---@field PBAS_ForwardRight_FourDir float
---@field PBAS_BackwardLeft_FourDir float
---@field PBAS_BackwardRight_FourDir float
---@field PartDamagedAMInfoList TArray<FPartDamagedAMInfo>
UBGWDataAsset_PartBreakAMInfoConfig = {}



---@class UBGWDataAsset_PatrolGroupSettings : UBGWDataAsset
---@field GroupIndexToUpdate int32
---@field PatrolGroups TArray<FPatrolGroupSetting>
UBGWDataAsset_PatrolGroupSettings = {}

function UBGWDataAsset_PatrolGroupSettings:ClearRepeatedSettings() end
function UBGWDataAsset_PatrolGroupSettings:ApplyAllPatrolGroupSettings() end
function UBGWDataAsset_PatrolGroupSettings:ClearAllPatrolGroupSettings() end
function UBGWDataAsset_PatrolGroupSettings:ApplySinglePatrolGroupSetting() end
function UBGWDataAsset_PatrolGroupSettings:ClearSinglePatrolGroupSetting() end


---@class UBGWDataAsset_PerformerConfig : UBGWDataAsset
---@field PerformerInfoMapping TMap<FName, FPerformerInfo>
UBGWDataAsset_PerformerConfig = {}



---@class UBGWDataAsset_PhantomRushRelatedeSkillConfig : UBGWDataAsset
---@field PhantomRushAtkSkill TArray<int32>
UBGWDataAsset_PhantomRushRelatedeSkillConfig = {}



---@class UBGWDataAsset_PlayerShootParam : UBGWDataAsset
---@field BlazeDuration float
---@field OneLightShotStaminaCost float
---@field StaminaFreezeTimer float
---@field ShootRadius float
---@field LightShootSkillID int32
---@field LightShootEffectID int32
UBGWDataAsset_PlayerShootParam = {}



---@class UBGWDataAsset_PostProcessMatSetting : UBGWDataAsset
---@field PostProcessMatInstances TArray<UMaterialInterface>
---@field PostProcessMatParams TArray<FMatParam>
---@field Weights TArray<float>
UBGWDataAsset_PostProcessMatSetting = {}



---@class UBGWDataAsset_PreloadOutlaws : UBGWDataAsset
---@field Outlaws TMap<int32, FResourceID_PreloadOutlaws>
---@field CheckedList TMap<int32, FResourceID_PreloadOutlaws>
---@field Outlaw_AbnormalState TArray<FString>
UBGWDataAsset_PreloadOutlaws = {}



---@class UBGWDataAsset_ProjectileSpawnConfig : UBGWDataAsset
---@field SpawnerType ProjectileSpawnerType
---@field bNeedHandleStopReq boolean
---@field BuffIDList TArray<int32>
---@field ProjectileID int32
---@field ProjectileWave int32
---@field ProjectileNumInOneWave int32
---@field SpawnBase FProjectileBaseStruct
---@field SpawnPosOffsetInfo FProjectilePosOffsetStruct
---@field AttachToSpawnBase boolean
---@field AttachRule_Rot EAttachmentRule
---@field TargetBase FProjectileBaseStruct
---@field TargetPosOffsetInfo FProjectilePosOffsetStruct
---@field BornDirBaseInfo FProjectileBornDirStruct
---@field BornDirOffset FProjectileBornDirOffsetStruct
---@field BulletFlySpd FSpawnBulletSpeed
---@field BulletRotSpd FSpawnBulletSpeed
---@field bEnableMultiTargetMode boolean
---@field MutilTargetRule FProjectileMulTargetRule
---@field bEnableSpawnBase_NoneTarget boolean
---@field SpawnBase_NoneTarget FProjectileBaseStruct
---@field SpawnPosOffsetInfo_NoneTarget FProjectilePosOffsetStruct
---@field bEnableTargetBase_NoneTarget boolean
---@field TargetBase_NoneTarget FProjectileBaseStruct
---@field TargetPosOffsetInfo_NoneTarget FProjectilePosOffsetStruct
UBGWDataAsset_ProjectileSpawnConfig = {}

---@return boolean
function UBGWDataAsset_ProjectileSpawnConfig:AboutEffectCaster() end


---@class UBGWDataAsset_RebirthPointNavigation : UBGWDataAsset
---@field Template TSubclassOf<AActor>
---@field EFXNodeOffsetAll FVector
---@field EFXNodeOffsetFirst FVector
---@field EFXNodeMaxNum int32
---@field EFXMinDir int32
---@field RefreshInterval float
---@field RefreshInterval_ResidentSound float
UBGWDataAsset_RebirthPointNavigation = {}



---@class UBGWDataAsset_SDFConfigAutoGenConfig : UBGWDataAsset
---@field BoneArray_1_First TArray<FName>
---@field BoneArray_1_Next TArray<FName>
---@field BoneArray_2_First TArray<FName>
---@field BoneArray_2_Next TArray<FName>
---@field BoneArray_3_First TArray<FName>
---@field BoneArray_3_Next TArray<FName>
UBGWDataAsset_SDFConfigAutoGenConfig = {}



---@class UBGWDataAsset_ScaleTimeSetting : UBGWDataAsset
---@field TimeScale float
---@field TotalTime float
---@field BlendInRealTime float
---@field BlendInType EGSBlendTypeG
---@field BlendInExp float
---@field BlendOutRealTime float
---@field BlendOutType EGSBlendTypeG
---@field BlendOutExp float
UBGWDataAsset_ScaleTimeSetting = {}



---@class UBGWDataAsset_SelectedTargetConfig : UBGWDataAsset
---@field SelectedRange float
---@field SelectedMaxMoveSpeed float
---@field SelectedMinMoveSpeed float
---@field SelectFollowMoveSpeed float
---@field GamepadSelectRotateSpeed float
---@field GamepadFollowRotateSpeed float
---@field FollowMoveTime float
---@field MinChangeAngle float
---@field MeleGamepadSelectedAngle float
---@field MeleMouseSelectedAngle float
---@field RangedGamepadSelectedAngle float
---@field RangedMouseSelectedAngle float
UBGWDataAsset_SelectedTargetConfig = {}



---@class UBGWDataAsset_SeqLevelLoadRelationInfo : UBGWSaveCheckDataAsset
---@field LevelRelationInfos TMap<FString, FSeqLevelRelationInfo>
---@field MovieRelationInfos TMap<int32, FMovieRelationInfoCollection>
---@field RelationDescriptions TMap<FString, FRelationLevelInfo>
UBGWDataAsset_SeqLevelLoadRelationInfo = {}



---@class UBGWDataAsset_SetUnitBattleBGM : UBGWDataAsset
---@field AkEventBegin UAkAudioEvent
---@field AkEventStop UAkAudioEvent
---@field BGMEventStopTimer float
---@field StopEventConditionConfig FStopEventConditionConfig
UBGWDataAsset_SetUnitBattleBGM = {}



---@class UBGWDataAsset_SkillIDBlackListConfig : UBGWDataAsset
---@field SkillList TArray<int32>
UBGWDataAsset_SkillIDBlackListConfig = {}



---@class UBGWDataAsset_SkillPrototypeSetting : UBGWDataAsset
---@field AnimMontages TArray<UAnimMontage>
UBGWDataAsset_SkillPrototypeSetting = {}



---@class UBGWDataAsset_SpecialBoneConfig : UBGWDataAsset
---@field UnitBP TSubclassOf<ABGUCharacterCS>
---@field SweepCheckBoneBlackList TArray<FName>
---@field SweepCheckBoneWhiteList TArray<FName>
UBGWDataAsset_SpecialBoneConfig = {}



---@class UBGWDataAsset_SpiderSetting : UBGWDataAsset
---@field SpiderSetting FAnimHumanoidSetting_Spider
UBGWDataAsset_SpiderSetting = {}



---@class UBGWDataAsset_SpiderSilkEntangleConfig : UBGWDataAsset
---@field NG_Template UNiagaraSystem
---@field DBC_Template UBGWDataAsset_B1DBC
---@field MaxCount float
---@field CountThreshold_HardMove float
---@field HardMoveBuffID int32
---@field bExitHardMoveWhenJump boolean
---@field EntangleSkillEffectID int32
---@field SkillAccCountMapping TMap<int32, float>
---@field SpeedMonitorInterval float
---@field MappingCurve_Speed UCurveFloat
---@field IncreaseCount_OnJump float
---@field IncreaseCount_OnLand float
---@field Mapping_NiagaraParam TArray<FSilkEntangleNiagaraParamMapping>
UBGWDataAsset_SpiderSilkEntangleConfig = {}



---@class UBGWDataAsset_SplineBirdSpawnConfig : UBGWDataAsset
---@field bEnableDebug boolean
---@field GlobalRefreshCoolDown float
---@field SplineUseProtectTime float
---@field SplineFilterDist FFloatRange
---@field MaxCoutInWorld int32
---@field SpawnGap FFloatRange
---@field FXAnimalTemplateList TArray<TSubclassOf<ABGUFXAnimalActor>>
---@field FXAnimalTemplateMap TMap<FName, TSubclassOf<ABGUFXAnimalActor>>
UBGWDataAsset_SplineBirdSpawnConfig = {}



---@class UBGWDataAsset_StateLib : UBGWDataAsset
---@field LeftSmallTurnSkillID int32
---@field RightSmallTurnSkillID int32
---@field LeftBigTurnSkillID int32
---@field RightBigTurnSkillID int32
---@field ArmorSetting FFGSArmorSettingInBP
---@field MoveSpeedFast float
---@field MoveSpeedNormal float
---@field MoveSpeedSlow float
---@field ABPSetting UBGWDataAsset_AbpHumanoidSetting
---@field BeAttackedInfoID int32
---@field UnitCameraID int32
---@field DeadInfoID int32
---@field MovementMode EMovementMode
---@field PartRuleID int32
---@field DodgeSkillID int32
---@field PreciseDodgeSkillID int32
---@field AMScaleMaxRate float
---@field SpecialBoneConfig UBGWDataAsset_SpecialBoneConfig
---@field BodiesNameList_BodiesCollisionEnable TArray<FName>
---@field bEnable_BodiesCollisionEnable boolean
---@field DefaultDisabledHitMoveCollisions TArray<FName>
UBGWDataAsset_StateLib = {}



---@class UBGWDataAsset_StaticMeshActorSetting : UBGWDataAsset
---@field Mesh UStaticMesh
---@field Materials TArray<UMaterialInterface>
---@field MaterialParameters TArray<FMatParam>
---@field DurationTime int32
UBGWDataAsset_StaticMeshActorSetting = {}



---@class UBGWDataAsset_StreamingLevelStateConfig : UBGWSaveCheckDataAsset
---@field DefaultManagedStateLevelConfig FManagedStreamingLevelStateConfig
---@field StreamingLevelBoxTriggerConfig TArray<FManagedStreamingLevelStateBoxConfig>
---@field LevelGetterKeywordInput FString
---@field LevelGetterOutput TArray<FString>
UBGWDataAsset_StreamingLevelStateConfig = {}

function UBGWDataAsset_StreamingLevelStateConfig:SubLevelNamesGetter() end


---@class UBGWDataAsset_SweepCheckDebugCollisionInfoConfig : UBGWDataAsset
---@field SCDCollisionInfo FFSCDCollisionInfo
---@field HitUnitSCDCollisionInfo FFSCDCollisionInfo
---@field HitBulletSCDCollisionInfo FFSCDCollisionInfo
---@field HitSceneItemSCDCollisionInfo FFSCDCollisionInfo
---@field HitWorldItemSCDCollisionInfo FFSCDCollisionInfo
---@field AWDCollisionInfo FFSCDCollisionInfo
---@field HitUnitAWDCollisionInfo FFSCDCollisionInfo
---@field HitSceneItemAWDCollisionInfo FFSCDCollisionInfo
---@field HitWorldItemAWDCollisionInfo FFSCDCollisionInfo
---@field HitBulletAWDCollisionInfo FFSCDCollisionInfo
UBGWDataAsset_SweepCheckDebugCollisionInfoConfig = {}



---@class UBGWDataAsset_SwitchBulletResetTargetConfig : UBGWDataAsset
---@field TargetBase FProjectileBaseStruct
---@field TargetPosOffsetInfo FProjectilePosOffsetStruct
UBGWDataAsset_SwitchBulletResetTargetConfig = {}



---@class UBGWDataAsset_TROConfig : UBGWDataAsset
---@field BaseVisibleDistanceFactorThesholds TArray<float>
---@field BaseNonRenderedUpdateRate int32
---@field CppTickCullDistance float
---@field CharacterMovementNavWalkingDistance float
---@field CharacterMovementTickCullDistance float
UBGWDataAsset_TROConfig = {}



---@class UBGWDataAsset_TakePhotoSystemConfig : UBGWDataAsset
---@field IsKeepLocalMove boolean
---@field CameraMoveableDistance float
---@field CameraMoveableHeight float
---@field MoveAccelerationFactor FVector
---@field MoveSpeedFactor FVector
---@field MouseFixedResistance float
---@field IsTurnImmediately boolean
---@field MouseYawRotationFactor float
---@field MousePitchRotationFactor float
---@field RotateSpeed_LR float
---@field RotateSpeed_UD float
---@field PhysicsAssetCheckRange float
---@field FilterList TArray<FFTPModeFilterInfo>
---@field StickerImageList TArray<FFTPModeStickerImage>
---@field FrameList TArray<FFTPModeFrame>
---@field ConfigTabTextureInfo TArray<UTexture2D>
---@field EnterEnhancedTime float
---@field ShortcutInputAction UInputAction
---@field InvalidTransformingResIDList TArray<int32>
---@field TakePhotoActor_BP TSubclassOf<ABGUTakePhotoActor>
UBGWDataAsset_TakePhotoSystemConfig = {}



---@class UBGWDataAsset_TamerAndBulletSkillIDConfig : UBGWDataAsset
---@field BulletSkillTestInfos TArray<FBulletSkillTestInfo>
UBGWDataAsset_TamerAndBulletSkillIDConfig = {}



---@class UBGWDataAsset_TamerListConfig : UBGWDataAsset
---@field CommandList TArray<FString>
---@field TamerList TArray<FString>
UBGWDataAsset_TamerListConfig = {}



---@class UBGWDataAsset_TaskGraphConfig : UBGWDataAsset
---@field TaskGraphAsset UCalliopeAsset
UBGWDataAsset_TaskGraphConfig = {}



---@class UBGWDataAsset_TigerWoodsConfig : UBGWDataAsset
---@field TWImpulseDataList TArray<FFTWImpulseData>
---@field TWImpulseBlendCurve UCurveFloat
---@field TWForceDataList TArray<FFTWForceData>
---@field TWForceBlendCurve UCurveFloat
---@field PhysicsDistanceThreshold float
---@field InterpolationDistanceThreshold float
---@field LocationInterpolationSpeedCurve UCurveFloat
---@field RotationInterpolationSpeedCurve UCurveFloat
UBGWDataAsset_TigerWoodsConfig = {}



---@class UBGWDataAsset_TortoiseLevelStreamingConfig : UBGWDataAsset
---@field DefaultManagedStateLevelConfig FTortoiseManagedStateLevelConfig
---@field StreamingLevelBoxTriggerConfig TArray<FTortoiseLevelStreamingBoxConfig>
---@field LevelGetterKeywordInput FString
---@field LevelGetterOutput TArray<FString>
UBGWDataAsset_TortoiseLevelStreamingConfig = {}

function UBGWDataAsset_TortoiseLevelStreamingConfig:SubLevelNamesGetter() end


---@class UBGWDataAsset_TrainDummyConfig : UBGWDataAsset
---@field TrainDummyHPType EGSTrainDummyHPType
---@field TrainDummyHPValue int32
---@field NeedCloseTrainDummyAI boolean
---@field DPSCalTimeType EDPSCalTimeType
---@field DPSCalTime float
---@field SpecialDamageTypeConfigList TArray<FTrainDummySpecialDamageTypeConfig>
UBGWDataAsset_TrainDummyConfig = {}



---@class UBGWDataAsset_TransEffectSetting : UBGWDataAsset
---@field TransEffect UNiagaraSystem
---@field Duration float
---@field NiagaraParams TArray<FGSNiagaraSysParam>
UBGWDataAsset_TransEffectSetting = {}



---@class UBGWDataAsset_TryFindSceneItemConfig : UBGWDataAsset
---@field SceneActorTags TArray<FName>
---@field MinDistance float
---@field MaxDistance float
---@field FindSceneItemWay FindSceneItemWay
---@field NeedRemoveCurrentCatch boolean
UBGWDataAsset_TryFindSceneItemConfig = {}



---@class UBGWDataAsset_UnitBarConfig : UBGWDataAsset
---@field LockDelayTime float
---@field LastDmgDelayTime float
UBGWDataAsset_UnitBarConfig = {}



---@class UBGWDataAsset_UnitBeAttackedConfig : UBGWDataAsset
---@field NoteString1 uint8
---@field NoteString2 uint8
---@field NoteString3 uint8
---@field NormalStiffAMPath FString
---@field UnitResName FString
---@field NormalStiffInfoList TArray<FNormalStiffInfo>
---@field BeHitResFlyHit UAnimMontage
---@field BeHitResFlyHitWithRM UAnimMontage
---@field BeRoaredResForLight UAnimMontage
---@field BeRoaredResForMedium UAnimMontage
---@field BeRoaredResForHeavy UAnimMontage
---@field PointAttractionFrontAM UAnimMontage
---@field PointAttractionBackAM UAnimMontage
---@field BeBlindStiffingAM UAnimMontage
---@field ImmobilizeBreakFXPath FName
---@field ImmobilizeBreakForwardAM UAnimMontage
---@field ImmobilizeBreakBackwardAM UAnimMontage
---@field ImmobilizeBreakLeftsideAM UAnimMontage
---@field ImmobilizeBreakRightsideAM UAnimMontage
---@field ForwardBeAttackedAdditiveAnim UAnimMontage
---@field RightBeAttackedAdditiveAnim UAnimMontage
---@field LeftBeAttackedAdditiveAnim UAnimMontage
---@field BackwardBeAttackedAdditiveAnim UAnimMontage
---@field FrozenBreakAM UAnimMontage
---@field Enable_Rotate_AssistBreakFrozen boolean
---@field AssistBreakFrozenAM UAnimMontage
---@field HitLevelDivide_Jump int32
---@field ForwardBeAttackedAdditiveAnim_Jump UAnimMontage
---@field RightBeAttackedAdditiveAnim_Jump UAnimMontage
---@field LeftBeAttackedAdditiveAnim_Jump UAnimMontage
---@field BackwardBeAttackedAdditiveAnim_Jump UAnimMontage
---@field BeAttackedAnim_Jump UAnimMontage
---@field BeAttackedAnim_Jump_CliffDistCheck float
---@field BeAttackedAnim_PillarFormBreak UAnimMontage
---@field NormalStiffAMList TArray<UAnimMontage>
UBGWDataAsset_UnitBeAttackedConfig = {}



---@class UBGWDataAsset_UnitCommonInputAction : UBGWDataAsset
---@field CommonInputAction TArray<int32>
UBGWDataAsset_UnitCommonInputAction = {}



---@class UBGWDataAsset_UnitDeathDispConfig : UBGWDataAsset
---@field NormalDeadAMPath FString
---@field UnitResName FString
---@field NormalDeadAMInfoList TArray<FNormalDeadAMInfo>
---@field NormalDissolveDBC UBUC_DispLibDispBaseConfigDataAsset
---@field DeathDissolvePlayType DeathDissolvePlayType
---@field BurnStateDotDeadMontage UAnimMontage
---@field PoisonStateDotDeadMontage UAnimMontage
---@field FreezeStateDotDeadMontage UAnimMontage
---@field ImmobilizingDeadMontage UAnimMontage
---@field OceanSeaDeadMontage UAnimMontage
---@field InteractCricketDeadMontage UAnimMontage
---@field SuicideDeadMontage UAnimMontage
---@field AirDeadMontage_Fall UAnimMontage
---@field AirDeadMontage_WithDirection UAnimMontage
---@field FallDeadMontage UAnimMontage
---@field NormalDeadAMList TArray<UAnimMontage>
UBGWDataAsset_UnitDeathDispConfig = {}

---@param _NormalDissolveDBC UBUC_DispLibDispBaseConfigDataAsset
---@param Burn_AbnormalStateDeadDBC UBUC_DispLibDispBaseConfigDataAsset
---@param Burn_AbnormalStateDissolveDBC UBUC_DispLibDispBaseConfigDataAsset
---@param Thunder_AbnormalStateDeadDBC UBUC_DispLibDispBaseConfigDataAsset
---@param Thunder_AbnormalStateDissolveDBC UBUC_DispLibDispBaseConfigDataAsset
---@param Poison_AbnormalStateDeadDBC UBUC_DispLibDispBaseConfigDataAsset
---@param Poison_AbnormalStateDissolveDBC UBUC_DispLibDispBaseConfigDataAsset
---@param Freeze_AbnormalStateDeadDBC UBUC_DispLibDispBaseConfigDataAsset
---@param Freeze_AbnormalStateDissolveDBC UBUC_DispLibDispBaseConfigDataAsset
---@param Yin_AbnormalStateDeadDBC UBUC_DispLibDispBaseConfigDataAsset
---@param Yin_AbnormalStateDissolveDBC UBUC_DispLibDispBaseConfigDataAsset
---@param Yang_AbnormalStateDeadDBC UBUC_DispLibDispBaseConfigDataAsset
---@param Yang_AbnormalStateDissolveDBC UBUC_DispLibDispBaseConfigDataAsset
function UBGWDataAsset_UnitDeathDispConfig:SetDefaultDBCAsset(_NormalDissolveDBC, Burn_AbnormalStateDeadDBC, Burn_AbnormalStateDissolveDBC, Thunder_AbnormalStateDeadDBC, Thunder_AbnormalStateDissolveDBC, Poison_AbnormalStateDeadDBC, Poison_AbnormalStateDissolveDBC, Freeze_AbnormalStateDeadDBC, Freeze_AbnormalStateDissolveDBC, Yin_AbnormalStateDeadDBC, Yin_AbnormalStateDissolveDBC, Yang_AbnormalStateDeadDBC, Yang_AbnormalStateDissolveDBC) end


---@class UBGWDataAsset_UnitDynamicObstaclePerformanceConfig : UBGWDataAsset
---@field bDontPlayDBC boolean
---@field OverrideDBC UBGWDataAsset_B1DBC
---@field PerformAMType UnitDynamicObstaclePerformAMType
---@field bNeedRot boolean
---@field F_DegLine_FBMode float
---@field F_DegLine_4DirMode float
---@field B_DegLine_4DirMode float
---@field AM_F_List TArray<UAnimMontage>
---@field AM_B_List TArray<UAnimMontage>
---@field AM_L_List TArray<UAnimMontage>
---@field AM_R_List TArray<UAnimMontage>
UBGWDataAsset_UnitDynamicObstaclePerformanceConfig = {}



---@class UBGWDataAsset_VigorSkillMimicryConfig : UBGWDataAsset
---@field CapsuleHalfHeight float
---@field capsuleRadius float
---@field SKMesh USkeletalMesh
---@field Materials TArray<UMaterialInterface>
---@field ABPClass TSubclassOf<UAnimInstance>
---@field PhysicsAsset UPhysicsAsset
---@field AnimMimicryStart UAnimMontage
---@field Override_AbnormalDispID_Attacker int32
---@field Override_AbnormalDispID_Victim int32
UBGWDataAsset_VigorSkillMimicryConfig = {}



---@class UBGWDataAsset_WaterSplashMapping : UBGWDataAsset
---@field bDrawDebug boolean
---@field SocketName_PostAudio FName
---@field AudioFadeOutTime_Ms int32
---@field ResourceMap TMap<int32, FWaterSplashResourceMap_WithSurfaceType>
UBGWDataAsset_WaterSplashMapping = {}



---@class UBGWDemo820ConfigDataAsset : UBGWDataAsset
---@field OpenLevelInfo TArray<FDemo820LevelInfo>
---@field OverSeaOpenLevelInfo TArray<FDemo820LevelInfo>
---@field OpenLevelIdIdx TMap<int32, int32>
---@field TimeInfo FDemo820TimeInfo
---@field OverSeaTimeInfo FDemo820TimeInfo
---@field SaveTimeDelay float
---@field ChangeLevelCameraTime float
---@field PassLevelCurve UCurveFloat
---@field CurveTimeMax float
---@field DelayTimeBossList TArray<int32>
---@field BossHpPercent float
---@field BossDelayTime float
UBGWDemo820ConfigDataAsset = {}



---@class UBGWDreamTeleportPointsComp : UGameInstanceSystemBaseUObj
UBGWDreamTeleportPointsComp = {}

function UBGWDreamTeleportPointsComp:OnAfterTeleportMontageEnded() end
function UBGWDreamTeleportPointsComp:OnBeforeTeleportMontageEnded() end


---@class UBGWEquipPreviewConfigDataAsset : UBGWDataAsset
---@field PositionConfigMap TMap<EquipPosition, FEquipPreviewPositionConfig>
---@field WineDBCDAMap TMap<EquipFXType, UBGWDataAsset>
---@field WinePartnerDBCDAMap TMap<EquipFXType, UBGWDataAsset>
---@field LegacyActiveDBCDAMap TMap<int32, UBGWDataAsset>
UBGWEquipPreviewConfigDataAsset = {}



---@class UBGWFallDyingConfigDataAsset : UBGWDataAsset
---@field SaveSelfWaitTime int32
---@field SaveSelfNeedTime int32
---@field SaveTeammateWaitTime int32
---@field FallDyingLifeTime int32
---@field TeamRebirthSkillID int32
---@field SelfRebirthSkillID int32
---@field ChallengeRebirthTime int32
UBGWFallDyingConfigDataAsset = {}



---@class UBGWFollowPartnerConfigDataAsset : UBGWDataAsset
---@field SeqShowingFinishMoveEQSTemplate UEnvQuery
---@field HiddenSelfDBC UBUC_DispLibDispBaseConfigDataAsset
UBGWFollowPartnerConfigDataAsset = {}



---@class UBGWGameInstanceCS : UBGWGameInstance
---@field ObjRefs TArray<UObject>
UBGWGameInstanceCS = {}

---@param DeltaSeconds float
---@param TickGroup int32
function UBGWGameInstanceCS:ReceiveTick(DeltaSeconds, TickGroup) end
function UBGWGameInstanceCS:ReceiveInit() end
function UBGWGameInstanceCS:ReceiveShutdown() end
---@param OldWorld UWorld
---@param NewWorld UWorld
function UBGWGameInstanceCS:OnWorldChangedCS(OldWorld, NewWorld) end
---@param World UWorld
function UBGWGameInstanceCS:OnPostActorTickCS(World) end
---@param World UWorld
function UBGWGameInstanceCS:OnWorldTickStartCS(World) end
---@param StartType EStartGameInstanceTypeForCS
function UBGWGameInstanceCS:StartGameInstanceForCS(StartType) end
---@return TSubclassOf<UOnlineSession>
function UBGWGameInstanceCS:GetOnlineSessionClassCS() end
---@param DeltaSeconds float
---@param TickGroup int32
function UBGWGameInstanceCS:ReceiveTickEvenWhenPaused(DeltaSeconds, TickGroup) end
---@param NewMatchState FName
function UBGWGameInstanceCS:OnGameModeMatchStateSetCS(NewMatchState) end


---@class UBGWGroupAIBattleHotZoneConfigDataAsset : UBGWDataAsset
---@field BattleCirclePointRingNum int32
---@field BattleCirclePointAngleInterval int32
---@field MeleeAttackCircleCustomInfo FGroupAIHotZoneCircleCustomInfo
---@field ShortBattleCircleCustomInfo FGroupAIHotZoneCircleCustomInfo
---@field RangeAttackCircleCustomInfo FGroupAIHotZoneCircleCustomInfo
---@field MiddleBattleCircleCustomInfo FGroupAIHotZoneCircleCustomInfo
---@field LongBattleCircleCustomInfo FGroupAIHotZoneCircleCustomInfo
---@field ShortBattleCircleRadius int32
---@field MiddleBattleCircleRadius int32
---@field LongBattleCircleRadius int32
---@field MeleeAttackHotZoneInnerRadius int32
---@field MeleeAttackHotZoneOneSideAngle int32
---@field RangeAttackHotZoneOneSideAngle int32
UBGWGroupAIBattleHotZoneConfigDataAsset = {}



---@class UBGWGroupAIMgrConfigDataAsset : UBGWDataAsset
---@field PerformerNumToStart int32
---@field UpdateDuration float
---@field UpdateDurationForAllocHotZonePoint float
---@field MaxAtkMoveTime float
---@field NormalTaskWaitTime float
---@field NormalTaskBeginNoiseTimeForMeleeAttacker float
---@field NormalTaskBeginNoiseTimeForRangeAttacker float
---@field IsNoMoveAttackInFirstRound boolean
---@field MeleeAttackTokenNum int32
---@field RangeAttackTokenNum int32
---@field MinMeleeAttackTokenReplenishedNum int32
---@field MinRangeAttackTokenNumWhenReplenished int32
---@field InViewAngleOneSide float
---@field MoveTo_DCParam_Switch2KFTDistance int32
---@field MoveTo_DCParam_Switch2MoveToDistance int32
---@field OutermostCircleWanderNearbyChooseRatio int32
---@field NoteString1 uint8
---@field InCameraViewportWeight float
---@field OutCameraViewportWeight float
---@field DistanceScoreWeight float
---@field AngleScoreWeight float
---@field LastAttackPerSecondScore float
---@field LastAttackPerSecondScoreMax float
---@field LockExtraScore float
---@field BossExtraScore float
UBGWGroupAIMgrConfigDataAsset = {}



---@class UBGWHatredConfigDataAsset : UBGWDataAsset
---@field AttenuationBeginTime int32
---@field AttenuationSpeed int32
---@field AttenuationSpeedForSkillExtra int32
---@field CommonCorrectionFactor int32
---@field HatredTickInterval int32
---@field BeLockedCorrectionFactor int32
---@field QualityCorrectionFactor int32
---@field LockCorrectionFactor int32
---@field ForceUpdateHatredTargetTime int32
---@field ReduceHatredValueWhenCastSkillSuccess int32
---@field OneSideViewAngle int32
---@field NotInViewHatredWeight float
---@field HatredBattleBlackList TArray<int32>
UBGWHatredConfigDataAsset = {}



---@class UBGWHeroIconConfigDataAsset : UBGWDataAsset
---@field HeroIconInfoList TArray<FHeroIconInfo>
UBGWHeroIconConfigDataAsset = {}



---@class UBGWMapUIConfigDataAsset : UBGWDataAsset
---@field LevelConfigMap TMap<MapSymbolLevel, FMapLevelConfig>
---@field MinScale float
---@field MaxScale float
---@field MaxMoveRange FVector2D
UBGWMapUIConfigDataAsset = {}



---@class UBGWMonkeySummonDataAsset : UBGWDataAsset
---@field SummonSpawnPointList TArray<FSummonSpawnQuene>
---@field MapSummonSateBehaviorTree TMap<SummonBehaviorState, UBehaviorTree>
---@field DefauleSummonBehaviorState SummonBehaviorState
---@field bAllowSpawnPointAwayFromNavMesh boolean
UBGWMonkeySummonDataAsset = {}



---@class UBGWMonsterManualConfigDataAsset : UBGWDataAsset
---@field MPCBook UMaterialParameterCollection
---@field MonsterManualInfoMap TMap<int32, FMonsterManualInfo>
UBGWMonsterManualConfigDataAsset = {}



---@class UBGWPhysMoveAnimDataAsset : UBGWBasePhysAnimDataAsset
---@field BoneNameToSimulatePhysics FName
UBGWPhysMoveAnimDataAsset = {}



---@class UBGWPriorityActionQueDataAsset : UBGWDataAsset
---@field PriorityActionMap TMap<int32, FPriorityActionQueInfo>
UBGWPriorityActionQueDataAsset = {}



---@class UBGWProceduralMapBlockMappingDataAsset : UBGWDataAsset
---@field MapBlockMapping TMap<MapCatFlag, FSoftObjectPath>
UBGWProceduralMapBlockMappingDataAsset = {}



---@class UBGWProceduralMapConfigDataAsset : UBGWDataAsset
---@field MapType ProceduralMapType
---@field MapWidth int32
---@field MapHeight int32
---@field BlockWidth int32
---@field BlockHeight int32
---@field IsUsingRanEE boolean
---@field EntranceX int32
---@field EntranceY int32
---@field ExitX int32
---@field ExitY int32
---@field ExpectedPointNumber int32
---@field MinPointWidth int32
---@field MinPointHeight int32
---@field MaxPointWidth int32
---@field MaxPointHeight int32
UBGWProceduralMapConfigDataAsset = {}



---@class UBGWProceduralSpawnCharacterLibDataAsset : UBGWDataAsset
---@field CharacterInfoList TArray<FCharacterSpawnerLibInfo>
UBGWProceduralSpawnCharacterLibDataAsset = {}



---@class UBGWProceduralSpawnCharacterWaveConfigDataAsset : UBGWDataAsset
---@field ProceduralSpawnCharaterConfig FProceduralSpawnCharaterConfig
UBGWProceduralSpawnCharacterWaveConfigDataAsset = {}



---@class UBGWProceduralSpawnSceneItemDataAsset : UBGWDataAsset
---@field ProceduralItemConfig FProceduralSpawnSceneItemConfig
UBGWProceduralSpawnSceneItemDataAsset = {}



---@class UBGWTamerSettingConfigDataAsset : UBGWDataAsset
---@field TamerStrategyPreDefinesForLevelOverride FTamerStrategyPreDefinesForLevelOverride
UBGWTamerSettingConfigDataAsset = {}



---@class UBGWTickRateOptimizeWorldSubSystem : UBGWTickableWorldSubSystem
UBGWTickRateOptimizeWorldSubSystem = {}

---@param InWorld UWorld
function UBGWTickRateOptimizeWorldSubSystem:OnWorldBeginPlayCS(InWorld) end
---@param WorldType int32
---@return boolean
function UBGWTickRateOptimizeWorldSubSystem:DoesSupportWorldTypeCS(WorldType) end


---@class UBGWTransBGMConfigDataAsset : UBGWDataAsset
---@field TransBGMConfig FSingleTransBGMConfig
UBGWTransBGMConfigDataAsset = {}



---@class UBGWTransPreviewConfigDataAsset : UBGWDataAsset
---@field AnimInConfigMap TMap<int32, UAnimMontage>
UBGWTransPreviewConfigDataAsset = {}



---@class UBGWUIConfigDataAsset : UBGWDataAsset
---@field DropFirstShowDelayTime float
---@field DropShowTime float
---@field DropMinShowTime float
---@field DropInFuncShowTime float
---@field DropAdvanceShowTime float
---@field DropAdvanceMinShowTime float
---@field DropInFuncAdvanceShowTime float
---@field DropManualShowTime float
---@field DropAdvanceJumpTime float
---@field DropSpecialTipsShowTime float
---@field DropSpecialShowTime float
---@field ExpShowTime float
---@field ExpMultiShowTime float
---@field DropMuseumShowTime float
---@field ShortcutActiveDelayTime float
---@field ShortcutDetailActiveDelayTime float
---@field ShortcutItemNudge float
---@field StToNrDelayTime float
---@field StToNrEasingTime float
---@field NrToStDelayTime float
---@field NrToStEasingTime float
---@field ShortcutSpellSort TArray<SpellType>
---@field ShowProtectTime float
---@field BattleMainFadeTime float
---@field InSeqShowProtectTime float
---@field InSeqBattleMainFadeTime float
---@field ActionMappingList TArray<FString>
---@field ShortcutSpellAction FString
---@field ShortcutItemAction FString
---@field HPLowPostProcessPercent float
---@field HPLimitPostProcessPercent float
---@field HPLowPostProcessSliderFreq float
---@field HPLimitPostProcessSliderFreq float
---@field HPLimitPostProcessAudioTime float
---@field HPPostProcessStopUIList TArray<EUIPageType>
---@field StylePoseMPC UMaterialParameterCollection
---@field ProgBaseTexSizeV1 float
---@field ProgBaseTexSizeV2 float
---@field ProgBaseTexSizeV3 float
---@field ProgPercentSplite float
---@field DBBInputHPPre float
---@field HpDefaultMap TMap<int32, float>
---@field ProcBarConfigMap TMap<int32, FProcBarConfig>
---@field CloudMoveTipsDelayTime float
---@field SeqSkipLongPressTime float
---@field SeqSkipFadeTime float
---@field ProgLevelResIDList TArray<int32>
---@field HideMouseCheckTime float
---@field BasePixelHeight int32
---@field BaselineOffset int32
---@field ConnectIconOffset int32
---@field MenuSwitchStartTime float
---@field MenuSwitchCheckTime float
---@field FirstSwitchThreshold float
---@field RepeatSwitchThreshold float
---@field SelectedDelayTime float
---@field UIFXMPC UMaterialParameterCollection
---@field UIGlobalMPC UMaterialParameterCollection
---@field TeleportAKBPicSwitchDelayTime float
---@field CastEnergyLevel TArray<float>
---@field AchieveTipsShowTime float
---@field TileItemConfig TMap<TileItemScene, FTileItemConfig>
---@field LoginNoticeIsCanSkip boolean
---@field TalentAllResetLongPressTime float
---@field TalentTabResetLongPressTime float
---@field LegacyMouseAreaDelayCheckTime float
---@field SliderDelayInputGap float
---@field UseHoverSelected boolean
---@field SettingHpConfig TArray<FSettingHpConfig>
---@field InputTipsConfig TMap<EUIPageType, FInputTipsLeftRightCfg>
---@field DelaySkippableTime float
---@field MediaClampTimeMap TMap<int32, FVector2D>
UBGWUIConfigDataAsset = {}



---@class UBGWUIDropItemConfigDataAsset : UBGWDataAsset
---@field DropItemWidgetCls TSubclassOf<UUserWidget>
---@field DropItemFlyTime float
---@field DropItemDelayDestroyTime float
---@field DropItemFlyCurveType DropItemFlyCurveType
---@field AmplitudeMin float
---@field AmplitudeMax float
---@field EffectBoomLengthMin float
---@field EffectBoomLengthMax float
---@field DistParam float
---@field DegParam float
UBGWUIDropItemConfigDataAsset = {}



---@class UBGWUltimateInfoDataAsset : UBGWDataAsset
---@field UltimateSkillConfigInfo TArray<FUltimateSkillConfigInfo>
UBGWUltimateInfoDataAsset = {}



---@class UBGW_820DemoPlayTimeMgr : UGameInstanceSystemBaseUObj
UBGW_820DemoPlayTimeMgr = {}


---@class UBGW_AsyncTaskMgr : UGameInstanceSystemBaseUObj
---@field HttpRequestCallbackListeners TArray<UUGSSdkHttpRequestCallbackListener>
UBGW_AsyncTaskMgr = {}



---@class UBGW_AutoResetGISCVarMgr : UGameInstanceSystemBaseUObj
UBGW_AutoResetGISCVarMgr = {}


---@class UBGW_BattleTriggerMgr : UGameInstanceSystemBaseUObj
UBGW_BattleTriggerMgr = {}


---@class UBGW_CETestGameMgr : UGameInstanceSystemBaseUObj
UBGW_CETestGameMgr = {}


---@class UBGW_CalliopeDebugManager : UGameInstanceSystemBaseUObj
UBGW_CalliopeDebugManager = {}


---@class UBGW_CameraAdapterMgr : UGameInstanceSystemBaseUObj
---@field GSViewPortHelper UGSViewPortHelper
UBGW_CameraAdapterMgr = {}

---@param NewWidth int32
---@param NewHeight int32
function UBGW_CameraAdapterMgr:OnViewPortResized(NewWidth, NewHeight) end


---@class UBGW_ChapterView820Mgr : UGameInstanceSystemBaseUObj
UBGW_ChapterView820Mgr = {}

---@param BeginStateName FName
---@param EndStateName FName
---@param IsForceImSet boolean
function UBGW_ChapterView820Mgr:OnAKBStateEndFunc(BeginStateName, EndStateName, IsForceImSet) end
function UBGW_ChapterView820Mgr:OnLeaveSeqFinished() end
function UBGW_ChapterView820Mgr:OnEntranceSeqFinished() end


---@class UBGW_ChapterViewMgr : UGameInstanceSystemBaseUObj
UBGW_ChapterViewMgr = {}

---@param BeginStateName FName
---@param EndStateName FName
---@param IsForceImSet boolean
function UBGW_ChapterViewMgr:OnAKBStateEndFunc(BeginStateName, EndStateName, IsForceImSet) end
function UBGW_ChapterViewMgr:OnLeaveSeqFinished() end
function UBGW_ChapterViewMgr:OnChapterSeqFinished() end
function UBGW_ChapterViewMgr:OnEntranceSeqFinished() end
function UBGW_ChapterViewMgr:OnSurpriseSeqFinished() end


---@class UBGW_ChapterViewMgrV2 : UGameInstanceSystemBaseUObj
UBGW_ChapterViewMgrV2 = {}

---@param BeginStateName FName
---@param EndStateName FName
---@param IsForceImSet boolean
function UBGW_ChapterViewMgrV2:OnAKBStateEndFunc(BeginStateName, EndStateName, IsForceImSet) end
function UBGW_ChapterViewMgrV2:OnLeaveSeqFinished() end
function UBGW_ChapterViewMgrV2:OnEntranceSeqFinished() end


---@class UBGW_CharacterViewMgr : UGameInstanceSystemBaseUObj
UBGW_CharacterViewMgr = {}

---@param BeginStateName FName
---@param EndStateName FName
---@param IsForceImSet boolean
function UBGW_CharacterViewMgr:OnAKBStateEndFunc(BeginStateName, EndStateName, IsForceImSet) end


---@class UBGW_ComboDebugMgr : UGameInstanceSystemBaseUObj
UBGW_ComboDebugMgr = {}


---@class UBGW_CommLevelMgr : UGameInstanceSystemBaseUObj
UBGW_CommLevelMgr = {}

---@param BeginStateName FName
---@param EndStateName FName
---@param IsForceImSet boolean
function UBGW_CommLevelMgr:OnAKBStateEndFunc(BeginStateName, EndStateName, IsForceImSet) end


---@class UBGW_CricketBattleMgr : UGameInstanceSystemBaseUObj
UBGW_CricketBattleMgr = {}


---@class UBGW_CtrlHeroIdConf : UBGWDataAsset
---@field HeroBPArray TArray<FString>
---@field HeroCtrlRotaSpeed int32
---@field HeroCtrlSensitivity int32
---@field HeroCtrlDebounce float
---@field AnimDeadZoneRadius float
UBGW_CtrlHeroIdConf = {}



---@class UBGW_DebugMgr : UGameInstanceSystemBaseUObj
UBGW_DebugMgr = {}


---@class UBGW_DevCheckGameMgr : UGameInstanceSystemBaseUObj
UBGW_DevCheckGameMgr = {}


---@class UBGW_DevSecurityMgr : UGameInstanceSystemBaseUObj
UBGW_DevSecurityMgr = {}


---@class UBGW_DispInteractMgr : UGameInstanceSystemBaseUObj
---@field DispInteractOwner ABGUDispInteractActor
---@field Landscape ALandscape
---@field LS_HeightMap UTexture2D
---@field LS_WeightMap UTexture2D
---@field LandscapeOriginOffset FVector
---@field LS_MinX int32
---@field LS_MinY int32
---@field LS_MaxX int32
---@field LS_MaxY int32
---@field MaxHeight float
---@field SimulationSize_cm float
---@field InteractiveData_StorageSize_cm float
---@field InteractDistLimitToDispActor float
---@field NS_Landscape_Interactive UNiagaraSystem
---@field NS_Landscape_Simulator UNiagaraSystem
UBGW_DispInteractMgr = {}



---@class UBGW_DispLibCameraBlockDataAsset : UBGWDataAsset
---@field InRange float
---@field OutRange float
---@field TriggerAngle float
---@field HeightDelta float
---@field AlphaRate float
UBGW_DispLibCameraBlockDataAsset = {}



---@class UBGW_DispLibCameraEnvFXDataAsset : UBGWDataAsset
---@field UseCameraEnvFX boolean
---@field CameraZOffset float
---@field CameraOffset FVector
---@field CameraEnvFXConfig TArray<FBUC_DispLibDBC_CameraEnvFXInfo>
UBGW_DispLibCameraEnvFXDataAsset = {}



---@class UBGW_DispLibConstDataAsset : UBGWDataAsset
---@field MAX_UAF_REQUESTS_COUNT int32
---@field DBCCascadeDefaultMetaString FName
---@field DBCNiagaraDefaultMetaString FName
---@field DBCCustomAdvNiagaraDefaultMetaString FName
---@field DBCSourceBaseCarrierActorPath FString
---@field DBCUseUEFXPool boolean
---@field DBCPlanePPOffset float
---@field DBCGlobalCameraShakeProtectedTime float
---@field DBCTinyOffsetBeHitDefaultDistance float
---@field DBCAttachConstraintValue_FixedTime float
---@field DBCAttachConstraintValue_RootVelocity float
---@field DBCAttachConstraintValue_AttachedSocketVelocity float
---@field DBCAttachConstraintValue_AttachedSocketVelocityAndTorsion FVector2D
---@field DBCAttachConstraintValue_AttachedSocketDistanceACCAndTorsion FVector2D
---@field DLDWorld_BP TSubclassOf<ADispLibDispWorld>
---@field NPC_GameUtilityData UNiagaraParameterCollection
---@field MPC_GameUtilityData UMaterialParameterCollection
---@field MPC_GameUtilityData_SDF UMaterialParameterCollection
---@field UseWEFM boolean
---@field WEFMManager UNiagaraSystem
---@field WEFMNPC UNiagaraParameterCollection
---@field WEFMMPC UMaterialParameterCollection
---@field WEFMVisualDebugFX UNiagaraSystem
---@field WEFMLODSettingArray TArray<FWEFMLODSetting>
---@field WEFM_RT2D UTextureRenderTarget2D
---@field EnableWEFMLevel TArray<FName>
UBGW_DispLibConstDataAsset = {}



---@class UBGW_DispLibDBCEditorDebugConfigDataAsset : UBGWDataAsset
UBGW_DispLibDBCEditorDebugConfigDataAsset = {}


---@class UBGW_DispLibFNameCacheDataAsset : UBGWDataAsset
---@field GSUnitHeight FName
---@field GSCPUNoiseFloat FName
---@field UseGSArtFresnel FName
---@field InvertGSArtFresnel FName
---@field UseContrastInsteadPower FName
---@field BrightValue FName
---@field DarkValue FName
---@field GSArtFresnelPower FName
---@field ClampGSArtFresnelDotProduct FName
---@field UAFUseVertexNormalNotTex FName
---@field UseUAFHeightGradientRamp FName
---@field UAFTopAlpha FName
---@field UAFBottomAlpha FName
---@field FColor_Out FName
---@field FColor_In FName
---@field GSOverrideOpacity FName
---@field EfxStop FName
---@field EfxEmitterPos FName
---@field EfxTargetPos FName
---@field EfxV4Param FName
---@field EfxEmitterDeath FName
---@field EfxPlanePPSize FName
---@field EfxDuration FName
---@field EfxSelfSkeletalMesh FName
---@field EfxMinorSkeletalMesh FName
---@field EfxSelfStaticMesh FName
---@field EfxMinorStaticMesh FName
---@field WEFM_CurFrameWindEventCount FName
---@field WEFM_WindDataV4 FName
---@field WEFM_WindDistanceDampingRate FName
---@field WEFM_WindType FName
---@field WEFM_WindIntensity FName
---@field WEFM_WindSizeV3 FName
---@field WEFM_WindDirWS FName
---@field WEFM_WindCenterPosWS FName
---@field WEFM_CurFrameHeatEventCount FName
---@field WEFM_HeatDataV4 FName
---@field WEFM_HeatDistanceDampingRate FName
---@field WEFM_HeatIntensity FName
---@field WEFM_HeatSizeV3 FName
---@field WEFM_HeatCenterPosWS FName
UBGW_DispLibFNameCacheDataAsset = {}



---@class UBGW_DispLibGameDBDataAsset : UBGWDataAsset
---@field DispConstDA UBGW_DispLibConstDataAsset
---@field CameraEnvFXDA UBGW_DispLibCameraEnvFXDataAsset
---@field FNameCacheDA UBGW_DispLibFNameCacheDataAsset
---@field UniversalArtFresnelCacheDA UBGW_DispLibUniversalArtFresnelCacheDataAsset
UBGW_DispLibGameDBDataAsset = {}



---@class UBGW_DispLibUniversalArtFresnelCacheDataAsset : UBGWDataAsset
---@field UnitArtFresnelUniversalData TArray<UBUC_DispLibUnitArtFresnelDataAsset>
UBGW_DispLibUniversalArtFresnelCacheDataAsset = {}



---@class UBGW_DynamicSDFMgr : UGameInstanceSystemBaseUObj
---@field DSDFClass TSubclassOf<ABGUDynamicSDFGenerator>
---@field DSDFV2Class TSubclassOf<ABGUDynamicSDFGenerator2>
UBGW_DynamicSDFMgr = {}



---@class UBGW_EnhancedInputMgrV2 : UGameInstanceSystemBaseUObj
---@field InputMappingContextConfig UBGWDataAsset_InputMappingContextConfigV2
---@field CustomizedInputSetting UBGWDataAsset_CustomizedInputSetting
---@field Receiver UInputActionEventReceiver
UBGW_EnhancedInputMgrV2 = {}



---@class UBGW_EventCollection : UGameInstanceSystemBaseUObj
UBGW_EventCollection = {}


---@class UBGW_ExceptionUIMgr : UGameInstanceSystemBaseUObj
UBGW_ExceptionUIMgr = {}

---@param WorldCtx UObject
---@return UBGW_ExceptionUIMgr
function UBGW_ExceptionUIMgr:Get(WorldCtx) end
function UBGW_ExceptionUIMgr:OnCloseExceptionUI() end


---@class UBGW_FSMInstanceMgr : UGameInstanceSystemBaseUObj
UBGW_FSMInstanceMgr = {}


---@class UBGW_GCMgr : UGameInstanceSystemBaseUObj
UBGW_GCMgr = {}


---@class UBGW_GSSdkMgr : UGameInstanceSystemBaseUObj
UBGW_GSSdkMgr = {}


---@class UBGW_GSUploadFilesMgr : UGameInstanceSystemBaseUObj
UBGW_GSUploadFilesMgr = {}


---@class UBGW_GameArchiveMgr : UGameInstanceSystemBaseUObj
UBGW_GameArchiveMgr = {}


---@class UBGW_GameDataMgr : UGameInstanceSystemBaseUObj
---@field UObjectDataOwner TArray<UObject>
UBGW_GameDataMgr = {}



---@class UBGW_GameInstance_B1 : UBGWGameInstanceCS
UBGW_GameInstance_B1 = {}

function UBGW_GameInstance_B1:ReceiveInit() end
function UBGW_GameInstance_B1:ProcessNianHuiLogic() end


---@class UBGW_GameLifeTimeMgr : UGameInstanceSystemBaseUObj
UBGW_GameLifeTimeMgr = {}


---@class UBGW_ILRuntimeCLRBinding : UObject
UBGW_ILRuntimeCLRBinding = {}

---@param bClrbinding int32
function UBGW_ILRuntimeCLRBinding:GenerateClrBindingCode_AutoTest(bClrbinding) end


---@class UBGW_ILRuntimeCrossBinding : UObject
UBGW_ILRuntimeCrossBinding = {}

function UBGW_ILRuntimeCrossBinding:GenerateCrossBindingCode_AutoTest() end


---@class UBGW_ILRuntimeMgr : UBGW_ScriptMgr
UBGW_ILRuntimeMgr = {}


---@class UBGW_LandLayerInfoMgr : UGameInstanceSystemBaseUObj
---@field LayerSceneInfoActor ALayerSceneInfo
UBGW_LandLayerInfoMgr = {}



---@class UBGW_LevelStreamingManger : UGameInstanceSystemBaseUObj
UBGW_LevelStreamingManger = {}

---@param ActionID int32
---@param Linkage int32
function UBGW_LevelStreamingManger:OnLoadLevelStreamingFinish(ActionID, Linkage) end
---@param ActionID int32
---@param Linkage int32
function UBGW_LevelStreamingManger:OnUnloadLevelStreamingFinish(ActionID, Linkage) end


---@class UBGW_LevelStreamingStateMgr : UGameInstanceSystemBaseUObj
UBGW_LevelStreamingStateMgr = {}


---@class UBGW_LoadingTipsMgr : UGameInstanceSystemBaseUObj
UBGW_LoadingTipsMgr = {}


---@class UBGW_ManagedReflectMgr : UBGW_ScriptMgr
UBGW_ManagedReflectMgr = {}


---@class UBGW_MemoryMgr : UGameInstanceSystemBaseUObj
UBGW_MemoryMgr = {}


---@class UBGW_MovieManager : UGameInstanceSystemBaseUObj
UBGW_MovieManager = {}


---@class UBGW_MultiKillConf : UBGWDataAsset
---@field MultiKillTime float
---@field UnparalleledValueBase int32
---@field UnparalleledRateMax int32
---@field UnparalleledRateBase float
---@field UnparalleledValueMax int32
---@field UnparalleledValueSpeed float
---@field UnparalleledRange float
---@field RebirthStayTime float
---@field RebirthCount int32
---@field UnparalleledRotaX float
---@field UnparalleledRotaY float
---@field UnparalleledSelectBack boolean
---@field MICBOnceChangeValue float
---@field MIFBOnceChangeValue float
---@field UnparalleledFreedomTime float
UBGW_MultiKillConf = {}



---@class UBGW_OnlineAchievement : UBGWOnlineAchievement
UBGW_OnlineAchievement = {}

---@param bWasSuccessful boolean
function UBGW_OnlineAchievement:OnStatUpdatedCompleteCS(bWasSuccessful) end
---@param bWasSuccessful boolean
function UBGW_OnlineAchievement:OnQueryAchievementsCompleteCS(bWasSuccessful) end
---@param bWasSuccessful boolean
function UBGW_OnlineAchievement:OnAchievementsWrittenCompleteCS(bWasSuccessful) end


---@class UBGW_OnlineActivity : UBGWOnlineActivity
UBGW_OnlineActivity = {}

---@param bWasSuccessful boolean
function UBGW_OnlineActivity:OnEndActivityCompleteCS(bWasSuccessful) end
---@param bWasSuccessful boolean
function UBGW_OnlineActivity:OnStartActivityCompleteCS(bWasSuccessful) end
---@param bWasSuccessful boolean
function UBGW_OnlineActivity:OnResumeActivityCompleteCS(bWasSuccessful) end
---@param bWasSuccessful boolean
function UBGW_OnlineActivity:OnSetActivityPriorityCompleteCS(bWasSuccessful) end
---@param sActivityId FString
---@param sSessionStr FString
function UBGW_OnlineActivity:OnGameActivityActivationCompleteCS(sActivityId, sSessionStr) end
---@param bWasSuccessful boolean
function UBGW_OnlineActivity:OnSetActivityAvailabilityCompleteCS(bWasSuccessful) end
---@param bWasSuccessful boolean
function UBGW_OnlineActivity:OnResetAllActiveActivitiesCompleteCS(bWasSuccessful) end


---@class UBGW_OnlineCloud : UBGWOnlineCloud
UBGW_OnlineCloud = {}

---@param Filename FString
---@param bWasSuccessful boolean
function UBGW_OnlineCloud:OnReadUserFilesCompleteCS(Filename, bWasSuccessful) end
---@param Filename FString
---@param bWasSuccessful boolean
function UBGW_OnlineCloud:OnDeleteUserFilesCompleteCS(Filename, bWasSuccessful) end
---@param bWasSuccessful boolean
function UBGW_OnlineCloud:OnEnumerateUserFilesCompleteCS(bWasSuccessful) end
---@param Filename FString
---@param bWasSuccessful boolean
function UBGW_OnlineCloud:OnWriteUserCloudFileCompleteCS(Filename, bWasSuccessful) end


---@class UBGW_OnlineFriend : UBGWOnlineFriend
UBGW_OnlineFriend = {}

---@param bWasSuccessful boolean
function UBGW_OnlineFriend:OnReadFriendListCompleteCS(bWasSuccessful) end


---@class UBGW_OnlineIdentity : UBGWOnlineIdentity
UBGW_OnlineIdentity = {}

---@param bSuccessful boolean
function UBGW_OnlineIdentity:OnLoginCompletedCS(bSuccessful) end
---@param RecvActionsJsonStr FString
function UBGW_OnlineIdentity:OnRecvAntiAddictionActionCS(RecvActionsJsonStr) end
---@param Privilege EBGWUserPrivileges
---@param PrivilegeResult EBGWPrivilegeResult
function UBGW_OnlineIdentity:OnGetUserPrivilegeCompleteCS(Privilege, PrivilegeResult) end


---@class UBGW_OnlinePresence : UBGWOnlinePresence
UBGW_OnlinePresence = {}

---@param bWasSuccessful boolean
function UBGW_OnlinePresence:OnSetPresenceCompleteCS(bWasSuccessful) end


---@class UBGW_OnlineSession : UBGWOnlineSession
UBGW_OnlineSession = {}

---@param Result EBGWJoinSessionResult
function UBGW_OnlineSession:OnJoinSessionCompleteCS(Result) end
---@param Success boolean
function UBGW_OnlineSession:OnCreateSessionCompleteCS(Success) end
function UBGW_OnlineSession:OnSessionInviteReceivedCS() end
---@param Success boolean
function UBGW_OnlineSession:OnSearchSessionsCompleteCS(Success) end
---@param SessionType EBGWOnlineSessionType
---@param Success boolean
function UBGW_OnlineSession:OnDestroySessionCompleteCS(SessionType, Success) end
---@param Success boolean
function UBGW_OnlineSession:OnFindSessionByIdCompleteCS(Success) end
---@param bWasSuccess boolean
function UBGW_OnlineSession:OnSessionUserInviteAcceptedCS(bWasSuccess) end


---@class UBGW_OnlineSubsystem : UBGWOnlineSubsystem
UBGW_OnlineSubsystem = {}

---@param bPurchased boolean
function UBGW_OnlineSubsystem:OnShowStoreUIClosedCS(bPurchased) end
---@param EntitlementId FString
---@param bWasSuccessful boolean
function UBGW_OnlineSubsystem:OnQueryIsOwnAdditionContentCompleteCS(EntitlementId, bWasSuccessful) end


---@class UBGW_PSOAdaptorMgr : UGameInstanceSystemBaseUObj
UBGW_PSOAdaptorMgr = {}


---@class UBGW_PaintWorldMgr : UGameInstanceSystemBaseUObj
UBGW_PaintWorldMgr = {}


---@class UBGW_PauseGameMgr : UGameInstanceSystemBaseUObj
UBGW_PauseGameMgr = {}


---@class UBGW_PipelineStateMgr : UGameInstanceSystemBaseUObj
UBGW_PipelineStateMgr = {}


---@class UBGW_PlatformEventExecMgr : UGameInstanceSystemBaseUObj
UBGW_PlatformEventExecMgr = {}


---@class UBGW_PlatformEventMgr : UBGWPlatformEventMgr
UBGW_PlatformEventMgr = {}

function UBGW_PlatformEventMgr:OnApplicationInitCS() end
function UBGW_PlatformEventMgr:OnApplicationExitCS() end
---@param bIsSignIn boolean
---@param PlatformUserId int32
---@param UserIndex int32
function UBGW_PlatformEventMgr:OnUserLoginChangeCS(bIsSignIn, PlatformUserId, UserIndex) end
function UBGW_PlatformEventMgr:OnApplicationResumeCS() end
function UBGW_PlatformEventMgr:OnApplicationPreExitCS() end
function UBGW_PlatformEventMgr:OnApplicationSuspendCS() end
function UBGW_PlatformEventMgr:OnApplicationTerminateCS() end
function UBGW_PlatformEventMgr:OnApplicationDeactivateCS() end
function UBGW_PlatformEventMgr:OnApplicationReactivatedCS() end
---@param bIsNetworkInitialized boolean
function UBGW_PlatformEventMgr:OnNetworkInitializedChangeCS(bIsNetworkInitialized) end


---@class UBGW_PlayGoMgr : UGameInstanceSystemBaseUObj
UBGW_PlayGoMgr = {}


---@class UBGW_PlayerInput_U3 : UObject
UBGW_PlayerInput_U3 = {}


---@class UBGW_PreloadAssetMgr : UGameInstanceSystemBaseUObj
---@field BattleSCConfigDataAsset UBGWDataAsset_BattleSCConfig
---@field HatredConfigDataAsset UBGWHatredConfigDataAsset
---@field UIConfigDataAsset UBGWUIConfigDataAsset
---@field MapConfigDataAsset UBGWMapUIConfigDataAsset
---@field FallDyingConfigDataAsset UBGWFallDyingConfigDataAsset
---@field Demo820ConfigDataAsset UBGWDemo820ConfigDataAsset
---@field CricketBattleDataAsset UBGWCricketBattleDataAsset
---@field EquipPreviewConfigDataAsset UBGWEquipPreviewConfigDataAsset
---@field TransPreviewConfigDataAsset UBGWTransPreviewConfigDataAsset
---@field BHLItemTmpDataAsset UBGWBHLItemTmpDataAsset
---@field MPCStickProg UMaterialParameterCollection
---@field MonsterManualConfigDataAsset UBGWMonsterManualConfigDataAsset
---@field ObservationModeConfig UBGWDataAsset_ObservationModeConfig
---@field ABSPosToUVConfig UBGWDataAsset_ABSPosToUVConfig
---@field DamageNumConfig UBGWDataAsset_DamageNumConfig
---@field GameConfig UBGWDataAsset_GameConfig
---@field LevelSequenceConfig UBGWDataAsset_LevelSequenceConfig
---@field AISkillScoreConfigDataAsset UBGWAISkillScoreConfigDataAsset
---@field AIHatredConfigDataAsset UBGWDataAsset_AIHatredConfig
---@field CoinDropFXNumConfig UBGWDataAsset_CoinDropFXNumConfig
---@field DA_B1_DispLibGameDB UBGW_DispLibGameDBDataAsset
---@field DefaultLocalFluid2DConfig UBGWDataAsset_LocalFluid2DConfig
---@field DestructibleImpulseConfig UBGWDataAsset_DestructibleImpulseConfig
---@field UnitDynamicObstacle_DefaultDBC UBGWDataAsset_B1DBC
---@field BattleFieldPerformanceOptConfig UBGWDataAsset_BattleFieldPerformanceOptConfig
---@field MatLayerFunctionMappingConfigMap TMap<int32, UBGWDataAsset_MatLayerFunctionMappingConfig>
---@field EnvironmentMaskGlobalConfig UBGWDataAsset_EnvironmentMaskGlobalConfig
---@field AnimationSyncStateMonster2WukongConfig UBGWDataAsset_AnimationSyncStateConfig
---@field AnimationSyncStateMonster2MonsterConfig UBGWDataAsset_AnimationSyncStateConfig
---@field FrozenAccMatCurve UCurveFloat
---@field BulletSmartSelectTargetConfig UBGWDataAsset_BulletSmartSelectTargetConfig
---@field _CloudMoveConfig UBGWDataAsset_CloudMoveConfig
---@field LevelInfo UBGWDataAsset_LevelInfo
---@field HitAudioPreloadListConfig UBGWDataAsset_HitAudioPreloadList
---@field TROConfig_Small UBGWDataAsset_TROConfig
---@field TROConfig_Medium UBGWDataAsset_TROConfig
---@field TROConfig_MediumBig UBGWDataAsset_TROConfig
---@field TROConfig_Big UBGWDataAsset_TROConfig
---@field TROConfig_Huge UBGWDataAsset_TROConfig
---@field AssetHolderMap TMap<int32, UAsyncLoadAssetHolder>
UBGW_PreloadAssetMgr = {}



---@class UBGW_ReplaySystemMgr : UGameInstanceSystemBaseUObj
UBGW_ReplaySystemMgr = {}


---@class UBGW_ScriptMgr : UGameInstanceSystemBaseUObj
UBGW_ScriptMgr = {}


---@class UBGW_SettingMgrV2 : UGameInstanceSystemBaseUObj
UBGW_SettingMgrV2 = {}


---@class UBGW_StaminaConfig : UBGWDataAsset
---@field StaminaMI UMaterialInstance
---@field StaminaMPC UMaterialParameterCollection
---@field StaminaParamList TArray<FStaminaTextureInfo>
---@field StaminaRecoverCurve1 UCurveFloat
---@field StaminaRecoverCurveLength1 float
---@field StaminaRecoverCurve2 UCurveFloat
---@field StaminaRecoverCurveLength2 float
---@field StaminaCostCurve UCurveFloat
---@field StaminaCostCurveLength float
---@field StaminaWarnCurve UCurveFloat
---@field StaminaWarnCurveLength float
UBGW_StaminaConfig = {}



---@class UBGW_TakePhotoSystemMgr : UGameInstanceSystemBaseUObj
---@field TakePhotoSystemConfig UBGWDataAsset_TakePhotoSystemConfig
UBGW_TakePhotoSystemMgr = {}



---@class UBGW_TerrainEffectConfig : UBGWDataAsset
---@field TerrainList TMap<SceneItemSurfaceType, FTerrainEffectInfo>
UBGW_TerrainEffectConfig = {}



---@class UBGW_UIEventCollection : UGameInstanceSystemBaseUObj
---@field Evt_RootPanelAddUI FBGW_UIEventCollectionEvt_RootPanelAddUI
---@field Evt_RootPanelAddUIWithLayer FBGW_UIEventCollectionEvt_RootPanelAddUIWithLayer
---@field Evt_RootPanelRemoveUI FBGW_UIEventCollectionEvt_RootPanelRemoveUI
UBGW_UIEventCollection = {}



---@class UBGW_UIMgr : UGameInstanceSystemBaseUObj
UBGW_UIMgr = {}


---@class UBGW_ValiDateMgr : UGameInstanceSystemBaseUObj
UBGW_ValiDateMgr = {}


---@class UBGW_WXLoginMgr : UGameInstanceSystemBaseUObj
UBGW_WXLoginMgr = {}


---@class UBIS_AssociationUniMgr : UGameInstanceSystemBaseUObj
UBIS_AssociationUniMgr = {}


---@class UBIS_LevelManager : UGameInstanceSystemBaseUObj
UBIS_LevelManager = {}


---@class UBIS_TaskManager : UGameInstanceSystemBaseUObj
UBIS_TaskManager = {}


---@class UBI_AbnormalStateAccBarCS : UBUI_Widget
---@field AbnormalStateType AbnormalStateType
UBI_AbnormalStateAccBarCS = {}



---@class UBI_AbnormalStateAccBoxCS : UBUI_Widget
---@field MoveUp_Duration float
---@field MoveUp_FuncType EEasingFunc::Type
---@field MoveDown_Duration float
---@field MoveDown_FuncType EEasingFunc::Type
---@field Hidden_Duration float
UBI_AbnormalStateAccBoxCS = {}



---@class UBI_AbnormalStateItemCS : UBUI_Widget
---@field WarningRemaining float
UBI_AbnormalStateItemCS = {}



---@class UBI_DebugTextInGrid : UBUI_Widget
UBI_DebugTextInGrid = {}


---@class UBI_DropAdvanceCS : UBUI_Widget
UBI_DropAdvanceCS = {}


---@class UBI_DropExpProgCS : UBUI_Widget
UBI_DropExpProgCS = {}


---@class UBI_DropExpProgV2CS : UBUI_Widget
UBI_DropExpProgV2CS = {}


---@class UBI_DropItemCS : UBUI_Widget
UBI_DropItemCS = {}


---@class UBI_DropManualCS : UBI_DropAdvanceCS
UBI_DropManualCS = {}


---@class UBI_DropMiddleItemCS : UBI_DropAdvanceCS
UBI_DropMiddleItemCS = {}


---@class UBI_DropMuseumCS : UBUI_Widget
UBI_DropMuseumCS = {}


---@class UBI_DropSpecialTipsCS : UBUI_Widget
UBI_DropSpecialTipsCS = {}


---@class UBI_DropSpiritCS : UBUI_Widget
UBI_DropSpiritCS = {}


---@class UBI_GourdCS : UBUI_Widget
UBI_GourdCS = {}


---@class UBI_GourdSlotCS : UBUI_Widget
UBI_GourdSlotCS = {}


---@class UBI_HpProgBarCS : UBI_ProgBarCS
---@field UseAbnormalFx boolean
---@field ZeroHide boolean
---@field NeedBgPercent boolean
UBI_HpProgBarCS = {}



---@class UBI_LockEnemyCS : UBUI_ProjWidget
UBI_LockEnemyCS = {}


---@class UBI_NavigationCS : UBUI_Widget
---@field IsShowRange boolean
---@field IsShowNavWidget boolean
---@field IsShowNotNavWidget boolean
---@field TargetWidget UWidget
---@field MaxAngle float
---@field MaxDistance float
---@field LimitSpecilNode boolean
UBI_NavigationCS = {}



---@class UBI_PlayerBarCS : UBUI_Widget
UBI_PlayerBarCS = {}


---@class UBI_PlayerStateBoxCS : UBUI_Widget
UBI_PlayerStateBoxCS = {}


---@class UBI_PlayerStateItemCS : UBUI_Widget
---@field WarningRemaining float
UBI_PlayerStateItemCS = {}



---@class UBI_ProgBarCS : UBUI_Widget
UBI_ProgBarCS = {}


---@class UBI_RideMountCS : UBUI_StateWidget
UBI_RideMountCS = {}


---@class UBI_ShortcutBaseCS : UBUI_StateWidget
---@field ShowInputType EGSInputType
---@field ShortcutType EnShortcutType
---@field CurPosIdx int32
UBI_ShortcutBaseCS = {}



---@class UBI_ShortcutCommCS : UBUI_Widget
UBI_ShortcutCommCS = {}


---@class UBI_ShortcutDescCS : UBUI_Widget
---@field InputAction UInputAction
---@field InputIconTexture UTexture2D
UBI_ShortcutDescCS = {}



---@class UBI_ShortcutItemBaseCS : UBUI_Widget
---@field CurPosIdx int32
UBI_ShortcutItemBaseCS = {}



---@class UBI_ShortcutItemCS : UBI_ShortcutCommCS
UBI_ShortcutItemCS = {}


---@class UBI_ShortcutNumCS : UBUI_StateWidget
---@field ShowInputType EGSInputType
---@field CurPosIdx int32
UBI_ShortcutNumCS = {}



---@class UBI_ShortcutSpellCS : UBI_ShortcutCommCS
---@field IsInTrans boolean
UBI_ShortcutSpellCS = {}



---@class UBI_SimAbnormalStateAccBoxCS : UBUI_Widget
UBI_SimAbnormalStateAccBoxCS = {}


---@class UBI_SoulSkillCS : UBUI_StateWidget
UBI_SoulSkillCS = {}


---@class UBI_StickLevelCS : UBUI_Widget
---@field ShowType StickLevelShowType
UBI_StickLevelCS = {}



---@class UBI_StickLevelDotCS : UBUI_Widget
---@field BindPelevel int32
UBI_StickLevelDotCS = {}



---@class UBI_StickLevelProgCS : UBUI_Widget
UBI_StickLevelProgCS = {}


---@class UBI_TalentLineCS : UBUI_Widget
---@field ParentID int32
---@field ChildID int32
UBI_TalentLineCS = {}



---@class UBI_TransCS : UBUI_Widget
UBI_TransCS = {}


---@class UBI_TransProgCS : UBUI_Widget
---@field IsProgLevel boolean
UBI_TransProgCS = {}



---@class UBI_TransShortcutSpellCS : UBI_ShortcutCommCS
UBI_TransShortcutSpellCS = {}


---@class UBI_TransStyle14CS : UBI_TransStyleCS
UBI_TransStyle14CS = {}


---@class UBI_TransStyle16CS : UBI_TransStyleCS
UBI_TransStyle16CS = {}


---@class UBI_TransStyle17CS : UBI_TransStyleCS
UBI_TransStyle17CS = {}


---@class UBI_TransStyle19CS : UBI_TransStyleStickCS
UBI_TransStyle19CS = {}


---@class UBI_TransStyle23CS : UBI_TransStyleCS
UBI_TransStyle23CS = {}


---@class UBI_TransStyle25CS : UBI_TransStyleStickCS
UBI_TransStyle25CS = {}


---@class UBI_TransStyleCS : UBUI_Widget
---@field ResID int32
UBI_TransStyleCS = {}



---@class UBI_TransStyleStickCS : UBI_TransStyleCS
UBI_TransStyleStickCS = {}


---@class UBI_TreasureCS : UBUI_StateWidget
UBI_TreasureCS = {}


---@class UBI_UnitBarCS : UBI_HpProgBarCS
UBI_UnitBarCS = {}


---@class UBI_UnitBarListCS : UBUI_Widget
UBI_UnitBarListCS = {}


---@class UBMPS_Base : UCalliopeMoviePipelineSetting
UBMPS_Base = {}

---@return FString
function UBMPS_Base:GetFooterTextCS() end
---@return FString
function UBMPS_Base:GetCategoryTextCS() end


---@class UBMPS_CLS : UBMPS_Base
---@field bOverrideBlendInSpeed boolean
---@field BlendInSpeed float
UBMPS_CLS = {}

---@return FString
function UBMPS_CLS:GetDisplayTextCS() end
---@param InPipeline UMoviePipeline
function UBMPS_CLS:SetupForPipelineCS(InPipeline) end
---@param InPipeline UMoviePipeline
function UBMPS_CLS:TeardownForPipelineCS(InPipeline) end
---@return boolean
function UBMPS_CLS:IgnoreTransientFiltersCS() end


---@class UBMPS_Equip : UBMPS_Base
---@field MeshConfig FEquipMeshConfig
---@field AbpConfig FEquipAbpConfig
UBMPS_Equip = {}

---@return FString
function UBMPS_Equip:GetDisplayTextCS() end
---@param InPipeline UMoviePipeline
function UBMPS_Equip:SetupForPipelineCS(InPipeline) end


---@class UBMPS_LevelStreaming : UBMPS_Base
---@field GeometryLevelsLoadSetting TMap<FString, LevelLoadState>
---@field SeqLevelsLoadSetting TMap<FString, LevelLoadState>
---@field ItemLevelsLoadSetting TMap<FString, LevelLoadState>
---@field OtherLevelsLoadSetting TMap<FString, LevelLoadState>
---@field MonsterLevelsLoadSetting TMap<FString, LevelLoadState>
UBMPS_LevelStreaming = {}

function UBMPS_LevelStreaming:RefreshCurrentLevelNames() end
---@return FString
function UBMPS_LevelStreaming:GetDisplayTextCS() end
---@param InPipeline UMoviePipeline
function UBMPS_LevelStreaming:SetupForPipelineCS(InPipeline) end
---@param InPipeline UMoviePipeline
function UBMPS_LevelStreaming:TeardownForPipelineCS(InPipeline) end


---@class UBMPS_PerformerConfig : UBMPS_Base
---@field PerformerTagMapping UBUC_PerformerMappingConfigDataAsset
UBMPS_PerformerConfig = {}

---@return FString
function UBMPS_PerformerConfig:GetDisplayTextCS() end
---@param InPipeline UMoviePipeline
function UBMPS_PerformerConfig:AfterLevelSequenceActorInitializedCS(InPipeline) end


---@class UBPS_EventCollectionCS : UBUS_EventCollection
UBPS_EventCollectionCS = {}


---@class UBPS_GSEventCollection : UGSEventCollectionBase
UBPS_GSEventCollection = {}

---@param InSummonReq FSummonReq
function UBPS_GSEventCollection:Evt_RequestSummon_Invoke(InSummonReq) end
---@param EndPlayReason EEndPlayReason::Type
function UBPS_GSEventCollection:EndPlayInCS(EndPlayReason) end
function UBPS_GSEventCollection:BeginPlayInCS() end
---@param RoleData TArray<uint8>
function UBPS_GSEventCollection:Evt_BPS_SyncRoleDataTmp_Invoke(RoleData) end
---@param p1 int32
function UBPS_GSEventCollection:Evt_TmpTransSendDropItem_Invoke(p1) end
---@param Guids TArray<FString>
function UBPS_GSEventCollection:Evt_BPS_ServerActivateTamer_Invoke(Guids) end
---@param InServantReq FServantReq
function UBPS_GSEventCollection:Evt_SendServantReq_Multicast_Invoke(InServantReq) end
---@param CloseResult EGSNetCloseResult
function UBPS_GSEventCollection:Evt_CloseConnectionWithResult_Invoke(CloseResult) end
---@param TamerClass FDynamicTamerSpawnReq
function UBPS_GSEventCollection:Evt_BPS_ServerSpawnDynamicTamer_Invoke(TamerClass) end
---@param p1 int32
function UBPS_GSEventCollection:Evt_BPS_TestPlayerState_Multicast_Invoke(p1) end
---@param Guids TArray<FTamerRoleSync>
function UBPS_GSEventCollection:Evt_BPS_ClientInitCharacterNetRole_Invoke(Guids) end
---@param OldActor AActor
---@param NewActorResId int32
function UBPS_GSEventCollection:Evt_BPS_SwitchPlayerTransState_Multicast_Invoke(OldActor, NewActorResId) end
---@param Guids TArray<FString>
function UBPS_GSEventCollection:Evt_BPS_ServerNotifyClientTamerBackToLoad_Invoke(Guids) end
---@param Guids TArray<FString>
function UBPS_GSEventCollection:Evt_BPS_ServerNotifyClientAuthorityTamerDead_Invoke(Guids) end


---@class UBPS_PlayerControllerDataCompB1 : UBUS_ActorBaseDataComp
UBPS_PlayerControllerDataCompB1 = {}


---@class UBPS_PlayerStateDataCompB1 : UBUS_ActorBaseDataComp
UBPS_PlayerStateDataCompB1 = {}

function UBPS_PlayerStateDataCompB1:PreECSBeginPlay() end
function UBPS_PlayerStateDataCompB1:LateECSBeginPlay() end


---@class UBPS_ReplayPlayerControllerDataComp : UBUS_ActorBaseDataComp
UBPS_ReplayPlayerControllerDataComp = {}


---@class UBSNS_CricketWinFinish : UMovieSceneCalliopeNotifyStateSection
UBSNS_CricketWinFinish = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_CricketWinFinish:OnNotifyEnd(InPlayer, InStatus, bInBackwards) end
---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_CricketWinFinish:OnNotifyBegin(InPlayer, InStatus, bInBackwards) end


---@class UBSNS_DisablePhysicalMove : UMovieSceneCalliopeNotifyStateSection
---@field UnitGuid FGameplayTag
UBSNS_DisablePhysicalMove = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_DisablePhysicalMove:OnNotifyEnd(InPlayer, InStatus, bInBackwards) end
---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_DisablePhysicalMove:OnNotifyBegin(InPlayer, InStatus, bInBackwards) end


---@class UBSNS_EnableUnitIK : UMovieSceneCalliopeNotifyStateSection
---@field bTakePlayerAsUnit boolean
---@field UnitGuid FGameplayTag
---@field bEnableIK boolean
---@field bEnableForefootIK boolean
---@field bEnableSpineIK boolean
UBSNS_EnableUnitIK = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_EnableUnitIK:OnNotifyEnd(InPlayer, InStatus, bInBackwards) end
---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_EnableUnitIK:OnNotifyBegin(InPlayer, InStatus, bInBackwards) end
---@param InPlaybackContext UObject
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_EnableUnitIK:OnPreviewNotifyEnd(InPlaybackContext, InStatus, bInBackwards) end
---@param InPlaybackContext UObject
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_EnableUnitIK:OnPreviewNotifyBegin(InPlaybackContext, InStatus, bInBackwards) end


---@class UBSNS_GSDispInteract : UMovieSceneCalliopeNotifyStateSection
---@field UnitGuid FGameplayTag
---@field ExtraInteractBones TArray<FBoneUseForDispMap>
---@field OverrideInfo TArray<FDispInteractOverride>
UBSNS_GSDispInteract = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_GSDispInteract:OnNotifyEnd(InPlayer, InStatus, bInBackwards) end
---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_GSDispInteract:OnNotifyBegin(InPlayer, InStatus, bInBackwards) end


---@class UBSNS_MarkCannotBeSkip : UMovieSceneCalliopeNotifyStateSection
UBSNS_MarkCannotBeSkip = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_MarkCannotBeSkip:OnNotifyEnd(InPlayer, InStatus, bInBackwards) end
---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_MarkCannotBeSkip:OnNotifyBegin(InPlayer, InStatus, bInBackwards) end


---@class UBSNS_PauseAI : UMovieSceneCalliopeNotifyStateSection
---@field UnitGuid FGameplayTag
UBSNS_PauseAI = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_PauseAI:OnNotifyEnd(InPlayer, InStatus, bInBackwards) end
---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_PauseAI:OnNotifyBegin(InPlayer, InStatus, bInBackwards) end


---@class UBSNS_SetSDFSolverCenter : UMovieSceneCalliopeNotifyStateSection
---@field UnitGuid FGameplayTag
UBSNS_SetSDFSolverCenter = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_SetSDFSolverCenter:OnNotifyEnd(InPlayer, InStatus, bInBackwards) end
---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_SetSDFSolverCenter:OnNotifyBegin(InPlayer, InStatus, bInBackwards) end


---@class UBSNS_ShowSpecialUI : UMovieSceneCalliopeNotifyStateSection
---@field UIPageID EUIPageID
---@field DialogueID int32
---@field NameID int32
---@field ChapterID int32
---@field MediaId int32
UBSNS_ShowSpecialUI = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_ShowSpecialUI:OnNotifyBegin(InPlayer, InStatus, bInBackwards) end
---@return FString
function UBSNS_ShowSpecialUI:GetDisplayName() end


---@class UBSNS_ShowSpecialUIV2 : UMovieSceneCalliopeNotifyStateSection
---@field UIPageID EUIPageType
---@field DialogueID int32
---@field NameID int32
---@field MediaId int32
---@field OpenEndingCredits EndingCreditsAction
UBSNS_ShowSpecialUIV2 = {}

---@param Player UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_ShowSpecialUIV2:OnNotifyEnd(Player, InStatus, bInBackwards) end
---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_ShowSpecialUIV2:OnNotifyBegin(InPlayer, InStatus, bInBackwards) end
---@return FString
function UBSNS_ShowSpecialUIV2:GetDisplayName() end


---@class UBSNS_StopAllAnimMontage : UMovieSceneCalliopeNotifyStateSection
---@field bTakePlayerAsUnit boolean
---@field UnitGuid FGameplayTag
UBSNS_StopAllAnimMontage = {}

---@param Player UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSNS_StopAllAnimMontage:OnNotifyBegin(Player, InStatus, bInBackwards) end


---@class UBSN_AddBuffOnUnit : UMovieSceneCalliopeNotifySection
---@field bTakePlayerAsUnit boolean
---@field UnitGuid FGameplayTag
---@field BuffID int32
---@field BuffLayer int32
---@field BuffDuration int32
UBSN_AddBuffOnUnit = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_AddBuffOnUnit:OnNotify(InPlayer, InStatus, bInBackwards) end
---@param InPlaybackContext UObject
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_AddBuffOnUnit:OnPreviewNotify(InPlaybackContext, InStatus, bInBackwards) end


---@class UBSN_ChangeBT : UMovieSceneCalliopeNotifySection
---@field UnitGuid FGameplayTag
---@field BehaviorTree UBehaviorTree
UBSN_ChangeBT = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_ChangeBT:OnNotify(InPlayer, InStatus, bInBackwards) end


---@class UBSN_DetachCameraInSkillSequence : UMovieSceneCalliopeNotifySection
UBSN_DetachCameraInSkillSequence = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_DetachCameraInSkillSequence:OnNotify(InPlayer, InStatus, bInBackwards) end


---@class UBSN_ForceTrigger : UMovieSceneCalliopeNotifySection
---@field TriggerActorGuid FGameplayTag
UBSN_ForceTrigger = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_ForceTrigger:OnNotify(InPlayer, InStatus, bInBackwards) end


---@class UBSN_GainItem : UMovieSceneCalliopeNotifySection
---@field ItemId int32
UBSN_GainItem = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_GainItem:OnNotify(InPlayer, InStatus, bInBackwards) end


---@class UBSN_HideUI : UMovieSceneCalliopeNotifySection
---@field UIPageList TArray<EUIPageID>
UBSN_HideUI = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_HideUI:OnNotify(InPlayer, InStatus, bInBackwards) end


---@class UBSN_Log : UMovieSceneCalliopeNotifySection
---@field Message FString
---@field bPrintToScreen boolean
---@field Duration float
---@field TextColor FLinearColor
UBSN_Log = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_Log:OnNotify(InPlayer, InStatus, bInBackwards) end


---@class UBSN_MediaCache : UMovieSceneCalliopeNotifySection
---@field MediaId int32
UBSN_MediaCache = {}

---@param Player UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_MediaCache:OnNotify(Player, InStatus, bInBackwards) end
---@return FString
function UBSN_MediaCache:GetDisplayName() end


---@class UBSN_MediaPlay : UMovieSceneCalliopeNotifySection
UBSN_MediaPlay = {}

---@param Player UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_MediaPlay:OnNotify(Player, InStatus, bInBackwards) end
---@return FString
function UBSN_MediaPlay:GetDisplayName() end


---@class UBSN_NotifyActor : UMovieSceneCalliopeNotifySection
---@field NotifyActorGuid FGameplayTag
---@field NotifyTags FGameplayTagContainer
UBSN_NotifyActor = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_NotifyActor:OnNotify(InPlayer, InStatus, bInBackwards) end
---@param InPlaybackContext UObject
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_NotifyActor:OnPreviewNotify(InPlaybackContext, InStatus, bInBackwards) end


---@class UBSN_NotifyPlayEnd : UMovieSceneCalliopeNotifySection
UBSN_NotifyPlayEnd = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_NotifyPlayEnd:OnNotify(InPlayer, InStatus, bInBackwards) end


---@class UBSN_PostAkEventOnUnit : UMovieSceneCalliopeNotifySection
---@field bTakePlayerAsUnit boolean
---@field UnitGuid FGameplayTag
---@field CanHandleStopRequest boolean
---@field AttachPointName FName
---@field AkEvent UAkAudioEvent
---@field AkStopEvent UAkAudioEvent
---@field Follow boolean
---@field EventName FString
UBSN_PostAkEventOnUnit = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_PostAkEventOnUnit:OnNotify(InPlayer, InStatus, bInBackwards) end
---@return FString
function UBSN_PostAkEventOnUnit:GetDisplayName() end
---@param InPlaybackContext UObject
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_PostAkEventOnUnit:OnPreviewNotify(InPlaybackContext, InStatus, bInBackwards) end
---@return float
function UBSN_PostAkEventOnUnit:GetDurationTime() end


---@class UBSN_RemoveBuffOnUnit : UMovieSceneCalliopeNotifySection
---@field bTakePlayerAsUnit boolean
---@field UnitGuid FGameplayTag
---@field BuffID int32
---@field BuffLayer int32
---@field bTriggerRemoveEffect boolean
UBSN_RemoveBuffOnUnit = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_RemoveBuffOnUnit:OnNotify(InPlayer, InStatus, bInBackwards) end
---@param InPlaybackContext UObject
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_RemoveBuffOnUnit:OnPreviewNotify(InPlaybackContext, InStatus, bInBackwards) end


---@class UBSN_SetUnitTransform : UMovieSceneCalliopeNotifySection
---@field bTakePlayerAsUnit boolean
---@field UnitGuid FGameplayTag
---@field Transform FTransform
UBSN_SetUnitTransform = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_SetUnitTransform:OnNotify(InPlayer, InStatus, bInBackwards) end
---@param InPlaybackContext UObject
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_SetUnitTransform:OnPreviewNotify(InPlaybackContext, InStatus, bInBackwards) end


---@class UBSN_ShowUI : UMovieSceneCalliopeNotifySection
---@field UIPageList TArray<EUIPageID>
UBSN_ShowUI = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_ShowUI:OnNotify(InPlayer, InStatus, bInBackwards) end


---@class UBSN_TriggerCustomEvent : UMovieSceneCalliopeNotifySection
---@field EventTag FGameplayTag
UBSN_TriggerCustomEvent = {}

---@param InPlayer UCalliopeLevelSequencePlayer
---@param InStatus int32
---@param bInBackwards boolean
function UBSN_TriggerCustomEvent:OnNotify(InPlayer, InStatus, bInBackwards) end


---@class UBST_PostAudioOnUnit : UMovieSceneCalliopeNormalSection
---@field bTakePlayerAsUnit boolean
---@field UnitGuid FGameplayTag
---@field AttachPointName FName
---@field AkEvent UAkAudioEvent
---@field EventName FString
---@field bRetriggerEvent boolean
---@field ScrubTailLengthMs int32
---@field bStopAtSectionEnd boolean
---@field PostOnDummyObj boolean
UBST_PostAudioOnUnit = {}

---@param Event UAkAudioEvent
function UBST_PostAudioOnUnit:SetEvent_Editor(Event) end
---@param InSectionData UMovieSceneCalliopeSectionData
function UBST_PostAudioOnUnit:Evaluate(InSectionData) end
---@return FString
function UBST_PostAudioOnUnit:GetDisplayName() end
---@return float
function UBST_PostAudioOnUnit:GetDurationTime() end
---@return UMovieSceneCalliopeSectionData
function UBST_PostAudioOnUnit:MakeSectionData() end
---@param InSectionData UMovieSceneCalliopeSectionData
function UBST_PostAudioOnUnit:SectionBeingDestroyed(InSectionData) end


---@class UBTD_CheckSkillCoolDown : UBAID_Base
---@field SkillID int32
UBTD_CheckSkillCoolDown = {}



---@class UBUAnimDataAsset8Dir : UDataAsset
---@field AnimSeqIdle UAnimSequence
UBUAnimDataAsset8Dir = {}



---@class UBUAnimEquipHeadPostProcess : UAnimInstance
---@field IdleBlendWight float
UBUAnimEquipHeadPostProcess = {}

function UBUAnimEquipHeadPostProcess:BlueprintInitializeAnimation() end


---@class UBUAnimEquipPreview : UAnimInstance
---@field AnimIdle UAnimSequence
UBUAnimEquipPreview = {}

function UBUAnimEquipPreview:BlueprintBeginPlay() end
---@param DeltaTimeX float
function UBUAnimEquipPreview:BlueprintUpdateAnimation(DeltaTimeX) end
function UBUAnimEquipPreview:BlueprintInitializeAnimation() end


---@class UBUAnimHumanoidCS : UBUAnimInstanceBase
---@field HandIKAlpha float
---@field DefaultAOAlpha float
---@field AttackAOAlpha float
---@field BSSlotAlpha float
---@field MMKeepAlpha float
---@field bEnableAnyCurveBodyBlend boolean
---@field bHasUpperBodySlotMontage boolean
---@field bHasLeftArmSlotMontage boolean
---@field bHasRightArmSlotMontage boolean
---@field bUsePoseOverride boolean
---@field PoseSnapshot FPoseSnapshot
---@field EnableSnapshotBlendTime float
---@field DisableSnapshotBlendTime float
---@field bEnableAnimCurveBodySeparation boolean
---@field AMMatryoshkaAlpha float
---@field AttackIKAlpha float
---@field bDisableABPMove boolean
---@field bHasMoveInput boolean
---@field bHasPlayerInput boolean
---@field MappedSpeed float
---@field HeadAimYaw float
---@field HeadAimPitch float
---@field HeadAimAlpha float
---@field FootIKAlpha float
---@field IKPelivisAlpha float
---@field IKSpinePitch float
---@field IKSpineRoll float
---@field IKInterpSpeed float
---@field bEnableIK boolean
---@field AnimIdle UAnimSequence
---@field DefaultAimOffset UAimOffsetBlendSpace
---@field AttackAimOffset UAimOffsetBlendSpace
---@field bIsAttackAimOffsetEnable boolean
---@field AttackAimOffsetEnableX float
---@field AttackAimOffsetEnableY float
---@field EnableAimOffset boolean
---@field IsFarButInSight boolean
---@field bIsPlayer boolean
---@field AnimDingShenStart UAnimSequence
---@field AnimDingShenHold UAnimSequence
---@field BSSlot UBlendSpace
---@field BSSlotY float
---@field BSSlotX float
---@field IsBSSlot boolean
---@field WeaponAimAlpha float
---@field PhysicBlendAlpha float
---@field SlopeAlpha float
---@field ASSlopeAdditiveLocalSpace UAnimSequence
---@field ASSlopeAdditiveMeshSpace UAnimSequence
---@field BSMoveSpeedAdditive UBlendSpace
UBUAnimHumanoidCS = {}

---@param DeltaTimeX float
function UBUAnimHumanoidCS:BlueprintThreadSafeUpdateAnimation(DeltaTimeX) end


---@class UBUAnimHumanoidCS_AdvancedMonsterLocomotion : UBUAnimHumanoidCS_LinkedInstanceBase
---@field FreeMode ELMFreeMode
---@field LockMode ELMLockMode
---@field StartAngle float
---@field StrideWarpingStartAlpha float
---@field StrideWarpingLoopAlpha float
---@field StrideWarpingTurnAlpha float
---@field MoveLoopSpine01AngleOffset float
---@field MoveLoopSpine02AngleOffset float
---@field MoveLoopSpine03AngleOffset float
---@field MoveLoopHeadAngleOffset float
---@field MoveLoopPelvisLocalOffset float
---@field MoveLoopPelvisAngleOffset float
---@field ASWalkStartFwd UAnimSequence
---@field ASWalkStartBwd UAnimSequence
---@field ASWalkStartLeftMin UAnimSequence
---@field ASWalkStartLeftMax UAnimSequence
---@field ASWalkStartRightMin UAnimSequence
---@field ASWalkStartRightMax UAnimSequence
---@field ASWalkStartLF UAnimSequence
---@field ASWalkStartLB UAnimSequence
---@field ASWalkStartRF UAnimSequence
---@field ASWalkStartRB UAnimSequence
---@field ASWalkLoopFwd UAnimSequence
---@field ASWalkLoopBwd UAnimSequence
---@field ASWalkLoopLF UAnimSequence
---@field ASWalkLoopLB UAnimSequence
---@field ASWalkLoopRF UAnimSequence
---@field ASWalkLoopRB UAnimSequence
---@field ASWalkSharpturnLeftMin UAnimSequence
---@field ASWalkSharpturnLeftMax UAnimSequence
---@field ASWalkSharpturnRightMin UAnimSequence
---@field ASWalkSharpturnRightMax UAnimSequence
---@field ASWalkPivotFwd UAnimSequence
---@field ASWalkPivotBwd UAnimSequence
---@field ASWalkPivotLF UAnimSequence
---@field ASWalkPivotLB UAnimSequence
---@field ASWalkPivotRF UAnimSequence
---@field ASWalkPivotRB UAnimSequence
---@field ASWalkTransFRToBR UAnimSequence
---@field ASWalkTransBRToFR UAnimSequence
---@field ASWalkTransFLToBL UAnimSequence
---@field ASWalkTransBLToFL UAnimSequence
---@field ASWalkStopFwd UAnimSequence
---@field ASWalkStopBwd UAnimSequence
---@field ASWalkStopLF UAnimSequence
---@field ASWalkStopLB UAnimSequence
---@field ASWalkStopRF UAnimSequence
---@field ASWalkStopRB UAnimSequence
---@field ASWalkLoopAddPose UAnimSequence
---@field ASWalkLoopAdditiveList TArray<UAnimSequence>
---@field ASRunStartFwd UAnimSequence
---@field ASRunStartBwd UAnimSequence
---@field ASRunStartLeftMin UAnimSequence
---@field ASRunStartLeftMax UAnimSequence
---@field ASRunStartRightMin UAnimSequence
---@field ASRunStartRightMax UAnimSequence
---@field ASRunStartLF UAnimSequence
---@field ASRunStartLB UAnimSequence
---@field ASRunStartRF UAnimSequence
---@field ASRunStartRB UAnimSequence
---@field ASRunLoopFwd UAnimSequence
---@field ASRunLoopBwd UAnimSequence
---@field ASRunLoopLF UAnimSequence
---@field ASRunLoopLB UAnimSequence
---@field ASRunLoopRF UAnimSequence
---@field ASRunLoopRB UAnimSequence
---@field ASRunSharpturnLeftMin UAnimSequence
---@field ASRunSharpturnLeftMax UAnimSequence
---@field ASRunSharpturnRightMin UAnimSequence
---@field ASRunSharpturnRightMax UAnimSequence
---@field ASRunPivotFwd UAnimSequence
---@field ASRunPivotBwd UAnimSequence
---@field ASRunPivotLF UAnimSequence
---@field ASRunPivotLB UAnimSequence
---@field ASRunPivotRF UAnimSequence
---@field ASRunPivotRB UAnimSequence
---@field ASRunTransFRToBR UAnimSequence
---@field ASRunTransBRToFR UAnimSequence
---@field ASRunTransFLToBL UAnimSequence
---@field ASRunTransBLToFL UAnimSequence
---@field ASRunStopFwd UAnimSequence
---@field ASRunStopBwd UAnimSequence
---@field ASRunStopLF UAnimSequence
---@field ASRunStopLB UAnimSequence
---@field ASRunStopRF UAnimSequence
---@field ASRunStopRB UAnimSequence
---@field ASRunLoopAddPose UAnimSequence
---@field ASRunLoopAdditiveList TArray<UAnimSequence>
---@field ASRushStartFwd UAnimSequence
---@field ASRushStartLeftMin UAnimSequence
---@field ASRushStartLeftMax UAnimSequence
---@field ASRushStartRightMin UAnimSequence
---@field ASRushStartRightMax UAnimSequence
---@field ASRushLoopFwd UAnimSequence
---@field ASRushSharpturnLeftMin UAnimSequence
---@field ASRushSharpturnLeftMax UAnimSequence
---@field ASRushSharpturnRightMin UAnimSequence
---@field ASRushSharpturnRightMax UAnimSequence
---@field ASRushStopFwd UAnimSequence
---@field ASRushLoopAddPose UAnimSequence
---@field ASRushLoopAdditiveList TArray<UAnimSequence>
---@field AnimIdle UAnimSequence
---@field MappedSpeed float
---@field GaitGroundedState GaitGroundedState
---@field MoveGaitGroundedState GaitGroundedState
---@field SwitchingLockStateAngle float
---@field ActorSpineNum int32
---@field VelocityDeltaAngle float
---@field StopVelocityDeltaAngle float
---@field InputDeltaAngle float
---@field InputVelocityAngle float
---@field MoveSpeedLastUpdate float
---@field bPivotUseOrientationWarping boolean
---@field bUpdateAnimIdle boolean
---@field bSwitchToLock boolean
---@field bSwitchingLockState boolean
---@field bFreeStop boolean
---@field bLockStop boolean
---@field bSwitchingLockStateStop boolean
---@field bMoveToIdle boolean
---@field bStartToTrans boolean
---@field bFreeStartToTurn boolean
---@field bLockStartToTurn boolean
---@field bSwitchingFreeToTurn boolean
---@field bLockLoopToTurn boolean
---@field bLockTurnToLoop boolean
---@field bFreeLoopToTurn boolean
---@field bFreeMoveToTurn boolean
---@field bLockMoveToTurn boolean
---@field bMoveStartSwitch boolean
---@field bMoveTurnSwitch boolean
UBUAnimHumanoidCS_AdvancedMonsterLocomotion = {}

---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldToMove() end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:SetupIdleAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:SetupIdleOutput(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:SetupMoveLoopAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:SetupMoveStopAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:SetupMoveTurnAnim(Context, Node) end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopToBR() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopToBL() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopToFR() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopToFL() end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:SetupMoveStartAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveStopAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveTurnAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:SetupMoveTurnOutput(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:SetupMoveStopOutput(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveStartAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:SetupMoveLoopOutput(Context, Node) end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopToFwd() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopToBwd() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopBRToFR() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopFRToBR() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopFLToBL() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopLeftBR() end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveTurnOutput(Context, Node) end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopLeftFR() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopLeftFL() end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveStopOutput(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveLoopOutput(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveLoopBRAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveLoopBLAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveLoopFRAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveLoopFLAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:SetupMoveStartOutput(Context, Node) end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopLeftBL() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopBLToFL() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopLeftBwd() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopLeftFwd() end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveLoopFwdAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveLoopBwdAnim(Context, Node) end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopTransToFL() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopTransToFR() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopTransToBR() end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveLoopTransAnim(Context, Node) end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopTransToBL() end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveLoopSimpleAnim(Context, Node) end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveTurnSwitchFree() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveTurnSwitchLock() end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:SetupMoveLoopAdditiveAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveLoopLB2LFOutput(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveLoopRB2RFOutput(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveLoopRF2RBOutput(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveLoopLF2LBOutput(Context, Node) end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopLeftTransBR() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopLeftTransFL() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopLeftTransBL() end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveLoopLeftTransFR() end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:UpdateMoveLoopStateMachine(Context, Node) end
---@return boolean
function UBUAnimHumanoidCS_AdvancedMonsterLocomotion:ShouldMoveTurnSwitchLockToFree() end


---@class UBUAnimHumanoidCS_AnimCurveBodyBlend : UBUAnimHumanoidCS_LinkedInstanceBase
---@field ASCurveBodyBlendUpperBody UAnimSequenceBase
---@field CurveBodyBlendUpperBodyWeight float
---@field ASCurveBodyBlendLeftArm UAnimSequenceBase
---@field CurveBodyBlendLeftArmWeight float
---@field ASCurveBodyBlendRightArm UAnimSequenceBase
---@field CurveBodyBlendRightArmWeight float
---@field ASCurveBodyBlendLeftLeg UAnimSequenceBase
---@field CurveBodyBlendLeftLegWeight float
---@field ASCurveBodyBlendRightLeg UAnimSequenceBase
---@field CurveBodyBlendRightLegWeight float
UBUAnimHumanoidCS_AnimCurveBodyBlend = {}



---@class UBUAnimHumanoidCS_AnimCurveBodySeparation : UBUAnimHumanoidCS_LinkedInstanceBase
---@field BodyBlendWeight_Leg float
---@field BodyBlendWeight_Pelvis float
---@field BodyBlendWeight_Spine float
---@field BodyBlendWeight_Head float
---@field BodyBlendWeight_ArmL float
---@field BodyBlendWeight_ArmR float
---@field BodyBlendWeight_ArmL_LocalSpace float
---@field BodyBlendWeight_ArmR_LocalSpace float
---@field BodySeparationBlendAlpha float
UBUAnimHumanoidCS_AnimCurveBodySeparation = {}

---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AnimCurveBodySeparation:InitBodySeparationBlend(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_AnimCurveBodySeparation:UpdateBodySeparationBlend(Context, Node) end


---@class UBUAnimHumanoidCS_AttackIK : UBUAnimHumanoidCS_LinkedInstanceBase
---@field AttackIKAlpha float
---@field AttackIKRollList TArray<float>
---@field AttackIKPitchList TArray<float>
---@field SolverRootBoneNameList TArray<FName>
---@field SolverEffectorBoneNameList TArray<FName>
---@field BoneScaleEnable boolean
---@field BoneScaleName FName
---@field BonePosition FVector
---@field BoneScaleAlpha float
UBUAnimHumanoidCS_AttackIK = {}



---@class UBUAnimHumanoidCS_BoneAim : UBUAnimHumanoidCS_LinkedInstanceBase
---@field WeaponAimAlpha float
---@field bEnableWeaponAim boolean
---@field WeaponBoneName FName
---@field WeaponAimPos FVector
---@field WeaponAimAxis FVector
---@field WeaponDegreesConstraint float
UBUAnimHumanoidCS_BoneAim = {}



---@class UBUAnimHumanoidCS_CloudLocomotion : UBUAnimHumanoidCS_LinkedInstanceBase
---@field LeanPitchAdditvie_Up UAnimSequence
---@field LeanPitchAdditvie_Down UAnimSequence
---@field StartFwd UAnimSequence
---@field StartFwdL UAnimSequence
---@field StartFwdR UAnimSequence
---@field StartBwdL UAnimSequence
---@field StartBwdR UAnimSequence
---@field RunLoop UAnimSequence
---@field RushLoop UAnimSequence
---@field RunLoopAdditvie_Left UAnimSequence
---@field RunLoopAdditvie_Right UAnimSequence
---@field RushLoopAdditvie_Left UAnimSequence
---@field RushLoopAdditvie_Right UAnimSequence
---@field RunStop UAnimSequence
---@field RushStop UAnimSequence
---@field bUpdateAnimIdle boolean
---@field InputVelocityAngle float
---@field Velocity FVector
---@field MoveAcceleration FVector
---@field MappedSpeed float
---@field GaitGroundedState GaitGroundedState
---@field StartAngle float
---@field RotationSpeed float
---@field MaxAcceleration float
---@field InputMoveDir FVector
---@field FinalMoveDir FVector
UBUAnimHumanoidCS_CloudLocomotion = {}

---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_CloudLocomotion:SetupIdleAnim(Context, Node) end


---@class UBUAnimHumanoidCS_FlyControl : UBUAnimHumanoidCS_LinkedInstanceBase
---@field bUseComplexFlyControl boolean
---@field BSFly UBlendSpace
---@field BSFlyX float
---@field BSFlyY float
---@field ASFlyUpward UAnimSequence
---@field ASFlyDownward UAnimSequence
---@field ASFlyUpToDown UAnimSequence
---@field ASFlyDownToUp UAnimSequence
---@field BSFlyLean UBlendSpace
---@field BSFlyLeanX float
---@field BSFlyLeanY float
---@field bFlyUpToDown boolean
---@field bFlyDownToUp boolean
UBUAnimHumanoidCS_FlyControl = {}



---@class UBUAnimHumanoidCS_FootIK : UBUAnimHumanoidCS_LinkedInstanceBase
---@field IKEffectorLeftFoot FVector
---@field IKEffectorRightFoot FVector
---@field IKEffectorLFoot_MeshSpace FVector
---@field IKEffectorRFoot_MeshSpace FVector
---@field IKJoint_LeftFoot FVector
---@field IKJoint_RightFoot FVector
---@field IKJointLFoot_MeshSpace FVector
---@field IKJointRFoot_MeshSpace FVector
---@field IKLeftFootAlpha float
---@field IKRightFootAlpha float
---@field IKScale float
---@field IKPelvisOffset float
---@field bFootUseFBIK boolean
UBUAnimHumanoidCS_FootIK = {}



---@class UBUAnimHumanoidCS_HandIK : UBUAnimHumanoidCS_LinkedInstanceBase
---@field bRHandUseFBIK boolean
---@field bLHandUseFBIK boolean
---@field IKEffectorLHand_MeshSpace FVector
---@field IKEffectorRHand_MeshSpace FVector
---@field IKEffectorLeftHand FVector
---@field IKEffectorRightHand FVector
---@field IKJointLeftHand FVector
---@field IKJointRightHand FVector
---@field IKAlphaLeftHand float
---@field IKAlphaRightHand float
UBUAnimHumanoidCS_HandIK = {}



---@class UBUAnimHumanoidCS_LeftArmSeparation : UBUAnimHumanoidCS_LinkedInstanceBase
---@field LeftArmBlendWeight float
UBUAnimHumanoidCS_LeftArmSeparation = {}



---@class UBUAnimHumanoidCS_LinkedInstanceBase : UAnimInstance
UBUAnimHumanoidCS_LinkedInstanceBase = {}

---@param DeltaTimeX float
function UBUAnimHumanoidCS_LinkedInstanceBase:BlueprintUpdateAnimation(DeltaTimeX) end
function UBUAnimHumanoidCS_LinkedInstanceBase:BlueprintInitializeAnimation() end
---@param DeltaTime float
function UBUAnimHumanoidCS_LinkedInstanceBase:BlueprintThreadSafeUpdateAnimation(DeltaTime) end


---@class UBUAnimHumanoidCS_MMRetarget : UBUAnimHumanoidCS_LinkedInstanceBase
---@field bCanRetarget boolean
---@field RetargetSrcMesh USkeletalMeshComponent
---@field BasePose UAnimSequence
---@field bNeedFixMM boolean
---@field MMAdditiveWeight float
---@field MMAdditivePose UAnimSequence
---@field Retargeter UIKRetargeter
---@field MMRetarget_PelvisOffsetZ float
---@field MMRetarget_FootOffsetScale float
UBUAnimHumanoidCS_MMRetarget = {}



---@class UBUAnimHumanoidCS_MonsterLocomotion : UBUAnimHumanoidCS_LinkedInstanceBase
---@field AnimIdle UAnimSequence
---@field VelocityBlendAlpha FVector4
---@field MoveLoopFwdBlendAlpha float
---@field ASFreeRunFwd UAnimSequence
---@field ASFreeRunStartFwd UAnimSequence
---@field ASFreeRunStartFR UAnimSequence
---@field ASFreeRunStartBR UAnimSequence
---@field ASFreeRunStartFL UAnimSequence
---@field ASFreeRunStartBL UAnimSequence
---@field BSFreeLeanAdditive UBlendSpace
---@field BSFreeLeanAdditiveX float
---@field BSFreeLeanAdditiveY float
---@field BSFreeRotAdditive UBlendSpace
---@field BSFreeRotAdditiveX float
---@field BSFreeRotAdditiveY float
---@field ASFreeRunStopLeftFoot UAnimSequence
---@field ASFreeRunStopRightFoot UAnimSequence
---@field bLeftFootFront boolean
---@field ASLockWalkFwd UAnimSequence
---@field ASLockWalkFR UAnimSequence
---@field ASLockWalkBR UAnimSequence
---@field ASLockWalkFL UAnimSequence
---@field ASLockWalkBL UAnimSequence
---@field ASLockWalkBwd UAnimSequence
---@field LockMoveDir MoveDirectionEight
---@field LockWalkFwdExplicitTimeForLeftFootStop float
---@field LockWalkBwdExplicitTimeForLeftFootStop float
---@field LockWalkFLExplicitTimeForLeftFootStop float
---@field LockWalkBLExplicitTimeForLeftFootStop float
---@field LockWalkFRExplicitTimeForLeftFootStop float
---@field LockWalkBRExplicitTimeForLeftFootStop float
---@field LockWalkFwdExplicitTimeForRightFootStop float
---@field LockWalkBwdExplicitTimeForRightFootStop float
---@field LockWalkFLExplicitTimeForRightFootStop float
---@field LockWalkBLExplicitTimeForRightFootStop float
---@field LockWalkFRExplicitTimeForRightFootStop float
---@field LockWalkBRExplicitTimeForRightFootStop float
---@field bSwitchToLock boolean
---@field bLockMoveF boolean
---@field bLockMoveB boolean
---@field bLockMoveL boolean
---@field bLockMoveR boolean
---@field bFreeMoveStartFwd boolean
---@field bFreeMoveStartBL boolean
---@field bFreeMoveStartFL boolean
---@field bFreeMoveStartBR boolean
---@field bFreeMoveStartFR boolean
---@field bIdleToMove boolean
---@field bMoveStop boolean
---@field bStandardFreeMoveStop boolean
UBUAnimHumanoidCS_MonsterLocomotion = {}



---@class UBUAnimHumanoidCS_MotionMatching : UBUAnimHumanoidCS_LinkedInstanceBase
---@field InputDesiredTransform FTransform
---@field InputRootTransform FTransform
---@field InputStrength float
---@field MotionMatchingState State_MM
---@field RotatorforMM FRotator
---@field UseMotionMatching boolean
---@field SpareMoveMode EABPMoveMode
---@field CurrentAA UAnimationAnalyzer
---@field AnimationAnalyzerBlendTime float
---@field MotionBlendTime float
---@field MMPlayRate float
---@field ForceSetRotAnimSpeed float
---@field DisableRotVerifyAnimSpeed float
---@field bRecordMMAnimData boolean
---@field bDisableLocomotionIdle boolean
---@field bForceMMToIdle boolean
---@field MMUpBodyStateAlpha float
---@field RotateAdditiveBS UBlendSpace
---@field RotateBSX float
---@field bMMtoIdle boolean
---@field bIdleToMM boolean
---@field bNeedFixMM boolean
---@field bFixMMWeapon_MeshSpaceRotation boolean
---@field MMAdditivePose UAnimSequence
---@field bFixMMAdditive_MeshSpaceRotation boolean
---@field MMAdditiveLayerSetup TArray<FGSInputBlendPose>
---@field MMAdditiveWeight float
---@field MMTransAnim UAnimSequence
---@field MMTransAnimStartPos float
---@field MMTransAlpha float
---@field bMMTransFinish boolean
---@field bMMTransStart boolean
---@field DefaultJointData FDefaultMotionJointData
---@field DefaultVelocity FVector
---@field bKeepMMInputUnchanged boolean
---@field bUseLMAnim boolean
---@field bDisableMMRootMotion boolean
---@field Speed float
---@field AnimIdle UAnimSequence
---@field BSRunFwd UBlendSpace
UBUAnimHumanoidCS_MotionMatching = {}

---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_MotionMatching:SetupDefaultMMPoseData(Context, Node) end


---@class UBUAnimHumanoidCS_Move : UBUAnimHumanoidCS_LinkedInstanceBase
---@field FinalABPMoveMode EABPMoveMode
---@field AnimTurnInPlaceLeft UAnimSequence
---@field AnimTurnInPlaceRight UAnimSequence
---@field AnimTurnInPlaceLeft180 UAnimSequence
---@field AnimTurnInPlaceRight180 UAnimSequence
---@field IsStandRotateStart boolean
---@field IsMoveAccelerating boolean
---@field StandRotateType StandRotateType
---@field RotateAngle float
---@field bCanMMRetarget boolean
UBUAnimHumanoidCS_Move = {}



---@class UBUAnimHumanoidCS_PlayerLocomotion : UBUAnimHumanoidCS_LinkedInstanceBase
---@field BSFreeAdditiveMovingLean UBlendSpace
---@field FreeAdditiveMovingLeanX float
---@field FreeAdditiveMovingLeanY float
---@field FreeAdditiveMovingLeanAlpha float
---@field ASFreeSprintStartF UAnimSequence
---@field ASFreeSprintStartL UAnimSequence
---@field ASFreeSprintStartR UAnimSequence
---@field ASFreeSprintStartBwdL UAnimSequence
---@field ASFreeSprintStartBwdR UAnimSequence
---@field ASFreeSprintTurnL UAnimSequence
---@field ASFreeSprintTurnR UAnimSequence
---@field ASFreeSprintTurnBwdL UAnimSequence
---@field ASFreeSprintTurnBwdR UAnimSequence
---@field ASFreeRunStop UAnimSequence
---@field ASFreeSprintStop UAnimSequence
---@field ASFreeSprintStopSlopeUp UAnimSequence
---@field BSLockWalkTurnF2B UBlendSpace
---@field BSLockWalkTurnB2F UBlendSpace
---@field BSLockRunTurnF2B UBlendSpace
---@field BSLockRunTurnB2F UBlendSpace
---@field BSWalkLoopFwd UBlendSpace
---@field VelocityDeltaAngle float
---@field VelocityDeltaAngleWalk float
---@field VelocityDeltaAngleRun float
---@field VelocityDeltaAngleRush float
---@field SlopeAngle float
---@field BSRunLoopFwd UBlendSpace
---@field AnimRateWalk float
---@field AnimRateRun float
---@field AnimRateRush float
---@field AnimRateRunLock float
---@field BSRunLoopAdditive UBlendSpace
---@field BSRunLoopRotationAdditive UBlendSpace
---@field FreeAdditiveMovingLeanSmoothX float
---@field FreeAdditiveMovingLeanSmoothY float
---@field BSRushLoopFwd UBlendSpace
---@field BSRushLoopLean UBlendSpace
---@field ASWalkStartBwdL UAnimSequence
---@field ASWalkStartLeft UAnimSequence
---@field ASWalkStartFwd UAnimSequence
---@field ASWalkStartRight UAnimSequence
---@field ASWalkStartBwdR UAnimSequence
---@field ASWalkTurnBwdL UAnimSequence
---@field ASWalkTurnLeft UAnimSequence
---@field ASWalkTurnRight UAnimSequence
---@field ASWalkTurnBwdR UAnimSequence
---@field WalkStartAngle float
---@field ASRunStartBwdL UAnimSequence
---@field ASRunStartLeft UAnimSequence
---@field ASRunStartFwd UAnimSequence
---@field ASRunStartRight UAnimSequence
---@field ASRunStartBwdR UAnimSequence
---@field ASRunTurnBwdL UAnimSequence
---@field ASRunTurnLeft UAnimSequence
---@field ASRunTurnRight UAnimSequence
---@field ASRunTurnBwdR UAnimSequence
---@field ASRunTurnBwdFallingVelocityAdditive UAnimSequence
---@field ASRunTurnBwdFallingVelocityAdditiveAlpha float
---@field ASRunTurnFwdL UAnimSequence
---@field ASRunTurnFwdR UAnimSequence
---@field ASRunTurnFwdFallingVelocityAdditive UAnimSequence
---@field ASRunTurnFwdFallingVelocityAdditiveAlpha float
---@field ASRunTurnFwdSpeedAdditive UAnimSequence
---@field ASRunTurnFwdSpeedAdditiveAlpha float
---@field RunStartAngle float
---@field RushStartAngle float
---@field ASFreeWalkStop UAnimSequence
---@field BSLockWalkStartFwd UBlendSpace
---@field BSLockWalkStartBwd UBlendSpace
---@field ASLockWalkStartFwdL UAnimSequence
---@field ASLockWalkStartFwdR UAnimSequence
---@field ASLockWalkStartBwdL UAnimSequence
---@field ASLockWalkStartBwdR UAnimSequence
---@field ASLockWalkStartLeftF UAnimSequence
---@field ASLockWalkStartLeftB UAnimSequence
---@field ASLockWalkStartRightF UAnimSequence
---@field ASLockWalkStartRightB UAnimSequence
---@field BSLockRunStartFwd UBlendSpace
---@field BSLockRunStartBwd UBlendSpace
---@field ASLockRunStartFwdL UAnimSequence
---@field ASLockRunStartFwdR UAnimSequence
---@field ASLockRunStartBwdL UAnimSequence
---@field ASLockRunStartBwdR UAnimSequence
---@field ASLockRunStartLeftF UAnimSequence
---@field ASLockRunStartLeftB UAnimSequence
---@field ASLockRunStartRightF UAnimSequence
---@field ASLockRunStartRightB UAnimSequence
---@field BSLockTurnFRFromFRBL UBlendSpace
---@field BSLockTurnFRFromFLBR UBlendSpace
---@field BSLockTurnBRFromFRBL UBlendSpace
---@field BSLockTurnBRFromFLBR UBlendSpace
---@field BSLockTurnBLFromFRBL UBlendSpace
---@field BSLockTurnBLFromFLBR UBlendSpace
---@field BSLockTurnFLFromFRBL UBlendSpace
---@field BSLockTurnFLFromFLBR UBlendSpace
---@field LockTurnToAlphaFR float
---@field LockTurnToAlphaBR float
---@field LockTurnToAlphaBL float
---@field LockTurnToAlphaFL float
---@field LockTurnFromAlphaFR float
---@field LockTurnFromAlphaBR float
---@field LockTurnFromAlphaBL float
---@field LockTurnFromAlphaFL float
---@field ASLockWalkLoopFwd UAnimSequence
---@field ASLockWalkLoopBwd UAnimSequence
---@field ASLockWalkLoopLeftF UAnimSequence
---@field ASLockWalkLoopRightF UAnimSequence
---@field ASLockWalkLoopLeftB UAnimSequence
---@field ASLockWalkLoopRightB UAnimSequence
---@field ASLockWalkLoopLeftFAdd UAnimSequence
---@field ASLockWalkLoopRightFAdd UAnimSequence
---@field ASLockRunLoopFwd UAnimSequence
---@field ASLockRunLoopBwd UAnimSequence
---@field ASLockRunLoopLeftF UAnimSequence
---@field ASLockRunLoopRightF UAnimSequence
---@field ASLockRunLoopLeftB UAnimSequence
---@field ASLockRunLoopRightB UAnimSequence
---@field ASLockRunLoopLeftFAdd UAnimSequence
---@field ASLockRunLoopRightFAdd UAnimSequence
---@field BSLockWalkTurnFR2BL UBlendSpace
---@field BSLockWalkTurnBR2FL UBlendSpace
---@field BSLockWalkTurnBL2FR UBlendSpace
---@field BSLockWalkTurnFL2BR UBlendSpace
---@field BSLockWalkTurnFR2FL UBlendSpace
---@field BSLockWalkTurnFL2FR UBlendSpace
---@field BSLockWalkTurnBL2FL UBlendSpace
---@field BSLockWalkTurnFL2BL UBlendSpace
---@field BSLockWalkTurnBR2FR UBlendSpace
---@field BSLockWalkTurnFR2BR UBlendSpace
---@field BSLockRunTurnFR2BL UBlendSpace
---@field BSLockRunTurnBR2FL UBlendSpace
---@field BSLockRunTurnBL2FR UBlendSpace
---@field BSLockRunTurnFL2BR UBlendSpace
---@field BSLockRunTurnFR2FL UBlendSpace
---@field BSLockRunTurnFL2FR UBlendSpace
---@field BSLockRunTurnBL2FL UBlendSpace
---@field BSLockRunTurnFL2BL UBlendSpace
---@field BSLockRunTurnBR2FR UBlendSpace
---@field BSLockRunTurnFR2BR UBlendSpace
---@field BSLockTurnStopFL UBlendSpace
---@field BSLockTurnStopFR UBlendSpace
---@field BSLockTurnStopBL UBlendSpace
---@field BSLockTurnStopBR UBlendSpace
---@field LockTurnStopAlphaFR float
---@field LockTurnStopAlphaBR float
---@field LockTurnStopAlphaBL float
---@field LockTurnStopAlphaFL float
---@field ASLockWalkStopFwd UAnimSequence
---@field ASLockWalkStopBwd UAnimSequence
---@field ASLockWalkStopLeftF UAnimSequence
---@field ASLockWalkStopLeftB UAnimSequence
---@field ASLockWalkStopRightF UAnimSequence
---@field ASLockWalkStopRightB UAnimSequence
---@field ASLockWalkStopFL45 UAnimSequence
---@field ASLockWalkStopFR45 UAnimSequence
---@field ASLockWalkStopBL45 UAnimSequence
---@field ASLockWalkStopBR45 UAnimSequence
---@field ASLockRunStopFwdL UAnimSequence
---@field ASLockRunStopFwdR UAnimSequence
---@field ASLockRunStopBwdL UAnimSequence
---@field ASLockRunStopBwdR UAnimSequence
---@field ASLockRunStopLeftF UAnimSequence
---@field ASLockRunStopLeftB UAnimSequence
---@field ASLockRunStopRightF UAnimSequence
---@field ASLockRunStopRightB UAnimSequence
---@field AnimIdle UAnimSequence
---@field MoveSpeedLevel MoveSpeedLevel
---@field MoveSpeedState MoveSpeedLevel
---@field InputBlendAlpha FVector4
---@field VelocityBlendAlpha FVector4
---@field VelocityBlendAlphaStop FVector4
---@field bLandingMove boolean
---@field LastFallingVelocity FVector
---@field RandomIdleIndex int32
---@field MoveLoopSpeedState float
---@field MaxSpeed float
---@field CurveMoveSpeedScale float
---@field TargetLockMoveDeltaAngle float
---@field InputDeltaAngle float
---@field InputDeltaAngleBackward float
---@field StrideWarpingSpeed float
---@field StrideWarpingAlpha float
---@field bSwitchToLock boolean
---@field bLockMoveF boolean
---@field bLockMoveB boolean
---@field bLockMoveL boolean
---@field bLockMoveR boolean
---@field bFreeTurn boolean
---@field bWalkFreeBwdL boolean
---@field bWalkFreeLeft boolean
---@field bWalkFreeRight boolean
---@field bWalkFreeBwdR boolean
---@field bRunFreeBwdL boolean
---@field bRunFreeTurnLeft boolean
---@field bRunFreeTurnRight boolean
---@field bRunFreeStartLeft boolean
---@field bRunFreeStartRight boolean
---@field bRunFreeBwdR boolean
---@field bRunFreeTurnFwdL boolean
---@field bRunFreeTurnLandFwdL boolean
---@field bRunFreeTurnLandFwdR boolean
---@field bRushFreeBwdL boolean
---@field bRushFreeLeft boolean
---@field bRushFreeRight boolean
---@field bRushFreeBwdR boolean
---@field bLastRush boolean
---@field bLastRun boolean
---@field bLeftFootFront boolean
---@field bRunStop boolean
---@field bRushStop boolean
---@field bToStop boolean
---@field bToTurnStop boolean
---@field bIdleToWalk boolean
---@field bRunToWalk boolean
---@field bToRun boolean
---@field bToRush boolean
---@field bLockMoveFromTurnStopFR boolean
---@field bLockMoveFromTurnStopBR boolean
---@field bLockMoveFromTurnStopBL boolean
---@field bLockMoveFromTurnStopFL boolean
---@field bLockMoveTransFromFwd boolean
---@field bLockMoveTransFromBwd boolean
---@field bLockMoveTransFromFL boolean
---@field bLockMoveTransFromFR boolean
---@field bLockMoveTransFromBL boolean
---@field bLockMoveTransFromBR boolean
---@field bLockMoveFromTurnStop boolean
---@field bInLockMoveState boolean
---@field bLockMoveTurnStart boolean
---@field bLockMoveToFwdLoop boolean
---@field bLockMoveToBwdLoop boolean
---@field bLockMoveToFLLoop boolean
---@field bLockMoveToBLLoop boolean
---@field bLockMoveToFRLoop boolean
---@field bLockMoveToBRLoop boolean
---@field bLockMoveStartFwd boolean
---@field bLockMoveStartBwd boolean
---@field bLockMoveStartFL boolean
---@field bLockMoveStartFR boolean
---@field bLockMoveStartBL boolean
---@field bLockMoveStartBR boolean
---@field bLockMoveFRToFwd boolean
---@field bLockMoveFRToFL boolean
---@field bLockMoveBRToBwd boolean
---@field bLockMoveBLToBwd boolean
---@field bLockMoveFLToFwd boolean
---@field bLockMoveFLToFR boolean
---@field bLockMoveToTurnStopFR boolean
---@field bLockMoveToTurnStopBR boolean
---@field bLockMoveToTurnStopBL boolean
---@field bLockMoveToTurnStopFL boolean
---@field bLockWalk boolean
---@field bLockRun boolean
---@field bLockStopFwd boolean
---@field bLockStopBwd boolean
---@field bLockStopLeft boolean
---@field bLockStopRight boolean
---@field bLockStopFL boolean
---@field bLockStopFR boolean
---@field bLockStopBL boolean
---@field bLockStopBR boolean
---@field bInSequenceTransition boolean
---@field bToSequenceTransitionMove boolean
---@field bSequenceTransitionFromWalk boolean
---@field bSequenceTransitionFromRun boolean
---@field bSequenceTransitionFromRush boolean
UBUAnimHumanoidCS_PlayerLocomotion = {}

function UBUAnimHumanoidCS_PlayerLocomotion:OnLeftSeqMove() end
function UBUAnimHumanoidCS_PlayerLocomotion:OnEnterSeqMove() end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_PlayerLocomotion:SetUpRushStopAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_PlayerLocomotion:GetRandomIdleAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_PlayerLocomotion:SetupSequenceTransitionAnim(Context, Node) end


---@class UBUAnimHumanoidCS_QuadrupedIK : UBUAnimHumanoidCS_LinkedInstanceBase
---@field IKEffectorLeftFoot FVector
---@field IKEffectorRightFoot FVector
---@field IKEffectorLFoot_MeshSpace FVector
---@field IKEffectorRFoot_MeshSpace FVector
---@field IKEffectorLeftHand FVector
---@field IKEffectorRightHand FVector
---@field IKEffectorLHand_MeshSpace FVector
---@field IKEffectorRHand_MeshSpace FVector
---@field IKJoint_LeftFoot FVector
---@field IKJoint_RightFoot FVector
---@field IKJointLFoot_MeshSpace FVector
---@field IKJointRFoot_MeshSpace FVector
---@field IKJoint_LeftHand FVector
---@field IKJoint_RightHand FVector
---@field IKJointLHand_MeshSpace FVector
---@field IKJointRHand_MeshSpace FVector
---@field IKLeftFootAlpha float
---@field IKRightFootAlpha float
---@field IKLeftHandAlpha float
---@field IKRightHandAlpha float
---@field IKScale float
---@field IKPelvisOffset float
---@field IKNeckOffset float
---@field bFootUseFBIK boolean
UBUAnimHumanoidCS_QuadrupedIK = {}



---@class UBUAnimHumanoidCS_QuadrupedLocomotion : UBUAnimHumanoidCS_LinkedInstanceBase
---@field BSMove UBlendSpace
---@field BSMoveBack UBlendSpace
---@field MoveYaw float
---@field SpeedRate float
---@field ASWalkStop UAnimSequence
---@field ASRunStartF UAnimSequence
---@field ASRunStartL UAnimSequence
---@field ASRunStartR UAnimSequence
---@field ASRunStartBL UAnimSequence
---@field ASRunStartBR UAnimSequence
---@field ASRunTurnStop UAnimSequence
---@field ASRunTurnL UAnimSequence
---@field ASRunTurnR UAnimSequence
---@field ASRunTurnBL UAnimSequence
---@field ASRunTurnBR UAnimSequence
---@field ASRunStop UAnimSequence
---@field ASRushStartF UAnimSequence
---@field ASRushStartL UAnimSequence
---@field ASRushStartR UAnimSequence
---@field ASRushStartBL UAnimSequence
---@field ASRushStartBR UAnimSequence
---@field ASRushTurnStop UAnimSequence
---@field ASRushTurnL UAnimSequence
---@field ASRushTurnR UAnimSequence
---@field ASRushTurnBL UAnimSequence
---@field ASRushTurnBR UAnimSequence
---@field ASRushStop UAnimSequence
---@field ASRunJump UAnimSequence
---@field ASRushJump UAnimSequence
---@field ASRunJumpSlope UAnimSequence
---@field ASRushJumpSlope UAnimSequence
---@field bUpdateAnimIdle boolean
---@field bShouldMove boolean
---@field bIdleToStart boolean
---@field bIdleToLoop boolean
---@field bLoopToIdle boolean
---@field bMoveBack boolean
---@field bInJump boolean
---@field bSlopeJump boolean
---@field bToFall boolean
---@field bToLandAnim boolean
---@field bToLandMove boolean
---@field bToTurn boolean
---@field bToStop boolean
---@field bToTurnStop boolean
---@field bToWalk boolean
---@field bToRun boolean
---@field bToRush boolean
---@field bToRunJump boolean
---@field bToRushJump boolean
---@field bToF boolean
---@field bToL boolean
---@field bToR boolean
---@field bToBL boolean
---@field bToBR boolean
UBUAnimHumanoidCS_QuadrupedLocomotion = {}

---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_QuadrupedLocomotion:SetupFallAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_QuadrupedLocomotion:GetRandomIdleAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_QuadrupedLocomotion:SetupLandMoveAnim(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_QuadrupedLocomotion:SetupLandStopAnim(Context, Node) end


---@class UBUAnimHumanoidCS_RightArmSeparation : UBUAnimHumanoidCS_LinkedInstanceBase
---@field RightArmBlendWeight float
UBUAnimHumanoidCS_RightArmSeparation = {}



---@class UBUAnimHumanoidCS_Simple4Dir : UBUAnimHumanoidCS_LinkedInstanceBase
---@field BSStart UBlendSpace
---@field BSEnd UBlendSpace
---@field CardinalDirectionBlendTime float
---@field AnimTurnInPlaceLeft UAnimSequence
---@field AnimTurnInPlaceRight UAnimSequence
---@field BSWalkFwd UBlendSpace
---@field BSWalkBwd UBlendSpace
---@field BSWalkLeft UBlendSpace
---@field BSWalkRight UBlendSpace
---@field BSRunFwd UBlendSpace
---@field BSRunBwd UBlendSpace
---@field BSRunLeft UBlendSpace
---@field BSRunRight UBlendSpace
---@field BSSprint UBlendSpace
---@field AnimIdle UAnimSequence
---@field Speed float
---@field VerticleSpeed float
---@field HorizontalSpeed float
---@field bHasRun boolean
---@field JogBaseSpeed float
---@field RunSpeed float
---@field SprintSpeed float
---@field IsFalling boolean
---@field LeanAngle float
---@field SlopeRightAngle float
---@field SlopeForwardAngle float
---@field SpeedWarpAmount float
---@field BSStartX float
---@field BSStartY float
---@field BSStopX float
---@field BSStopY float
---@field BSStopNoBreakX float
---@field BSStopNoBreakY float
---@field bLoopToIdle boolean
---@field bLoopToStop boolean
---@field bLoopToStopWithNoBreak boolean
---@field bStartToLoop boolean
---@field bIdleToLoop boolean
---@field bIdleToStart boolean
---@field bStartToIdle boolean
---@field bStopToIdle boolean
---@field bStopWithNoBreakToIdle boolean
---@field LocomotionCardinalDirection CardinalDir
---@field LocomotionOrientationAngle float
---@field AnimFallingStart UAnimSequence
---@field AnimFallingLoop UAnimSequence
---@field AnimFallingLand UAnimSequence
---@field FallingLoopPlayRate float
---@field bHasJumpAnimAsset boolean
UBUAnimHumanoidCS_Simple4Dir = {}



---@class UBUAnimHumanoidCS_SpecialMove : UBUAnimHumanoidCS_LinkedInstanceBase
---@field bHasMoveInput boolean
---@field bHasPlayerInput boolean
---@field Speed float
---@field MappedSpeed float
---@field SpecialMovementMode SpecialMovementMode
---@field LastSpecialMovementMode SpecialMovementMode
---@field bGroundMoving boolean
---@field MaxAnimWeightLockMoveDir LockMoveDirectionSix
---@field ASGlideStartGroundFlatSlow UAnimSequence
---@field ASGlideStartGroundFlatFast UAnimSequence
---@field ASGlideStartGroundSteepSlow UAnimSequence
---@field ASGlideStartGroundSteepFast UAnimSequence
---@field ASGlideStartAirFlatSlow UAnimSequence
---@field ASGlideStartAirFlatFast UAnimSequence
---@field ASGlideStartAirSteepSlow UAnimSequence
---@field ASGlideStartAirSteepFast UAnimSequence
---@field ASGlideStartBackAirFlat UAnimSequence
---@field ASGlideStartBackAirSteep UAnimSequence
---@field GlideStartSpeedBlendAlpha float
---@field ASGlideLoopSteep UAnimSequence
---@field BSGlideLoopSteepAdditive UBlendSpace
---@field ASGlideLoopFlatSlow UAnimSequence
---@field ASGlideLoopFlatFast UAnimSequence
---@field BSGlideLoopFlatSlowDirAdditive UBlendSpace
---@field BSGlideLoopFlatFastDirAdditive UBlendSpace
---@field GlideLoopDirAdditiveX float
---@field GlideLoopDirAdditiveY float
---@field BSGlideLoopFlatVerticalInputAdditive UBlendSpace
---@field BSGlideLoopFlatVerticalInputAdditiveY float
---@field GlideLoopSpeedBlendAlpha float
---@field BSGlideLoopFlatHorizonalInputAdditive UBlendSpace
---@field BSGlideLoopFlatHorizonalInputAdditiveX float
---@field ASGlideLoopFlatRotationLeftAdditive UAnimSequence
---@field ASGlideLoopFlatRotationRightAdditive UAnimSequence
---@field ASGlideEndSlow UAnimSequence
---@field ASGlideEndFast UAnimSequence
---@field bGlideMoving boolean
---@field bParkourMoving boolean
---@field ASParkourLowClimbStart UAnimSequence
---@field ASParkourLowClimbGetUp UAnimSequence
---@field ASParkourLowClimbFallLoop UAnimSequence
---@field ASParkourLowClimbLand UAnimSequence
---@field ASParkourLowClimbLandMove UAnimSequence
---@field ASParkourNormalClimbStart UAnimSequence
---@field ASParkourNormalClimbGetUp UAnimSequence
---@field ASParkourNormalClimbFallLoop UAnimSequence
---@field ASParkourNormalClimbLand UAnimSequence
---@field ASParkourNormalClimbLandMove UAnimSequence
---@field ASParkourHighClimbStart UAnimSequence
---@field ASParkourHighClimbGetUp UAnimSequence
---@field ASParkourHighClimbFallLoop UAnimSequence
---@field ASParkourHighClimbLand UAnimSequence
---@field ASParkourHighClimbLandMove UAnimSequence
---@field ASParkourLowAcrossStart UAnimSequence
---@field ASParkourLowAcrossThrough UAnimSequence
---@field ASParkourLowAcrossFallLoop UAnimSequence
---@field ASParkourLowAcrossLand UAnimSequence
---@field ASParkourLowAcrossLandMove UAnimSequence
---@field ASParkourNormalAcrossStart UAnimSequence
---@field ASParkourNormalAcrossThrough UAnimSequence
---@field ASParkourNormalAcrossFallLoop UAnimSequence
---@field ASParkourNormalAcrossLand UAnimSequence
---@field ASParkourNormalAcrossLandMove UAnimSequence
---@field ASParkourHighAcrossStart UAnimSequence
---@field ASParkourHighAcrossThrough UAnimSequence
---@field ASParkourHighAcrossFallLoop UAnimSequence
---@field ASParkourHighAcrossLand UAnimSequence
---@field ASParkourHighAcrossLandMove UAnimSequence
---@field ASStrideUpLeftFootLow UAnimSequence
---@field ASStrideUpRightFootLow UAnimSequence
---@field ASStrideUpLeftFootHigh UAnimSequence
---@field ASStrideUpRightFootHigh UAnimSequence
---@field ASStrideUpLeftFootFall UAnimSequence
---@field ASStrideUpRightFootFall UAnimSequence
---@field ASStrideUpLeftFootEnd UAnimSequence
---@field ASStrideUpRightFootEnd UAnimSequence
---@field ASStrideUpLeftFootLandMove UAnimSequence
---@field ASStrideUpRightFootLandMove UAnimSequence
---@field ASStrideDownLeftFoot UAnimSequence
---@field ASStrideDownRightFoot UAnimSequence
---@field ASStrideDownLeftFootFall UAnimSequence
---@field ASStrideDownRightFootFall UAnimSequence
---@field ASStrideDownLeftFootEnd UAnimSequence
---@field ASStrideDownRightFootEnd UAnimSequence
---@field ASStrideDownLeftFootLandMove UAnimSequence
---@field ASStrideDownRightFootLandMove UAnimSequence
---@field bIsInAir boolean
---@field bAirMoving boolean
---@field StartJumpDir SkillDirection
---@field bIsJumpStartFast boolean
---@field bInJump boolean
---@field bIsLittleFall boolean
---@field bHasFallAnimAsset boolean
---@field StartJumpSpdState StartJumpSpdState
---@field BSJumpStart_F UBlendSpace
---@field BSJumpStart_B UBlendSpace
---@field BSJumpLoop_F UBlendSpace
---@field BSJumpLoop_B UBlendSpace
---@field BSJumpAdditiveLean UBlendSpace
---@field BSJumpAdditiveRot UBlendSpace
---@field AnimGroundJumpStart UAnimSequence
---@field AnimJumpStart_N UAnimSequence
---@field AnimJumpStart_F UAnimSequence
---@field AnimJumpStart_L UAnimSequence
---@field AnimJumpStart_R UAnimSequence
---@field AnimJumpStart_B UAnimSequence
---@field AnimGlideJumpStart UAnimSequence
---@field AnimFallStart UAnimSequence
---@field AnimFallStart_N UAnimSequence
---@field AnimFallStart_F UAnimSequence
---@field AnimFallStart_L UAnimSequence
---@field AnimFallStart_R UAnimSequence
---@field AnimFallStart_B UAnimSequence
---@field AnimFallLoop UAnimSequence
---@field FallHeightType FallHeightType_V2
---@field FallHeight float
---@field AnimLand_F_Low UAnimSequence
---@field AnimLand_F_Mid UAnimSequence
---@field AnimLand_F_High UAnimSequence
---@field AnimLand_L UAnimSequence
---@field AnimLand_R UAnimSequence
---@field AnimLand_B UAnimSequence
---@field bIsInLandCantMoveTime boolean
---@field StartMoveAfterJump UAnimSequence
---@field AddtiveMoveAfterJump_F UAnimSequence
---@field AddtiveMoveAfterJump_B UAnimSequence
---@field AddtiveMoveAfterJump_L UAnimSequence
---@field AddtiveMoveAfterJump_R UAnimSequence
---@field AdditiveMoveAfterJumpFAlpha float
---@field AdditiveMoveAfterJumpBAlpha float
---@field AdditiveMoveAfterJumpLAlpha float
---@field AdditiveMoveAfterJumpRAlpha float
---@field BSJumpAdditiveLeanX float
---@field BSJumpAdditiveLeanY float
---@field LandPredictionAlpha float
---@field BSJumpAdditiveRotX float
---@field BSJumpAdditiveRotY float
---@field LandAdditiveAlpha float
---@field VelocityDeltaAngle float
---@field VelocityDeltaAngleTrans float
---@field bSplineMoving boolean
---@field bSplineMoveForward boolean
---@field bSplineMoveSharpturn boolean
---@field bSplineMoveReSharpturn boolean
---@field bSplineMoveCanExitSharpturn boolean
---@field bSplineMoveStopToStart boolean
---@field bSplineMoveStopToLoop boolean
---@field SharpturnAngle float
---@field ASSplineMoveIdleForward UAnimSequence
---@field ASSplineMoveIdleBackward UAnimSequence
---@field ASSplineMoveStartForward UAnimSequence
---@field ASSplineMoveStartBackward UAnimSequence
---@field ASSplineMoveLoopForward UAnimSequence
---@field ASSplineMoveLoopBackward UAnimSequence
---@field ASSplineMoveStopForward UAnimSequence
---@field ASSplineMoveStopBackward UAnimSequence
---@field ASSplineMoveTurnF2B UAnimSequence
---@field ASSplineMoveTurnB2F UAnimSequence
---@field AnimCloudFallStart UAnimSequence
---@field AnimCloudFallLoop UAnimSequence
---@field bGlideEndToGroundMove boolean
---@field bAirStartGlide boolean
---@field bGlideFlat boolean
---@field bGlideSteep boolean
---@field bGlideStartFront boolean
---@field bGlideStartBack boolean
---@field bGlideLoopRotationLeft boolean
---@field bGlideLoopRotationRight boolean
---@field bGlideEndSlow boolean
---@field bGlideEndFast boolean
---@field bToFall boolean
---@field bToGroundJumpStart boolean
---@field bToGroundJumpStartFwd boolean
---@field bToGroundJumpStartBwd boolean
---@field bToGlideJumpStart boolean
---@field bToLandAdditive boolean
---@field bStride boolean
---@field bStrideJump boolean
---@field bStrideUpJump boolean
---@field bStrideDownJump boolean
---@field bStrideUp boolean
---@field bStrideDown boolean
---@field bStrideUpLand boolean
---@field bStrideDownLand boolean
---@field bStrideUpHigh boolean
---@field bStrideUpLow boolean
---@field bCloudFall boolean
---@field bLeaveGlideMoving boolean
---@field bParkourClimb boolean
---@field bParkourAcross boolean
---@field bParkourLow boolean
---@field bParkourNormal boolean
---@field bParkourHigh boolean
---@field bParkourFall boolean
---@field bLandAnimToGround boolean
---@field bLockMoveJumpF boolean
---@field bLockMoveJumpFL boolean
---@field bLockMoveJumpFR boolean
---@field bLockMoveJumpBL boolean
---@field bLockMoveJumpBR boolean
---@field bLockMoveJumpB boolean
---@field bToStride boolean
---@field bStrideContinue boolean
---@field bLeftFootFront boolean
---@field bToLandAnim boolean
---@field bToLandMove boolean
---@field bSwitchToLock boolean
UBUAnimHumanoidCS_SpecialMove = {}

---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_SpecialMove:SetupLandAnim(Context, Node) end
---@param AnimCloudLand UAnimSequence
function UBUAnimHumanoidCS_SpecialMove:GetAnimCloudLand(AnimCloudLand) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_SpecialMove:UpdateGroundJump(Context, Node) end
---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimHumanoidCS_SpecialMove:UpdateGroundAdditive(Context, Node) end


---@class UBUAnimHumanoidCS_UpperBodySeparation : UBUAnimHumanoidCS_LinkedInstanceBase
---@field UpperBodyBlendWeight float
---@field BSUpperBodyBlendAdditive UBlendSpace
---@field BSUpperBodyBlendAdditiveX float
---@field BSUpperBodyBlendAdditiveY float
UBUAnimHumanoidCS_UpperBodySeparation = {}



---@class UBUAnimInsect : UBUAnimInstanceBase
---@field FinalABPMoveMode EABPMoveMode
UBUAnimInsect = {}



---@class UBUAnimInstanceBase : UAnimInstance
---@field ABPSetting UBGWDataAsset_AbpHumanoidSetting
UBUAnimInstanceBase = {}

function UBUAnimInstanceBase:BlueprintInitializeAnimation() end


---@class UBUAnimInteractiveActor : UAnimInstance
---@field ABPSetting UBGWDataAsset_AnimInteractiveActorSetting
---@field AnimIdle UAnimSequence
UBUAnimInteractiveActor = {}

function UBUAnimInteractiveActor:BlueprintInitializeAnimation() end


---@class UBUAnimModularMesh : UAnimInstance
---@field LoopAnimation UAnimSequence
---@field bStopCopyPose boolean
---@field MappedSpeed float
---@field FakeInertia FVector
---@field SpeedToInertiaScale float
---@field MinInertiaFactor float
UBUAnimModularMesh = {}

function UBUAnimModularMesh:BlueprintInitializeAnimation() end
---@param DeltaTime float
function UBUAnimModularMesh:BlueprintThreadSafeUpdateAnimation(DeltaTime) end


---@class UBUAnimPerformer : UAnimInstance
---@field ABPSetting UBGWDataAsset_AbpPerformerSetting
---@field EnableHeadAimOffset boolean
---@field HeadAimLookAtRotation FRotator
---@field HeadAimAlpha float
---@field AimOffsetMappingCurve UCurveVector
---@field EnableEyeAimOffset boolean
---@field EyeAimLookAtRotation FRotator
---@field EyeAimAlpha float
---@field bCanSwitchBlinkAnim boolean
---@field AnimIdle UAnimSequence
---@field HeadAimOffset UAimOffsetBlendSpace
---@field EyeAimOffset UAimOffsetBlendSpace
UBUAnimPerformer = {}

---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimPerformer:GetRandomBlinkAnim(Context, Node) end
---@param DeltaTimeX float
function UBUAnimPerformer:BlueprintUpdateAnimation(DeltaTimeX) end
function UBUAnimPerformer:BlueprintInitializeAnimation() end


---@class UBUAnimQuadruped : UBUAnimInstanceBase
---@field AnimIdle UAnimSequence
---@field FinalABPMoveMode EABPMoveMode
---@field QuadrupedIKAlpha float
UBUAnimQuadruped = {}

---@param DeltaTime float
function UBUAnimQuadruped:BlueprintThreadSafeUpdateAnimation(DeltaTime) end


---@class UBUAnimShadowInstanceBase : UAnimInstance
---@field Snapshot FPoseSnapshot
UBUAnimShadowInstanceBase = {}



---@class UBUAnimSimple : UAnimInstance
---@field AnimIdleList TArray<UAnimSequence>
UBUAnimSimple = {}

---@param Context FAnimUpdateContext
---@param Node FAnimNodeReference
function UBUAnimSimple:GetRandomIdleAnim(Context, Node) end
function UBUAnimSimple:BlueprintInitializeAnimation() end


---@class UBUAnimWheel : UBUAnimInstanceBase
---@field ASIdle UAnimSequence
---@field ASSpeedUp UAnimSequence
---@field ASSpeedDown UAnimSequence
---@field ASMoveLoop UAnimSequence
---@field MovePlayRate float
---@field BSRotationAdditive UBlendSpace
---@field BSRotationAdditiveX float
---@field bIdleToSpeedUp boolean
---@field bLoopToIdle boolean
---@field bIdleToLoop boolean
UBUAnimWheel = {}

---@param DeltaTimeX float
function UBUAnimWheel:BlueprintUpdateAnimation(DeltaTimeX) end


---@class UBUAnim_PostProcess : UAnimInstance
---@field AttackOffset_Alpha float
---@field AttackOffset_AttackOffsetType AttackOffsetType
---@field AttackOffset_WorldRotOffset FQuat
UBUAnim_PostProcess = {}

---@param DeltaTimeX float
function UBUAnim_PostProcess:BlueprintUpdateAnimation(DeltaTimeX) end
function UBUAnim_PostProcess:BlueprintInitializeAnimation() end


---@class UBUAnim_PostProcess_Quadruped : UAnimInstance
---@field IKSpinePitch float
---@field IKSpineRoll float
---@field IKSpineAlpha float
---@field LimbIKAlpha float
---@field LimbIKEffectorList TArray<FEffectorData>
---@field EnableAttackIK boolean
---@field AttackIKRollList TArray<float>
---@field AttackIKPitchList TArray<float>
---@field RootName FName
---@field SolverRootBoneNameList TArray<FName>
---@field SolverEffectorBoneNameList TArray<FName>
UBUAnim_PostProcess_Quadruped = {}

---@param DeltaTimeX float
function UBUAnim_PostProcess_Quadruped:BlueprintUpdateAnimation(DeltaTimeX) end
function UBUAnim_PostProcess_Quadruped:BlueprintInitializeAnimation() end


---@class UBUAnim_PostProcess_Wukong : UAnimInstance
---@field Alpha_FBIK_StandBar float
---@field SlowIK_Alpha float
---@field SlowIK_Enable boolean
---@field SlowIKType SlowIKType
---@field LockTransform_Local FTransform
---@field Relative_l_in_r FTransform
---@field Relative_r_in_l FTransform
UBUAnim_PostProcess_Wukong = {}

---@param DeltaTimeX float
function UBUAnim_PostProcess_Wukong:BlueprintUpdateAnimation(DeltaTimeX) end
function UBUAnim_PostProcess_Wukong:BlueprintInitializeAnimation() end


---@class UBUAnimationAnalyzer : UAnimationAnalyzer
UBUAnimationAnalyzer = {}

---@param OrgAA UAnimationAnalyzer
---@return UBUAnimationAnalyzer
function UBUAnimationAnalyzer:GenerateNewAACSAsset(OrgAA) end
---@param ABP_Setting UBGWDataAsset_AbpHumanoidSetting
---@param OrgAAPackageName FString
---@return boolean
function UBUAnimationAnalyzer:FindABPSettingSameToAA(ABP_Setting, OrgAAPackageName) end
---@param ABP_Setting UBGWDataAsset_AbpHumanoidSetting
---@param OrgAAPackageName FString
---@return boolean
function UBUAnimationAnalyzer:AddToABPSettingSameToAA(ABP_Setting, OrgAAPackageName) end
---@param Ref int32
---@param Owner AActor
function UBUAnimationAnalyzer:MMAnimationSeqUsingNotify_Inner(Ref, Owner) end
---@param Ref int32
---@return boolean
function UBUAnimationAnalyzer:CheckIsFirstLoadRequireDesireAsset(Ref) end
---@param Ref int32
---@param bLoadAll boolean
---@param Obj UObject
---@return int32
function UBUAnimationAnalyzer:RequireAnimationsLoadAtDesiredReferences(Ref, bLoadAll, Obj) end


---@class UBUC_CutDeathData : UObject
UBUC_CutDeathData = {}


---@class UBUC_DBCCustomEventExampleDataAsset : UDispLibDBCCustomEventDataAssetBase
---@field MyBool boolean
---@field MyLinearColor FLinearColor
UBUC_DBCCustomEventExampleDataAsset = {}



---@class UBUC_DispB1ConstDataAsset : UBGW_DispLibConstDataAsset
---@field DBCDefaultCamOffset float
UBUC_DispB1ConstDataAsset = {}



---@class UBUC_DispLibDBCPermanentWEFMMotorDataAsset : UBGWDataAsset
---@field BaseWindMotor TArray<FBUC_DispLibDBC_WEFMPermanentWind>
---@field BaseHeatMotor TArray<FBUC_DispLibDBC_Heat>
UBUC_DispLibDBCPermanentWEFMMotorDataAsset = {}



---@class UBUC_DispLibDispBaseConfigDataAsset : UBGWDataAsset
---@field PlayCascade TArray<FBUC_DispLibDBC_PlayCascade>
---@field PlayNiagara TArray<FBUC_DispLibDBC_PlayNiagara>
---@field PlayAdvanceNiagara TArray<FBUC_DispLibDBC_PlayAdvanceNiagara>
---@field PlayArtFresnel TArray<FBUC_DispLibDBC_PlayArtFresnel>
---@field PlayCameraShake TArray<FBUC_DispLibDBC_PlayCameraShake>
---@field PlayCustomCameraShake TArray<FBUC_DispLibDBC_PlayCustomCameraShake>
---@field PlayAudio TArray<FBUC_DispLibDBC_PlayAudio>
---@field SpawnSimpleActor TArray<FBUC_DispLibDBC_SpawnSimpleActor>
---@field WEFMWind TArray<FBUC_DispLibDBC_WEFMWind>
---@field ScenePhysicalInteractor TArray<FBUC_DispLibDBC_ScenePhysicalInteractor>
---@field ChangeMaterial TArray<FBUC_DispLibDBC_ChangeMaterial>
---@field ModifyMaterial TArray<FBUC_DispLibDBC_ModifyMaterial>
---@field ModifyNiagaraParams TArray<FBUC_DispLibDBC_ModifyNiagaraParams>
---@field ModifyMPCParams TArray<FBUC_DispLibDBC_ModifyMaterialParameterCollection>
---@field CustomEvents TArray<FBUC_DispLibDBC_CustomEvent>
---@field MetaString FName
---@field DelayDestroyTime float
UBUC_DispLibDispBaseConfigDataAsset = {}



---@class UBUC_DispLibSceneInteractorData : UBGWDataAsset
---@field ScenePhysicalInteractor TArray<FBUC_DispLibDBC_ScenePhysicalInteractor>
UBUC_DispLibSceneInteractorData = {}



---@class UBUC_DispLibUnitArtFresnelDataAsset : UBGWDataAsset
---@field Time float
---@field OnePeriodTime float
---@field SimpleProgrammedCurve boolean
---@field FadeInTime float
---@field CommonTime float
---@field FadeOutTime float
---@field ProgrammedPowerMax float
---@field Loop boolean
---@field InvertGSArtFresnel boolean
---@field UseVertexNormalNotTex boolean
---@field UseContrastInsteadPower boolean
---@field BrightValue float
---@field DarkValue float
---@field GSArtFresnelPower UCurveFloat
---@field ClampGSArtFresnelDotProduct boolean
---@field UseHeightGradientRamp boolean
---@field BottomAlpha float
---@field TopAlpha float
---@field FColor_Out UCurveLinearColor
---@field FColor_In UCurveLinearColor
UBUC_DispLibUnitArtFresnelDataAsset = {}



---@class UBUC_PerformerMappingConfigDataAsset : UBGWDataAsset
---@field PerformerTagMapping TMap<TSubclassOf<ABGUPerformerActorCS>, FPerformerTag>
UBUC_PerformerMappingConfigDataAsset = {}



---@class UBUC_ProceduralSpawnSceneItemData : UObject
UBUC_ProceduralSpawnSceneItemData = {}


---@class UBUI_AbnormalStateAcc_Box : UBUI_Widget
---@field MoveUp_Duration float
---@field MoveUp_FuncType EEasingFunc::Type
---@field MoveDown_Duration float
---@field MoveDown_FuncType EEasingFunc::Type
---@field Hidden_Duration float
UBUI_AbnormalStateAcc_Box = {}



---@class UBUI_AnimWidget : UUserWidget
UBUI_AnimWidget = {}

---@param Param int32
function UBUI_AnimWidget:OnAnimationSequenceEvent(Param) end


---@class UBUI_AutoTestMgrPanel : UBUI_Widget
UBUI_AutoTestMgrPanel = {}


---@class UBUI_BarBase : UBUI_Widget
---@field OffsetFadeDuration float
---@field ProcBarTweenDelay float
---@field ProcBarTweenDuration float
---@field ProcBarTweenFuncType EEasingFunc::Type
---@field MainBarTweenDelay float
---@field MainBarTweenDuration float
---@field MainBarTweenFuncType EEasingFunc::Type
---@field MainBarIncTweenFuncType EEasingFunc::Type
---@field IsIgnoreIncExTweenAnim boolean
---@field MainBarIncTweenLinearSpeed float
UBUI_BarBase = {}



---@class UBUI_BarCSharp : UBUI_Widget
---@field CurValue float
---@field CurMaxValue float
---@field FrameInitPadding FMargin
---@field IS_SHOW_U_INTER_TOTAL_NUM boolean
---@field IS_SHOW_BAR_VALUE_NUM boolean
---@field CONF_INTER_PLAY_TIME float
---@field CONF_INTER_TIME_COUNT float
---@field FloatingTransform FWidgetTransform
---@field FloatingImageBrush FSlateBrush
---@field UninterruptMaxValue float
---@field FloatBarCls UClass
UBUI_BarCSharp = {}

---@param DecreaseValueIn float
function UBUI_BarCSharp:ValueDecrease(DecreaseValueIn) end
---@param IncreaseValueIn float
function UBUI_BarCSharp:ValueIncrease(IncreaseValueIn) end
---@param InValue float
function UBUI_BarCSharp:ChangeMaxValue(InValue) end
---@param ChangeValue float
function UBUI_BarCSharp:BarChangeValue(ChangeValue) end
---@return float
function UBUI_BarCSharp:CalcCurBarLength() end
---@param inBarSlot UNamedSlot
---@param InValue float
function UBUI_BarCSharp:UpdateBarByValue(inBarSlot, InValue) end
---@param InBarWidget UWidget
---@param InBarLength float
function UBUI_BarCSharp:UpdateBarByLength(InBarWidget, InBarLength) end
---@param InValue float
function UBUI_BarCSharp:UpdateCurMaxValue(InValue) end
---@param DecreaseValueIn float
function UBUI_BarCSharp:UninterruptDecrease(DecreaseValueIn) end
---@param InValue float
---@return float
function UBUI_BarCSharp:CalcBarLengthByValue(InValue) end
---@param InMaxValue float
---@param InCurValue float
---@param InIsReCalcMaxLen boolean
function UBUI_BarCSharp:InitSetCurAndMaxValue(InMaxValue, InCurValue, InIsReCalcMaxLen) end
---@param inBarSlot UNamedSlot
function UBUI_BarCSharp:UpdateBarWithCurLength(inBarSlot) end
function UBUI_BarCSharp:PlayUninterruptBarAnimation() end


---@class UBUI_BarFloat : UBUI_Widget
---@field WAE_ShowInFinished FBUI_BarFloatWAE_ShowInFinished
UBUI_BarFloat = {}

function UBUI_BarFloat:OnAnimationFinished() end


---@class UBUI_BarMatBase : UBUI_Widget
---@field LineMarkScaleCurve UCurveVector
---@field OffsetFadeDuration float
---@field ProcBarTweenDelay float
---@field ProcBarTweenDuration float
---@field ProcBarTweenFuncType EEasingFunc::Type
---@field MainBarTweenDelay float
---@field MainBarTweenDuration float
---@field MainBarTweenFuncType EEasingFunc::Type
---@field MainBarIncTweenFuncType EEasingFunc::Type
---@field IsIgnoreIncExTweenAnim boolean
---@field MainBarIncTweenLinearSpeed float
---@field DebuffTweenDelay float
---@field DebuffTweenDuration float
---@field DebuffTweenFuncType EEasingFunc::Type
UBUI_BarMatBase = {}



---@class UBUI_BarTimeCount : UBUI_Widget
UBUI_BarTimeCount = {}


---@class UBUI_BattleInfoCS : UBUI_Widget
UBUI_BattleInfoCS = {}


---@class UBUI_BattleMainCS : UBUI_Widget
UBUI_BattleMainCS = {}


---@class UBUI_BossBar : UBUI_EnemyBloodBarPure
---@field OwnerCharacter AActor
UBUI_BossBar = {}

---@param InOwnerCharacter AActor
function UBUI_BossBar:GSInit(InOwnerCharacter) end


---@class UBUI_BulletDebugInfo : UBUI_ProjectileDebugInfo
UBUI_BulletDebugInfo = {}


---@class UBUI_Button : UBUI_Widget
---@field UIDataConfigMap TMap<ButtonUIStat, FFUIData>
---@field GSTextColorType TextColorType
---@field GSButtonUIStat ButtonUIStat
---@field GSParentButtonUIStat ButtonUIStat
---@field GSButtonStat ButtonStat
---@field PreChilds TArray<UBUI_Button>
---@field PreChildNames TArray<FString>
---@field Parent UBUI_Button
---@field Childs TArray<UBUI_Button>
---@field AnimReverseSpeed float
---@field IsSelectedUseLayer boolean
---@field MouseMoveHoverType MouseMoveHoverType
---@field IsMouseEnterSetFocus boolean
---@field IsFocusSetActive boolean
---@field IsActiveUseInput boolean
---@field IsTopUseInput boolean
---@field KeyBoardShowFocusType KeyBoardShowFocusType
---@field FocusAudioEvent UAkAudioEvent
---@field HoveredAudioEvent UAkAudioEvent
---@field ActiveAudioEvent UAkAudioEvent
---@field ClickAudioEvent UAkAudioEvent
---@field LockClickAudioEvent UAkAudioEvent
---@field MouseStayEventTime float
---@field UseAlphaTest boolean
---@field Debug boolean
---@field OnSetBtnStateEvent FBUI_ButtonOnSetBtnStateEvent
UBUI_Button = {}

---@param Reason FocusReason
---@return boolean
function UBUI_Button:SetFocusOn(Reason) end
---@param MyGeometry FGeometry
---@param InKeyEvent FKeyEvent
---@return FEventReply
function UBUI_Button:OnKeyUp(MyGeometry, InKeyEvent) end
---@param InIsMouseEnterSetFocus boolean
function UBUI_Button:SetIsMouseEnterSetFocus(InIsMouseEnterSetFocus) end
---@return boolean
function UBUI_Button:GetIsMouseEnterSetFocus() end
---@param Navigation EUINavigation
---@return UWidget
function UBUI_Button:OnCustomWidgetNavigation(Navigation) end
---@param MyGeometry FGeometry
---@param InKeyEvent FKeyEvent
---@return FEventReply
function UBUI_Button:OnKeyDown(MyGeometry, InKeyEvent) end
---@param MyGeometry FGeometry
---@param MouseEvent FPointerEvent
---@return FEventReply
function UBUI_Button:OnMouseMove(MyGeometry, MouseEvent) end
---@param MouseEvent FPointerEvent
function UBUI_Button:OnMouseLeave(MouseEvent) end
---@param MyGeometry FGeometry
---@param MouseEvent FPointerEvent
function UBUI_Button:OnMouseEnter(MyGeometry, MouseEvent) end
---@param MyGeometry FGeometry
---@param MouseEvent FPointerEvent
---@return FEventReply
function UBUI_Button:OnMouseButtonUp(MyGeometry, MouseEvent) end
---@param MyGeometry FGeometry
---@param InKeyEvent FKeyEvent
---@return FEventReply
function UBUI_Button:OnPreviewKeyDown(MyGeometry, InKeyEvent) end
---@param MyGeometry FGeometry
---@param MouseEvent FPointerEvent
---@return FEventReply
function UBUI_Button:OnMouseButtonDown(MyGeometry, MouseEvent) end
---@param InFocusEvent FFocusEvent
function UBUI_Button:OnAddedToFocusPath(InFocusEvent) end
---@param MyGeometry FGeometry
---@param InAnalogInputEvent FAnalogInputEvent
---@return FEventReply
function UBUI_Button:OnAnalogValueChanged(MyGeometry, InAnalogInputEvent) end
---@param InMyGeometry FGeometry
---@param InMouseEvent FPointerEvent
---@return FEventReply
function UBUI_Button:OnMouseButtonDoubleClick(InMyGeometry, InMouseEvent) end


---@class UBUI_ButtonCompare : UBUI_ButtonLongPressV2
---@field CurUIDataConfigMap TMap<ButtonUIStat, FFUIData>
---@field SelectUIDataConfigMap TMap<ButtonUIStat, FFUIData>
---@field IsSelect boolean
UBUI_ButtonCompare = {}



---@class UBUI_ButtonLongPressV2 : UBUI_Button
---@field PressStartTime float
---@field PressTimeMax float
---@field CurPressTime float
---@field OverFadeOutTime float
---@field StartPressAudioEvent UAkAudioEvent
---@field StopPressAudioEvent UAkAudioEvent
---@field FinishPressAudioEvent UAkAudioEvent
---@field SpecialNormalUIDataConfigMap TMap<ButtonUIStat, FFUIData>
---@field IsSpecial boolean
UBUI_ButtonLongPressV2 = {}



---@class UBUI_ButtonNone : UBUI_Button
---@field NoneUIDataConfigMap TMap<ButtonUIStat, FFUIData>
---@field NormalUIDataConfigMap TMap<ButtonUIStat, FFUIData>
---@field IsNone boolean
UBUI_ButtonNone = {}



---@class UBUI_ButtonSpecialNone : UBUI_ButtonNone
---@field SpecialNoneUIDataConfigMap TMap<ButtonUIStat, FFUIData>
---@field SpecialNormalUIDataConfigMap TMap<ButtonUIStat, FFUIData>
---@field IsSpecial boolean
UBUI_ButtonSpecialNone = {}



---@class UBUI_ButtonSpellItemV2 : UBUI_Button
---@field NoneUIDataConfigMap TMap<ButtonUIStat, FFUIData>
---@field InitiativeUIDataConfigMap TMap<ButtonUIStat, FFUIData>
---@field WearInitiativeUIDataConfigMap TMap<ButtonUIStat, FFUIData>
---@field PassiveUIDataConfigMap TMap<ButtonUIStat, FFUIData>
---@field WearPassiveUIDataConfigMap TMap<ButtonUIStat, FFUIData>
---@field IsInitiative boolean
---@field IsNone boolean
---@field IsWear boolean
UBUI_ButtonSpellItemV2 = {}



---@class UBUI_ButtonTalentItemV2 : UBUI_Button
---@field NotLearnUIDataConfigMap TMap<ButtonUIStat, FFUIData>
---@field HasLearnUIDataConfigMap TMap<ButtonUIStat, FFUIData>
---@field MaxLearnUIDataConfigMap TMap<ButtonUIStat, FFUIData>
---@field CurTalentState TalentState
UBUI_ButtonTalentItemV2 = {}



---@class UBUI_ChapterRoam : UBUI_Widget
UBUI_ChapterRoam = {}


---@class UBUI_CommErrorTips : UBUI_Widget
UBUI_CommErrorTips = {}

function UBUI_CommErrorTips:OnConfirmButtonDown() end


---@class UBUI_ConnectInfoPanel : UBUI_Widget
UBUI_ConnectInfoPanel = {}


---@class UBUI_Cursor : UBUI_CursorBase
---@field ScrollInputParams FScrollInputData
---@field ScrollParams FScrollData
---@field NeedUpdateParams boolean
UBUI_Cursor = {}



---@class UBUI_CursorBase : UBUI_Widget
---@field IsForceShowCursor boolean
---@field IsShowImgCursor boolean
---@field CursorRadius float
---@field MovePower float
---@field ResistancePower float
---@field GravitationPowerCurve UCurveFloat
---@field CursorMoveDelay float
---@field CanvasOffsetCoeList TArray<FVector2D>
---@field MouseCanvasOffsetCoe float
---@field ScrollCanvasOffsetCoe float
UBUI_CursorBase = {}



---@class UBUI_CursorMap : UBUI_Widget
---@field CursorRadius float
---@field RangeRadius float
---@field ScaleCoe float
---@field MousePowerCoe float
---@field MovePower float
---@field CursorMoveDelay float
---@field ToPosSpeed float
UBUI_CursorMap = {}



---@class UBUI_DataValidatePanel : UBUI_Widget
UBUI_DataValidatePanel = {}

function UBUI_DataValidatePanel:OnClickClose() end
function UBUI_DataValidatePanel:OnClickOpenLog() end
---@param bIsChecked boolean
function UBUI_DataValidatePanel:OnCheckDisplayFull(bIsChecked) end


---@class UBUI_DebugComm : UBUI_Widget
---@field OwnerActor AActor
UBUI_DebugComm = {}

function UBUI_DebugComm:Destruct() end


---@class UBUI_DebugDrawRoundRect : UBUI_Widget
---@field RefRoundWidgetSize float
---@field DebugDrawThickness float
UBUI_DebugDrawRoundRect = {}

function UBUI_DebugDrawRoundRect:UpdateShow() end
---@param InRadiusCfg FVector4
function UBUI_DebugDrawRoundRect:SetRadiusCfg(InRadiusCfg) end
function UBUI_DebugDrawRoundRect:ConstructDebugShow() end
---@param RefPos FVector2D
function UBUI_DebugDrawRoundRect:SetRefRectPosCenter(RefPos) end


---@class UBUI_DependWidget : UBUI_Widget
---@field DependType DependType
---@field DependItem UWidget
---@field DependAlignment FVector2D
---@field Offset FVector2D
---@field NeedSafeZone boolean
---@field TickUpdatePos boolean
UBUI_DependWidget = {}

function UBUI_DependWidget:TryUpdateDependPos() end


---@class UBUI_DraggableV2 : UBUI_Widget
UBUI_DraggableV2 = {}

---@param MyGeometry FGeometry
---@param InDeltaTime float
function UBUI_DraggableV2:Tick(MyGeometry, InDeltaTime) end
---@param MyGeometry FGeometry
---@param MouseEvent FPointerEvent
---@return FEventReply
function UBUI_DraggableV2:OnMouseMove(MyGeometry, MouseEvent) end
---@param MouseEvent FPointerEvent
function UBUI_DraggableV2:OnMouseLeave(MouseEvent) end
---@param MyGeometry FGeometry
---@param MouseEvent FPointerEvent
---@return FEventReply
function UBUI_DraggableV2:OnMouseButtonUp(MyGeometry, MouseEvent) end
---@param MouseEvent FPointerEvent
---@param Operation UDragDropOperation
function UBUI_DraggableV2:OnDragCancelled(MouseEvent, Operation) end
---@param MyGeometry FGeometry
---@param MouseEvent FPointerEvent
---@return FEventReply
function UBUI_DraggableV2:OnMouseButtonDown(MyGeometry, MouseEvent) end
---@param MyGeometry FGeometry
---@param MouseEvent FPointerEvent
---@return FEventReply
function UBUI_DraggableV2:OnPreviewMouseButtonDown(MyGeometry, MouseEvent) end


---@class UBUI_EndCreditsItem : UBUI_Widget
---@field DependWidgetList TArray<UWidget>
---@field DataJson FString
---@field TestDataJson FString
UBUI_EndCreditsItem = {}



---@class UBUI_EndCreditsPage : UBUI_EndCreditsItem
---@field PageAction EndCreditsPageAction
---@field ScrollSpeed float
---@field ScrollEndOffset float
UBUI_EndCreditsPage = {}



---@class UBUI_EndCreditsScroll : UBUI_Widget
---@field CacheCount int32
---@field CacheScrollSize int32
---@field CurPageIdx int32
---@field ScrollOffset float
---@field ScrollSpeed float
---@field IsPlaying boolean
---@field IsEnding boolean
UBUI_EndCreditsScroll = {}



---@class UBUI_EnemyBar : UBUI_EnemyBloodBarPure
---@field OwnerCharacter AActor
UBUI_EnemyBar = {}

---@param InOwnerCharacter AActor
function UBUI_EnemyBar:GSInit(InOwnerCharacter) end


---@class UBUI_EnemyBloodBarPure : UBUI_Widget
UBUI_EnemyBloodBarPure = {}

---@param Owner AActor
function UBUI_EnemyBloodBarPure:DoShowIn(Owner) end
---@param OwnerCharacter AActor
function UBUI_EnemyBloodBarPure:DoGSInit(OwnerCharacter) end
function UBUI_EnemyBloodBarPure:DoShowOut() end
function UBUI_EnemyBloodBarPure:DoFreeOwner() end


---@class UBUI_ExceptionPanel : UBUI_Widget
UBUI_ExceptionPanel = {}

function UBUI_ExceptionPanel:OnCloseButtonDown() end


---@class UBUI_FOnButtonClickedEvent_LamdaHolder : UObject
UBUI_FOnButtonClickedEvent_LamdaHolder = {}

function UBUI_FOnButtonClickedEvent_LamdaHolder:LamdaCB() end


---@class UBUI_FOnButtonReleasedEvent_LamdaHolder : UObject
UBUI_FOnButtonReleasedEvent_LamdaHolder = {}

function UBUI_FOnButtonReleasedEvent_LamdaHolder:LamdaCB() end


---@class UBUI_GMCameraPanel : UBUI_Widget
---@field UnlockCameraMode DefaultCamArmMode
---@field LockCameraMode DefaultCamArmMode
UBUI_GMCameraPanel = {}

---@param bChecked boolean
function UBUI_GMCameraPanel:CheckBox_LockFar_OnCheckStateChanged(bChecked) end
---@param bChecked boolean
function UBUI_GMCameraPanel:CheckBox_LockMid_OnCheckStateChanged(bChecked) end
---@param bChecked boolean
function UBUI_GMCameraPanel:CheckBox_UnlockMid_OnCheckStateChanged(bChecked) end
---@param bChecked boolean
function UBUI_GMCameraPanel:CheckBox_UnlockFar_OnCheckStateChanged(bChecked) end
---@param bChecked boolean
function UBUI_GMCameraPanel:CheckBox_LockClose_OnCheckStateChanged(bChecked) end
---@param bChecked boolean
function UBUI_GMCameraPanel:CheckBox_UnlockFree_OnCheckStateChanged(bChecked) end
---@param bChecked boolean
function UBUI_GMCameraPanel:CheckBox_UnlockClose_OnCheckStateChanged(bChecked) end
---@param bChecked boolean
function UBUI_GMCameraPanel:CheckBox_LockDefault_OnCheckStateChanged(bChecked) end
---@param bChecked boolean
function UBUI_GMCameraPanel:CheckBox_CameraGroup02_OnCheckStateChanged(bChecked) end
---@param bChecked boolean
function UBUI_GMCameraPanel:CheckBox_CameraGroup03_OnCheckStateChanged(bChecked) end
---@param bChecked boolean
function UBUI_GMCameraPanel:CheckBox_UnlockDefault_OnCheckStateChanged(bChecked) end
---@param bChecked boolean
function UBUI_GMCameraPanel:CheckBox_CameraGroup01_OnCheckStateChanged(bChecked) end


---@class UBUI_GMDIYPanel : UBUI_Widget
---@field CmdGroupTemp TSubclassOf<UUserWidget>
UBUI_GMDIYPanel = {}

function UBUI_GMDIYPanel:OnClickDoSaveCmds() end
function UBUI_GMDIYPanel:OnClickDoReturnCmdList() end


---@class UBUI_GMInfo_Enemy : UBUI_Widget
---@field InfoTemp TSubclassOf<UUserWidget>
---@field PartInfoTemp TSubclassOf<UUserWidget>
UBUI_GMInfo_Enemy = {}



---@class UBUI_GMInfo_Player : UBUI_Widget
---@field InfoTemp TSubclassOf<UUserWidget>
UBUI_GMInfo_Player = {}



---@class UBUI_GMInformationPanel : UBUI_Widget
---@field InfoTemp TSubclassOf<UUserWidget>
UBUI_GMInformationPanel = {}



---@class UBUI_GMOptimizePanel : UBUI_Widget
UBUI_GMOptimizePanel = {}

function UBUI_GMOptimizePanel:OnRunBtnClicked() end
function UBUI_GMOptimizePanel:OnToHFSBtnClicked() end
function UBUI_GMOptimizePanel:OnToHFMBtnClicked() end
function UBUI_GMOptimizePanel:OnToOriginMapBtnClicked() end


---@class UBUI_GMRootPanel : UBUI_Widget
UBUI_GMRootPanel = {}

function UBUI_GMRootPanel:OnClickToDIYPanel() end
function UBUI_GMRootPanel:OnClickToSkillPanel() end
function UBUI_GMRootPanel:OnClickToCameraPanel() end
function UBUI_GMRootPanel:OnClickToDefaultPanel() end
function UBUI_GMRootPanel:OnClickToTeleportPanel() end
function UBUI_GMRootPanel:OnClickToOptimizePanel() end
function UBUI_GMRootPanel:OnClickToCalliopePanel() end
function UBUI_GMRootPanel:OnClickToHatredAndTargetPanel() end


---@class UBUI_GMSkillPanel : UBUI_Widget
---@field CheckTemp TSubclassOf<UUserWidget>
UBUI_GMSkillPanel = {}

---@param IsChecked boolean
function UBUI_GMSkillPanel:OnToggleDS(IsChecked) end
---@param IsChecked boolean
function UBUI_GMSkillPanel:OnToggleFS(IsChecked) end
---@param IsChecked boolean
function UBUI_GMSkillPanel:OnToggleJC(IsChecked) end
---@param IsChecked boolean
function UBUI_GMSkillPanel:OnToggleZZG(IsChecked) end
---@param IsChecked boolean
function UBUI_GMSkillPanel:OnToggleCCG(IsChecked) end
---@param IsChecked boolean
function UBUI_GMSkillPanel:OnToggleTTTB(IsChecked) end
---@param IsChecked boolean
function UBUI_GMSkillPanel:OnToggleFTXD(IsChecked) end
---@param IsChecked boolean
function UBUI_GMSkillPanel:OnToggleJYBS(IsChecked) end


---@class UBUI_GMTeleportPanel : UBUI_Widget
UBUI_GMTeleportPanel = {}


---@class UBUI_GMUI : UBUI_Widget
---@field ConfigTemp TSubclassOf<UUserWidget>
---@field BtnTemp TSubclassOf<UUserWidget>
---@field CheckTemp TSubclassOf<UUserWidget>
---@field SliderTemp TSubclassOf<UUserWidget>
---@field EditableTemp TSubclassOf<UUserWidget>
UBUI_GMUI = {}

---@param IsChecked boolean
function UBUI_GMUI:OnSetInvisible(IsChecked) end
function UBUI_GMUI:OnClickDoFullHP() end
function UBUI_GMUI:OnClickDoFullMP() end
function UBUI_GMUI:OnClickDoLockHP() end
---@param IsChecked boolean
function UBUI_GMUI:OnChangeDoLockHP2(IsChecked) end
---@param IsChecked boolean
function UBUI_GMUI:OnChangeDoToggleUI(IsChecked) end
---@param IsChecked boolean
function UBUI_GMUI:OnToggleAllEnemyAI(IsChecked) end
---@param bCancel boolean
function UBUI_GMUI:OnCancelAllEnemyCD(bCancel) end
function UBUI_GMUI:OnClickDoSetConfigs() end
function UBUI_GMUI:OnClickDoInvincible() end
function UBUI_GMUI:OnClickKillAllEnemy() end
function UBUI_GMUI:OnClickDoAddBuff100() end
---@param IsChecked boolean
function UBUI_GMUI:OnChangeDoInvincible(IsChecked) end
---@param IsChecked boolean
function UBUI_GMUI:OnChangeDoLockStamina(IsChecked) end
---@param IsChecked boolean
function UBUI_GMUI:OnChangeDoLockEnemyHP(IsChecked) end
function UBUI_GMUI:OnClick999BloodBottle() end
function UBUI_GMUI:OnClickDoRemoveAllBuff() end
function UBUI_GMUI:OnClickFullBloodBottle() end
---@param IsChecked boolean
function UBUI_GMUI:OnChangeDoEnableEnemyBar(IsChecked) end


---@class UBUI_GMUnitInfo_Left : UBUI_Widget
---@field InfoTemp TSubclassOf<UUserWidget>
---@field PlayerCharacter ABGUCharacter
---@field Target ABGUCharacter
UBUI_GMUnitInfo_Left = {}



---@class UBUI_GMUnitInfo_Right : UBUI_Widget
---@field InfoTemp TSubclassOf<UUserWidget>
UBUI_GMUnitInfo_Right = {}



---@class UBUI_GMUnitInfo_Up : UBUI_Widget
UBUI_GMUnitInfo_Up = {}


---@class UBUI_GM_AIRootPanel : UBUI_Widget
UBUI_GM_AIRootPanel = {}

function UBUI_GM_AIRootPanel:OnSwitchButtonPress() end


---@class UBUI_GM_CalliopePanel : UBUI_Widget
UBUI_GM_CalliopePanel = {}

---@param InInstanceName FName
---@return FString
function UBUI_GM_CalliopePanel:GetInstanceDebugInfo(InInstanceName) end
---@param InFilterStr FString
---@param Instances TArray<FName>
function UBUI_GM_CalliopePanel:RefreshInstanceListWithFilter(InFilterStr, Instances) end


---@class UBUI_GM_HatredAndTargetPanel : UBUI_Widget
UBUI_GM_HatredAndTargetPanel = {}

function UBUI_GM_HatredAndTargetPanel:CleanTargetInfos() end
---@param Target AActor
---@return int32
function UBUI_GM_HatredAndTargetPanel:GetDebugTargetInfo(Target) end
---@param Target AActor
---@param Value int32
function UBUI_GM_HatredAndTargetPanel:SetNeedShowDebugTargetInfos(Target, Value) end
---@param _FilterRadius FString
---@param Instances TArray<FName>
---@param Units TArray<AActor>
function UBUI_GM_HatredAndTargetPanel:RefreshInstanceListWithFilterRadius(_FilterRadius, Instances, Units) end


---@class UBUI_GM_OP_DIY : UBUI_Widget
UBUI_GM_OP_DIY = {}

function UBUI_GM_OP_DIY:OnClickDoCmds() end
function UBUI_GM_OP_DIY:OnClickDoSave() end
function UBUI_GM_OP_DIY:OnClickDoDelete() end


---@class UBUI_GM_OP_Editable : UBUI_Widget
UBUI_GM_OP_Editable = {}

function UBUI_GM_OP_Editable:OnClickChangeValue() end


---@class UBUI_GridPanel : UBUI_Widget
---@field ColumnNum int32
---@field MinRow int32
---@field ListMinRow int32
UBUI_GridPanel = {}



---@class UBUI_InputActionIcon : UBUI_Button
---@field InputAction UInputAction
---@field Description FText
---@field Color FColor
UBUI_InputActionIcon = {}



---@class UBUI_InputIconWidget : UBUI_Widget
---@field ShowType EGSInputType
---@field IsUsedInUI boolean
---@field IsNeedInteractEffect boolean
---@field IsNeedInteractTips boolean
---@field IconScale FVector2D
---@field IconColor FSlateColor
---@field GamepadBrush FSlateBrush
---@field GamepadBrushConfig FInputBrushStruct
---@field PSBrush FSlateBrush
---@field KeyboardBrush FSlateBrush
---@field EditorKeyboardBrush FSlateBrush
---@field KeyboardBrushConfig FInputBrushStruct
---@field IsShowTips boolean
---@field TipsMode UITipsMode
---@field TxtDesc FText
---@field TxtFont FSlateFontInfo
---@field TxtPosPadding FVector2D
---@field TxtColor FSlateColor
---@field TxtShadowOffset FVector2D
---@field TxtShadowColor FLinearColor
UBUI_InputIconWidget = {}

function UBUI_InputIconWidget:UpdateGamepad() end
function UBUI_InputIconWidget:UpdateKeyboard() end


---@class UBUI_InputTipsOne : UBUI_Widget
UBUI_InputTipsOne = {}


---@class UBUI_LoadingScreenPreview : UBUI_Widget
UBUI_LoadingScreenPreview = {}

---@param Text FText
---@param CommitMethod ETextCommit::Type
function UBUI_LoadingScreenPreview:OnTextCommitted(Text, CommitMethod) end
---@param SelectedItem FString
---@param SelectionType ESelectInfo::Type
function UBUI_LoadingScreenPreview:OnSelectionChanged(SelectedItem, SelectionType) end


---@class UBUI_LoopWidget : UBUI_Widget
---@field ActiveLoop boolean
---@field NeedAdaptive boolean
---@field LoopDirection LoopDirection
---@field Wait float
---@field Delay float
---@field ScrollSpeed float
---@field Content UWidget
---@field MaxDesiredWidget float
---@field CurLoopDirection LoopDirection
---@field Time float
---@field Distance float
UBUI_LoopWidget = {}

---@return boolean
function UBUI_LoopWidget:Reset() end
---@return boolean
function UBUI_LoopWidget:GetActiveLoop() end
---@param InActiveLoop boolean
function UBUI_LoopWidget:SetActiveLoop(InActiveLoop) end


---@class UBUI_MBarBase : UBUI_ProjWidget
---@field ShowDurationTime float
---@field MinScale float
---@field MaxScale float
---@field XMinScale float
---@field XMaxScale float
---@field YMinScale float
---@field YMaxScale float
---@field ScaleRate float
UBUI_MBarBase = {}



---@class UBUI_MInteractIcon : UBUI_ProjWidget
UBUI_MInteractIcon = {}


---@class UBUI_MPlayerInfo : UBUI_MBarBase
---@field InterpSpeed float
UBUI_MPlayerInfo = {}



---@class UBUI_MSimNum : UBUI_ProjWidget
---@field PlayerDamageNumConfig TMap<DamageTypeEnum, FString>
---@field EnemyDamageNumConfig TMap<DamageTypeEnum, FString>
UBUI_MSimNum = {}

function UBUI_MSimNum:OnShowAnimFinished() end


---@class UBUI_MagicFieldDebugInfo : UBUI_ProjectileDebugInfo
UBUI_MagicFieldDebugInfo = {}


---@class UBUI_MapWidget : UBUI_Widget
UBUI_MapWidget = {}

function UBUI_MapWidget:Construct() end


---@class UBUI_Menu : UBUI_DependWidget
---@field MenuUIStat MenuUIStat
---@field MenuSwitchType MenuSwitchType
---@field InteractActionType InteractActionType
---@field UseLeftRightAction boolean
---@field Parent UBUI_Menu
---@field ChildMenus TArray<UBUI_Menu>
---@field SelectedIdx int32
---@field CacheSelectedIdx int32
---@field ActivedIdx int32
---@field GenBySelfChilds TArray<UBUI_MenuButton>
---@field UseNavLoop boolean
UBUI_Menu = {}



---@class UBUI_MenuButton : UBUI_Button
---@field MenuUIStat MenuUIStat
UBUI_MenuButton = {}



---@class UBUI_MouseButtonEvent : UUserWidget
UBUI_MouseButtonEvent = {}

---@param MyGeometry FGeometry
---@param InDeltaTime float
function UBUI_MouseButtonEvent:Tick(MyGeometry, InDeltaTime) end
---@param MyGeometry FGeometry
---@param MouseEvent FPointerEvent
---@return FEventReply
function UBUI_MouseButtonEvent:OnMouseMove(MyGeometry, MouseEvent) end
---@param MyGeometry FGeometry
---@param MouseEvent FPointerEvent
function UBUI_MouseButtonEvent:OnMouseEnter(MyGeometry, MouseEvent) end
---@param MouseEvent FPointerEvent
function UBUI_MouseButtonEvent:OnMouseLeave(MouseEvent) end
---@param MyGeometry FGeometry
---@param MouseEvent FPointerEvent
---@return FEventReply
function UBUI_MouseButtonEvent:OnMouseButtonUp(MyGeometry, MouseEvent) end
---@param MyGeometry FGeometry
---@param MouseEvent FPointerEvent
---@return FEventReply
function UBUI_MouseButtonEvent:OnMouseButtonDown(MyGeometry, MouseEvent) end
---@param Param int32
function UBUI_MouseButtonEvent:OnUserWidgetAnimationSequenceEvent(Param) end


---@class UBUI_NameBar : UBUI_Widget
---@field ItemNameText UTextBlock
---@field BackImage UImage
UBUI_NameBar = {}



---@class UBUI_NotifyValidatePanel : UBUI_Widget
UBUI_NotifyValidatePanel = {}

function UBUI_NotifyValidatePanel:OnClickClose() end


---@class UBUI_ProgressBarPure : UBUI_Widget
UBUI_ProgressBarPure = {}


---@class UBUI_ProjWidget : UBUI_Widget
UBUI_ProjWidget = {}


---@class UBUI_ProjectileDebugInfo : UBUI_Widget
---@field InfoTemp TSubclassOf<UUserWidget>
---@field ProjectileSelf ABGUProjectileBaseActor
UBUI_ProjectileDebugInfo = {}

---@param projectileBaseActor ABGUProjectileBaseActor
function UBUI_ProjectileDebugInfo:OnRegistOwner(projectileBaseActor) end


---@class UBUI_ReplayPanel : UBUI_Widget
UBUI_ReplayPanel = {}

function UBUI_ReplayPanel:OnMouseCaptureEnd() end
function UBUI_ReplayPanel:OnStopButtonClicked() end
function UBUI_ReplayPanel:OnBackButtonClicked() end
function UBUI_ReplayPanel:OnMouseCaptureBegin() end
---@param Value float
function UBUI_ReplayPanel:OnSliderValueChanged(Value) end
function UBUI_ReplayPanel:OnForwardButtonClicked() end
function UBUI_ReplayPanel:OnPlayOrPauseButtonClicked() end


---@class UBUI_RoundRectDemo : UBUI_Widget
---@field InterpSpeed float
UBUI_RoundRectDemo = {}

---@param InDeltaTime float
function UBUI_RoundRectDemo:UpdateShow(InDeltaTime) end
---@param TargetWidget UWidget
---@param WorldPos FVector
function UBUI_RoundRectDemo:UpdatePosRefWorldPos(TargetWidget, WorldPos) end


---@class UBUI_RoundRectDemoOne : UBUI_Widget
---@field InterpSpeed float
UBUI_RoundRectDemoOne = {}

---@param InDeltaTime float
function UBUI_RoundRectDemoOne:UpdateShow(InDeltaTime) end
---@param TargetWidget UWidget
---@param WorldPos FVector
function UBUI_RoundRectDemoOne:UpdatePosRefWorldPos(TargetWidget, WorldPos) end


---@class UBUI_ScrollTips : UBUI_Widget
---@field ScrollBox UGSScrollBox
UBUI_ScrollTips = {}



---@class UBUI_SlateDebug : UBUI_Widget
UBUI_SlateDebug = {}


---@class UBUI_Startup : UBUI_Widget
UBUI_Startup = {}

---@param bChecked boolean
function UBUI_Startup:OnSetInvisible(bChecked) end
---@param bChecked boolean
function UBUI_Startup:OnChangeDoVSync(bChecked) end
function UBUI_Startup:OnClick_OpenLevel() end
---@param bChecked boolean
function UBUI_Startup:OnChangeDoLockHP2(bChecked) end
---@param bChecked boolean
function UBUI_Startup:OnToggleAllEnemyAI(bChecked) end
---@param bChecked boolean
function UBUI_Startup:OnChangeDoToggleUI(bChecked) end
---@param bChecked boolean
function UBUI_Startup:OnCancelAllEnemyCD(bChecked) end
---@param Text FText
---@param CommitMethod ETextCommit::Type
function UBUI_Startup:OnCMDTextCommitted(Text, CommitMethod) end
---@param bChecked boolean
function UBUI_Startup:OnChangeDoLock60FPS(bChecked) end
---@param bChecked boolean
function UBUI_Startup:OnChangeDoInvincible(bChecked) end
---@param bChecked boolean
function UBUI_Startup:OnChangeDoLockStamina(bChecked) end
---@param bChecked boolean
function UBUI_Startup:OnChangeDoLockEnemyHP(bChecked) end
---@param bChecked boolean
function UBUI_Startup:OnChangeApplyByDefault(bChecked) end
---@param SelectedItem FString
---@param SelectionType ESelectInfo::Type
function UBUI_Startup:OnLevelSelectionChanged(SelectedItem, SelectionType) end
---@param bChecked boolean
function UBUI_Startup:OnChangeDoEnableEnemyBar(bChecked) end
---@param bChecked boolean
function UBUI_Startup:OnChangeNeverShowStartupUI(bChecked) end


---@class UBUI_StateItem : UBUI_Widget
---@field Padding_Left float
---@field Padding_Right float
---@field WarningRemaining float
---@field WarnningFlashCurve UCurveFloat
---@field WarningFlashAge float
UBUI_StateItem = {}



---@class UBUI_StateWidget : UBUI_Widget
---@field DefaultConfigMap TMap<WidgetUIStat, FFUIData>
---@field DisableConfigMap TMap<WidgetUIStat, FFUIData>
---@field EditIsDisable boolean
---@field EditCurState WidgetUIStat
UBUI_StateWidget = {}



---@class UBUI_TeamTipsIcon : UBUI_Widget
UBUI_TeamTipsIcon = {}


---@class UBUI_UnitDebugInfo : UBUI_Widget
---@field InfoTemp TSubclassOf<UUserWidget>
---@field UnitSelf ABGUCharacterCS
UBUI_UnitDebugInfo = {}

---@param UnitActor ABGUCharacterCS
function UBUI_UnitDebugInfo:OnRegistOwner(UnitActor) end


---@class UBUI_Widget : UUGSInputWidgetCS
---@field IsNewConfig boolean
---@field IsInstance boolean
---@field GSDefaultTickType EGSTickType
---@field CurTickType EGSTickType
---@field IsRegTick boolean
---@field DelegateWrapperHolder TArray<UUILRuntimeDelegateWrapperBase>
---@field OnShowAudioEvent UAkAudioEvent
---@field OnHideAudioEvent UAkAudioEvent
---@field AnimationConfig TMap<FString, FAnimationInfo>
---@field AnimationRestoreConfig TMap<FString, FAnimationRestoreInfo>
---@field WidgetMPlayer UMediaPlayer
---@field GSAnimKeyStateBlenderCfg TArray<FAnimKeyStateBlendCfg>
---@field GSAnimKeyStateBlenderObjMap TMap<FString, UGSAnimKeyStateBlender>
---@field CommSyncParam TArray<FMatSyncConfig>
UBUI_Widget = {}

---@param AnimName FString
---@param TargetState FString
---@param IsForce boolean
---@param InStateDelayEasingTime float
---@param InStateOverideEasingTime float
function UBUI_Widget:GSAnimKeyToState(AnimName, TargetState, IsForce, InStateDelayEasingTime, InStateOverideEasingTime) end
---@param MyGeometry FGeometry
---@param InDeltaTime float
function UBUI_Widget:Tick(MyGeometry, InDeltaTime) end
---@param AnimName FString
---@param TargetState FString
---@param InStateDelayEasingTime float
---@param InStateOverideEasingTime float
---@param IsForce boolean
function UBUI_Widget:WoodTestAnimKeyState(AnimName, TargetState, InStateDelayEasingTime, InStateOverideEasingTime, IsForce) end
---@param MyGeometry FGeometry
---@param InKeyEvent FKeyEvent
---@return FEventReply
function UBUI_Widget:OnKeyUp(MyGeometry, InKeyEvent) end
---@param ListItemObject UObject
function UBUI_Widget:OnGSOnListItemObjectSet(ListItemObject) end
function UBUI_Widget:Destruct() end
---@param MyGeometry FGeometry
---@param InKeyEvent FKeyEvent
---@return FEventReply
function UBUI_Widget:OnKeyDown(MyGeometry, InKeyEvent) end
---@param Animation UWidgetAnimation
---@param EventName FString
function UBUI_Widget:OnAnimationSequenceEvent(Animation, EventName) end
function UBUI_Widget:Construct() end
---@param MyGeometry FGeometry
---@param MouseEvent FPointerEvent
---@return FEventReply
function UBUI_Widget:OnMouseWheel(MyGeometry, MouseEvent) end
---@param IsDesignTime boolean
function UBUI_Widget:PreConstruct(IsDesignTime) end
function UBUI_Widget:OnInitialized() end
---@param InFocusEvent FFocusEvent
function UBUI_Widget:OnFocusChanging(InFocusEvent) end
---@param MyGeometry FGeometry
---@param InKeyEvent FKeyEvent
---@return FEventReply
function UBUI_Widget:OnPreviewKeyDown(MyGeometry, InKeyEvent) end
---@param InFocusEvent FFocusEvent
function UBUI_Widget:OnAddedToFocusPath(InFocusEvent) end
---@param MyGeometry FGeometry
---@param InAnalogInputEvent FAnalogInputEvent
---@return FEventReply
function UBUI_Widget:OnAnalogValueChanged(MyGeometry, InAnalogInputEvent) end
---@param InFocusEvent FFocusEvent
function UBUI_Widget:OnRemovedFromFocusPath(InFocusEvent) end


---@class UBUI_WidgetComponent : UObject
UBUI_WidgetComponent = {}


---@class UBUI_ZBBPanel : UBUI_Widget
UBUI_ZBBPanel = {}

function UBUI_ZBBPanel:ShowZBBInfo() end
---@param SelectedItem FString
---@param SelectionType ESelectInfo::Type
function UBUI_ZBBPanel:GenerateReport(SelectedItem, SelectionType) end


---@class UBUS_AIComp : UActorCompBaseUObj
---@field PerceptionComp UAIPerceptionComponent
UBUS_AIComp = {}

---@param Target AActor
---@param Stimulus FAIStimulus
function UBUS_AIComp:OnTargetPerceptionUpdated(Target, Stimulus) end


---@class UBUS_AIRequestManageComp : UActorCompBaseUObj
---@field DirectionMove UBADirectionMove
---@field RootMotionMove UBARootMotionMove
---@field DirectionDamage UBADirectionDamage
---@field TraceMove UBATraceMove
---@field MoveSkill UBAMoveSkill
UBUS_AIRequestManageComp = {}



---@class UBUS_AKMgrComp : UActorCompBaseUObj
UBUS_AKMgrComp = {}

---@param CallbackType EAkCallbackType
---@param CallbackInfo UAkCallbackInfo
function UBUS_AKMgrComp:OnAkEventCallBack(CallbackType, CallbackInfo) end
---@param AkComp UAkComponent
function UBUS_AKMgrComp:OnAkCompAutoDestroyed(AkComp) end


---@class UBUS_ActionTriggerConfigComp : UActorEditCompBase
---@field TargetActionType TargetActionType
---@field UseManualSelect boolean
---@field TargetList TArray<ABGUCharacter>
---@field UseAreaSelect boolean
---@field AreaList TArray<ABGUSelectAreaActor>
---@field ResIDList TArray<int32>
---@field bSelectUnitHasTarget boolean
---@field bSelectPassiveUnit boolean
UBUS_ActionTriggerConfigComp = {}



---@class UBUS_ActionTriggerDataComp : UBUS_TriggerBoxDataComp
UBUS_ActionTriggerDataComp = {}


---@class UBUS_ActorBaseDataComp : UActorDataContainer
UBUS_ActorBaseDataComp = {}

function UBUS_ActorBaseDataComp:InitOnNewInCS() end
function UBUS_ActorBaseDataComp:OnDestoryInCS() end
function UBUS_ActorBaseDataComp:PreECSBeginPlay() end
function UBUS_ActorBaseDataComp:LateECSBeginPlay() end


---@class UBUS_ActorCallComp : UActorEditCompBase
---@field CallActorCls TSubclassOf<AActor>
UBUS_ActorCallComp = {}



---@class UBUS_ActorCallerDataComp : UBUS_ActorBaseDataComp
UBUS_ActorCallerDataComp = {}


---@class UBUS_ActorConfigInfoComp : UActorEditCompBase
---@field GameplayTagGuid FGameplayTag
---@field GameplayTagGuidForGroup FGameplayTag
---@field CircusConfig FCircusConfigNonCharacter
UBUS_ActorConfigInfoComp = {}



---@class UBUS_AiWeakInteractComp : UActorEditCompBase
---@field AiWeakInteractCheckType AiWeakInteractCheckType
---@field InteractTriggerRadius int32
---@field InteractTriggerAngle int32
---@field AiConversationID int32
---@field EnableTaskStageCondition boolean
---@field TaskStageID int32
---@field TaskStageStatus StageStatus
UBUS_AiWeakInteractComp = {}



---@class UBUS_AiWeakInteractionDataComp : UBUS_ActorBaseDataComp
UBUS_AiWeakInteractionDataComp = {}


---@class UBUS_AllowUseSpecialItemAreaConfigComp : UActorEditCompBase
---@field AllowUseSpecialItemID TArray<int32>
UBUS_AllowUseSpecialItemAreaConfigComp = {}



---@class UBUS_AllowUseSpecialItemAreaDataComp : UBUS_AreaBaseDataContainer
UBUS_AllowUseSpecialItemAreaDataComp = {}


---@class UBUS_AreaBaseDataContainer : UBUS_ActorBaseDataComp
UBUS_AreaBaseDataContainer = {}


---@class UBUS_AreaConfigInfoComp : UActorEditCompBase
---@field AreaType AreaType
---@field UnitFilter FAreaUnitFilter
---@field IngnorePlayerTrans boolean
---@field bAutoEnableOverlap boolean
---@field bNotifyGraph boolean
UBUS_AreaConfigInfoComp = {}



---@class UBUS_AreaOverlapComp : UActorCompBaseUObj
UBUS_AreaOverlapComp = {}

---@param OverlappedActor AActor
---@param OtherActor AActor
function UBUS_AreaOverlapComp:OnActorEnterActor(OverlappedActor, OtherActor) end
---@param OverlappedActor AActor
---@param OtherActor AActor
function UBUS_AreaOverlapComp:OnActorLeaveActor(OverlappedActor, OtherActor) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function UBUS_AreaOverlapComp:OnActorEnter_EnterArea(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function UBUS_AreaOverlapComp:OnActorLeave_EnterArea(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end


---@class UBUS_AttackFeedbackComp : UActorCompBaseUObj
UBUS_AttackFeedbackComp = {}


---@class UBUS_AudioEditComp : UActorEditCompBase
---@field LoopEvent FUAkEventConfig
---@field DeadEvent FUAkEventConfig
UBUS_AudioEditComp = {}



---@class UBUS_AudioEmitterDataComp : UBUS_ActorBaseDataComp
UBUS_AudioEmitterDataComp = {}


---@class UBUS_AudioEmitterEditComp : UActorEditCompBase
---@field bDebug boolean
---@field bDebugLog boolean
---@field bHiddenInGame boolean
---@field bFollowPlayerElevation boolean
---@field AkEventEmitter UAkAudioEvent
---@field EmitterHeight float
---@field SwitchGroup FName
---@field SwitchStateInside FName
---@field SwitchStateOutside FName
---@field OccRefreshInterval float
---@field MaxRangeFadeDistance float
---@field WallHeight float
UBUS_AudioEmitterEditComp = {}



---@class UBUS_AudioTriggerComp : UBaseActorComp
UBUS_AudioTriggerComp = {}

function UBUS_AudioTriggerComp:BeginPlayInCS() end


---@class UBUS_AudioTriggerConfigComp : UActorEditCompBase
---@field AudioList TArray<FAudioConfig>
UBUS_AudioTriggerConfigComp = {}



---@class UBUS_AudioTriggerDataComp : UBUS_TriggerBoxDataComp
UBUS_AudioTriggerDataComp = {}


---@class UBUS_AutoCloudMoveAreaConfigComp : UActorEditCompBase
---@field AcceptRadius float
---@field MaxHeightDistance float
UBUS_AutoCloudMoveAreaConfigComp = {}



---@class UBUS_AutoCloudMoveAreaDataComp : UBUS_AreaBaseDataContainer
UBUS_AutoCloudMoveAreaDataComp = {}


---@class UBUS_BGMAreaDataComp : UBUS_AreaBaseDataContainer
UBUS_BGMAreaDataComp = {}


---@class UBUS_BGMVolumeDataComp : UBUS_ActorBaseDataComp
UBUS_BGMVolumeDataComp = {}


---@class UBUS_BGUDataComp : UBUS_BGUDataCompBase
UBUS_BGUDataComp = {}

function UBUS_BGUDataComp:LateECSBeginPlay() end


---@class UBUS_BGUDataCompBase : UBGUDataComp
UBUS_BGUDataCompBase = {}

function UBUS_BGUDataCompBase:InitOnNewInCS() end
function UBUS_BGUDataCompBase:OnDestoryInCS() end
function UBUS_BGUDataCompBase:PreECSBeginPlay() end
function UBUS_BGUDataCompBase:LateECSBeginPlay() end


---@class UBUS_BattleFieldPerformanceOptAreaDataComp : UBUS_AreaBaseDataContainer
UBUS_BattleFieldPerformanceOptAreaDataComp = {}


---@class UBUS_BattleSCDataComp : UBUS_ActorBaseDataComp
UBUS_BattleSCDataComp = {}


---@class UBUS_BattleTriggerConfigComp : UActorEditCompBase
---@field AutoEnable boolean
---@field BattleTriggerConfig FBattleTriggerConfig
UBUS_BattleTriggerConfigComp = {}



---@class UBUS_BattleTriggerDataComp : UBUS_ActorBaseDataComp
UBUS_BattleTriggerDataComp = {}


---@class UBUS_BuffTriggerAreaConfigComp : UActorEditCompBase
---@field ObserveUnitsConditions TArray<FFGSBuffTriggerUnitCondition>
---@field bTriggerEndOverlapWhenDisable boolean
UBUS_BuffTriggerAreaConfigComp = {}



---@class UBUS_BuffTriggerAreaDataComp : UBUS_AreaBaseDataContainer
UBUS_BuffTriggerAreaDataComp = {}


---@class UBUS_BuffTriggerConfigComp : UActorEditCompBase
---@field AutoEnable boolean
---@field bTriggerEndOverlapWhenDisable boolean
---@field ObserveUnitsConditions TArray<FFGSBuffTriggerUnitCondition>
UBUS_BuffTriggerConfigComp = {}



---@class UBUS_BuffTriggerDataComp : UBUS_ActorBaseDataComp
UBUS_BuffTriggerDataComp = {}


---@class UBUS_BulletDataComp : UBUS_ProjectileBaseDataComp
UBUS_BulletDataComp = {}


---@class UBUS_CastImmobilizeEditComp : UActorEditCompBase
UBUS_CastImmobilizeEditComp = {}


---@class UBUS_CharacterModularComp : UBaseActorComp
UBUS_CharacterModularComp = {}


---@class UBUS_CircusDataComp : UBUS_ActorBaseDataComp
UBUS_CircusDataComp = {}


---@class UBUS_CloudMoveRestrictAreaConfigComp : UActorEditCompBase
---@field CloudMoveRestrictType EGSCloudMoveRestrictType
UBUS_CloudMoveRestrictAreaConfigComp = {}



---@class UBUS_CloudMoveRestrictAreaDataComp : UBUS_AreaBaseDataContainer
UBUS_CloudMoveRestrictAreaDataComp = {}


---@class UBUS_CloudMoveRestrictAreaLogicComp : UActorCompBaseUObj
UBUS_CloudMoveRestrictAreaLogicComp = {}


---@class UBUS_CloudMoveTriggerAreaConfigComp : UActorEditCompBase
---@field PreCoolDown float
UBUS_CloudMoveTriggerAreaConfigComp = {}



---@class UBUS_CloudMoveTriggerAreaDataComp : UBUS_AreaBaseDataContainer
UBUS_CloudMoveTriggerAreaDataComp = {}


---@class UBUS_CloudMoveTriggerAreaLogicComp : UActorCompBaseUObj
UBUS_CloudMoveTriggerAreaLogicComp = {}


---@class UBUS_CollectionConfigComp : UActorEditCompBase
---@field CollectionDropID int32
---@field GroupId int32
---@field UnitClass TSubclassOf<AActor>
---@field PlusUnitClass TSubclassOf<AActor>
---@field ChiefUnitClass TSubclassOf<AActor>
---@field OverWriterEventId boolean
---@field EventID int32
---@field PlusEventId int32
---@field ChiefEventId int32
UBUS_CollectionConfigComp = {}



---@class UBUS_CollectiontDataComp : UBUS_InteractiveActorDataComp
UBUS_CollectiontDataComp = {}


---@class UBUS_ConfigInfoComp : UActorEditCompBase
---@field UnitCDesc FUnitCDesc
---@field UnitAIDesc FUnitAIDesc
---@field UnitPhysicsDesc FUnitPhysicsDesc
---@field UnitFixedGuid FUnitGuidData
---@field UnitBehaviorTree UBehaviorTree
---@field DispInteractSolverConfig FDispInteractSolverConfig
---@field DispInteractBoneMap TMap<FName, FBoneUseForDispMap>
---@field TROConfigOverride UBGWDataAsset_TROConfig
---@field SpecialBoneConfig UBGWDataAsset_SpecialBoneConfig
---@field DestroyProjectileWhenDead TArray<int32>
---@field SpotLightRotationLagSpeed float
---@field AttachConfig FActorAttachConfig
---@field GSCameraAutoLockSetting FFGSCameraAutoLockSetting
---@field NormalMeleeAutoLockSetting FFGSMeleeAutoLockSetting
---@field G4MeleeAutoLockSetting FFGSMeleeAutoLockSetting
---@field DodgeInputFixLine float
---@field GridSize float
---@field FlagConfig FUnitCompFlagConfig
---@field FallingCheckThreshold float
---@field CircusConfig FCircusConfig
---@field _InteractInfoTemplateType InteractInfoTemplateType
---@field NeutralAnimalConfig FNeutralAnimalConfig
---@field WaterSplashConfig UBGWDataAsset_WaterSplashMapping
---@field bDisableDataConvert boolean
UBUS_ConfigInfoComp = {}



---@class UBUS_CricketMgrConfigComp : UActorEditCompBase
---@field CricketTamer TSubclassOf<ABUTamerActor>
---@field SpawnProbability float
---@field SpawnDelayTimeRange FVector2D
---@field TrySpawnMaxCount int32
---@field ReSpawnDelayTime float
---@field MovePointConfig TArray<FCricketMovePointConfig>
---@field LeaveFightDistance float
---@field LeaveFightDelayTime float
---@field InteractConfig UBGWDataAsset_CricketInteractConfig
---@field ASWeakIdle UAnimSequence
---@field WeakDuration float
---@field NormalLongPressInteractGroupID int32
---@field WeakLongPressInteractGroupID int32
UBUS_CricketMgrConfigComp = {}



---@class UBUS_CricketMgrDataComp : UBUS_ActorBaseDataComp
UBUS_CricketMgrDataComp = {}


---@class UBUS_CutDeathDataComp : UBUS_ActorBaseDataComp
UBUS_CutDeathDataComp = {}


---@class UBUS_DamageCastDataComp : UBUS_ActorBaseDataComp
UBUS_DamageCastDataComp = {}


---@class UBUS_DeadAreaDataComp : UBUS_AreaBaseDataContainer
UBUS_DeadAreaDataComp = {}


---@class UBUS_DeadZoneLogicComp : UActorCompBaseUObj
UBUS_DeadZoneLogicComp = {}

function UBUS_DeadZoneLogicComp:PlayerCliffFallRollBack() end


---@class UBUS_DecalConfigComp : UActorEditCompBase
---@field FloatCurveList TArray<FGSFloatCurveToParam>
---@field LinearColorCurveList TArray<FGSLinearColorCurveToParam>
UBUS_DecalConfigComp = {}



---@class UBUS_DecalDataComp : UBUS_FXDataComp
UBUS_DecalDataComp = {}


---@class UBUS_DestructibleActorDataComp : UBUS_ActorBaseDataComp
UBUS_DestructibleActorDataComp = {}


---@class UBUS_DestructibleActorRelativeDestroyComp : UBaseActorComp
---@field RelativeDestroyActors TArray<TSoftObjectPtr<AActor>>
---@field RelativeDestroyDestructibles TArray<TSoftObjectPtr<ABGUFXActorBase>>
UBUS_DestructibleActorRelativeDestroyComp = {}

function UBUS_DestructibleActorRelativeDestroyComp:BeginPlayInCS() end


---@class UBUS_DestructibleConfigComp : UActorEditCompBase
---@field MassLevel DestructibleMassLevel
---@field StrengthLevel DestructibleStrengthLevel
---@field DestroyedDebrisLifeTime float
---@field DebrisDissipationTime float
---@field CanParryStrengthLevel TArray<EGSHitDestructibleStrengthLevel>
---@field DestructibleParryEvent UAkAudioEvent
---@field DestructibleParryDispConfig UBGWDataAsset
---@field DestructionDropInfoID int32
---@field CanBeHitByBullet boolean
UBUS_DestructibleConfigComp = {}



---@class UBUS_DestructibleDestroyEffectTriggerComp : UActorEditCompBase
---@field DestructibleTag FName
---@field EffectIDs TArray<int32>
---@field BuffIDs TArray<int32>
UBUS_DestructibleDestroyEffectTriggerComp = {}



---@class UBUS_DestructibleEnvSurfaceVolumeRelativeComp : UBaseActorComp
---@field RelativeEnvironmentSurfaceVolumes TArray<TSoftObjectPtr<ABGWEnvironmentSurfaceVolume>>
UBUS_DestructibleEnvSurfaceVolumeRelativeComp = {}

function UBUS_DestructibleEnvSurfaceVolumeRelativeComp:BeginPlayInCS() end


---@class UBUS_DialogueProxyDataComp : UBUS_ActorBaseDataComp
UBUS_DialogueProxyDataComp = {}


---@class UBUS_DispInteractAreaComp : UActorCompBaseUObj
UBUS_DispInteractAreaComp = {}

---@param OverlappedActor AActor
---@param OtherActor AActor
function UBUS_DispInteractAreaComp:OnActorEnter(OverlappedActor, OtherActor) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function UBUS_DispInteractAreaComp:OnActorLeave(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end


---@class UBUS_DispInteractBaseDataComp : UBUS_ActorBaseDataComp
UBUS_DispInteractBaseDataComp = {}


---@class UBUS_DispMgrComp : UActorCompBaseUObj
UBUS_DispMgrComp = {}


---@class UBUS_DropItemComp : UActorEditCompBase
---@field DropItemResID int32
---@field UseSoulBottleCondition boolean
---@field NewFXSpawnCompTag FName
---@field NoSoulBottleDropTemplate UUBGWDropItemTemplete
---@field HaveSoulBottleDropTemplate UUBGWDropItemTemplete
UBUS_DropItemComp = {}



---@class UBUS_DropItemDataComp : UBUS_InteractiveActorDataComp
UBUS_DropItemDataComp = {}


---@class UBUS_DroppableDestructionDataComp : UBUS_ActorBaseDataComp
UBUS_DroppableDestructionDataComp = {}


---@class UBUS_DroppedItemManagerConfigComp : UActorEditCompBase
---@field DropItemID int32
---@field DropTransform FTransform
---@field SpawnDelayTime float
---@field PointRecorder TSoftObjectPtr<ABGU_EQSPointRecorderActor>
---@field DropUnit FGsActorGuidReference
---@field DropSocket FName
---@field bUseSocketRotation boolean
---@field bUseSocketRotationAxisX boolean
---@field bUseSocketRotationAxisY boolean
---@field bUseSocketRotationAxisZ boolean
---@field DropOffset FTransform
UBUS_DroppedItemManagerConfigComp = {}



---@class UBUS_DroppedItemManagerDataComp : UBUS_ActorBaseDataComp
UBUS_DroppedItemManagerDataComp = {}


---@class UBUS_DumperTruckTriggerConfigComp : UActorEditCompBase
---@field TamerActor ABUTamerActor
---@field AnimationAsset UAnimationAsset
---@field SplineList TArray<TSoftObjectPtr<AActor>>
---@field turnSpeed int32
---@field Acceleration float
---@field MaxSpeed float
---@field MinSpeed float
---@field StartSpeed float
---@field MultiSplineDefaultIndex int32
---@field FirstAccelerationIndex int32
---@field SecondAccelerationIndex int32
---@field SpeedRateParam float
---@field RotatorWaitTime float
---@field SpeedRateParamCurve UCurveFloat
---@field UseCurveTime float
---@field StartPointIndex int32
---@field IsStartForward boolean
---@field ForwardBuffID int32
---@field BackBuffID int32
---@field ImmobilizeBuffSpeedThreshold int32
---@field ImmobilizeDeBuffSpeedThreshold int32
---@field ImmobilizeBuffID int32
---@field ImmobilizeDeBuffID int32
---@field SweepCheckParamter FSweepCheckParamter
---@field BeginEventParamter FFAKEventParamter
---@field EndEventParamter FFAKEventParamter
---@field DamageAvailableSpeedThreshold float
---@field DamageDisableSpeedThreshold float
---@field AutoEnable boolean
UBUS_DumperTruckTriggerConfigComp = {}



---@class UBUS_DumperTruckTriggerDataComp : UBUS_ActorBaseDataComp
UBUS_DumperTruckTriggerDataComp = {}


---@class UBUS_DynamicObstacleConfigComp : UActorEditCompBase
---@field bDefaultEnable boolean
UBUS_DynamicObstacleConfigComp = {}



---@class UBUS_DynamicObstacleDataComp : UBUS_ActorBaseDataComp
UBUS_DynamicObstacleDataComp = {}


---@class UBUS_DynamicSDFDataProcessBaseDataComp : UBUS_ActorBaseDataComp
UBUS_DynamicSDFDataProcessBaseDataComp = {}


---@class UBUS_EnvCtrlActorDataComp : UBUS_ActorBaseDataComp
UBUS_EnvCtrlActorDataComp = {}


---@class UBUS_EnvironmentItemStateMachineComp : UActorEditCompBase
---@field bEnableBoxOverlaping boolean
---@field TriggerUnitFilter TriggerUnitFilter
---@field TriggerRange float
---@field bCanTriggerRepeatedly boolean
---@field SpecifiedResID int32
---@field ResIDBlackList TArray<int32>
UBUS_EnvironmentItemStateMachineComp = {}



---@class UBUS_EnvironmentItemStateMachineDataComp : UBUS_ActorBaseDataComp
UBUS_EnvironmentItemStateMachineDataComp = {}


---@class UBUS_EquipPreviewActorDataComp : UBUS_ActorBaseDataComp
UBUS_EquipPreviewActorDataComp = {}


---@class UBUS_EventCollectionCS : UBUS_EventCollection
---@field Evt_SetFloatValueToSimulateFog FBUS_EventCollectionCSEvt_SetFloatValueToSimulateFog
---@field Evt_TriggerFrozenFractureBreak FBUS_EventCollectionCSEvt_TriggerFrozenFractureBreak
UBUS_EventCollectionCS = {}



---@class UBUS_ExtendConfigComp : UActorEditCompBase
---@field GroupAIBPConfig FGroupAIBPConfig
---@field BehaviorGraphTemplateID int32
---@field DialogueGraphTemplateID int32
---@field StateGraphTemplate UCalliopeAsset
---@field StateGraphTemplatePath FString
---@field OtherFsmTemplates TArray<UCalliopeAsset>
---@field OtherFsmTemplatesPath TArray<FString>
---@field FsmSubMachineOverride TMap<FGameplayTag, UCalliopeAsset>
---@field FsmSubMachinePathOverride TMap<FGameplayTag, FString>
---@field PhaseStateGraphTemplate UCalliopeAsset
---@field PhaseStateGraphTemplatePath FString
---@field EventMap TMap<FString, FGameplayTag>
---@field BattleSC ABGUBattleSC
---@field SpecificEventListen_BattleSC TArray<BattleCoopReason>
---@field BattleSC_GUID FGameplayTag
---@field InterruptAiConversationWhenIntoBattle boolean
---@field AIConversationEventIDList TArray<int32>
---@field AIConversationFacts TArray<FAiConversationFact>
---@field IntimidateBPConfig FIntimidateBPConfig
---@field GSArmorSettingInBP FFGSArmorSettingInBP
---@field WakeUpConfig FFGSWakeUpConfig
---@field ReplaceLeisureSequenceID int32
---@field LeisureAnimAfterSequence UAnimMontage
---@field OnFightSkillIDAfterSequence int32
---@field OnFightSkillIDBackAfterSequence int32
---@field OnFightSkillIDLeftAfterSequence int32
---@field OnFightSkillIDRightAfterSequence int32
---@field AIState int32
---@field LastSkillBlockReason int32
---@field UserHandle int32
---@field bLogVerbose boolean
---@field bEnablePerceptionPreview boolean
---@field bEnablePerceptionPreviewOutlineOnly boolean
---@field bEnableWakeUpLinkRangeDebug boolean
---@field bEnableHardMove boolean
---@field WindyMoveAffectedAngleForward float
---@field WindyMoveForwardBuffID int32
---@field WindyMoveBackwardBuffID int32
---@field WindyMoveEnterSkill int32
---@field MuddyMoveEnterSkill int32
---@field FrozenMoveEnterSkill int32
---@field SpiderSilkyMoveEnterSkill int32
---@field WindyMoveForwardBlendAnim UAnimSequenceBase
---@field PatrolType PatrolType
---@field bDisableRestartOnLeaveFight boolean
---@field bDisableRestartOnReset boolean
---@field MotionMatchingState State_MM
---@field FindPathMoveType EBGUMoveAIType
---@field PatrolMoveSpeedType EAIMoveSpeedType
---@field EnablePatrolOnStart boolean
---@field PatrolBuff int32
---@field ABPSettingForPatrol UBGWDataAsset_AbpHumanoidSetting
---@field MoveAcceptableRadius float
---@field StartWaitAMProbability float
---@field StartWaitAM TArray<UAnimMontage>
---@field TurnSkillConfig FFGSTurnSkillConfig
---@field RandomPatrolConfig FRandomPatrolConfig
---@field SplinePatrolConfig FFGSSplinePatrolConfig
---@field MultiSplinePatrolConfig FFGSMultiSplinePatrolConfig
---@field LeisureConfig FFGSLeisureConfig
---@field FollowPatrolConfig FFollowPatrolConfig
---@field GroupPatrolConfig FFGSGroupPatrolConfig
---@field bEnableMovePhysicsTransform boolean
---@field PhysicsTransformGravityAddValue float
---@field RotationTypeDurningPhysicsState MovePhysicsRotationType
---@field GlideSlopeEdgeAngle float
---@field MaxGlideSpeed float
---@field MinGlideSpeed float
---@field MaxSpeedAngle float
---@field MinSpeedAngle float
---@field MoveControlReactionSpeed float
---@field MoveControlAddMaxSpeed float
---@field PreventGlideSkillID int32
---@field bEnablePhysicalMove boolean
---@field PhysicalGravityAddValue float
---@field PhysicalMoveBuff TArray<int32>
---@field PhysicalMoveBuffNeedSpeed float
---@field PhysicalMoveBuffProtectTime float
---@field bUseSocketDirection boolean
---@field DirectionBaseSocekt FName
---@field ForwardSocket FName
---@field AccuratelyMoveDistance float
---@field bSimulatePhysicsWhenAttacking boolean
---@field HorizontalMoveSpeed float
---@field VerticalMoveSpeed float
---@field MaxMoveDistance float
---@field FlyDownwardSpeedRate float
---@field FlyDownwardJudgeAngle float
---@field FloatRelativeSpotActor TWeakObjectPtr<AActor>
---@field RelativeFloatHeight float
---@field SplineList TArray<TSoftObjectPtr<AActor>>
---@field BeginTriggerBox TSoftObjectPtr<ATriggerBase>
---@field EndTriggerBox TSoftObjectPtr<ATriggerBase>
---@field turnSpeed int32
---@field Acceleration float
---@field MaxSpeed float
---@field MinSpeed float
---@field StartSpeed float
---@field MultiSplineDefaultIndex int32
---@field FirstAccelerationIndex int32
---@field SecondAccelerationIndex int32
---@field SpeedRateParam float
---@field RotatorWaitTime float
---@field SpeedRateParamCurve UCurveFloat
---@field UseCurveTime float
---@field StartPointIndex int32
---@field IsStartForward boolean
---@field ForwardBuffID int32
---@field BackBuffID int32
---@field FollowStateRotationRate float
---@field bEnableTTTBRT boolean
---@field bEnableEnvInteraction boolean
---@field TraceDelay float
---@field TraceLength float
---@field Size float
---@field SampleCollectionProtectTime float
---@field OverrideSurfaceType SceneItemSurfaceType
---@field OverrideSurfacePersistTime float
---@field OverrideSurfaceFXActorTag FName
---@field bDrawDebug boolean
---@field DebugDrawOffset float
---@field FXComponentName TArray<FString>
---@field GlobalFXConfigList TArray<FGlobalFXConfigInfo>
---@field PointLightTag FGameplayTag
---@field LoopEvent FUAkEventConfig
---@field DeadEvent FUAkEventConfig
---@field BtlBGMBPConfig FBtlBGMBPConfig
---@field DrawDebugLine boolean
---@field bShowFootSpeed boolean
---@field bShowFootHeight boolean
---@field bUseFarStepAudio boolean
---@field LeftFootSpeedRefBoneName FName
---@field RightFootSpeedRefBoneName FName
---@field LeftFootLineTraceBoneName FName
---@field RightFootLineTraceBoneName FName
---@field LeftFootFrontSocket FName
---@field RightFootFrontSocket FName
---@field CameraShake TSubclassOf<UMatineeCameraShake>
---@field StepAudioPath FSoftObjectPath
---@field MoveActionTypeID int32
---@field bPrintStepAudioSwitchState boolean
---@field bMultiSpdForStepAK boolean
---@field bMyriapods boolean
---@field DecalMaterialPath FSoftObjectPath
---@field FootStepDecalSize FVector
---@field FootStepDecalOffset FVector
---@field FootStepDecalStartFadeOutTime float
---@field FootStepDecalFadeOutDuration float
---@field FoliageInteractSoundPriority FoliageInteractSoundPriority
---@field BeImmobilizedConfig UBGWDataAsset_BeImmobilizedConfig
---@field DA_PELevelConfig UBGWDataAsset_PELevelConfig
---@field AutoEnablePreciseDodge boolean
---@field DefaultAwardsLevel int32
---@field TolerantTimeSeconds float
---@field Awards TArray<FPreciseDodgeAwards>
---@field bDebugPreciseDodge boolean
---@field TransStageConfigID int32
---@field TransBackSkillID int32
---@field TransBackDurationTime float
---@field AbnormalAttrConfig UBGWDataAsset_AbnormalAttrConfig
---@field AbnormalStateImmueList TArray<Birth_AbnormalStateImmueType>
---@field BirthAbnormalStateList TArray<FBirth_AbnomalState>
---@field EffectIDList_SwitchWeaponPose TArray<int32>
---@field TriggerEffectCoolDown_SwitchWeaponPose float
---@field CostDMG_StartHeight float
---@field OverHeight_DmgAdditive_INV10000 int32
---@field FallDmg_DmgMax_INV10000 int32
---@field BaseDmg_INV10000 int32
---@field FallingSafeTime float
---@field LandCamShakeConfig FLandCamShake
---@field EnableDodge_InFalling boolean
---@field CanDodge_Distance float
---@field Dodge_DmgMul float
---@field EnableFloorDistanceCheck boolean
---@field bSaveInitData boolean
---@field ActorResetType EBGUResetType
---@field bEnableImpactAction boolean
---@field EnableImplactCalculationParameter float
---@field EnableImpactActionHeightDiff float
---@field EnableImpactAnimThreshold float
---@field LeftAngleSplitLine float
---@field MiddleLeftAngleSplitLine float
---@field MiddleRightAngleSplitLine float
---@field RightAngleSplitLine float
---@field ForwardImpactActionAnim UAnimMontage
---@field LeftSideImpactActionAnim UAnimMontage
---@field RightSideImpactActionAnim UAnimMontage
---@field InteractiveUnitID int32
---@field DefalutInteractiveGroupID int32
---@field ShopID int32
---@field InteractFuncList TArray<int32>
---@field RewardDropID int32
---@field InteractAnchorOverride FName
---@field ObjectMaterial InteractiveObjectMaterial
---@field PersistentDataDontResetOnNewGamePlus boolean
---@field bEnableFlyCtrl boolean
---@field CheckInterval float
---@field TraceIgnoreActorTags TArray<FName>
---@field FlyHeightMin float
---@field FlyHeightMax float
---@field FlyHeightMaxAbs float
---@field PushUpImpulse float
---@field PushDownImpulse float
---@field bLockZ boolean
---@field bPrintHitActor boolean
---@field DefaultComboGraphIndex int32
---@field ComboGraphTemplates TArray<UCalliopeAsset>
---@field ComboGraphTemplatesPath TArray<FString>
---@field bEnableDebugComboGraph boolean
---@field bEnableTurretControl boolean
---@field TurretTurnTriggerYaw float
---@field TurretTurnDelay float
---@field TurretTurnBlendTime float
---@field CameraGraphClass TSubclassOf<UGSCameraGraph>
---@field bCanAsPerformer boolean
---@field bBowWhenAfterShow boolean
---@field bWaitingPerformer boolean
---@field bWaitingWhenReturnHome boolean
---@field bStandingWaiting boolean
---@field bUseSceneItemPosition boolean
---@field WaitingLocationItemTag FName
---@field WaitingLocation FVector
---@field WaitingRotation FRotator
---@field WaitingAnim UAnimMontage
---@field WaitingStateConfig FPerformerStateConfig
---@field PreShowStateConfig FPerformerStateConfig
---@field ShowingStateConfig FPerformerStateConfig
---@field NPCInfoID int32
---@field bCanAsNPC boolean
---@field OverrideAnimConfig UBGWDataAsset_NPCAnimInfoConfig
---@field bCanAsFollowPartner boolean
---@field TouchWallFeedBack_EnableDebug boolean
---@field TouchWallFeedBack_TraceLength float
---@field TouchWallFeedBack_SpeedThreshold float
---@field HitDynamicObstacle_ProtectTime float
---@field CliffUnbalance_SpeedThreshold float
---@field CliffUnbalanceAMConfig FCliffUnbalanceAMConfig
---@field BossBarObserveTamerList TArray<FGsActorGuidReference>
---@field HatchConfigInfo FHatchConfigInfo
---@field PermanentWindMotorsDataAsset UBUC_DispLibDBCPermanentWEFMMotorDataAsset
---@field bDisableDataConvert boolean
UBUS_ExtendConfigComp = {}

function UBUS_ExtendConfigComp:PreSaveCS() end


---@class UBUS_FXActorBaseConfigComp : UActorEditCompBase
---@field FXActorConfig FFFXActorConfig
UBUS_FXActorBaseConfigComp = {}



---@class UBUS_FXAnimalCommComp : UActorCompBaseUObj
UBUS_FXAnimalCommComp = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function UBUS_FXAnimalCommComp:StartEscape(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end


---@class UBUS_FXAnimalDataComp : UBUS_ActorBaseDataComp
UBUS_FXAnimalDataComp = {}


---@class UBUS_FXAnimalEditComp : UActorEditCompBase
---@field SpeedType EFXAnimalSpeedType
---@field MoveSpeed float
---@field MoveType EFXAnimalMoveType
---@field Time_BeginToDisappear float
---@field Time_EscapeToDisappear float
---@field Time_DisappearToDestory float
UBUS_FXAnimalEditComp = {}



---@class UBUS_FXAudioEditComp : UActorEditCompBase
---@field LoopEvent FUAkEventConfig
---@field DestructibleEvent FUAkEventConfig
UBUS_FXAudioEditComp = {}



---@class UBUS_FXDataComp : UBUS_ActorBaseDataComp
UBUS_FXDataComp = {}


---@class UBUS_FixCameraTriggerConfigComp : UActorEditCompBase
---@field CanRetriggerCount int32
---@field TargetCamera ACameraActor
---@field TargetCameraOffset FVector
---@field BlendCameraDuration float
---@field BlendFunction EViewTargetBlendFunction
---@field BlendExp float
UBUS_FixCameraTriggerConfigComp = {}



---@class UBUS_FixCameraTriggerDataComp : UBUS_TriggerBoxDataComp
UBUS_FixCameraTriggerDataComp = {}


---@class UBUS_FlowDataComp : UBUS_ActorBaseDataComp
---@field FlowActorType FlowActorType
UBUS_FlowDataComp = {}



---@class UBUS_FoliageInteractSoundCompImpl : UActorCompBaseUObj
UBUS_FoliageInteractSoundCompImpl = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function UBUS_FoliageInteractSoundCompImpl:OnCollisionEndOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function UBUS_FoliageInteractSoundCompImpl:OnCollisionBeginOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end


---@class UBUS_ForceFightControllerConfigComp : UActorEditCompBase
---@field ForceFightControlConfig TArray<FFGSForceFightUnitGroupConfig>
UBUS_ForceFightControllerConfigComp = {}



---@class UBUS_ForceFightControllerDataComp : UBUS_AreaBaseDataContainer
UBUS_ForceFightControllerDataComp = {}


---@class UBUS_ForceOriginalFormAreaConfigComp : UActorEditCompBase
---@field OverrideSkills TMap<int32, int32>
---@field AutoEnable boolean
UBUS_ForceOriginalFormAreaConfigComp = {}



---@class UBUS_ForceOriginalFormAreaDataComp : UBUS_AreaBaseDataContainer
UBUS_ForceOriginalFormAreaDataComp = {}


---@class UBUS_ForceOriginalFormConfigComp : UActorEditCompBase
---@field OverrideSkills TMap<int32, int32>
---@field AutoEnable boolean
UBUS_ForceOriginalFormConfigComp = {}



---@class UBUS_ForceOriginalFormDataComp : UBUS_ActorBaseDataComp
UBUS_ForceOriginalFormDataComp = {}


---@class UBUS_GSEventCollection : UGSEventCollectionBase
UBUS_GSEventCollection = {}

---@param PredictionKeyId int32
---@param ParentPredictionKeyId int32
function UBUS_GSEventCollection:Evt_TestPredictServer(PredictionKeyId, ParentPredictionKeyId) end
function UBUS_GSEventCollection:Evt_TeleportBegin_Invoke() end
---@param p1 int32
---@param p2 FVector
function UBUS_GSEventCollection:Evt_ServerRPCTest_Invoke(p1, p2) end
function UBUS_GSEventCollection:Evt_TestPredictMultiCast() end
---@param p1 int32
---@param p2 AActor
function UBUS_GSEventCollection:Evt_ClientRPCTest_Invoke(p1, p2) end
---@param UnitState EBGUUnitState
---@param NeedForceUpdate boolean
---@param Time float
---@param PredictionKeyId int32
---@param ParentPredictionKeyId int32
function UBUS_GSEventCollection:Evt_UnitStatePredicServer(UnitState, NeedForceUpdate, Time, PredictionKeyId, ParentPredictionKeyId) end
function UBUS_GSEventCollection:Evt_TeleportFinish_Invoke() end
---@param p1 FString
function UBUS_GSEventCollection:Evt_InputActionPressServer(p1) end
function UBUS_GSEventCollection:Evt_ClearTargetInfo_Invoke() end
---@param StartJumpDir SkillDirection
---@param CurrentInput FVector2D
---@param PredictionKeyId int32
---@param ParentPredictionKeyId int32
function UBUS_GSEventCollection:Evt_TriggerJumpSkillServer(StartJumpDir, CurrentInput, PredictionKeyId, ParentPredictionKeyId) end
---@param P TArray<FString>
function UBUS_GSEventCollection:Evt_ExecuteCommandGMServer(P) end
---@param EndPlayReason EEndPlayReason::Type
function UBUS_GSEventCollection:EndPlayInCS(EndPlayReason) end
---@param PartId int32
---@param HitHP float
---@param HitWeight int32
function UBUS_GSEventCollection:Evt_TriggerHitInPartServer(PartId, HitHP, HitWeight) end
---@param FinalGuid FString
---@param NotifyTag FGameplayTag
function UBUS_GSEventCollection:Evt_NotifyGraphClientServer(FinalGuid, NotifyTag) end
---@param p1 float
function UBUS_GSEventCollection:Evt_RotateToTargetSvrServer(p1) end
function UBUS_GSEventCollection:Evt_TriggerPlayerRestServer() end
---@param ID int32
---@param RuleIDList TArray<int32>
---@param Reason MontageBindReason
---@param SkillDirection SkillDirection
---@param bNeedCheckSkillCanCast boolean
---@param PredictionKeyId int32
---@param ParentPredictionKeyId int32
function UBUS_GSEventCollection:Evt_SmartCastSkillTryServer(ID, RuleIDList, Reason, SkillDirection, bNeedCheckSkillCanCast, PredictionKeyId, ParentPredictionKeyId) end
---@param p1 float
function UBUS_GSEventCollection:Evt_StopSlotAnimationServer(p1) end
---@param UnitState EBGUUnitState
---@param NeedForceUpdate boolean
---@param Time float
function UBUS_GSEventCollection:Evt_UnitStatePredicMultiCast(UnitState, NeedForceUpdate, Time) end
---@param p1 FString
function UBUS_GSEventCollection:Evt_InputActionReleaseServer(p1) end
---@param p1 int32
function UBUS_GSEventCollection:Evt_ChargeSkillSuccessServer(p1) end
function UBUS_GSEventCollection:BeginPlayInCS() end
---@param BuffID int32
---@param Caster AActor
---@param RootCaster AActor
---@param Duration float
---@param BuffSourceType BuffSourceType
---@param bRecursed boolean
---@param BattleAttrSnapShot FBattleAttrSnapShot
function UBUS_GSEventCollection:Evt_BuffAdd_Multicast_Invoke(BuffID, Caster, RootCaster, Duration, BuffSourceType, bRecursed, BattleAttrSnapShot) end
---@param Player AActor
---@param DropId int32
---@param DropLevel int32
function UBUS_GSEventCollection:Evt_DropCollectionItemServer(Player, DropId, DropLevel) end
---@param StartJumpDir SkillDirection
---@param CurrentInput FVector2D
function UBUS_GSEventCollection:Evt_TriggerJumpSkillMultiCast(StartJumpDir, CurrentInput) end
---@param Attacker AActor
---@param DeadReason DeadReason
---@param DmgID int32
---@param StiffLevel int32
---@param BeAttackedAM UAnimMontage
---@param EffectInstReq FEffectInstReq
---@param bIsDotDmg boolean
---@param AbnormalStateType AbnormalStateType
function UBUS_GSEventCollection:Evt_UnitDead_Multicast_Invoke(Attacker, DeadReason, DmgID, StiffLevel, BeAttackedAM, EffectInstReq, bIsDotDmg, AbnormalStateType) end
function UBUS_GSEventCollection:Evt_Camera_ClearCamLockServer() end
---@param PartId int32
---@param HitHP float
---@param HitWeight int32
function UBUS_GSEventCollection:Evt_TriggerHitInPartMultiCast(PartId, HitHP, HitWeight) end
---@param p1 FString
function UBUS_GSEventCollection:Evt_InputActionPressMultiCast(p1) end
---@param P TArray<FString>
function UBUS_GSEventCollection:Evt_ExecuteCommandGMMultiCast(P) end
---@param p1 float
function UBUS_GSEventCollection:Evt_RotateToTargetSvrMultiCast(p1) end
---@param p1 int32
---@param p2 int32
function UBUS_GSEventCollection:Evt_OnlineChallengeBeginServer(p1, p2) end
---@param ID int32
---@param RuleIDList TArray<int32>
---@param Reason MontageBindReason
---@param SkillDirection SkillDirection
---@param bNeedCheckSkillCanCast boolean
function UBUS_GSEventCollection:Evt_SmartCastSkillTryMultiCast(ID, RuleIDList, Reason, SkillDirection, bNeedCheckSkillCanCast) end
---@param NewTargetInfo FUnitLockTargetInfo
function UBUS_GSEventCollection:Evt_SetTargetInfoServer_Invoke(NewTargetInfo) end
function UBUS_GSEventCollection:Evt_TriggerPlayerRestMultiCast() end
---@param FinalGuid FString
---@param NotifyTag FGameplayTag
function UBUS_GSEventCollection:Evt_NotifyGraphClientMultiCast(FinalGuid, NotifyTag) end
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_TestPredict_Confirm_Client(PredictionKeyId) end
---@param p1 float
function UBUS_GSEventCollection:Evt_StopSlotAnimationMultiCast(p1) end
---@param PredictionKeyId int32
---@param ParentPredictionKeyId int32
function UBUS_GSEventCollection:Evt_TriggerRootMotionJumpServer(PredictionKeyId, ParentPredictionKeyId) end
---@param BuffID int32
---@param RemoveTriggerType BuffEffectTriggerType
---@param Layer int32
---@param WithTriggerRemmoveEffect boolean
function UBUS_GSEventCollection:Evt_BuffRemove_Multicast_Invoke(BuffID, RemoveTriggerType, Layer, WithTriggerRemmoveEffect) end
---@param p1 int32
function UBUS_GSEventCollection:Evt_ChargeSkillSuccessMultiCast(p1) end
---@param p1 FString
function UBUS_GSEventCollection:Evt_InputActionReleaseMultiCast(p1) end
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_TestPredict_RollBack_Client(PredictionKeyId) end
---@param Player AActor
---@param DropId int32
---@param DropLevel int32
function UBUS_GSEventCollection:Evt_DropCollectionItemMultiCast(Player, DropId, DropLevel) end
---@param Target AActor
function UBUS_GSEventCollection:Evt_FinishRescueInteract_Invoke(Target) end
---@param RebirthType RebirthType
function UBUS_GSEventCollection:Evt_UnitRebirth_Multicast_Invoke(RebirthType) end
---@param State RebirthType
function UBUS_GSEventCollection:Evt_RebirthTeleportFinish_Invoke(State) end
---@param p1 int32
function UBUS_GSEventCollection:Evt_SkillRotate_Multicast_Invoke(p1) end
function UBUS_GSEventCollection:Evt_Camera_ClearCamLockMultiCast() end
---@param p1 int32
---@param p2 int32
function UBUS_GSEventCollection:Evt_OnlineChallengeBeginMultiCast(p1, p2) end
---@param Target AActor
function UBUS_GSEventCollection:Evt_FinishRescue_Multicast_Invoke(Target) end
---@param Montage UAnimMontage
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
---@param PredictionKeyId int32
---@param ParentPredictionKeyId int32
function UBUS_GSEventCollection:Evt_ClientMultiCastRPCTest2Server(Montage, PlayTimeRate, MontagePosOffset, StartSectionName, Reason, PredictionKeyId, ParentPredictionKeyId) end
---@param p1 int32
function UBUS_GSEventCollection:Evt_RecoveryPartDamageValueServer(p1) end
---@param Montage UAnimMontage
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
function UBUS_GSEventCollection:Evt_ClientMultiCastRPCTest1Server(Montage, PlayTimeRate, MontagePosOffset, StartSectionName, Reason) end
---@param Montage UAnimMontage
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
---@param PredictionKeyId int32
---@param ParentPredictionKeyId int32
function UBUS_GSEventCollection:Evt_CastSkillWithAnimMontageServer(Montage, PlayTimeRate, MontagePosOffset, StartSectionName, Reason, PredictionKeyId, ParentPredictionKeyId) end
---@param UnitState EBGUUnitState
---@param NeedForceUpdate boolean
---@param Time float
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_UnitStatePredic_Confirm_Client(UnitState, NeedForceUpdate, Time, PredictionKeyId) end
---@param IsHasBuffBefore boolean
---@param Caster AActor
---@param BuffID int32
---@param BuffDuration float
function UBUS_GSEventCollection:Evt_AddBuffNotify_Multicast_Invoke(IsHasBuffBefore, Caster, BuffID, BuffDuration) end
---@param RemoveTriggerType BuffEffectTriggerType
---@param WithTriggerRemmoveEffect boolean
function UBUS_GSEventCollection:Evt_BuffAllRemove_Multicast_Invoke(RemoveTriggerType, WithTriggerRemmoveEffect) end
function UBUS_GSEventCollection:Evt_GMUnitSuicide_Multicast_Invoke() end
function UBUS_GSEventCollection:Evt_TriggerRootMotionJumpMultiCast() end
---@param UnitState EBGUUnitState
---@param NeedForceUpdate boolean
---@param Time float
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_UnitStatePredic_RollBack_Client(UnitState, NeedForceUpdate, Time, PredictionKeyId) end
---@param Attacker AActor
---@param SkillDamageConfig FSkillDamageConfig
---@param EffectInstReq FEffectInstReq
---@param Attacker_AttrMemData FBattleAttrSnapShot
---@param PredictionKeyId int32
---@param ParentPredictionKeyId int32
function UBUS_GSEventCollection:Evt_TriggerNormalDamageEffectServer(Attacker, SkillDamageConfig, EffectInstReq, Attacker_AttrMemData, PredictionKeyId, ParentPredictionKeyId) end
---@param Success boolean
---@param Saver AActor
---@param BeSaver AActor
function UBUS_GSEventCollection:Evt_TriggerEndSave_Multicast_Invoke(Success, Saver, BeSaver) end
---@param EffectID int32
---@param Caster AActor
---@param Target AActor
---@param EffectInstReq FEffectInstReq
---@param PredictionKeyId int32
---@param ParentPredictionKeyId int32
function UBUS_GSEventCollection:Evt_TriggerSkillEffectBySkillServer(EffectID, Caster, Target, EffectInstReq, PredictionKeyId, ParentPredictionKeyId) end
---@param TalentID int32
---@param ChangeLevel int32
function UBUS_GSEventCollection:Evt_ActivateTalent_Multicast_Invoke(TalentID, ChangeLevel) end
---@param p1 int32
function UBUS_GSEventCollection:Evt_UnitEquipFaBao_Multicast_Invoke(p1) end
---@param StartJumpDir SkillDirection
---@param CurrentInput FVector2D
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_TriggerJumpSkill_Confirm_Client(StartJumpDir, CurrentInput, PredictionKeyId) end
---@param Montage UAnimMontage
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
function UBUS_GSEventCollection:Evt_ClientMultiCastRPCTest1MultiCast(Montage, PlayTimeRate, MontagePosOffset, StartSectionName, Reason) end
---@param Montage UAnimMontage
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
function UBUS_GSEventCollection:Evt_ClientMultiCastRPCTest2MultiCast(Montage, PlayTimeRate, MontagePosOffset, StartSectionName, Reason) end
---@param CSI FCastSkillInfo
---@param PredictionKeyId int32
---@param ParentPredictionKeyId int32
function UBUS_GSEventCollection:Evt_UnitCastSkillTryCMultiCastServer(CSI, PredictionKeyId, ParentPredictionKeyId) end
---@param StartJumpDir SkillDirection
---@param CurrentInput FVector2D
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_TriggerJumpSkill_RollBack_Client(StartJumpDir, CurrentInput, PredictionKeyId) end
---@param TriggerId EBUStateTrigger
---@param Time float
---@param NeedForceUpdate boolean
function UBUS_GSEventCollection:Evt_UnitStateTriggerCMultiCastServer(TriggerId, Time, NeedForceUpdate) end
---@param p1 int32
function UBUS_GSEventCollection:Evt_RecoveryPartDamageValueMultiCast(p1) end
---@param ID int32
---@param RuleIDList TArray<int32>
---@param Reason MontageBindReason
---@param SkillDirection SkillDirection
---@param bNeedCheckSkillCanCast boolean
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_SmartCastSkillTry_Confirm_Client(ID, RuleIDList, Reason, SkillDirection, bNeedCheckSkillCanCast, PredictionKeyId) end
---@param OldRoleLevel int32
---@param NewRoleLevel int32
function UBUS_GSEventCollection:Evt_RoleLevelChange_Multicast_Invoke(OldRoleLevel, NewRoleLevel) end
---@param ID int32
---@param RuleIDList TArray<int32>
---@param Reason MontageBindReason
---@param SkillDirection SkillDirection
---@param bNeedCheckSkillCanCast boolean
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_SmartCastSkillTry_RollBack_Client(ID, RuleIDList, Reason, SkillDirection, bNeedCheckSkillCanCast, PredictionKeyId) end
---@param CSI FCastSkillInfo
function UBUS_GSEventCollection:Evt_UnitCastSkillTry_Multicast_Invoke(CSI) end
---@param Actor1 AActor
---@param Actor2 AActor
---@param p1 int32
function UBUS_GSEventCollection:Evt_UpdateBuffCaster_Multicast_Invoke(Actor1, Actor2, p1) end
---@param Reason EBGUBulletDestroyReason
function UBUS_GSEventCollection:Evt_OnProjectileDead_Multicast_Invoke(Reason) end
---@param Actor AActor
function UBUS_GSEventCollection:Evt_TriggerFallDying_Multicast_Invoke(Actor) end
---@param p1 int32
---@param p2 int32
function UBUS_GSEventCollection:Evt_RemoveBuffNotify_Multicast_Invoke(p1, p2) end
---@param Montage UAnimMontage
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
function UBUS_GSEventCollection:Evt_CastSkillWithAnimMontageMultiCast(Montage, PlayTimeRate, MontagePosOffset, StartSectionName, Reason) end
---@param p1 int32
function UBUS_GSEventCollection:Evt_DeactivateTalent_Multicast_Invoke(p1) end
---@param EffectID int32
---@param EffectInstReq FEffectInstReq
---@param InnerTarget AActor
---@param bWithRPCEvent boolean
---@param PredictionKeyId int32
---@param ParentPredictionKeyId int32
function UBUS_GSEventCollection:Evt_TriggerSkillEffect_TransmitServer(EffectID, EffectInstReq, InnerTarget, bWithRPCEvent, PredictionKeyId, ParentPredictionKeyId) end
function UBUS_GSEventCollection:Evt_UnitUnequipFaBao_Multicast_Invoke() end
---@param NewTransform FTransform
---@param bSweep boolean
---@param bTeleport boolean
function UBUS_GSEventCollection:Evt_SetActorTransform_Multicast_Invoke(NewTransform, bSweep, bTeleport) end
---@param Attacker AActor
---@param SkillDamageConfig FSkillDamageConfig
---@param EffectInstReq FEffectInstReq
---@param Attacker_AttrMemData FBattleAttrSnapShot
function UBUS_GSEventCollection:Evt_TriggerNormalDamageEffectMultiCast(Attacker, SkillDamageConfig, EffectInstReq, Attacker_AttrMemData) end
---@param Target AActor
function UBUS_GSEventCollection:Evt_TriggrtInteractOnOtherClientServer(Target) end
---@param EffectID int32
---@param Caster AActor
---@param Target AActor
---@param EffectInstReq FEffectInstReq
function UBUS_GSEventCollection:Evt_TriggerSkillEffectBySkillMultiCast(EffectID, Caster, Target, EffectInstReq) end
function UBUS_GSEventCollection:Evt_TriggerGainKeyItem_Multicast_Invoke() end
---@param NewLocation FVector
---@param bSweep boolean
---@param bTeleport boolean
function UBUS_GSEventCollection:Evt_SetActorLocationGM_Multicast_Invoke(NewLocation, bSweep, bTeleport) end
---@param BuffID int32
---@param Duration float
---@param BuffSourceType BuffSourceType
---@param Caster AActor
function UBUS_GSEventCollection:Evt_BuffInstsDictOnAdd_Multicast_Invoke(BuffID, Duration, BuffSourceType, Caster) end
---@param RebirthType RebirthType
function UBUS_GSEventCollection:Evt_UnitRebirth_ByItem_Multicast_Invoke(RebirthType) end
---@param Montage UAnimMontage
---@param Scale float
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
---@param PredictionKeyId int32
---@param ParentPredictionKeyId int32
function UBUS_GSEventCollection:Evt_MoveWithAnimMontageCMultiCastServer(Montage, Scale, PlayTimeRate, MontagePosOffset, StartSectionName, Reason, PredictionKeyId, ParentPredictionKeyId) end
---@param TriggerId EBUStateTrigger
---@param Time float
---@param NeedForceUpdate boolean
function UBUS_GSEventCollection:Evt_UnitStateTriggerCMultiCastMultiCast(TriggerId, Time, NeedForceUpdate) end
---@param CSI FCastSkillInfo
function UBUS_GSEventCollection:Evt_UnitCastSkillTryCMultiCastMultiCast(CSI) end
---@param EquipPosition EquipPosition
---@param EquipID int32
function UBUS_GSEventCollection:Evt_InitDaShenEquipData_Multicast_Invoke(EquipPosition, EquipID) end
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_TriggerRootMotionJump_Confirm_Client(PredictionKeyId) end
---@param Montage UAnimMontage
---@param Scale float
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
function UBUS_GSEventCollection:Evt_MoveWithAnimMontage_Multicast_Invoke(Montage, Scale, PlayTimeRate, MontagePosOffset, StartSectionName, Reason) end
---@param RebirthPointConfigID int32
---@param TeleportReason TeleportReason
function UBUS_GSEventCollection:Evt_TeleportWithRebirthPointFailedServer(RebirthPointConfigID, TeleportReason) end
---@param EffectID int32
---@param EffectInstReq FEffectInstReq
---@param InnerTarget AActor
---@param bWithRPCEvent boolean
function UBUS_GSEventCollection:Evt_TriggerSkillEffect_TransmitMultiCast(EffectID, EffectInstReq, InnerTarget, bWithRPCEvent) end
---@param p1 boolean
function UBUS_GSEventCollection:Evt_SwitchNoInteraction_Multicast_Invoke(p1) end
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_TriggerRootMotionJump_RollBack_Client(PredictionKeyId) end
---@param p1 int32
function UBUS_GSEventCollection:Evt_OnIncreaseMaxPELevel_Multicast_Invoke(p1) end
---@param GroupId int32
---@param InteractUnitState EBGUInteractUnitState
function UBUS_GSEventCollection:Evt_InteractGroup_Update_Multicast_Invoke(GroupId, InteractUnitState) end
---@param Target AActor
function UBUS_GSEventCollection:Evt_TriggrtInteractOnOtherClientMultiCast(Target) end
---@param Montage UAnimMontage
---@param Scale float
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
function UBUS_GSEventCollection:Evt_MoveWithAnimMontageCMultiCastMultiCast(Montage, Scale, PlayTimeRate, MontagePosOffset, StartSectionName, Reason) end
function UBUS_GSEventCollection:Evt_TriggerResetAllActors_Multicast_Invoke() end
---@param BulletDispReason EBGUBulletDispReason
---@param EffectInstReq FEffectInstReq
---@param BeHitActor AActor
function UBUS_GSEventCollection:Evt_SpawnBulletFXByReason_Multicast_Invoke(BulletDispReason, EffectInstReq, BeHitActor) end
---@param p1 boolean
function UBUS_GSEventCollection:Evt_ShouledUpdateBuffTime_Multicast_Invoke(p1) end
---@param BuffID int32
---@param RemoveTriggerType BuffEffectTriggerType
---@param WithTriggerRemmoveEffect boolean
function UBUS_GSEventCollection:Evt_BuffRemoveImmediately_Multicast_Invoke(BuffID, RemoveTriggerType, WithTriggerRemmoveEffect) end
---@param p1 int32
function UBUS_GSEventCollection:Evt_BuffInstsDictOnRemove_Multicast_Invoke(p1) end
---@param Montage UAnimMontage
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_ClientMultiCastRPCTest2_Confirm_Client(Montage, PlayTimeRate, MontagePosOffset, StartSectionName, Reason, PredictionKeyId) end
---@param TargetActor AActor
---@param turnSpeed float
function UBUS_GSEventCollection:Evt_SkillRotateTraceActor_Multicast_Invoke(TargetActor, turnSpeed) end
---@param AttrID EBGUAttrFloat
---@param IncreaseValue float
function UBUS_GSEventCollection:Evt_FTB_IncreaseAttrFloat_Multicast_Invoke(AttrID, IncreaseValue) end
---@param Montage UAnimMontage
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_ClientMultiCastRPCTest2_RollBack_Client(Montage, PlayTimeRate, MontagePosOffset, StartSectionName, Reason, PredictionKeyId) end
---@param p1 int32
function UBUS_GSEventCollection:Evt_OnlineChallengeEndToUI_Multicast_Invoke(p1) end
---@param Montage UAnimMontage
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
---@param PredictionKeyId int32
---@param ParentPredictionKeyId int32
---@param __TriggerActor AActor
function UBUS_GSEventCollection:Evt_ClientMultiCastRPCTest2SPTransmitServer(Montage, PlayTimeRate, MontagePosOffset, StartSectionName, Reason, PredictionKeyId, ParentPredictionKeyId, __TriggerActor) end
---@param EquipPosition EquipPosition
---@param EquipID int32
function UBUS_GSEventCollection:Evt_BattleLogicChangeEquip_Multicast_Invoke(EquipPosition, EquipID) end
---@param Montage UAnimMontage
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_CastSkillWithAnimMontage_Confirm_Client(Montage, PlayTimeRate, MontagePosOffset, StartSectionName, Reason, PredictionKeyId) end
---@param RebirthPointConfigID int32
---@param TeleportReason TeleportReason
function UBUS_GSEventCollection:Evt_TeleportWithRebirthPointFailedMultiCast(RebirthPointConfigID, TeleportReason) end
---@param Tag FGameplayTag
function UBUS_GSEventCollection:Evt_SceneObjTransitByEvent_Multicast_Invoke(Tag) end
function UBUS_GSEventCollection:Evt_OnClientBeginPlayReqForInitEquip_Invoke() end
---@param EffectID int32
---@param Caster AActor
---@param Target AActor
---@param EffectInstReq FEffectInstReq
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_TriggerSkillEffectBySkill_Confirm_Client(EffectID, Caster, Target, EffectInstReq, PredictionKeyId) end
---@param Attacker AActor
---@param SkillDamageConfig FSkillDamageConfig
---@param EffectInstReq FEffectInstReq
---@param Attacker_AttrMemData FBattleAttrSnapShot
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_TriggerNormalDamageEffect_Confirm_Client(Attacker, SkillDamageConfig, EffectInstReq, Attacker_AttrMemData, PredictionKeyId) end
---@param Montage UAnimMontage
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_CastSkillWithAnimMontage_RollBack_Client(Montage, PlayTimeRate, MontagePosOffset, StartSectionName, Reason, PredictionKeyId) end
---@param EffectID int32
---@param Caster AActor
---@param Target AActor
---@param EffectInstReq FEffectInstReq
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_TriggerSkillEffectBySkill_RollBack_Client(EffectID, Caster, Target, EffectInstReq, PredictionKeyId) end
---@param CSI FCastSkillInfo
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_UnitCastSkillTryCMultiCast_Confirm_Client(CSI, PredictionKeyId) end
---@param Attacker AActor
---@param SkillDamageConfig FSkillDamageConfig
---@param EffectInstReq FEffectInstReq
---@param Attacker_AttrMemData FBattleAttrSnapShot
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_TriggerNormalDamageEffect_RollBack_Client(Attacker, SkillDamageConfig, EffectInstReq, Attacker_AttrMemData, PredictionKeyId) end
function UBUS_GSEventCollection:Evt_RelieveImmobilizedClient_Multicast_Invoke() end
---@param BuffID int32
---@param Target AActor
---@param EffectIdx int32
---@param EffectInstReq FEffectInstReq
---@param bIsPeriodical boolean
function UBUS_GSEventCollection:Evt_TriggerSkillEffectByBuff_Multicast_Invoke(BuffID, Target, EffectIdx, EffectInstReq, bIsPeriodical) end
---@param Attacker AActor
---@param SkillDamageConfig FSkillDamageConfig
---@param EffectInstReq FEffectInstReq
---@param Attacker_AttrMemData FBattleAttrSnapShot
---@param PredictionKeyId int32
---@param ParentPredictionKeyId int32
---@param __TriggerActor AActor
function UBUS_GSEventCollection:Evt_TriggerNormalDamageEffectSPTransmitServer(Attacker, SkillDamageConfig, EffectInstReq, Attacker_AttrMemData, PredictionKeyId, ParentPredictionKeyId, __TriggerActor) end
---@param BuffID int32
---@param Layer_OldValue int32
---@param Layer_NewValue int32
function UBUS_GSEventCollection:Evt_OnBuffLayerChangedNotify_Multicast_Invoke(BuffID, Layer_OldValue, Layer_NewValue) end
---@param p1 int32
---@param p2 int32
function UBUS_GSEventCollection:Evt_OnlineChallengeBeginToUI_Multicast_Invoke(p1, p2) end
---@param EffectID int32
---@param EffectInstReq FEffectInstReq
---@param InnerTarget AActor
---@param bWithRPCEvent boolean
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_TriggerSkillEffect_Transmit_Confirm_Client(EffectID, EffectInstReq, InnerTarget, bWithRPCEvent, PredictionKeyId) end
---@param MMState State_MM
function UBUS_GSEventCollection:Evt_ChangeMotionMatchingState_Multicast_Invoke(MMState) end
---@param p1 FString
function UBUS_GSEventCollection:Evt_ChallenegeRebirthTeleport_Multicast_Invoke(p1) end
---@param CSI FCastSkillInfo
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_UnitCastSkillTryCMultiCast_RollBack_Client(CSI, PredictionKeyId) end
---@param Montage UAnimMontage
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
---@param __TriggerActor AActor
function UBUS_GSEventCollection:Evt_ClientMultiCastRPCTest2SPTransmitMultiCast(Montage, PlayTimeRate, MontagePosOffset, StartSectionName, Reason, __TriggerActor) end
---@param NewTargetInfo FUnitLockTargetInfo
function UBUS_GSEventCollection:Evt_SetTargetInfoWithCameraLockingServer_Invoke(NewTargetInfo) end
---@param EffectID int32
---@param EffectInstReq FEffectInstReq
---@param InnerTarget AActor
---@param bWithRPCEvent boolean
---@param PredictionKeyId int32
---@param ParentPredictionKeyId int32
---@param __TriggerActor AActor
function UBUS_GSEventCollection:Evt_TriggerSkillEffect_TransmitSPTransmitServer(EffectID, EffectInstReq, InnerTarget, bWithRPCEvent, PredictionKeyId, ParentPredictionKeyId, __TriggerActor) end
---@param EffectID int32
---@param EffectInstReq FEffectInstReq
---@param InnerTarget AActor
---@param bWithRPCEvent boolean
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_TriggerSkillEffect_Transmit_RollBack_Client(EffectID, EffectInstReq, InnerTarget, bWithRPCEvent, PredictionKeyId) end
---@param Attacker AActor
---@param SkillDamageConfig FSkillDamageConfig
---@param EffectInstReq FEffectInstReq
---@param Attacker_AttrMemData FBattleAttrSnapShot
---@param __TriggerActor AActor
function UBUS_GSEventCollection:Evt_TriggerNormalDamageEffectSPTransmitMultiCast(Attacker, SkillDamageConfig, EffectInstReq, Attacker_AttrMemData, __TriggerActor) end
---@param Montage UAnimMontage
---@param Scale float
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_MoveWithAnimMontageCMultiCast_Confirm_Client(Montage, Scale, PlayTimeRate, MontagePosOffset, StartSectionName, Reason, PredictionKeyId) end
---@param Montage UAnimMontage
---@param Scale float
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
---@param PredictionKeyId int32
function UBUS_GSEventCollection:Evt_MoveWithAnimMontageCMultiCast_RollBack_Client(Montage, Scale, PlayTimeRate, MontagePosOffset, StartSectionName, Reason, PredictionKeyId) end
function UBUS_GSEventCollection:Evt_TestEventCollectionMultiCast_Multicast_Invoke() end
---@param AMScaleType EAMScaleType
---@param AMScaleAxis EAMScaleRateAxis
---@param LandingTraceLength float
---@param PureScaleValue float
---@param CachedDataID int32
---@param AttackRangeLimit boolean
---@param DebugMode boolean
---@param TotalDuration float
---@param NotifyBeginTime float
---@param NotifyEndTime float
---@param AMScaleMinRate float
---@param AMScaleMaxRate float
---@param AMScaleMoveOffset float
---@param AMScaleMoveOffsetZ float
function UBUS_GSEventCollection:Evt_SetAMScaleRateByPosMultiCast_Multicast_Invoke(AMScaleType, AMScaleAxis, LandingTraceLength, PureScaleValue, CachedDataID, AttackRangeLimit, DebugMode, TotalDuration, NotifyBeginTime, NotifyEndTime, AMScaleMinRate, AMScaleMaxRate, AMScaleMoveOffset, AMScaleMoveOffsetZ) end
---@param EffectID int32
---@param EffectInstReq FEffectInstReq
---@param InnerTarget AActor
---@param bWithRPCEvent boolean
---@param __TriggerActor AActor
function UBUS_GSEventCollection:Evt_TriggerSkillEffect_TransmitSPTransmitMultiCast(EffectID, EffectInstReq, InnerTarget, bWithRPCEvent, __TriggerActor) end
function UBUS_GSEventCollection:Evt_BattleLogicResetEquipIllusion_Multicast_Invoke() end
---@param EquipIllusionConfigPath FString
function UBUS_GSEventCollection:Evt_BattleLogicChangeEquipIllusion_Multicast_Invoke(EquipIllusionConfigPath) end
---@param Montage UAnimMontage
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
---@param PredictionKeyId int32
---@param __TriggerActor AActor
function UBUS_GSEventCollection:Evt_ClientMultiCastRPCTest2_SPTransmitConfirm_Client(Montage, PlayTimeRate, MontagePosOffset, StartSectionName, Reason, PredictionKeyId, __TriggerActor) end
---@param p1 int32
function UBUS_GSEventCollection:Evt_TestEventCollectionIntMultiCast_Multicast_Invoke(p1) end
---@param Montage UAnimMontage
---@param PlayTimeRate float
---@param MontagePosOffset float
---@param StartSectionName FName
---@param Reason MontageBindReason
---@param PredictionKeyId int32
---@param __TriggerActor AActor
function UBUS_GSEventCollection:Evt_ClientMultiCastRPCTest2_SPTransmitRollBack_Client(Montage, PlayTimeRate, MontagePosOffset, StartSectionName, Reason, PredictionKeyId, __TriggerActor) end
---@param p1 FName
function UBUS_GSEventCollection:Evt_TestEventCollectionNameMultiCast_Multicast_Invoke(p1) end
---@param p1 float
function UBUS_GSEventCollection:Evt_TestEventCollectionFloatMultiCast_Multicast_Invoke(p1) end
---@param Actor AActor
function UBUS_GSEventCollection:Evt_TestEventCollectionActorMultiCast_Multicast_Invoke(Actor) end
---@param Attacker AActor
---@param SkillDamageConfig FSkillDamageConfig
---@param EffectInstReq FEffectInstReq
---@param Attacker_AttrMemData FBattleAttrSnapShot
---@param PredictionKeyId int32
---@param __TriggerActor AActor
function UBUS_GSEventCollection:Evt_TriggerNormalDamageEffect_SPTransmitConfirm_Client(Attacker, SkillDamageConfig, EffectInstReq, Attacker_AttrMemData, PredictionKeyId, __TriggerActor) end
---@param Tag FGameplayTag
function UBUS_GSEventCollection:Evt_SceneObjTransitByEventNoSaveState_Multicast_Invoke(Tag) end
---@param Object UObject
function UBUS_GSEventCollection:Evt_TestEventCollectionObjectMultiCast_Multicast_Invoke(Object) end
---@param Attacker AActor
---@param SkillDamageConfig FSkillDamageConfig
---@param EffectInstReq FEffectInstReq
---@param Attacker_AttrMemData FBattleAttrSnapShot
---@param PredictionKeyId int32
---@param __TriggerActor AActor
function UBUS_GSEventCollection:Evt_TriggerNormalDamageEffect_SPTransmitRollBack_Client(Attacker, SkillDamageConfig, EffectInstReq, Attacker_AttrMemData, PredictionKeyId, __TriggerActor) end
---@param p1 FString
function UBUS_GSEventCollection:Evt_TestEventCollectionStringMultiCast_Multicast_Invoke(p1) end
---@param Vector FVector
function UBUS_GSEventCollection:Evt_TestEventCollectionVectorMultiCast_Multicast_Invoke(Vector) end
---@param EffectID int32
---@param EffectInstReq FEffectInstReq
---@param InnerTarget AActor
---@param bWithRPCEvent boolean
---@param PredictionKeyId int32
---@param __TriggerActor AActor
function UBUS_GSEventCollection:Evt_TriggerSkillEffect_Transmit_SPTransmitConfirm_Client(EffectID, EffectInstReq, InnerTarget, bWithRPCEvent, PredictionKeyId, __TriggerActor) end
---@param EffectID int32
---@param EffectInstReq FEffectInstReq
---@param InnerTarget AActor
---@param bWithRPCEvent boolean
---@param PredictionKeyId int32
---@param __TriggerActor AActor
function UBUS_GSEventCollection:Evt_TriggerSkillEffect_Transmit_SPTransmitRollBack_Client(EffectID, EffectInstReq, InnerTarget, bWithRPCEvent, PredictionKeyId, __TriggerActor) end


---@class UBUS_GamePlusSpawnComp : UActorEditCompBase
---@field GamePlusSpawnConfigList TArray<FGamePlusSpawnConfig>
---@field TaskStageID int32
---@field TaskStageStage TaskCollectionState
---@field CollectionCountMax int32
UBUS_GamePlusSpawnComp = {}



---@class UBUS_GamePlusSpawnDataComp : UBUS_FlowDataComp
UBUS_GamePlusSpawnDataComp = {}


---@class UBUS_GateStateMachineConfigComp : UActorEditCompBase
---@field StartWithClosed boolean
---@field ManualStateControl boolean
---@field GateStateMachineType GateStateMachineType
UBUS_GateStateMachineConfigComp = {}



---@class UBUS_GateStateMachineDataComp : UBUS_ActorBaseDataComp
UBUS_GateStateMachineDataComp = {}


---@class UBUS_GhostActorDataComp : UBUS_ActorBaseDataComp
UBUS_GhostActorDataComp = {}


---@class UBUS_GroupAIAreaComp : UActorEditCompBase
---@field GroupAIMgrConfigDA UBGWGroupAIMgrConfigDataAsset
---@field GroupAIBattleHotZoneConfigDA UBGWGroupAIBattleHotZoneConfigDataAsset
UBUS_GroupAIAreaComp = {}



---@class UBUS_GroupAIAreaCompImpl : UActorCompBaseUObj
UBUS_GroupAIAreaCompImpl = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function UBUS_GroupAIAreaCompImpl:OverlapEnd(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end
---@param OverlappedActor AActor
---@param OtherActor AActor
function UBUS_GroupAIAreaCompImpl:OverlapBegin(OverlappedActor, OtherActor) end


---@class UBUS_GroupAIAreaConfigInfoComp : UActorEditCompBase
---@field GroupAIMgrConfigDA UBGWGroupAIMgrConfigDataAsset
---@field GroupAIBattleHotZoneConfigDA UBGWGroupAIBattleHotZoneConfigDataAsset
UBUS_GroupAIAreaConfigInfoComp = {}



---@class UBUS_GroupAIAreaDataComp : UBUS_ActorBaseDataComp
UBUS_GroupAIAreaDataComp = {}


---@class UBUS_GroupAIDataComp : UBUS_AreaBaseDataContainer
UBUS_GroupAIDataComp = {}


---@class UBUS_GuidComp : UActorEditCompBase
---@field bForceEditRandomGuid boolean
---@field UnitRandomGuid FString
UBUS_GuidComp = {}



---@class UBUS_IgnoreSkillMappingAreaConfigComp : UActorEditCompBase
---@field SkillMappingTypeMask int32
---@field SkillMappingResultRullMask int32
UBUS_IgnoreSkillMappingAreaConfigComp = {}



---@class UBUS_IgnoreSkillMappingAreaDataComp : UBUS_AreaBaseDataContainer
UBUS_IgnoreSkillMappingAreaDataComp = {}


---@class UBUS_InteractComp : UActorEditCompBase
---@field InteractiveUnitID int32
---@field DefalutInteractiveGroupID int32
---@field ShopID int32
---@field RewardDropID int32
---@field InteractAnchorOverride FName
---@field ObjectMaterial InteractiveObjectMaterial
---@field ActivableDistance float
UBUS_InteractComp = {}



---@class UBUS_InteractDrawConfigComp : UActorEditCompBase
---@field MPC UMaterialParameterCollection
---@field NPC UNiagaraParameterCollection
---@field M_CombineTexture UMaterial
---@field RT_LandscapeMap UTextureRenderTarget2D
---@field RT_DataStorage UTextureRenderTarget2D
UBUS_InteractDrawConfigComp = {}



---@class UBUS_InteractiveActorDataComp : UBUS_ActorBaseDataComp
UBUS_InteractiveActorDataComp = {}


---@class UBUS_IntervalTriggerAreaConfigComp : UActorEditCompBase
---@field AutoEnable boolean
---@field TriggerInterval float
---@field DuringTime float
---@field AddBuffList TArray<int32>
---@field PlayerAddBuffList TArray<int32>
---@field IgnoredChrs TArray<TSoftObjectPtr<ABUTamerActor>>
---@field IgnoredPerceptionSettingChrs TArray<TSoftObjectPtr<ABUTamerActor>>
---@field AIPerceptionSetting UBGWDataAsset_AIPerceptionConfig
---@field PostProcessMatConfig UBGWDataAsset_PostProcessMatSetting
---@field AkEventBegin UAkAudioEvent
---@field AkEventStop UAkAudioEvent
---@field VolumeBGMConfigDA UBGWBGMConfigDataAsset
---@field VolumeGroupConfig FFBGMVolumeGroupConfig
UBUS_IntervalTriggerAreaConfigComp = {}



---@class UBUS_IntervalTriggerAreaDataComp : UBUS_AreaBaseDataContainer
UBUS_IntervalTriggerAreaDataComp = {}


---@class UBUS_IntervalTriggerConfigComp : UActorEditCompBase
---@field Timer float
---@field DuringTimer float
---@field WarningTime float
---@field WarningBuffID int32
---@field AddBuffList TArray<int32>
---@field SpAddBuff int32
---@field SpUnits TArray<FGsActorGuidReference>
---@field PlayerAddBuffList TArray<int32>
---@field IgnoredChrs TArray<FGsActorGuidReference>
---@field IgnoredPerceptionSettingChrs TArray<FGsActorGuidReference>
---@field AIPerceptionSetting UBGWDataAsset_AIPerceptionConfig
---@field PostProcessMatConfig UBGWDataAsset_PostProcessMatSetting
UBUS_IntervalTriggerConfigComp = {}



---@class UBUS_IntervalTriggerDataComp : UBUS_ActorBaseDataComp
UBUS_IntervalTriggerDataComp = {}


---@class UBUS_ItemInteractAreaSystem_CPU : UActorCompBaseUObj
---@field LocalPlayer AActor
UBUS_ItemInteractAreaSystem_CPU = {}

---@param OverlappedActor AActor
---@param OtherActor AActor
function UBUS_ItemInteractAreaSystem_CPU:OnActorEnter(OverlappedActor, OtherActor) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function UBUS_ItemInteractAreaSystem_CPU:OnActorLeave(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end


---@class UBUS_JJSObstacleConfigComp : UActorEditCompBase
---@field bDefaultEnable boolean
---@field bOpenWhenSpecialSkillHit boolean
---@field SpecialSkillList TArray<int32>
---@field OpenFx TSoftObjectPtr<UNiagaraSystem>
---@field OpenFxTransform FTransform
---@field OpenAudio TSoftObjectPtr<UAkAudioEvent>
---@field OpenStateLoopAudio TSoftObjectPtr<UAkAudioEvent>
---@field CloseFx TSoftObjectPtr<UNiagaraSystem>
---@field CloseFxTransform FTransform
---@field CloseAudio TSoftObjectPtr<UAkAudioEvent>
---@field CloseStateLoopAudio TSoftObjectPtr<UAkAudioEvent>
UBUS_JJSObstacleConfigComp = {}



---@class UBUS_JJSObstacleDataComp : UBUS_ActorBaseDataComp
UBUS_JJSObstacleDataComp = {}


---@class UBUS_LandingZoneComp : UActorCompBaseUObj
UBUS_LandingZoneComp = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function UBUS_LandingZoneComp:OnCollisionEndOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function UBUS_LandingZoneComp:OnCollisionBeginOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end


---@class UBUS_LandingZoneDataComp : UBUS_ActorBaseDataComp
UBUS_LandingZoneDataComp = {}


---@class UBUS_LeavesSkillManageComp : UBaseActorCompTickable
---@field FXTag FName
---@field PreStageTime float
---@field AbsorbStageTime float
---@field FlyStageMaxTime float
---@field ScatterStageTime float
UBUS_LeavesSkillManageComp = {}

---@param EndPlayReason EEndPlayReason::Type
function UBUS_LeavesSkillManageComp:EndPlayInCS(EndPlayReason) end
function UBUS_LeavesSkillManageComp:BeginPlayInCS() end
---@param DeltaTime float
function UBUS_LeavesSkillManageComp:TickComponentInCS(DeltaTime) end


---@class UBUS_LightningFXActorDataComp : UBUS_FXDataComp
UBUS_LightningFXActorDataComp = {}


---@class UBUS_LightningFXSpawnComp : UActorEditCompBase
---@field LightningFXSpawnConfig FLightningFXSpawnConfig
UBUS_LightningFXSpawnComp = {}



---@class UBUS_MFDirectionComp : UActorEditCompBase
---@field DirectionUsage MagicFieldDirectionUsage
---@field DirectionType MagicFieldDirectionType
---@field DirectionTypeDetail MagicFieldDirectionTypeDetail
---@field AnchorPointTag FName
---@field DirectionEffects TArray<FMFDirectionEffect>
UBUS_MFDirectionComp = {}



---@class UBUS_MFNegativeOverlapComp : UActorCompBaseUObj
UBUS_MFNegativeOverlapComp = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComponent UPrimitiveComponent
function UBUS_MFNegativeOverlapComp:OverlapEnd(OverlappedComponent, OtherActor, OtherComponent) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComponent UPrimitiveComponent
function UBUS_MFNegativeOverlapComp:OverlapBegin(OverlappedComponent, OtherActor, OtherComponent) end


---@class UBUS_MagicFieldDataComp : UBUS_ProjectileBaseDataComp
UBUS_MagicFieldDataComp = {}


---@class UBUS_ManualSplineMoveCompImpl : UActorCompBaseUObj
UBUS_ManualSplineMoveCompImpl = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function UBUS_ManualSplineMoveCompImpl:OnCollisionEndOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function UBUS_ManualSplineMoveCompImpl:OnCollisionBeginOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end


---@class UBUS_ManualSplineMoveVolumeComp : UActorEditCompBase
---@field ForwardSplineAnimConfig UBGWDataAsset_ManualSplineMoveAnimConfig
---@field ReverseSplineAnimConfig UBGWDataAsset_ManualSplineMoveAnimConfig
UBUS_ManualSplineMoveVolumeComp = {}



---@class UBUS_ManualSplineMoveVolumeDataComp : UBUS_ActorBaseDataComp
UBUS_ManualSplineMoveVolumeDataComp = {}


---@class UBUS_MapSymbolConfigComp : UActorEditCompBase
---@field MapSymbolConfig FMapSymbolConfig
UBUS_MapSymbolConfigComp = {}



---@class UBUS_MeditationPointConfigComp : UActorEditCompBase
---@field MeditationPointConfig FMeditationPointConfig
UBUS_MeditationPointConfigComp = {}



---@class UBUS_MeditationPointDataComp : UBUS_InteractiveActorDataComp
UBUS_MeditationPointDataComp = {}


---@class UBUS_MessageDistributionCenter : UActorEditCompBase
---@field BattleEventMap TMap<FGameplayTag, FGameplayTag>
UBUS_MessageDistributionCenter = {}



---@class UBUS_ModularMgrConfigComp : UActorEditCompBase
---@field ModularFolderPath FString
---@field ModularActorTemplate TSubclassOf<AActor>
---@field ContextTamerActor ABUTamerActor
---@field bAutoAttachModularActors boolean
---@field bNeedsCopyPose boolean
---@field ModularActorSpawnInnerRange float
---@field ModularActorSpawnOuterRange float
---@field bAutoSnapToGround boolean
---@field bUseRandomLocationZ boolean
---@field bUseRandomRotation boolean
---@field bDestroyAfterOwnerDeath boolean
---@field BreakDownProjectileMap TMap<FName, int32>
UBUS_ModularMgrConfigComp = {}



---@class UBUS_ModularMgrDataComp : UBUS_ActorBaseDataComp
UBUS_ModularMgrDataComp = {}


---@class UBUS_MovePhysicsTransformCompImpl : UActorCompBaseUObj
UBUS_MovePhysicsTransformCompImpl = {}

---@param HitComp UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param HitImpule FVector
---@param Hit FHitResult
function UBUS_MovePhysicsTransformCompImpl:OnRootCompHit(HitComp, OtherActor, OtherComp, HitImpule, Hit) end


---@class UBUS_MovementSystem : UActorCompBaseUObj
---@field PlayerCameraManager APlayerCameraManager
---@field CppCharacterMovementComp UBGUCharacterMovementComponent
---@field CrowdFollowComp UBGUCrowdFollowingComponent
UBUS_MovementSystem = {}

---@param MoveRequestID int32
---@param Result EPathFollowingResult::Type
function UBUS_MovementSystem:OnAIPathMoveModeMoveComplete(MoveRequestID, Result) end
---@param Data FDoNNavigationQueryData
function UBUS_MovementSystem:AIFlyPathMoveMode_Pathfinding_OnFinish(Data) end
---@param Data FDonNavigationDynamicCollisionPayload
function UBUS_MovementSystem:AIFlyPathMoveMode_Pathfinding_OnDynamicCollisionAlert(Data) end


---@class UBUS_NameTriggerConfigComp : UActorEditCompBase
---@field NameID int32
---@field Duration float
UBUS_NameTriggerConfigComp = {}



---@class UBUS_NameTriggerDataComp : UBUS_TriggerBoxDataComp
UBUS_NameTriggerDataComp = {}


---@class UBUS_NarratorDataComp : UBUS_ActorBaseDataComp
UBUS_NarratorDataComp = {}


---@class UBUS_NeutralAnimalAreaConfigInfoComp : UActorEditCompBase
---@field bDrawDebug boolean
---@field DestroyAllAnimalWhenPlaySeq boolean
---@field DontSpawnInCloudMove boolean
---@field DistributionSpawnTendency AnimalDistributionSpawnTendency
---@field PresetCD float
---@field SpawnCD float
---@field DestroyProtectCD float
---@field SpawnPosType AnimalSpawnPosType
---@field AnimalTemplates TArray<FAnimalSpawnTemplate>
---@field EQSTemplate UEnvQuery
---@field SpawnRotType AnimalSpawnRotType
UBUS_NeutralAnimalAreaConfigInfoComp = {}



---@class UBUS_NeutralAnimalSpawnAreaDataComp : UBUS_AreaBaseDataContainer
UBUS_NeutralAnimalSpawnAreaDataComp = {}


---@class UBUS_NeutralFXAnimalSpawnConfigComp : UActorEditCompBase
---@field Outside_Dist float
---@field Outside_Spd_Threshold float
---@field RandomNiagaraTemplateList TArray<UNiagaraSystem>
---@field destroyTime float
---@field SpawnMomentType EFXAnimalSpawnMomentType
UBUS_NeutralFXAnimalSpawnConfigComp = {}



---@class UBUS_NeutralFXAnimalSpawnLogicComp : UActorCompBaseUObj
UBUS_NeutralFXAnimalSpawnLogicComp = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function UBUS_NeutralFXAnimalSpawnLogicComp:StartEscape(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function UBUS_NeutralFXAnimalSpawnLogicComp:StartEscapeWitchSpdCheck(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end


---@class UBUS_NeutralFXAnimalSpawnPointDataComp : UBUS_ActorBaseDataComp
UBUS_NeutralFXAnimalSpawnPointDataComp = {}


---@class UBUS_OnFightTriggerConfigComp : UActorEditCompBase
---@field TargetUnit ABGUCharacterCS
---@field OnFightSkillID int32
UBUS_OnFightTriggerConfigComp = {}



---@class UBUS_OnFightTriggerDataComp : UBUS_TriggerBoxDataComp
UBUS_OnFightTriggerDataComp = {}


---@class UBUS_OnlineAssistTriggerConfigComp : UActorEditCompBase
---@field RebirthPointId int32
---@field UnitGuid FString
UBUS_OnlineAssistTriggerConfigComp = {}



---@class UBUS_OnlineAssistTriggerDataComp : UBUS_ActorBaseDataComp
UBUS_OnlineAssistTriggerDataComp = {}


---@class UBUS_POMDecalDataComp : UBUS_DecalDataComp
UBUS_POMDecalDataComp = {}


---@class UBUS_ParkourMoveComp : UActorEditCompBase
---@field CheckParkourStartDistance float
---@field ParkourMaxHeight float
---@field ParkourMinHeight float
---@field RunStrideSpeedRate float
---@field SprintStrideSpeedRate float
---@field bEnableStrideDown boolean
UBUS_ParkourMoveComp = {}



---@class UBUS_PatrolCompImpl : UActorCompBaseUObj
---@field TriggerBox ATriggerBase
UBUS_PatrolCompImpl = {}

---@param OverlapActor AActor
---@param OtherActor AActor
function UBUS_PatrolCompImpl:OnTriggerBoxOverlap(OverlapActor, OtherActor) end


---@class UBUS_PerformerDataComp : UBUS_BGUDataCompBase
UBUS_PerformerDataComp = {}


---@class UBUS_PerformerDestructibleDestroyComp : UBaseActorCompTickable
---@field bIsEnabled boolean
---@field HitStrengthLevel EGSHitDestructibleStrengthLevel
---@field HitShapeTag FName
---@field IsNeedDrawDebug boolean
UBUS_PerformerDestructibleDestroyComp = {}

function UBUS_PerformerDestructibleDestroyComp:BeginPlayInCS() end
---@param IsEnabled boolean
function UBUS_PerformerDestructibleDestroyComp:SetEnableDestroyDestructible(IsEnabled) end
---@param DeltaTime float
function UBUS_PerformerDestructibleDestroyComp:TickComponentInCS(DeltaTime) end


---@class UBUS_PlaceholderActorConfigComp : UActorEditCompBase
---@field describe FString
UBUS_PlaceholderActorConfigComp = {}



---@class UBUS_PlaceholderActorDataComp : UBUS_InteractiveActorDataComp
UBUS_PlaceholderActorDataComp = {}


---@class UBUS_PlayerApproachedNotifyComp : UActorCompBaseUObj
UBUS_PlayerApproachedNotifyComp = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function UBUS_PlayerApproachedNotifyComp:PlayerApproached_BeginOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end


---@class UBUS_PlayerCameraCompUObj : UActorCompBaseUObj
UBUS_PlayerCameraCompUObj = {}

---@param TargetCameraGroupId int32
---@param alpha float
---@param BlendTime float
function UBUS_PlayerCameraCompUObj:OnSwitchCameraGroupTo(TargetCameraGroupId, alpha, BlendTime) end


---@class UBUS_PlayerCameraSystem : UActorCompBaseUObj
---@field PlayerController APlayerController
---@field PlayerCameraManager APlayerCameraManager
UBUS_PlayerCameraSystem = {}



---@class UBUS_PlayerDataComp : UBUS_BGUDataComp
UBUS_PlayerDataComp = {}


---@class UBUS_ProceduralEnvInteractionConfigComp : UActorEditCompBase
---@field bEnableDecal boolean
---@field bEnableMesh boolean
---@field WorldSize FVector2D
---@field SceneItemSurfaceType SceneItemSurfaceType
UBUS_ProceduralEnvInteractionConfigComp = {}



---@class UBUS_ProceduralEnvInteractionDataComp : UBUS_ActorBaseDataComp
UBUS_ProceduralEnvInteractionDataComp = {}


---@class UBUS_ProceduralMapGeneratorDataComp : UBUS_ActorBaseDataComp
UBUS_ProceduralMapGeneratorDataComp = {}


---@class UBUS_ProceduralMapGeneratorDataConfigComp : UActorEditCompBase
---@field MapConfigDataAsset UBGWProceduralMapConfigDataAsset
---@field MapBlockMappingInfo UBGWProceduralMapBlockMappingDataAsset
---@field MapCustsomLightConfigs UBGWCustomLightConfigDataAsset
UBUS_ProceduralMapGeneratorDataConfigComp = {}



---@class UBUS_ProceduralSpawnCharacterDataComp : UBUS_ActorBaseDataComp
UBUS_ProceduralSpawnCharacterDataComp = {}


---@class UBUS_ProceduralSpawnCharacterDataConfigComp : UActorEditCompBase
---@field ProceduralWaveCharacterConfigAsset UBGWProceduralSpawnCharacterWaveConfigDataAsset
UBUS_ProceduralSpawnCharacterDataConfigComp = {}



---@class UBUS_ProceduralSpawnSceneItemDataComp : UBUS_ActorBaseDataComp
UBUS_ProceduralSpawnSceneItemDataComp = {}


---@class UBUS_ProceduralSpawnSceneItemDataConfigComp : UActorEditCompBase
---@field ProceduralSceneItemDataAsset UBGWProceduralSpawnSceneItemDataAsset
UBUS_ProceduralSpawnSceneItemDataConfigComp = {}



---@class UBUS_ProcessGraphEditComp : UActorEditCompBase
---@field ProcessAssets TArray<UCalliopeAsset>
UBUS_ProcessGraphEditComp = {}



---@class UBUS_ProjectileBaseDataComp : UBUS_ActorBaseDataComp
UBUS_ProjectileBaseDataComp = {}

function UBUS_ProjectileBaseDataComp:LateECSBeginPlay() end


---@class UBUS_ProjectileConfigInfoComp : UActorEditCompBase
---@field CheckShapeType ProjectileCheckShapeType
---@field SpecificFlags int32
---@field LocalTrans_LineTracePoint FTransform
---@field Interact_Start_SphereRadius float
---@field Interact_Start_LocalTransform FTransform
---@field Interact_End_SphereRadius float
---@field Interact_End_LocalTransform FTransform
---@field WindBrokenAudio UAkAudioEvent
---@field TriggerDist_WindBroken float
---@field bEnableDebug_WindBrokenAudio boolean
---@field DonutAudio UAkAudioEvent
---@field DonutAudioLocationType DonutBulletAudioLocationType
---@field DonutAudioStopMode AkEventStopMode
---@field DonutAudioStopTimeMs int32
---@field DonutAudioFadeOutTimeMs int32
---@field DonutAudioCurveInterpolation AkCurveInterpolationCS
---@field LoopEvent FUAkEventConfig
---@field DeadEvent FUAkEventConfig
---@field bEnable boolean
---@field TraceDelay float
---@field TraceLength float
---@field Size float
---@field SampleCollectionProtectTime float
---@field OverrideSurfaceType SceneItemSurfaceType
---@field OverrideSurfacePersistTime float
---@field OverrideSurfaceFXActorTag FName
---@field bDrawDebug boolean
---@field DebugDrawOffset float
---@field DestructibleTag FName
---@field EffectIDs TArray<int32>
---@field BuffIDs TArray<int32>
---@field NeedCheckWorldStatic boolean
---@field SweepCheckChannel ECollisionChannel
---@field CheckCompProfileName_Bullet Type_CheckCompProfileName_Bullet
---@field HitCheckConf FHitCheckConf
---@field bEnableAttackWarning boolean
---@field AttackWarningExtendSize float
---@field AttackWarningOffset FVector
---@field bEnableDebug boolean
---@field bHitChrAttach boolean
---@field HitChrAttachTime float
---@field bHitItemAttach boolean
---@field HitItemAttachTime float
---@field AttachOffset float
---@field MPC UMaterialParameterCollection
---@field bDrawDebug_Laser boolean
---@field AkEvent_LaserEnd UAkAudioEvent
---@field FadeOut_AkEvent_LaserEnd int32
---@field AkEvent_LaserHitItem UAkAudioEvent
---@field CheckCompProfileName_MagicField Type_CheckCompProfileName_MagicField
---@field MagicFieldOverlapType MagicFieldOverlapType
---@field bDebug boolean
---@field bCanHandleAvoidance boolean
---@field bUseSoftEdge boolean
---@field FieldBuffList TArray<FFieldBuffInfo>
---@field BornEffectDelayTime float
---@field BornAttackWarningTime float
---@field bAttackWarningTriggerPreciseDodge boolean
---@field bPreciseDodgeFilterTeammate boolean
---@field EnterEvents TArray<FMFEvent>
---@field ExitEvents TArray<FMFEvent>
---@field BirthEvents TArray<FMFEvent>
---@field DieEvents TArray<FMFEvent>
---@field HitDestructibleStrengthLevel EGSHitDestructibleStrengthLevel
---@field HitDestructibleDirectionType EGSHitDestructibleDirection
---@field HitDestructibleEffectsTriggerForSelf TArray<int32>
---@field OverlapBeginEvents TArray<FMFOverlapEvent>
---@field OverlapEndEvents TArray<FMFOverlapEvent>
---@field BornEvents TArray<FMFOverlapEvent>
---@field DeadEvents TArray<FMFOverlapEvent>
---@field DirectionUsage MagicFieldDirectionUsage
---@field DirectionType MagicFieldDirectionType
---@field DirectionTypeDetail MagicFieldDirectionTypeDetail
---@field AnchorPointTag FName
---@field DirectionEffects TArray<FMFDirectionEffect>
---@field bEnableShelterRT boolean
---@field bEnableGlobalFX boolean
---@field GlobalFXTag FGameplayTag
---@field ExtAbilityMask FProjectileExtAbilityMask
---@field DisableAbilityMask FProjectileDisableAbilityMask
---@field bForceUseProjectileMovementComp boolean
---@field bNotify_SpawnFinished boolean
UBUS_ProjectileConfigInfoComp = {}



---@class UBUS_QuestDataComp : UBUS_ActorBaseDataComp
---@field QuestActorType QuestActorType
UBUS_QuestDataComp = {}



---@class UBUS_RebirthPointConfigComp : UActorEditCompBase
---@field RebirthPointConfig FRebirthPointConfig
UBUS_RebirthPointConfigComp = {}



---@class UBUS_RebirthPointDataComp : UBUS_InteractiveActorDataComp
UBUS_RebirthPointDataComp = {}


---@class UBUS_RebirthPointInfoSaveConfigComp : UActorEditCompBase
---@field RebirthPointConfigID int32
UBUS_RebirthPointInfoSaveConfigComp = {}



---@class UBUS_RebirthPointInfoSaverDataComp : UBUS_ActorBaseDataComp
UBUS_RebirthPointInfoSaverDataComp = {}


---@class UBUS_RideControlTriggerDataComp : UBUS_ActorBaseDataComp
UBUS_RideControlTriggerDataComp = {}


---@class UBUS_SDFMakerDataComp : UBUS_ActorBaseDataComp
UBUS_SDFMakerDataComp = {}


---@class UBUS_SafeLandVolumeComp : UActorCompBaseUObj
UBUS_SafeLandVolumeComp = {}

---@param OverlappedActor AActor
---@param OtherActor AActor
function UBUS_SafeLandVolumeComp:OnActorEnter(OverlappedActor, OtherActor) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function UBUS_SafeLandVolumeComp:OnActorLeave(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end


---@class UBUS_SaveInitDataComp : UActorEditCompBase
---@field bSaveInitData boolean
---@field ActorResetType EBGUResetType
---@field PersistentDataDontResetOnNewGamePlus boolean
UBUS_SaveInitDataComp = {}



---@class UBUS_SceneInactiveActorComp : UBaseActorCompTickable
---@field SceneActorActivationInfo TArray<FFGSSceneActorActivationInfo>
UBUS_SceneInactiveActorComp = {}

---@param ActivationInfo FFGSSceneActorActivationInfo
function UBUS_SceneInactiveActorComp:TryAddActivationInfo(ActivationInfo) end
---@param SceneActorActivationType EGSSceneActorActivationType
---@param Tag FName
function UBUS_SceneInactiveActorComp:TryRemoveActivationInfo(SceneActorActivationType, Tag) end
---@param EndPlayReason EEndPlayReason::Type
function UBUS_SceneInactiveActorComp:EndPlayInCS(EndPlayReason) end
---@return TArray<FFGSSceneActorActivationInfo>
function UBUS_SceneInactiveActorComp:GetSceneActorActivationInfo() end
function UBUS_SceneInactiveActorComp:BeginPlayInCS() end
---@param DeltaTime float
function UBUS_SceneInactiveActorComp:TickComponentInCS(DeltaTime) end


---@class UBUS_SceneInactiveActorDataComp : UBUS_FXDataComp
UBUS_SceneInactiveActorDataComp = {}


---@class UBUS_SceneItemCommComp : UActorEditCompBase
---@field TeleportTransform FTransform
---@field SkillID int32
---@field NeedClosePhysicWhenReset boolean
UBUS_SceneItemCommComp = {}



---@class UBUS_SceneItemDataComp : UBUS_ActorBaseDataComp
UBUS_SceneItemDataComp = {}


---@class UBUS_SceneRotateTriggerConfigComp : UActorEditCompBase
---@field SkeletalMeshActor TSoftObjectPtr<AActor>
---@field AnimSequence UAnimSequence
---@field AttachPoint FName
---@field LocationCurve UCurveVector
---@field RotationCurve UCurveVector
---@field MultiplierCurveL UCurveVector
---@field MultiplierCurveR UCurveVector
---@field AffectedLevels TArray<FName>
---@field AffectedNiagaraNPC TArray<TSoftObjectPtr<UNiagaraParameterCollection>>
UBUS_SceneRotateTriggerConfigComp = {}



---@class UBUS_SceneRotateTriggerDataComp : UBUS_AreaBaseDataContainer
UBUS_SceneRotateTriggerDataComp = {}


---@class UBUS_SceneWindEffectActorComp : UBaseActorCompTickable
---@field WindEffectStrength float
---@field WindEffectCompTag FName
UBUS_SceneWindEffectActorComp = {}

function UBUS_SceneWindEffectActorComp:BeginPlayInCS() end
---@param DeltaTime float
function UBUS_SceneWindEffectActorComp:TickComponentInCS(DeltaTime) end


---@class UBUS_SelectAreaDataComp : UBUS_ActorBaseDataComp
UBUS_SelectAreaDataComp = {}


---@class UBUS_SeqHelperActorComp : UBaseActorComp
UBUS_SeqHelperActorComp = {}

---@param Tag FName
---@param IsRemoving boolean
---@param BuffID int32
---@param Duration float
function UBUS_SeqHelperActorComp:AddBuff(Tag, IsRemoving, BuffID, Duration) end
---@param Tag FName
function UBUS_SeqHelperActorComp:EnableAI(Tag) end
---@param Tag FName
function UBUS_SeqHelperActorComp:DisableAI(Tag) end
function UBUS_SeqHelperActorComp:ExitStealth() end
---@param Tag FName
---@param MontageToPlay UAnimMontage
function UBUS_SeqHelperActorComp:PlayMontage(Tag, MontageToPlay) end
---@param Tag FName
function UBUS_SeqHelperActorComp:PerformPatrol(Tag) end
---@param SelfTag FName
---@param TargetTag FName
function UBUS_SeqHelperActorComp:CatchAsTarget(SelfTag, TargetTag) end
---@param Tag FName
---@param IsHidden boolean
---@param EnableCollision boolean
function UBUS_SeqHelperActorComp:SetVisibility(Tag, IsHidden, EnableCollision) end
---@param Tag FName
function UBUS_SeqHelperActorComp:NotifyUnitDead(Tag) end
---@param Tag FName
---@param SimpleState EBGUSimpleState
---@param IsRemoving boolean
function UBUS_SeqHelperActorComp:UpdateSimpleStates(Tag, SimpleState, IsRemoving) end
---@param Class TSubclassOf<ABGUCharacterCS>
---@param Transform FTransform
---@param Tag FName
---@param PauseAI boolean
function UBUS_SeqHelperActorComp:SpawnPlayerPartner(Class, Transform, Tag, PauseAI) end
---@param Tag FName
---@param SpeedRateType EAIMoveSpeedType
---@param AcceptableRadius float
---@param MoveAIType EBGUMoveAIType
---@param IncludeSelfRadius boolean
---@param IncludeTargetRadius boolean
function UBUS_SeqHelperActorComp:PerformMoveToPlayer(Tag, SpeedRateType, AcceptableRadius, MoveAIType, IncludeSelfRadius, IncludeTargetRadius) end
---@param Tag FName
---@param position FVector
---@param SpeedRateType EAIMoveSpeedType
---@param AcceptableRadius float
---@param MoveAIType EBGUMoveAIType
---@param IncludeSelfRadius boolean
---@param IncludeTargetRadius boolean
function UBUS_SeqHelperActorComp:PerformMoveToLocation(Tag, position, SpeedRateType, AcceptableRadius, MoveAIType, IncludeSelfRadius, IncludeTargetRadius) end
---@param Tag FName
function UBUS_SeqHelperActorComp:PerformPerceivePlayer(Tag) end
function UBUS_SeqHelperActorComp:BeginPlayInCS() end


---@class UBUS_SeqHelperActorData : UObject
UBUS_SeqHelperActorData = {}


---@class UBUS_SeqHelperActorDataComp : UBUS_ActorBaseDataComp
UBUS_SeqHelperActorDataComp = {}


---@class UBUS_SeqHelperComp : UBaseActorComp
---@field CameraRotation FTransform
---@field MoveToTargetTransform FTransform
UBUS_SeqHelperComp = {}

function UBUS_SeqHelperComp:EnableAI() end
function UBUS_SeqHelperComp:DisableAI() end
---@param JumpMontage UAnimMontage
---@param JumpForce float
function UBUS_SeqHelperComp:PerformJump(JumpMontage, JumpForce) end
function UBUS_SeqHelperComp:PerformPatrol() end
function UBUS_SeqHelperComp:NotifyUnitDead() end
---@param SimpleState EBGUSimpleState
---@param IsRemoving boolean
function UBUS_SeqHelperComp:UpdateSimpleStates(SimpleState, IsRemoving) end
---@param SpeedRateType EAIMoveSpeedType
---@param AcceptableRadius float
---@param MoveAIType EBGUMoveAIType
---@param IncludeSelfRadius boolean
---@param IncludeTargetRadius boolean
function UBUS_SeqHelperComp:PerformMoveToPlayer(SpeedRateType, AcceptableRadius, MoveAIType, IncludeSelfRadius, IncludeTargetRadius) end
function UBUS_SeqHelperComp:PerformPerceivePlayer() end
---@param position FVector
---@param SpeedRateType EAIMoveSpeedType
---@param AcceptableRadius float
---@param MoveAIType EBGUMoveAIType
---@param IncludeSelfRadius boolean
---@param IncludeTargetRadius boolean
function UBUS_SeqHelperComp:PerformMoveToLocation(position, SpeedRateType, AcceptableRadius, MoveAIType, IncludeSelfRadius, IncludeTargetRadius) end
---@param Transform FTransform
function UBUS_SeqHelperComp:SetMoveToTargetTransform(Transform) end
---@param InEnableVisualize boolean
---@param InSightRange float
---@param InVisionAngleDegrees float
---@param InHearRange float
---@param InPursuitRange float
function UBUS_SeqHelperComp:OverrideAIPerceptionSetting(InEnableVisualize, InSightRange, InVisionAngleDegrees, InHearRange, InPursuitRange) end
---@param CollisionProfileName FName
function UBUS_SeqHelperComp:SetCharacterCollisionProfile(CollisionProfileName) end
function UBUS_SeqHelperComp:BeginPlayInCS() end


---@class UBUS_SeqPerformerConfigInfoComp : UActorEditCompBase
---@field DispInteractBoneMap TMap<FName, FBoneUseForDispMap>
---@field bUseCustomBodyPartCollision boolean
UBUS_SeqPerformerConfigInfoComp = {}



---@class UBUS_ShadowActorDataComp : UBUS_ActorBaseDataComp
UBUS_ShadowActorDataComp = {}


---@class UBUS_SimpleBGUDataComp : UBUS_BGUDataComp
UBUS_SimpleBGUDataComp = {}


---@class UBUS_SkillSelectHelperActorDataComp : UBUS_ActorBaseDataComp
UBUS_SkillSelectHelperActorDataComp = {}


---@class UBUS_SkillSequenceComp : UActorCompBaseUObj
UBUS_SkillSequenceComp = {}

function UBUS_SkillSequenceComp:OnFinished() end


---@class UBUS_SpawnCollectionComp : UActorEditCompBase
---@field SpawnGroup FFGSSpawnProbabilityGroup
UBUS_SpawnCollectionComp = {}



---@class UBUS_SpawnCollectionDataComp : UBUS_FlowDataComp
UBUS_SpawnCollectionDataComp = {}


---@class UBUS_SpawnMultiPointComp : UActorEditCompBase
---@field bDefaultStartSpawn boolean
---@field GeneratePointsEQSTemplate UEnvQuery
---@field QueryConfig TArray<FGSEnvNamedValue>
---@field PreviewMesh UStaticMesh
---@field Material UMaterialInterface
---@field DiffuseColor FLinearColor
---@field SpawnPoints TArray<FVector>
---@field SpawnPointsRot TArray<FRotator>
---@field UseSpawnPointsRot boolean
---@field SpawnNum int32
---@field ReSpawnThreshold int32
---@field IsLRU boolean
---@field IsNotSpawnedInPlayerSight boolean
---@field LowerLimitNum int32
---@field ReSpawnNum int32
---@field ReSpawnTestInterval float
---@field Type SpawnType
---@field SpawnedTag FName
---@field SpawnRule SpawnRule
---@field SpawnActorList TArray<TSubclassOf<AActor>>
---@field SpawnHeight float
---@field SpawnMontages TArray<UAnimMontage>
---@field bIsFacePlayer boolean
---@field bIsCatchPlayer boolean
---@field TamerMaster TSoftObjectPtr<ABUTamerActor>
---@field OlineConfig FOnlineSpawnConfig
---@field SpawnMaster TSoftObjectPtr<ABGUCharacterCS>
---@field GeneratedActors TArray<AActor>
UBUS_SpawnMultiPointComp = {}

function UBUS_SpawnMultiPointComp:RunEQSQuery() end
function UBUS_SpawnMultiPointComp:RecordSpawnPoints() end
function UBUS_SpawnMultiPointComp:ClearGenerateActors() end
function UBUS_SpawnMultiPointComp:PreviewRecordSpawnPoints() end


---@class UBUS_SpawnMultiPointDataComp : UBUS_FlowDataComp
UBUS_SpawnMultiPointDataComp = {}


---@class UBUS_SpecifyRebirthPosAreaConfigComp : UActorEditCompBase
---@field BindTuDiMiaoID int32
---@field BindZhaoHunFanID int32
UBUS_SpecifyRebirthPosAreaConfigComp = {}



---@class UBUS_SpecifyRebirthPosAreaDataComp : UBUS_AreaBaseDataContainer
UBUS_SpecifyRebirthPosAreaDataComp = {}


---@class UBUS_SpecifyRebirthPosAreaLogicComp : UActorCompBaseUObj
UBUS_SpecifyRebirthPosAreaLogicComp = {}


---@class UBUS_SpiderNavigationDataComp : UBUS_ActorBaseDataComp
UBUS_SpiderNavigationDataComp = {}


---@class UBUS_SpiderOceanMgrComp : UActorEditCompBase
---@field SpiderNiagara ANiagaraActor
---@field AdditionalSpiderNiagaraList TArray<ANiagaraActor>
---@field NiagaraSpline ABGUSplineActor
---@field SpiderFollowStartIndex int32
---@field NiagaraMoveCurve UCurveFloat
---@field SpiderDistanceCurve UCurveFloat
---@field SpiderSpawnPointsSelectCurve UCurveFloat
---@field SpiderSpawnPointTag FName
---@field SpiderSectorActor AActor
---@field SpiderSectorScaleCurve UCurveVector
---@field SpiderSpawnPoints TArray<FSpiderSpawnPointData>
---@field bDrawDebugNiagaraLocation boolean
---@field FixedGuid FUnitGuidData
UBUS_SpiderOceanMgrComp = {}



---@class UBUS_SpiderOceanMgrDataComp : UBUS_ActorBaseDataComp
UBUS_SpiderOceanMgrDataComp = {}


---@class UBUS_SplineDataComp : UBUS_ActorBaseDataComp
UBUS_SplineDataComp = {}


---@class UBUS_SplineFlyMoveTriggerConfigComp : UActorEditCompBase
---@field SplineFlyMoveConfigs TArray<FSplineFlyMoveConfig>
---@field OnlyTransitionPlayerCanTrigger boolean
---@field IsPlayerObserveMode boolean
---@field AutoEnable boolean
---@field TraceVelocityCameraSpeedRate float
---@field bDestoryControlledUnitInActived boolean
---@field SceneItem TSoftObjectPtr<ABGUSceneItemBase>
UBUS_SplineFlyMoveTriggerConfigComp = {}



---@class UBUS_SplineFlyMoveTriggerDataComp : UBUS_ActorBaseDataComp
UBUS_SplineFlyMoveTriggerDataComp = {}


---@class UBUS_SpringArmComponent : UBGUSpringArmComponent
---@field IsXSmoothFixed boolean
---@field IsYSmoothFixed boolean
---@field IsZSmoothFixed boolean
---@field DefaultCameraLagSpeed float
UBUS_SpringArmComponent = {}

---@param OriginArmLocation FVector
---@param DesiredArmLocation FVector
---@param HitResult FHitResult
---@param DeltaTime float
---@return FVector
function UBUS_SpringArmComponent:BlendLocationsInCS(OriginArmLocation, DesiredArmLocation, HitResult, DeltaTime) end
---@param Current FVector
---@param Target FVector
---@param DeltaTime float
---@param SmoothSpeed FVector
---@return FVector
function UBUS_SpringArmComponent:CalcSmoothLocation(Current, Target, DeltaTime, SmoothSpeed) end


---@class UBUS_StealthTriggerConfigComp : UActorEditCompBase
---@field bAutoStealthMode boolean
UBUS_StealthTriggerConfigComp = {}



---@class UBUS_StealthTriggerDataComp : UBUS_TriggerBoxDataComp
UBUS_StealthTriggerDataComp = {}


---@class UBUS_TaskCollectiontDataComp : UBUS_InteractiveActorDataComp
UBUS_TaskCollectiontDataComp = {}


---@class UBUS_TaskStageCollectionConfigComp : UActorEditCompBase
---@field CD int32
---@field FinishCD int32
---@field TaskStageID int32
---@field TaskStageStage TaskCollectionState
---@field CanDestoryTaskFinish boolean
---@field DropId int32
---@field CollectionDropTemplete UUBGWDropItemTemplete
---@field CollectionDropTemplete_TaskFinish UUBGWDropItemTemplete
---@field CollectionFXSpawnCompTag FName
---@field DestoryDelayTime float
---@field CacheDBC UBGWDataAsset_B1DBC
UBUS_TaskStageCollectionConfigComp = {}



---@class UBUS_TortoiseLevelStreamingConfigComp : UActorEditCompBase
---@field BeginConfig UBGWDataAsset_TortoiseLevelStreamingConfig
---@field LoopConfig UBGWDataAsset_TortoiseLevelStreamingConfig
---@field EndConfig UBGWDataAsset_TortoiseLevelStreamingConfig
UBUS_TortoiseLevelStreamingConfigComp = {}



---@class UBUS_TortoiseLevelStreamingMgrDataComp : UBUS_ActorBaseDataComp
UBUS_TortoiseLevelStreamingMgrDataComp = {}


---@class UBUS_TortoiseMoveMgrActorConfigComp : UActorEditCompBase
---@field Tortoise AActor
---@field LevelMoveAttachedBone FName
---@field FakeMoveLevels TArray<FName>
---@field TortoiseUnitResIDs TArray<int32>
---@field TortoiseRotationTriggerBoxInfoMap TMap<int32, FTortoiseRotateTriggerBoxInfo>
UBUS_TortoiseMoveMgrActorConfigComp = {}



---@class UBUS_TortoiseMoveMgrActorDataComp : UBUS_ActorBaseDataComp
UBUS_TortoiseMoveMgrActorDataComp = {}


---@class UBUS_TortoiseMoveMgrComp : UActorCompBaseUObj
UBUS_TortoiseMoveMgrComp = {}


---@class UBUS_TrainDummyMgrConfigComp : UActorEditCompBase
---@field TrainDummyClass TSubclassOf<ABGUTamerBase>
---@field PlayerRoleDataConfigID int32
---@field TrainDummyConfig UBGWDataAsset_TrainDummyConfig
UBUS_TrainDummyMgrConfigComp = {}



---@class UBUS_TrainDummyMgrDataComp : UBUS_ActorBaseDataComp
UBUS_TrainDummyMgrDataComp = {}


---@class UBUS_TransPreviewActorDataComp : UBUS_ActorBaseDataComp
UBUS_TransPreviewActorDataComp = {}


---@class UBUS_TreeBirdSpawnMgrConfigComp : UActorEditCompBase
---@field TreeArray TArray<FTreeInfo>
---@field TreeInfoBase UBGWDataAsset_BPTreeInfo
---@field SpawnConfig FTreeBirdSpawnConfig
UBUS_TreeBirdSpawnMgrConfigComp = {}



---@class UBUS_TreeBirdSpawnMgrDataComp : UBUS_ActorBaseDataComp
UBUS_TreeBirdSpawnMgrDataComp = {}


---@class UBUS_TriggerBoxDataComp : UBUS_ActorBaseDataComp
UBUS_TriggerBoxDataComp = {}


---@class UBUS_TriggerComp : UActorEditCompBase
---@field TriggerType TriggerType
---@field TriggerCharacter ACharacter
---@field TriggerCharacterGuid FString
---@field TriggerStateWhenTriggerCharacterInvalid boolean
---@field bEnableSwitch boolean
---@field CircleRaidus float
---@field bEndOverlapTrigger boolean
---@field BeginEndOverlapTriggerDirectionType BeginEndOverlapTriggerDirectionType
---@field bCharacterActiveState boolean
---@field bUnitState boolean
---@field UnitState EBGUUnitState
---@field bSimpleState boolean
---@field SimpleState EBGUSimpleState
---@field AttrFloatType EBGUAttrFloat
---@field CompareType ValueCompareType
---@field bCompareRatio boolean
---@field CompareValue float
UBUS_TriggerComp = {}



---@class UBUS_TriggerObjDataComp : UBUS_InteractiveActorDataComp
UBUS_TriggerObjDataComp = {}


---@class UBUS_TriggerProcessControlComp : UActorEditCompBase
---@field AttachedTriggerObjs TArray<FSceneObjWithState>
---@field NeedActivateObjs TArray<FSceneObjTriggerEvent>
UBUS_TriggerProcessControlComp = {}



---@class UBUS_TriggerProcessControllerDataComp : UBUS_ActorBaseDataComp
UBUS_TriggerProcessControllerDataComp = {}


---@class UBUS_UIControlSystemV2 : UActorCompBaseUObj
UBUS_UIControlSystemV2 = {}


---@class UBUS_UnitTeamMngConfigComp : UActorEditCompBase
---@field TeamList TMap<FString, FUnitTeam>
UBUS_UnitTeamMngConfigComp = {}



---@class UBUS_UnitTeamMngDataComp : UBUS_ActorBaseDataComp
UBUS_UnitTeamMngDataComp = {}


---@class UBUS_UpdraftAreaDataComp : UBUS_AreaBaseDataContainer
UBUS_UpdraftAreaDataComp = {}


---@class UBUS_UpdraftComp : UActorCompBaseUObj
UBUS_UpdraftComp = {}

---@param OverlappedActor AActor
---@param OtherActor AActor
function UBUS_UpdraftComp:OnActorEnter(OverlappedActor, OtherActor) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function UBUS_UpdraftComp:OnActorLeave(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end


---@class UBUS_UpdraftConfigInfoComp : UActorEditCompBase
---@field UpVelocity float
---@field CD float
---@field bEnableDebug boolean
UBUS_UpdraftConfigInfoComp = {}



---@class UBUS_UpdraftDataComp : UBUS_ActorBaseDataComp
UBUS_UpdraftDataComp = {}


---@class UBUS_WanderBGMAreaConfigComp : UActorEditCompBase
---@field AkEventBegin UAkAudioEvent
---@field AkEventStop UAkAudioEvent
---@field VolumeBGMConfigDA UBGWBGMConfigDataAsset
---@field VolumeGroupConfig FFBGMVolumeGroupConfig
---@field VolumeConditionConfigs TArray<FFBGMVolumeConditionConfig>
UBUS_WanderBGMAreaConfigComp = {}



---@class UBUS_WanderBGMVolumeComp : UActorEditCompBase
---@field AkEventBegin UAkAudioEvent
---@field AkEventStop UAkAudioEvent
---@field VolumeBGMConfigDA UBGWBGMConfigDataAsset
---@field VolumeGroupConfig FFBGMVolumeGroupConfig
---@field VolumeConditionConfigs TArray<FFBGMVolumeConditionConfig>
UBUS_WanderBGMVolumeComp = {}



---@class UBUS_WeaponDataComp : UBUS_ActorBaseDataComp
UBUS_WeaponDataComp = {}


---@class UBUS_ZBBCreatorDataComp : UBUS_ActorBaseDataComp
UBUS_ZBBCreatorDataComp = {}


---@class UBWS_DispLibImageProcessor : UObject
---@field KawaseBlurMatInst UMaterialInstanceDynamic
---@field BlitMatInst UMaterialInstanceDynamic
---@field CombineRGBMatInst UMaterialInstanceDynamic
---@field CombineMatInst UMaterialInstanceDynamic
---@field Config UBWS_DispLibImageProcessorConfig
---@field RenderTarget0 UTextureRenderTarget2D
---@field RenderTarget1 UTextureRenderTarget2D
---@field SourceTexName FName
---@field ShiftName FName
---@field IsFlipVerticalAxisName FName
---@field BlendTexName FName
---@field BlendAlphaName FName
---@field RChannelName FName
---@field GChannelName FName
---@field BChannelName FName
UBWS_DispLibImageProcessor = {}

---@param SrcTex UTexture
---@param BlendTex UTexture
---@param DstTex UTextureRenderTarget2D
---@param BlendAlpha float
---@param IsFlipVerticalAxis boolean
function UBWS_DispLibImageProcessor:Blit(SrcTex, BlendTex, DstTex, BlendAlpha, IsFlipVerticalAxis) end
---@param WorldContext UObject
---@param ConfigPath FString
function UBWS_DispLibImageProcessor:Init(WorldContext, ConfigPath) end
---@param SrcTex UTexture
---@param DstTex UTextureRenderTarget2D
---@param IsFlipVerticalAxis boolean
function UBWS_DispLibImageProcessor:KawaseBlur(SrcTex, DstTex, IsFlipVerticalAxis) end
---@param RChannel UTexture
---@param GChannel UTexture
---@param BChannel UTexture
---@param DstTex UTextureRenderTarget2D
---@param IsFlipVerticalAxis boolean
function UBWS_DispLibImageProcessor:CombileRGB(RChannel, GChannel, BChannel, DstTex, IsFlipVerticalAxis) end
function UBWS_DispLibImageProcessor:InitParameters() end


---@class UBWS_DispLibImageProcessorConfig : UBGWDataAsset
---@field KawaseMaterialPrototype UMaterialInstance
---@field RenderTarget0 UTextureRenderTarget2D
---@field RenderTarget1 UTextureRenderTarget2D
---@field BlitMaterialPrototype UMaterialInstance
---@field CombineRGBMaterialPrototype UMaterialInstance
UBWS_DispLibImageProcessorConfig = {}



---@class UBasicActionBase : UObject
---@field OwnCharacter ACharacter
---@field CurAIRequest UAIRequestBase
---@field AIBasicActionType EAIBasicActionType
UBasicActionBase = {}



---@class UBed_MovieNode_WarmingUp : UBED_MovieNode
---@field StartSequences TArray<FLevelSequenceConfig>
---@field bUseMarkFrameLoop boolean
---@field bUseCinematicCamera boolean
---@field CameraBlendInTime float
---@field CameraBlendInFunction EViewTargetBlendFunction
---@field CameraBlendInFuncExp float
---@field StreamingLevelNameList TArray<FName>
---@field Performers FGameplayTagContainer
---@field AssociationUnitInfoConfigId int32
---@field AssociationUnitSpawnInfoSpawnType AssociationUnitSpawnType
---@field bUseAsyncLoad boolean
UBed_MovieNode_WarmingUp = {}



---@class UBezier_MovementComponentInCS : UActorComponent
---@field RotateSpeed float
---@field InitFlySpeed float
---@field destroyTime float
---@field ControlAdditionPoint1 FVector
---@field ControlAdditionPoint2 FVector
---@field BezierPathPointNum int32
---@field BezierMoveWeight float
---@field MaxFlySpeed float
---@field AccelerationTime float
---@field ApproachDis float
---@field EnableDrawDebugPoint boolean
---@field SpeedCurve UCurveFloat
---@field ProjectileMovement UProjectileMovementComponent
UBezier_MovementComponentInCS = {}

---@param _RotateSpeed float
---@param _FlySpeed float
---@param _DestroyTime float
---@param _MaxFlySpeed float
---@param _BezierPathPointNum int32
---@param _BezierMoveWeight float
---@param _AccelerationTime float
---@param _ApproachDis float
---@param _EnableDrawDebugPoint boolean
---@param _SpeedCurve UCurveFloat
---@param _ControlAdditionPoint1 FVector
---@param _ControlAdditionPoint2 FVector
function UBezier_MovementComponentInCS:InitMovementParam(_RotateSpeed, _FlySpeed, _DestroyTime, _MaxFlySpeed, _BezierPathPointNum, _BezierMoveWeight, _AccelerationTime, _ApproachDis, _EnableDrawDebugPoint, _SpeedCurve, _ControlAdditionPoint1, _ControlAdditionPoint2) end
---@param DeltaSeconds float
function UBezier_MovementComponentInCS:ReceiveTick(DeltaSeconds) end
function UBezier_MovementComponentInCS:ReceiveBeginPlay() end


---@class UBgmVolumeFunctionBinder : UObject
UBgmVolumeFunctionBinder = {}

---@param OverlapActor AActor
---@param OtherActor AActor
function UBgmVolumeFunctionBinder:OnActorEnter(OverlapActor, OtherActor) end
---@param OverlapActor AActor
---@param OtherActor AActor
function UBgmVolumeFunctionBinder:OnActorLeave(OverlapActor, OtherActor) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function UBgmVolumeFunctionBinder:OnCollisionEndOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function UBgmVolumeFunctionBinder:OnCollisionBeginOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end


---@class UCacheAssetReference : UObject
---@field refCount int32
---@field AssetState CacheAssetState
---@field RefObj UObject
UCacheAssetReference = {}



---@class UCanvasCoordTransMainWidget : UBUI_Widget
---@field ImgSize FVector2D
UCanvasCoordTransMainWidget = {}

---@param DeltaTime float
function UCanvasCoordTransMainWidget:OnTickCallback(DeltaTime) end


---@class UCustomShadowComp : UBaseActorCompTickable
---@field MPC_CustomShadow UMaterialParameterCollection
---@field Player_Actor AActor
---@field RerenderSpeed float
---@field OrthoWidth float
---@field SceneCapture_Actor ASceneCapture2D
---@field Light_Actor ADirectionalLight
---@field SceneCapture_Comp USceneCaptureComponent2D
---@field LandscapeProxy ALandscapeProxy
---@field LightVector FVector
---@field CurrentRenderPos FVector
UCustomShadowComp = {}

function UCustomShadowComp:Init() end
function UCustomShadowComp:Tick() end
function UCustomShadowComp:BeginPlayInCS() end
---@param DeltaTime float
function UCustomShadowComp:TickComponentInCS(DeltaTime) end


---@class UDA_PCSEW_KJLRandomLightningConfig : UBGWDataAsset
---@field BulletID int32
---@field PointGeneratorTag FString
---@field LimitDistance_ToPlayer float
---@field DummyActiveDistance float
---@field DummyFXCompTag FName
---@field LightningBeam UNiagaraSystem
---@field LightningEndParamName FString
---@field SocketList TArray<FString>
---@field DummyBulletNum int32
---@field EndPos_Noise FVector
---@field RandomInterval FVector2D
UDA_PCSEW_KJLRandomLightningConfig = {}



---@class UDispLibDBCCustomEventDataAssetBase : UBGWDataAsset
UDispLibDBCCustomEventDataAssetBase = {}


---@class UDispLibDispWorldDataComp : UBUS_ActorBaseDataComp
UDispLibDispWorldDataComp = {}


---@class UDispLib_DBCDecalComponent : UDecalComponent
UDispLib_DBCDecalComponent = {}


---@class UDispLib_DBCNiagaraComponent : UBaseEditorTickableActorComp
---@field Delay float
---@field EndMode DispLibDBCEndMode
---@field Duration float
---@field DelayTimeAfterStop float
---@field DestroyTiming DispLibDBCEffectDestroyTiming
---@field Template UNiagaraSystem
---@field OverrideTargetMeshCompTag FName
---@field Attached boolean
---@field SocketName FName
---@field offsetInLocaSpace boolean
---@field LocationOffset FVector
---@field RotationOffset FRotator
---@field Scale FVector
---@field SnapGround boolean
---@field SnapGroundRotationMode DispLibDBCSnapGroundRotationMode
---@field ignoreRootBoneScale boolean
---@field SetSelfMeshParam boolean
---@field OverrideMeshBones TArray<FName>
---@field OverrideMeshSockets TArray<FName>
---@field customParams TArray<FGSNiagaraSysParam>
---@field DetachOnEndDispStageBegin boolean
---@field EnableShadow boolean
---@field EnableVolumetricTranslucentShadow boolean
---@field TranslucentSortPriority int32
---@field PausePriority int32
---@field PauseMode DispLibDBCPauseMode
---@field EndStagePriority int32
---@field ForceChangeVisibleStateDEFPriority int32
---@field ForceVisibleStateDefaultMode DispLibDBCNiagaraForceVisibleStateMode
---@field CompTag FName
---@field ScalabilitySettings FBUC_DispLibDBC_NiagaraEventScalabilitySettings
---@field MergedSettings FBUC_DispLibDBC_NiagaraEventMergedSettings
---@field GamePlayDispReqID int32
---@field hasAttachedSocket boolean
---@field EditorPreview_NGComp UNiagaraComponent
---@field DBCRequestHasSend boolean
---@field InitOver boolean
UDispLib_DBCNiagaraComponent = {}

---@param EndPlayReason EEndPlayReason::Type
function UDispLib_DBCNiagaraComponent:EndPlayInCS(EndPlayReason) end
function UDispLib_DBCNiagaraComponent:BeginPlayInCS() end
---@param DeltaTime float
function UDispLib_DBCNiagaraComponent:TickComponentInCS(DeltaTime) end
---@param MemberName FString
---@param PropertyName FString
function UDispLib_DBCNiagaraComponent:OnPropertyChanged(MemberName, PropertyName) end


---@class UDispLib_DBCSimpleActorBaseData : UBaseActorComp
UDispLib_DBCSimpleActorBaseData = {}


---@class UDispLib_DBCSimpleMaterialQualityManager : UBaseActorCompTickable
---@field InitOver boolean
UDispLib_DBCSimpleMaterialQualityManager = {}

function UDispLib_DBCSimpleMaterialQualityManager:BeginPlayInCS() end
---@param DeltaTime float
function UDispLib_DBCSimpleMaterialQualityManager:TickComponentInCS(DeltaTime) end


---@class UDispLib_DBCWEFMMotorComp : UBaseEditorTickableActorComp
---@field EventName FName
---@field GetSocketOnThisComp FName
---@field SocketName FName
---@field Delay float
---@field EndMode DispLibDBCEndMode
---@field Duration float
---@field SocketLocalOffset FVector
---@field TriggerProbability float
---@field Radius FBUC_DispLibUtil_DBCAdvProcessScalar
---@field VelocityThreshold float
---@field BaseIntensity FBUC_DispLibUtil_DBCAdvProcessScalar
---@field ScaleVelocityIntensity float
---@field DistanceDamplingRate float
---@field WindMotorMode DispLibDBCWindMotorMode
---@field RangeAxis DispLibDBCAxisMode
---@field RangeAxisLocalRotation FVector
---@field RangeMask float
---@field VelocityDir DispLibDBCAxisMode
---@field VelocityDirLocalRotation FVector
---@field ScaleSecondVelocity FBUC_DispLibUtil_DBCAdvProcessScalar
UDispLib_DBCWEFMMotorComp = {}

function UDispLib_DBCWEFMMotorComp:EditorTestDoOnceWindEvent() end
function UDispLib_DBCWEFMMotorComp:BeginPlayInCS() end
---@param MemberName FString
---@param PropertyName FString
function UDispLib_DBCWEFMMotorComp:OnPropertyChanged(MemberName, PropertyName) end
---@param DeltaTime float
function UDispLib_DBCWEFMMotorComp:TickComponentInCS(DeltaTime) end


---@class UDispLib_EditorTestFXToolComp : UBaseEditorTickableActorComp
---@field Enable boolean
---@field Template UNiagaraSystem
---@field SimDBCMergeNiagara boolean
---@field SimulaHitTime float
---@field FlySpeed float
---@field AutoResetTimeAfterLoopEnd float
---@field MultiSpawnSimulaLoopDuration float
---@field MultiSpawnInfo_SpawnBrust FVector
---@field MultiSpawnInfo_SpawnRate FVector
---@field MultiSpawn_EveryChildEventStdPlayingDuration float
---@field MultiSpawn_EveryChildEventEndDispStageDuration float
---@field MultiSpawn_ChildEventSpawnOnGridPlane boolean
---@field MultiSpawn_ChildEventSpawnBoxSize FVector
---@field MultiSpawn_SimFlyBullet boolean
---@field MultiSpawn_RandomFlyVelocity boolean
---@field MultiSpawn_FlyVelocity FVector
---@field MgrSystemNGActor AActor
---@field OriginPosWS FVector
---@field NC UNiagaraComponent
---@field HitMarkObj UStaticMeshComponent
UDispLib_EditorTestFXToolComp = {}

function UDispLib_EditorTestFXToolComp:ForceCleanAllNiagaraComp() end
---@param EndPlayReason EEndPlayReason::Type
function UDispLib_EditorTestFXToolComp:EndPlayInCS(EndPlayReason) end
function UDispLib_EditorTestFXToolComp:BeginPlayInCS() end
---@param DeltaTime float
function UDispLib_EditorTestFXToolComp:TickComponentInCS(DeltaTime) end


---@class UDispLib_EditorZakkaComp : UBaseActorCompTickable
---@field PermanentWindMotorsDataAsset UBUC_DispLibDBCPermanentWEFMMotorDataAsset
UDispLib_EditorZakkaComp = {}

---@param DeltaSeconds float
function UDispLib_EditorZakkaComp:ReceiveTick(DeltaSeconds) end


---@class UDispLib_PPEffectParameters : UObject
---@field Duration float
---@field BeginningDuration float
---@field FinishingDuration float
---@field VectorParams TArray<FVector4>
---@field ScalarParams TArray<float>
UDispLib_PPEffectParameters = {}



---@class UDispLib_PostProcessConf : UBGWDataAsset
---@field RadialBlurConf FUDispLib_PostProcessRadialBlurConf
---@field InverseFieldConf FUDispLib_PostProcessBlueprintConf
---@field CommonConfs TArray<FUDispLib_PostPorcessCommonConf>
UDispLib_PostProcessConf = {}



---@class UDispLib_SplineMoveComp : UBaseActorCompTickable
---@field ProgressCurve UCurveFloat
---@field Time float
---@field RandomMappingScale FVector2D
---@field RandomRotation FVector
UDispLib_SplineMoveComp = {}

function UDispLib_SplineMoveComp:BeginPlayInCS() end
---@param DeltaTime float
function UDispLib_SplineMoveComp:TickComponentInCS(DeltaTime) end


---@class UExcelTest : UAutoTest_Template
UExcelTest = {}


---@class UFDownloadImageDelegateWrapper : UUILRuntimeDelegateWrapperBase
UFDownloadImageDelegateWrapper = {}

---@param Texture UTexture2DDynamic
function UFDownloadImageDelegateWrapper:Callback(Texture) end


---@class UFGSOnAKBStateBeginWrapper : UUILRuntimeDelegateWrapperBase
UFGSOnAKBStateBeginWrapper = {}

---@param BeginStateName FName
---@param EndStateName FName
---@param IsFromForceSetStateImmediately boolean
function UFGSOnAKBStateBeginWrapper:Callback(BeginStateName, EndStateName, IsFromForceSetStateImmediately) end


---@class UFGSOnAKBStateEndWrapper : UUILRuntimeDelegateWrapperBase
UFGSOnAKBStateEndWrapper = {}

---@param BeginStateName FName
---@param EndStateName FName
---@param IsFromForceSetStateImmediately boolean
function UFGSOnAKBStateEndWrapper:Callback(BeginStateName, EndStateName, IsFromForceSetStateImmediately) end


---@class UFGSOnAKBStateInteruptWrapper : UUILRuntimeDelegateWrapperBase
UFGSOnAKBStateInteruptWrapper = {}

---@param BeginStateName FName
---@param EndStateName FName
---@param IsFromForceSetStateImmediately boolean
function UFGSOnAKBStateInteruptWrapper:Callback(BeginStateName, EndStateName, IsFromForceSetStateImmediately) end


---@class UFGSOnButtonCheckStateChangedWrapper : UUILRuntimeDelegateWrapperBase
UFGSOnButtonCheckStateChangedWrapper = {}

---@param GSID int32
---@param bIsChecked boolean
function UFGSOnButtonCheckStateChangedWrapper:Callback(GSID, bIsChecked) end


---@class UFOnAkPostEventCallbackWrapper : UUILRuntimeDelegateWrapperBase
UFOnAkPostEventCallbackWrapper = {}

---@param CallbackType EAkCallbackType
---@param CallbackInfo UAkCallbackInfo
function UFOnAkPostEventCallbackWrapper:Callback(CallbackType, CallbackInfo) end


---@class UFOnBinkMediaPlayerMediaReachedEndWrapper : UUILRuntimeDelegateWrapperBase
UFOnBinkMediaPlayerMediaReachedEndWrapper = {}

function UFOnBinkMediaPlayerMediaReachedEndWrapper:Callback() end


---@class UFOnButtonClickedEventWrapper : UUILRuntimeDelegateWrapperBase
UFOnButtonClickedEventWrapper = {}

function UFOnButtonClickedEventWrapper:Callback() end


---@class UFOnButtonPressedEventWrapper : UUILRuntimeDelegateWrapperBase
UFOnButtonPressedEventWrapper = {}

function UFOnButtonPressedEventWrapper:Callback() end


---@class UFOnCheckBoxComponentStateChangedWrapper : UUILRuntimeDelegateWrapperBase
UFOnCheckBoxComponentStateChangedWrapper = {}

---@param bIsChecked boolean
function UFOnCheckBoxComponentStateChangedWrapper:Callback(bIsChecked) end


---@class UFOnEditableTextBoxChangedEventWrapper : UUILRuntimeDelegateWrapperBase
UFOnEditableTextBoxChangedEventWrapper = {}

---@param Text FText
function UFOnEditableTextBoxChangedEventWrapper:Callback(Text) end


---@class UFOnEditableTextBoxCommittedEventWrapper : UUILRuntimeDelegateWrapperBase
UFOnEditableTextBoxCommittedEventWrapper = {}

---@param Text FText
---@param CommitMethod ETextCommit::Type
function UFOnEditableTextBoxCommittedEventWrapper:Callback(Text, CommitMethod) end


---@class UFOnEditableTextChangedEventWrapper : UUILRuntimeDelegateWrapperBase
UFOnEditableTextChangedEventWrapper = {}

---@param Text FText
function UFOnEditableTextChangedEventWrapper:Callback(Text) end


---@class UFOnFloatValueChangedEventWrapper : UUILRuntimeDelegateWrapperBase
UFOnFloatValueChangedEventWrapper = {}

---@param Value float
function UFOnFloatValueChangedEventWrapper:Callback(Value) end


---@class UFOnInputActionWrapper : UUILRuntimeDelegateWrapperBase
UFOnInputActionWrapper = {}

function UFOnInputActionWrapper:Callback() end


---@class UFOnIsSelectingKeyChangedWrapper : UUILRuntimeDelegateWrapperBase
UFOnIsSelectingKeyChangedWrapper = {}

function UFOnIsSelectingKeyChangedWrapper:Callback() end


---@class UFOnKeySelectedWrapper : UUILRuntimeDelegateWrapperBase
UFOnKeySelectedWrapper = {}

---@param SelectedKey FInputChord
function UFOnKeySelectedWrapper:Callback(SelectedKey) end


---@class UFOnMediaPlayerMediaEventWrapper : UUILRuntimeDelegateWrapperBase
UFOnMediaPlayerMediaEventWrapper = {}

function UFOnMediaPlayerMediaEventWrapper:Callback() end


---@class UFOnMovieSceneSequencePlayerEventWrapper : UUILRuntimeDelegateWrapperBase
UFOnMovieSceneSequencePlayerEventWrapper = {}

function UFOnMovieSceneSequencePlayerEventWrapper:Callback() end


---@class UFOnMultiLineEditableTextBoxCommittedEventWrapper : UUILRuntimeDelegateWrapperBase
UFOnMultiLineEditableTextBoxCommittedEventWrapper = {}

---@param Text FText
---@param CommitMethod ETextCommit::Type
function UFOnMultiLineEditableTextBoxCommittedEventWrapper:Callback(Text, CommitMethod) end


---@class UFOnMultiLineEditableTextChangedEventWrapper : UUILRuntimeDelegateWrapperBase
UFOnMultiLineEditableTextChangedEventWrapper = {}

---@param Text FText
function UFOnMultiLineEditableTextChangedEventWrapper:Callback(Text) end


---@class UFOnPointerEventWrapper : UUILRuntimeDelegateWrapperBase
UFOnPointerEventWrapper = {}

---@param Geometry FGeometry
---@param PointerEvent FPointerEvent
---@return FEventReply
function UFOnPointerEventWrapper:Callback(Geometry, PointerEvent) end


---@class UFOnSelectionChangedWrapper : UUILRuntimeDelegateWrapperBase
UFOnSelectionChangedWrapper = {}

---@param SelectedItem FString
---@param SelectionType ESelectInfo::Type
function UFOnSelectionChangedWrapper:Callback(SelectedItem, SelectionType) end


---@class UFOnUserScrolledEventWrapper : UUILRuntimeDelegateWrapperBase
UFOnUserScrolledEventWrapper = {}

---@param CurrentOffset float
function UFOnUserScrolledEventWrapper:Callback(CurrentOffset) end


---@class UFWidgetAnimationDynamicEventWrapper : UUILRuntimeDelegateWrapperBase
UFWidgetAnimationDynamicEventWrapper = {}

function UFWidgetAnimationDynamicEventWrapper:Callback() end


---@class UFlowOverlapCompFunctionBinder : UObject
UFlowOverlapCompFunctionBinder = {}

---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
function UFlowOverlapCompFunctionBinder:OnCollisionEndOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex) end
---@param OverlappedComponent UPrimitiveComponent
---@param OtherActor AActor
---@param OtherComp UPrimitiveComponent
---@param OtherBodyIndex int32
---@param bFromSweep boolean
---@param SweepResult FHitResult
function UFlowOverlapCompFunctionBinder:OnCollisionBeginOverlap(OverlappedComponent, OtherActor, OtherComp, OtherBodyIndex, bFromSweep, SweepResult) end


---@class UFluidHeightmapFogComponent : UActorComponent
---@field RT_TopHeightmap UTextureRenderTarget2D
---@field RT_BottomHeightmap UTextureRenderTarget2D
---@field MID_BaseHeightmap UMaterialInstanceDynamic
---@field MID_PSFogOutput UMaterialInstanceDynamic
---@field PS_FogOutput UParticleSystemComponent
---@field BB_Heightmap UBoxComponent
---@field DebuggerActor ARenderTargetDebugger
---@field BoundingSize int32
UFluidHeightmapFogComponent = {}

function UFluidHeightmapFogComponent:InitComp() end
function UFluidHeightmapFogComponent:RenderHeightmap() end


---@class UFluidHeightmapSettings : UObject
UFluidHeightmapSettings = {}


---@class UFluidSimulationComponent : UBaseActorCompTickable
---@field VelocityTexture UTextureRenderTarget2D
---@field AdvectedVelocityTexture UTextureRenderTarget2D
---@field ColorTexture UTextureRenderTarget2D
---@field DivergenceTexture UTextureRenderTarget2D
---@field PressureTexture UTextureRenderTarget2D
---@field ScratchRT UTextureRenderTarget2D
---@field ObstacleTexture UTextureRenderTarget2D
---@field AdvectMID UMaterialInstanceDynamic
---@field DivergenceMID UMaterialInstanceDynamic
---@field PressureIterationMID UMaterialInstanceDynamic
---@field GradientSubtractionMID UMaterialInstanceDynamic
---@field BoundaryConditionMID UMaterialInstanceDynamic
---@field VelocityPreviewMID UMaterialInstanceDynamic
---@field ObstacleMID UMaterialInstanceDynamic
---@field ColorPreviewMID UMaterialInstanceDynamic
---@field VelocitySeedMID UMaterialInstanceDynamic
---@field ColorSeedMID UMaterialInstanceDynamic
---@field CopyRTMID UMaterialInstanceDynamic
---@field VolumeFogMID UMaterialInstanceDynamic
---@field RaymarchVelocityMID UMaterialInstanceDynamic
---@field Settings UFluidSimulationSettings
---@field DefaultRes UFluidSimulationRes
---@field Positions TArray<FVector>
---@field Velocities TArray<FVector>
---@field OverlappedActors TArray<AActor>
---@field VolumeFogComponent UStaticMeshComponent
UFluidSimulationComponent = {}

---@param Actor AActor
function UFluidSimulationComponent:AddActor(Actor) end
---@param Actor AActor
function UFluidSimulationComponent:RemoveActor(Actor) end
function UFluidSimulationComponent:BeginPlayInCS() end
---@param DeltaTime float
function UFluidSimulationComponent:TickComponentInCS(DeltaTime) end


---@class UFluidSimulationInteractor : UActorComponent
UFluidSimulationInteractor = {}


---@class UFluidSimulationRes : UPrimaryDataAsset
---@field AdvectionMaterial UMaterial
---@field DivergenceMaterial UMaterial
---@field PressureIterationMaterial UMaterial
---@field GradientSubtractionMaterial UMaterial
---@field BoundaryConditionMaterial UMaterial
---@field ObstacleMaterial UMaterial
---@field ColorPreviewMaterial UMaterial
---@field VelocityPreviewMaterial UMaterial
---@field VolumePreviewMaterial UMaterial
---@field VelocitySeedMaterial UMaterial
---@field CopyRTMaterial UMaterial
---@field RaymarchVelocityMaterial UMaterial
---@field InteractiveVolumeFogMaterial UMaterial
UFluidSimulationRes = {}



---@class UFluidSimulationSettings : UPrimaryDataAsset
---@field Is3D boolean
---@field Resolution2D int32
---@field Resolution3D FluidSimDimension
---@field PressureDivisor int32
---@field VelocityDensityMaskAmount float
---@field DebugPressureStrength float
---@field ColorSeedMaterial UMaterial
---@field ObstaclePoint FTransform
---@field SeedTemperatureMultiplier float
---@field TemperatureInset float
---@field EdgeHardness float
---@field NoiseStrength float
---@field DensityMultiplier float
---@field VelocitySeedMaterial UMaterial
---@field Curl1Strength float
---@field Curl1Tiling float
---@field Curl2Strength float
---@field Curl2Tiling float
---@field OverallVelocityMultiplier float
---@field RadialForce float
---@field NoiseFieldPosOffset FVector
---@field ObstacleMaterial2D UMaterial
---@field AdvectionMaterial3D UMaterial
---@field JacobiIterations int32
---@field TimeStep float
---@field ConstantCurlTiling float
---@field ConstantCurlStrength float
---@field TemperatureBuoyancy float
---@field TemperatureDampening float
---@field DensityDampening float
---@field DensityErosion float
---@field EmissionCurve UCurveFloat
---@field EmissionMultiplier float
---@field EmissionTemperatureMultiplier float
---@field InteractInfo UMaterialParameterCollection
---@field MPCInteractPosName FName
---@field MPCInteractVelName FName
---@field InteractVelocityMultiper float
UFluidSimulationSettings = {}



---@class UForceCinfigComp : USceneComponent
---@field ForceRandomBiasMin FVector
---@field ForceRandomBiasMax FVector
---@field DontRotateToAtker boolean
UForceCinfigComp = {}



---@class UFunctionBinder_AudioSystem : UObject
UFunctionBinder_AudioSystem = {}

---@param SwitchGroup FString
---@param SwitchState FString
function UFunctionBinder_AudioSystem:RoomSetSwitch(SwitchGroup, SwitchState) end


---@class UGSAutoSizeScrollBox : UGSScrollBox
---@field ContentSizeBox USizeBox
---@field OrderSetting OrderSetting
---@field ItemSize FVector2D
---@field Baseline float
---@field UsePaddingCurve boolean
---@field PaddingCurve UCurveFloat
---@field UseCurveScale boolean
---@field ScaleCurve UCurveFloat
---@field ScaleRange FVector2D
---@field UseRenderScale boolean
---@field ScaleMaxLength float
---@field AutoSizeScrollParams FAutoSizeScrollData
---@field OverScrollOffset float
UGSAutoSizeScrollBox = {}



---@class UGSBackGround : UBUI_Widget
---@field IsBlockTouch boolean
---@field IsWithBlur boolean
---@field IsWithMask boolean
---@field MaskColor FLinearColor
---@field TweenInTime float
---@field TweenFunc EEasingFunc::Type
UGSBackGround = {}



---@class UGSBackgroundBlurCS : UBackgroundBlur
---@field CommParams FMatCommParams
UGSBackgroundBlurCS = {}

function UGSBackgroundBlurCS:GSOnConstruct() end
---@param InCommParams FMatCommParams
function UGSBackgroundBlurCS:SetCommParams(InCommParams) end


---@class UGSButton : UButton
---@field PressedMask UWidget
---@field HoveredWidget UWidget
---@field FocusedWidget UWidget
---@field RootCon UWidget
---@field DurationTime float
---@field PressedScale float
---@field ClickAudioEvent UAkAudioEvent
---@field FocusAudioEvent UAkAudioEvent
---@field HoveredAudioEvent UAkAudioEvent
UGSButton = {}

function UGSButton:GSOnPressed() end
function UGSButton:GSOnClicked() end
function UGSButton:GSOnHovered() end
---@param FocusEvent FFocusEvent
function UGSButton:GSOnFocused(FocusEvent) end
function UGSButton:GSOnReleased() end
function UGSButton:GSOnUnhovered() end
function UGSButton:GSOnConstruct() end
---@param FocusEvent FFocusEvent
function UGSButton:GSOnLostFocused(FocusEvent) end


---@class UGSButtonCheck : UGSButton
---@field CheckedWidget UWidget
---@field IsChecked boolean
---@field IsClickTriggerStateChange boolean
---@field OnGSButtonCheckStateChanged FGSButtonCheckOnGSButtonCheckStateChanged
UGSButtonCheck = {}



---@class UGSCameraGraph : UObject
UGSCameraGraph = {}

---@return boolean
function UGSCameraGraph:IsG4Mode() end
---@return boolean
function UGSCameraGraph:IsLocked() end
---@return boolean
function UGSCameraGraph:HasTarget() end
---@param TargetResID int32
---@return boolean
function UGSCameraGraph:TargetResIDEqual(TargetResID) end
---@param DurationTime float
---@return boolean
function UGSCameraGraph:HasNoCameraInput(DurationTime) end
---@return boolean
function UGSCameraGraph:IsUseGuiBeiCamera() end
function UGSCameraGraph:OnCameraGraphTick() end
---@param bEnable boolean
function UGSCameraGraph:CameraGraphNode_G4(bEnable) end
---@param ExtendID int32
---@return boolean
function UGSCameraGraph:TargetExtendIDEqual(ExtendID) end
---@param bEnable boolean
---@param ArmLength float
---@param ArmLengthSpeed float
---@param CameraPitch float
---@param CameraPitchSpeed float
function UGSCameraGraph:CameraGraphNode_Dead(bEnable, ArmLength, ArmLengthSpeed, CameraPitch, CameraPitchSpeed) end
---@param bEnable boolean
function UGSCameraGraph:CameraGraphNode_Lock(bEnable) end
---@param bEnable boolean
function UGSCameraGraph:CameraGraphNode_Giant(bEnable) end
---@param bEnable boolean
function UGSCameraGraph:CameraGraphNode_Curve(bEnable) end
---@param bEnable boolean
function UGSCameraGraph:CameraGraphNode_Player(bEnable) end
---@param bEnable boolean
---@param InCameraRotationRate float
---@param InCameraRotationAccelerate float
---@param InCameraRotationVelocityThreshold float
---@param InFallingAdjustAngleLimit float
---@param InFallingAdjustSpeedPercent float
function UGSCameraGraph:CameraGraphNode_AutoTrail(bEnable, InCameraRotationRate, InCameraRotationAccelerate, InCameraRotationVelocityThreshold, InFallingAdjustAngleLimit, InFallingAdjustSpeedPercent) end
---@param bEnable boolean
function UGSCameraGraph:CameraGraphNode_LockSkill(bEnable) end
---@param bEnable boolean
function UGSCameraGraph:CameraGraphNode_FixedParam(bEnable) end
---@param bEnable boolean
---@param CameraPitchAdditive float
---@param CameraYawAdditive float
function UGSCameraGraph:CameraGraphNode_SplineMove(bEnable, CameraPitchAdditive, CameraYawAdditive) end
---@param bEnable boolean
function UGSCameraGraph:CameraGraphNode_GiantSkill(bEnable) end
---@param bEnable boolean
---@param IsXAxisFixed boolean
---@param IsYAxisFixed boolean
---@param IsZAxisFixed boolean
---@param SmoothSpeed float
---@param CameraLagSpeed float
function UGSCameraGraph:CameraGraphNode_AxisSmooth(bEnable, IsXAxisFixed, IsYAxisFixed, IsZAxisFixed, SmoothSpeed, CameraLagSpeed) end
---@param bEnable boolean
function UGSCameraGraph:CameraGraphNode_PlayerSkill(bEnable) end
---@param bEnable boolean
function UGSCameraGraph:CameraGraphNode_GuiBeiCamera(bEnable) end
---@param bEnable boolean
function UGSCameraGraph:CameraGraphNode_ShootSuction(bEnable) end
---@param bEnable boolean
function UGSCameraGraph:CameraGraphNode_TraceVelocity(bEnable) end
---@param bEnable boolean
function UGSCameraGraph:CameraGraphNode_InverseCamera(bEnable) end
---@param bEnable boolean
function UGSCameraGraph:CameraGraphNode_CloudMoveLimit(bEnable) end
---@param bEnable boolean
function UGSCameraGraph:CameraGraphNode_LerpPostProcess(bEnable) end
---@param bEnable boolean
function UGSCameraGraph:CameraGraphNode_AutoMoveTrailCamera(bEnable) end


---@class UGSDebugDraw : UBUI_Widget
---@field DrawScreenPoint TArray<FDebugDrawPoint>
---@field DrawViewPortPoint TArray<FDebugDrawPoint>
UGSDebugDraw = {}



---@class UGSDebugDrawBase : UBUI_Widget
UGSDebugDrawBase = {}


---@class UGSDebugDrawMessage : UGSDebugDrawBase
UGSDebugDrawMessage = {}


---@class UGSDebugDrawSeqStat : UGSDebugDrawBase
UGSDebugDrawSeqStat = {}


---@class UGSDebugDrawTable : UGSDebugDrawBase
UGSDebugDrawTable = {}


---@class UGSDispLib_PostProcessContext : UObject
---@field PostProcessVolume APostProcessVolume
---@field World UWorld
---@field Config UDispLib_PostProcessConf
---@field ImageProcessor UBWS_DispLibImageProcessor
UGSDispLib_PostProcessContext = {}



---@class UGSEQC_CachedEnterBattlePoint : UGSEQCBase
UGSEQC_CachedEnterBattlePoint = {}

---@param QuerierObject UObject
---@param QuerierActor AActor
function UGSEQC_CachedEnterBattlePoint:ProvideSingleLocationCS(QuerierObject, QuerierActor) end


---@class UGSEQC_CachedGroupAIHotZonePoint : UGSEQCBase
UGSEQC_CachedGroupAIHotZonePoint = {}

---@param QuerierObject UObject
---@param QuerierActor AActor
function UGSEQC_CachedGroupAIHotZonePoint:ProvideSingleLocationCS(QuerierObject, QuerierActor) end


---@class UGSEQC_CachedSceneItem : UGSEQCBase
UGSEQC_CachedSceneItem = {}

---@param QuerierObject UObject
---@param QuerierActor AActor
function UGSEQC_CachedSceneItem:ProvideActorsSetCS(QuerierObject, QuerierActor) end


---@class UGSEQC_CaptainContext : UGSEQCBase
UGSEQC_CaptainContext = {}

---@param QuerierObject UObject
---@param QuerierActor AActor
function UGSEQC_CaptainContext:ProvideSingleActorCS(QuerierObject, QuerierActor) end


---@class UGSEQC_PlayerContext : UGSEQCBase
UGSEQC_PlayerContext = {}

---@param QuerierObject UObject
---@param QuerierActor AActor
function UGSEQC_PlayerContext:ProvideActorsSetCS(QuerierObject, QuerierActor) end


---@class UGSEQC_ProjectileContext : UGSEQCBase
---@field ProjectileID int32
UGSEQC_ProjectileContext = {}

---@param QuerierObject UObject
---@param QuerierActor AActor
function UGSEQC_ProjectileContext:ProvideActorsSetCS(QuerierObject, QuerierActor) end


---@class UGSEQC_QATargetLocationContext : UGSEQCBase
UGSEQC_QATargetLocationContext = {}

---@param QuerierObject UObject
---@param QuerierActor AActor
function UGSEQC_QATargetLocationContext:ProvideLocationsSetCS(QuerierObject, QuerierActor) end


---@class UGSEQC_QuerierNavProjectLocation : UGSEQCBase
UGSEQC_QuerierNavProjectLocation