//Stuff all/most of GemFX shared shaders need
NAMESPACE_ENTER(GFX)
#define GFX_SETTINGS_DEF "ReShade/GemFX_settings.cfg"
#define GFX_SETTINGS_UNDEF "ReShade/GemFX_settings.undef" 

#include GFX_SETTINGS_DEF

#if AL_Adaptation && AMBIENT_LIGHT
texture2D detectLowTex { Width = BUFFER_WIDTH; Height = BUFFER_HEIGHT; Format = RGBA32F; };

sampler2D detectLowColor { Texture = detectLowTex; };

#define xSprint BUFFER_WIDTH/192
#define ySprint BUFFER_HEIGHT/108

void PS_AL_DetectLow(float4 vpos : SV_Position, float2 texcoord : TEXCOORD, out float4 detectLow : SV_Target0)
{ 	[branch]
	if (texcoord.x <= BUFFER_RCP_WIDTH && texcoord.y <= BUFFER_RCP_HEIGHT) 
	{
		float4 detectLowVals = float4(0.0f,0.0f,0.0f,0.0f);
		[loop]
		for (float i = 2.0f; i < BUFFER_WIDTH; i=i+xSprint)
			[loop]
			for (float j = 2.0f; j < BUFFER_HEIGHT; j=j+ySprint )
			{
				float4 nBrightSample = tex2Dlod(RFX_backbufferColor, float4(BUFFER_RCP_WIDTH*i,BUFFER_RCP_HEIGHT*j,0.0,0.0));
				detectLowVals += nBrightSample;
			}
		detectLow = detectLowVals / ((BUFFER_WIDTH/10.0f)*(BUFFER_HEIGHT/10.0f));
	} else detectLow = float4(0,0,0,0);
}

#undef xSprint
#undef ySprint

technique Utility_Tech <bool enabled = RFX_Start_Enabled; int toggle = RFX_ToggleKey; >
{
	pass AL_DetectLow
	{
		VertexShader = RFX_VS_PostProcess;
		PixelShader = PS_AL_DetectLow;
		RenderTarget = detectLowTex;
	}
}
#endif

#include GFX_SETTINGS_UNDEF

NAMESPACE_LEAVE()

#pragma message "GemFX 0000 by LuciferHawk\n\n"