/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen.trees;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.rootplacers.AboveRootPlacement;
import net.minecraft.world.level.levelgen.feature.rootplacers.MangroveRootPlacement;
import net.minecraft.world.level.levelgen.feature.rootplacers.MangroveRootPlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;

public class ExtraRootVariantPlacer
extends MangroveRootPlacer {
    public static final Codec<ExtraRootVariantPlacer> CODEC = RecordCodecBuilder.create(inst -> ExtraRootVariantPlacer.m_225885_((RecordCodecBuilder.Instance)inst).and(inst.group((App)MangroveRootPlacement.f_225772_.fieldOf("mangrove_root_placement").forGetter(p -> p.f_225814_), (App)RootVariant.CODEC.listOf().fieldOf("root_variants").forGetter(p -> p.rootVariants))).apply((Applicative)inst, ExtraRootVariantPlacer::new));
    private final List<RootVariant> rootVariants;

    public ExtraRootVariantPlacer(IntProvider pTrunkOffset, BlockStateProvider pRootProvider, Optional<AboveRootPlacement> pAboveRootPlacement, MangroveRootPlacement mangrovePlacement, List<RootVariant> rootVariants) {
        super(pTrunkOffset, pRootProvider, pAboveRootPlacement, mangrovePlacement);
        this.rootVariants = rootVariants;
    }

    protected RootPlacerType<?> m_213745_() {
        return (RootPlacerType)TinkerStructures.extraRootVariantPlacer.get();
    }

    protected void m_213654_(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> placer, RandomSource pRandom, BlockPos pos, TreeConfiguration pTreeConfig) {
        for (RootVariant variant : this.rootVariants) {
            if (!level.m_7433_(pos, (Predicate)variant)) continue;
            placer.accept(pos, this.m_225870_(level, pos, variant.state.m_213972_(pRandom, pos)));
            return;
        }
        super.m_213654_(level, placer, pRandom, pos, pTreeConfig);
    }

    public static Builder builder() {
        return new Builder();
    }

    public record RootVariant(HolderSet<Block> holder, BlockStateProvider state) implements Predicate<BlockState>
    {
        public static final Codec<RootVariant> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)RegistryCodecs.m_206277_((ResourceKey)Registry.f_122901_).fieldOf("matches").forGetter(RootVariant::holder), (App)BlockStateProvider.f_68747_.fieldOf("state_provider").forGetter(RootVariant::state)).apply((Applicative)inst, RootVariant::new));

        @Override
        public boolean test(BlockState state) {
            return state.m_204341_(this.holder);
        }
    }

    public static class Builder {
        private IntProvider trunkOffset = null;
        private BlockStateProvider roots = null;
        @Nullable
        private AboveRootPlacement aboveRootPlacement = null;
        private HolderSet<Block> canGrowThrough = null;
        private int maxRootWidth = 8;
        private int maxRootLength = 15;
        private float randomSkewChance = 0.2f;
        private final ImmutableList.Builder<RootVariant> rootVariants = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder rootBlock(Block block) {
            return this.roots((BlockStateProvider)BlockStateProvider.m_191382_((Block)block));
        }

        @CanIgnoreReturnValue
        public Builder rootVariant(HolderSet<Block> holder, BlockStateProvider state) {
            this.rootVariants.add((Object)new RootVariant(holder, state));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rootVariant(Block rootVariant, Block ... replace) {
            return this.rootVariant((HolderSet<Block>)HolderSet.m_205806_(Block::m_204297_, (Object[])replace), (BlockStateProvider)BlockStateProvider.m_191382_((Block)rootVariant));
        }

        @CanIgnoreReturnValue
        public Builder slimyRoots(EnumObject<SlimeType, Block> slimyRoots) {
            slimyRoots.forEach((type, block) -> this.rootVariant((Block)block, (Block)block, (Block)TinkerWorld.congealedSlime.get((Enum)type)));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder canGrowThroughTag(TagKey<Block> tag) {
            return this.canGrowThrough((HolderSet<Block>)Registry.f_122824_.m_203561_(tag));
        }

        public MangroveRootPlacer build() {
            if (this.trunkOffset == null) {
                throw new IllegalStateException("Must set trunk offset");
            }
            if (this.roots == null) {
                throw new IllegalStateException("Must set roots");
            }
            if (this.canGrowThrough == null) {
                throw new IllegalStateException("Must set can grow through");
            }
            ImmutableList rootVariants = this.rootVariants.build();
            if (rootVariants.isEmpty()) {
                throw new IllegalStateException("Must have at least one root variant");
            }
            RootVariant first = (RootVariant)rootVariants.get(0);
            MangroveRootPlacement mangrovePlacement = new MangroveRootPlacement(this.canGrowThrough, first.holder, first.state, this.maxRootWidth, this.maxRootLength, this.randomSkewChance);
            if (rootVariants.size() == 1) {
                return new MangroveRootPlacer(this.trunkOffset, this.roots, Optional.ofNullable(this.aboveRootPlacement), mangrovePlacement);
            }
            return new ExtraRootVariantPlacer(this.trunkOffset, this.roots, Optional.ofNullable(this.aboveRootPlacement), mangrovePlacement, rootVariants.stream().skip(1L).toList());
        }

        public Optional<RootPlacer> buildOptional() {
            return Optional.of(this.build());
        }

        public Builder trunkOffset(IntProvider trunkOffset) {
            this.trunkOffset = trunkOffset;
            return this;
        }

        public Builder aboveRootPlacement(@Nullable AboveRootPlacement aboveRootPlacement) {
            this.aboveRootPlacement = aboveRootPlacement;
            return this;
        }

        public Builder canGrowThrough(HolderSet<Block> canGrowThrough) {
            this.canGrowThrough = canGrowThrough;
            return this;
        }

        public Builder maxRootWidth(int maxRootWidth) {
            this.maxRootWidth = maxRootWidth;
            return this;
        }

        public Builder maxRootLength(int maxRootLength) {
            this.maxRootLength = maxRootLength;
            return this;
        }

        public Builder randomSkewChance(float randomSkewChance) {
            this.randomSkewChance = randomSkewChance;
            return this;
        }

        public Builder roots(BlockStateProvider roots) {
            this.roots = roots;
            return this;
        }
    }
}

