/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import slimeknights.mantle.loot.function.SetFluidLootFunction;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.json.loot.AddToolDataFunction;
import slimeknights.tconstruct.library.json.loot.RandomMaterial;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.world.TinkerHeadType;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.FoliageType;

@Mod.EventBusSubscriber(modid="tconstruct", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class WorldEvents {
    private static void injectInto(LootTableLoadEvent event, String poolName, LootPoolEntryContainer ... entries) {
        LootPool pool = event.getTable().getPool(poolName);
        if (pool != null) {
            int oldLength = pool.f_79023_.length;
            pool.f_79023_ = Arrays.copyOf(pool.f_79023_, oldLength + entries.length);
            System.arraycopy(entries, 0, pool.f_79023_, oldLength, entries.length);
        }
    }

    private static LootPoolEntryContainer makeSeed(FoliageType type, int weight) {
        return LootItem.m_79579_((ItemLike)((ItemLike)TinkerWorld.slimeGrassSeeds.get((Enum)type))).m_79707_(weight).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)4.0f))).m_7512_();
    }

    private static LootPoolEntryContainer makeSapling(FoliageType type, int weight) {
        return LootItem.m_79579_((ItemLike)((ItemLike)TinkerWorld.slimeSapling.get((Enum)type))).m_79707_(weight).m_7512_();
    }

    @SubscribeEvent
    static void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation name = event.getName();
        if ("minecraft".equals(name.m_135827_())) {
            switch (name.m_135815_()) {
                case "chests/simple_dungeon": {
                    if (!((Boolean)Config.COMMON.slimyLootChests.get()).booleanValue()) break;
                    WorldEvents.injectInto(event, "pool1", WorldEvents.makeSeed(FoliageType.EARTH, 3), WorldEvents.makeSeed(FoliageType.SKY, 7));
                    WorldEvents.injectInto(event, "main", WorldEvents.makeSapling(FoliageType.EARTH, 3), WorldEvents.makeSapling(FoliageType.SKY, 7));
                    break;
                }
                case "chests/nether_bridge": {
                    if (!((Boolean)Config.COMMON.slimyLootChests.get()).booleanValue()) break;
                    WorldEvents.injectInto(event, "main", WorldEvents.makeSeed(FoliageType.BLOOD, 5));
                    break;
                }
                case "chests/bastion_bridge": {
                    if (!((Boolean)Config.COMMON.slimyLootChests.get()).booleanValue()) break;
                    WorldEvents.injectInto(event, "pool2", WorldEvents.makeSapling(FoliageType.BLOOD, 1));
                    break;
                }
                case "chests/end_city_treasure": {
                    if (!((Boolean)Config.COMMON.slimyLootChests.get()).booleanValue()) break;
                    WorldEvents.injectInto(event, "main", WorldEvents.makeSeed(FoliageType.ENDER, 5), WorldEvents.makeSapling(FoliageType.ENDER, 3));
                    break;
                }
                case "gameplay/piglin_bartering": {
                    int weight = (Integer)Config.COMMON.barterBlazingBlood.get();
                    if (weight <= 0) break;
                    WorldEvents.injectInto(event, "main", LootItem.m_79579_(TinkerSmeltery.scorchedLantern).m_79707_(weight).m_79078_((LootItemFunction.Builder)SetFluidLootFunction.builder((FluidStack)new FluidStack(TinkerFluids.blazingBlood.get(), 50))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_7512_());
                    break;
                }
                case "chests/spawn_bonus_chest": {
                    int weight = (Integer)Config.COMMON.tinkerToolBonusChest.get();
                    if (weight <= 0) break;
                    RandomMaterial randomHead = RandomMaterial.random(HeadMaterialStats.ID).tier(1).build();
                    RandomMaterial firstHandle = RandomMaterial.firstWithStat(HandleMaterialStats.ID);
                    RandomMaterial randomBinding = RandomMaterial.random(ExtraMaterialStats.ID).tier(1).build();
                    WorldEvents.injectInto(event, "main", LootItem.m_79579_((ItemLike)TinkerTools.handAxe.get()).m_79707_(weight).m_79078_((LootItemFunction.Builder)AddToolDataFunction.builder().addMaterial(randomHead).addMaterial(firstHandle).addMaterial(randomBinding)).m_7512_());
                    WorldEvents.injectInto(event, "pool1", LootItem.m_79579_((ItemLike)TinkerTools.pickaxe.get()).m_79707_(weight).m_79078_((LootItemFunction.Builder)AddToolDataFunction.builder().addMaterial(randomHead).addMaterial(firstHandle).addMaterial(randomBinding)).m_7512_());
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    static void livingVisibility(LivingEvent.LivingVisibilityEvent event) {
        Entity lookingEntity = event.getLookingEntity();
        if (lookingEntity == null) {
            return;
        }
        LivingEntity entity = event.getEntity();
        ItemStack helmet = entity.m_6844_(EquipmentSlot.HEAD);
        Item item = helmet.m_41720_();
        if (item != Items.f_41852_ && TinkerWorld.headItems.contains((Object)item) && lookingEntity.m_6095_() == ((TinkerHeadType)((SkullBlock)((BlockItem)item).m_40614_()).m_48754_()).getType()) {
            event.modifyVisibility(0.5);
        }
    }

    @SubscribeEvent
    static void creeperKill(LivingDropsEvent event) {
        LivingEntity dying;
        TinkerHeadType headType;
        Creeper creeper;
        Entity entity;
        DamageSource source = event.getSource();
        if (source != null && (entity = source.m_7639_()) instanceof Creeper && (creeper = (Creeper)entity).m_32313_() && (headType = TinkerHeadType.fromEntityType((dying = event.getEntity()).m_6095_())) != null && ((Boolean)Config.COMMON.headDrops.get((Object)headType).get()).booleanValue()) {
            creeper.m_32314_();
            event.getDrops().add(dying.m_19998_((ItemLike)TinkerWorld.heads.get((Enum)headType)));
        }
    }
}

