/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.ranged;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.data.FloatMultiplier;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataKeys;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class ScopeModifier
extends Modifier
implements EquipmentChangeModifierHook {
    public static final ResourceLocation SCOPE = TConstruct.getResource("longbow_scope");

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.EQUIPMENT_CHANGE);
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        IToolStackView replacement;
        if (context.getEntity().f_19853_.f_46443_ && ((replacement = context.getReplacementTool()) == null || replacement.getModifierLevel(this) == 0)) {
            context.getTinkerData().ifPresent(data -> ((FloatMultiplier)data.computeIfAbsent(TinkerDataKeys.FOV_MODIFIER)).remove(SCOPE));
        }
    }

    public static void scopingUsingTick(IToolStackView tool, LivingEntity entity, int chargeTime) {
        if (entity.f_19853_.f_46443_ && tool.getModifierLevel(TinkerModifiers.scope.getId()) > 0) {
            float drawTime = tool.getPersistentData().getInt(GeneralInteractionModifierHook.KEY_DRAWTIME);
            if (chargeTime > 0 && drawTime > 0.0f) {
                entity.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> ((FloatMultiplier)data.computeIfAbsent(TinkerDataKeys.FOV_MODIFIER)).set(SCOPE, 1.0f - 0.6f * Math.min((float)chargeTime / drawTime, 1.0f)));
            }
        }
    }

    public static void stopScoping(LivingEntity entity) {
        if (entity.f_19853_.f_46443_) {
            entity.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> ((FloatMultiplier)data.computeIfAbsent(TinkerDataKeys.FOV_MODIFIER)).remove(SCOPE));
        }
    }
}

