/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;

public class SweepingEdgeModifier
extends Modifier
implements TooltipModifierHook {
    private static final Component SWEEPING_BONUS = TConstruct.makeTranslation("modifier", "sweeping_edge.attack_damage");

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.TOOLTIP);
    }

    public float getSweepingDamage(IToolStackView toolStack, float baseDamage) {
        float level = toolStack.getModifier(this).getEffectiveLevel();
        float sweepingDamage = 1.0f;
        if (level > 4.0f) {
            sweepingDamage = baseDamage;
        } else if (level > 0.0f) {
            sweepingDamage = Math.min(baseDamage, level * 0.25f * baseDamage + 1.0f);
        }
        return sweepingDamage;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        float amount = modifier.getEffectiveLevel() * 0.25f;
        tooltip.add((Component)this.applyStyle(Component.m_237113_((String)Util.PERCENT_FORMAT.format(amount)).m_130946_(" ").m_7220_(SWEEPING_BONUS)));
    }
}

