/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class PiercingModifier
extends Modifier
implements ToolStatsModifierHook,
VolatileDataModifierHook,
MeleeHitModifierHook,
TooltipModifierHook {
    private static final ResourceLocation PIERCING_DEBUFF = TConstruct.getResource("piercing_debuff");

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.TOOL_STATS, TinkerHooks.VOLATILE_DATA, TinkerHooks.MELEE_HIT, TinkerHooks.TOOLTIP);
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, ModifierEntry modifier, ModDataNBT volatileData) {
        float toRemove = 0.5f * modifier.getEffectiveLevel();
        float baseDamage = context.getBaseStats().get(ToolStats.ATTACK_DAMAGE).floatValue();
        if (baseDamage < toRemove) {
            volatileData.putFloat(PIERCING_DEBUFF, toRemove - baseDamage);
        }
    }

    @Override
    public void addToolStats(ToolRebuildContext context, ModifierEntry modifier, ModifierStatsBuilder builder) {
        float toRemove = 0.5f * modifier.getEffectiveLevel() - context.getVolatileData().getFloat(PIERCING_DEBUFF);
        ToolStats.ATTACK_DAMAGE.add(builder, -toRemove);
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        Player player = context.getPlayerAttacker();
        DamageSource source = player != null ? DamageSource.m_19344_((Player)player) : DamageSource.m_19370_((LivingEntity)context.getAttacker());
        source.m_19380_();
        float secondaryDamage = (modifier.getEffectiveLevel() * tool.getMultiplier(ToolStats.ATTACK_DAMAGE) - tool.getVolatileData().getFloat(PIERCING_DEBUFF)) * context.getCooldown();
        if (context.isCritical()) {
            secondaryDamage *= 1.5f;
        }
        ToolAttackUtil.attackEntitySecondary(source, secondaryDamage, context.getTarget(), context.getLivingTarget(), true);
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        TooltipModifierHook.addDamageBoost(tool, this, modifier.getEffectiveLevel() - tool.getVolatileData().getFloat(PIERCING_DEBUFF), tooltip);
    }
}

