/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.general;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.level.BlockEvent;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.capability.EntityModifierCapability;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierLootingHandler;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ExperiencedModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> EXPERIENCED = TConstruct.createKey("experienced");

    public ExperiencedModifier() {
        MinecraftForge.EVENT_BUS.addListener(this::onExperienceDrop);
        MinecraftForge.EVENT_BUS.addListener(this::onEntityKilled);
        MinecraftForge.EVENT_BUS.addListener(this::beforeBlockBreak);
    }

    private static int boost(int original, int level) {
        return (int)((double)original * (1.0 + 0.5 * (double)level));
    }

    private void beforeBlockBreak(BlockEvent.BreakEvent event) {
        int level = 0;
        ToolStack tool = ExperiencedModifier.getHeldTool((LivingEntity)event.getPlayer(), InteractionHand.MAIN_HAND);
        if (tool != null) {
            level = tool.getModifierLevel(this);
        }
        if ((tool = ExperiencedModifier.getHeldTool((LivingEntity)event.getPlayer(), EquipmentSlot.LEGS)) != null) {
            level += tool.getModifierLevel(this);
        }
        if (level > 0) {
            event.setExpToDrop(ExperiencedModifier.boost(event.getExpToDrop(), level));
        }
    }

    private void onEntityKilled(LivingDeathEvent event) {
        Projectile projectile;
        ModifierNBT modifiers;
        Entity entity;
        DamageSource source = event.getSource();
        if (source != null && (entity = source.m_7640_()) instanceof Projectile && !(modifiers = EntityModifierCapability.getOrEmpty((Entity)(projectile = (Projectile)entity))).isEmpty()) {
            event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> data.put(EXPERIENCED, modifiers.getLevel(this.getId())));
        }
    }

    private void onExperienceDrop(LivingExperienceDropEvent event) {
        Player player;
        int experienced = event.getEntity().getCapability(TinkerDataCapability.CAPABILITY).resolve().map(data -> data.get(EXPERIENCED)).orElse(-1);
        if (experienced > 0) {
            event.setDroppedExperience(ExperiencedModifier.boost(event.getDroppedExperience(), experienced));
        } else if (experienced != 0 && (player = event.getAttackingPlayer()) != null) {
            int level = 0;
            ToolStack tool = ExperiencedModifier.getHeldTool((LivingEntity)player, ModifierLootingHandler.getLootingSlot((LivingEntity)player));
            if (tool != null) {
                level = tool.getModifierLevel(this);
            }
            if ((tool = ExperiencedModifier.getHeldTool((LivingEntity)player, EquipmentSlot.LEGS)) != null) {
                level += tool.getModifierLevel(this);
            }
            if (level > 0) {
                event.setDroppedExperience(ExperiencedModifier.boost(event.getDroppedExperience(), level));
            }
        }
    }
}

