/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.upgrades.armor;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.definition.ModifiableArmorMaterial;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.logic.InteractionHandler;

public class SpringyModifier
extends Modifier
implements EquipmentChangeModifierHook,
MeleeHitModifierHook,
OnAttackedModifierHook {
    private static final TinkerDataCapability.TinkerDataKey<SlotInCharge> SLOT_IN_CHARGE = TConstruct.createKey("springy");

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.EQUIPMENT_CHANGE, TinkerHooks.MELEE_HIT, TinkerHooks.ON_ATTACKED);
    }

    @Override
    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        LivingEntity user = context.getEntity();
        Entity attacker = source.m_7639_();
        if (isDirectDamage && !user.f_19853_.f_46443_ && attacker instanceof LivingEntity) {
            LivingEntity livingAttacker = (LivingEntity)attacker;
            context.getTinkerData().ifPresent(data -> {
                if (Optional.ofNullable(data.get(SLOT_IN_CHARGE)).filter(slot -> slot.inCharge == slotType).isPresent()) {
                    float bestBonus = 0.0f;
                    for (EquipmentSlot bouncingSlot : ModifiableArmorMaterial.ARMOR_SLOTS) {
                        float newBonus;
                        IToolStackView bouncingTool = context.getToolInSlot(bouncingSlot);
                        if (bouncingTool == null || bouncingTool.isBroken()) continue;
                        int level = modifier.getLevel();
                        if (!(RANDOM.nextFloat() < (float)level * 0.25f) || !((newBonus = 0.5f * RANDOM.nextFloat() * (float)level) > bestBonus)) continue;
                        bestBonus = newBonus;
                    }
                    if (bestBonus > 0.0f) {
                        float angle = attacker.m_146908_() * (float)Math.PI / 180.0f;
                        livingAttacker.m_147240_((double)bestBonus, (double)(-Mth.m_14031_((float)angle)), (double)Mth.m_14089_((float)angle));
                    }
                }
            });
        }
    }

    private static boolean toolValid(IToolStackView tool, EquipmentSlot slot, EquipmentChangeContext context) {
        if (!tool.isBroken() && !context.getEntity().f_19853_.f_46443_) {
            return ModifierUtil.validArmorSlot(tool, slot);
        }
        return false;
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        EquipmentSlot slot = context.getChangedSlot();
        if (SpringyModifier.toolValid(tool, slot, context)) {
            context.getTinkerData().ifPresent(data -> {
                SlotInCharge slotInCharge = data.get(SLOT_IN_CHARGE);
                if (slotInCharge != null) {
                    slotInCharge.removeSlot(slot);
                }
            });
        }
    }

    @Override
    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        EquipmentSlot slot = context.getChangedSlot();
        if (SpringyModifier.toolValid(tool, slot, context)) {
            context.getTinkerData().ifPresent(data -> {
                SlotInCharge slotInCharge = data.get(SLOT_IN_CHARGE);
                if (slotInCharge == null) {
                    slotInCharge = new SlotInCharge();
                    data.put(SLOT_IN_CHARGE, slotInCharge);
                }
                slotInCharge.addSlot(slot);
            });
        }
    }

    @Override
    public float beforeMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damage, float baseKnockback, float knockback) {
        return knockback + (float)modifier.getLevel() * 0.5f;
    }

    private static class SlotInCharge {
        private final boolean[] active = new boolean[6];
        @Nullable
        EquipmentSlot inCharge = null;

        private SlotInCharge() {
        }

        void addSlot(EquipmentSlot slotType) {
            this.active[slotType.m_20750_()] = true;
            if (this.inCharge == null || this.inCharge.m_20743_() == EquipmentSlot.Type.HAND && slotType != EquipmentSlot.OFFHAND) {
                this.inCharge = slotType;
            }
        }

        void removeSlot(EquipmentSlot slotType) {
            this.active[slotType.m_20750_()] = false;
            for (EquipmentSlot armorSlot : ModifiableArmorMaterial.ARMOR_SLOTS) {
                if (!this.active[slotType.m_20750_()]) continue;
                this.inCharge = armorSlot;
                return;
            }
            for (EquipmentSlot hand : InteractionHandler.HAND_SLOTS) {
                if (!this.active[slotType.m_20750_()]) continue;
                this.inCharge = hand;
                return;
            }
            this.inCharge = null;
        }
    }
}

