/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.skull;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffect;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.modifiers.modules.unserializable.ArmorLevelModule;
import slimeknights.tconstruct.library.modifiers.modules.unserializable.CureOnRemovalModule;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class StrongBonesModifier
extends NoLevelsModifier {
    public static final TinkerDataCapability.TinkerDataKey<Integer> CALCIFIABLE = TConstruct.createKey("calcifable");
    public static final ArmorLevelModule CALCIFIABLE_MODULE = new ArmorLevelModule(CALCIFIABLE, false);
    public static final FluidEffect<FluidEffectContext.Entity> FLUID_EFFECT = FluidEffect.simple((fluid, scale, context, action) -> {
        LivingEntity target = context.getLivingTarget();
        if (target != null && StrongBonesModifier.drinkMilk(target, (int)(400.0f * scale.value()))) {
            return scale.value();
        }
        return 0.0f;
    });

    public StrongBonesModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, LivingEntityUseItemEvent.Finish.class, StrongBonesModifier::onItemFinishUse);
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addModule(CureOnRemovalModule.HELMET);
    }

    private static boolean drinkMilk(LivingEntity living, int duration) {
        ItemStack helmet = living.m_6844_(EquipmentSlot.HEAD);
        boolean didSomething = false;
        if (ModifierUtil.getModifierLevel(helmet, TinkerModifiers.strongBones.getId()) > 0) {
            MobEffectInstance effect = new MobEffectInstance(MobEffects.f_19606_, duration);
            effect.getCurativeItems().clear();
            effect.getCurativeItems().add(new ItemStack((ItemLike)helmet.m_41720_()));
            didSomething = living.m_7292_(effect);
        }
        if (ArmorLevelModule.getLevel(living, CALCIFIABLE) > 0) {
            didSomething |= living.m_7292_(new MobEffectInstance((MobEffect)TinkerModifiers.calcifiedEffect.get(), duration, 0));
        }
        return didSomething;
    }

    private static void onItemFinishUse(LivingEntityUseItemEvent.Finish event) {
        LivingEntity living = event.getEntity();
        if (event.getItem().m_41720_() == Items.f_42455_) {
            StrongBonesModifier.drinkMilk(living, 1200);
        }
    }
}

