/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.effect.BleedingEffect;

public class LaceratingModifier
extends Modifier
implements ProjectileHitModifierHook,
MeleeHitModifierHook {
    private static void applyEffect(LivingEntity target, int level) {
        ((BleedingEffect)((Object)TinkerModifiers.bleeding.get())).apply(target, 1 + 20 * (2 + RANDOM.nextInt(level + 3)), level - 1, true);
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, TinkerHooks.PROJECTILE_HIT, TinkerHooks.MELEE_HIT);
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        LivingEntity target = context.getLivingTarget();
        if (target != null && context.isFullyCharged() && target.m_6084_() && RANDOM.nextFloat() < 0.5f) {
            target.m_21335_((Entity)context.getAttacker());
            LaceratingModifier.applyEffect(target, modifier.getLevel());
        }
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        AbstractArrow arrow;
        if (target != null && (!(projectile instanceof AbstractArrow) || (arrow = (AbstractArrow)projectile).m_36792_()) && target.m_6084_() && RANDOM.nextFloat() < 0.5f) {
            Entity owner = projectile.m_37282_();
            if (owner != null) {
                target.m_21335_(owner);
            }
            LaceratingModifier.applyEffect(target, modifier.getLevel());
        }
        return false;
    }
}

