/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.biome.Biome;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class InvariantModifier
extends Modifier
implements ConditionalStatModifierHook,
MeleeDamageModifierHook,
TooltipModifierHook {
    private static final float BASELINE_TEMPERATURE = 0.75f;
    private static final float MAX_TEMPERATURE = 1.25f;
    private static final float DAMAGE = 2.0f;
    private static final float ACCURACY = 0.120000005f;

    private static float getBonus(LivingEntity living, int level) {
        BlockPos pos = living.m_20183_();
        return (1.25f - Math.abs(0.75f - ((Biome)living.f_19853_.m_204166_(pos).m_203334_()).m_47505_(pos))) * (float)level;
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.CONDITIONAL_STAT, TinkerHooks.MELEE_DAMAGE, TinkerHooks.TOOLTIP);
    }

    @Override
    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        return damage + InvariantModifier.getBonus(context.getAttacker(), modifier.getLevel()) * 2.0f * tool.getMultiplier(ToolStats.ATTACK_DAMAGE);
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.ACCURACY) {
            return baseValue + InvariantModifier.getBonus(living, modifier.getLevel()) * 0.120000005f * multiplier;
        }
        return baseValue;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        int level = modifier.getLevel();
        float bonus = player != null && key == TooltipKey.SHIFT ? InvariantModifier.getBonus((LivingEntity)player, level) : (float)level * 1.25f;
        if (bonus > 0.01f) {
            if (tool.hasTag(TinkerTags.Items.RANGED)) {
                TooltipModifierHook.addStatBoost(tool, this, ToolStats.ACCURACY, TinkerTags.Items.RANGED, bonus * 0.120000005f, tooltip);
            } else {
                TooltipModifierHook.addDamageBoost(tool, this, bonus * 2.0f, tooltip);
            }
        }
    }
}

