/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.melee;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class InsatibleModifier
extends Modifier
implements ProjectileHitModifierHook,
ConditionalStatModifierHook,
MeleeDamageModifierHook,
MeleeHitModifierHook,
TooltipModifierHook {
    private static float getBonus(LivingEntity attacker, int level, TinkerEffect effect) {
        int effectLevel = effect.getLevel(attacker) + 1;
        return (float)(level * effectLevel) / 4.0f;
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook(this, TinkerHooks.PROJECTILE_HIT, TinkerHooks.CONDITIONAL_STAT, TinkerHooks.MELEE_DAMAGE, TinkerHooks.MELEE_HIT, TinkerHooks.TOOLTIP);
    }

    @Override
    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        return damage + InsatibleModifier.getBonus(context.getAttacker(), modifier.getLevel(), (TinkerEffect)((Object)TinkerModifiers.insatiableEffect.get())) * tool.getMultiplier(ToolStats.ATTACK_DAMAGE);
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (!context.isExtraAttack() && context.isFullyCharged()) {
            LivingEntity attacker = context.getAttacker();
            int effectLevel = Math.min(7, ((TinkerEffect)((Object)TinkerModifiers.insatiableEffect.get())).getLevel(attacker) + 1);
            ((TinkerEffect)((Object)TinkerModifiers.insatiableEffect.get())).apply(attacker, 100, effectLevel, true);
        }
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.PROJECTILE_DAMAGE) {
            baseValue += InsatibleModifier.getBonus(living, modifier.getLevel(), (TinkerEffect)((Object)TinkerModifiers.insatiableRangedEffect.get())) / 2.0f * multiplier;
        }
        return baseValue;
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (attacker != null) {
            int effectLevel = Math.min(7, ((TinkerEffect)((Object)TinkerModifiers.insatiableRangedEffect.get())).getLevel(attacker) + 1);
            ((TinkerEffect)((Object)TinkerModifiers.insatiableRangedEffect.get())).apply(attacker, 200, effectLevel, true);
        }
        return false;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        int level = modifier.getLevel();
        float bonus = level * 2;
        if (player != null && key == TooltipKey.SHIFT) {
            bonus = InsatibleModifier.getBonus((LivingEntity)player, level, tool.hasTag(TinkerTags.Items.RANGED) ? (TinkerEffect)((Object)TinkerModifiers.insatiableRangedEffect.get()) : (TinkerEffect)((Object)TinkerModifiers.insatiableEffect.get()));
        }
        TooltipModifierHook.addDamageBoost(tool, this, bonus, tooltip);
    }
}

