/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.traits.harvest;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.behavior.ReduceToolDamageModule;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;

public class TemperateModifier
extends Modifier
implements ConditionalStatModifierHook,
ToolDamageModifierHook,
BreakSpeedModifierHook,
TooltipModifierHook {
    private static final float BASELINE_TEMPERATURE = 0.75f;
    private static final float MAX_MINING_BOOST = 7.5f;
    private static final float MAX_DRAWSPEED_BOOST = 0.15f;
    private static final Component SPEED = TConstruct.makeTranslation("modifier", "temperate.speed");
    private static final Component REINFORCED = TConstruct.makeTranslation("modifier", "temperate.reinforced");

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.CONDITIONAL_STAT, TinkerHooks.TOOL_DAMAGE, TinkerHooks.BREAK_SPEED, TinkerHooks.TOOLTIP);
    }

    private static float diminishingPercent(float level) {
        if (level < 5.0f) {
            return 0.025f * level * (11.0f - level);
        }
        return 0.75f + (level - 5.0f) * 0.05f;
    }

    private static float getBonus(LivingEntity living, BlockPos pos, int level) {
        return (((Biome)living.f_19853_.m_204166_(pos).m_203334_()).m_47505_(pos) - 0.75f) * (float)level / 1.25f;
    }

    @Override
    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity holder) {
        float bonus;
        if (holder != null && (bonus = TemperateModifier.getBonus(holder, holder.m_20183_(), modifier.getLevel())) > 0.0f) {
            return ReduceToolDamageModule.reduceDamage(amount, TemperateModifier.diminishingPercent(bonus * 2.0f));
        }
        return amount;
    }

    @Override
    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        float bonus;
        if (isEffective && (bonus = TemperateModifier.getBonus((LivingEntity)event.getEntity(), event.getPos(), modifier.getLevel())) < 0.0f) {
            event.setNewSpeed(event.getNewSpeed() - bonus * 7.5f * tool.getMultiplier(ToolStats.MINING_SPEED) * miningSpeedModifier);
        }
    }

    @Override
    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        float bonus;
        if (stat == ToolStats.DRAW_SPEED && (bonus = TemperateModifier.getBonus(living, living.m_20183_(), modifier.getLevel())) < 0.0f) {
            baseValue -= bonus * 0.15f * multiplier;
        }
        return baseValue;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry entry, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag tooltipFlag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (harvest || tool.hasTag(TinkerTags.Items.RANGED)) {
            int level = entry.getLevel();
            float bonus = player != null && key == TooltipKey.SHIFT ? TemperateModifier.getBonus((LivingEntity)player, player.m_20183_(), level) : (float)(-level);
            if (bonus < -0.01f) {
                float value = harvest ? -bonus * tool.getMultiplier(ToolStats.MINING_SPEED) * 7.5f : -bonus * tool.getMultiplier(ToolStats.DRAW_SPEED) * 0.15f;
                TooltipModifierHook.addFlatBoost(entry.getModifier(), SPEED, value, tooltip);
            }
            if (bonus > 0.01f) {
                tooltip.add((Component)this.applyStyle(Component.m_237113_((String)(Util.PERCENT_FORMAT.format(TemperateModifier.diminishingPercent(bonus * 2.0f)) + " ")).m_7220_(REINFORCED)));
            }
        }
    }
}

