/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.slotless;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.DurabilityShieldModifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class OverslimeModifier
extends DurabilityShieldModifier
implements ToolStatsModifierHook,
VolatileDataModifierHook {
    private static final ResourceLocation KEY_OVERSLIME_CAP = TConstruct.getResource("overslime_cap");
    public static final ResourceLocation KEY_OVERSLIME_FRIEND = TConstruct.getResource("overslime_friend");

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.TOOL_STATS, TinkerHooks.VOLATILE_DATA);
    }

    @Override
    public Component getDisplayName(int level) {
        return super.getDisplayName();
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, ModifierEntry modifier, ModDataNBT volatileData) {
        this.addCapacity(volatileData, (int)(50.0f * context.getDefinition().getData().getMultiplier(ToolStats.DURABILITY)));
    }

    @Override
    public void addToolStats(ToolRebuildContext context, ModifierEntry modifier, ModifierStatsBuilder builder) {
        if (!context.getVolatileData().getBoolean(KEY_OVERSLIME_FRIEND)) {
            if (context.hasTag(TinkerTags.Items.MELEE)) {
                ToolStats.ATTACK_DAMAGE.multiply(builder, 0.9f);
            }
            if (context.hasTag(TinkerTags.Items.HARVEST)) {
                ToolStats.MINING_SPEED.multiply(builder, 0.9f);
            }
            if (context.hasTag(TinkerTags.Items.ARMOR)) {
                ToolStats.ARMOR.add(builder, -0.5);
            }
            if (context.hasTag(TinkerTags.Items.RANGED)) {
                ToolStats.VELOCITY.multiply(builder, 0.9f);
            }
        }
    }

    @Override
    public int getPriority() {
        return 150;
    }

    @Override
    @Nullable
    public Boolean showDurabilityBar(IToolStackView tool, ModifierEntry modifier) {
        return this.getOverslime(tool) < this.getCapacity(tool) ? Boolean.valueOf(true) : null;
    }

    @Override
    public int getDurabilityRGB(IToolStackView tool, ModifierEntry modifier) {
        if (this.getOverslime(tool) > 0) {
            return 53503;
        }
        return -1;
    }

    @Override
    protected ResourceLocation getShieldKey() {
        return this.getId();
    }

    public ResourceLocation getCapacityKey() {
        return KEY_OVERSLIME_CAP;
    }

    public ResourceLocation getFriendKey() {
        return KEY_OVERSLIME_FRIEND;
    }

    public void setFriend(ModDataNBT volatileData) {
        volatileData.putBoolean(this.getFriendKey(), true);
    }

    public int getCapacity(IModDataView volatileData) {
        return volatileData.getInt(this.getCapacityKey());
    }

    public int getCapacity(IToolStackView tool) {
        return this.getCapacity(tool.getVolatileData());
    }

    @Override
    protected int getShieldCapacity(IToolStackView tool, int level) {
        return this.getCapacity(tool);
    }

    public void setCapacity(ModDataNBT volatileData, int amount) {
        volatileData.putInt(KEY_OVERSLIME_CAP, amount);
    }

    public void addCapacity(ModDataNBT volatileData, int amount) {
        this.setCapacity(volatileData, this.getCapacity(volatileData) + amount);
    }

    public void multiplyCapacity(ModDataNBT volatileData, float factor) {
        volatileData.putInt(KEY_OVERSLIME_CAP, (int)((float)this.getCapacity(volatileData) * factor));
    }

    public int getOverslime(IToolStackView tool) {
        return this.getShield(tool);
    }

    @Override
    public void setShield(ModDataNBT persistentData, int amount) {
        super.setShield(persistentData, amount);
    }

    public void setOverslime(IToolStackView tool, int amount) {
        this.setShield(tool, 0, amount);
    }

    public void addOverslime(IToolStackView tool, int amount) {
        int overworked = tool.getModifierLevel(TinkerModifiers.overworked.getId());
        this.addShield(tool, 0, amount * (1 + overworked));
    }
}

