/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.hook.armor.ProtectionModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.armor.ProtectionModule;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.modifiers.defense.AbstractProtectionModifier;

public class ShulkingModifier
extends AbstractProtectionModifier<ModifierMaxLevel>
implements ProtectionModifierHook,
TooltipModifierHook {
    private static final TinkerDataCapability.TinkerDataKey<ModifierMaxLevel> KEY = TConstruct.createKey("shulking");

    public ShulkingModifier() {
        super(KEY);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, LivingHurtEvent.class, ShulkingModifier::onAttack);
    }

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.PROTECTION, TinkerHooks.TOOLTIP);
    }

    @Override
    protected ModifierMaxLevel createData(EquipmentChangeContext context) {
        return new ModifierMaxLevel();
    }

    @Override
    public float getProtectionModifier(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float modifierValue) {
        if (context.getEntity().m_6047_() && !source.m_19379_() && !source.m_19378_()) {
            modifierValue += modifier.getEffectiveLevel() * 2.5f;
        }
        return modifierValue;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        ProtectionModule.addResistanceTooltip(tool, this, modifier.getEffectiveLevel() * 2.5f, player, tooltip);
    }

    private static void onAttack(LivingHurtEvent event) {
        Entity attacker = event.getSource().m_7639_();
        if (attacker != null && attacker.m_6047_()) {
            attacker.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(data -> {
                ModifierMaxLevel max = data.get(KEY);
                if (max != null) {
                    event.setAmount(event.getAmount() * (1.0f - max.getMax() * 0.1f));
                }
            });
        }
    }
}

