/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public abstract class AbstractProtectionModifier<T extends ModifierMaxLevel>
extends Modifier
implements EquipmentChangeModifierHook {
    private final TinkerDataCapability.TinkerDataKey<T> key;

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        hookBuilder.addHook(this, TinkerHooks.EQUIPMENT_CHANGE);
    }

    protected abstract T createData(EquipmentChangeContext var1);

    protected void reset(T data, EquipmentChangeContext context) {
    }

    protected void set(T data, EquipmentSlot slot, float scaledLevel, EquipmentChangeContext context) {
        ((ModifierMaxLevel)data).set(slot, scaledLevel);
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        LivingEntity entity = context.getEntity();
        EquipmentSlot slot = context.getChangedSlot();
        if (ModifierUtil.validArmorSlot(tool, slot) && !entity.f_19853_.f_46443_) {
            context.getTinkerData().ifPresent(data -> {
                ModifierMaxLevel modData = (ModifierMaxLevel)data.get(this.key);
                if (modData != null) {
                    this.set(modData, slot, 0.0f, context);
                    if (modData.getMax() == 0.0f) {
                        this.reset(modData, context);
                    }
                }
            });
        }
    }

    @Override
    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        LivingEntity entity = context.getEntity();
        EquipmentSlot slot = context.getChangedSlot();
        if (!entity.f_19853_.f_46443_ && ModifierUtil.validArmorSlot(tool, slot) && !tool.isBroken()) {
            float scaledLevel = modifier.getEffectiveLevel();
            context.getTinkerData().ifPresent(data -> {
                ModifierMaxLevel modData = (ModifierMaxLevel)data.get(this.key);
                if (modData == null) {
                    modData = this.createData(context);
                    data.put(this.key, modData);
                }
                this.set(modData, slot, scaledLevel, context);
            });
        }
    }

    public AbstractProtectionModifier(TinkerDataCapability.TinkerDataKey<T> key) {
        this.key = key;
    }
}

