/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.tool;

import java.util.Iterator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.modifiers.modules.fluid.TankModule;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipe;
import slimeknights.tconstruct.library.recipe.entitymelting.EntityMeltingRecipeCache;
import slimeknights.tconstruct.library.recipe.melting.IMeltingContainer;
import slimeknights.tconstruct.library.recipe.melting.IMeltingRecipe;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.smeltery.block.entity.module.EntityMeltingModule;

public class MeltingModifier
extends NoLevelsModifier
implements MeleeHitModifierHook {
    private static final int MAX_TEMPERATURE = 1000;
    private static IMeltingRecipe lastRecipe = null;
    private static final MeltingContainer inventory = new MeltingContainer();
    private TankModule tank;

    @Override
    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        super.registerHooks(hookBuilder);
        this.tank = new TankModule(1000, true);
        hookBuilder.addModule(this.tank);
        hookBuilder.addHook(this, TinkerHooks.MELEE_HIT);
    }

    private static FluidStack meltItem(ItemStack stack, Level world) {
        inventory.setStack(stack);
        IMeltingRecipe recipe = lastRecipe;
        if (recipe == null || !recipe.m_5818_((Container)inventory, world)) {
            recipe = world.m_7465_().m_44015_((RecipeType)TinkerRecipeTypes.MELTING.get(), (Container)inventory, world).orElse(null);
            if (recipe == null) {
                inventory.setStack(ItemStack.f_41583_);
                return FluidStack.EMPTY;
            }
            lastRecipe = recipe;
        }
        FluidStack result = FluidStack.EMPTY;
        if (recipe.getTemperature(inventory) <= 1000) {
            result = recipe.getOutput(inventory);
        }
        inventory.setStack(ItemStack.f_41583_);
        return result;
    }

    @Override
    public void processLoot(IToolStackView tool, int level, List<ItemStack> generatedLoot, LootContext context) {
        FluidStack current = this.tank.getFluid(tool);
        int capacity = this.tank.getCapacity(tool);
        if (current.getAmount() >= capacity) {
            return;
        }
        ServerLevel world = context.m_78952_();
        Iterator<ItemStack> iterator = generatedLoot.iterator();
        boolean isDirty = false;
        while (iterator.hasNext()) {
            int maxCopies;
            ItemStack stack = iterator.next();
            FluidStack output = MeltingModifier.meltItem(stack, (Level)world);
            if (output.isEmpty() || !current.isEmpty() && !current.isFluidEqual(output) || (maxCopies = Math.min((capacity - current.getAmount()) / output.getAmount(), stack.m_41613_())) <= 0) continue;
            int amount = output.getAmount() * maxCopies;
            if (current.isEmpty()) {
                output.setAmount(amount);
                current = output;
            } else {
                current.setAmount(amount);
            }
            isDirty = true;
            stack.m_41774_(maxCopies);
            if (!stack.m_41619_()) continue;
            iterator.remove();
        }
        if (isDirty) {
            this.tank.setFluid(tool, current);
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        LivingEntity target;
        if (damageDealt > 0.0f && context.isFullyCharged() && (target = context.getLivingTarget()) != null) {
            int damagePerOutput;
            FluidStack output;
            EntityMeltingRecipe recipe = EntityMeltingRecipeCache.findRecipe(context.getAttacker().f_19853_.m_7465_(), target.m_6095_());
            if (recipe != null) {
                output = recipe.getOutput(target);
                damagePerOutput = recipe.getDamage();
            } else {
                output = EntityMeltingModule.getDefaultFluid();
                damagePerOutput = 2;
            }
            int fluidAmount = damageDealt < (float)(damagePerOutput * 2) ? (int)((float)output.getAmount() * damageDealt / (float)damagePerOutput) : output.getAmount() * 2;
            FluidStack fluid = this.tank.getFluid(tool);
            if (fluid.isEmpty()) {
                output.setAmount(fluidAmount);
                fluid = output;
            } else {
                fluid.grow(fluidAmount);
            }
            this.tank.setFluid(tool, fluid);
        }
    }

    private static class MeltingContainer
    implements IMeltingContainer {
        private ItemStack stack;

        private MeltingContainer() {
        }

        @Override
        public IMeltingContainer.IOreRate getOreRate() {
            return Config.COMMON.melterOreRate;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
        }
    }
}

