/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.dynamic.InventoryMenuModifier;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class ShieldStrapModifier
extends InventoryMenuModifier {
    private static final ResourceLocation KEY = TConstruct.getResource("shield_strap");
    private static final Pattern PATTERN = new Pattern("tconstruct", "shield_plus");

    public ShieldStrapModifier() {
        super(KEY, 1);
    }

    @Override
    public int getPriority() {
        return 95;
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, ModifierEntry modifier, ModDataNBT volatileData) {
        super.addVolatileData(context, modifier, volatileData);
        volatileData.putBoolean(ToolInventoryCapability.INCLUDE_OFFHAND, true);
    }

    @Override
    public boolean startInteract(IToolStackView tool, ModifierEntry modifier, Player player, EquipmentSlot equipmentSlot, TooltipKey keyModifier) {
        if (keyModifier == TooltipKey.SHIFT) {
            return super.startInteract(tool, modifier, player, equipmentSlot, keyModifier);
        }
        if (keyModifier == TooltipKey.NORMAL) {
            if (player.f_19853_.f_46443_) {
                return true;
            }
            ItemStack offhand = player.m_21206_();
            int slots = this.getSlots((IToolContext)tool, modifier.getLevel());
            if (offhand.m_41619_() || !ToolInventoryCapability.isBlacklisted(offhand)) {
                ItemStack newOffhand = ItemStack.f_41583_;
                ModDataNBT persistentData = tool.getPersistentData();
                ListTag list = new ListTag();
                if (persistentData.contains(KEY, 9)) {
                    ListTag original = (ListTag)persistentData.get(KEY, GET_COMPOUND_LIST);
                    for (int i = 0; i < original.size(); ++i) {
                        CompoundTag compoundNBT = original.m_128728_(i);
                        int slot = compoundNBT.m_128451_("Slot");
                        if (slot == 0) {
                            newOffhand = ItemStack.m_41712_((CompoundTag)compoundNBT);
                            continue;
                        }
                        if (slot >= slots) continue;
                        CompoundTag copy = compoundNBT.m_6426_();
                        copy.m_128405_("Slot", slot - 1);
                        list.add((Object)copy);
                    }
                }
                if (!offhand.m_41619_()) {
                    list.add((Object)ShieldStrapModifier.write(offhand, slots - 1));
                }
                persistentData.put(KEY, (Tag)list);
                player.m_21008_(InteractionHand.OFF_HAND, newOffhand);
                if (!newOffhand.m_41619_() || !list.isEmpty()) {
                    player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11675_, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public Pattern getPattern(IToolStackView tool, ModifierEntry modifier, int slot, boolean hasStack) {
        return hasStack ? null : PATTERN;
    }
}

