/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor;

import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.network.TinkerNetwork;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.GeneralInteractionModifierHook;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.logic.InteractionHandler;

public class ReflectingModifier
extends Modifier {
    public ReflectingModifier() {
        MinecraftForge.EVENT_BUS.addListener(this::projectileImpact);
    }

    private void projectileImpact(ProjectileImpactEvent event) {
        Entity entity = event.getEntity();
        if (!entity.f_19853_.f_46443_) {
            ModifierEntry activeModifier;
            ToolStack tool;
            int reflectingLevel;
            ItemStack stack;
            LivingEntity living;
            Entity entity2;
            Projectile projectile = event.getProjectile();
            HitResult hit = event.getRayTraceResult();
            if (!RegistryHelper.contains(TinkerTags.EntityTypes.REFLECTING_BLACKLIST, (EntityType)projectile.m_6095_()) && hit.m_6662_() == HitResult.Type.ENTITY && (entity2 = ((EntityHitResult)hit).m_82443_()) instanceof LivingEntity && (living = (LivingEntity)entity2).m_6117_() && living != projectile.m_37282_() && (stack = living.m_21211_()).m_204117_(TinkerTags.Items.SHIELDS) && (reflectingLevel = (tool = ToolStack.from(stack)).getModifierLevel(this)) > 0 && (activeModifier = GeneralInteractionModifierHook.getActiveModifier(tool)) != ModifierEntry.EMPTY) {
                GeneralInteractionModifierHook hook = activeModifier.getHook(TinkerHooks.GENERAL_INTERACT);
                int time = hook.getUseDuration(tool, activeModifier) - living.m_21212_();
                if (hook.getUseAction(tool, activeModifier) == UseAnim.BLOCK && time >= 5 && time < 40 * reflectingLevel && InteractionHandler.canBlock(living, projectile.m_20182_(), tool)) {
                    if (!RegistryHelper.contains(TinkerTags.EntityTypes.REFLECTING_PRESERVE_OWNER, (EntityType)projectile.m_6095_())) {
                        if (projectile instanceof AbstractArrow) {
                            AbstractArrow arrow = (AbstractArrow)projectile;
                            AbstractArrow.Pickup pickup = arrow.f_36705_;
                            arrow.m_5602_((Entity)living);
                            arrow.f_36705_ = pickup;
                        } else {
                            projectile.m_5602_((Entity)living);
                        }
                        projectile.f_37246_ = true;
                    }
                    Vec3 reboundAngle = living.m_20154_();
                    float velocity = ConditionalStatModifierHook.getModifiedStat(tool, living, ToolStats.VELOCITY) * 1.1f;
                    projectile.m_6686_(reboundAngle.f_82479_, reboundAngle.f_82480_, reboundAngle.f_82481_, velocity, ModifierUtil.getInaccuracy(tool, living));
                    if (projectile instanceof AbstractHurtingProjectile) {
                        AbstractHurtingProjectile hurting = (AbstractHurtingProjectile)projectile;
                        hurting.f_36813_ = reboundAngle.f_82479_ * 0.1;
                        hurting.f_36814_ = reboundAngle.f_82480_ * 0.1;
                        hurting.f_36815_ = reboundAngle.f_82481_ * 0.1;
                    }
                    if (living.m_6095_() == EntityType.f_20532_) {
                        TinkerNetwork.getInstance().sendVanillaPacket((Packet)new ClientboundSetEntityMotionPacket((Entity)projectile), (Entity)living);
                    }
                    living.f_19853_.m_5594_(null, living.m_20183_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 1.5f + living.f_19853_.f_46441_.m_188501_() * 0.4f);
                    event.setCanceled(true);
                }
            }
        }
    }
}

