/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.menu;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import slimeknights.mantle.inventory.EmptyItemHandler;
import slimeknights.mantle.inventory.SmartItemHandlerSlot;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.menu.ReadOnlySlot;

public class ToolContainerMenu
extends AbstractContainerMenu {
    public static final int SLOT_SIZE = 18;
    public static final int REPEAT_BACKGROUND_START = 17;
    private final ItemStack stack;
    private final IItemHandler itemHandler;
    private final Player player;
    private final EquipmentSlot slotType;
    private final int selectedHotbarSlot;
    private final boolean showOffhand;
    private final int playerInventoryStart;

    public ToolContainerMenu(int id, Inventory playerInventory, ItemStack stack, IItemHandlerModifiable itemHandler, EquipmentSlot slotType) {
        this((MenuType)TinkerTools.toolContainer.get(), id, playerInventory, stack, (IItemHandler)itemHandler, slotType);
    }

    public static ToolContainerMenu forClient(int id, Inventory inventory, FriendlyByteBuf buffer) {
        EquipmentSlot slotType = (EquipmentSlot)buffer.m_130066_(EquipmentSlot.class);
        ItemStack stack = inventory.f_35978_.m_6844_(slotType);
        IItemHandler handler = (IItemHandler)stack.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(cap -> cap instanceof IItemHandlerModifiable).orElse(EmptyItemHandler.INSTANCE);
        return new ToolContainerMenu((MenuType)TinkerTools.toolContainer.get(), id, inventory, stack, handler, slotType);
    }

    protected ToolContainerMenu(@Nullable MenuType<?> type, int id, Inventory playerInventory, ItemStack stack, IItemHandler handler, EquipmentSlot slotType) {
        super(type, id);
        int c;
        this.stack = stack;
        this.itemHandler = handler;
        this.player = playerInventory.f_35978_;
        this.slotType = slotType;
        int slots = this.itemHandler.getSlots();
        for (int i = 0; i < slots; ++i) {
            this.m_38897_((Slot)new ToolContainerSlot(this.itemHandler, i, 8 + i % 9 * 18, 18 + i / 9 * 18));
        }
        this.showOffhand = ModifierUtil.checkVolatileFlag(stack, ToolInventoryCapability.INCLUDE_OFFHAND);
        if (this.showOffhand) {
            int x = 8 + slots % 9 * 18;
            int y = 18 + slots / 9 * 18;
            if (slotType == EquipmentSlot.OFFHAND) {
                this.m_38897_(new ReadOnlySlot((Container)playerInventory, 40, x, y));
            } else {
                this.m_38897_(new Slot((Container)playerInventory, 40, x, y));
            }
            ++slots;
        }
        this.playerInventoryStart = this.f_38839_.size();
        int playerY = 32 + 18 * ((slots + 8) / 9);
        for (int r = 0; r < 3; ++r) {
            for (c = 0; c < 9; ++c) {
                this.m_38897_(new Slot((Container)playerInventory, c + r * 9 + 9, 8 + c * 18, playerY + r * 18));
            }
        }
        int hotbarStart = playerY + 58;
        this.selectedHotbarSlot = slotType == EquipmentSlot.MAINHAND ? playerInventory.f_35977_ : (slotType == EquipmentSlot.OFFHAND ? 10 : -1);
        for (c = 0; c < 9; ++c) {
            if (c == this.selectedHotbarSlot) {
                this.m_38897_(new ReadOnlySlot((Container)playerInventory, c, 8 + c * 18, hotbarStart));
                continue;
            }
            this.m_38897_(new Slot((Container)playerInventory, c, 8 + c * 18, hotbarStart));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return this.player == playerIn && !this.stack.m_41619_() && this.player.m_6844_(this.slotType) == this.stack;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        if (this.playerInventoryStart < 0) {
            return ItemStack.f_41583_;
        }
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            result = slotStack.m_41777_();
            int end = this.f_38839_.size();
            if (index < this.playerInventoryStart ? !this.m_38903_(slotStack, this.playerInventoryStart, end, true) : !this.m_38903_(slotStack, 0, this.playerInventoryStart, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return result;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public EquipmentSlot getSlotType() {
        return this.slotType;
    }

    public int getSelectedHotbarSlot() {
        return this.selectedHotbarSlot;
    }

    public boolean isShowOffhand() {
        return this.showOffhand;
    }

    private static class ToolContainerSlot
    extends SmartItemHandlerSlot {
        private final int index;

        public ToolContainerSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
            this.index = index;
        }

        public void m_5852_(@Nonnull ItemStack stack) {
            ((IItemHandlerModifiable)this.getItemHandler()).setStackInSlot(this.index, stack);
        }

        public void m_6654_() {
            this.m_5852_(this.m_7993_());
        }
    }
}

