/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.LlamaSpit;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectContext;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffectManager;
import slimeknights.tconstruct.library.modifiers.fluid.FluidEffects;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.tools.TinkerModifiers;

public class FluidEffectProjectile
extends LlamaSpit {
    private static final EntityDataAccessor<FluidStack> FLUID = SynchedEntityData.m_135353_(FluidEffectProjectile.class, (EntityDataSerializer)TinkerFluids.FLUID_DATA_SERIALIZER);
    private float power = 1.0f;
    private int knockback = 1;

    public FluidEffectProjectile(EntityType<? extends FluidEffectProjectile> type, Level level) {
        super(type, level);
    }

    public FluidEffectProjectile(Level level, LivingEntity owner, FluidStack fluid, float power) {
        this((EntityType<? extends FluidEffectProjectile>)((EntityType)TinkerModifiers.fluidSpitEntity.get()), level);
        this.m_6034_(owner.m_20185_(), owner.m_20188_() - 0.1, owner.m_20189_());
        this.m_5602_((Entity)owner);
        this.setFluid(fluid);
        this.setPower(power);
    }

    public FluidStack getFluid() {
        return (FluidStack)this.f_19804_.m_135370_(FLUID);
    }

    public void setFluid(FluidStack fluid) {
        this.f_19804_.m_135381_(FLUID, (Object)fluid);
    }

    protected void m_5790_(EntityHitResult result) {
        FluidEffects recipe;
        Vec3 vec3;
        Entity target = result.m_82443_();
        if (this.knockback > 0 && (vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.knockback * 0.6)).m_82556_() > 0.0) {
            target.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
        }
        FluidStack fluid = this.getFluid();
        if (!this.f_19853_.f_46443_ && !fluid.isEmpty() && (recipe = FluidEffectManager.INSTANCE.find(fluid.getFluid())).hasEntityEffects()) {
            int consumed = recipe.applyToEntity(fluid, this.power, new FluidEffectContext.Entity(this.f_19853_, ModifierUtil.asLiving(this.m_37282_()), (Projectile)this, target), IFluidHandler.FluidAction.EXECUTE);
            fluid.shrink(consumed);
            if (fluid.isEmpty()) {
                this.m_146870_();
            } else {
                this.setFluid(fluid);
            }
        }
    }

    protected void m_8060_(BlockHitResult hitResult) {
        BlockPos hit = hitResult.m_82425_();
        BlockState state = this.f_19853_.m_8055_(hit);
        state.m_60669_(this.f_19853_, state, hitResult, (Projectile)this);
        FluidStack fluid = this.getFluid();
        if (!this.f_19853_.f_46443_) {
            FluidEffects recipe;
            if (!fluid.isEmpty() && (recipe = FluidEffectManager.INSTANCE.find(fluid.getFluid())).hasEntityEffects()) {
                int consumed;
                FluidEffectContext.Block context = new FluidEffectContext.Block(this.f_19853_, ModifierUtil.asLiving(this.m_37282_()), (Projectile)this, hitResult);
                do {
                    consumed = recipe.applyToBlock(fluid, this.power, context, IFluidHandler.FluidAction.EXECUTE);
                    fluid.shrink(consumed);
                } while (consumed > 0 && !fluid.isEmpty());
                if (!fluid.isEmpty() && this.f_19853_.m_8055_(hit).m_60795_()) {
                    return;
                }
            }
            this.m_146870_();
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLUID, (Object)FluidStack.EMPTY);
    }

    protected void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128350_("power", this.power);
        nbt.m_128405_("knockback", this.knockback);
        FluidStack fluid = this.getFluid();
        if (!fluid.isEmpty()) {
            nbt.m_128365_("fluid", (Tag)fluid.writeToNBT(new CompoundTag()));
        }
    }

    protected void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.power = nbt.m_128457_("power");
        this.knockback = nbt.m_128451_("knockback");
        this.setFluid(FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("fluid")));
    }

    public void setPower(float power) {
        this.power = power;
    }

    public void setKnockback(int knockback) {
        this.knockback = knockback;
    }

    public int getKnockback() {
        return this.knockback;
    }
}

