/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.inventory;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import slimeknights.mantle.recipe.container.ISingleStackContainer;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipe;
import slimeknights.tconstruct.library.recipe.tinkerstation.IMutableTinkerStationContainer;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tables.block.entity.table.TinkerStationBlockEntity;

public class TinkerStationContainerWrapper
implements IMutableTinkerStationContainer {
    private final TinkerStationBlockEntity station;
    private MaterialRecipe[] materials;
    private boolean[] searchedMaterial;
    @Nullable
    private ToolStack tool;
    private MaterialRecipe lastMaterialRecipe;
    @Nullable
    private Player player;

    public TinkerStationContainerWrapper(TinkerStationBlockEntity station) {
        this.station = station;
        int count = station.getInputCount();
        this.materials = new MaterialRecipe[count];
        this.searchedMaterial = new boolean[count];
    }

    @Nullable
    private MaterialRecipe findMaterialRecipe(ItemStack stack) {
        Level world = this.station.m_58904_();
        if (world == null) {
            return null;
        }
        ISingleStackContainer inv = () -> stack;
        if (this.lastMaterialRecipe != null && this.lastMaterialRecipe.matches(inv, world)) {
            return this.lastMaterialRecipe;
        }
        Optional newRecipe = world.m_7465_().m_44015_((RecipeType)TinkerRecipeTypes.MATERIAL.get(), (Container)inv, world);
        if (newRecipe.isPresent()) {
            this.lastMaterialRecipe = (MaterialRecipe)newRecipe.get();
            return this.lastMaterialRecipe;
        }
        return null;
    }

    public void refreshInput(int slot) {
        if (slot == 0) {
            this.tool = null;
        } else if (slot >= 1 && slot < this.station.getInputCount() + 1) {
            this.materials[slot - 1] = null;
            this.searchedMaterial[slot - 1] = false;
        }
    }

    public void resize() {
        int count = this.station.getInputCount();
        if (count != this.materials.length) {
            this.materials = new MaterialRecipe[count];
            this.searchedMaterial = new boolean[count];
        }
    }

    @Override
    public ItemStack getTinkerableStack() {
        return this.station.m_8020_(0);
    }

    @Override
    public ToolStack getTinkerable() {
        if (this.tool == null) {
            this.tool = ToolStack.from(this.getTinkerableStack());
        }
        return this.tool;
    }

    @Override
    public ItemStack getInput(int index) {
        if (index < 0 || index >= this.station.getInputCount()) {
            return ItemStack.f_41583_;
        }
        return this.station.m_8020_(index + 1);
    }

    @Override
    public int getInputCount() {
        return this.station.getInputCount();
    }

    @Override
    @Nullable
    public MaterialRecipe getInputMaterial(int index) {
        if (index < 0 || index >= this.station.getInputCount()) {
            return null;
        }
        if (!this.searchedMaterial[index]) {
            this.materials[index] = this.findMaterialRecipe(this.getInput(index));
            this.searchedMaterial[index] = true;
        }
        return this.materials[index];
    }

    @Override
    public void setInput(int index, ItemStack stack) {
        if (index >= 0 && index < this.station.getInputCount()) {
            this.station.m_6836_(index + 1, stack);
        }
    }

    @Override
    public void giveItem(ItemStack stack) {
        if (this.player != null) {
            this.player.m_150109_().m_150079_(stack);
        }
    }

    public void setPlayer(@Nullable Player player) {
        this.player = player;
    }
}

