/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.data;

import java.util.Locale;
import net.minecraft.world.item.Item;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import slimeknights.mantle.registration.object.FluidObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.smeltery.data.Byproduct;

public enum SmelteryCompat {
    TIN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenTin, Byproduct.COPPER),
    ALUMINUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenAluminum, Byproduct.IRON),
    LEAD((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenLead, Byproduct.SILVER, Byproduct.GOLD),
    SILVER((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenSilver, Byproduct.LEAD, Byproduct.GOLD),
    NICKEL((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenNickel, Byproduct.PLATINUM, Byproduct.IRON),
    ZINC((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenZinc, Byproduct.TIN, Byproduct.COPPER),
    PLATINUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenPlatinum, Byproduct.GOLD),
    TUNGSTEN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenTungsten, Byproduct.PLATINUM, Byproduct.GOLD),
    OSMIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenOsmium, Byproduct.IRON),
    URANIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenUranium, Byproduct.LEAD, Byproduct.COPPER),
    BRONZE((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenBronze, new Byproduct[0]),
    BRASS((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenBrass, new Byproduct[0]),
    ELECTRUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenElectrum, new Byproduct[0]),
    INVAR((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenInvar, new Byproduct[0]),
    CONSTANTAN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenConstantan, new Byproduct[0]),
    PEWTER((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenPewter, new Byproduct[0]),
    STEEL((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenSteel, new Byproduct[0]),
    ENDERIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenEnderium, new Byproduct[0]),
    LUMIUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenLumium, new Byproduct[0]),
    SIGNALUM((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenSignalum, new Byproduct[0]),
    REFINED_GLOWSTONE((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenRefinedGlowstone, false),
    REFINED_OBSIDIAN((FluidObject<? extends ForgeFlowingFluid>)TinkerFluids.moltenRefinedObsidian, false);

    private final String name = this.name().toLowerCase(Locale.US);
    private final FluidObject<? extends ForgeFlowingFluid> fluid;
    private final boolean isOre;
    private final boolean hasDust;
    private final Byproduct[] byproducts;

    private SmelteryCompat(FluidObject<? extends ForgeFlowingFluid> fluid, boolean hasDust) {
        this.fluid = fluid;
        this.isOre = false;
        this.byproducts = new Byproduct[0];
        this.hasDust = hasDust;
    }

    private SmelteryCompat(FluidObject<? extends ForgeFlowingFluid> fluid, Byproduct ... byproducts) {
        this.fluid = fluid;
        this.isOre = byproducts.length > 0;
        this.byproducts = byproducts;
        this.hasDust = true;
    }

    public FluidObject<?> getFluid() {
        return this.fluid;
    }

    public Item getBucket() {
        return this.fluid.m_5456_();
    }

    public String getName() {
        return this.name;
    }

    public boolean isOre() {
        return this.isOre;
    }

    public boolean hasDust() {
        return this.hasDust;
    }

    public Byproduct[] getByproducts() {
        return this.byproducts;
    }
}

