/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.screen.module;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.client.screen.ScalableElementScreen;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.GuiUtil;
import slimeknights.tconstruct.smeltery.block.entity.module.FuelModule;

public class GuiFuelModule {
    private static final ScalableElementScreen FIRE = new ScalableElementScreen(176, 136, 14, 14, 256, 256);
    private static final String TOOLTIP_TEMPERATURE = TConstruct.makeTranslationKey("gui", "melting.fuel.temperature");
    private static final List<Component> TOOLTIP_NO_TANK = Collections.singletonList(Component.m_237115_((String)TConstruct.makeTranslationKey("gui", "melting.fuel.no_tank")));
    private static final List<Component> TOOLTIP_NO_FUEL = Collections.singletonList(Component.m_237115_((String)TConstruct.makeTranslationKey("gui", "melting.fuel.empty")));
    private static final Component TOOLTIP_INVALID_FUEL = Component.m_237115_((String)TConstruct.makeTranslationKey("gui", "melting.fuel.invalid")).m_130940_(ChatFormatting.RED);
    private static final Component TOOLTIP_SOLID_FUEL = Component.m_237115_((String)TConstruct.makeTranslationKey("gui", "melting.fuel.solid"));
    private final AbstractContainerScreen<?> screen;
    private final FuelModule fuelModule;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int fireX;
    private final int fireY;
    private final boolean hasFuelSlot;
    private FuelModule.FuelInfo fuelInfo = FuelModule.FuelInfo.EMPTY;

    private boolean isHovered(int checkX, int checkY) {
        return GuiUtil.isHovered(checkX, checkY, this.x - 1, this.y - 1, this.width + 2, this.height + 2);
    }

    public void draw(PoseStack matrices) {
        int fuel = this.fuelModule.getFuel();
        int fuelQuality = this.fuelModule.getFuelQuality();
        if (fuel > 0 && fuelQuality > 0) {
            FIRE.drawScaledYUp(matrices, this.fireX + this.screen.f_97735_, this.fireY + this.screen.f_97736_, 14 * fuel / fuelQuality);
        }
        if (!this.hasFuelSlot) {
            this.fuelInfo = this.fuelModule.getFuelInfo();
            if (!this.fuelInfo.isEmpty()) {
                GuiUtil.renderFluidTank(matrices, this.screen, this.fuelInfo.getFluid(), this.fuelInfo.getTotalAmount(), this.fuelInfo.getCapacity(), this.x, this.y, this.width, this.height, 100);
            }
        }
    }

    public void renderHighlight(PoseStack matrices, int checkX, int checkY) {
        if (this.isHovered(checkX, checkY)) {
            if (this.hasFuelSlot) {
                if (checkY > this.y + 18) {
                    GuiUtil.renderHighlight(matrices, this.x, this.y + 18, this.width, this.height - 18);
                }
            } else {
                GuiUtil.renderHighlight(matrices, this.x, this.y, this.width, this.height);
            }
        }
    }

    public void addTooltip(PoseStack matrices, int mouseX, int mouseY, boolean hasTank) {
        int checkX = mouseX - this.screen.f_97735_;
        int checkY = mouseY - this.screen.f_97736_;
        if (this.isHovered(checkX, checkY)) {
            List<Object> tooltip;
            if (this.hasFuelSlot || this.fuelInfo.isItem()) {
                int temperature;
                tooltip = !this.hasFuelSlot || checkY > this.y + 18 ? (hasTank ? ((temperature = this.fuelModule.getTemperature()) > 0 ? Arrays.asList(TOOLTIP_SOLID_FUEL, Component.m_237110_((String)TOOLTIP_TEMPERATURE, (Object[])new Object[]{temperature}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC})) : TOOLTIP_NO_FUEL) : TOOLTIP_NO_TANK) : Collections.emptyList();
            } else if (!this.fuelInfo.isEmpty()) {
                FluidStack fluid = this.fuelInfo.getFluid();
                tooltip = FluidTooltipHandler.getFluidTooltip((FluidStack)fluid, (int)this.fuelInfo.getTotalAmount());
                int temperature = this.fuelInfo.getTemperature();
                if (temperature > 0) {
                    tooltip.add(1, (Component)Component.m_237110_((String)TOOLTIP_TEMPERATURE, (Object[])new Object[]{temperature}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                } else {
                    tooltip.add(1, TOOLTIP_INVALID_FUEL);
                }
            } else {
                tooltip = hasTank ? TOOLTIP_NO_FUEL : TOOLTIP_NO_TANK;
            }
            this.screen.m_96597_(matrices, tooltip, mouseX, mouseY);
        }
    }

    @Nullable
    public FluidStack getIngredient(int checkX, int checkY) {
        if (!this.hasFuelSlot && this.isHovered(checkX, checkY) && !this.fuelInfo.isEmpty()) {
            return this.fuelInfo.getFluid();
        }
        return null;
    }

    public GuiFuelModule(AbstractContainerScreen<?> screen, FuelModule fuelModule, int x, int y, int width, int height, int fireX, int fireY, boolean hasFuelSlot) {
        this.screen = screen;
        this.fuelModule = fuelModule;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.fireX = fireX;
        this.fireY = fireY;
        this.hasFuelSlot = hasFuelSlot;
    }
}

