/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.ModelData;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.TinkerRenderTypes;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.entity.controller.HeatingStructureBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.MeltingModuleInventory;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.HeatingStructureMultiblock;
import slimeknights.tconstruct.smeltery.client.render.SmelteryTankRenderer;

public class HeatingStructureBlockEntityRenderer
implements BlockEntityRenderer<HeatingStructureBlockEntity> {
    private static final float ITEM_SCALE = 0.9375f;

    public HeatingStructureBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(HeatingStructureBlockEntity smeltery, float partialTicks, PoseStack matrices, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Level world = smeltery.m_58904_();
        if (world == null) {
            return;
        }
        BlockState state = smeltery.m_58900_();
        HeatingStructureMultiblock.StructureData structure = smeltery.getStructure();
        boolean structureValid = (Boolean)state.m_61143_((Property)ControllerBlock.IN_STRUCTURE) != false && structure != null;
        BlockPos errorPos = smeltery.getErrorPos();
        if (errorPos != null && Minecraft.m_91087_().f_91074_ != null) {
            boolean highlightError = smeltery.isHighlightError();
            if (!structureValid && highlightError || smeltery.showDebugBlockBorder((Player)Minecraft.m_91087_().f_91074_)) {
                int dz;
                BlockPos pos = smeltery.m_58899_();
                BlockPos playerPos = Minecraft.m_91087_().f_91074_.m_20183_();
                int dx = playerPos.m_123341_() - pos.m_123341_();
                if (dx * dx + (dz = playerPos.m_123343_() - pos.m_123343_()) * dz < 512) {
                    VertexConsumer vertexBuilder = buffer.m_6299_((RenderType)(highlightError ? TinkerRenderTypes.ERROR_BLOCK : RenderType.f_110371_));
                    LevelRenderer.m_109782_((PoseStack)matrices, (VertexConsumer)vertexBuilder, (VoxelShape)Shapes.m_83144_(), (double)(errorPos.m_123341_() - pos.m_123341_()), (double)(errorPos.m_123342_() - pos.m_123342_()), (double)(errorPos.m_123343_() - pos.m_123343_()), (float)1.0f, (float)(structureValid ? 1.0f : 0.0f), (float)0.0f, (float)0.5f);
                }
            }
        }
        if (!structureValid) {
            return;
        }
        BlockPos pos = smeltery.m_58899_();
        BlockPos minPos = structure.getMinInside();
        BlockPos maxPos = structure.getMaxInside();
        matrices.m_85836_();
        matrices.m_85837_((double)(minPos.m_123341_() - pos.m_123341_()), (double)(minPos.m_123342_() - pos.m_123342_()), (double)(minPos.m_123343_() - pos.m_123343_()));
        SmelteryTankRenderer.renderFluids(matrices, buffer, smeltery.getTank(), minPos, maxPos, LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)minPos));
        int xd = 1 + maxPos.m_123341_() - minPos.m_123341_();
        int zd = 1 + maxPos.m_123343_() - minPos.m_123343_();
        int layer = xd * zd;
        Direction facing = (Direction)state.m_61143_((Property)ControllerBlock.FACING);
        Quaternion itemRotation = Vector3f.f_122225_.m_122240_(-90.0f * (float)facing.m_122416_());
        MeltingModuleInventory inventory = smeltery.getMeltingInventory();
        Minecraft mc = Minecraft.m_91087_();
        ItemRenderer itemRenderer = mc.m_91291_();
        int max = (Integer)Config.CLIENT.maxSmelteryItemQuads.get();
        if (max != 0) {
            int quadsRendered = 0;
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                int height = i / layer;
                int layerIndex = i % layer;
                int offsetX = layerIndex % xd;
                int offsetZ = layerIndex / xd;
                BlockPos itemPos = minPos.m_7918_(offsetX, height, offsetZ);
                matrices.m_85836_();
                matrices.m_85837_((double)((float)offsetX + 0.5f), (double)((float)height + 0.5f), (double)((float)offsetZ + 0.5f));
                matrices.m_85845_(itemRotation);
                matrices.m_85841_(0.9375f, 0.9375f, 0.9375f);
                BakedModel model = itemRenderer.m_174264_(stack, world, null, 0);
                itemRenderer.m_115143_(stack, ItemTransforms.TransformType.NONE, false, matrices, buffer, LevelRenderer.m_109541_((BlockAndTintGetter)world, (BlockPos)itemPos), OverlayTexture.f_118083_, model);
                matrices.m_85849_();
                if (max == -1) continue;
                if (model.m_7521_()) {
                    quadsRendered += 100;
                } else {
                    RandomSource random = smeltery.m_58904_().m_213780_();
                    for (Direction direction : Direction.values()) {
                        quadsRendered += model.getQuads(null, direction, random, ModelData.EMPTY, null).size();
                    }
                    quadsRendered += model.getQuads(null, null, random, ModelData.EMPTY, null).size();
                }
                if (quadsRendered > max) break;
            }
        }
        matrices.m_85849_();
    }

    public boolean shouldRenderOffScreen(HeatingStructureBlockEntity tile) {
        return (Boolean)tile.m_58900_().m_61143_((Property)ControllerBlock.IN_STRUCTURE) != false && tile.getStructure() != null;
    }
}

