/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.controller;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.controller.ControllerBlock;
import slimeknights.tconstruct.smeltery.block.entity.controller.HeatingStructureBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.module.MeltingModuleInventory;
import slimeknights.tconstruct.smeltery.block.entity.module.alloying.MultiAlloyingModule;
import slimeknights.tconstruct.smeltery.block.entity.module.alloying.SmelteryAlloyTank;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.HeatingStructureMultiblock;
import slimeknights.tconstruct.smeltery.block.entity.multiblock.SmelteryMultiblock;
import slimeknights.tconstruct.smeltery.block.entity.tank.ISmelteryTankHandler;

public class SmelteryBlockEntity
extends HeatingStructureBlockEntity {
    private static final int CAPACITY_PER_BLOCK = 1080;
    private static final int BLOCKS_PER_FUEL = 15;
    private static final Component NAME = TConstruct.makeTranslation("gui", "smeltery");
    private final SmelteryAlloyTank alloyTank;
    private final MultiAlloyingModule alloyingModule;

    public SmelteryBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends HeatingStructureBlockEntity>)((BlockEntityType)TinkerSmeltery.smeltery.get()), pos, state, NAME);
        this.alloyTank = new SmelteryAlloyTank(this.tank);
        this.alloyingModule = new MultiAlloyingModule((MantleBlockEntity)this, this.alloyTank);
    }

    @Override
    protected HeatingStructureMultiblock<?> createMultiblock() {
        return new SmelteryMultiblock(this);
    }

    @Override
    protected MeltingModuleInventory createMeltingInventory() {
        return new MeltingModuleInventory((MantleBlockEntity)this, this.tank, Config.COMMON.smelteryOreRate);
    }

    @Override
    protected boolean isDebugItem(ItemStack stack) {
        return stack.m_204117_(TinkerTags.Items.SMELTERY_DEBUG);
    }

    @Override
    protected void heat() {
        if (this.structure == null || this.f_58857_ == null) {
            return;
        }
        if (this.structure.hasTanks()) {
            boolean entityMelted = false;
            if (this.tick == 12) {
                entityMelted = this.entityModule.interactWithEntities();
            }
            switch (this.tick % 4) {
                case 0: {
                    if (this.fuelModule.hasFuel()) break;
                    if (entityMelted) {
                        this.fuelModule.findFuel(true);
                        break;
                    }
                    int possibleTemp = this.fuelModule.findFuel(false);
                    this.alloyTank.setTemperature(possibleTemp);
                    if (!this.meltingInventory.canHeat(possibleTemp) && !this.alloyingModule.canAlloy()) break;
                    this.fuelModule.findFuel(true);
                    break;
                }
                case 1: {
                    if (this.fuelModule.hasFuel()) {
                        this.meltingInventory.heatItems(this.fuelModule.getTemperature());
                        break;
                    }
                    this.meltingInventory.coolItems();
                    break;
                }
                case 2: {
                    if (!this.fuelModule.hasFuel()) break;
                    this.alloyTank.setTemperature(this.fuelModule.getTemperature());
                    this.alloyingModule.doAlloy();
                    break;
                }
                case 3: {
                    boolean hasFuel = this.fuelModule.hasFuel();
                    BlockState state = this.m_58900_();
                    if ((Boolean)state.m_61143_((Property)ControllerBlock.ACTIVE) != hasFuel) {
                        this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)ControllerBlock.ACTIVE, (Comparable)Boolean.valueOf(hasFuel)));
                    }
                    this.fuelModule.decreaseFuel(this.fuelRate);
                    break;
                }
            }
        }
    }

    @Override
    protected void setStructure(@Nullable HeatingStructureMultiblock.StructureData structure) {
        super.setStructure(structure);
        if (structure != null) {
            int dx = structure.getInnerX();
            int dy = structure.getInnerY();
            int dz = structure.getInnerZ();
            int size = dx * dy * dz;
            this.tank.setCapacity(1080 * size);
            this.meltingInventory.resize(size, this.dropItem);
            this.fuelRate = 1 + (2 * (dx * dy) + 2 * (dy * dz) + dx * dz) / 15;
        }
    }

    @Override
    public void notifyFluidsChanged(ISmelteryTankHandler.FluidChange type, FluidStack fluid) {
        super.notifyFluidsChanged(type, fluid);
        if (type == ISmelteryTankHandler.FluidChange.ADDED) {
            this.alloyingModule.clearCachedRecipes();
        }
    }

    public MultiAlloyingModule getAlloyingModule() {
        return this.alloyingModule;
    }
}

