/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block.entity.component;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import slimeknights.tconstruct.library.client.model.ModelProperties;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.component.SearedTankBlock;
import slimeknights.tconstruct.smeltery.block.entity.ITankBlockEntity;
import slimeknights.tconstruct.smeltery.block.entity.component.SmelteryComponentBlockEntity;
import slimeknights.tconstruct.smeltery.item.TankItem;

public class TankBlockEntity
extends SmelteryComponentBlockEntity
implements ITankBlockEntity {
    public static final int DEFAULT_CAPACITY = 4000;
    protected final FluidTankAnimated tank;
    private final LazyOptional<IFluidHandler> holder;
    private int lastStrength;

    public static int getCapacity(Block block) {
        if (block instanceof ITankBlock) {
            return ((ITankBlock)block).getCapacity();
        }
        return 4000;
    }

    public static int getCapacity(Item item) {
        if (item instanceof BlockItem) {
            return TankBlockEntity.getCapacity(((BlockItem)item).m_40614_());
        }
        return 4000;
    }

    public TankBlockEntity(BlockPos pos, BlockState state) {
        ITankBlock tank;
        Block block = state.m_60734_();
        this(pos, state, block instanceof ITankBlock ? (tank = (ITankBlock)block) : (ITankBlock)TinkerSmeltery.searedTank.get((Enum)SearedTankBlock.TankType.FUEL_TANK));
    }

    public TankBlockEntity(BlockPos pos, BlockState state, ITankBlock block) {
        this((BlockEntityType)TinkerSmeltery.tank.get(), pos, state, block);
    }

    protected TankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, ITankBlock block) {
        super(type, pos, state);
        this.lastStrength = -1;
        this.tank = new FluidTankAnimated(block.getCapacity(), this);
        this.holder = LazyOptional.of(() -> this.tank);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.holder.invalidate();
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(ModelProperties.FLUID_TANK, (Object)this.tank).build();
    }

    @Override
    public void onTankContentsChanged() {
        ITankBlockEntity.super.onTankContentsChanged();
        if (this.f_58857_ != null) {
            this.f_58857_.m_5518_().m_7174_(this.f_58858_);
            this.requestModelDataUpdate();
        }
    }

    @Override
    public void updateFluidTo(FluidStack fluid) {
        ITankBlockEntity.super.updateFluidTo(fluid);
        if (this.f_58857_ != null) {
            this.f_58857_.m_5518_().m_7174_(this.f_58858_);
        }
    }

    public void setTankTag(ItemStack stack) {
        TankItem.setTank(stack, this.tank);
    }

    public void updateTank(CompoundTag nbt) {
        if (nbt.m_128456_()) {
            this.tank.setFluid(FluidStack.EMPTY);
        } else {
            this.tank.readFromNBT(nbt);
            if (this.f_58857_ != null) {
                this.f_58857_.m_5518_().m_7174_(this.f_58858_);
            }
        }
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.tank.setCapacity(TankBlockEntity.getCapacity(this.m_58900_().m_60734_()));
        this.updateTank(tag.m_128469_("tank"));
        super.m_142466_(tag);
    }

    public void saveSynced(CompoundTag tag) {
        super.saveSynced(tag);
        if (!this.tank.isEmpty()) {
            tag.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        }
    }

    @Override
    public FluidTankAnimated getTank() {
        return this.tank;
    }

    @Override
    public int getLastStrength() {
        return this.lastStrength;
    }

    @Override
    public void setLastStrength(int lastStrength) {
        this.lastStrength = lastStrength;
    }

    public static interface ITankBlock {
        public int getCapacity();
    }
}

