/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jsonthings.item;

import dev.gigaherz.jsonthings.things.IFlexItem;
import dev.gigaherz.jsonthings.things.StackContext;
import dev.gigaherz.jsonthings.things.events.FlexEventHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.item.ModifiableArmorItem;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.client.TravelersGearModel;

public class FlexBasicArmorItem
extends ModifiableArmorItem
implements IFlexItem {
    private final Map<String, FlexEventHandler> eventHandlers = new HashMap<String, FlexEventHandler>();
    private final Set<CreativeModeTab> tabs = new HashSet<CreativeModeTab>();
    private final ResourceLocation name;
    private final boolean dyeable;
    @Nullable
    private final String golden;

    public FlexBasicArmorItem(ArmorMaterial materialIn, EquipmentSlot slot, Item.Properties builderIn, ToolDefinition toolDefinition, ResourceLocation name, boolean dyeable, boolean hasGolden) {
        super(materialIn, slot, builderIn, toolDefinition);
        this.name = name;
        this.dyeable = dyeable;
        this.golden = hasGolden ? name.m_135827_() + ":textures/models/armor/" + name.m_135815_() + "_golden_" + (slot == EquipmentSlot.LEGS ? 2 : 1) + ".png" : null;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (this.golden != null && ModifierUtil.getModifierLevel(stack, TinkerModifiers.golden.getId()) > 0) {
            return this.golden;
        }
        return null;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @Nonnull
            public Model getGenericArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (FlexBasicArmorItem.this.dyeable) {
                    return TravelersGearModel.getModel(itemStack, equipmentSlot, original, FlexBasicArmorItem.this.name, true);
                }
                return original;
            }
        });
    }

    public void addCreativeStack(StackContext stackContext, Iterable<CreativeModeTab> tabs) {
        for (CreativeModeTab tab : tabs) {
            this.tabs.add(tab);
        }
    }

    protected boolean m_220152_(CreativeModeTab category) {
        return this.tabs.contains(category);
    }

    public void addEventHandler(String name, FlexEventHandler flexEventHandler) {
        this.eventHandlers.put(name, flexEventHandler);
    }

    @Nullable
    public FlexEventHandler getEventHandler(String name) {
        return this.eventHandlers.get(name);
    }
}

