/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jsonthings;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.serializers.FlexItemType;
import dev.gigaherz.jsonthings.things.serializers.IItemSerializer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.definition.IToolStatProvider;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolStatProviders;
import slimeknights.tconstruct.plugin.jsonthings.item.DummyArmorMaterial;
import slimeknights.tconstruct.plugin.jsonthings.item.FlexBasicArmorItem;
import slimeknights.tconstruct.plugin.jsonthings.item.FlexFlatEmbellishedArmor;
import slimeknights.tconstruct.plugin.jsonthings.item.FlexLayeredEmbellishedArmor;
import slimeknights.tconstruct.plugin.jsonthings.item.FlexModifiableBowItem;
import slimeknights.tconstruct.plugin.jsonthings.item.FlexModifiableCrossbowItem;
import slimeknights.tconstruct.plugin.jsonthings.item.FlexModifiableItem;
import slimeknights.tconstruct.plugin.jsonthings.item.FlexModifiableStaffItem;
import slimeknights.tconstruct.plugin.jsonthings.item.FlexRepairKitItem;
import slimeknights.tconstruct.plugin.jsonthings.item.FlexToolPartItem;
import slimeknights.tconstruct.tools.item.ArmorSlotType;

public class FlexItemTypes {
    static final List<Item> TOOL_ITEMS = new ArrayList<Item>();
    static final List<Item> CROSSBOW_ITEMS = new ArrayList<Item>();

    private static <T> T add(List<? super T> list, T item) {
        list.add(item);
        return item;
    }

    public static void init() {
        FlexItemTypes.register("tool_part", data -> {
            MaterialStatsId statType = new MaterialStatsId(JsonHelper.getResourceLocation((JsonObject)data, (String)"stat_type"));
            return (props, builder) -> new FlexToolPartItem(props, statType);
        });
        FlexItemTypes.register("repair_kit", data -> {
            float repairAmount = GsonHelper.m_13915_((JsonObject)data, (String)"repair_amount");
            return (props, builder) -> new FlexRepairKitItem(props, repairAmount);
        });
        FlexItemTypes.register("tool", data -> {
            IToolStatProvider statProvider = (IToolStatProvider)ToolStatProviders.REGISTRY.getIfPresent(data, "stat_provider");
            boolean breakBlocksInCreative = GsonHelper.m_13855_((JsonObject)data, (String)"break_blocks_in_creative", (boolean)true);
            return (props, builder) -> FlexItemTypes.add(TOOL_ITEMS, new FlexModifiableItem(props, ToolDefinition.builder(builder.getRegistryName()).setStatsProvider(statProvider).build(), breakBlocksInCreative));
        });
        FlexItemTypes.register("staff", data -> {
            IToolStatProvider statProvider = (IToolStatProvider)ToolStatProviders.REGISTRY.getIfPresent(data, "stat_provider");
            boolean breakBlocksInCreative = GsonHelper.m_13855_((JsonObject)data, (String)"break_blocks_in_creative", (boolean)true);
            return (props, builder) -> FlexItemTypes.add(TOOL_ITEMS, new FlexModifiableStaffItem(props, ToolDefinition.builder(builder.getRegistryName()).setStatsProvider(statProvider).build(), breakBlocksInCreative));
        });
        FlexItemTypes.register("bow", data -> {
            IToolStatProvider statProvider = data.has("stat_provider") ? (IToolStatProvider)ToolStatProviders.REGISTRY.getIfPresent(data, "stat_provider") : ToolStatProviders.RANGED;
            return (props, builder) -> FlexItemTypes.add(TOOL_ITEMS, new FlexModifiableBowItem(props, ToolDefinition.builder(builder.getRegistryName()).setStatsProvider(statProvider).build()));
        });
        FlexItemTypes.register("crossbow", data -> {
            IToolStatProvider statProvider = data.has("stat_provider") ? (IToolStatProvider)ToolStatProviders.REGISTRY.getIfPresent(data, "stat_provider") : ToolStatProviders.RANGED;
            boolean allowFireworks = GsonHelper.m_13912_((JsonObject)data, (String)"allow_fireworks");
            return (props, builder) -> FlexItemTypes.add(CROSSBOW_ITEMS, new FlexModifiableCrossbowItem(props, ToolDefinition.builder(builder.getRegistryName()).setStatsProvider(statProvider).build(), allowFireworks));
        });
        FlexItemTypes.register("basic_armor", data -> {
            ResourceLocation name = JsonHelper.getResourceLocation((JsonObject)data, (String)"texture_name");
            boolean dyeable = GsonHelper.m_13855_((JsonObject)data, (String)"dyeable", (boolean)false);
            boolean hasGolden = GsonHelper.m_13855_((JsonObject)data, (String)"has_golden", (boolean)true);
            ArmorSlotType slot = (ArmorSlotType)JsonHelper.getAsEnum((JsonObject)data, (String)"slot", ArmorSlotType.class);
            SoundEvent equipSound = (SoundEvent)JsonHelper.getAsEntry((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (JsonObject)data, (String)"equip_sound");
            IToolStatProvider statProvider = data.has("stat_provider") ? (IToolStatProvider)ToolStatProviders.REGISTRY.getIfPresent(data, "stat_provider") : ToolStatProviders.NO_PARTS;
            return (props, builder) -> new FlexBasicArmorItem(new DummyArmorMaterial(name, equipSound), slot.getEquipmentSlot(), props, ToolDefinition.builder(builder.getRegistryName()).setStatsProvider(statProvider).build(), name, dyeable, hasGolden);
        });
        FlexItemTypes.register("layered_embellished_armor", data -> {
            ResourceLocation name = JsonHelper.getResourceLocation((JsonObject)data, (String)"texture_name");
            ArmorSlotType slot = (ArmorSlotType)JsonHelper.getAsEnum((JsonObject)data, (String)"slot", ArmorSlotType.class);
            SoundEvent equipSound = (SoundEvent)JsonHelper.getAsEntry((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (JsonObject)data, (String)"equip_sound");
            IToolStatProvider statProvider = data.has("stat_provider") ? (IToolStatProvider)ToolStatProviders.REGISTRY.getIfPresent(data, "stat_provider") : ToolStatProviders.NO_PARTS;
            return (props, builder) -> new FlexLayeredEmbellishedArmor(new DummyArmorMaterial(name, equipSound), slot.getEquipmentSlot(), props, ToolDefinition.builder(builder.getRegistryName()).setStatsProvider(statProvider).build(), name);
        });
        FlexItemTypes.register("flat_embellished_armor", data -> {
            ResourceLocation name = JsonHelper.getResourceLocation((JsonObject)data, (String)"texture_name");
            MaterialId defaultMaterial = new MaterialId(JsonHelper.getResourceLocation((JsonObject)data, (String)"default_material"));
            boolean dyeable = GsonHelper.m_13855_((JsonObject)data, (String)"dyeable", (boolean)false);
            ArmorSlotType slot = (ArmorSlotType)JsonHelper.getAsEnum((JsonObject)data, (String)"slot", ArmorSlotType.class);
            SoundEvent equipSound = (SoundEvent)JsonHelper.getAsEntry((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (JsonObject)data, (String)"equip_sound");
            IToolStatProvider statProvider = data.has("stat_provider") ? (IToolStatProvider)ToolStatProviders.REGISTRY.getIfPresent(data, "stat_provider") : ToolStatProviders.NO_PARTS;
            return (props, builder) -> new FlexFlatEmbellishedArmor(new DummyArmorMaterial(name, equipSound), slot.getEquipmentSlot(), props, ToolDefinition.builder(builder.getRegistryName()).setStatsProvider(statProvider).build(), name, defaultMaterial, dyeable);
        });
    }

    private static <T extends Item> void register(String name, IItemSerializer<T> factory) {
        FlexItemType.register((String)TConstruct.resourceString(name), factory);
    }
}

