/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.jei.melting;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.melting.MeltingRecipe;
import slimeknights.tconstruct.plugin.jei.AlloyRecipeCategory;
import slimeknights.tconstruct.plugin.jei.TConstructJEIConstants;
import slimeknights.tconstruct.plugin.jei.melting.AbstractMeltingCategory;
import slimeknights.tconstruct.plugin.jei.melting.MeltingFuelHandler;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class FoundryCategory
extends AbstractMeltingCategory {
    private static final Component TITLE = TConstruct.makeTranslation("jei", "foundry.title");
    private final IDrawable icon;

    public FoundryCategory(IGuiHelper helper) {
        super(helper);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(TinkerSmeltery.foundryController));
    }

    public RecipeType<MeltingRecipe> getRecipeType() {
        return TConstructJEIConstants.FOUNDRY;
    }

    public Component getTitle() {
        return TITLE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MeltingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 24, 18).addIngredients(recipe.getInput());
        AlloyRecipeCategory.drawVariableFluids(builder, RecipeIngredientRole.OUTPUT, 96, 4, 32, 32, recipe.getOutputWithByproducts(), 810, AbstractMeltingCategory.MeltingFluidCallback.INSTANCE);
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 4, 4).addTooltipCallback((IRecipeSlotTooltipCallback)FUEL_TOOLTIP).setFluidRenderer(1L, false, 12, 32).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, MeltingFuelHandler.getUsableFuels(recipe.getTemperature()));
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

