/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.stat;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraftforge.common.TierSortingRegistry;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.RegistryHelper;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.library.utils.HarvestTiers;
import slimeknights.tconstruct.library.utils.Util;

public class ToolTierStat
implements IToolStat<Tier> {
    private final ToolStatId name;

    @Override
    public boolean supports(Item item) {
        return RegistryHelper.contains(TinkerTags.Items.HARVEST, (Item)item);
    }

    @Override
    public Tier getDefaultValue() {
        return HarvestTiers.minTier();
    }

    @Override
    public Object makeBuilder() {
        return new TierBuilder(this.getDefaultValue());
    }

    @Override
    public Tier build(Object builder, Tier value) {
        return HarvestTiers.max(((TierBuilder)builder).value, value);
    }

    @Override
    public void update(ModifierStatsBuilder builder, Tier value) {
        builder.updateStat(this, b -> {
            b.value = HarvestTiers.max(b.value, value);
        });
    }

    @Override
    @Nullable
    public Tier read(Tag tag) {
        ResourceLocation tierId;
        if (tag.m_7060_() == 8 && (tierId = ResourceLocation.m_135820_((String)tag.m_7916_())) != null) {
            return TierSortingRegistry.byName((ResourceLocation)tierId);
        }
        return null;
    }

    @Override
    public Tag write(Tier value) {
        ResourceLocation id = TierSortingRegistry.getName((Tier)value);
        if (id != null) {
            return StringTag.m_129297_((String)id.toString());
        }
        return null;
    }

    @Override
    public Tier deserialize(JsonElement json) {
        ResourceLocation id = JsonHelper.convertToResourceLocation((JsonElement)json, (String)this.getName().toString());
        Tier tier = TierSortingRegistry.byName((ResourceLocation)id);
        if (tier != null) {
            return tier;
        }
        throw new JsonSyntaxException("Unknown tool tier " + id);
    }

    @Override
    public JsonElement serialize(Tier value) {
        return new JsonPrimitive(Objects.requireNonNull(TierSortingRegistry.getName((Tier)value)).toString());
    }

    @Override
    public Tier fromNetwork(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.m_130281_();
        Tier tier = TierSortingRegistry.byName((ResourceLocation)id);
        if (tier != null) {
            return tier;
        }
        throw new DecoderException("Unknown tool tier " + id);
    }

    @Override
    public void toNetwork(FriendlyByteBuf buffer, Tier value) {
        buffer.m_130085_(Objects.requireNonNull(TierSortingRegistry.getName((Tier)value)));
    }

    @Override
    public Component formatValue(Tier value) {
        return Component.m_237115_((String)Util.makeTranslationKey("tool_stat", this.getName())).m_7220_(HarvestTiers.getName(value));
    }

    public String toString() {
        return "ToolTierStat{" + this.name + "}";
    }

    @Override
    public ToolStatId getName() {
        return this.name;
    }

    public ToolTierStat(ToolStatId name) {
        this.name = name;
    }

    private static class TierBuilder {
        private Tier value;

        public TierBuilder(Tier value) {
            this.value = value;
        }
    }
}

