/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.nbt;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierTraitHook;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.helper.ToolBuildHandler;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.MultiplierNBT;
import slimeknights.tconstruct.library.tools.nbt.StatsNBT;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.RestrictedCompoundTag;

public class ToolStack
implements IToolStackView {
    private static final String KEY_VALIDATE_SLOTS = TConstruct.makeTranslationKey("recipe", "modifier.validate_slots");
    public static final String TAG_MATERIALS = "tic_materials";
    public static final String TAG_PERSISTENT_MOD_DATA = "tic_persistent";
    public static final String TAG_UPGRADES = "tic_upgrades";
    public static final String TAG_BROKEN = "tic_broken";
    protected static final String TAG_STATS = "tic_stats";
    protected static final String TAG_MULTIPLIERS = "tic_multipliers";
    public static final String TAG_VOLATILE_MOD_DATA = "tic_volatile_data";
    public static final String TAG_MODIFIERS = "tic_modifiers";
    protected static final String TAG_DAMAGE = "Damage";
    private static final String TAG_UNBREAKABLE = "Unbreakable";
    private static final String TAG_HIDE_FLAGS = "HideFlags";
    private static final Set<String> RESTRICTED_TAGS = ImmutableSet.of((Object)"tic_materials", (Object)"tic_stats", (Object)"tic_multipliers", (Object)"tic_persistent", (Object)"tic_volatile_data", (Object)"tic_upgrades", (Object[])new String[]{"tic_modifiers", "tic_broken", "Damage", "HideFlags"});
    private final Item item;
    private final ToolDefinition definition;
    private final CompoundTag nbt;
    private RestrictedCompoundTag restrictedNBT;
    private int damage = -1;
    @Nullable
    private Boolean broken;
    @Nullable
    private MaterialNBT materials;
    @Nullable
    private ModifierNBT upgrades;
    @Nullable
    private ModDataNBT persistentModData;
    @Nullable
    private ModifierNBT modifiers;
    @Nullable
    private StatsNBT stats;
    @Nullable
    private MultiplierNBT multipliers;
    @Nullable
    private IModDataView volatileModData;

    private static ToolStack from(ItemStack stack, boolean copyNbt) {
        ToolDefinition toolDefinition;
        Item item = stack.m_41720_();
        if (item instanceof IModifiable) {
            IModifiable mod = (IModifiable)item;
            toolDefinition = mod.getToolDefinition();
        } else {
            toolDefinition = ToolDefinition.EMPTY;
        }
        ToolDefinition definition = toolDefinition;
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
            if (!copyNbt) {
                if (definition != ToolDefinition.EMPTY) {
                    stack.f_41590_ = nbt;
                } else {
                    switch ((Config.Common.LogInvalidToolStack)((Object)Config.COMMON.logInvalidToolStack.get())) {
                        case STACKTRACE: {
                            TConstruct.LOG.warn("Tool stack constructed using non-modifiable tool, this may cause issues as it has no NBT. Stacktrace can be disabled in config.", (Throwable)new Exception("Stack trace"));
                            break;
                        }
                        case WARNING: {
                            TConstruct.LOG.warn("Tool stack constructed using non-modifiable tool, this may cause issues as it has no NBT. To debug this issue or disable the warning, use logInvalidToolStack in the config.");
                        }
                    }
                }
            }
        } else if (copyNbt) {
            nbt = nbt.m_6426_();
        }
        return ToolStack.from(item, definition, nbt);
    }

    public static ToolStack from(ItemStack stack) {
        return ToolStack.from(stack, false);
    }

    public static ToolStack copyFrom(ItemStack stack) {
        return ToolStack.from(stack, true);
    }

    public static ToolStack createTool(Item item, ToolDefinition definition, MaterialNBT materials) {
        ToolStack tool = ToolStack.from(item, definition, new CompoundTag());
        tool.damage = 0;
        tool.broken = false;
        tool.upgrades = ModifierNBT.EMPTY;
        tool.setMaterials(materials);
        return tool;
    }

    public ToolStack copy() {
        ToolStack tool = ToolStack.from(this.item, this.definition, this.nbt.m_6426_());
        tool.damage = this.damage;
        tool.broken = this.broken;
        tool.materials = this.materials;
        tool.upgrades = this.upgrades;
        tool.modifiers = this.modifiers;
        tool.stats = this.stats;
        return tool;
    }

    public void clearCache() {
        this.damage = -1;
        this.broken = null;
        this.materials = null;
        this.upgrades = null;
        this.modifiers = null;
        this.stats = null;
        this.multipliers = null;
        this.volatileModData = null;
        this.persistentModData = null;
    }

    public ItemStack createStack(int size) {
        ItemStack stack = new ItemStack((ItemLike)this.item, size);
        stack.m_41751_(this.nbt);
        return stack;
    }

    public ItemStack createStack() {
        return this.createStack(1);
    }

    public ItemStack updateStack(ItemStack stack) {
        if (stack.m_41720_() != this.item) {
            throw new IllegalArgumentException("Wrong item in stack");
        }
        stack.m_41751_(this.nbt.m_6426_());
        return stack;
    }

    public RestrictedCompoundTag getRestrictedNBT() {
        if (this.restrictedNBT == null) {
            this.restrictedNBT = new RestrictedCompoundTag(this.nbt, RESTRICTED_TAGS);
        }
        return this.restrictedNBT;
    }

    @Override
    public boolean isBroken() {
        if (this.broken == null) {
            this.broken = this.nbt.m_128471_(TAG_BROKEN);
        }
        return this.broken;
    }

    @Override
    public boolean isUnbreakable() {
        return this.nbt.m_128471_(TAG_UNBREAKABLE);
    }

    protected void setBrokenRaw(boolean broken) {
        this.broken = broken;
        this.nbt.m_128379_(TAG_BROKEN, broken);
    }

    protected void breakTool() {
        this.setDamage(this.getStats().getInt(ToolStats.DURABILITY));
    }

    protected int getDamageRaw() {
        if (this.damage == -1) {
            this.damage = this.nbt.m_128451_(TAG_DAMAGE);
        }
        return this.damage;
    }

    @Override
    public int getDamage() {
        int durability = this.getStats().getInt(ToolStats.DURABILITY);
        if (this.isBroken()) {
            return durability;
        }
        return Math.min(this.getDamageRaw(), durability - 1);
    }

    @Override
    public int getCurrentDurability() {
        if (this.isBroken()) {
            return 0;
        }
        return Math.max(0, this.getStats().getInt(ToolStats.DURABILITY) - this.getDamageRaw());
    }

    @Override
    public void setDamage(int damage) {
        int durability = this.getStats().getInt(ToolStats.DURABILITY);
        if (damage >= durability) {
            damage = Math.max(0, durability);
            this.setBrokenRaw(true);
        } else {
            this.setBrokenRaw(false);
        }
        this.damage = damage;
        this.nbt.m_128405_(TAG_DAMAGE, damage);
    }

    @Override
    public StatsNBT getStats() {
        if (this.stats == null) {
            this.stats = StatsNBT.readFromNBT(this.nbt.m_128423_(TAG_STATS));
        }
        return this.stats;
    }

    protected void setStats(StatsNBT stats) {
        this.stats = stats;
        this.nbt.m_128365_(TAG_STATS, (Tag)stats.serializeToNBT());
        int newMax = this.getStats().getInt(ToolStats.DURABILITY);
        if (this.getDamageRaw() >= newMax) {
            this.setDamage(newMax);
        }
    }

    protected MultiplierNBT getMultipliers() {
        if (this.multipliers == null) {
            this.multipliers = MultiplierNBT.readFromNBT(this.nbt.m_128423_(TAG_MULTIPLIERS));
        }
        return this.multipliers;
    }

    protected void setMultipliers(MultiplierNBT multipliers) {
        if (multipliers.getContainedStats().isEmpty()) {
            this.multipliers = MultiplierNBT.EMPTY;
            this.nbt.m_128473_(TAG_MULTIPLIERS);
        } else {
            this.multipliers = multipliers;
            this.nbt.m_128365_(TAG_MULTIPLIERS, (Tag)multipliers.serializeToNBT());
        }
    }

    @Override
    public float getMultiplier(INumericToolStat<?> stat) {
        MultiplierNBT multipliers = this.getMultipliers();
        if (multipliers.hasStat(stat)) {
            return multipliers.get(stat);
        }
        return 1.0f;
    }

    @Override
    public MaterialNBT getMaterials() {
        if (!this.getDefinition().isMultipart()) {
            return MaterialNBT.EMPTY;
        }
        if (this.materials == null) {
            this.materials = MaterialNBT.readFromNBT(this.nbt.m_128423_(TAG_MATERIALS));
        }
        return this.materials;
    }

    protected void setMaterialsRaw(MaterialNBT materials) {
        this.materials = materials;
        if (materials == MaterialNBT.EMPTY) {
            this.nbt.m_128473_(TAG_MATERIALS);
        } else {
            this.nbt.m_128365_(TAG_MATERIALS, (Tag)materials.serializeToNBT());
        }
    }

    public void setMaterials(MaterialNBT materials) {
        this.setMaterialsRaw(materials);
        this.rebuildStats();
    }

    public void replaceMaterial(int index, MaterialVariantId replacement) {
        this.setMaterials(this.getMaterials().replaceMaterial(index, replacement));
    }

    @Override
    public ModifierNBT getUpgrades() {
        if (this.upgrades == null) {
            this.upgrades = ModifierNBT.readFromNBT(this.nbt.m_128423_(TAG_UPGRADES));
        }
        return this.upgrades;
    }

    public void setUpgrades(ModifierNBT modifiers) {
        this.upgrades = modifiers;
        this.nbt.m_128365_(TAG_UPGRADES, (Tag)modifiers.serializeToNBT());
        this.rebuildStats();
    }

    public void addModifier(ModifierId modifier, int level) {
        if (level <= 0) {
            throw new IllegalArgumentException("Invalid level, must be above 0");
        }
        this.setUpgrades(this.getUpgrades().withModifier(modifier, level));
    }

    public void addModifierAmount(ModifierId modifier, int amount, int needed) {
        if (needed <= 0) {
            throw new IllegalArgumentException("Invalid needed, must be above 0");
        }
        if (amount > 0) {
            this.setUpgrades(this.getUpgrades().addAmount(modifier, amount, needed));
        }
    }

    public void removeModifier(ModifierId modifier, int level) {
        ModifierNBT newModifiers;
        if (level <= 0) {
            throw new IllegalArgumentException("Invalid level, must be above 0");
        }
        this.upgrades = newModifiers = this.getUpgrades().withoutModifier(modifier, level);
        this.nbt.m_128365_(TAG_UPGRADES, (Tag)newModifiers.serializeToNBT());
        this.rebuildStats();
    }

    @Override
    public ModifierNBT getModifiers() {
        if (this.modifiers == null) {
            this.modifiers = ModifierNBT.readFromNBT(this.nbt.m_128423_(TAG_MODIFIERS));
        }
        return this.modifiers;
    }

    protected void setModifiers(ModifierNBT modifiers) {
        this.modifiers = modifiers;
        this.nbt.m_128365_(TAG_MODIFIERS, (Tag)this.modifiers.serializeToNBT());
    }

    @Override
    public ModDataNBT getPersistentData() {
        if (this.persistentModData == null) {
            if (this.nbt.m_128425_(TAG_PERSISTENT_MOD_DATA, 10)) {
                this.persistentModData = ModDataNBT.readFromNBT(this.nbt.m_128469_(TAG_PERSISTENT_MOD_DATA));
            } else {
                CompoundTag tag = new CompoundTag();
                this.nbt.m_128365_(TAG_PERSISTENT_MOD_DATA, (Tag)tag);
                this.persistentModData = ModDataNBT.readFromNBT(tag);
            }
        }
        return this.persistentModData;
    }

    @Override
    public IModDataView getVolatileData() {
        if (this.volatileModData == null) {
            this.volatileModData = this.nbt.m_128425_(TAG_VOLATILE_MOD_DATA, 10) ? ModDataNBT.readFromNBT(this.nbt.m_128469_(TAG_VOLATILE_MOD_DATA)) : IModDataView.EMPTY;
        }
        return this.volatileModData;
    }

    protected void setVolatileModData(ModDataNBT modData) {
        CompoundTag data = modData.getData();
        if (data.m_128456_()) {
            this.volatileModData = IModDataView.EMPTY;
            this.nbt.m_128473_(TAG_VOLATILE_MOD_DATA);
        } else {
            this.volatileModData = modData;
            this.nbt.m_128365_(TAG_VOLATILE_MOD_DATA, (Tag)data);
        }
    }

    @Nullable
    public Component tryValidate() {
        for (SlotType slotType : SlotType.getAllSlotTypes()) {
            if (this.getFreeSlots(slotType) >= 0) continue;
            return Component.m_237110_((String)KEY_VALIDATE_SLOTS, (Object[])new Object[]{slotType.getDisplayName()});
        }
        for (ModifierEntry entry : this.getModifierList()) {
            Component result = entry.getHook(TinkerHooks.VALIDATE).validate(this, entry);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void ensureHasData() {
        if (this.definition.isDataLoaded() && !ToolStack.isInitialized(this.nbt)) {
            if (this.definition.isMultipart() && !this.nbt.m_128425_(TAG_MATERIALS, 9)) {
                this.setMaterialsRaw(ToolBuildHandler.randomMaterials(this.definition.getData(), this.definition.getDefaultMaxTier(), false));
            }
            this.rebuildStats();
        }
    }

    public void rebuildStats() {
        ToolDefinitionData toolData = this.getDefinitionData();
        ModDataNBT volatileData = new ModDataNBT();
        toolData.buildSlots(volatileData);
        ModDataNBT persistentData = this.getPersistentData();
        MaterialNBT materials = this.getMaterials();
        StatsNBT stats = this.definition.buildStats(materials);
        ModifierStatsBuilder statBuilder = ModifierStatsBuilder.builder();
        toolData.buildStatMultipliers(statBuilder);
        ModifierNBT.Builder modBuilder = ModifierNBT.builder();
        modBuilder.add(this.getUpgrades());
        modBuilder.add(toolData.getTraits());
        List<PartRequirement> parts = this.getDefinition().getData().getParts();
        int max = Math.min(materials.size(), parts.size());
        IMaterialRegistry materialRegistry = MaterialRegistry.getInstance();
        for (int i = 0; i < max; ++i) {
            modBuilder.add(materialRegistry.getTraits(materials.get(i).getId(), parts.get(i).getStatType()));
        }
        ModifierNBT beforeTraits = modBuilder.build();
        List<Object> modifierList = Collections.emptyList();
        if (beforeTraits.isEmpty()) {
            this.nbt.m_128473_(TAG_VOLATILE_MOD_DATA);
            this.setModifiers(ModifierNBT.EMPTY);
        } else {
            ToolRebuildContext context = new ToolRebuildContext(this.item, this.getDefinition(), this.getMaterials(), this.getUpgrades(), beforeTraits, stats, persistentData, volatileData);
            modBuilder = ModifierNBT.builder();
            ModifierTraitHook.TraitBuilder traitBuilder = new ModifierTraitHook.TraitBuilder(context, modBuilder);
            for (ModifierEntry entry : beforeTraits.getModifiers()) {
                traitBuilder.addEntry(entry);
            }
            ModifierNBT allMods = modBuilder.build();
            this.setModifiers(allMods);
            modifierList = allMods.getModifiers();
            context = context.withModifiers(allMods);
            for (ModifierEntry modifierEntry : modifierList) {
                modifierEntry.getHook(TinkerHooks.VOLATILE_DATA).addVolatileData(context, modifierEntry, volatileData);
            }
            for (ModifierEntry modifierEntry : modifierList) {
                modifierEntry.getHook(TinkerHooks.TOOL_STATS).addToolStats(context, modifierEntry, statBuilder);
            }
        }
        this.setVolatileModData(volatileData);
        this.setStats(statBuilder.build(stats, this.item));
        this.setMultipliers(statBuilder.buildMultipliers(this.item));
        for (ModifierEntry modifierEntry : modifierList) {
            modifierEntry.getHook(TinkerHooks.RAW_DATA).addRawData(this, modifierEntry, this.getRestrictedNBT());
        }
    }

    public static boolean isInitialized(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && ToolStack.isInitialized(tag);
    }

    public static boolean isInitialized(CompoundTag tag) {
        return tag.m_128425_(TAG_STATS, 10);
    }

    public static boolean hasMaterials(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        return nbt != null && nbt.m_128425_(TAG_MATERIALS, 9);
    }

    public static void ensureInitialized(ItemStack stack) {
        if (stack.m_41720_() instanceof IModifiable) {
            ToolStack.ensureInitialized(stack, ((IModifiable)stack.m_41720_()).getToolDefinition());
        }
    }

    public static void ensureInitialized(ItemStack stack, ToolDefinition toolDefinition) {
        if (!toolDefinition.isDataLoaded()) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag != null && ToolStack.isInitialized(tag)) {
            return;
        }
        ToolStack.from(stack).ensureHasData();
    }

    public static void verifyTag(Item item, CompoundTag tag, ToolDefinition definition) {
        MaterialIdNBT stored;
        MaterialIdNBT resolved;
        if (!definition.isDataLoaded() || tag.m_128471_("tic_display")) {
            return;
        }
        boolean hasMaterials = tag.m_128425_(TAG_MATERIALS, 9);
        if (hasMaterials && (resolved = (stored = MaterialIdNBT.readFromNBT((Tag)tag.m_128437_(TAG_MATERIALS, 8))).resolveRedirects()) != stored) {
            resolved.updateNBT(tag);
        }
        ToolStack tool = ToolStack.from(item, definition, tag);
        if (hasMaterials || !definition.isMultipart()) {
            tool.rebuildStats();
        }
    }

    private ToolStack(Item item, ToolDefinition definition, CompoundTag nbt) {
        this.item = item;
        this.definition = definition;
        this.nbt = nbt;
    }

    public static ToolStack from(Item item, ToolDefinition definition, CompoundTag nbt) {
        return new ToolStack(item, definition, nbt);
    }

    @Override
    public Item getItem() {
        return this.item;
    }

    @Override
    public ToolDefinition getDefinition() {
        return this.definition;
    }

    protected CompoundTag getNbt() {
        return this.nbt;
    }
}

