/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.materials.IMaterialRegistry;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.tools.definition.PartRequirement;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.ToolDefinitionData;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.MaterialIdNBT;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public final class ToolBuildHandler {
    private static final MaterialId RENDER_MATERIAL = new MaterialId("tconstruct", "ui_render");
    private static final List<MaterialVariantId> RENDER_MATERIALS = Arrays.asList(MaterialVariantId.create(RENDER_MATERIAL, "head"), MaterialVariantId.create(RENDER_MATERIAL, "handle"), MaterialVariantId.create(RENDER_MATERIAL, "extra"), MaterialVariantId.create(RENDER_MATERIAL, "large"), MaterialVariantId.create(RENDER_MATERIAL, "extra_large"));

    private ToolBuildHandler() {
    }

    public static ItemStack buildItemFromMaterials(IModifiable tool, MaterialNBT materials) {
        return ToolStack.createTool(tool.m_5456_(), tool.getToolDefinition(), materials).createStack();
    }

    public static MaterialVariantId getRenderMaterial(int index) {
        return RENDER_MATERIALS.get(index % RENDER_MATERIALS.size());
    }

    public static ItemStack buildToolForRendering(Item item, ToolDefinition definition) {
        ItemStack stack = new ItemStack((ItemLike)item);
        if (definition.isMultipart()) {
            stack = new MaterialIdNBT(RENDER_MATERIALS).updateStack(stack);
        }
        stack.m_41784_().m_128379_("tic_display", true);
        return stack;
    }

    public static MaterialNBT randomMaterials(ToolDefinitionData data, int maxTier, boolean allowHidden) {
        List<PartRequirement> requirements = data.getParts();
        Map materialChoices = requirements.stream().map(PartRequirement::getStatType).distinct().collect(Collectors.toMap(Function.identity(), t -> new ArrayList()));
        IMaterialRegistry registry = MaterialRegistry.getInstance();
        registry.getAllMaterials().stream().filter(mat -> (allowHidden || !mat.isHidden()) && mat.getTier() <= maxTier).forEach(mat -> {
            for (IMaterialStats stats : registry.getAllStats(mat.getIdentifier())) {
                List list = (List)materialChoices.get((Object)stats.getIdentifier());
                if (list == null) continue;
                list.add(mat);
            }
        });
        MaterialNBT.Builder builder = MaterialNBT.builder();
        for (PartRequirement requirement : requirements) {
            List choices = materialChoices.get((Object)requirement.getStatType());
            if (choices == null || choices.isEmpty()) {
                builder.add(MaterialVariant.UNKNOWN);
                TConstruct.LOG.error("Failed to find a {} material of type {} below tier {}", (Object)(allowHidden ? "non-hidden " : ""), (Object)requirement.getStatType(), (Object)maxTier);
                continue;
            }
            builder.add((IMaterial)choices.get(TConstruct.RANDOM.nextInt(choices.size())));
        }
        return builder.build();
    }

    public static void addDefaultSubItems(IModifiable item, List<ItemStack> itemList) {
        block3: {
            IMaterial material2;
            MaterialId materialId;
            block4: {
                boolean isMultipart;
                block2: {
                    ToolDefinition definition = item.getToolDefinition();
                    isMultipart = definition.isMultipart();
                    if (definition.isDataLoaded() && (!isMultipart || MaterialRegistry.isFullyLoaded())) break block2;
                    itemList.add(new ItemStack((ItemLike)item));
                    break block3;
                }
                if (isMultipart) break block4;
                itemList.add(ToolBuildHandler.buildItemFromMaterials(item, MaterialNBT.EMPTY));
                break block3;
            }
            String showOnlyId = (String)Config.COMMON.showOnlyToolMaterial.get();
            boolean added = false;
            if (!showOnlyId.isEmpty() && (materialId = MaterialId.tryParse(showOnlyId)) != null && (material2 = MaterialRegistry.getMaterial(materialId)) != IMaterial.UNKNOWN && ToolBuildHandler.addSubItem(item, itemList, material2)) {
                added = true;
            }
            if (added) break block3;
            for (IMaterial material2 : MaterialRegistry.getInstance().getVisibleMaterials()) {
                if (ToolBuildHandler.addSubItem(item, itemList, material2) && !showOnlyId.isEmpty()) break;
            }
        }
    }

    private static boolean addSubItem(IModifiable item, List<ItemStack> items, IMaterial material) {
        List<PartRequirement> required = item.getToolDefinition().getData().getParts();
        MaterialNBT.Builder materials = MaterialNBT.builder();
        boolean useMaterial = false;
        for (PartRequirement requirement : required) {
            if (requirement.canUseMaterial(material.getIdentifier())) {
                materials.add(material);
                useMaterial = true;
                continue;
            }
            materials.add(MaterialRegistry.firstWithStatType(requirement.getStatType()));
        }
        if (useMaterial) {
            items.add(ToolBuildHandler.buildItemFromMaterials(item, materials.build()));
            return true;
        }
        return false;
    }
}

