/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.module;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import io.netty.handler.codec.DecoderException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;

public interface IToolModule
extends GenericLoaderRegistry.IHaveLoader {
    public static final GenericLoaderRegistry<IToolModule> LOADER = new GenericLoaderRegistry("Tool Module", false);

    public static ModifierHookMap read(FriendlyByteBuf buffer) {
        int size = buffer.m_130242_();
        ModifierHookMap.Builder builder = ModifierHookMap.builder();
        for (int i = 0; i < size; ++i) {
            ResourceLocation hookName = buffer.m_130281_();
            ModifierHook<?> hook = ModifierHooks.getHook(hookName);
            if (hook == null) {
                throw new DecoderException("Unknown hook from network, this likely indicates a broken or outdated mod: " + hookName);
            }
            IToolModule module = (IToolModule)LOADER.decode(buffer);
            builder.addHookChecked(module, hook);
        }
        return builder.build();
    }

    public static void write(ModifierHookMap modules, FriendlyByteBuf buffer) {
        List<Map.Entry> entries = modules.getAllModules().entrySet().stream().filter(entry -> entry.getValue() instanceof IToolModule).toList();
        buffer.m_130130_(entries.size());
        for (Map.Entry entry2 : entries) {
            buffer.m_130085_(((ModifierHook)entry2.getKey()).getName());
            LOADER.encode(buffer, (GenericLoaderRegistry.IHaveLoader)((IToolModule)entry2.getValue()));
        }
    }

    public static enum Serializer implements JsonSerializer<ModifierHookMap>,
    JsonDeserializer<ModifierHookMap>
    {
        INSTANCE;


        public ModifierHookMap deserialize(JsonElement element, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject json = GsonHelper.m_13918_((JsonElement)element, (String)"modules");
            ModifierHookMap.Builder builder = ModifierHookMap.builder();
            for (Map.Entry entry : json.entrySet()) {
                String key = (String)entry.getKey();
                ResourceLocation hookName = ResourceLocation.m_135820_((String)key);
                if (hookName == null) {
                    throw new JsonSyntaxException("Invalid hook name " + key);
                }
                ModifierHook<?> hook = ModifierHooks.getHook(hookName);
                if (hook == null) {
                    throw new JsonSyntaxException("Unknown hook name " + hookName);
                }
                builder.addHookChecked(LOADER.convert((JsonElement)entry.getValue(), key), hook);
            }
            return builder.build();
        }

        public JsonElement serialize(ModifierHookMap src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            for (Map.Entry<ModifierHook<?>, Object> entry : src.getAllModules().entrySet()) {
                Object object = entry.getValue();
                if (!(object instanceof IToolModule)) continue;
                IToolModule module = (IToolModule)object;
                json.add(entry.getKey().getName().toString(), LOADER.serialize((GenericLoaderRegistry.IHaveLoader)module));
            }
            return json;
        }
    }
}

