/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.harvest;

import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.TierSortingRegistry;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.library.tools.definition.harvest.IHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class TagHarvestLogic
implements IHarvestLogic {
    protected static final LoadableField<TagKey<Block>, TagHarvestLogic> TAG_FIELD = Loadables.BLOCK_TAG.requiredField("effective", h -> h.tag);
    public static final RecordLoadable<TagHarvestLogic> LOADER = RecordLoadable.create(TAG_FIELD, TagHarvestLogic::new);
    protected final TagKey<Block> tag;

    @Override
    public boolean isEffective(IToolStackView tool, BlockState state) {
        return state.m_204336_(this.tag) && TierSortingRegistry.isCorrectTierForDrops((Tier)tool.getStats().get(ToolStats.HARVEST_TIER), (BlockState)state);
    }

    @Override
    public float getDestroySpeed(IToolStackView tool, BlockState state) {
        return state.m_204336_(this.tag) ? tool.getStats().get(ToolStats.MINING_SPEED).floatValue() : 1.0f;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends IHarvestLogic> getLoader() {
        return LOADER;
    }

    public TagHarvestLogic(TagKey<Block> tag) {
        this.tag = tag;
    }
}

