/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.harvest;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.block.BlockPredicate;
import slimeknights.tconstruct.library.tools.definition.harvest.TagHarvestLogic;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class ModifiedHarvestLogic
extends TagHarvestLogic {
    public static final RecordLoadable<ModifiedHarvestLogic> LOADER = RecordLoadable.create((RecordField)TAG_FIELD, (RecordField)SpeedModifier.LOADABLE.list(1).requiredField("modifiers", l -> l.speedModifiers), ModifiedHarvestLogic::new);
    private final List<SpeedModifier> speedModifiers;

    protected ModifiedHarvestLogic(TagKey<Block> tag, List<SpeedModifier> speedModifiers) {
        super(tag);
        this.speedModifiers = speedModifiers;
    }

    public static Builder builder(TagKey<Block> tag) {
        return new Builder(tag);
    }

    public RecordLoadable<ModifiedHarvestLogic> getLoader() {
        return LOADER;
    }

    @Override
    public float getDestroySpeed(IToolStackView tool, BlockState state) {
        float speed = super.getDestroySpeed(tool, state);
        for (SpeedModifier modifier : this.speedModifiers) {
            if (!modifier.predicate.matches((Object)state)) continue;
            return Math.max(1.0f, speed * modifier.modifier);
        }
        return speed;
    }

    public static class Builder {
        private final TagKey<Block> tag;
        private final ImmutableList.Builder<SpeedModifier> speedModifiers = ImmutableList.builder();

        public Builder addModifier(float modifier, IJsonPredicate<BlockState> predicate) {
            this.speedModifiers.add((Object)new SpeedModifier(modifier, predicate));
            return this;
        }

        public Builder tagModifier(TagKey<Block> tag, float modifier) {
            return this.addModifier(modifier, (IJsonPredicate<BlockState>)BlockPredicate.tag(tag));
        }

        public Builder notTagModifier(TagKey<Block> tag, float modifier) {
            return this.addModifier(modifier, (IJsonPredicate<BlockState>)BlockPredicate.tag(tag).inverted());
        }

        public Builder blockModifier(float modifier, Block ... blocks) {
            return this.addModifier(modifier, (IJsonPredicate<BlockState>)BlockPredicate.set((Block[])blocks));
        }

        public Builder notBlockModifier(float modifier, Block ... blocks) {
            return this.addModifier(modifier, (IJsonPredicate<BlockState>)BlockPredicate.set((Block[])blocks).inverted());
        }

        public ModifiedHarvestLogic build() {
            return new ModifiedHarvestLogic(this.tag, (List<SpeedModifier>)this.speedModifiers.build());
        }

        protected Builder(TagKey<Block> tag) {
            this.tag = tag;
        }
    }

    private record SpeedModifier(float modifier, IJsonPredicate<BlockState> predicate) {
        public static final RecordLoadable<SpeedModifier> LOADABLE = RecordLoadable.create((RecordField)FloatLoadable.ANY.requiredField("modifier", SpeedModifier::modifier), (RecordField)BlockPredicate.LOADER.requiredField("predicate", SpeedModifier::predicate), SpeedModifier::new);
    }
}

