/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.definition.aoe;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.tools.definition.aoe.IAreaOfEffectIterator;
import slimeknights.tconstruct.library.tools.definition.aoe.IBoxExpansion;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.tools.TinkerModifiers;

public record BoxAOEIterator(BoxSize base, List<BoxSize> expansions, IBoxExpansion direction) implements IAreaOfEffectIterator
{
    public static final RecordLoadable<BoxAOEIterator> LOADER = RecordLoadable.create((RecordField)BoxSize.LOADER.defaultField("bonus", (Object)BoxSize.ZERO, BoxAOEIterator::base), (RecordField)BoxSize.LOADER.list(0).defaultField("expansions", List.of(), BoxAOEIterator::expansions), (RecordField)IBoxExpansion.REGISTRY.requiredField("expansion_direction", BoxAOEIterator::direction), BoxAOEIterator::new);

    public static Builder builder(int width, int height, int depth) {
        return new Builder(new BoxSize(width, height, depth));
    }

    public RecordLoadable<BoxAOEIterator> getLoader() {
        return LOADER;
    }

    private BoxSize sizeFor(int level) {
        int size = this.expansions.size();
        if (level == 0 || size == 0) {
            return this.base;
        }
        int width = this.base.width;
        int height = this.base.height;
        int depth = this.base.depth;
        if (level >= size) {
            int cycles = level / size;
            for (BoxSize expansion : this.expansions) {
                width += expansion.width * cycles;
                height += expansion.height * cycles;
                depth += expansion.depth * cycles;
            }
        }
        int remainder = level % size;
        for (int i = 0; i < remainder; ++i) {
            BoxSize expansion;
            expansion = this.expansions.get(i);
            width += expansion.width;
            height += expansion.height;
            depth += expansion.depth;
        }
        return new BoxSize(width, height, depth);
    }

    @Override
    public Iterable<BlockPos> getBlocks(IToolStackView tool, ItemStack stack, Player player, BlockState state, Level world, BlockPos origin, Direction sideHit, IAreaOfEffectIterator.AOEMatchType matchType) {
        int expanded = tool.getModifierLevel(TinkerModifiers.expanded.getId());
        return BoxAOEIterator.calculate(tool, stack, world, player, origin, sideHit, this.sizeFor(expanded), this.direction, matchType);
    }

    public static Iterable<BlockPos> calculate(IToolStackView tool, ItemStack stack, Level world, Player player, BlockPos origin, Direction sideHit, BoxSize extraSize, IBoxExpansion expansionDirection, IAreaOfEffectIterator.AOEMatchType matchType) {
        if (extraSize.isZero()) {
            return Collections.emptyList();
        }
        IBoxExpansion.ExpansionDirections expansion = expansionDirection.getDirections(player, sideHit);
        Predicate<BlockPos> posPredicate = IAreaOfEffectIterator.defaultBlockPredicate(tool, stack, world, origin, matchType);
        return () -> new RectangleIterator(origin, expansion.width(), extraSize.width, expansion.height(), extraSize.height, expansion.traverseDown(), expansion.depth(), extraSize.depth, posPredicate);
    }

    private record BoxSize(int width, int height, int depth) {
        public static final BoxSize ZERO = new BoxSize(0, 0, 0);
        public static final RecordLoadable<BoxSize> LOADER = RecordLoadable.create((RecordField)IntLoadable.FROM_ZERO.defaultField("width", (Object)0, BoxSize::width), (RecordField)IntLoadable.FROM_ZERO.defaultField("height", (Object)0, BoxSize::height), (RecordField)IntLoadable.FROM_ZERO.defaultField("depth", (Object)0, BoxSize::depth), BoxSize::new);

        public boolean isZero() {
            return this.width == 0 && this.height == 0 && this.depth == 0;
        }
    }

    public static class Builder {
        private final BoxSize base;
        @Nonnull
        private IBoxExpansion direction = IBoxExpansion.SIDE_HIT;
        private final ImmutableList.Builder<BoxSize> expansions = ImmutableList.builder();

        public Builder addExpansion(int width, int height, int depth) {
            this.expansions.add((Object)new BoxSize(width, height, depth));
            return this;
        }

        public Builder addWidth(int width) {
            return this.addExpansion(width, 0, 0);
        }

        public Builder addHeight(int height) {
            return this.addExpansion(0, height, 0);
        }

        public Builder addDepth(int depth) {
            return this.addExpansion(0, 0, depth);
        }

        public BoxAOEIterator build() {
            return new BoxAOEIterator(this.base, (List<BoxSize>)this.expansions.build(), this.direction);
        }

        public Builder(BoxSize base) {
            this.base = base;
        }

        public Builder direction(@Nonnull IBoxExpansion direction) {
            if (direction == null) {
                throw new NullPointerException("direction is marked non-null but is null");
            }
            this.direction = direction;
            return this;
        }
    }

    public static class RectangleIterator
    extends AbstractIterator<BlockPos> {
        private final Direction widthDir;
        private final Direction heightDir;
        private final Direction depthDir;
        private final int maxWidth;
        private final int maxHeight;
        private final int maxDepth;
        private int currentWidth = 0;
        private int currentHeight = 0;
        private int currentDepth = 0;
        protected final BlockPos origin;
        protected final BlockPos.MutableBlockPos mutablePos;
        protected final Predicate<BlockPos> posPredicate;
        protected int lastX;
        protected int lastY;
        protected int lastZ;

        public RectangleIterator(BlockPos origin, Direction widthDir, int extraWidth, Direction heightDir, int extraHeight, boolean traverseDown, Direction depthDir, int extraDepth, Predicate<BlockPos> posPredicate) {
            this.origin = origin;
            this.widthDir = widthDir;
            this.heightDir = heightDir;
            this.depthDir = depthDir;
            this.maxWidth = extraWidth * 2;
            this.maxHeight = traverseDown ? extraHeight * 2 : extraHeight;
            this.maxDepth = extraDepth;
            this.mutablePos = new BlockPos.MutableBlockPos(origin.m_123341_(), origin.m_123342_(), origin.m_123343_());
            this.posPredicate = posPredicate;
            if (extraWidth > 0) {
                --this.currentWidth;
            } else if (extraHeight > 0) {
                --this.currentHeight;
            }
            this.mutablePos.m_122175_(widthDir, -extraWidth + this.currentWidth);
            if (traverseDown) {
                this.mutablePos.m_122175_(heightDir, -extraHeight + this.currentHeight);
            } else if (this.currentHeight != 0) {
                this.mutablePos.m_122175_(heightDir, this.currentHeight);
            }
            this.lastX = this.mutablePos.m_123341_();
            this.lastY = this.mutablePos.m_123342_();
            this.lastZ = this.mutablePos.m_123343_();
        }

        protected boolean incrementPosition() {
            if (this.currentWidth == this.maxWidth) {
                if (this.currentHeight == this.maxHeight) {
                    if (this.currentDepth == this.maxDepth) {
                        return false;
                    }
                    ++this.currentDepth;
                    this.mutablePos.m_122173_(this.depthDir);
                    this.currentHeight = 0;
                    this.mutablePos.m_122175_(this.heightDir, -this.maxHeight);
                } else {
                    ++this.currentHeight;
                    this.mutablePos.m_122173_(this.heightDir);
                }
                this.currentWidth = 0;
                this.mutablePos.m_122175_(this.widthDir, -this.maxWidth);
            } else {
                ++this.currentWidth;
                this.mutablePos.m_122173_(this.widthDir);
            }
            return true;
        }

        protected BlockPos computeNext() {
            this.mutablePos.m_122178_(this.lastX, this.lastY, this.lastZ);
            while (this.incrementPosition()) {
                if (this.mutablePos.equals((Object)this.origin) || !this.posPredicate.test((BlockPos)this.mutablePos)) continue;
                this.lastX = this.mutablePos.m_123341_();
                this.lastY = this.mutablePos.m_123342_();
                this.lastZ = this.mutablePos.m_123343_();
                return this.mutablePos;
            }
            return (BlockPos)this.endOfData();
        }
    }
}

