/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.melting;

import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.recipe.data.AbstractRecipeBuilder;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.melting.MaterialMeltingRecipe;

public class MaterialMeltingRecipeBuilder
extends AbstractRecipeBuilder<MaterialMeltingRecipeBuilder> {
    private final MaterialVariantId inputId;
    private final int temperature;
    private final FluidStack result;

    public static MaterialMeltingRecipeBuilder material(MaterialVariantId materialId, int temperature, FluidStack result) {
        if (temperature < 0) {
            throw new IllegalArgumentException("Invalid temperature " + temperature + ", must be 0 or greater");
        }
        return new MaterialMeltingRecipeBuilder(materialId, temperature, result);
    }

    public static MaterialMeltingRecipeBuilder material(MaterialVariantId materialId, FluidStack result) {
        return MaterialMeltingRecipeBuilder.material(materialId, result.getFluid().getFluidType().getTemperature(result) - 300, result);
    }

    public static MaterialMeltingRecipeBuilder material(MaterialId materialId, Fluid result, int amount) {
        return MaterialMeltingRecipeBuilder.material(materialId, new FluidStack(result, amount));
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        this.save(consumer, this.inputId.getId());
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        ResourceLocation advancementID = this.buildOptionalAdvancement(id, "melting");
        consumer.accept((FinishedRecipe)new AbstractRecipeBuilder.LoadableFinishedRecipe((AbstractRecipeBuilder)this, (Recipe)new MaterialMeltingRecipe(id, this.inputId, this.temperature, this.result), MaterialMeltingRecipe.LOADER, advancementID));
    }

    private MaterialMeltingRecipeBuilder(MaterialVariantId inputId, int temperature, FluidStack result) {
        this.inputId = inputId;
        this.temperature = temperature;
        this.result = result;
    }
}

