/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.recipe.ingredient.NestedIngredient;
import slimeknights.tconstruct.library.utils.JsonUtils;

public class NoContainerIngredient
extends NestedIngredient {
    public static final ResourceLocation ID = TConstruct.getResource("no_container");

    protected NoContainerIngredient(Ingredient nested) {
        super(nested);
    }

    @Override
    public boolean test(@Nullable ItemStack stack) {
        return stack != null && super.test(stack) && !stack.hasCraftingRemainingItem();
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    public JsonElement m_43942_() {
        JsonElement nestedElement = this.nested.m_43942_();
        if (this.nested.isVanilla() && nestedElement.isJsonObject()) {
            JsonObject nestedObject = nestedElement.getAsJsonObject();
            nestedObject.addProperty("type", ID.toString());
            return nestedObject;
        }
        JsonObject json = JsonUtils.withType(ID);
        json.add("match", this.nested.m_43942_());
        return json;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static NoContainerIngredient of(Ingredient ingredient) {
        return new NoContainerIngredient(ingredient);
    }

    public static NoContainerIngredient of(ItemLike ... items) {
        return NoContainerIngredient.of(Ingredient.m_43929_((ItemLike[])items));
    }

    public static NoContainerIngredient of(ItemStack ... stacks) {
        return NoContainerIngredient.of(Ingredient.m_43927_((ItemStack[])stacks));
    }

    public static NoContainerIngredient of(TagKey<Item> tag) {
        return NoContainerIngredient.of(Ingredient.m_204132_(tag));
    }

    public static enum Serializer implements IIngredientSerializer<NoContainerIngredient>
    {
        INSTANCE;


        public NoContainerIngredient parse(JsonObject json) {
            Ingredient ingredient = json.has("match") ? CraftingHelper.getIngredient((JsonElement)json.get("match")) : VanillaIngredientSerializer.INSTANCE.parse(json);
            return new NoContainerIngredient(ingredient);
        }

        public NoContainerIngredient parse(FriendlyByteBuf buffer) {
            return new NoContainerIngredient(Ingredient.m_43940_((FriendlyByteBuf)buffer));
        }

        public void write(FriendlyByteBuf buffer, NoContainerIngredient ingredient) {
            ingredient.nested.m_43923_(buffer);
        }
    }
}

