/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.ingredient.FluidIngredient;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

public class MaterialFluidRecipe
implements ICustomOutputRecipe<ICastingContainer> {
    public static final RecordLoadable<MaterialFluidRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)FluidIngredient.LOADABLE.requiredField("fluid", r -> r.fluid), (RecordField)IntLoadable.FROM_ZERO.requiredField("temperature", r -> r.temperature), (RecordField)MaterialVariantId.LOADABLE.nullableField("input", r -> r.input != null ? r.input.getVariant() : null), (RecordField)MaterialVariantId.LOADABLE.nullableField("output", r -> r.output.getVariant()), MaterialFluidRecipe::new);
    private final ResourceLocation id;
    private final FluidIngredient fluid;
    private final int temperature;
    @Nullable
    private final MaterialVariant input;
    private final MaterialVariant output;

    public MaterialFluidRecipe(ResourceLocation id, FluidIngredient fluid, int temperature, @Nullable MaterialVariantId inputId, MaterialVariantId outputId) {
        this.id = id;
        this.fluid = fluid;
        this.temperature = temperature;
        this.input = inputId == null ? null : MaterialVariant.of(inputId);
        this.output = MaterialVariant.of(outputId);
        MaterialCastingLookup.registerFluid(this);
    }

    public boolean matches(ICastingContainer inv) {
        if (this.output.isUnknown() || !this.fluid.test(inv.getFluid())) {
            return false;
        }
        if (this.input != null) {
            if (this.input.isUnknown()) {
                return false;
            }
            return this.input.matchesVariant(inv.getStack());
        }
        return true;
    }

    public int getFluidAmount(Fluid fluid) {
        return this.fluid.getAmount(fluid);
    }

    public List<FluidStack> getFluids() {
        return this.fluid.getFluids();
    }

    public final boolean matches(ICastingContainer inv, Level worldIn) {
        return this.matches(inv);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerSmeltery.materialFluidRecipe.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TinkerRecipeTypes.DATA.get();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public int getTemperature() {
        return this.temperature;
    }

    @Nullable
    public MaterialVariant getInput() {
        return this.input;
    }

    public MaterialVariant getOutput() {
        return this.output;
    }
}

