/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.casting.material;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.IMultiRecipe;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.mantle.recipe.helper.TypeAwareRecipeSerializer;
import slimeknights.tconstruct.library.json.TinkerLoadables;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.recipe.casting.AbstractCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.DisplayCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.ICastingContainer;
import slimeknights.tconstruct.library.recipe.casting.ICastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.IDisplayableCastingRecipe;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialCastingLookup;
import slimeknights.tconstruct.library.recipe.casting.material.MaterialFluidRecipe;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;

public class MaterialCastingRecipe
extends AbstractCastingRecipe
implements IMultiRecipe<IDisplayableCastingRecipe> {
    protected static final LoadableField<Integer, MaterialCastingRecipe> ITEM_COST_FIELD = IntLoadable.FROM_ONE.requiredField("item_cost", r -> r.itemCost);
    protected static final LoadableField<IMaterialItem, MaterialCastingRecipe> RESULT_FIELD = TinkerLoadables.MATERIAL_ITEM.requiredField("result", r -> r.result);
    public static final RecordLoadable<MaterialCastingRecipe> LOADER = RecordLoadable.create((RecordField)LoadableRecipeSerializer.TYPED_SERIALIZER.requiredField(), (RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)CAST_FIELD, ITEM_COST_FIELD, RESULT_FIELD, (RecordField)CAST_CONSUMED_FIELD, (RecordField)SWITCH_SLOTS_FIELD, MaterialCastingRecipe::new);
    private final RecipeSerializer<?> serializer;
    protected final int itemCost;
    protected final IMaterialItem result;
    protected Optional<MaterialFluidRecipe> cachedFluidRecipe = Optional.empty();
    protected List<IDisplayableCastingRecipe> multiRecipes;

    public MaterialCastingRecipe(TypeAwareRecipeSerializer<?> serializer, ResourceLocation id, String group, Ingredient cast, int itemCost, IMaterialItem result, boolean consumed, boolean switchSlots) {
        super(serializer.getType(), id, group, cast, consumed, switchSlots);
        this.serializer = serializer;
        this.itemCost = itemCost;
        this.result = result;
        MaterialCastingLookup.registerItemCost(result, itemCost);
    }

    protected Optional<MaterialFluidRecipe> getMaterialFluid(ICastingContainer inv) {
        return MaterialCastingLookup.getCastingFluid(inv);
    }

    protected Optional<MaterialFluidRecipe> getCachedMaterialFluid(ICastingContainer inv) {
        Optional<MaterialFluidRecipe> fluidRecipe = this.cachedFluidRecipe;
        if (fluidRecipe.filter(recipe -> recipe.matches(inv)).isEmpty() && (fluidRecipe = this.getMaterialFluid(inv)).isPresent()) {
            this.cachedFluidRecipe = fluidRecipe;
        }
        return fluidRecipe;
    }

    public boolean matches(ICastingContainer inv, Level worldIn) {
        if (!this.getCast().test(inv.getStack())) {
            return false;
        }
        return this.getCachedMaterialFluid(inv).filter(recipe -> this.result.canUseMaterial(recipe.getOutput().getId())).isPresent();
    }

    @Override
    public int getCoolingTime(ICastingContainer inv) {
        return this.getCachedMaterialFluid(inv).map(recipe -> ICastingRecipe.calcCoolingTime(recipe.getTemperature(), recipe.getFluidAmount(inv.getFluid()) * this.itemCost)).orElse(1);
    }

    @Override
    public int getFluidAmount(ICastingContainer inv) {
        return this.getCachedMaterialFluid(inv).map(recipe -> recipe.getFluidAmount(inv.getFluid())).orElse(1) * this.itemCost;
    }

    @Override
    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)this.result);
    }

    public ItemStack assemble(ICastingContainer inv) {
        MaterialVariant material = this.getCachedMaterialFluid(inv).map(MaterialFluidRecipe::getOutput).orElse(MaterialVariant.UNKNOWN);
        return this.result.withMaterial(material.getVariant());
    }

    protected List<FluidStack> resizeFluids(List<FluidStack> fluids) {
        if (this.itemCost != 1) {
            return fluids.stream().map(fluid -> new FluidStack(fluid, fluid.getAmount() * this.itemCost)).collect(Collectors.toList());
        }
        return fluids;
    }

    public List<IDisplayableCastingRecipe> getRecipes() {
        if (this.multiRecipes == null) {
            RecipeType<?> type = this.m_6671_();
            List<ItemStack> castItems = Arrays.asList(this.getCast().m_43908_());
            this.multiRecipes = MaterialCastingLookup.getAllCastingFluids().stream().filter(recipe -> {
                MaterialVariant output = recipe.getOutput();
                return !output.isUnknown() && !output.get().isHidden() && this.result.canUseMaterial(output.getId());
            }).map(recipe -> {
                List<FluidStack> fluids = this.resizeFluids(recipe.getFluids());
                int fluidAmount = fluids.stream().mapToInt(FluidStack::getAmount).max().orElse(0);
                return new DisplayCastingRecipe(type, castItems, fluids, this.result.withMaterial(recipe.getOutput().getVariant()), ICastingRecipe.calcCoolingTime(recipe.getTemperature(), this.itemCost * fluidAmount), this.isConsumed());
            }).collect(Collectors.toList());
        }
        return this.multiRecipes;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }
}

