/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.unserializable;

import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.EquipmentChangeModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierHookProvider;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public record ArmorStatModule(TinkerDataCapability.TinkerDataKey<Float> key, float scale, boolean allowBroken) implements ModifierHookProvider,
EquipmentChangeModifierHook
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = ModifierModule.defaultHooks(TinkerHooks.EQUIPMENT_CHANGE);

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    @Override
    public void onEquip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        ArmorStatModule.addStatIfArmor(tool, context, this.key, modifier.getEffectiveLevel() * this.scale, this.allowBroken);
    }

    @Override
    public void onUnequip(IToolStackView tool, ModifierEntry modifier, EquipmentChangeContext context) {
        ArmorStatModule.addStatIfArmor(tool, context, this.key, -modifier.getEffectiveLevel() * this.scale, this.allowBroken);
    }

    public static void addStat(EquipmentChangeContext context, TinkerDataCapability.TinkerDataKey<Float> key, float amount) {
        context.getTinkerData().ifPresent(data -> {
            float totalLevels = data.get(key, Float.valueOf(0.0f)).floatValue() + amount;
            if (totalLevels <= 0.005f) {
                data.remove(key);
            } else {
                data.put(key, Float.valueOf(totalLevels));
            }
        });
    }

    public static void addStatIfArmor(IToolStackView tool, EquipmentChangeContext context, TinkerDataCapability.TinkerDataKey<Float> key, float amount, boolean allowBroken) {
        if (ModifierUtil.validArmorSlot(tool, context.getChangedSlot()) && (!tool.isBroken() || allowBroken)) {
            ArmorStatModule.addStat(context, key, amount);
        }
    }

    public static float getStat(LivingEntity living, TinkerDataCapability.TinkerDataKey<Float> key) {
        return living.getCapability(TinkerDataCapability.CAPABILITY).resolve().map(data -> (Float)data.get(key)).orElse(Float.valueOf(0.0f)).floatValue();
    }
}

