/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.fluid;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.primitive.BooleanLoadable;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.VolatileDataModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class TankCapacityModule
implements ModifierModule,
VolatileDataModifierHook {
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = List.of(TinkerHooks.VOLATILE_DATA);
    public static final ResourceLocation DEFAULT_CAPACITY_KEY = TConstruct.getResource("tank_capacity");
    protected static final LoadableField<ResourceLocation, TankCapacityModule> CAPACITY_KEY_FIELD = Loadables.RESOURCE_LOCATION.defaultField("capacity_key", (Object)DEFAULT_CAPACITY_KEY, TankCapacityModule::getCapacityKey);
    protected static final LoadableField<Integer, TankCapacityModule> CAPACITY_FIELD = IntLoadable.FROM_ZERO.requiredField("capacity", TankCapacityModule::getCapacity);
    protected static final LoadableField<Boolean, TankCapacityModule> SCALE_CAPACITY_FIELD = BooleanLoadable.INSTANCE.requiredField("scale_capacity", TankCapacityModule::isScaleCapacity);
    public static final RecordLoadable<TankCapacityModule> LOADER = RecordLoadable.create(CAPACITY_KEY_FIELD, CAPACITY_FIELD, SCALE_CAPACITY_FIELD, TankCapacityModule::new);
    private final ResourceLocation capacityKey;
    private final int capacity;
    private final boolean scaleCapacity;

    public TankCapacityModule(int capacity, boolean scaleCapacity) {
        this(DEFAULT_CAPACITY_KEY, capacity, scaleCapacity);
    }

    public int getCapacity(IToolStackView tool) {
        return tool.getVolatileData().getInt(this.getCapacityKey());
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, ModifierEntry modifier, ModDataNBT volatileData) {
        ResourceLocation key = this.getCapacityKey();
        volatileData.putInt(key, this.capacity * modifier.getLevel() + volatileData.getInt(key));
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public ResourceLocation getCapacityKey() {
        return this.capacityKey;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isScaleCapacity() {
        return this.scaleCapacity;
    }

    public TankCapacityModule(ResourceLocation capacityKey, int capacity, boolean scaleCapacity) {
        this.capacityKey = capacityKey;
        this.capacity = capacity;
        this.scaleCapacity = scaleCapacity;
    }
}

