/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.combat;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.entity.LivingEntityPredicate;
import slimeknights.mantle.data.registry.GenericLoaderRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.json.RandomLevelingValue;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHook;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.armor.OnAttackedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModuleCondition;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public record MobEffectModule(IJsonPredicate<LivingEntity> target, MobEffect effect, RandomLevelingValue level, RandomLevelingValue time, ModifierModuleCondition condition) implements OnAttackedModifierHook,
MeleeHitModifierHook,
ProjectileHitModifierHook,
ModifierModule,
ModifierModuleCondition.ConditionalModifierModule
{
    private static final List<ModifierHook<?>> DEFAULT_HOOKS = ModifierModule.defaultHooks(TinkerHooks.ON_ATTACKED, TinkerHooks.MELEE_HIT, TinkerHooks.PROJECTILE_HIT);
    public static final RecordLoadable<MobEffectModule> LOADER = RecordLoadable.create((RecordField)LivingEntityPredicate.LOADER.defaultField("target", MobEffectModule::target), (RecordField)Loadables.MOB_EFFECT.requiredField("effect", MobEffectModule::effect), (RecordField)RandomLevelingValue.LOADABLE.requiredField("level", MobEffectModule::level), (RecordField)RandomLevelingValue.LOADABLE.requiredField("time", MobEffectModule::time), ModifierModuleCondition.FIELD, MobEffectModule::new);

    public static Builder builder(MobEffect effect) {
        return new Builder(effect);
    }

    private void applyEffect(@Nullable LivingEntity target, float scaledLevel) {
        if (target == null || !this.target.matches((Object)target)) {
            return;
        }
        int level = Math.round(this.level.computeValue(scaledLevel)) - 1;
        if (level < 0) {
            return;
        }
        float duration = this.time.computeValue(scaledLevel);
        if (duration > 0.0f) {
            target.m_7292_(new MobEffectInstance(this.effect, (int)duration, level));
        }
    }

    @Override
    public void onAttacked(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        Entity attacker = source.m_7639_();
        if (isDirectDamage && attacker instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)attacker;
            float scaledLevel = modifier.getEffectiveLevel();
            if (TConstruct.RANDOM.nextFloat() < scaledLevel * 0.25f) {
                this.applyEffect(living, scaledLevel);
                ToolDamageUtil.damageAnimated(tool, 1, context.getEntity(), slotType);
            }
        }
    }

    @Override
    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        this.applyEffect(context.getLivingTarget(), modifier.getEffectiveLevel());
    }

    @Override
    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        this.applyEffect(target, modifier.getEffectiveLevel());
        return false;
    }

    @Override
    public List<ModifierHook<?>> getDefaultHooks() {
        return DEFAULT_HOOKS;
    }

    public GenericLoaderRegistry.IGenericLoader<? extends ModifierModule> getLoader() {
        return LOADER;
    }

    public static class Builder
    extends ModifierModuleCondition.Builder<Builder> {
        private final MobEffect effect;
        private IJsonPredicate<LivingEntity> target = LivingEntityPredicate.ANY;
        private RandomLevelingValue level = RandomLevelingValue.flat(1.0f);
        private RandomLevelingValue time = RandomLevelingValue.flat(0.0f);

        public MobEffectModule build() {
            return new MobEffectModule(this.target, this.effect, this.level, this.time, this.condition);
        }

        private Builder(MobEffect effect) {
            this.effect = effect;
        }

        public Builder target(IJsonPredicate<LivingEntity> target) {
            this.target = target;
            return this;
        }

        public Builder level(RandomLevelingValue level) {
            this.level = level;
            return this;
        }

        public Builder time(RandomLevelingValue time) {
            this.time = time;
            return this;
        }
    }
}

